// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_MESSAGE_H
#define _GSTREAMERMM_MESSAGE_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstmessage.h>
#include <gstreamermm/wrap.h>
#include <gstreamermm/format.h>
#include <gstreamermm/clock.h>
#include <gstreamermm/enums.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstMessage GstMessage;
typedef struct _GstMessageClass GstMessageClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class Message_Class; } // namespace Gst
namespace Gst
{

/** @addtogroup gstreamermmEnums Enums and Flags */

/**
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%MessageType operator|(MessageType, MessageType)</tt><br>
 * <tt>%MessageType operator&(MessageType, MessageType)</tt><br>
 * <tt>%MessageType operator^(MessageType, MessageType)</tt><br>
 * <tt>%MessageType operator~(MessageType)</tt><br>
 * <tt>%MessageType& operator|=(MessageType&, MessageType)</tt><br>
 * <tt>%MessageType& operator&=(MessageType&, MessageType)</tt><br>
 * <tt>%MessageType& operator^=(MessageType&, MessageType)</tt><br>
 */
enum MessageType
{
  MESSAGE_UNKNOWN = 0,
  MESSAGE_EOS = 1 << 0,
  MESSAGE_ERROR = 1 << 1,
  MESSAGE_WARNING = 1 << 2,
  MESSAGE_INFO = 1 << 3,
  MESSAGE_TAG = 1 << 4,
  MESSAGE_BUFFERING = 1 << 5,
  MESSAGE_STATE_CHANGED = 1 << 6,
  MESSAGE_STATE_DIRTY = 1 << 7,
  MESSAGE_STEP_DONE = 1 << 8,
  MESSAGE_CLOCK_PROVIDE = 1 << 9,
  MESSAGE_CLOCK_LOST = 1 << 10,
  MESSAGE_NEW_CLOCK = 1 << 11,
  MESSAGE_STRUCTURE_CHANGE = 1 << 12,
  MESSAGE_STREAM_STATUS = 1 << 13,
  MESSAGE_APPLICATION = 1 << 14,
  MESSAGE_ELEMENT = 1 << 15,
  MESSAGE_SEGMENT_START = 1 << 16,
  MESSAGE_SEGMENT_DONE = 1 << 17,
  MESSAGE_DURATION = 1 << 18,
  MESSAGE_LATENCY = 1 << 19,
  MESSAGE_ASYNC_START = 1 << 20,
  MESSAGE_ASYNC_DONE = 1 << 21,
  MESSAGE_ANY = ~0
};

/** @ingroup gstreamermmEnums */
inline MessageType operator|(MessageType lhs, MessageType rhs)
  { return static_cast<MessageType>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MessageType operator&(MessageType lhs, MessageType rhs)
  { return static_cast<MessageType>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MessageType operator^(MessageType lhs, MessageType rhs)
  { return static_cast<MessageType>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MessageType operator~(MessageType flags)
  { return static_cast<MessageType>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline MessageType& operator|=(MessageType& lhs, MessageType rhs)
  { return (lhs = static_cast<MessageType>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline MessageType& operator&=(MessageType& lhs, MessageType rhs)
  { return (lhs = static_cast<MessageType>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline MessageType& operator^=(MessageType& lhs, MessageType rhs)
  { return (lhs = static_cast<MessageType>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::MessageType> : public Glib::Value_Flags<Gst::MessageType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{


Glib::ustring get_name(MessageType t);
Glib::QueryQuark get_quark(MessageType t);

class Structure;
class TagList;

/** Gst::Message — Lightweight objects to signal the application of pipeline
 * events.
 * Messages are implemented as a subclass of Gst::MiniObject with a generic
 * Gst::Structure as the content. This allows for writing custom messages
 * without requiring an API change while allowing a wide range of different
 * types of messages.
 *
 * Messages are posted by objects in the pipeline and are passed to the
 * application using the Gst::Bus.
 *
 * The basic use pattern of posting a message on a Gst::Bus is as follows: 
 * @code
 * bus->post(Gst::MessageEos::create(my_element));
 * @endcode
 */

class Message : public Gst::MiniObject
{
protected:
 
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Message CppObjectType;
  typedef Message_Class CppClassType;
  typedef GstMessage BaseObjectType;
  typedef GstMessageClass BaseClassType;

private:  friend class Message_Class;
  static CppClassType message_class_;

private:
  // noncopyable
  Message(const Message&);
  Message& operator=(const Message&);

protected:
  explicit Message(GstMessage* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Message();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GstMiniObject.
  GstMessage*       gobj()       { return reinterpret_cast<GstMessage*>(gobject_); }

  ///Provides access to the underlying C GstMiniObject.
  const GstMessage* gobj() const { return reinterpret_cast<GstMessage*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstMessage* gobj_copy();

private:

 
public:
  /** Get the structure of a message.
   * @return The Gst::Structure of the message (unmodifiable)
   */
  const Structure* get_structure();

public:
  /** Wrap a GstMessage* in a C++ instance, creating an instance of a
   *  derived Gst::Message.  Gst::wrap() would just create a Gst::Message
   *  (rather than a derived one) because the derived Gst::Message classes
   *  do not correspond to GType types in the GStreamer API.
   */
  static Glib::RefPtr<Message> wrap(GstMessage* message, bool take_copy=false);

   MessageType get_message_type() const;
    ClockTime get_timestamp() const;
    Glib::RefPtr<Gst::Object> get_source();
  Glib::RefPtr<const Gst::Object> get_source() const;
 

public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

class MessageApplication : public Message
{
public:
  explicit MessageApplication(GstMessage *message);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, Structure& structure);
};

class MessageClockProvide : public Message
{
public:
  explicit MessageClockProvide(GstMessage *message);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, const Glib::RefPtr<Clock>& clock, bool ready);
  void parse(Glib::RefPtr<Clock>& clock, bool& ready);
};

class MessageClockLost : public Message
{
public:
  explicit MessageClockLost(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, const Glib::RefPtr<Clock>& clock);
  void parse(Glib::RefPtr<Clock>& clock);
};

class MessageCustom : public Message
{
public:
  explicit MessageCustom(GstMessage* castitem);

  static Glib::RefPtr<Message> create(MessageType type, const Glib::RefPtr<Object>& src, Structure& structure);
};

class MessageElement : public Message
{
public:
  explicit MessageElement(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, Structure& structure);
};

class MessageEos : public Message
{
public:
  explicit MessageEos(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src);
};

class MessageError : public Message
{
public:
  explicit MessageError(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, Glib::Error& error, const std::string& debug);
  void parse(Glib::Error& error, std::string& debug);
  void parse(Glib::Error& error);
};

class MessageInfo : public Message
{
public:
  explicit MessageInfo(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, Glib::Error& error, const std::string& debug);
  void parse(Glib::Error& error, std::string& debug);
};

class MessageNewClock: public Message
{
public:
  explicit MessageNewClock(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, const Glib::RefPtr<Clock>& clock);
  void parse(Glib::RefPtr<Clock>& clock);
};

class MessageSegmentDone : public Message
{
public:
  explicit MessageSegmentDone(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, Format format, gint64 position);
  void parse(Format& format, gint64& position);
};

class MessageSegmentStart : public Message
{
public:
  explicit MessageSegmentStart(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, Format format, gint64 position);
  void parse(Format& format, gint64& position);
};

class MessageStateChanged : public Message
{
public:
  explicit MessageStateChanged(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, State oldstate, State newstate, State pending);
  void parse(State& oldstate, State& newstate, State& pending);
};

class MessageTag : public Message
{
public:
  explicit MessageTag(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, TagList& taglist);
  void parse(TagList& taglist);
};

class MessageBuffering : public Message
{
public:
  explicit MessageBuffering(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, int percent);
  void parse(int& percent);
};

class MessageWarning : public Message
{
public:
  explicit MessageWarning(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, Glib::Error& error, const std::string& debug);
  void parse(Glib::Error& error, std::string& debug);
};

class MessageDuration : public Message
{
public:
  explicit MessageDuration(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, Format format, gint64 position);
  void parse(Format& format, gint64& position);
};

class MessageStateDirty : public Message
{
public:
  explicit MessageStateDirty(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src);
};

class MessageAsyncStart : public Message
{
public:
  explicit MessageAsyncStart(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src, bool new_base_time);
  void parse(bool& new_base_time);
};

class MessageAsyncDone : public Message
{
public:
  explicit MessageAsyncDone(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src);
};

class MessageLatency : public Message
{
public:
  explicit MessageLatency(GstMessage* castitem);

  static Glib::RefPtr<Message> create(const Glib::RefPtr<Object>& src);
};

} //namespace Gst


namespace Gst
{
  /** @relates Gst::Message
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gst::Message> wrap(GstMessage* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_MESSAGE_H */

