// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gstreamermm/structure.h>
#include <gstreamermm/private/structure_p.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstvalue.h> //Must be included before gststructure.h
#include <gst/gststructure.h>
#include <gstreamermm/value.h>
#include <gstreamermm/miniobject.h>

static gboolean
Structure_Foreach_gstreamermm_callback(GQuark field_id, const GValue *value, void* data)
{
  Glib::ValueBase val_base;
  val_base.init(value);

  Gst::Structure::SlotForeach* slot = static_cast<Gst::Structure::SlotForeach*>(data);

  bool result = (*slot)(Glib::QueryQuark(field_id), val_base);
  delete slot;
  return result;
}

static gboolean
Structure_Map_gstreamermm_callback(GQuark field_id, GValue *value, void* data)
{
  Glib::ValueBase val_base;
  val_base.init(value);

  Gst::Structure::SlotMap* slot = static_cast<Gst::Structure::SlotMap*>(data);

  bool result = (*slot)(Glib::QueryQuark(field_id), val_base);
  delete slot;
  return result;
}

namespace Gst
{

Structure::Structure(const Glib::ustring& name)
{
  gobject_ = gst_structure_empty_new(name.c_str());
}

void
Structure::get_field(const Glib::ustring& name, Glib::ValueBase& value) const
{
  value.init(gst_structure_get_value(gobj(), name.c_str()));
}

Structure&
Structure::set_field(const Glib::ustring& fieldname, const Glib::ValueBase& value)
{
  GType type = G_VALUE_TYPE(value.gobj());

  if (type == Glib::Value<Fourcc>::value_type())
  {
     const Glib::Value<Fourcc>* fourcc =
        static_cast< const Glib::Value<Fourcc>* >(&value);

     gst_structure_set(gobj(), fieldname.c_str(), GST_TYPE_FOURCC,
        fourcc->get().get_fourcc(), NULL);
  }
  else if (type == Glib::Value<IntRange>::value_type())
  {
     const Glib::Value<IntRange>* range =
        static_cast< const Glib::Value<IntRange>* >(&value);

     gst_structure_set(gobj(), fieldname.c_str(), GST_TYPE_INT_RANGE,
        range->get().min, range->get().max, NULL);
  }
  else if (type == Glib::Value<DoubleRange>::value_type())
  {
     const Glib::Value<DoubleRange>* range =
        static_cast< const Glib::Value<DoubleRange>* >(&value);

     gst_structure_set(gobj(), fieldname.c_str(), GST_TYPE_DOUBLE_RANGE,
        range->get().min, range->get().max, NULL);
  }
  else if (type == Glib::Value<Fraction>::value_type())
  {
     const Glib::Value<Fraction>* fract =
        static_cast< const Glib::Value<Fraction>* >(&value);

     gst_structure_set(gobj(), fieldname.c_str(), GST_TYPE_FRACTION,
        fract->get().num, fract->get().denom, NULL);
  }
  else if (type == Glib::Value<FractionRange>::value_type())
  {
     const Glib::Value<FractionRange>* range =
        static_cast< const Glib::Value<FractionRange>* >(&value);

     gst_structure_set(gobj(), fieldname.c_str(), GST_TYPE_FRACTION_RANGE,
         range->get().min.num, range->get().min.denom, range->get().max.num,
             range->get().max.denom, NULL);
  }
  else if (type == Glib::Value<Glib::Date>::value_type())
  {
     const Glib::Value<Glib::Date>* date =
        static_cast< const Glib::Value<Glib::Date>* >(&value);

     gst_structure_set(gobj(), fieldname.c_str(), GST_TYPE_DATE,
         date->get().gobj(), NULL);
  }
  else if (type == Glib::Value<Structure>::value_type())
  {
     const Glib::Value<Structure>* obj =
        static_cast< const Glib::Value<Structure>* >(&value);

     gst_structure_set(gobj(), fieldname.c_str(), GST_TYPE_STRUCTURE,
        obj->get().gobj(), NULL);
  }
  else if (type == Glib::Value<MiniObject>::value_type())
  {
     const Glib::Value<MiniObject>* obj =
        static_cast< const Glib::Value<MiniObject>* >(&value);

     gst_structure_set(gobj(), fieldname.c_str(), GST_TYPE_MINI_OBJECT,
        obj->get().gobj(), NULL);
  }
  else 
    gst_structure_set_value(gobj(), fieldname.c_str(), value.gobj());

  return *this;
}

Structure&
Structure::remove_field(const Glib::ustring& fieldname)
{
  gst_structure_remove_field(gobj(), fieldname.c_str());
  return *this;
}

bool
Structure::get_boolean(const Glib::ustring& name, Glib::ValueBase& value) const
{
  bool result = gst_structure_has_field_typed(gobj(), name.c_str(), G_TYPE_BOOLEAN);

  if (result)
    value.init(gst_structure_get_value(gobj(), name.c_str()));

  return result;
}

bool
Structure::get_int(const Glib::ustring& name, Glib::ValueBase& value) const
{
  bool result = gst_structure_has_field_typed(gobj(), name.c_str(), G_TYPE_INT);

  if (result)
    value.init(gst_structure_get_value(gobj(), name.c_str()));

  return result;
}

bool
Structure::get_uint(const Glib::ustring& name, Glib::ValueBase& value) const
{
  bool result = gst_structure_has_field_typed(gobj(), name.c_str(), G_TYPE_UINT);

  if (result)
    value.init(gst_structure_get_value(gobj(), name.c_str()));

  return result;
}

bool
Structure::get_fourcc(const Glib::ustring& name, Glib::ValueBase& value) const
{
  bool result = gst_structure_has_field_typed(gobj(), name.c_str(), G_TYPE_UINT);

  if (result)
    value.init(gst_structure_get_value(gobj(), name.c_str()));

  return result;
}


bool
Structure::get_double(const Glib::ustring& name, Glib::ValueBase& value) const
{
  bool result = gst_structure_has_field_typed(gobj(), name.c_str(), G_TYPE_DOUBLE);

  if (result)
    value.init(gst_structure_get_value(gobj(), name.c_str()));

  return result;
}

bool
Structure::get_string(const Glib::ustring& name, Glib::ValueBase& value) const
{
  bool result = gst_structure_has_field_typed(gobj(), name.c_str(), G_TYPE_STRING);

  if (result)
    value.init(gst_structure_get_value(gobj(), name.c_str()));

  return result;
}

bool
Structure::get_date (const Glib::ustring& name, Glib::Date& date) const
{
  GDate *gdate = 0;
  const bool has = gst_structure_get_date(gobj(), name.c_str(), &gdate);
  date.set_julian(g_date_get_julian(gdate));
  return has;
}


bool
Structure::get_clock_time(const Glib::ustring& name, Glib::ValueBase& value) const
{
  bool result = gst_structure_has_field_typed(gobj(), name.c_str(), G_TYPE_UINT64);

  if (result)
    value.init(gst_structure_get_value(gobj(), name.c_str()));

  return result;
}


bool
Structure::get_enum(const Glib::ustring& name, GType enum_type, Glib::ValueBase& value) const
{
  bool result = gst_structure_has_field_typed(gobj(), name.c_str(), enum_type);

  if (result)
    value.init(gst_structure_get_value(gobj(), name.c_str()));

  return result;
}


bool
Structure::get_fraction(const Glib::ustring& name, Gst::Fraction& f) const
{
  return gst_structure_get_fraction(gobj(), name.c_str(), &f.num, &f.denom);
}

bool
Structure::foreach(const SlotForeach& slot)
{
  SlotForeach* slot_copy = new SlotForeach(slot);
  return gst_structure_foreach(gobj(), &Structure_Foreach_gstreamermm_callback, slot_copy);
}

bool
Structure::map_in_place(const SlotMap& slot)
{
  SlotMap* slot_copy = new SlotMap(slot);
  return gst_structure_map_in_place(gobj(), &Structure_Map_gstreamermm_callback, slot_copy);
}

Structure
Structure::create_from_string(const Glib::ustring& the_string)
{
  return Structure(gst_structure_from_string(the_string.c_str(), NULL)); 
}

} //namespace Gst

namespace
{
} // anonymous namespace


namespace Glib
{

Gst::Structure wrap(GstStructure* object, bool take_copy, bool destroy)
{
  return Gst::Structure(object, take_copy, destroy);
}

} // namespace Glib


namespace Gst
{


// static
GType Structure::get_type()
{
  return gst_structure_get_type();
}

Structure::Structure()
:
  gobject_ (0), // Allows creation of invalid wrapper, e.g. for output arguments to methods.
  destroy(false)  // destroy tells whether to free gobject when wrapper is destroyed
{}

Structure::Structure(const Structure& other)
:
  gobject_ (other.gobject_),  // Always use original object
  destroy(false)  // Do not delete gobject when wrapper is destroyed (let
                  // original wrapper do that)
{}

Structure::Structure(GstStructure* gobject, bool make_a_copy, bool destroy)
:
  // For this ncopy BoxedType wrapper, make_a_copy is false by default
  // and destroy is true.
  gobject_ ((make_a_copy && gobject) ? gst_structure_copy(gobject) : gobject),
  destroy(destroy) // Should wrapper destroy gobject when deleted?
{}

// operator=() DOES make copies of gobject.
Structure& Structure::operator=(const Structure& other)
{
  Structure temp (gobject_, true);
  swap(temp);
  return *this;
}

Structure::~Structure()
{
  if(destroy && gobject_)
    gst_structure_free(gobject_);
}

void Structure::swap(Structure& other)
{
  GstStructure *const temp = gobject_;
  gobject_ = other.gobject_;
  other.gobject_ = temp;

  bool const destroy_temp = destroy;
  destroy = other.destroy;
  other.destroy = destroy_temp;
}

GstStructure* Structure::gobj_copy() const
{
  return gst_structure_copy(gobject_);
}

//
void Structure::set_destroy(bool destroy)
{
  this->destroy = destroy;
}


Glib::ustring Structure::get_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gst_structure_get_name(const_cast<GstStructure*>(gobj())));
}

bool Structure::has_name(const Glib::ustring& name) const
{
  return gst_structure_has_name(const_cast<GstStructure*>(gobj()), name.c_str());
}

void Structure::set_name(const Glib::ustring& name)
{
gst_structure_set_name(gobj(), name.c_str()); 
}

Glib::QueryQuark Structure::get_name_id() const
{
  return Glib::QueryQuark(gst_structure_get_name_id(const_cast<GstStructure*>(gobj())));
}

void Structure::remove_all_fields()
{
gst_structure_remove_all_fields(gobj()); 
}

GType Structure::get_field_type(const Glib::ustring& fieldname) const
{
  return gst_structure_get_field_type(const_cast<GstStructure*>(gobj()), fieldname.c_str());
}

int Structure::size() const
{
  return gst_structure_n_fields(const_cast<GstStructure*>(gobj()));
}

bool Structure::has_field(const Glib::ustring& fieldname) const
{
  return gst_structure_has_field(const_cast<GstStructure*>(gobj()), fieldname.c_str());
}

bool Structure::has_field(const Glib::ustring& fieldname, GType type) const
{
  return gst_structure_has_field_typed(const_cast<GstStructure*>(gobj()), fieldname.c_str(), type);
}

Glib::ustring Structure::nth_field_name(guint index) const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gst_structure_nth_field_name(const_cast<GstStructure*>(gobj()), index));
}

Glib::ustring Structure::to_string() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gst_structure_to_string(const_cast<GstStructure*>(gobj())));
}


} // namespace Gst


