// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_BIN_H
#define _GSTREAMERMM_BIN_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/element.h>
#include <gstreamermm/childproxy.h>
#include <gstreamermm/pad.h>
#include <stdexcept> //Because add() throws std::runtime_error.


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstBin GstBin;
typedef struct _GstBinClass GstBinClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class Bin_Class; } // namespace Gst
namespace Gst
{

class Pad;

//TODO: Correct statements about iterators in class docs below:

/** Gst::Bin — Base class and element that can contain other elements.
 * Gst::Bin is an element that can contain other Gst::Element, allowing them to
 * be managed as a group. Pads from the child elements can be ghosted to the
 * bin, see Gst::GhostPad. This makes the bin look like any other elements and
 * enables creation of higher-level abstraction elements.
 *
 * A new Gst::Bin is created with create(). Use a Gst::Pipeline instead if you
 * want to create a toplevel bin because a normal bin doesn't have a bus or
 * handle clock distribution of its own.
 *
 * After the bin has been created you will typically add elements to it with
 * add(). You can remove elements with remove().
 *
 * An element can be retrieved from a bin with get_element(), using the
 * elements name. get_element_recurse_up() is mainly used for internal purposes
 * and will query the parent bins when the element is not found in the current
 * bin.
 *
 * An iterator of elements in a bin can be retrieved with iterate_elements().
 * Various other iterators exist to retrieve the elements in a bin.
 *
 * The element-added signal is fired whenever a new element is added to the
 * bin. Likewise the element-removed signal is fired whenever an element is
 * removed from the bin.
 *
 * Notes:
 *
 * A Gst::Bin internally intercepts every Gst::Message posted by its children
 * and implements the following default behaviour for each of them:
 *
 * - Gst::MESSAGE_EOS - This message is only posted by sinks in the PLAYING
 * state. If all sinks posted the EOS message, this bin will post and EOS
 * message upwards.
 *
 * - Gst::MESSAGE_SEGMENT_START - just collected and never forwarded upwards.
 * The messages are used to decide when all elements have completed playback of
 * their segment.
 *
 * - Gst::MESSAGE_SEGMENT_DONE - Is posted by Gst::Bin when all elements that
 * posted a SEGMENT_START have posted a SEGMENT_DONE.
 *
 * - Gst::MESSAGE_DURATION - Is posted by an element that detected a change in
 * the stream duration. The default bin behaviour is to clear any cached
 * duration values so that the next duration query will perform a full duration
 * recalculation. The duration change is posted to the application so that it
 * can refetch the new duration with a duration query.
 *
 * - Gst::MESSAGE_CLOCK_LOST - This message is posted by an element when it can
 * no longer provide a clock. The default bin behaviour is to check if the lost
 * clock was the one provided by the bin. If so and the bin is currently in the
 * PLAYING state, the message is forwarded to the bin parent. This message is
 * also generated when a clock provider is removed from the bin. If this
 * message is received by the application, it should PAUSE the pipeline and set
 * it back to PLAYING to force a new clock distribution.
 *
 * - Gst::MESSAGE_CLOCK_PROVIDE - This message is generated when an element can
 * provide a clock. This mostly happens when a new clock provider is added to
 * the bin. The default behaviour of the bin is to mark the currently selected
 * clock as dirty, which will perform a clock recalculation the next time the
 * bin is asked to provide a clock. This message is never sent tot the
 * application but is forwarded to the parent of the bin.
 *
 * - OTHERS - posted upwards.
 *
 * A Gst::Bin implements the following default behaviour for answering to a
 * Gst::Query:
 *
 * - Gst::QUERY_DURATION - If the query has been asked before with the same
 * format and the bin is a toplevel bin (ie. has no parent), use the cached
 * previous value. If no previous value was cached, the query is sent to all
 * sink elements in the bin and the MAXIMUM of all values is returned. If the
 * bin is a toplevel bin the value is cached. If no sinks are available in the
 * bin, the query fails.
 *
 * - Gst::QUERY_POSITION - The query is sent to all sink elements in the bin
 * and the MAXIMUM of all values is returned. If no sinks are available in the
 * bin, the query fails.
 *
 * - OTHERS - the query is forwarded to all sink elements, the result of the
 * first sink that answers the query successfully is returned. If no sink is in
 * the bin, the query fails.
 *
 * A Gst::Bin will by default forward any event sent to it to all sink
 * elements. If all the sinks return true, the bin will also return true, else
 * false is returned. If no sinks are in the bin, the event handler will return
 * true.
 *
 * Last reviewed on 2006-04-28 (0.10.6)
 */

class Bin
: public Element,
  public ChildProxy
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Bin CppObjectType;
  typedef Bin_Class CppClassType;
  typedef GstBin BaseObjectType;
  typedef GstBinClass BaseClassType;

private:  friend class Bin_Class;
  static CppClassType bin_class_;

private:
  // noncopyable
  Bin(const Bin&);
  Bin& operator=(const Bin&);

protected:
  explicit Bin(const Glib::ConstructParams& construct_params);
  explicit Bin(GstBin* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Bin();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstBin*       gobj()       { return reinterpret_cast<GstBin*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstBin* gobj() const { return reinterpret_cast<GstBin*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstBin* gobj_copy();

private:

  
protected:
  explicit Bin(const Glib::ustring& name);

public:
  /** Creates a new bin with the given name.
   *
   * @param name The name of the new bin.
   * @return A new Gst::Bin.
   */
  
  static Glib::RefPtr<Bin> create(const Glib::ustring& name);


  /** Adds the given element to the bin.
   * This sets the element's parent, and thus takes ownership of the element.
   * An element can only be added to one bin.
   *
   * If the element's pads are linked to other pads then the pads will be unlinked
   * before the element is added to the bin.
   *
   * MT safe.
   *
   * @param element The Gst::Element to add.
   * @return This Gst::Bin if successful, for chained calls to add().
   *
   * @throws std::runtime_error if the Bin does not want to accept the Element.
   */
  Glib::RefPtr<Bin> add(const Glib::RefPtr<Element>& element);

  /** Removes the element from the bin, unparenting it as well. Unparenting the
   * element means that the element will be dereferenced, so if the bin holds
   * the only reference to the element, the element will be freed in the
   * process of removing it from the bin.
   *
   * If the element's pads are linked to other pads, the pads will be unlinked
   * before the element is removed from the bin.
   *
   * MT safe.
   *
   * element the Gst::Element to remove
   * Returns this Gst::Bin if successful (for further removing if wanted), NULL
   * otherwise
   */
  Glib::RefPtr<Bin> remove(const Glib::RefPtr<Element>& element);

  //We could add a bool recurse_up = false parameter, 
  //but get_element() and get_element_recurse_up() seem different enough to be separate.
  //One recurses down and the other recurses up, so it's not just additional behaviour. 
  
  /** Gets the element with the given name from a bin. This
   * function recurses into child bins.
   * 
   * Returns: the Gst::Element with the given name, or <tt>0</tt>
   * @param name The element name to search for.
   * @return The Gst::Element with the given name, or <tt>0</tt>.
   */
  Glib::RefPtr<Element> get_element(const Glib::ustring& name);
  
  /** Gets the element with the given name from a bin. This
   * function recurses into child bins.
   * 
   * Returns: the Gst::Element with the given name, or <tt>0</tt>
   * @param name The element name to search for.
   * @return The Gst::Element with the given name, or <tt>0</tt>.
   */
  Glib::RefPtr<const Element> get_element(const Glib::ustring& name) const;

  
  /** Gets the element with the given name from this bin. If the
   * element is not found, a recursion is performed on the parent bin.
   * 
   * Returns: the Gst::Element with the given name, or <tt>0</tt>
   * @param name The element name to search for.
   * @return The Gst::Element with the given name, or <tt>0</tt>.
   */
  Glib::RefPtr<Element> get_element_recurse_up(const Glib::ustring& name);
  
  /** Gets the element with the given name from this bin. If the
   * element is not found, a recursion is performed on the parent bin.
   * 
   * Returns: the Gst::Element with the given name, or <tt>0</tt>
   * @param name The element name to search for.
   * @return The Gst::Element with the given name, or <tt>0</tt>.
   */
  Glib::RefPtr<const Element> get_element_recurse_up(const Glib::ustring& name) const;
 
  
  /** Looks for an element inside the bin that implements the given
   * interface. If such an element is found, it returns the element.
   * You can cast this element to the given interface afterwards.  If you want
   * all elements that implement the interface, use
   * iterate_all_by_interface(). This function recurses into child bins.
   * 
   * MT safe.  Caller owns returned reference.
   * @param iface The Type of an interface.
   * @return A Gst::Element inside the bin implementing the interface.
   */
  Glib::RefPtr<Element> get_element(GType interface);
  
  /** Looks for an element inside the bin that implements the given
   * interface. If such an element is found, it returns the element.
   * You can cast this element to the given interface afterwards.  If you want
   * all elements that implement the interface, use
   * iterate_all_by_interface(). This function recurses into child bins.
   * 
   * MT safe.  Caller owns returned reference.
   * @param iface The Type of an interface.
   * @return A Gst::Element inside the bin implementing the interface.
   */
  Glib::RefPtr<const Element> get_element(GType interface) const;

  
  /** Recursively looks for elements with an unlinked pad of the given
   * direction within the specified bin and returns an unlinked pad
   * if one is found, or <tt>0</tt> otherwise. If a pad is found, the caller
   * owns a reference to it and should use Gst::Object::unref() on the
   * pad when it is not needed any longer.
   * @param direction Whether to look for an unlinked source or sink pad.
   * @return Unlinked pad of the given direction, or <tt>0</tt>.
   * 
   * Since: 0.10.3
   * 
   * Deprecated: use find_unlinked_pad() instead.
   */
  Glib::RefPtr<Pad> find_unconnected_pad(PadDirection dir);
  
  /** Recursively looks for elements with an unlinked pad of the given
   * direction within the specified bin and returns an unlinked pad
   * if one is found, or <tt>0</tt> otherwise. If a pad is found, the caller
   * owns a reference to it and should use Gst::Object::unref() on the
   * pad when it is not needed any longer.
   * @param direction Whether to look for an unlinked source or sink pad.
   * @return Unlinked pad of the given direction, or <tt>0</tt>.
   * 
   * Since: 0.10.3
   * 
   * Deprecated: use find_unlinked_pad() instead.
   */
  Glib::RefPtr<const Pad> find_unconnected_pad(PadDirection dir) const;

/* TODO:
GstIterator*    gst_bin_iterate_elements	 (GstBin *bin);
GstIterator*    gst_bin_iterate_sorted		 (GstBin *bin);
GstIterator*    gst_bin_iterate_recurse		 (GstBin *bin);

GstIterator*	gst_bin_iterate_sinks		 (GstBin *bin);
GstIterator*	gst_bin_iterate_sources		 (GstBin *bin);
GstIterator*	gst_bin_iterate_all_by_interface (GstBin *bin, GType iface);
*/

 
  /** Gets the bin's list of children.
   */
   Glib::ListHandle< Glib::RefPtr<Element> > get_children() const;
 
  /** Gets the number of children in the bin.
   */
   int get_num_children() const;
 
  
  /** Will be emitted after the element was added to the bin.
   *
   * @par Prototype:
   * <tt>void on_my_%element_added(const Glib::RefPtr<Element>& element)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Element>& > signal_element_added();


  /** Will be emitted after the element was removed from the bin.
   *
   * @par Prototype:
   * <tt>void on_my_%element_removed(const Glib::RefPtr<Element>& element)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Element>& > signal_element_removed();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The bin will handle Asynchronous state changes.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_async_handling() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The bin will handle Asynchronous state changes.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_async_handling() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  /** method to add an element to a bin
   */
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool add_element_vfunc(const Glib::RefPtr<Element>& element);
#endif //GLIBMM_VFUNCS_ENABLED


  /** method to remove an element from a bin
   */
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool remove_element_vfunc(const Glib::RefPtr<Element>& element);
#endif //GLIBMM_VFUNCS_ENABLED


  /** method to handle a message from the children
   */
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void handle_message_vfunc(const Glib::RefPtr<Message>& message);
#endif //GLIBMM_VFUNCS_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_element_added(const Glib::RefPtr<Element>& element);
  virtual void on_element_removed(const Glib::RefPtr<Element>& element);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} //namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Bin
   */
  Glib::RefPtr<Gst::Bin> wrap(GstBin* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_BIN_H */

