// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_FORMAT_H
#define _GSTREAMERMM_FORMAT_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstformat.h>


namespace Gst
{

/** @addtogroup gstreamermmEnums Enums and Flags */

/**
 * @ingroup gstreamermmEnums
 */
enum Format
{
  FORMAT_UNDEFINED,
  FORMAT_DEFAULT,
  FORMAT_BYTES,
  FORMAT_TIME,
  FORMAT_BUFFERS,
  FORMAT_PERCENT
};

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::Format> : public Glib::Value_Enum<Gst::Format>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{


/** A format definition is used to get details of a Gst::Format by
 * Gst::get_details().
 */
struct FormatDefinition
{
  /// The unique id of this format.
  Gst::Format         value;

  /// A short nick of the format.
  Glib::ustring       nick;

  /// A longer description of the format.
  Glib::ustring       description;

  /// A quark for the nick.
  Glib::QueryQuark    quark;
};

namespace Enums
{

/** Get a printable name for the given format. Do not modify or free.
 * 
 * @param format A Gst::Format.
 * @return The name of the format or NULL if the format is unknown.
 */
Glib::ustring get_name(Format f);

/** Get the unique quark for the given format.
 *
 * @param format A Gst::Format.
 * @return The quark associated with the format or 0 if the format is unknown. 
 */
Glib::QueryQuark get_quark(Format f);

} //namespace Enums

/** Return the format registered with the given nick.
 *
 * @param nick The nick of the format.
 * @return The format with nick or Gst::FORMAT_UNDEFINED if the format was not
 * registered.
 */
Format get_format(const Glib::ustring& nick);

/** Get details about the given format.
 *
 * @param format The format to get details of.
 * @param def The Gst::FormatDefinition in which to store details of format.
 * @return true if successful, false otherwise. MT safe.
 */
bool get_details(Format format, FormatDefinition& def);

} //namespace Gst


#endif /* _GSTREAMERMM_FORMAT_H */

