// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_QUERY_H
#define _GSTREAMERMM_QUERY_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstquery.h>
#include <gstreamermm/miniobject.h>
#include <gstreamermm/structure.h>
#include <gstreamermm/wrap.h>
#include <gstreamermm/format.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstQuery GstQuery;
typedef struct _GstQueryClass GstQueryClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class Query_Class; } // namespace Gst
namespace Gst
{

/** @addtogroup gstreamermmEnums Enums and Flags */

/**
 * @ingroup gstreamermmEnums
 */
enum QueryType
{
  QUERY_NONE,
  QUERY_POSITION,
  QUERY_DURATION,
  QUERY_LATENCY,
  QUERY_JITTER,
  QUERY_RATE,
  QUERY_SEEKING,
  QUERY_SEGMENT,
  QUERY_CONVERT,
  QUERY_FORMATS
};

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::QueryType> : public Glib::Value_Enum<Gst::QueryType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{


namespace Enums
{

/** Get a printable name for the given query type.
 *
 * @param query The query type.
 * @return The name of the query.
 */
Glib::ustring get_name(QueryType t);


/** Get the unique quark for the given query type.
 *
 * @param query The query type.
 * @return The quark associated with the query type.
 */
Glib::QueryQuark get_quark(QueryType t);


} //namespace Enums

struct QueryTypeDefinition
{
  QueryType             value;
  Glib::ustring         nick;
  Glib::ustring         description;
  Glib::QueryQuark      quark;
};


class Query : public MiniObject
{
protected:
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Query CppObjectType;
  typedef Query_Class CppClassType;
  typedef GstQuery BaseObjectType;
  typedef GstQueryClass BaseClassType;

private:  friend class Query_Class;
  static CppClassType query_class_;

private:
  // noncopyable
  Query(const Query&);
  Query& operator=(const Query&);

protected:
  explicit Query(GstQuery* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Query();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GstMiniObject.
  GstQuery*       gobj()       { return reinterpret_cast<GstQuery*>(gobject_); }

  ///Provides access to the underlying C GstMiniObject.
  const GstQuery* gobj() const { return reinterpret_cast<GstQuery*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstQuery* gobj_copy();

private:


public:

  /** Get the structure of a query.
   * @return The Structure of the query.
   */
  Structure get_structure() const;

public:
  /** Get the Gst::QueryType of the query.
   */
   QueryType get_query_type() const;
 
  /** Wrap a GstQuery* in a C++ instance, creating an instance of a derived
   * Gst::Query. Gst::wrap() would just create a Gst::Query (rather than a
   * derived one) because the derived Gst::Query classes do not correspond
   * to GType types in the GStreamer API.
   */
  static Glib::RefPtr<Query> wrap(GstQuery* query, bool take_copy=false);

  
  /** Create a new GstQueryType based on the nick or return an
   * already registered query with that nick
   * @param nick The nick of the new query.
   * @param description The description of the new query.
   * @return A new GstQueryType or an already registered query
   * with the same nick.
   */
  static QueryType register_query_type(const Glib::ustring& nick, const Glib::ustring& description);
  
  /** Get the query type registered with @a nick.
   * @param nick The nick of the query.
   * @return The query registered with @a nick or Gst::QUERY_NONE
   * if the query was not registered.
   */
  static QueryType get_query_type(const Glib::ustring& nick);

 
  /** See if the given Gst::QueryType is inside the @a types query types array.
   * @param type The Gst::QueryType to find.
   * @return <tt>true</tt> if the type is found inside the array.
   */
  static bool query_types_contains(const Glib::ArrayHandle<QueryType>& types, QueryType type);

  /** Get details about the given Gst::QueryType.
   *
   * @param type A Gst::QueryType.
   * @param def A Gst::QueryTypeDefinition in which to store the details.
   * @return true if successful, false otherwise.
   */
  bool get_details(QueryType type, QueryTypeDefinition& def);
  

public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

//TODO: Modify create methods of derived Query classes to return
//Glib::RefPtr<...> to the derived class and not just Gst::Query. Must deal
//with GstStructure immutability problem (bug #510301) first because casting
//Glib::RefPtrs references the objects which causes problems when GStreamer API
//tries to modify the GstStructures of the objects.

class QueryConvert : public Query
{
public:
  explicit QueryConvert(GstQuery* query);

  static Glib::RefPtr<Query> create(Format src_format, gint64 value, Format dest_format);
  void set(Format src_format, gint64 src_value, Format dest_format, gint64 dest_value);
  void parse(Format& dest_format, gint64& dest_value);
  void parse(Format& src_format, gint64& src_value, Format& dest_format, gint64& dest_value);
};

class QueryPosition : public Query
{
public:
  explicit QueryPosition(GstQuery* query);

  static Glib::RefPtr<Query> create(Format format);
  void set(Format format, gint64 position);
  void parse(Format& format, gint64& position);
};

class QueryDuration : public Query
{
public:
  explicit QueryDuration(GstQuery* query);

  static Glib::RefPtr<Query> create(Format format);
  void set(Format format, gint64 duration);
  void parse(Format& format, gint64& duration);
};

class QueryLatency : public Query
{
public:
  explicit QueryLatency(GstQuery* query);

  static Glib::RefPtr<Query> create();
  void set(bool live, ClockTime min_latency, ClockTime max_latency);
  void parse(bool& live, ClockTime& min_latency, ClockTime& max_latency);
};

class QuerySeeking : public Query
{
public:
  explicit QuerySeeking(GstQuery* query);

  static Glib::RefPtr<Query> create(Format format);
  void set(Format format, bool seeakable, gint64 segment_start, gint64 segment_end);
  void parse(Format& format, bool& seekable, gint64& segment_start, gint64& segment_end);
};

class QueryFormats : public Query
{
public:
  explicit QueryFormats(GstQuery* query);

  static Glib::RefPtr<Query> create();
  void set(int n_formats, const va_list& varargs);
  //TODO: set(int n_formats, const std::vector<const Format>& formats);
  void parse(guint& n_formats);
  void parse(guint nth, Format& format);
};

class QuerySegment : public Query
{
public:
  explicit QuerySegment(GstQuery* query);

  static Glib::RefPtr<Query> create(Format format);
  void set(double rate, Format format, gint64 start_value, gint64 stop_value);
  void parse(double& rate, Format& format, gint64& start_value, gint64& stop_value);
};

} //namespace Gst


namespace Gst
{
  /** @relates Gst::Query
   * @param object The C instance
   * @param take_copy false if the result should take ownership of the C instance. true if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gst::Query> wrap(GstQuery* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_QUERY_H */

