// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_ELEMENTFACTORY_H
#define _GSTREAMERMM_ELEMENTFACTORY_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstelement.h>
#include <gstreamermm/pluginfeature.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstElementFactory GstElementFactory;
typedef struct _GstElementFactoryClass GstElementFactoryClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class ElementFactory_Class; } // namespace Gst
namespace Gst
{

class Caps;
class Element;
class PadTemplate;
class Plugin;

/** Gst::ElementFactory — Create Gst::Element from a factory.
 * Gst::ElementFactory is used to create instances of elements. A
 * Gst::ElementFactory can be added to a Gst::Plugin as it is also a
 * Gst::PluginFeature. Use find() to get a particular element factory. Use
 * create_named_element() and the create_element() functions to create element
 * instances.
 *
 * The following code example shows you how to create a 'filesrc' element.
 *
 * @code
 *  #include <gstreamermm.h>
 *  #include <iostream>

 *  int main (int argc, char *argc[])
 *  {
 *    Glib::RefPtr<Gst::Element> src;
 *    Glib::RefPtr<Gst::ElementFactory> srcfactory;
 *
 *    Gst::init(&argc,&argv);
 *
 *    srcfactory = Gst::ElementFactory::find("filesrc");
 *
 *    if (!srcfactory)
 *    {
 *      std::cout << "Could not find factory 'filesrc'" << std::endl;
 *      exit(1);
 *    }
 *
 *    src = srcfactory->create_named_element("src");
 *
 *    if (!src)
 *    {
 *      std::cout << "Could not create element 'src'" << std::endl;
 *      exit(1);
 *    }
 *    ...
 *  }
 * @endcode
 *
 */

class ElementFactory : public PluginFeature
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef ElementFactory CppObjectType;
  typedef ElementFactory_Class CppClassType;
  typedef GstElementFactory BaseObjectType;
  typedef GstElementFactoryClass BaseClassType;

private:  friend class ElementFactory_Class;
  static CppClassType elementfactory_class_;

private:
  // noncopyable
  ElementFactory(const ElementFactory&);
  ElementFactory& operator=(const ElementFactory&);

protected:
  explicit ElementFactory(const Glib::ConstructParams& construct_params);
  explicit ElementFactory(GstElementFactory* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~ElementFactory();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstElementFactory*       gobj()       { return reinterpret_cast<GstElementFactory*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstElementFactory* gobj() const { return reinterpret_cast<GstElementFactory*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstElementFactory* gobj_copy();

private:


public:
  
  /** Search for an element factory of the given name. Refs the returned
   * element factory; caller is responsible for unreffing.
   * @param name Name of factory to find.
   * @return Gst::ElementFactory if found, <tt>0</tt> otherwise.
   */
  static Glib::RefPtr<ElementFactory> find(const Glib::ustring& name);

  //Note that name can't be NULL here, though it seems like gstreamer should allow that as for gst_element_factory_make().
  
  /** Create a new element of the type defined by the given elementfactory.
   * It will be given the name supplied, since all elements require a name as
   * their first argument.
   * @param name Name of new element.
   * @return New Gst::Element or <tt>0</tt> if the element couldn't be created.
   */
  Glib::RefPtr<Element> create_named_element(const Glib::ustring& name);

  
  /** Create a new element of the type defined by the given element factory.
   * @param factoryname A named factory to instantiate.
   * @param name Name of new element.
   * @return New Gst::Element or <tt>0</tt> if unable to create element.
   */
  static Glib::RefPtr<Element> create_element(const Glib::ustring& factory_name, const Glib::ustring& name);
  
  /** Create a new element of the type defined by the given element factory, 
   * with a guaranteed unique name consisting of the element factory name and a
   * number.
   * @param factoryname A named factory to instantiate.
   * @param name Name of new element.
   * @return New Gst::Element or an empty RefPtr if unable to create element.
   */
  static Glib::RefPtr<Element> create_element(const Glib::ustring& factory_name);

  
  /** Get the Type for elements managed by this factory. The type can
   * only be retrieved if the element factory is loaded, which can be
   * assured with Gst::PluginFeature::load().
   * @return The Type for elements managed by this factory or 0 if
   * the factory is not loaded.
   */
  GType get_element_type() const;
  
  /** Gets the longname for this factory
   * @return The longname.
   */
  Glib::ustring get_long_name() const;
  
  /** Gets the class for this factory.
   * @return The class.
   */
  Glib::ustring get_kclass() const;
  
  /** Gets the description for this factory.
   * @return The description.
   */
  Glib::ustring get_description() const;
  
  /** Gets the author for this factory.
   * @return The author.
   */
  Glib::ustring get_author() const;
  
  /** Gets the number of pad_templates in this factory.
   * @return The number of pad_templates.
   */
  guint get_num_pad_templates() const;
  
  /** Gets the type of URIs the element supports or Gst::URI_UNKNOWN if none.
   * @return Type of URIs this element supports.
   */
  int get_uri_type() const;

 
  /** Gets a <tt>0</tt>-terminated array of protocols this element supports or <tt>0</tt> if
   * no protocols are supported. You may not change the contents of the returned
   * array, as it is still owned by the element factory. Use Glib::strdupv() to
   * make a copy of the protocol string array if you need to.
   * @return The supported protocols or <tt>0</tt>.
   */
  Glib::StringArrayHandle get_uri_protocols() const;

  
  /** Check if @a factory implements the interface with name @a interfacename.
   * @param interfacename An interface name.
   * @return #<tt>true</tt> when @a factory implement the interface.
   * 
   * Since: 0.10.14.
   */
  bool has_interface(const Glib::ustring& name) const;
  
  /** Checks if the factory can sink the given capability.
   * @param caps The caps to check.
   * @return True if it can sink the capabilities.
   */
  bool can_sink_caps(const Glib::RefPtr<const Caps>& caps) const;
  
  /** Checks if the factory can source the given capability.
   * @param caps The caps to check.
   * @return True if it can src the capabilities.
   */
  bool can_src_caps(const Glib::RefPtr<const Caps>& caps) const;

 
  /** Gets the List of Gst::StaticPadTemplate for this factory.
   * @return The padtemplates.
   */
  Glib::ListHandle< Glib::RefPtr<const PadTemplate> > get_static_pad_templates();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::ElementFactory
   */
  Glib::RefPtr<Gst::ElementFactory> wrap(GstElementFactory* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_ELEMENTFACTORY_H */

