// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_PIPELINE_H
#define _GSTREAMERMM_PIPELINE_H


#include <glibmm.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/bin.h>
#include <gstreamermm/clock.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstPipeline GstPipeline;
typedef struct _GstPipelineClass GstPipelineClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class Pipeline_Class; } // namespace Gst
namespace Gst
{

class Bus;

/** A Gst::Pipeline is a special Gst::Bin used as the toplevel container for
 * the filter graph.
 * The Gst::Pipeline will manage the selection and distribution of a global
 * Gst::Clock as well as provide a Gst::Bus to the application. It will also
 * implement a default behavour for managing seek events (see
 * Gst::Element::seek()).
 *
 * create() is used to create a pipeline. when the pipeline is destroyed all
 * its resources including all added Gst::Element objects are destroyed.
 *
 * Elements are added and removed from the pipeline using the Gst::Bin methods
 * like Gst::Bin::add() and Gst::Bin::remove() (see Gst::Bin).
 *
 * Before changing the state of the Gst::Pipeline (see Gst::Element) a Gst::Bus
 * can be retrieved with get_bus(). This bus can then be used to receive
 * Gst::Message from the elements in the pipeline.
 *
 * By default, a Gst::Pipeline will automatically flush the pending Gst::Bus
 * messages when going to the NULL state to ensure that no circular references
 * exist when no messages are read from the Gst::Bus. This behaviour can be
 * changed with set_auto_flush_bus().
 *
 * When the Gst::Pipeline performs the PAUSED to PLAYING state change it will
 * select a clock for the elements. The clock selection algorithm will by
 * default select a clock provided by an element that is most upstream (closest
 * to the source). For live pipelines (ones that return
 * Gst::STATE_CHANGE_NO_PREROLL from the Gst::Element::set_state() call) this
 * will select the clock provided by the live source. For normal pipelines this
 * will select a clock provided by the sinks (most likely the audio sink). If
 * no element provides a clock, a default Gst::SystemClock is used.
 *
 * The clock selection can be controlled with the use_clock() method, which
 * will enforce a given clock on the pipeline. With auto_clock() the default
 * clock selection algorithm can be restored.
 *
 * A Gst::Pipeline maintains a stream time for the elements. The stream time is
 * defined as the difference between the current clock time and the base time.
 * When the pipeline goes to READY or a flushing seek is performed on it, the
 * stream time is reset to 0. When the pipeline is set from PLAYING to PAUSED,
 * the current clock time is sampled and used to configure the base time for
 * the elements when the pipeline is set to PLAYING again. This default
 * behaviour can be changed with the set_new_stream_time() method.
 *
 * When sending a flushing seek event to a Gst::Pipeline (see
 * Gst::Element::seek()), it will make sure that the pipeline is properly
 * PAUSED and resumed as well as set the new stream time to 0 when the seek
 * succeeded.
 *
 * Last reviewed on 2006-03-12 (0.10.5)
 * @ingroup GstBaseClasses
 */

class Pipeline : public Bin 
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Pipeline CppObjectType;
  typedef Pipeline_Class CppClassType;
  typedef GstPipeline BaseObjectType;
  typedef GstPipelineClass BaseClassType;

private:  friend class Pipeline_Class;
  static CppClassType pipeline_class_;

private:
  // noncopyable
  Pipeline(const Pipeline&);
  Pipeline& operator=(const Pipeline&);

protected:
  explicit Pipeline(const Glib::ConstructParams& construct_params);
  explicit Pipeline(GstPipeline* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Pipeline();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstPipeline*       gobj()       { return reinterpret_cast<GstPipeline*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstPipeline* gobj() const { return reinterpret_cast<GstPipeline*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstPipeline* gobj_copy();

private:


protected:
  explicit Pipeline(const Glib::ustring& name);
  Pipeline();

public:
  /** Create a new pipeline with the given name.
   *
   * @param name Name of new pipeline.
   * @return Newly created Gst::Pipeline. MT safe.
   */
  
  static Glib::RefPtr<Pipeline> create(const Glib::ustring& name);


  /** Create a new pipeline with a unique generic name.
   * @return Newly created Gst::Pipeline. MT safe.
   */
   
  static Glib::RefPtr<Pipeline> create();


  /** Gets the Gst::Bus of @a pipeline. The bus allows applications to receive Gst::Messages.
   * @return A Gst::Bus, unref after usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<Gst::Bus> get_bus();
  
  /** Gets the Gst::Bus of @a pipeline. The bus allows applications to receive Gst::Messages.
   * @return A Gst::Bus, unref after usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<const Gst::Bus> get_bus() const;
  
  /** Set the clock for @a pipeline. The clock will be distributed
   * to all the elements managed by the pipeline.
   * @param clock The clock to set.
   * @return <tt>true</tt> if the clock could be set on the pipeline. <tt>false</tt> if
   * some element did not accept the clock.
   * 
   * MT safe.
   */
  bool set_clock(const Glib::RefPtr<Gst::Clock>& clock);
  
  /** Gets the current clock used by @a pipeline.
   * @return A Gst::Clock, unref after usage.
   */
  Glib::RefPtr<Gst::Clock> get_clock();
  
  /** Gets the current clock used by @a pipeline.
   * @return A Gst::Clock, unref after usage.
   */
  Glib::RefPtr<const Gst::Clock> get_clock() const;
  
  /** Force @a pipeline to use the given @a clock. The pipeline will
   * always use the given clock even if new clock providers are added
   * to this pipeline.
   * 
   * If @a clock is <tt>0</tt> all clocking will be disabled which will make
   * the pipeline run as fast as possible.
   * 
   * MT safe.
   * @param clock The clock to use.
   */
  void use_clock(const Glib::RefPtr<Gst::Clock>& clock);
  
  /** Let @a pipeline select a clock automatically. This is the default
   * behaviour.
   * 
   * Use this function if you previous forced a fixed clock with
   * use_clock() and want to restore the default
   * pipeline clock selection algorithm.
   * 
   * MT safe.
   */
  void auto_clock();
  
  /** Set the new stream time of @a pipeline to @a time. The stream time is used to
   * set the base time on the elements (see Gst::Element::set_base_time())
   * in the PAUSED->PLAYING state transition.
   * 
   * Setting @a time to Gst::CLOCK_TIME_NONE will disable the pipeline's management
   * of element base time. The application will then be responsible for
   * performing base time distribution. This is sometimes useful if you want to
   * synchronize capture from multiple pipelines, and you can also ensure that the
   * pipelines have the same clock.
   * 
   * MT safe.
   * @param time The new stream time to set.
   */
  void set_new_stream_time(ClockTime time);
  
  /** Gets the last stream time of @a pipeline. If the pipeline is PLAYING,
   * the returned time is the stream time used to configure the element's
   * base time in the PAUSED->PLAYING state. If the pipeline is PAUSED, the
   * returned time is the stream time when the pipeline was paused.
   * 
   * This function returns Gst::CLOCK_TIME_NONE if the pipeline was
   * configured to not handle the management of the element's base time
   * (see set_new_stream_time()).
   * @return A Gst::ClockTime.
   * 
   * MT safe.
   */
  ClockTime get_last_stream_time() const;
  
  /** Usually, when a pipeline goes from READY to <tt>0</tt> state, it automatically
   * flushes all pending messages on the bus, which is done for refcounting
   * purposes, to break circular references.
   * 
   * This means that applications that update state using (async) bus messages
   * (e.g. do certain things when a pipeline goes from PAUSED to READY) might
   * not get to see messages when the pipeline is shut down, because they might
   * be flushed before they can be dispatched in the main thread. This behaviour
   * can be disabled using this function.
   * 
   * It is important that all messages on the bus are handled when the
   * automatic flushing is disabled else memory leaks will be introduced.
   * 
   * MT safe.
   * 
   * Since: 0.10.4
   * @param auto_flush Whether or not to automatically flush the bus when
   * the pipeline goes from READY to <tt>0</tt> state.
   */
  void set_auto_flush_bus(gboolean auto_flush = true);
  
  /** Check if @a pipeline will automatically flush messages when going to
   * the <tt>0</tt> state.
   * @return Whether the pipeline will automatically flush its bus when
   * going from READY to <tt>0</tt> state or not.
   * 
   * MT safe.
   * 
   * Since: 0.10.4.
   */
  bool get_auto_flush_bus() const;
  
  /** Set the expected delay needed for all elements to perform the
   * PAUSED to PLAYING state change. @a delay will be added to the
   * base time of the elements so that they wait an additional @a delay
   * amount of time before starting to process buffers and cannot be
   * Gst::CLOCK_TIME_NONE.
   * 
   * This option is used for tuning purposes and should normally not be
   * used.
   * 
   * MT safe.
   * 
   * Since: 0.10.5
   * @param delay The delay.
   */
  void set_delay(ClockTime delay);
  
  /** Get the configured delay (see set_delay()).
   * @return The configured delay.
   * 
   * MT safe.
   * 
   * Since: 0.10.5.
   */
  ClockTime get_delay() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to automatically flush the pipeline's bus when going from READY into NULL state.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_auto_flush_bus() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to automatically flush the pipeline's bus when going from READY into NULL state.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_auto_flush_bus() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Expected delay needed for elements to spin up to PLAYING in nanoseconds.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<ClockTime> property_delay() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Expected delay needed for elements to spin up to PLAYING in nanoseconds.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<ClockTime> property_delay() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} //namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Pipeline
   */
  Glib::RefPtr<Gst::Pipeline> wrap(GstPipeline* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_PIPELINE_H */

