/* The Cairo CSS Drawing Library.
 * Copyright (C) 2008 Robert Staudinger
 *
 * This  library is free  software; you can  redistribute it and/or
 * modify it  under  the terms  of the  GNU Lesser  General  Public
 * License  as published  by the Free  Software  Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed  in the hope that it will be useful,
 * but  WITHOUT ANY WARRANTY; without even  the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License  along  with  this library;  if not,  write to  the Free
 * Software Foundation, Inc., 51  Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#ifndef CCD_BACKGROUND_H
#define CCD_BACKGROUND_H

#include <stdbool.h>
#include <stdint.h>
#include <cairo.h>
#include <glib.h>
#include <libcroco/libcroco.h>
#include <ccd/ccd-features.h>
#include <ccd/ccd-color.h>
#include <ccd/ccd-image.h>
#include <ccd/ccd-property.h>

G_BEGIN_DECLS

typedef struct {
	ccd_color_t		color;
	ccd_property_spec_t	spec;
} ccd_background_color_t;

typedef struct {
	ccd_image_t		image;
	ccd_property_spec_t	spec;
} ccd_background_image_t;

typedef struct {
	ccd_background_color_t	bg_color;
	ccd_background_image_t	bg_image;
} ccd_background_t;

ccd_background_t *	ccd_background_new	(void);
void			ccd_background_free	(ccd_background_t *self);

bool ccd_background_parse (ccd_background_t *self, char const *property, 
			   CRTerm const *values);

void ccd_background_draw (ccd_background_color_t const *bg_color, 
			  ccd_background_image_t const *bg_image,
			  cairo_t *cr, int32_t x, int32_t y, 
			  int32_t width, int32_t height);

void ccd_background_dump	(ccd_background_t const *self);
void ccd_background_color_dump	(ccd_background_color_t const *self);
void ccd_background_image_dump	(ccd_background_image_t const *self);

G_END_DECLS

#endif /* CCD_BACKGROUND_H */

