/* The Cairo CSS Drawing Library.
 * Copyright (C) 2008 Robert Staudinger
 *
 * This  library is free  software; you can  redistribute it and/or
 * modify it  under  the terms  of the  GNU Lesser  General  Public
 * License  as published  by the Free  Software  Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed  in the hope that it will be useful,
 * but  WITHOUT ANY WARRANTY; without even  the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License  along  with  this library;  if not,  write to  the Free
 * Software Foundation, Inc., 51  Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#ifndef CCD_STYLE_H
#define CCD_STYLE_H

#include <stdint.h>
#include <glib.h>
#include <cairo.h>
#include <ccd/ccd-features.h>
#include <ccd/ccd-background.h>
#include <ccd/ccd-border.h>
#include <ccd/ccd-color.h>
#include <ccd/ccd-property.h>

G_BEGIN_DECLS

/**
 * ccd_style_t:
 *
 * Representation of a block of CSS statements.
 *
 * <emphasis>Memory management:</emphasis> Style objects are owned by the 
 * stylesheet, and therefore not created or modified by the CCD consumer.
 **/
typedef struct {
	/*< private >*/
	ccd_background_color_t const	*bg_color;
	ccd_background_image_t const	*bg_image;
	ccd_border_stroke_t		 left;
	ccd_border_stroke_t		 top;
	ccd_border_stroke_t		 right;
	ccd_border_stroke_t		 bottom;
	ccd_color_t const		*color;
	ccd_property_spec_t		 color_spec;
} ccd_style_t;

void ccd_style_init (ccd_style_t *self);

void ccd_style_draw_line (ccd_style_t const *self, cairo_t *cr, 
			  int32_t x1, int32_t x2, int32_t y1, int32_t y2);

void ccd_style_draw_outline (ccd_style_t const *self, cairo_t *cr, 
			     int32_t x, int32_t y, int32_t width, int32_t height);

void ccd_style_draw_rectangle (ccd_style_t const *self, cairo_t *cr, 
			       int32_t x, int32_t y, int32_t width, int32_t height);

void ccd_style_dump (ccd_style_t const *self);

G_END_DECLS

#endif /* CCD_STYLE_H */

