
extern "C"
{
#include <glib-object.h>
#include <gdk/gdkenumtypes.h>
}

#include <gdkmm/pixmap.h>
#include <gdkmm/private/pixmap_p.h>

// -*- c++ -*-
/* $Id: pixmap.ccg,v 1.13 2002/04/02 13:23:10 daniel Exp $ */

/*
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdkmm/window.h>
#include <gdk/gdkpixmap.h>


namespace Gdk
{

Pixmap::Pixmap(const Glib::RefPtr<Window>& window,int width, int height, int	depth)
:
  Drawable((GdkDrawable*) gdk_pixmap_new(window->gobj(), width, height, depth))
{
  //TODO: We need a construct function if we really want to use our own GClass.
}

Pixmap::Pixmap(const Glib::RefPtr<Window>& window, const char* data, int width, int height, int	depth,
               const Color& fg, const Color& bg)
:
  Drawable((GdkDrawable*) gdk_pixmap_create_from_data(
      window->gobj(), data, width, height, depth,
      const_cast<GdkColor*>(fg.gobj()), const_cast<GdkColor*>(bg.gobj())))
{
  //TODO: We need a construct function if we really want to use our own GClass.
}

void Pixmap::warn_about_xpm_file_problem(const Glib::ustring& filename)
{
  g_warning("Couldn't create pixmap from file '%s' - using internal default", filename.c_str());
}

Glib::RefPtr<Pixmap>
Pixmap::create_from_data(
				  const Glib::RefPtr<const Drawable>& window,
				  const char* data,
				  int        width,
				  int        height,
				  int        depth,
				  const Color& fg,
				  const Color& bg)
{
  GdkPixmap* obj = gdk_pixmap_create_from_data( const_cast<GdkWindow*>(window->gobj()),
				   const_cast<char*>(data),width,height,depth,
				   const_cast<GdkColor*>(fg.gobj()),
				   const_cast<GdkColor*>(bg.gobj()));

  return wrap_specific_type(obj);
}


Glib::RefPtr<Pixmap>
Pixmap::create_from_xpm(const Glib::RefPtr<const Drawable>& window,
				 const Color& transparent_color,
				 const Glib::ustring& filename)
{
  GdkPixmap* obj = gdk_pixmap_create_from_xpm( const_cast<GdkWindow*>(window->gobj()), 0,
				  const_cast<GdkColor*>(transparent_color.gobj()),
				  const_cast<char*>(filename.c_str()));
  if(!obj)
  {
    Glib::RefPtr<Bitmap> dummy;
    warn_about_xpm_file_problem(filename);
    return create_from_xpm(window, dummy, transparent_color, defaultPixmap);
  }
  else
  {
    return wrap_specific_type(obj);
  }
}


Glib::RefPtr<Pixmap>
Pixmap::create_from_xpm(const Glib::RefPtr<const Drawable>& window,
				 Glib::RefPtr<Bitmap>& mask,
				 const Color& transparent_color,
				 const Glib::ustring& filename)
{
  GdkBitmap* bit = 0;

  GdkPixmap* obj = gdk_pixmap_create_from_xpm( const_cast<GdkWindow*>(window->gobj()), &bit,
				  const_cast<GdkColor*>(transparent_color.gobj()),
				  const_cast<char*>(filename.c_str()));

  if(!obj)
  {
    warn_about_xpm_file_problem(filename);
    return create_from_xpm(window, mask, transparent_color, defaultPixmap);
  }
  else
  {
    mask = Bitmap::wrap_specific_type(bit);
  }

  return wrap_specific_type(obj);
}


Glib::RefPtr<Pixmap>
Pixmap::create_from_xpm(const Glib::RefPtr<const Drawable>   &window,
					  const Glib::RefPtr<Colormap>& colormap,
					  Glib::RefPtr<Bitmap>& bitmap,
					  const Color& transparent_color,
					  const Glib::ustring& filename)
{
  GdkBitmap* bit = 0;
  GdkPixmap* obj = gdk_pixmap_colormap_create_from_xpm( const_cast<GdkWindow*>(window->gobj()),
					   colormap->gobj(), &bit,
					   const_cast<GdkColor*>(transparent_color.gobj()),
					   const_cast<char*>(filename.c_str()));

  if(!obj)
    {
      warn_about_xpm_file_problem(filename);
      return create_from_xpm(window, bitmap, transparent_color, defaultPixmap);
    }
  else
    bitmap = Bitmap::wrap_specific_type(bit);

  return wrap_specific_type(obj);
}


Glib::RefPtr<Pixmap>
Pixmap::create_from_xpm(const Glib::RefPtr<const Drawable>& window,
				   Glib::RefPtr<Bitmap>& bitmap,
				   const Color& transparent_color,
				   const char * const *data)
{
  GdkBitmap* bit = 0;
  GdkPixmap* obj = gdk_pixmap_create_from_xpm_d( const_cast<GdkWindow*>(window->gobj()), &bit,
				    const_cast<GdkColor*>(transparent_color.gobj()),
				    const_cast<char**>(data));

  bitmap = Bitmap::wrap_specific_type(bit);

  return wrap_specific_type(obj);
}

Glib::RefPtr<Pixmap>
Pixmap::create_from_xpm(const Glib::RefPtr<const Drawable>& window,
					     const Glib::RefPtr<Colormap>& colormap,
					     Glib::RefPtr<Bitmap>& mask,
					     const Color& transparent_color,
					     const char * const * data)
{
  GdkBitmap* bit = 0;
  GdkPixmap* obj = gdk_pixmap_colormap_create_from_xpm_d( const_cast<GdkWindow*>(window->gobj()),
					     colormap->gobj(),
					     &bit,
                                             const_cast<GdkColor*>(transparent_color.gobj()),
					     const_cast<char**>(data));

  mask = Bitmap::wrap_specific_type(bit);

  return wrap_specific_type(obj);
}

Glib::RefPtr<Pixmap>
Pixmap::create_from_xpm(const Glib::RefPtr<Colormap>& colormap,
					     Glib::RefPtr<Bitmap>& mask,
					     const Color& transparent_color,
					     const char * const * data)
{
  GdkBitmap* bit = 0;
  GdkPixmap* obj = gdk_pixmap_colormap_create_from_xpm_d( 0,
					     colormap->gobj(),
					     &bit,
                                             const_cast<GdkColor*>(transparent_color.gobj()),
					     const_cast<char**>(data));

  mask = Bitmap::wrap_specific_type(bit);

  return wrap_specific_type(obj);
}

Glib::RefPtr<Pixmap>
Pixmap::create_from_xpm(const Glib::RefPtr<Colormap>& colormap,
					     Glib::RefPtr<Bitmap>& mask,
					     const char * const * data)
{
  GdkBitmap* bit = 0;
  GdkPixmap* obj = gdk_pixmap_colormap_create_from_xpm_d( 0,
					     colormap->gobj(),
					     &bit, 0,
					     const_cast<char**>(data));

  mask = Bitmap::wrap_specific_type(bit);

  return wrap_specific_type(obj);
}

static const char *const noimage_xpm[] = {
  "20 20 4 1",
    " 	c None",
    ".	c #000000",
    "+	c #E24444",
    "@	c #FFFFFF",
    "....................",
    ".++@@@@@@@@@@@@@@++.",
    ".+++@@@@@@@@@@@@+++.",
    ".@+++@@@@@@@@@@+++@.",
    ".@@+++@@@@@@@@+++@@.",
    ".@@@+++@@@@@@+++@@@.",
    ".@@@@+++@@@@+++@@@@.",
    ".@@@@@+++@@+++@@@@@.",
    ".@@@@@@++++++@@@@@@.",
    ".@@@@@@@++++@@@@@@@.",
    ".@@@@@@@++++@@@@@@@.",
    ".@@@@@@++++++@@@@@@.",
    ".@@@@@+++@@+++@@@@@.",
    ".@@@@+++@@@@+++@@@@.",
    ".@@@+++@@@@@@+++@@@.",
    ".@@+++@@@@@@@@+++@@.",
    ".@+++@@@@@@@@@@+++@.",
    ".+++@@@@@@@@@@@@+++.",
    ".++@@@@@@@@@@@@@@++.",
    "...................."};

const char* const* Pixmap::defaultPixmap = noimage_xpm;

} //namespace


namespace
{
} // anonymous namespace


namespace Gdk
{


/* The *_Class implementation: */

GType Pixmap_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gdk_pixmap_get_type(), "gdkmm__Pixmap", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Pixmap_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Pixmap_Class::wrap_new(GObject* o)
{
  return new Pixmap((GdkPixmap*)(o));
}


/* The implementation: */

GdkPixmap* Pixmap::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<Pixmap> Pixmap::wrap_specific_type(GdkPixmap* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<Pixmap> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    Pixmap* pCppObject = dynamic_cast<Pixmap*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<Pixmap>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<Pixmap>( new Pixmap(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

Pixmap::Pixmap(GdkPixmap* castitem)
: Gdk::Drawable((GdkDrawable*)(castitem))
{}

Pixmap::~Pixmap()
{
}

Pixmap::CppClassType Pixmap::pixmap_class_; //Initialize static member.

GType Pixmap::get_type()
{
  return pixmap_class_.get_type();
}

GType Pixmap::get_base_type()
{
  return gdk_pixmap_get_type();
}

Pixmap::Pixmap()
: Gdk::Drawable((GdkDrawable*)(g_object_new(get_type(), (char*)0)))
{}

Glib::RefPtr<Pixmap> Pixmap::create()
{
  return Glib::RefPtr<Pixmap>( new Pixmap() );
}
Glib::RefPtr<Pixmap> Pixmap::create(const Glib::RefPtr<Window>& window, int width, int height, int depth = -1)
{
  return Glib::RefPtr<Pixmap>( new Pixmap(window, width, height, depth) );
}
Glib::RefPtr<Pixmap> Pixmap::create(const Glib::RefPtr<Window>& window, const char* data, int width, int height, int	depth, const Color& fg, const Color& bg)
{
  return Glib::RefPtr<Pixmap>( new Pixmap(window, data, width, height, depth, fg, bg) );
}


} // namespace Gdk

