// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_REGION_H
#define _GDKMM_REGION_H

#include <glibmm.h>

/* $Id: region.hg,v 1.12 2002/04/02 13:23:10 daniel Exp $ */

/* region.h
 *
 * Copyright (C) 1998-1999 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

extern "C" { typedef struct _GdkRegion GdkRegion; }

#include <glibmm/arrayhandle.h>
#include <gdkmm/types.h>
#include <gdkmm/rectangle.h>


namespace Gdk
{


/** @addtogroup gdkmmEnums Enums and Flags */

/**
 * @ingroup gdkmmEnums
 */
enum FillRule
{
  EVEN_ODD_RULE,
  WINDING_RULE
};

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::FillRule> : public Glib::Value_Enum<Gdk::FillRule>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum OverlapType
{
  OVERLAP_RECTANGLE_IN,
  OVERLAP_RECTANGLE_OUT,
  OVERLAP_RECTANGLE_PART
};

} // namespace Gdk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::OverlapType> : public Glib::Value_Enum<Gdk::OverlapType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{


class Region
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Region CppObjectType;
  typedef GdkRegion BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  Region();

  // Use make_a_copy=true when getting it directly from a struct.
  explicit Region(GdkRegion* castitem, bool make_a_copy = false);

  Region(const Region& src);
  Region& operator=(const Region& src);

  ~Region();

  GdkRegion*       gobj()       { return gobject_; }
  const GdkRegion* gobj() const { return gobject_; }

  // The caller is responsible for freeing it. Use when directly setting fields in structs.
  GdkRegion* gobj_copy() const;

protected:
  GdkRegion* gobject_;

private:

  
public:

  Region(const Glib::ArrayHandle<Gdk::Point>& points, FillRule fill_rule);
  Region(const Rectangle& rectangle);

  
  void get_clipbox(const Rectangle& rectangle);
  Glib::ArrayHandle<Rectangle> get_rectangles() const;

  
  bool empty();
  
  bool point_in(int x, int y);
  
  OverlapType rect_in(const Rectangle& rect);

  
  void offset(int dx, int dy);
  
  void shrink(int dx, int dy);
  
  void union_with_rect(const Rectangle& rect);
  
  void intersect(Region& source2);
  
  void union_(Region& source2); //union is a keyword.
  
  void subtract(Region& source2);
  
  void xor_(Region& source2); //xor is a keyword
  
  void spans_intersect_foreach(GdkSpan* spans, int n_spans, bool sorted, GdkSpanFunc function, gpointer data);


};

} //namespace Gdk


namespace Gdk
{

/** @relates Gdk::Region */
bool operator==(const Region& lhs, const Region& rhs);

/** @relates Gdk::Region */
bool operator!=(const Region& lhs, const Region& rhs);


} // namespace Gdk


namespace Glib
{

/** @relates Gdk::Region */
Gdk::Region wrap(GdkRegion* object, bool take_copy = false);

} // namespace Glib

#endif /* _GDKMM_REGION_H */

