
#include <gtkmm/buttonbox.h>
#include <gtkmm/private/buttonbox_p.h>

// -*- c++ -*-
/* $Id: buttonbox.ccg,v 1.9 2002/04/02 13:25:14 daniel Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkhbbox.h>
#include <gtk/gtkvbbox.h>

namespace Gtk
{

VButtonBox::VButtonBox(ButtonBoxStyle layout, int spacing)
:
  Gtk::ButtonBox((GtkButtonBox*) g_object_new(get_type(), (char*)0))
{
  set_layout(layout);
  set_spacing(spacing);
}

HButtonBox::HButtonBox(ButtonBoxStyle layout, int spacing)
:
  Gtk::ButtonBox((GtkButtonBox*) g_object_new(get_type(), (char*)0))
{
  set_layout(layout);
  set_spacing(spacing);
}


} /* namespace Gtk */


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::ButtonBox* wrap(GtkButtonBox* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::ButtonBox *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType ButtonBox_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_button_box_get_type(), "gtkmm__ButtonBox", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void ButtonBox_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* ButtonBox_Class::wrap_new(GObject* o)
{
  return manage(new ButtonBox((GtkButtonBox*)(o)));
}


/* The implementation: */

ButtonBox::ButtonBox(GtkButtonBox* castitem)
: Gtk::Box((GtkBox*)(castitem))
{}

ButtonBox::~ButtonBox()
{
  destroy_();
}

ButtonBox::CppClassType ButtonBox::buttonbox_class_; //Initialize static member.

GType ButtonBox::get_type()
{
  return buttonbox_class_.get_type();
}

GType ButtonBox::get_base_type()
{
  return gtk_button_box_get_type();
}

ButtonBoxStyle ButtonBox::get_layout() const
{
  return ((ButtonBoxStyle)(gtk_button_box_get_layout(const_cast<GtkButtonBox*>(gobj()))));
}

void ButtonBox::set_layout(ButtonBoxStyle layout_style)
{
  gtk_button_box_set_layout(gobj(), ((GtkButtonBoxStyle)(layout_style)));
}

void ButtonBox::set_child_secondary(Widget& child, bool is_secondary)
{
  gtk_button_box_set_child_secondary(gobj(), (child).Gtk::Widget::gobj(), static_cast<int>(is_secondary));
}

int ButtonBox::get_child_min_width() const
{
  return gobj()->child_min_width;
}

void ButtonBox::set_child_min_width(const int& value)
{
  gobj()->child_min_width =  value;
}

int ButtonBox::get_child_min_height() const
{
  return gobj()->child_min_height;
}

void ButtonBox::set_child_min_height(const int& value)
{
  gobj()->child_min_height =  value;
}

int ButtonBox::get_child_ipadding_x() const
{
  return gobj()->child_ipad_x;
}

void ButtonBox::set_child_ipadding_x(const int& value)
{
  gobj()->child_ipad_x =  value;
}

int ButtonBox::get_child_ipadding_y() const
{
  return gobj()->child_ipad_y;
}

void ButtonBox::set_child_ipadding_y(const int& value)
{
  gobj()->child_ipad_y =  value;
}


Glib::PropertyProxy<ButtonBoxStyle> ButtonBox::property_layout_style()
{
  return Glib::PropertyProxy<ButtonBoxStyle>(this, "layout_style");
}


} // namespace Gtk


namespace Glib
{

Gtk::VButtonBox* wrap(GtkVButtonBox* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::VButtonBox *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType VButtonBox_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_vbutton_box_get_type(), "gtkmm__VButtonBox", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void VButtonBox_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* VButtonBox_Class::wrap_new(GObject* o)
{
  return manage(new VButtonBox((GtkVButtonBox*)(o)));
}


/* The implementation: */

VButtonBox::VButtonBox(GtkVButtonBox* castitem)
: Gtk::ButtonBox((GtkButtonBox*)(castitem))
{}

VButtonBox::~VButtonBox()
{
  destroy_();
}

VButtonBox::CppClassType VButtonBox::vbuttonbox_class_; //Initialize static member.

GType VButtonBox::get_type()
{
  return vbuttonbox_class_.get_type();
}

GType VButtonBox::get_base_type()
{
  return gtk_vbutton_box_get_type();
}


} // namespace Gtk


namespace Glib
{

Gtk::HButtonBox* wrap(GtkHButtonBox* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::HButtonBox *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType HButtonBox_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_hbutton_box_get_type(), "gtkmm__HButtonBox", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void HButtonBox_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* HButtonBox_Class::wrap_new(GObject* o)
{
  return manage(new HButtonBox((GtkHButtonBox*)(o)));
}


/* The implementation: */

HButtonBox::HButtonBox(GtkHButtonBox* castitem)
: Gtk::ButtonBox((GtkButtonBox*)(castitem))
{}

HButtonBox::~HButtonBox()
{
  destroy_();
}

HButtonBox::CppClassType HButtonBox::hbuttonbox_class_; //Initialize static member.

GType HButtonBox::get_type()
{
  return hbuttonbox_class_.get_type();
}

GType HButtonBox::get_base_type()
{
  return gtk_hbutton_box_get_type();
}


} // namespace Gtk

