
#include <gtkmm/checkbutton.h>
#include <gtkmm/private/checkbutton_p.h>

// -*- c++ -*-
/* $Id: checkbutton.ccg,v 1.9 2002/03/09 18:10:46 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkcheckbutton.h>

namespace Gtk
{

CheckButton::CheckButton(const Glib::ustring & label, bool mnemonic /* = false */)
: Gtk::ToggleButton((GtkToggleButton*)( g_object_new( get_type() , "label", label.c_str(), "use_underline", (gboolean)mnemonic, 0 ) ))
{
}

} /* namespace */

namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::CheckButton* wrap(GtkCheckButton* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::CheckButton *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType CheckButton_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_check_button_get_type(), "gtkmm__CheckButton", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void CheckButton_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->draw_indicator = &draw_indicator_vfunc_callback;
}


void CheckButton_Class::draw_indicator_vfunc_callback(GtkCheckButton* self, GdkRectangle* area)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->draw_indicator(area);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->draw_indicator)
      (*base->draw_indicator)(self, area);
  }
}


Glib::ObjectBase* CheckButton_Class::wrap_new(GObject* o)
{
  return manage(new CheckButton((GtkCheckButton*)(o)));
}


/* The implementation: */

CheckButton::CheckButton(GtkCheckButton* castitem)
: Gtk::ToggleButton((GtkToggleButton*)(castitem))
{}

CheckButton::~CheckButton()
{
  destroy_();
}

CheckButton::CppClassType CheckButton::checkbutton_class_; //Initialize static member.

GType CheckButton::get_type()
{
  return checkbutton_class_.get_type();
}

GType CheckButton::get_base_type()
{
  return gtk_check_button_get_type();
}

CheckButton::CheckButton()
: Gtk::ToggleButton((GtkToggleButton*)(g_object_new(get_type(), (char*)0)))
{}


void Gtk::CheckButton::draw_indicator(GdkRectangle* area)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->draw_indicator)
    (*base->draw_indicator)(gobj(),area);
}


} // namespace Gtk

