
#include <gtkmm/combo.h>
#include <gtkmm/private/combo_p.h>

// -*- c++ -*-
/* $Id: combo.ccg,v 1.10 2002/01/23 05:43:04 daniel Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkcombo.h>
#include <gtk/gtklabel.h>
#include <gtkmm/entry.h>
#include <gtkmm/button.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/window.h>
#include <gtkmm/item.h>

namespace Gtk
{

/*
void Combo::remove_item_string(Gtk::Item& item)
{
  gtk_combo_set_item_string(gobj(), item.gobj(), 0);
}
*/

Glib::ListHandle<Glib::ustring> Combo::get_popdown_strings() const
{
  GList* popdown_strings = 0;

  GList *const list_children =
      gtk_container_get_children(reinterpret_cast<GtkContainer*>(gobj()->list));

  for(const GList* node = list_children; node != 0; node = node->next)
  {
    GtkLabel *const label = reinterpret_cast<GtkLabel*>(
        gtk_bin_get_child(static_cast<GtkBin*>(node->data)));

    popdown_strings = g_list_prepend(
        popdown_strings, const_cast<char*>(gtk_label_get_text(label)));
  }

  g_list_free(list_children);
  popdown_strings = g_list_reverse(popdown_strings);

  return Glib::ListHandle<Glib::ustring>(popdown_strings, Glib::OWNERSHIP_SHALLOW);
}

} // namespace Gtk


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::Combo* wrap(GtkCombo* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Combo *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Combo_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_combo_get_type(), "gtkmm__Combo", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Combo_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Combo_Class::wrap_new(GObject* o)
{
  return manage(new Combo((GtkCombo*)(o)));
}


/* The implementation: */

Combo::Combo(GtkCombo* castitem)
: Gtk::HBox((GtkHBox*)(castitem))
{}

Combo::~Combo()
{
  destroy_();
}

Combo::CppClassType Combo::combo_class_; //Initialize static member.

GType Combo::get_type()
{
  return combo_class_.get_type();
}

GType Combo::get_base_type()
{
  return gtk_combo_get_type();
}

Combo::Combo()
: Gtk::HBox((GtkHBox*)(g_object_new(get_type(), (char*)0)))
{}

void Combo::set_value_in_list(bool value, bool empty)
{
  gtk_combo_set_value_in_list(gobj(), static_cast<int>(value), static_cast<int>(empty));
}

void Combo::set_use_arrows(bool arrows_on)
{
  gtk_combo_set_use_arrows(gobj(), static_cast<int>(arrows_on));
}

void Combo::set_use_arrows_always(bool arrows_always)
{
  gtk_combo_set_use_arrows_always(gobj(), static_cast<int>(arrows_always));
}

void Combo::set_case_sensitive(bool val)
{
  gtk_combo_set_case_sensitive(gobj(), static_cast<int>(val));
}

void Combo::set_popdown_strings(const Glib::ListHandle<Glib::ustring>& strings)
{
  gtk_combo_set_popdown_strings(gobj(), strings.data());
}

void Combo::disable_activate()
{
  gtk_combo_disable_activate(gobj());
}

Entry* Combo::get_entry()
{
  return Glib::wrap((GtkEntry*)(gobj()->entry));
}

const Entry* Combo::get_entry() const
{
  return Glib::wrap((GtkEntry*)(gobj()->entry));
}


Glib::PropertyProxy<bool> Combo::property_enable_arrow_keys()
{
  return Glib::PropertyProxy<bool>(this, "enable_arrow_keys");
}

Glib::PropertyProxy<bool> Combo::property_enable_arrows_always()
{
  return Glib::PropertyProxy<bool>(this, "enable_arrows_always");
}

Glib::PropertyProxy<bool> Combo::property_case_sensitive()
{
  return Glib::PropertyProxy<bool>(this, "case_sensitive");
}

Glib::PropertyProxy<bool> Combo::property_allow_empty()
{
  return Glib::PropertyProxy<bool>(this, "allow_empty");
}

Glib::PropertyProxy<bool> Combo::property_value_in_list()
{
  return Glib::PropertyProxy<bool>(this, "value_in_list");
}


} // namespace Gtk

