
#include <gtkmm/fontselection.h>
#include <gtkmm/private/fontselection_p.h>

// -*- c++ -*-
/* $Id: fontselection.ccg,v 1.15 2002/04/09 20:53:26 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

//#include <gdkmm/font.h>
#include <gtkmm/box.h>
#include <gtkmm/button.h>
#include <gtkmm/entry.h>
#include <gtkmm/label.h>
#include <gtkmm/radiobutton.h>
#include <gtk/gtkfontsel.h>

namespace Gtk
{

FontSelectionDialog::FontSelectionDialog()
:
  Gtk::Dialog(reinterpret_cast<GtkDialog*>(g_object_new(get_type(), 0)))
{
}

FontSelectionDialog::FontSelectionDialog(const Glib::ustring& title)
:
  Gtk::Dialog(reinterpret_cast<GtkDialog*>(g_object_new(get_type(), 0)))
{
  set_title(title);
}

} /* namespace Gtk */


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::FontSelection* wrap(GtkFontSelection* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::FontSelection *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType FontSelection_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_font_selection_get_type(), "gtkmm__FontSelection", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void FontSelection_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* FontSelection_Class::wrap_new(GObject* o)
{
  return manage(new FontSelection((GtkFontSelection*)(o)));
}


/* The implementation: */

FontSelection::FontSelection(GtkFontSelection* castitem)
: Gtk::VBox((GtkVBox*)(castitem))
{}

FontSelection::~FontSelection()
{
  destroy_();
}

FontSelection::CppClassType FontSelection::fontselection_class_; //Initialize static member.

GType FontSelection::get_type()
{
  return fontselection_class_.get_type();
}

GType FontSelection::get_base_type()
{
  return gtk_font_selection_get_type();
}

FontSelection::FontSelection()
: Gtk::VBox((GtkVBox*)(g_object_new(get_type(), (char*)0)))
{}

Glib::ustring FontSelection::get_font_name() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_font_selection_get_font_name(const_cast<GtkFontSelection*>(gobj())));
}

bool FontSelection::set_font_name(const Glib::ustring& fontname)
{
  return gtk_font_selection_set_font_name(gobj(), fontname.c_str());
}

Glib::ustring FontSelection::get_preview_text() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_font_selection_get_preview_text(const_cast<GtkFontSelection*>(gobj())));
}

void FontSelection::set_preview_text(const Glib::ustring& fontname)
{
  gtk_font_selection_set_preview_text(gobj(), fontname.c_str());
}

Entry* FontSelection::get_font_entry()
{
  return Glib::wrap((GtkEntry*)(gobj()->font_entry));
}

const Entry* FontSelection::get_font_entry() const
{
  return Glib::wrap((GtkEntry*)(gobj()->font_entry));
}

Entry* FontSelection::get_font_style_entry()
{
  return Glib::wrap((GtkEntry*)(gobj()->font_style_entry));
}

const Entry* FontSelection::get_font_style_entry() const
{
  return Glib::wrap((GtkEntry*)(gobj()->font_style_entry));
}

Entry* FontSelection::get_size_entry()
{
  return Glib::wrap((GtkEntry*)(gobj()->size_entry));
}

const Entry* FontSelection::get_size_entry() const
{
  return Glib::wrap((GtkEntry*)(gobj()->size_entry));
}

RadioButton* FontSelection::get_pixels_button()
{
  return Glib::wrap((GtkRadioButton*)(gobj()->pixels_button));
}

const RadioButton* FontSelection::get_pixels_button() const
{
  return Glib::wrap((GtkRadioButton*)(gobj()->pixels_button));
}

RadioButton* FontSelection::get_points_button()
{
  return Glib::wrap((GtkRadioButton*)(gobj()->points_button));
}

const RadioButton* FontSelection::get_points_button() const
{
  return Glib::wrap((GtkRadioButton*)(gobj()->points_button));
}

Button* FontSelection::get_filter_button()
{
  return Glib::wrap((GtkButton*)(gobj()->filter_button));
}

const Button* FontSelection::get_filter_button() const
{
  return Glib::wrap((GtkButton*)(gobj()->filter_button));
}

Entry* FontSelection::get_preview_entry()
{
  return Glib::wrap((GtkEntry*)(gobj()->preview_entry));
}

const Entry* FontSelection::get_preview_entry() const
{
  return Glib::wrap((GtkEntry*)(gobj()->preview_entry));
}


Glib::PropertyProxy<Glib::ustring> FontSelection::property_font_name()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "font_name");
}

Glib::PropertyProxy<Glib::ustring> FontSelection::property_preview_text()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "preview_text");
}


} // namespace Gtk


namespace Glib
{

Gtk::FontSelectionDialog* wrap(GtkFontSelectionDialog* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::FontSelectionDialog *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType FontSelectionDialog_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_font_selection_dialog_get_type(), "gtkmm__FontSelectionDialog", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void FontSelectionDialog_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* FontSelectionDialog_Class::wrap_new(GObject* o)
{
  return manage(new FontSelectionDialog((GtkFontSelectionDialog*)(o)));
}


/* The implementation: */

FontSelectionDialog::FontSelectionDialog(GtkFontSelectionDialog* castitem)
: Gtk::Dialog((GtkDialog*)(castitem))
{}

FontSelectionDialog::~FontSelectionDialog()
{
  destroy_();
}

FontSelectionDialog::CppClassType FontSelectionDialog::fontselectiondialog_class_; //Initialize static member.

GType FontSelectionDialog::get_type()
{
  return fontselectiondialog_class_.get_type();
}

GType FontSelectionDialog::get_base_type()
{
  return gtk_font_selection_dialog_get_type();
}

bool FontSelectionDialog::set_font_name(const Glib::ustring& fontname)
{
  return gtk_font_selection_dialog_set_font_name(gobj(), fontname.c_str());
}

Glib::ustring FontSelectionDialog::get_font_name() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_font_selection_dialog_get_font_name(const_cast<GtkFontSelectionDialog*>(gobj())));
}

Glib::ustring FontSelectionDialog::get_preview_text()
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_font_selection_dialog_get_preview_text(gobj()));
}

void FontSelectionDialog::set_preview_text(const Glib::ustring& fontname)
{
  gtk_font_selection_dialog_set_preview_text(gobj(), fontname.c_str());
}

FontSelection* FontSelectionDialog::get_font_selection()
{
  return Glib::wrap((GtkFontSelection*)(gobj()->fontsel));
}

const FontSelection* FontSelectionDialog::get_font_selection() const
{
  return Glib::wrap((GtkFontSelection*)(gobj()->fontsel));
}

Button* FontSelectionDialog::get_ok_button()
{
  return Glib::wrap((GtkButton*)(gobj()->ok_button));
}

const Button* FontSelectionDialog::get_ok_button() const
{
  return Glib::wrap((GtkButton*)(gobj()->ok_button));
}

Button* FontSelectionDialog::get_apply_button()
{
  return Glib::wrap((GtkButton*)(gobj()->apply_button));
}

const Button* FontSelectionDialog::get_apply_button() const
{
  return Glib::wrap((GtkButton*)(gobj()->apply_button));
}

Button* FontSelectionDialog::get_cancel_button()
{
  return Glib::wrap((GtkButton*)(gobj()->cancel_button));
}

const Button* FontSelectionDialog::get_cancel_button() const
{
  return Glib::wrap((GtkButton*)(gobj()->cancel_button));
}


} // namespace Gtk

