
#include <gtkmm/imagemenuitem.h>
#include <gtkmm/private/imagemenuitem_p.h>

// -*- c++ -*-
/* $Id: imagemenuitem.ccg,v 1.6 2002/04/02 13:25:17 daniel Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkimagemenuitem.h>

#include <gtkmm/image.h>
#include <gtkmm/stock.h>
#include <gtkmm/accellabel.h>

namespace Gtk
{

ImageMenuItem::ImageMenuItem(const Glib::ustring& label,
			      bool mnemonic = false) :
  Gtk::MenuItem((GtkMenuItem*) g_object_new(get_type(), (char*)0))
{
  add_accel_label(label, mnemonic);
}
  
ImageMenuItem::ImageMenuItem(const Gtk::StockID& stock_id):
  Gtk::MenuItem((GtkMenuItem*) g_object_new(get_type(), (char*)0))
{
  Gtk::Image* image = new Gtk::Image(stock_id.get_string(), ICON_SIZE_MENU);

  set_image( *(Gtk::manage(image)) );

  Gtk::StockItem item;
  if(Gtk::Stock::lookup(stock_id.get_string(), item))
  {
    add_accel_label(item.get_label(), true); //true = use mnemonic.
    accel_key_ = Menu_Helpers::AccelKey(item.get_modifier(), item.get_keyval());
  }
  else
  {
    add_accel_label(stock_id.get_string(), false);
  }
}

} /* namespace */


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::ImageMenuItem* wrap(GtkImageMenuItem* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::ImageMenuItem *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType ImageMenuItem_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_image_menu_item_get_type(), "gtkmm__ImageMenuItem", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void ImageMenuItem_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* ImageMenuItem_Class::wrap_new(GObject* o)
{
  return manage(new ImageMenuItem((GtkImageMenuItem*)(o)));
}


/* The implementation: */

ImageMenuItem::ImageMenuItem(GtkImageMenuItem* castitem)
: Gtk::MenuItem((GtkMenuItem*)(castitem))
{}

ImageMenuItem::~ImageMenuItem()
{
  destroy_();
}

ImageMenuItem::CppClassType ImageMenuItem::imagemenuitem_class_; //Initialize static member.

GType ImageMenuItem::get_type()
{
  return imagemenuitem_class_.get_type();
}

GType ImageMenuItem::get_base_type()
{
  return gtk_image_menu_item_get_type();
}

ImageMenuItem::ImageMenuItem()
: Gtk::MenuItem((GtkMenuItem*)(g_object_new(get_type(), (char*)0)))
{}

void ImageMenuItem::set_image(Widget& image)
{
  gtk_image_menu_item_set_image(gobj(), (image).Gtk::Widget::gobj());
}

Widget* ImageMenuItem::get_image() const
{
  return Glib::wrap(gtk_image_menu_item_get_image(const_cast<GtkImageMenuItem*>(gobj())));
}


} // namespace Gtk

