
#include <gtkmm/menu.h>
#include <gtkmm/private/menu_p.h>

// -*- c++ -*-
/* $Id: menu.ccg,v 1.9 2001/12/04 15:56:30 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkdnd.h>
#include <gtk/gtkmenu.h>
#include <gtkmm/accelgroup.h>

namespace Gtk
{

void 
Menu::popup(GtkMenuPositionFunc func,
				      gpointer data,
				      guint button,
				      guint32 activate_time)
{
  gtk_menu_popup(gobj(), 0, 0,
	   func, data, button, activate_time);
}

void
Menu::popup(guint button, guint32 activate_time)
{
  gtk_menu_popup(gobj(), 0, 0, 0, 0, button, activate_time);
}


void
Menu::reorder_child(const MenuItem &child, int position)
{
  gtk_menu_reorder_child(gobj(),
		   const_cast<GtkWidget*>(GTK_WIDGET(child.gobj())),
		   position);
}

void Menu::unset_accel_group()
{
  gtk_menu_set_accel_group(gobj(), 0);
}

void Menu::remove_title()
{
  gtk_menu_set_title(gobj(), 0);
}

} /* namespace Gtk */


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::Menu* wrap(GtkMenu* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Menu *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Menu_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_menu_get_type(), "gtkmm__Menu", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Menu_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Menu_Class::wrap_new(GObject* o)
{
  return manage(new Menu((GtkMenu*)(o)));
}


/* The implementation: */

Menu::Menu(GtkMenu* castitem)
: Gtk::MenuShell((GtkMenuShell*)(castitem))
{}

Menu::~Menu()
{
  destroy_();
}

Menu::CppClassType Menu::menu_class_; //Initialize static member.

GType Menu::get_type()
{
  return menu_class_.get_type();
}

GType Menu::get_base_type()
{
  return gtk_menu_get_type();
}

Menu::Menu()
: Gtk::MenuShell((GtkMenuShell*)(g_object_new(get_type(), (char*)0)))
{}

void Menu::popup(MenuShell& parent_menu_shell, MenuItem& parent_menu_item, GtkMenuPositionFunc func, gpointer data, guint button, guint32 activate_time)
{
  gtk_menu_popup(gobj(), (parent_menu_shell).Gtk::Widget::gobj(), (parent_menu_item).Gtk::Widget::gobj(), func, data, button, activate_time);
}

void Menu::reposition()
{
  gtk_menu_reposition(gobj());
}

void Menu::popdown()
{
  gtk_menu_popdown(gobj());
}

MenuItem* Menu::get_active()
{
  return Glib::wrap((GtkMenuItem*)(gtk_menu_get_active(gobj())));
}

void Menu::set_active(guint index)
{
  gtk_menu_set_active(gobj(), index);
}

void Menu::set_accel_group(const Glib::RefPtr<AccelGroup>& accel_group)
{
  gtk_menu_set_accel_group(gobj(), Glib::unwrap(accel_group));
}

Glib::RefPtr<AccelGroup> Menu::get_accel_group()
{
  return Glib::wrap(gtk_menu_get_accel_group(gobj()));
}

void Menu::set_accel_path(const Glib::ustring& accel_path)
{
  gtk_menu_set_accel_path(gobj(), accel_path.c_str());
}

void Menu::detach()
{
  gtk_menu_detach(gobj());
}

Widget* Menu::get_attach_widget()
{
  return Glib::wrap(gtk_menu_get_attach_widget(gobj()));
}

void Menu::set_tearoff_state(bool torn_off)
{
  gtk_menu_set_tearoff_state(gobj(), static_cast<int>(torn_off));
}

bool Menu::get_tearoff_state() const
{
  return gtk_menu_get_tearoff_state(const_cast<GtkMenu*>(gobj()));
}

void Menu::set_title(const Glib::ustring& title)
{
  gtk_menu_set_title(gobj(), title.c_str());
}

Glib::ustring Menu::get_title() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_menu_get_title(const_cast<GtkMenu*>(gobj())));
}

void Menu::attach_to_widget(Widget& widget, GtkMenuDetachFunc detacher)
{
  gtk_menu_attach_to_widget(gobj(), (widget).Gtk::Widget::gobj(), detacher);
}


Glib::PropertyProxy<Glib::ustring> Menu::property_tearoff_title()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "tearoff_title");
}


} // namespace Gtk

