
#include <gtkmm/messagedialog.h>
#include <gtkmm/private/messagedialog_p.h>

#include <gtk/gtktypebuiltins.h>
// -*- c++ -*-
/* $Id: messagedialog.ccg,v 1.10 2002/04/02 13:25:18 daniel Exp $ */

/* 
 *
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkmessagedialog.h>
#include <gtk/gtklabel.h>


namespace Gtk
{

MessageDialog::MessageDialog(const Glib::ustring& message,
                             MessageType type, ButtonsType buttons,
                             bool modal, bool use_separator)
:
  Gtk::Dialog((GtkDialog*) g_object_new(
      get_type(), "message_type", (GtkMessageType)type, "buttons", (GtkButtonsType)buttons, (char*)0))
{
  construct_(modal, use_separator);
  set_message(message);
}

MessageDialog::MessageDialog(Gtk::Window& parent, const Glib::ustring& message,
                             MessageType type, ButtonsType buttons,
                             bool modal, bool use_separator)
:
  Gtk::Dialog((GtkDialog*) g_object_new(
      get_type(), "message_type", (GtkMessageType)type, "buttons", (GtkButtonsType)buttons, (char*)0))
{
  construct_(modal, use_separator);
  set_transient_for(parent);
  set_message(message);
}

void MessageDialog::set_message(const Glib::ustring& message)
{
  // The label is really a <private> struct field.
  // There should really be a message property.

  gtk_label_set_text(GTK_LABEL(gobj()->label), message.c_str());
}

} // namespace Gtk


namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gtk::MessageType>::value_type()
{
  return gtk_message_type_get_type();
}

// static
GType Glib::Value<Gtk::ButtonsType>::value_type()
{
  return gtk_buttons_type_get_type();
}


namespace Glib
{

Gtk::MessageDialog* wrap(GtkMessageDialog* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::MessageDialog *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType MessageDialog_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_message_dialog_get_type(), "gtkmm__MessageDialog", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void MessageDialog_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* MessageDialog_Class::wrap_new(GObject* o)
{
  return manage(new MessageDialog((GtkMessageDialog*)(o)));
}


/* The implementation: */

MessageDialog::MessageDialog(GtkMessageDialog* castitem)
: Gtk::Dialog((GtkDialog*)(castitem))
{}

MessageDialog::~MessageDialog()
{
  destroy_();
}

MessageDialog::CppClassType MessageDialog::messagedialog_class_; //Initialize static member.

GType MessageDialog::get_type()
{
  return messagedialog_class_.get_type();
}

GType MessageDialog::get_base_type()
{
  return gtk_message_dialog_get_type();
}


} // namespace Gtk

