
#include <gtkmm/socket.h>
#include <gtkmm/private/socket_p.h>

// -*- c++ -*-
/* $Id: socket.ccg,v 1.2 2001/05/10 22:13:27 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtksocket.h>

namespace Gtk
{

}


namespace
{

const Glib::SignalProxyInfo Socket_signal_plug_added_info =
{
  "plug_added",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


gboolean Socket_signal_plug_removed_callback(GtkSocket*, void* data)
{
  using namespace Gtk;
  typedef SigC::Slot0<bool> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    return static_cast<int>(((*(SlotType::Proxy)(slot->proxy_))
        ( slot)));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}

gboolean Socket_signal_plug_removed_notify_callback(GtkSocket*, void* data)
{
  using namespace Gtk;
  typedef SigC::Slot0<void> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        ( slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}


const Glib::SignalProxyInfo Socket_signal_plug_removed_info =
{
  "plug_removed",
  (GCallback) &Socket_signal_plug_removed_callback,
  (GCallback) &Socket_signal_plug_removed_notify_callback
};

} // anonymous namespace


namespace Glib
{

Gtk::Socket* wrap(GtkSocket* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Socket *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Socket_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_socket_get_type(), "gtkmm__Socket", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Socket_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->plug_added = &plug_added_callback;
  klass->plug_removed = &plug_removed_callback;
}


void Socket_Class::plug_added_callback(GtkSocket* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_plug_added();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->plug_added)
      (*base->plug_added)(self);
  }
}

gboolean Socket_Class::plug_removed_callback(GtkSocket* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return static_cast<int>(obj->on_plug_removed());
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->plug_removed)
      (*base->plug_removed)(self);
  }

  typedef gboolean RType;
  return RType();
}


Glib::ObjectBase* Socket_Class::wrap_new(GObject* o)
{
  return manage(new Socket((GtkSocket*)(o)));
}


/* The implementation: */

Socket::Socket(GtkSocket* castitem)
: Gtk::Container((GtkContainer*)(castitem))
{}

Socket::~Socket()
{
  destroy_();
}

Socket::CppClassType Socket::socket_class_; //Initialize static member.

GType Socket::get_type()
{
  return socket_class_.get_type();
}

GType Socket::get_base_type()
{
  return gtk_socket_get_type();
}

Socket::Socket()
: Gtk::Container((GtkContainer*)(g_object_new(get_type(), (char*)0)))
{}

void Socket::add_id(GdkNativeWindow window_id)
{
  gtk_socket_add_id(gobj(), window_id);
}

GdkNativeWindow Socket::get_id() const
{
  return gtk_socket_get_id(const_cast<GtkSocket*>(gobj()));
}


Glib::SignalProxy0<void> Socket::signal_plug_added()
{
  return Glib::SignalProxy0<void>(this, &Socket_signal_plug_added_info);
}

Glib::SignalProxy0<bool> Socket::signal_plug_removed()
{
  return Glib::SignalProxy0<bool>(this, &Socket_signal_plug_removed_info);
}


void Gtk::Socket::on_plug_added()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->plug_added)
    (*base->plug_added)(gobj());
}

bool Gtk::Socket::on_plug_removed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->plug_removed)
    return (*base->plug_removed)(gobj());

  typedef bool RType;
  return RType();
}


} // namespace Gtk

