
#include <gtkmm/texttagtable.h>
#include <gtkmm/private/texttagtable_p.h>

// -*- c++ -*-
/* $Id: texttagtable.ccg,v 1.1 2001/10/22 17:44:02 murrayc Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


namespace
{


void TextTagTable_signal_tag_changed_callback(GtkTextTagTable*, GtkTextTag* p0,gboolean p1,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot2<void,const Glib::RefPtr<TextTag>&,bool> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::wrap(p0, true)
,p1
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo TextTagTable_signal_tag_changed_info =
{
  "tag_changed",
  (GCallback) &TextTagTable_signal_tag_changed_callback,
  (GCallback) &TextTagTable_signal_tag_changed_callback
};


void TextTagTable_signal_tag_added_callback(GtkTextTagTable*, GtkTextTag* p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,const Glib::RefPtr<TextTag>&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::wrap(p0, true)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo TextTagTable_signal_tag_added_info =
{
  "tag_added",
  (GCallback) &TextTagTable_signal_tag_added_callback,
  (GCallback) &TextTagTable_signal_tag_added_callback
};


void TextTagTable_signal_tag_removed_callback(GtkTextTagTable*, GtkTextTag* p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,const Glib::RefPtr<TextTag>&> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (Glib::wrap(p0, true)
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo TextTagTable_signal_tag_removed_info =
{
  "tag_removed",
  (GCallback) &TextTagTable_signal_tag_removed_callback,
  (GCallback) &TextTagTable_signal_tag_removed_callback
};

} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gtk::TextTagTable> wrap(GtkTextTagTable* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Gtk::TextTagTable>( dynamic_cast<Gtk::TextTagTable*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gtk
{


/* The *_Class implementation: */

GType TextTagTable_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_text_tag_table_get_type(), "gtkmm__TextTagTable", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void TextTagTable_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->tag_changed = &tag_changed_callback;
  klass->tag_added = &tag_added_callback;
  klass->tag_removed = &tag_removed_callback;
}


void TextTagTable_Class::tag_changed_callback(GtkTextTagTable* self, GtkTextTag* p0, gboolean p1)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_tag_changed(Glib::wrap(p0, true)
, p1
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->tag_changed)
      (*base->tag_changed)(self, p0, p1);
  }
}

void TextTagTable_Class::tag_added_callback(GtkTextTagTable* self, GtkTextTag* p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_tag_added(Glib::wrap(p0, true)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->tag_added)
      (*base->tag_added)(self, p0);
  }
}

void TextTagTable_Class::tag_removed_callback(GtkTextTagTable* self, GtkTextTag* p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_tag_removed(Glib::wrap(p0, true)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->tag_removed)
      (*base->tag_removed)(self, p0);
  }
}


Glib::ObjectBase* TextTagTable_Class::wrap_new(GObject* o)
{
  return new TextTagTable((GtkTextTagTable*)(o));
}


/* The implementation: */

GtkTextTagTable* TextTagTable::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<TextTagTable> TextTagTable::wrap_specific_type(GtkTextTagTable* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<TextTagTable> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    TextTagTable* pCppObject = dynamic_cast<TextTagTable*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<TextTagTable>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<TextTagTable>( new TextTagTable(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

TextTagTable::TextTagTable(GtkTextTagTable* castitem)
: Glib::Object((GObject*)(castitem))
{}

TextTagTable::~TextTagTable()
{
}

TextTagTable::CppClassType TextTagTable::texttagtable_class_; //Initialize static member.

GType TextTagTable::get_type()
{
  return texttagtable_class_.get_type();
}

GType TextTagTable::get_base_type()
{
  return gtk_text_tag_table_get_type();
}

TextTagTable::TextTagTable()
: Glib::Object((GObject*)(g_object_new(get_type(), (char*)0)))
{}

Glib::RefPtr<TextTagTable> TextTagTable::create()
{
  return Glib::RefPtr<TextTagTable>( new TextTagTable() );
}
void TextTagTable::add(const Glib::RefPtr<TextTag>& tag)
{
  gtk_text_tag_table_add(gobj(), Glib::unwrap(tag));
}

void TextTagTable::remove(const Glib::RefPtr<TextTag>& tag)
{
  gtk_text_tag_table_remove(gobj(), Glib::unwrap(tag));
}

Glib::RefPtr<TextTag> TextTagTable::lookup(const Glib::ustring& name)
{
  Glib::RefPtr<TextTag> retvalue = Glib::wrap(gtk_text_tag_table_lookup(gobj(), name.c_str()));
  if(!(retvalue.is_null()))
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

void TextTagTable::foreach(GtkTextTagTableForeach func, gpointer data)
{
  gtk_text_tag_table_foreach(gobj(), func, data);
}

int TextTagTable::get_size()
{
  return gtk_text_tag_table_get_size(gobj());
}


Glib::SignalProxy2<void,const Glib::RefPtr<TextTag>&,bool> TextTagTable::signal_tag_changed()
{
  return Glib::SignalProxy2<void,const Glib::RefPtr<TextTag>&,bool>(this, &TextTagTable_signal_tag_changed_info);
}

Glib::SignalProxy1<void,const Glib::RefPtr<TextTag>&> TextTagTable::signal_tag_added()
{
  return Glib::SignalProxy1<void,const Glib::RefPtr<TextTag>&>(this, &TextTagTable_signal_tag_added_info);
}

Glib::SignalProxy1<void,const Glib::RefPtr<TextTag>&> TextTagTable::signal_tag_removed()
{
  return Glib::SignalProxy1<void,const Glib::RefPtr<TextTag>&>(this, &TextTagTable_signal_tag_removed_info);
}


void Gtk::TextTagTable::on_tag_changed(const Glib::RefPtr<TextTag>& tag, bool size_changed)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->tag_changed)
    (*base->tag_changed)(gobj(),Glib::unwrap(tag),static_cast<int>(size_changed));
}

void Gtk::TextTagTable::on_tag_added(const Glib::RefPtr<TextTag>& tag)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->tag_added)
    (*base->tag_added)(gobj(),Glib::unwrap(tag));
}

void Gtk::TextTagTable::on_tag_removed(const Glib::RefPtr<TextTag>& tag)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->tag_removed)
    (*base->tag_removed)(gobj(),Glib::unwrap(tag));
}


} // namespace Gtk

