
#include <gtkmm/toolbar.h>
#include <gtkmm/private/toolbar_p.h>

#include <gtk/gtktypebuiltins.h>
// -*- c++ -*-
/* $Id: toolbar.ccg,v 1.23 2002/04/02 13:25:19 daniel Exp $ */

/* 
 *
 * Copyright 1998-1999 The Gtk-- Development Team
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glib.h>
#include <gtkmm/button.h>
#include <gtkmm/togglebutton.h>
#include <gtkmm/radiobutton.h>
#include <gtkmm/tooltips.h>
//#include <gtkmm/image.h>
#include <gtkmm/label.h>
#include <gtk/gtklabel.h>

namespace Gtk
{

namespace Toolbar_Helpers
{

/*********************************************************************
***** Item classes (This should be an easy and cool interface)
*********************************************************************/

Element::Element(const Element& other)
:
  type_                 (other.type_),
  widget_               (other.widget_),
  text_                 (other.text_),
  has_text_             (other.has_text_),
  stock_id_             (other.stock_id_),
  tooltip_text_         (other.tooltip_text_),
  tooltip_private_text_ (other.tooltip_private_text_),
  content_              (other.content_),
  callback_             (other.callback_),
  group_                (0)
{}

Element::Element(ToolbarChildType  type,
                                  Widget*         widget,
                                  const Glib::ustring& text,
                                  bool                 has_text,
                                  const Glib::ustring&  stock_id,
                                  const Glib::ustring& tooltip_text,
                                  const Glib::ustring& tooltip_private_text,
                                  Widget*         content,
                                  const Callback0&     callback)
:
  type_                 (type),
  widget_               (widget),
  text_                 (text),
  has_text_             (has_text),
  stock_id_             (stock_id),
  tooltip_text_         (tooltip_text),
  tooltip_private_text_ (tooltip_private_text),
  content_              (content),
  callback_             (callback),
  group_                (0)
{}

Element::Element(Widget&         widget,
                                  const Glib::ustring& tooltip_text,
                                  const Glib::ustring& tooltip_private_text)
:
  type_                 (TOOLBAR_CHILD_WIDGET),
  widget_               (&widget),
  text_                 (),
  has_text_             (false),
  stock_id_             (Glib::ustring()),
  tooltip_text_         (tooltip_text),
  tooltip_private_text_ (tooltip_private_text),
  content_              (0),
  callback_             (),
  group_                (0)
{}

Space::Space()
:
  Element(TOOLBAR_CHILD_SPACE,
          0,
          Glib::ustring(),
          false,
          Glib::ustring(),
          Glib::ustring(),
          Glib::ustring(),
          0,
          Callback0())
{}

StockElem::StockElem(const Glib::ustring& stock_id,
                     const Callback0&      callback,
                     const Glib::ustring&  tooltip_text,
                     const Glib::ustring&  tooltip_private_text)
:
  Element(TOOLBAR_CHILD_SPACE,
          0,
          Glib::ustring(),
          false,
          stock_id,
          tooltip_text,
          tooltip_private_text,
          0,
          callback)
{}

ButtonElem::ButtonElem(const Glib::ustring& text,
                                        Widget&         content,
                                        const Callback0&     callback,
                                        const Glib::ustring& tooltip_text,
                                        const Glib::ustring& tooltip_private_text)
:
  Element(TOOLBAR_CHILD_BUTTON,
          0,
          text,
          true,
          Glib::ustring(),
          tooltip_text,
          tooltip_private_text,
          &content,
          callback)
{}

ButtonElem::ButtonElem(const Glib::ustring& text,
                                        const Callback0&     callback,
                                        const Glib::ustring& tooltip_text,
                                        const Glib::ustring& tooltip_private_text)

:
  Element(TOOLBAR_CHILD_BUTTON,
          0,
          text,
          true,
          Glib::ustring(),
          tooltip_text,
          tooltip_private_text,
          0,
          callback)
{}

ButtonElem::ButtonElem(Widget&         content,
                                        const Callback0&     callback,
                                        const Glib::ustring& tooltip_text,
                                        const Glib::ustring& tooltip_private_text)
:
  Element(TOOLBAR_CHILD_BUTTON,
          0,
          Glib::ustring(),
          false,
          Glib::ustring(),
          tooltip_text,
          tooltip_private_text,
          &content,
          callback)
{}

ToggleElem::ToggleElem(const Glib::ustring& text,
                                        Widget&         content,
                                        const Callback0&     callback,
                                        const Glib::ustring& tooltip_text,
                                        const Glib::ustring& tooltip_private_text)
:
  Element(TOOLBAR_CHILD_TOGGLEBUTTON,
          0,
          text,
          true,
          Glib::ustring(),
          tooltip_text,
          tooltip_private_text,
          &content,
          callback)
{}

ToggleElem::ToggleElem(const Glib::ustring& text,
                                        const Callback0&     callback,
                                        const Glib::ustring& tooltip_text,
                                        const Glib::ustring& tooltip_private_text)
:
  Element(TOOLBAR_CHILD_TOGGLEBUTTON,
          0,
          text,
          true,
          Glib::ustring(),
          tooltip_text,
          tooltip_private_text,
          0,
          callback)
{}

ToggleElem::ToggleElem(Widget&         content,
                                        const Callback0&     callback,
                                        const Glib::ustring& tooltip_text,
                                        const Glib::ustring& tooltip_private_text)
:
  Element(TOOLBAR_CHILD_TOGGLEBUTTON,
          0,
          Glib::ustring(),
          false,
          Glib::ustring(),
          tooltip_text,
          tooltip_private_text,
          &content,
          callback)
{}

RadioElem::RadioElem(RadioButton::Group&  group,
                                      const Glib::ustring& text,
                                      Widget&         content,
                                      const Callback0&     callback,
                                      const Glib::ustring& tooltip_text,
                                      const Glib::ustring& tooltip_private_text)
:
  Element(TOOLBAR_CHILD_RADIOBUTTON,
          0,
          text,
          true,
          Glib::ustring(),
          tooltip_text,
          tooltip_private_text,
          &content,
          callback)
{
  group_ = &group;
}

RadioElem::RadioElem(RadioButton::Group&  group,
                                      const Glib::ustring& text,
                                      const Callback0&     callback,
                                      const Glib::ustring& tooltip_text,
                                      const Glib::ustring& tooltip_private_text)
:
  Element(TOOLBAR_CHILD_RADIOBUTTON,
          0,
          text,
          true,
          Glib::ustring(),
          tooltip_text,
          tooltip_private_text,
          0,
          callback)
{
  group_ = &group;
}

RadioElem::RadioElem(RadioButton::Group&  group,
                                      Widget&         content,
                                      const Callback0&     callback,
                                      const Glib::ustring& tooltip_text,
                                      const Glib::ustring& tooltip_private_text)
:
  Element(TOOLBAR_CHILD_RADIOBUTTON,
          0,
          Glib::ustring(),
          false,
          Glib::ustring(),
          tooltip_text,
          tooltip_private_text,
          &content,
          callback)
{
  group_ = &group;
}


/*********************************************************************
***** List properties
*********************************************************************/
typedef Glib::List_Iterator<Tool*> tool_iterator;

tool_iterator ToolList::insert(tool_iterator position, const Element& e)
{
  int pos = gparent()->num_children;

  // locate the items desired position
  if(position.node)
    pos = g_list_position(glist(), position.node);

  const char* text    = 0;
  const char* tooltip = 0;
  const char* tooltip_private = 0;
  Widget* w = NULL;

  if(e.has_text_)
    text = e.text_.c_str();

  if(!e.tooltip_text_.empty())
    tooltip = e.tooltip_text_.c_str();

  if(!e.tooltip_private_text_.empty())
    tooltip_private = e.tooltip_private_text_.c_str();

  // give item to gtk+
  if (e.stock_id_.get_string().empty ()) {
    w = Glib::wrap(
      gtk_toolbar_insert_element(gparent(),
                                 (GtkToolbarChildType)e.type_,
                                 ((e.widget_) ? e.widget_->gobj() : 0),
                                 text, tooltip, tooltip_private,
                                 ((e.content_) ? e.content_->gobj() : 0),
                                 0, 0,
                                 pos));
  } else {
    w = Glib::wrap(
      gtk_toolbar_insert_stock(gparent(),
                               e.stock_id_.get_string().c_str(),
                               tooltip, tooltip_private,
                               0, 0,
                               pos));
  }

  if(e.group_ && w)
  {
    RadioButton* rb = dynamic_cast<RadioButton*>(w);
    rb->set_group(*e.group_);
    *(e.group_) = rb->get_group(); // TODO: What is this for?
  }

  // connect slot
  if(e.callback_ && w)
  {
    if(Button* btn = dynamic_cast<Button*>(w))
      btn->signal_clicked().connect(e.callback_);
  }

  // return the right iterator
  if(pos == 0)
    return begin();

  if(!position.node)
    return --end();

  return --position;
}


tool_iterator ToolList::erase(tool_iterator position)
{
  if(!position.node)
    return end();

  iterator next = position;
  ++next;

  if((*position)->get_type() == TOOLBAR_CHILD_SPACE)
  {
    gtk_toolbar_remove_space(gparent(), g_list_position(glist(), position.node));
  }
  else
  {
    gtk_container_remove(
        reinterpret_cast<GtkContainer*>(gparent()),
        (*position)->get_widget()->gobj());
  }

  return next;
}

void ToolList::remove(const_reference t)
{
  erase(find(t));
}

void ToolList::remove(Widget& widget)
{
  gtk_container_remove(
      reinterpret_cast<GtkContainer*>(gparent()), widget.gobj());
}

ToolbarChildType Tool::get_type() const
{
  return (ToolbarChildType) type;
}

Widget* Tool::get_widget() const
{
  return Glib::wrap(widget);
}

Widget* Tool::get_content() const
{
  return Glib::wrap(icon);
}

Label* Tool::get_label() const
{
  return Glib::wrap(reinterpret_cast<GtkLabel*>(label));
}

} // namespace Toolbar_Helpers


Toolbar::ToolList& Toolbar::tools()
{
  tools_proxy_ = ToolList(gobj());
  return tools_proxy_;
}

const Toolbar::ToolList& Toolbar::tools() const
{
  tools_proxy_ =  ToolList(const_cast<GtkToolbar*>(gobj()));
  return tools_proxy_;
}

} // namespace Gtk


namespace
{


void Toolbar_signal_orientation_changed_callback(GtkToolbar*, GtkOrientation p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,Orientation> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (((Orientation)(p0))
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo Toolbar_signal_orientation_changed_info =
{
  "orientation_changed",
  (GCallback) &Toolbar_signal_orientation_changed_callback,
  (GCallback) &Toolbar_signal_orientation_changed_callback
};


void Toolbar_signal_style_changed_callback(GtkToolbar*, GtkToolbarStyle p0,void* data)
{
  using namespace Gtk;
  typedef SigC::Slot1<void,ToolbarStyle> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (((ToolbarStyle)(p0))
, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }
}

const Glib::SignalProxyInfo Toolbar_signal_style_changed_info =
{
  "style_changed",
  (GCallback) &Toolbar_signal_style_changed_callback,
  (GCallback) &Toolbar_signal_style_changed_callback
};

} // anonymous namespace

// static
GType Glib::Value<Gtk::ToolbarChildType>::value_type()
{
  return gtk_toolbar_child_type_get_type();
}


namespace Glib
{

Gtk::Toolbar* wrap(GtkToolbar* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gtk::Toolbar *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

GType Toolbar_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        gtype_ = g_type_register_static(gtk_toolbar_get_type(), "gtkmm__Toolbar", &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Toolbar_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->orientation_changed = &orientation_changed_callback;
  klass->style_changed = &style_changed_callback;
}


void Toolbar_Class::orientation_changed_callback(GtkToolbar* self, GtkOrientation p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_orientation_changed(((Orientation)(p0))
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->orientation_changed)
      (*base->orientation_changed)(self, p0);
  }
}

void Toolbar_Class::style_changed_callback(GtkToolbar* self, GtkToolbarStyle p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->on_style_changed(((ToolbarStyle)(p0))
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->style_changed)
      (*base->style_changed)(self, p0);
  }
}


Glib::ObjectBase* Toolbar_Class::wrap_new(GObject* o)
{
  return manage(new Toolbar((GtkToolbar*)(o)));
}


/* The implementation: */

Toolbar::Toolbar(GtkToolbar* castitem)
: Gtk::Container((GtkContainer*)(castitem))
{}

Toolbar::~Toolbar()
{
  destroy_();
}

Toolbar::CppClassType Toolbar::toolbar_class_; //Initialize static member.

GType Toolbar::get_type()
{
  return toolbar_class_.get_type();
}

GType Toolbar::get_base_type()
{
  return gtk_toolbar_get_type();
}


namespace Toolbar_Helpers
{

ToolList::iterator ToolList::find(const_reference w)
{
  iterator i = begin();
  for(i = begin(); i != end() && (*i != w); i++);
  return i;
}

ToolList::iterator ToolList::find(Widget& w)
{
  iterator i;
  for (i = begin(); i != end() && ((*i)->get_widget() != &w); i++);
  return i;
}

} /* namespace Toolbar_Helpers */


namespace Toolbar_Helpers
{

ToolList::ToolList()
{}

ToolList::ToolList(GtkToolbar* gparent)
: type_base((GObject*)gparent)
{}

ToolList::ToolList(const ToolList& src)
{
  operator=(src);
}

ToolList& ToolList::operator=(const ToolList& src)
{
  gparent_ = src.gparent_;
  return *this;
}

GList*& ToolList::glist() const
{
  return ((GtkToolbar*)gparent_)->children;
}

void ToolList::erase(iterator start, iterator stop)
{
  type_base::erase(start, stop);
}

GtkToolbar* ToolList::gparent()
{
  return (GtkToolbar*)type_base::gparent();
}

const GtkToolbar* ToolList::gparent() const
{
  return (GtkToolbar*)type_base::gparent();
}

ToolList::value_type ToolList::operator[](size_type l) const
{
  return type_base::operator[](l);
}

} /* namespace Toolbar_Helpers */

Toolbar::Toolbar()
: Gtk::Container((GtkContainer*)(g_object_new(get_type(), (char*)0)))
{}

Orientation Toolbar::get_orientation() const
{
  return ((Orientation)(gobj()->orientation));
}

void Toolbar::set_orientation(Orientation orientation)
{
  gtk_toolbar_set_orientation(gobj(), ((GtkOrientation)(orientation)));
}

ToolbarStyle Toolbar::get_style() const
{
  return ((ToolbarStyle)(gobj()->style));
}

void Toolbar::set_style(ToolbarStyle style)
{
  gtk_toolbar_set_style(gobj(), ((GtkToolbarStyle)(style)));
}

void Toolbar::set_tooltips(bool enable)
{
  gtk_toolbar_set_tooltips(gobj(), static_cast<int>(enable));
}


Glib::SignalProxy1<void,Orientation> Toolbar::signal_orientation_changed()
{
  return Glib::SignalProxy1<void,Orientation>(this, &Toolbar_signal_orientation_changed_info);
}

Glib::SignalProxy1<void,ToolbarStyle> Toolbar::signal_style_changed()
{
  return Glib::SignalProxy1<void,ToolbarStyle>(this, &Toolbar_signal_style_changed_info);
}


void Gtk::Toolbar::on_orientation_changed(Orientation orientation)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->orientation_changed)
    (*base->orientation_changed)(gobj(),((GtkOrientation)(orientation)));
}

void Gtk::Toolbar::on_style_changed(ToolbarStyle style)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->style_changed)
    (*base->style_changed)(gobj(),((GtkToolbarStyle)(style)));
}


} // namespace Gtk

