
#include <pangomm/fontmap.h>
#include <pangomm/private/fontmap_p.h>

// -*- c++ -*-
/* $Id: fontmap.ccg,v 1.3 2002/02/24 16:20:57 cactus Exp $ */

/* 
 *
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <pangomm/context.h>

namespace Pango
{

Glib::ArrayHandle < Glib::RefPtr<FontFamily >, FontFamilyRefPtrTraits > FontMap::list_families()
{
  //Get the array:
  PangoFontFamily** pFamilies = 0;
  int n_families = 0;
  pango_font_map_list_families(gobj(), &pFamilies, &n_families);

  return Glib::ArrayHandle< Glib::RefPtr<FontFamily>, FontFamilyRefPtrTraits >
      (pFamilies, n_families, Glib::OWNERSHIP_SHALLOW);
}

} /* namespace Pango */


namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Pango::FontMap> wrap(PangoFontMap* object, bool take_copy /* = false */)
{
  return Glib::RefPtr<Pango::FontMap>( dynamic_cast<Pango::FontMap*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Pango
{


/* The *_Class implementation: */

GType FontMap_Class::get_type()
  {
    gtype_ = pango_font_map_get_type(); //The actual struct definition is hidden, so we can not derive one.
    return gtype_;
  }


Glib::ObjectBase* FontMap_Class::wrap_new(GObject* o)
{
  return new FontMap((PangoFontMap*)(o));
}


/* The implementation: */

PangoFontMap* FontMap::gobj_copy()
{
  reference();
  return gobj();
}

Glib::RefPtr<FontMap> FontMap::wrap_specific_type(PangoFontMap* gobject, bool take_copy /* = false */) //static
{
  Glib::RefPtr<FontMap> refPtr;

  if(gobject)
  {
    //Check for an existing wrapper:
    FontMap* pCppObject = dynamic_cast<FontMap*>(Glib::ObjectBase::_get_current_wrapper(G_OBJECT(gobject)));
    if(pCppObject)
    {
      //Return the existing wrapper:
      refPtr = Glib::RefPtr<FontMap>(pCppObject);
    }
    else
    {
      //Create a new wrapper:
      refPtr = Glib::RefPtr<FontMap>( new FontMap(gobject) );
    }

    if(take_copy && refPtr)
      refPtr->reference();
  }

  return refPtr;
}

FontMap::FontMap(PangoFontMap* castitem)
: Glib::Object((GObject*)(castitem))
{}

FontMap::~FontMap()
{
}

FontMap::CppClassType FontMap::fontmap_class_; //Initialize static member.

GType FontMap::get_type()
{
  return fontmap_class_.get_type();
}

GType FontMap::get_base_type()
{
  return pango_font_map_get_type();
}

Glib::RefPtr<Font> FontMap::load_font(const Glib::RefPtr<Context>& context, const FontDescription& desc)
{
  return Glib::wrap(pango_font_map_load_font(gobj(), (context)->gobj(), (desc).gobj()));
}

Glib::RefPtr<Fontset> FontMap::load_fontset(const Glib::RefPtr<Context>& context, const FontDescription& desc, PangoLanguage* language)
{
  return Glib::wrap(pango_font_map_load_fontset(gobj(), (context)->gobj(), (desc).gobj(), language));
}


} // namespace Pango

