// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_EXPANDER_H
#define _GTKMM_EXPANDER_H


#include <glibmm.h>

/* $Id: expander.hg,v 1.6.4.1 2006/04/20 12:43:13 murrayc Exp $ */

/* expander.h
 * 
 * Copyright (C) 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/bin.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkExpander GtkExpander;
typedef struct _GtkExpanderClass GtkExpanderClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Expander_Class; } // namespace Gtk
namespace Gtk
{

/** A container which can hide its child.
 *
 * A Expander allows the user to hide or show its child by clicking on an
 * expander triangle similar to the triangles used in a Gtk::TreeView.
 *
 * @ingroup Widgets
 */

class Expander : public Bin
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Expander CppObjectType;
  typedef Expander_Class CppClassType;
  typedef GtkExpander BaseObjectType;
  typedef GtkExpanderClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Expander();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Expander_Class;
  static CppClassType expander_class_;

  // noncopyable
  Expander(const Expander&);
  Expander& operator=(const Expander&);

protected:
  explicit Expander(const Glib::ConstructParams& construct_params);
  explicit Expander(GtkExpander* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkExpander*       gobj()       { return reinterpret_cast<GtkExpander*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkExpander* gobj() const { return reinterpret_cast<GtkExpander*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

public:

  /** Creates a new Expander.
   *
   * The Expander has an empty label.
   * 
   * Since: 2.4
   */
  Expander();

  /** Creates a new Expander with a label.
   *
   * Creates a new expander using label as the text of the label. Settin @a mnemonic to true
   * will allow you to precede characters in the label with an underscore which will make them
   * underlined. If you need a literal underscore character in a label, use '__' (two underscores).
   * The first underlined character represents a keyboard accelerator called a mnemonic.
   * Pressing Alt and that key activates the button.
   * 
   * @param label The string for the label describing the Expander.
   * @param mnemonic Wether the label may contain underscores to set up accelerators.
   
   * Since: 2.4
   */
  explicit Expander(const Glib::ustring& label, bool mnemonic = false);
  

  /** Sets the state of the expander. Set to <tt>true</tt>, if you want
   * the child widget to be revealed, and <tt>false</tt> if you want the
   * child widget to be hidden.
   * 
   * @newin2p4
   * @param expanded Whether the child widget is revealed.
   */
  void set_expanded(bool expanded = true);
  
  /** Queries a Gtk::Expander and returns its current state. Returns <tt>true</tt>
   * if the child widget is revealed.
   * 
   * See set_expanded().
   * @return The current state of the expander.
   * 
   * @newin2p4.
   */
  bool get_expanded() const;

  
  /** Sets the spacing field of @a expander , which is the number of pixels to
   * place between expander and the child.
   * 
   * @newin2p4
   * @param spacing Distance between the expander and child in pixels.
   */
  void set_spacing(int spacing);
  
  /** Gets the value set by set_spacing().
   * @return Spacing between the expander and child.
   * 
   * @newin2p4.
   */
  int get_spacing() const;

  
  /** Sets the text of the label of the expander to @a label .
   * 
   * This will also clear any previously set labels.
   * 
   * @newin2p4
   * @param label A string.
   */
  void set_label(const Glib::ustring& label);
  
  /** Fetches the text from the label of the expander, as set by
   * set_label(). If the label text has not
   * been set the return value will be <tt>0</tt>. This will be the
   * case if you create an empty button with Gtk::Button::new() to
   * use as a container.
   * @return The text of the label widget. This string is owned
   * by the widget and must not be modified or freed.
   * 
   * @newin2p4.
   */
  Glib::ustring get_label() const;

  
  /** If true, an underline in the text of the expander label indicates
   * the next character should be used for the mnemonic accelerator key.
   * 
   * @newin2p4
   * @param use_underline <tt>true</tt> if underlines in the text indicate mnemonics.
   */
  void set_use_underline(bool use_underline = true);
  
  /** Returns whether an embedded underline in the expander label indicates a
   * mnemonic. See set_use_underline().
   * @return <tt>true</tt> if an embedded underline in the expander label
   * indicates the mnemonic accelerator keys.
   * 
   * @newin2p4.
   */
  bool get_use_underline() const;

  
  /** Sets whether the text of the label contains markup in Pango's text markup
   * language. See Gtk::Label::set_markup().
   * 
   * @newin2p4
   * @param use_markup <tt>true</tt> if the label's text should be parsed for markup.
   */
  void set_use_markup(bool use_markup = true);
  
  /** Returns whether the label's text is interpreted as marked up with
   * the Pango text markup
   * language. See set_use_markup().
   * @return <tt>true</tt> if the label's text will be parsed for markup
   * 
   * @newin2p4.
   */
  bool get_use_markup() const;

  
  /** Set the label widget for the expander. This is the widget
   * that will appear embedded alongside the expander arrow.
   * 
   * @newin2p4
   * @param label_widget The new label widget.
   */
  void set_label_widget(Widget& label_widget);
  
  /** Retrieves the label widget for the frame. See
   * set_label_widget().
   * @return The label widget, or <tt>0</tt> if there is none.
   * 
   * @newin2p4.
   */
  Widget* get_label_widget();
  
  /** Retrieves the label widget for the frame. See
   * set_label_widget().
   * @return The label widget, or <tt>0</tt> if there is none.
   * 
   * @newin2p4.
   */
  const Widget* get_label_widget() const;

   //keybinding

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the expander has been opened to reveal the child widget.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_expanded() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the expander has been opened to reveal the child widget.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_expanded() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Text of the expander's label.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_label() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Text of the expander's label.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_label() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If set
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_use_underline() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** If set
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_use_underline() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The text of the label includes XML markup. See pango_parse_markup.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_use_markup() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The text of the label includes XML markup. See pango_parse_markup.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_use_markup() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Space to put between the label and the child.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_spacing() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Space to put between the label and the child.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_spacing() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** A widget to display in place of the usual expander label.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Widget*> property_label_widget() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** A widget to display in place of the usual expander label.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Widget*> property_label_widget() const;
#endif //#GLIBMM_PROPERTIES_ENABLED
            

};


} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::Expander
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Gtk::Expander* wrap(GtkExpander* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_EXPANDER_H */

