// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_RGBA_H
#define _GDKMM_RGBA_H


#include <glibmm.h>

/* Copyright (C) 2010 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdk/gdk.h> //TODO: Remove this?


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _GdkRGBA GdkRGBA; }
#endif

namespace Gdk
{

/** TODO
 */
class RGBA
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef RGBA CppObjectType;
  typedef GdkRGBA BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  explicit RGBA(GdkRGBA* gobject, bool make_a_copy = true);

  RGBA(const RGBA& other);
  RGBA& operator=(const RGBA& other);

  ~RGBA();

  void swap(RGBA& other);

  ///Provides access to the underlying C instance.
  GdkRGBA*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const GdkRGBA* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  GdkRGBA* gobj_copy() const;

protected:
  GdkRGBA* gobject_;

private:

  
public:

  
  /** Instantiate a new Gdk::RGBA.
   */
  RGBA();

  /** Instantiate a new Gdk::RGBA.
   * The text string can be in any of the forms accepted by XParseRGBA; these include names for a color from rgb.txt,
   * such as DarkSlateGray, or a hex specification such as 305050.
   * @param value the string specifying the color..
   */
  explicit RGBA(const Glib::ustring& value);
  

  /** Set a grey color, by using the same value for all color components.
   * @param value The value to be used for the red, green, and blue components.
   */
  void set_grey(gushort value);
  void set_grey_p(double g);

  /** Set the color, by specifying red, green, and blue color component values.
   * @param red_ The red component of the color.
   * @param green_ The green component of the color.
   * @param blue_ The blue component of the color.
   */
  void set_rgb(gushort red_, gushort green_, gushort blue_);

  /** Set the color, by specifying red, green, and blue color component values, as percentages.
   * @param red_ The red component of the color, as a percentage.
   * @param green_ The green component of the color, as a percentage.
   * @param blue_ The blue component of the color, as a percentage.
   */
  void set_rgb_p(double red_, double green_, double blue_);

  void set_hsv(double h, double s, double v);
  void set_hsl(double h, double s, double l);

  
  bool set(const Glib::ustring& value);

  /** Get the red component of the color.
   * @result The red component of the color.
   */
  gushort get_red() const;

  /** Get the green component of the color.
   * @result The green component of the color.
   */
  gushort get_green() const;

  /** Get the blue component of the color.
   * @result The blue component of the color.
   */
  gushort get_blue() const;

  /** Set the red component of the color.
   * @param value The red component of the color.
   */
  void set_red(gushort value);

  /** Set the green component of the color.
   * @param value The green component of the color.
   */
  void set_green(gushort value);

  /** Set the blue component of the color.
   * @param value The blue component of the color.
   */
  void set_blue(gushort value);


  /** Get the red component of the color, as a percentage.
   * @result The red component of the color, as a percentage.
   */
  double get_red_p() const;

  /** Get the green component of the color, as a percentage.
   * @result The green component of the color, as a percentage.
   */
  double get_green_p() const;

  /** Get the blue component of the color, as a percentage.
   * @result The blue component of the color, as a percentage.
   */
  double get_blue_p() const;

  
  Glib::ustring to_string() const;


};


#ifndef DOXYGEN_SHOULD_SKIP_THIS
/* These traits are for arrays of GdkRGBA structs -- not pointer arrays.
 */
struct RGBATraits
{
  typedef Gdk::RGBA  CppType;
  typedef GdkRGBA    CType;
  typedef GdkRGBA    CTypeNonConst;

  static CType   to_c_type      (const CppType& obj) { return *obj.gobj(); }
  static CType   to_c_type      (const CType&   obj) { return obj; }
  static CppType to_cpp_type    (const CType&   obj) { return CppType(const_cast<CType*>(&obj), true); }
  static void    release_c_type (const CType&)       {}
};
#endif //DOXYGEN_SHOULD_SKIP_THIS

typedef Glib::ArrayHandle<RGBA,RGBATraits> ArrayHandle_RGBA;

} // namespace Gdk


namespace Gdk
{

/** @relates Gdk::RGBA
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
bool operator==(const RGBA& lhs, const RGBA& rhs);

/** @relates Gdk::RGBA
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 * @result The result
 */
bool operator!=(const RGBA& lhs, const RGBA& rhs);


} // namespace Gdk


namespace Gdk
{

/** @relates Gdk::RGBA
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(RGBA& lhs, RGBA& rhs)
  { lhs.swap(rhs); }

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 * 
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::RGBA
 */
Gdk::RGBA wrap(GdkRGBA* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::RGBA> : public Glib::Value_Boxed<Gdk::RGBA>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _GDKMM_RGBA_H */

