/*
 *  Copyright (C) 2005 Robert Staudinger
 *
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GTK_MOZ_EDIT_H__
#define __GTK_MOZ_EDIT_H__

#include <glib.h>
#include <glib-object.h>
#include <glib/gmacros.h>
#include <gtk/gtk.h>
#include <gtkmozedit/gme-web-browser.h>

G_BEGIN_DECLS

#define GTK_TYPE_MOZ_EDIT                  (gtk_moz_edit_get_gtype ())
#define GTK_MOZ_EDIT(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_MOZ_EDIT, GtkMozEdit))
#define GTK_MOZ_EDIT_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_MOZ_EDIT, GtkMozEditClass))
#define GTK_IS_MOZ_EDIT(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_MOZ_EDIT))
#define GTK_IS_MOZ_EDIT_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_MOZ_EDIT))
#define GTK_MOZ_EDIT_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_MOZ_EDIT, GtkMozEditClass))

typedef struct _GtkMozEditClass GtkMozEditClass;

GtkWidget *gtk_moz_edit_new 	 (void);
GType	   gtk_moz_edit_get_gtype (void);
gboolean   gtk_moz_edit_command  (GtkMozEdit *self, const gchar *cmd, const gchar *val);
void 	   gtk_moz_edit_load (GtkMozEdit *self, const gchar *url);
gboolean   gtk_moz_edit_save (GtkMozEdit *self, const gchar *filename, gboolean save_files);

GmeWebBrowser* gtk_moz_edit_get_web_browser (GtkMozEdit *self);

G_END_DECLS

#endif /* __GTK_MOZ_EDIT_H__ */
