/*
 * beagle-util.h
 *
 * Copyright (C) 2005 Novell, Inc.
 *
 */

/*
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __BEAGLE_UTIL_H
#define __BEAGLE_UTIL_H

#include <glib.h>

#define BEAGLE_ERROR (beagle_error_quark ())

typedef enum {
	BEAGLE_ERROR_DAEMON_ERROR
} BeagleError;

GQuark beagle_error_quark (void);

gboolean beagle_util_is_path_on_block_device (const char *path);

const gchar *beagle_util_get_home_dir ();
const gchar *beagle_util_get_socket_dir ();
gchar *beagle_util_get_socket_path (const char *client_name);

gboolean beagle_util_daemon_is_running (void);

#endif /* __BEAGLE_UTIL_H */

