// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_ENTITY_H
#define _LIBGDAMM_ENTITY_H


#include <glibmm.h>

/* $Id: entity.hg,v 1.1 2006/11/08 00:07:37 murrayc Exp $ */
// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* entity.h
 *
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/object.h>
#include <libgdamm/dicttype.h>
#include <libgdamm/entityfield.h>
#include <glibmm/object.h>
#include <libgda/gda-entity.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaEntity GdaEntity;
typedef struct _GdaEntityClass GdaEntityClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class Entity_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{


class Entity : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Entity CppObjectType;
  typedef Entity_Class CppClassType;
  typedef GdaEntity BaseObjectType;
  typedef GdaEntityIface BaseClassType;

private:
  friend class Entity_Class;
  static CppClassType entity_class_;

  // noncopyable
  Entity(const Entity&);
  Entity& operator=(const Entity&);

protected:
  Entity(); // you must derive from this class
  explicit Entity(GdaEntity* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Entity();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaEntity*       gobj()       { return reinterpret_cast<GdaEntity*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GdaEntity* gobj() const { return reinterpret_cast<GdaEntity*>(gobject_); }

private:

protected:

public:

  
  /** Tells if @a field  belongs to the @a iface  entity
   * @param field An object implementing the Gda::EntityField interface.
   * @return <tt>true</tt> if @a field  belongs to the @a iface  entity.
   */
  bool has_field(const Glib::RefPtr<EntityField>& field) const;
  
  /** Get a new list containing all the Gda::EntityField objects held within the object
   * implementing the Gda::Entity interface.
   * 
   * The returned list nodes are in the order in which the fields are within the entity.
   * @return The new list.
   */
  GSList* get_fields();
  
  /** Get the number of fields in @a iface 
   * @return The number of fields, or -1 if an error occurred.
   */
  int get_n_fields() const;

  
  /** Get a Gda::EntityField using its name. The notion of "field name" is the
   * string returned by Gda::EntityField::get_name() on each of the fields composing @a iface .
   * However, if that definition does not return any field, then each particular
   * implementation of @a iface  may try to give an extra definition to the notion of 
   * "field name".
   * 
   * For instance, in the case of the Gda::Query object, the  Gda::EntityField::get_name() is used
   * as a first try to find a field, and if that fails, then the object tries to find
   * fields from their SQL naming.
   * 
   * In the case where there can be more than one field with the same name (depending on
   *  @a iface 's implementation), then the returned value is <tt>0</tt>.
   * @return The requested Gda::EntityField or <tt>0</tt> if the field cannot be found, or if
   * more than one field has been found.
   */
  Glib::RefPtr<EntityField> get_field_by_name(const Glib::ustring& name);
  
  /** Get a Gda::EntityField using its name. The notion of "field name" is the
   * string returned by Gda::EntityField::get_name() on each of the fields composing @a iface .
   * However, if that definition does not return any field, then each particular
   * implementation of @a iface  may try to give an extra definition to the notion of 
   * "field name".
   * 
   * For instance, in the case of the Gda::Query object, the  Gda::EntityField::get_name() is used
   * as a first try to find a field, and if that fails, then the object tries to find
   * fields from their SQL naming.
   * 
   * In the case where there can be more than one field with the same name (depending on
   *  @a iface 's implementation), then the returned value is <tt>0</tt>.
   * @return The requested Gda::EntityField or <tt>0</tt> if the field cannot be found, or if
   * more than one field has been found.
   */
  Glib::RefPtr<const EntityField> get_field_by_name(const Glib::ustring& name) const;

  
  /** 
   * @return The requested GdaEntityField.
   */
  Glib::RefPtr<EntityField> get_field_by_xml_id(const Glib::ustring& xml_id);
  
  /** 
   * @return The requested GdaEntityField.
   */
  Glib::RefPtr<const EntityField> get_field_by_xml_id(const Glib::ustring& xml_id) const;

  
  /** 
   * @return The requested GdaEntityField or <tt>0</tt> if the index is out of bounds.
   */
  Glib::RefPtr<EntityField> get_field_by_index(int index);
  
  /** 
   * @return The requested GdaEntityField or <tt>0</tt> if the index is out of bounds.
   */
  Glib::RefPtr<const EntityField> get_field_by_index(int index) const;

  
  /** Get the position of the field in the given entity. Positions start at 0.
   *  @a field  MUST be a visible field.
   * @param field An object implementing the Gda::EntityField interface.
   * @return The position or -1 if the field is not in the entity or is not visible.
   */
  int get_field_index(const Glib::RefPtr<const EntityField>& field) const;
  
  /** Add @a field  to @a iface 's fields (at the end of the list)
   * @param field An object implementing the Gda::EntityField interface to add.
   */
  void add_field(const Glib::RefPtr<EntityField>& field);
  
  /** Add @a field  to @a iface 's fields, before @a field_before  if it is not <tt>0</tt>, 
   * or at the end if @a field_before  is <tt>0</tt>.
   * @param field An object implementing the Gda::EntityField interface to add.
   * @param field_before An object implementing the Gda::EntityField interface before which @a field  will be added, or <tt>0</tt>.
   */
  void add_field_before(const Glib::RefPtr<EntityField>& field, const Glib::RefPtr<EntityField>& field_before);
  
  /** 
   * @param field1 An object implementing the Gda::EntityField interface.
   * @param field2 An object implementing the Gda::EntityField interface.
   */
  void swap_fields(const Glib::RefPtr<EntityField>& field1, const Glib::RefPtr<EntityField>& field2);
  
  /** 
   * @param field An object implementing the Gda::EntityField interface to remove.
   */
  void remove_field(const Glib::RefPtr<EntityField>& field);

  
  /** Tells if the real entity (the corresponding DBMS object) represented by @a iface  can be written to.
   * @return <tt>true</tt> if it is possible to write to @a iface .
   */
  bool is_writable() const;


  //TODO: vfuncs and signals.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** @relates Gnome::Gda::Entity
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Glib::RefPtr<Gnome::Gda::Entity> wrap(GdaEntity* object, bool take_copy = false);

} // namespace Glib


#endif /* _LIBGDAMM_ENTITY_H */

