#define __TESTPRINT_C__

/*
 * libgnomeprintui test program
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors:
 *   Unknown author
 *   Lauris Kaplinski <lauris@helixcode.com>
 *
 * Copyright 2000-2001 Ximian, Inc. and authors
 *
 */

#include <popt-gnome.h>
#include <gtk/gtk.h>
#include <libgnomeprint/gnome-print-meta.h>
#include <libgnomeprintui/gnome-print-i18n.h>
#include <libgnomeprintui/gnome-print-preview.h>
#include <libgnomeprintui/gnome-print-master-preview.h>
#include <libgnomeprintui/gnome-font-dialog.h>
#include <libgnomeprintui/gnome-printer-dialog.h>
#include <libgnomeprintui/gnome-print-dialog.h>

#define dpi 72

static gboolean font_dialog = FALSE;
static gboolean printer_dialog = FALSE;
static gboolean print_dialog = FALSE;
static gboolean master_preview = FALSE;
static gchar *metafile = NULL;

static struct poptOption options[] = {
	{ "metafile", 'm', POPT_ARG_STRING, &metafile, 0, "Render from metafile", N_("PATH")},
	{ "font-dialog", 'f', POPT_ARG_NONE, &font_dialog, 0, "Bring up font dialog", NULL},
	{ "printer-dialog", 'p', POPT_ARG_NONE, &printer_dialog, 0, "Bring up printer dialog", NULL},
	{ "print-dialog", 'd', POPT_ARG_NONE, &print_dialog, 0, "Bring up print dialog", NULL},
	{ "master-preview", 0, POPT_ARG_NONE, &master_preview, 0, "Use GnomePrintMasterPreview", NULL},
	POPT_AUTOHELP
	{ NULL, '\0', 0, NULL, 0 }
};

static void
star (GnomePrintContext *pc, double x, double y)
{
	gnome_print_moveto (pc, x - 3, y - 5);
	gnome_print_lineto (pc, x + 3, y + 5);
	gnome_print_stroke (pc);

	gnome_print_moveto (pc, x + 3, y - 5);
	gnome_print_lineto (pc, x - 3, y + 5);
	gnome_print_stroke (pc);
}

static void
print_test_page (GnomePrintContext *pc, GnomeFontFace *face)
{
	GnomeFont *font;
	int i;

	gnome_print_beginpage (pc, "testprint2 demo page");

	font = gnome_font_face_get_font_default (face, 14);

	gnome_print_setfont (pc, font);

	for (i = 0; i < 900; i += 20){
		char buf [40];
		
		gnome_print_setrgbcolor (pc, 0.4, 0.4, 0.4);
		gnome_print_moveto (pc, 0, i);
		gnome_print_lineto (pc, 600, i);
		gnome_print_stroke (pc);

		gnome_print_setrgbcolor (pc, 1.0, 0.0, 0.0);
		sprintf (buf, "%d", i);
		gnome_print_moveto (pc, 10, i + 3);
		gnome_print_show (pc, buf);
	}

	gnome_print_setrgbcolor (pc, 0.4, 0.4, 0.4);
	for (i = 0; i < 900; i += 20){
		gnome_print_moveto (pc, i, 0);
		gnome_print_lineto (pc, i, 900);
		gnome_print_stroke (pc);
	}

	if (1){

		double aff [6];

		gnome_print_gsave (pc);
		art_affine_rotate (aff, 20);
		gnome_print_concat (pc, aff);
		art_affine_translate (aff, 100, 100);
		gnome_print_concat (pc, aff);
		gnome_print_grestore (pc);
	}

#if 0
	gnome_print_moveto (pc, 120, 120);
	gnome_print_lineto (pc, 200, 210);
	gnome_print_stroke (pc);

	gnome_print_setrgbcolor (pc, 0.1, 0.1, 0.1);
	gnome_print_moveto (pc, 200, 200);
	gnome_print_lineto (pc, 300, 300);
	gnome_print_stroke (pc);
#endif
	
	gnome_print_setrgbcolor (pc, 0, 0, 0);

	font = gnome_font_face_get_font_default (face, 45);

	for (i = 0; i < 300; i += 50){
		char buf [90];

		sprintf (buf, "Hello-%d", i);
		gnome_print_setfont (pc, font);
		gnome_print_moveto (pc, i, i);
		gnome_print_show (pc, buf);
		star (pc, i, i); 
	}

	gnome_print_showpage (pc);
	gnome_print_context_close (pc);
	
}

#if 0
static void
show_pixbuf (GnomePrintPixbuf * gpb, GdkPixbuf * pb, gint pagenum, gpointer data)
{
	int fh;
	gint y, w, h, rs;
	guchar * px, * p;

	g_print ("Showpixbuf called :)\n");

	w = gdk_pixbuf_get_width (pb);
	h = gdk_pixbuf_get_height (pb);
	rs = gdk_pixbuf_get_rowstride (pb);
	px = gdk_pixbuf_get_pixels (pb);

	fh = creat ("output.dump", S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH);
	g_return_if_fail (fh >= 0);

	for (y = 0; y < h; y++) {
		p = px + y * rs;
		write (fh, p, w * 4);
	}

	close (fh);
}
#endif

static void
test_ps (GnomePrintConfig *config, GnomeFontFace *face)
{
	GnomePrintContext *pc;

	gtk_widget_set_default_colormap (gdk_rgb_get_cmap ());
#if 0
	gtk_widget_set_default_visual (gdk_rgb_get_visual ());
#endif
		
	if (config) {
		pc = gnome_print_context_new (config);
		if (metafile) {
			gnome_print_meta_render_file (pc, metafile);
		} else {
			print_test_page (pc, face);
		}
	} else {
		if (master_preview) {
			GnomePrintMaster *gpm;
			GnomePrintContext *ctx;
			GtkWidget *gpmp;
			gpm = gnome_print_master_new ();
			ctx = gnome_print_master_get_context (gpm);

			if (metafile) {
				gnome_print_meta_render_file (ctx, metafile);
			} else {
				print_test_page (ctx, face);
			}

			g_object_unref (G_OBJECT (ctx));

			gpmp = gnome_print_master_preview_new (gpm, NULL);
			gtk_widget_show (gpmp);
			gtk_main ();
		} else {
			GtkWidget *toplevel, *canvas, *sw;
			toplevel = gtk_window_new (GTK_WINDOW_TOPLEVEL);
			gtk_widget_set_usize (toplevel, 700, 700);
			sw = gtk_scrolled_window_new (NULL, NULL);
			canvas = gnome_canvas_new_aa ();
			gnome_canvas_set_pixels_per_unit (GNOME_CANVAS (canvas), dpi / 72.0);
			gtk_container_add (GTK_CONTAINER (toplevel), sw);
			gtk_container_add (GTK_CONTAINER (sw), canvas);
			
			config = gnome_print_config_default ();
			pc = gnome_print_preview_new (config, GNOME_CANVAS (canvas));
			
			gtk_widget_show_all (toplevel);

			if (metafile) {
				gnome_print_meta_render_file (pc, metafile);
			} else {
				print_test_page (pc, face);
			}

			gtk_main ();
		}
	}
}

int
main (int argc, char **argv)
{
	poptContext *ctx;
	GtkWidget *w;
	gint response;
	GnomeFontFace *face = NULL;
	GnomePrintConfig *config = NULL;

	gtk_init (&argc, &argv);

	/* Parse arguments */
	ctx = poptGetContext (NULL, argc, argv, options, 0);
	g_return_val_if_fail (ctx != NULL, 1);
	g_return_val_if_fail (poptGetNextOpt (ctx) == -1, 1);

	if (font_dialog) {
		w = gnome_font_dialog_new ("Please select font");
		gtk_widget_show (w);
		response = gtk_dialog_run (GTK_DIALOG (w));
		if (response == GTK_RESPONSE_OK) {
			GtkWidget *fs;
			fs = gnome_font_dialog_get_fontsel (GNOME_FONT_DIALOG (w));
			g_return_val_if_fail (GNOME_IS_FONT_SELECTION (fs), 1);
			face = gnome_font_selection_get_face (GNOME_FONT_SELECTION (fs));
			g_return_val_if_fail (GNOME_IS_FONT_FACE (face), 1);
		} else {
			g_warning ("No font specified");
		}
		gtk_widget_destroy (w);
	}

	if (printer_dialog) {
		w = gnome_printer_dialog_new_default ();
		gtk_widget_show (w);
		response = gtk_dialog_run (GTK_DIALOG (w));
		if (response == GTK_RESPONSE_OK) {
			config = gnome_printer_dialog_get_config (GNOME_PRINTER_DIALOG (w));
		} else {
			g_warning ("No config specified");
		}
		gtk_widget_destroy (w);
	} else if (print_dialog) {
		w = gnome_print_dialog_new ("Print test dialog", GNOME_PRINT_DIALOG_RANGE | GNOME_PRINT_DIALOG_COPIES);
		gtk_widget_show (w);
		response = gtk_dialog_run (GTK_DIALOG (w));
		if (response == GNOME_PRINT_DIALOG_RESPONSE_PRINT) {
			config = gnome_print_dialog_get_config (GNOME_PRINT_DIALOG (w));
		} else {
			g_warning ("No config specified");
		}
		gtk_widget_destroy (w);
	}

	if (!face) face = gnome_font_face_find ("Courier");

	test_ps (config, face);

	return 0;
}
