#ifndef PPT_W_DIALOGWRAP_H		// -*- c++ -*-
#define PPT_W_DIALOGWRAP_H
///
// Copyright (C) 2002, 2003, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include <gtkmm/dialog.h>

/**
 * A helper class to do create nice and uniform dialogs in passepartout.  The
 * main focus is for subclasses to be HIG compliant without having to have
 * lots of extra code.
 */
class DialogWrap : public Gtk::Dialog {
protected:
  /** Create a non-modal dialog */
  DialogWrap(const std::string& name);

  /** Create a modal dialog */
  DialogWrap(const std::string& name, Gtk::Window& parent);

  /**
   * Show and raise the dialog, so it is surely visible.
   * Subclasses might override this to make sure the dialog is up to date.
   */
  virtual void show_raise();

  /**
   * Hook in a button in the same callback system as buttons created by
   * {add_button()}.
   */
  Gtk::Button* fix_button(Gtk::Button* button, int action_id);
};

#endif

