// $Id: repeat-button.h,v 1.4 2002/01/21 17:13:12 cactus Exp $ -*- c++ -*-

/* RadioActive Copyright (C) 1999-2002 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef RADIOACTIVE_REPEAT_BUTTON_H
#define RADIOACTIVE_REPEAT_BUTTON_H

#include <gtk--/button.h>

namespace RadioActive
{
    namespace Widgets
    {
	class RepeatButton: public Gtk::Button
	{
	public:
	    RepeatButton (int time = 0);
	    
	    RepeatButton (const std::string &text = "",
			  int                time = 0);
	    
	    SigC::Signal0<void> hold;
	private:
	    unsigned int button_mask;
	    int timeout_time;
	    int button_press_handler (GdkEventButton *e);
	    int button_release_handler (GdkEventButton *e);
	    int timeout_handler ();
	};
    }
}

#endif /* !RADIOACTIVE_REPEAT_BUTTON_H */
