/* valacodegenerator.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <rasa@gmx.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valacodegenerator.h"
#include <ccode/valaccodestruct.h>
#include <ccode/valaccodeenum.h>
#include <ccode/valaccodefunction.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodecomment.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodemacroreplacement.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodereturnstatement.h>
#include <vala/valaliteral.h>
#include <ccode/valaccodefunctiondeclarator.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodetypedefinition.h>
#include <ccode/valaccodedeclarator.h>
#include <vala/valamemberaccessibility.h>
#include <vala/valalockable.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodedeclaration.h>
#include <vala/valaarray.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodeemptystatement.h>
#include <vala/valalocalvariabledeclaration.h>
#include <vala/valareport.h>
#include <vala/valainstancecast.h>
#include <ccode/valaccodeinitializerlist.h>
#include <vala/valatypeparameter.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <ccode/valaccodeconditionalexpression.h>
#include <ccode/valaccodegotostatement.h>
#include <ccode/valaccodeifstatement.h>
#include <vala/valaswitchsection.h>
#include <vala/valaswitchlabel.h>
#include <ccode/valaccodedostatement.h>
#include <ccode/valaccodewhilestatement.h>
#include <ccode/valaccodeforstatement.h>
#include <ccode/valaccodeelementaccess.h>
#include <ccode/valaccodebreakstatement.h>
#include <ccode/valaccodecontinuestatement.h>
#include <ccode/valaccodelabel.h>
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodenewline.h>
#include <ccode/valaccodeswitchstatement.h>
#include <ccode/valaccodecasestatement.h>
#include <vala/valainvokable.h>
#include <vala/valaarrayresizemethod.h>
#include <vala/valaarraylengthfield.h>
#include <vala/valapointer.h>
#include <vala/valasourcefilecycle.h>
#include <ccode/valaccodewriter.h>
#include <ccode/valaccodeoncesection.h>
#include <gobject/valacodegenerator.h>
#include <gobject/valaclassregisterfunction.h>
#include <gobject/valatyperegisterfunction.h>
#include <gobject/valainterfaceregisterfunction.h>

struct _ValaCodeGeneratorPrivate {
	gboolean _memory_management;
	ValaCodeContext* context;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaTypeReference* current_return_type;
	ValaTryStatement* current_try;
	ValaCCodeFragment* header_begin;
	ValaCCodeFragment* header_type_declaration;
	ValaCCodeFragment* header_type_definition;
	ValaCCodeFragment* header_type_member_declaration;
	ValaCCodeFragment* source_begin;
	ValaCCodeFragment* source_include_directives;
	ValaCCodeFragment* source_type_member_declaration;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_dispose_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* instance_struct;
	ValaCCodeStruct* type_struct;
	ValaCCodeStruct* instance_priv_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeEnum* cenum;
	ValaCCodeFunction* function;
	ValaCCodeBlock* block;
	GList* temp_vars;
	GList* temp_ref_vars;
	GHashTable* user_marshal_list;
	GHashTable* predefined_marshal_list;
	GHashTable* c_keywords;
	gint next_temp_var_id;
	gint current_try_id;
	gint next_try_id;
	gboolean in_creation_method;
	gboolean current_method_inner_error;
	ValaTypeReference* bool_type;
	ValaTypeReference* char_type;
	ValaTypeReference* unichar_type;
	ValaTypeReference* short_type;
	ValaTypeReference* ushort_type;
	ValaTypeReference* int_type;
	ValaTypeReference* uint_type;
	ValaTypeReference* long_type;
	ValaTypeReference* ulong_type;
	ValaTypeReference* int64_type;
	ValaTypeReference* uint64_type;
	ValaTypeReference* string_type;
	ValaTypeReference* float_type;
	ValaTypeReference* double_type;
	ValaDataType* list_type;
	ValaDataType* slist_type;
	ValaTypeReference* mutex_type;
	ValaDataType* type_module_type;
	ValaMethod* substring_method;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean string_h_needed;
};
#define VALA_CODE_GENERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorPrivate))
enum  {
	VALA_CODE_GENERATOR_DUMMY_PROPERTY,
	VALA_CODE_GENERATOR_MEMORY_MANAGEMENT
};
static void vala_code_generator_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void vala_code_generator_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_code_generator_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev);
static void vala_code_generator_real_visit_flags (ValaCodeVisitor* base, ValaFlags* fl);
static void vala_code_generator_real_visit_flags_value (ValaCodeVisitor* base, ValaFlagsValue* fv);
static void vala_code_generator_real_visit_callback (ValaCodeVisitor* base, ValaCallback* cb);
static void vala_code_generator_real_visit_member (ValaCodeVisitor* base, ValaMember* m);
static void vala_code_generator_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void vala_code_generator_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static void vala_code_generator_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p);
static void vala_code_generator_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void vala_code_generator_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc);
static void vala_code_generator_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c);
static void vala_code_generator_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d);
static void vala_code_generator_real_visit_begin_block (ValaCodeVisitor* base, ValaBlock* b);
static void vala_code_generator_add_object_creation (ValaCodeGenerator* self, ValaCCodeBlock* b);
static void vala_code_generator_real_visit_end_block (ValaCodeVisitor* base, ValaBlock* b);
static void vala_code_generator_real_visit_empty_statement (ValaCodeVisitor* base, ValaEmptyStatement* stmt);
static gboolean vala_code_generator_struct_has_instance_fields (ValaCodeGenerator* self, ValaStruct* st);
static void vala_code_generator_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt);
static char* vala_code_generator_get_variable_cname (ValaCodeGenerator* self, const char* name);
static void vala_code_generator_real_visit_variable_declarator (ValaCodeVisitor* base, ValaVariableDeclarator* decl);
static void vala_code_generator_real_visit_end_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list);
static ValaVariableDeclarator* vala_code_generator_get_temp_variable_declarator (ValaCodeGenerator* self, ValaTypeReference* type, gboolean takes_ownership);
static ValaCCodeExpression* vala_code_generator_get_destroy_func_expression (ValaCodeGenerator* self, ValaTypeReference* type);
static ValaCCodeExpression* vala_code_generator_get_unref_expression (ValaCodeGenerator* self, ValaCCodeExpression* cvar, ValaTypeReference* type);
static void vala_code_generator_real_visit_end_full_expression (ValaCodeVisitor* base, ValaExpression* expr);
static void vala_code_generator_append_temp_decl (ValaCodeGenerator* self, ValaCCodeFragment* cfrag, GList* temp_vars);
static void vala_code_generator_add_simple_check (ValaCodeGenerator* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
static void vala_code_generator_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt);
static void vala_code_generator_create_temp_decl (ValaCodeGenerator* self, ValaStatement* stmt, GList* temp_vars);
static void vala_code_generator_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt);
static void vala_code_generator_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt);
static void vala_code_generator_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt);
static void vala_code_generator_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt);
static void vala_code_generator_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt);
static void vala_code_generator_real_visit_end_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt);
static void vala_code_generator_real_visit_break_statement (ValaCodeVisitor* base, ValaBreakStatement* stmt);
static void vala_code_generator_real_visit_continue_statement (ValaCodeVisitor* base, ValaContinueStatement* stmt);
static void vala_code_generator_append_local_free (ValaCodeGenerator* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop);
static void vala_code_generator_create_local_free (ValaCodeGenerator* self, ValaStatement* stmt);
static gboolean vala_code_generator_append_local_free_expr (ValaCodeGenerator* self, ValaSymbol* sym, ValaCCodeCommaExpression* ccomma, gboolean stop_at_loop);
static void vala_code_generator_create_local_free_expr (ValaCodeGenerator* self, ValaExpression* expr);
static void vala_code_generator_real_visit_begin_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt);
static void vala_code_generator_real_visit_end_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt);
static void vala_code_generator_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt);
static void vala_code_generator_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt);
static void vala_code_generator_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause);
static char* vala_code_generator_get_symbol_lock_name (ValaCodeGenerator* self, ValaSymbol* sym);
static void vala_code_generator_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt);
static void vala_code_generator_real_visit_end_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* expr);
static void vala_code_generator_real_visit_boolean_literal (ValaCodeVisitor* base, ValaBooleanLiteral* expr);
static void vala_code_generator_real_visit_character_literal (ValaCodeVisitor* base, ValaCharacterLiteral* expr);
static void vala_code_generator_real_visit_integer_literal (ValaCodeVisitor* base, ValaIntegerLiteral* expr);
static void vala_code_generator_real_visit_real_literal (ValaCodeVisitor* base, ValaRealLiteral* expr);
static void vala_code_generator_real_visit_string_literal (ValaCodeVisitor* base, ValaStringLiteral* expr);
static void vala_code_generator_real_visit_null_literal (ValaCodeVisitor* base, ValaNullLiteral* expr);
static void vala_code_generator_real_visit_literal_expression (ValaCodeVisitor* base, ValaLiteralExpression* expr);
static void vala_code_generator_real_visit_parenthesized_expression (ValaCodeVisitor* base, ValaParenthesizedExpression* expr);
static ValaCCodeExpression* vala_code_generator_get_array_length_cexpression (ValaCodeGenerator* self, ValaExpression* array_expr, gint dim);
static void vala_code_generator_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr);
static void vala_code_generator_real_visit_base_access (ValaCodeVisitor* base, ValaBaseAccess* expr);
static void vala_code_generator_real_visit_postfix_expression (ValaCodeVisitor* base, ValaPostfixExpression* expr);
static ValaMemberAccess* vala_code_generator_find_property_access (ValaCodeGenerator* self, ValaExpression* expr);
static ValaCCodeExpression* vala_code_generator_get_ref_expression (ValaCodeGenerator* self, ValaExpression* expr);
static void vala_code_generator_visit_expression (ValaCodeGenerator* self, ValaExpression* expr);
static void vala_code_generator_real_visit_end_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr);
static void vala_code_generator_real_visit_sizeof_expression (ValaCodeVisitor* base, ValaSizeofExpression* expr);
static void vala_code_generator_real_visit_typeof_expression (ValaCodeVisitor* base, ValaTypeofExpression* expr);
static void vala_code_generator_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr);
static void vala_code_generator_real_visit_cast_expression (ValaCodeVisitor* base, ValaCastExpression* expr);
static void vala_code_generator_real_visit_pointer_indirection (ValaCodeVisitor* base, ValaPointerIndirection* expr);
static void vala_code_generator_real_visit_addressof_expression (ValaCodeVisitor* base, ValaAddressofExpression* expr);
static void vala_code_generator_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr);
static void vala_code_generator_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr);
static void vala_code_generator_real_visit_type_check (ValaCodeVisitor* base, ValaTypeCheck* expr);
static void vala_code_generator_real_visit_conditional_expression (ValaCodeVisitor* base, ValaConditionalExpression* expr);
static void vala_code_generator_real_visit_end_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l);
static void vala_code_generator_real_visit_end_assignment (ValaCodeVisitor* base, ValaAssignment* a);
static ValaCCodeFunctionCall* vala_code_generator_get_property_set_call (ValaCodeGenerator* self, ValaProperty* prop, ValaMemberAccess* ma, ValaCCodeExpression* cexpr);
static void vala_code_generator_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_code_generator_add_class_init_function (ValaCodeGenerator* self, ValaClass* cl);
static void vala_code_generator_add_interface_init_function (ValaCodeGenerator* self, ValaClass* cl, ValaInterface* iface);
static void vala_code_generator_add_instance_init_function (ValaCodeGenerator* self, ValaClass* cl);
static void vala_code_generator_add_dispose_function (ValaCodeGenerator* self, ValaClass* cl);
static ValaCCodeIdentifier* vala_code_generator_get_value_setter_function (ValaCodeGenerator* self, ValaTypeReference* type_reference);
static gboolean vala_code_generator_class_has_readable_properties (ValaCodeGenerator* self, ValaClass* cl);
static gboolean vala_code_generator_class_has_writable_properties (ValaCodeGenerator* self, ValaClass* cl);
static void vala_code_generator_add_get_property_function (ValaCodeGenerator* self, ValaClass* cl);
static void vala_code_generator_add_set_property_function (ValaCodeGenerator* self, ValaClass* cl);
static void vala_code_generator_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static ValaCCodeFunctionCall* vala_code_generator_get_param_spec (ValaCodeGenerator* self, ValaProperty* prop);
static ValaCCodeFunctionCall* vala_code_generator_get_signal_creation (ValaCodeGenerator* self, ValaSignal* sig, ValaDataType* type);
static void vala_code_generator_add_interface_base_init_function (ValaCodeGenerator* self, ValaInterface* iface);
static void vala_code_generator_real_visit_end_invocation_expression (ValaCodeVisitor* base, ValaInvocationExpression* expr);
static void vala_code_generator_process_cmember (ValaCodeGenerator* self, ValaMemberAccess* expr, ValaCCodeExpression* pub_inst, ValaDataType* base_type);
static void vala_code_generator_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr);
static void vala_code_generator_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static ValaCCodeStatement* vala_code_generator_create_method_type_check_statement (ValaCodeGenerator* self, ValaMethod* m, ValaDataType* t, gboolean non_null, const char* var_name);
static ValaCCodeStatement* vala_code_generator_create_property_type_check_statement (ValaCodeGenerator* self, ValaProperty* prop, gboolean getter, ValaDataType* t, gboolean non_null, const char* var_name);
static ValaCCodeStatement* vala_code_generator_create_type_check_statement (ValaCodeGenerator* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaDataType* t, gboolean non_null, const char* var_name);
static ValaCCodeExpression* vala_code_generator_default_value_for_type (ValaCodeGenerator* self, ValaDataType* type);
static ValaDataType* vala_code_generator_find_parent_type (ValaCodeGenerator* self, ValaCodeNode* node);
static char* vala_code_generator_get_array_length_cname (ValaCodeGenerator* self, const char* array_cname, gint dim);
static void vala_code_generator_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static gboolean vala_code_generator_is_possible_entry_point (ValaCodeGenerator* self, ValaMethod* m, gboolean* return_value, gboolean* args_parameter);
static char* vala_code_generator_get_marshaller_type_name (ValaCodeGenerator* self, ValaTypeReference* t);
static char* vala_code_generator_get_signal_marshaller_function (ValaCodeGenerator* self, ValaSignal* sig, const char* prefix);
static char* vala_code_generator_get_value_type_name_from_type_reference (ValaCodeGenerator* self, ValaTypeReference* t);
static char* vala_code_generator_get_signal_signature (ValaCodeGenerator* self, ValaSignal* sig);
static void vala_code_generator_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
static ValaCCodeIncludeDirective* vala_code_generator_get_internal_include (ValaCodeGenerator* self, const char* filename);
static void vala_code_generator_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
static char* vala_code_generator_get_define_for_filename (const char* filename);
static void vala_code_generator_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static GObject * vala_code_generator_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer vala_code_generator_parent_class = NULL;
static void vala_code_generator_dispose (GObject * obj);


ValaCodeGenerator* vala_code_generator_new (gboolean manage_memory)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaCodeGenerator * self;
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	(__params_it->name = "memory-management", g_value_init (&__params_it->value, G_TYPE_BOOLEAN), g_value_set_boolean (&__params_it->value, manage_memory), __params_it++);
	self = g_object_newv (VALA_TYPE_CODE_GENERATOR, __params_it - __params, __params);
	return self;
}


/**
 * Generate and emit C code for the specified code context.
 *
 * @param context a code context
 */
void vala_code_generator_emit (ValaCodeGenerator* self, ValaCodeContext* context)
{
	ValaCodeContext* __temp0;
	ValaSymbol* __temp1;
	ValaTypeReference* __temp2;
	ValaSymbol* __temp3;
	ValaTypeReference* __temp4;
	ValaSymbol* __temp5;
	ValaTypeReference* __temp6;
	ValaSymbol* __temp7;
	ValaTypeReference* __temp8;
	ValaSymbol* __temp9;
	ValaTypeReference* __temp10;
	ValaSymbol* __temp11;
	ValaTypeReference* __temp12;
	ValaSymbol* __temp13;
	ValaTypeReference* __temp14;
	ValaSymbol* __temp15;
	ValaTypeReference* __temp16;
	ValaSymbol* __temp17;
	ValaTypeReference* __temp18;
	ValaSymbol* __temp19;
	ValaTypeReference* __temp20;
	ValaSymbol* __temp21;
	ValaTypeReference* __temp22;
	ValaSymbol* __temp23;
	ValaTypeReference* __temp24;
	ValaSymbol* __temp25;
	ValaTypeReference* __temp26;
	ValaSymbol* __temp27;
	ValaTypeReference* __temp28;
	ValaSymbol* __temp29;
	ValaMethod* __temp32;
	ValaMethod* __temp31;
	ValaSymbol* __temp30;
	ValaSymbol* glib_ns;
	ValaDataType* __temp35;
	ValaDataType* __temp34;
	ValaSymbol* __temp33;
	ValaDataType* __temp38;
	ValaDataType* __temp37;
	ValaSymbol* __temp36;
	ValaTypeReference* __temp39;
	ValaSymbol* __temp40;
	ValaDataType* __temp43;
	ValaDataType* __temp42;
	ValaSymbol* __temp41;
	GList* source_files;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CODE_CONTEXT (context));
	__temp0 = NULL;
	self->priv->context = (__temp0 = g_object_ref (context), (self->priv->context == NULL ? NULL : (self->priv->context = (g_object_unref (self->priv->context), NULL))), __temp0);
	vala_code_context_find_header_cycles (context);
	__temp1 = NULL;
	self->priv->root_symbol = (__temp1 = vala_code_context_get_root (context), (self->priv->root_symbol == NULL ? NULL : (self->priv->root_symbol = (g_object_unref (self->priv->root_symbol), NULL))), __temp1);
	__temp2 = NULL;
	self->priv->bool_type = (__temp2 = vala_type_reference_new (), (self->priv->bool_type == NULL ? NULL : (self->priv->bool_type = (g_object_unref (self->priv->bool_type), NULL))), __temp2);
	__temp3 = NULL;
	(vala_type_reference_set_data_type (self->priv->bool_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp3 = vala_symbol_lookup (self->priv->root_symbol, "bool"))))), vala_type_reference_get_data_type (self->priv->bool_type));
	(__temp3 == NULL ? NULL : (__temp3 = (g_object_unref (__temp3), NULL)));
	__temp4 = NULL;
	self->priv->char_type = (__temp4 = vala_type_reference_new (), (self->priv->char_type == NULL ? NULL : (self->priv->char_type = (g_object_unref (self->priv->char_type), NULL))), __temp4);
	__temp5 = NULL;
	(vala_type_reference_set_data_type (self->priv->char_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp5 = vala_symbol_lookup (self->priv->root_symbol, "char"))))), vala_type_reference_get_data_type (self->priv->char_type));
	(__temp5 == NULL ? NULL : (__temp5 = (g_object_unref (__temp5), NULL)));
	__temp6 = NULL;
	self->priv->unichar_type = (__temp6 = vala_type_reference_new (), (self->priv->unichar_type == NULL ? NULL : (self->priv->unichar_type = (g_object_unref (self->priv->unichar_type), NULL))), __temp6);
	__temp7 = NULL;
	(vala_type_reference_set_data_type (self->priv->unichar_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp7 = vala_symbol_lookup (self->priv->root_symbol, "unichar"))))), vala_type_reference_get_data_type (self->priv->unichar_type));
	(__temp7 == NULL ? NULL : (__temp7 = (g_object_unref (__temp7), NULL)));
	__temp8 = NULL;
	self->priv->short_type = (__temp8 = vala_type_reference_new (), (self->priv->short_type == NULL ? NULL : (self->priv->short_type = (g_object_unref (self->priv->short_type), NULL))), __temp8);
	__temp9 = NULL;
	(vala_type_reference_set_data_type (self->priv->short_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp9 = vala_symbol_lookup (self->priv->root_symbol, "short"))))), vala_type_reference_get_data_type (self->priv->short_type));
	(__temp9 == NULL ? NULL : (__temp9 = (g_object_unref (__temp9), NULL)));
	__temp10 = NULL;
	self->priv->ushort_type = (__temp10 = vala_type_reference_new (), (self->priv->ushort_type == NULL ? NULL : (self->priv->ushort_type = (g_object_unref (self->priv->ushort_type), NULL))), __temp10);
	__temp11 = NULL;
	(vala_type_reference_set_data_type (self->priv->ushort_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp11 = vala_symbol_lookup (self->priv->root_symbol, "ushort"))))), vala_type_reference_get_data_type (self->priv->ushort_type));
	(__temp11 == NULL ? NULL : (__temp11 = (g_object_unref (__temp11), NULL)));
	__temp12 = NULL;
	self->priv->int_type = (__temp12 = vala_type_reference_new (), (self->priv->int_type == NULL ? NULL : (self->priv->int_type = (g_object_unref (self->priv->int_type), NULL))), __temp12);
	__temp13 = NULL;
	(vala_type_reference_set_data_type (self->priv->int_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp13 = vala_symbol_lookup (self->priv->root_symbol, "int"))))), vala_type_reference_get_data_type (self->priv->int_type));
	(__temp13 == NULL ? NULL : (__temp13 = (g_object_unref (__temp13), NULL)));
	__temp14 = NULL;
	self->priv->uint_type = (__temp14 = vala_type_reference_new (), (self->priv->uint_type == NULL ? NULL : (self->priv->uint_type = (g_object_unref (self->priv->uint_type), NULL))), __temp14);
	__temp15 = NULL;
	(vala_type_reference_set_data_type (self->priv->uint_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp15 = vala_symbol_lookup (self->priv->root_symbol, "uint"))))), vala_type_reference_get_data_type (self->priv->uint_type));
	(__temp15 == NULL ? NULL : (__temp15 = (g_object_unref (__temp15), NULL)));
	__temp16 = NULL;
	self->priv->long_type = (__temp16 = vala_type_reference_new (), (self->priv->long_type == NULL ? NULL : (self->priv->long_type = (g_object_unref (self->priv->long_type), NULL))), __temp16);
	__temp17 = NULL;
	(vala_type_reference_set_data_type (self->priv->long_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp17 = vala_symbol_lookup (self->priv->root_symbol, "long"))))), vala_type_reference_get_data_type (self->priv->long_type));
	(__temp17 == NULL ? NULL : (__temp17 = (g_object_unref (__temp17), NULL)));
	__temp18 = NULL;
	self->priv->ulong_type = (__temp18 = vala_type_reference_new (), (self->priv->ulong_type == NULL ? NULL : (self->priv->ulong_type = (g_object_unref (self->priv->ulong_type), NULL))), __temp18);
	__temp19 = NULL;
	(vala_type_reference_set_data_type (self->priv->ulong_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp19 = vala_symbol_lookup (self->priv->root_symbol, "ulong"))))), vala_type_reference_get_data_type (self->priv->ulong_type));
	(__temp19 == NULL ? NULL : (__temp19 = (g_object_unref (__temp19), NULL)));
	__temp20 = NULL;
	self->priv->int64_type = (__temp20 = vala_type_reference_new (), (self->priv->int64_type == NULL ? NULL : (self->priv->int64_type = (g_object_unref (self->priv->int64_type), NULL))), __temp20);
	__temp21 = NULL;
	(vala_type_reference_set_data_type (self->priv->int64_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp21 = vala_symbol_lookup (self->priv->root_symbol, "int64"))))), vala_type_reference_get_data_type (self->priv->int64_type));
	(__temp21 == NULL ? NULL : (__temp21 = (g_object_unref (__temp21), NULL)));
	__temp22 = NULL;
	self->priv->uint64_type = (__temp22 = vala_type_reference_new (), (self->priv->uint64_type == NULL ? NULL : (self->priv->uint64_type = (g_object_unref (self->priv->uint64_type), NULL))), __temp22);
	__temp23 = NULL;
	(vala_type_reference_set_data_type (self->priv->uint64_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp23 = vala_symbol_lookup (self->priv->root_symbol, "uint64"))))), vala_type_reference_get_data_type (self->priv->uint64_type));
	(__temp23 == NULL ? NULL : (__temp23 = (g_object_unref (__temp23), NULL)));
	__temp24 = NULL;
	self->priv->float_type = (__temp24 = vala_type_reference_new (), (self->priv->float_type == NULL ? NULL : (self->priv->float_type = (g_object_unref (self->priv->float_type), NULL))), __temp24);
	__temp25 = NULL;
	(vala_type_reference_set_data_type (self->priv->float_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp25 = vala_symbol_lookup (self->priv->root_symbol, "float"))))), vala_type_reference_get_data_type (self->priv->float_type));
	(__temp25 == NULL ? NULL : (__temp25 = (g_object_unref (__temp25), NULL)));
	__temp26 = NULL;
	self->priv->double_type = (__temp26 = vala_type_reference_new (), (self->priv->double_type == NULL ? NULL : (self->priv->double_type = (g_object_unref (self->priv->double_type), NULL))), __temp26);
	__temp27 = NULL;
	(vala_type_reference_set_data_type (self->priv->double_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp27 = vala_symbol_lookup (self->priv->root_symbol, "double"))))), vala_type_reference_get_data_type (self->priv->double_type));
	(__temp27 == NULL ? NULL : (__temp27 = (g_object_unref (__temp27), NULL)));
	__temp28 = NULL;
	self->priv->string_type = (__temp28 = vala_type_reference_new (), (self->priv->string_type == NULL ? NULL : (self->priv->string_type = (g_object_unref (self->priv->string_type), NULL))), __temp28);
	__temp29 = NULL;
	(vala_type_reference_set_data_type (self->priv->string_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp29 = vala_symbol_lookup (self->priv->root_symbol, "string"))))), vala_type_reference_get_data_type (self->priv->string_type));
	(__temp29 == NULL ? NULL : (__temp29 = (g_object_unref (__temp29), NULL)));
	__temp32 = NULL;
	__temp31 = NULL;
	__temp30 = NULL;
	self->priv->substring_method = (__temp32 = (__temp31 = VALA_METHOD (vala_symbol_get_node ((__temp30 = vala_symbol_lookup (vala_code_node_get_symbol (VALA_CODE_NODE (vala_type_reference_get_data_type (self->priv->string_type))), "substring")))), (__temp31 == NULL ? NULL : g_object_ref (__temp31))), (self->priv->substring_method == NULL ? NULL : (self->priv->substring_method = (g_object_unref (self->priv->substring_method), NULL))), __temp32);
	(__temp30 == NULL ? NULL : (__temp30 = (g_object_unref (__temp30), NULL)));
	glib_ns = vala_symbol_lookup (self->priv->root_symbol, "GLib");
	__temp35 = NULL;
	__temp34 = NULL;
	__temp33 = NULL;
	self->priv->list_type = (__temp35 = (__temp34 = VALA_DATA_TYPE (vala_symbol_get_node ((__temp33 = vala_symbol_lookup (glib_ns, "List")))), (__temp34 == NULL ? NULL : g_object_ref (__temp34))), (self->priv->list_type == NULL ? NULL : (self->priv->list_type = (g_object_unref (self->priv->list_type), NULL))), __temp35);
	(__temp33 == NULL ? NULL : (__temp33 = (g_object_unref (__temp33), NULL)));
	__temp38 = NULL;
	__temp37 = NULL;
	__temp36 = NULL;
	self->priv->slist_type = (__temp38 = (__temp37 = VALA_DATA_TYPE (vala_symbol_get_node ((__temp36 = vala_symbol_lookup (glib_ns, "SList")))), (__temp37 == NULL ? NULL : g_object_ref (__temp37))), (self->priv->slist_type == NULL ? NULL : (self->priv->slist_type = (g_object_unref (self->priv->slist_type), NULL))), __temp38);
	(__temp36 == NULL ? NULL : (__temp36 = (g_object_unref (__temp36), NULL)));
	__temp39 = NULL;
	self->priv->mutex_type = (__temp39 = vala_type_reference_new (), (self->priv->mutex_type == NULL ? NULL : (self->priv->mutex_type = (g_object_unref (self->priv->mutex_type), NULL))), __temp39);
	__temp40 = NULL;
	(vala_type_reference_set_data_type (self->priv->mutex_type, VALA_DATA_TYPE (vala_symbol_get_node ((__temp40 = vala_symbol_lookup (glib_ns, "Mutex"))))), vala_type_reference_get_data_type (self->priv->mutex_type));
	(__temp40 == NULL ? NULL : (__temp40 = (g_object_unref (__temp40), NULL)));
	__temp43 = NULL;
	__temp42 = NULL;
	__temp41 = NULL;
	self->priv->type_module_type = (__temp43 = (__temp42 = VALA_DATA_TYPE (vala_symbol_get_node ((__temp41 = vala_symbol_lookup (glib_ns, "TypeModule")))), (__temp42 == NULL ? NULL : g_object_ref (__temp42))), (self->priv->type_module_type == NULL ? NULL : (self->priv->type_module_type = (g_object_unref (self->priv->type_module_type), NULL))), __temp43);
	(__temp41 == NULL ? NULL : (__temp41 = (g_object_unref (__temp41), NULL)));
	if (vala_code_context_get_module_init_method (context) != NULL) {
		ValaCCodeFragment* __temp44;
		__temp44 = NULL;
		self->priv->module_init_fragment = (__temp44 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->module_init_fragment == NULL ? NULL : (self->priv->module_init_fragment = (g_object_unref (self->priv->module_init_fragment), NULL))), __temp44);
		{
			GList* __temp47;
			GList* parameter_it;
			__temp47 = NULL;
			__temp47 = vala_invokable_get_parameters (VALA_INVOKABLE (vala_code_context_get_module_init_method (context)));
			for (parameter_it = __temp47; parameter_it != NULL; parameter_it = parameter_it->next) {
				ValaFormalParameter* parameter;
				parameter = parameter_it->data;
				{
					if (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (parameter)) == self->priv->type_module_type) {
						char* __temp46;
						const char* __temp45;
						self->priv->in_plugin = TRUE;
						__temp46 = NULL;
						__temp45 = NULL;
						self->priv->module_init_param_name = (__temp46 = (__temp45 = vala_formal_parameter_get_name (parameter), (__temp45 == NULL ? NULL : g_strdup (__temp45))), (self->priv->module_init_param_name = (g_free (self->priv->module_init_param_name), NULL)), __temp46);
						break;
					}
				}
			}
			(__temp47 == NULL ? NULL : (__temp47 = (g_list_free (__temp47), NULL)));
		}
	}
	/* we're only interested in non-pkg source files */
	source_files = vala_code_context_get_source_files (context);
	{
		GList* __temp48;
		GList* file_it;
		__temp48 = NULL;
		__temp48 = source_files;
		for (file_it = __temp48; file_it != NULL; file_it = file_it->next) {
			ValaSourceFile* file;
			file = file_it->data;
			{
				if (!vala_source_file_get_pkg (file)) {
					vala_source_file_accept (file, VALA_CODE_VISITOR (self));
				}
			}
		}
	}
	(glib_ns == NULL ? NULL : (glib_ns = (g_object_unref (glib_ns), NULL)));
	(source_files == NULL ? NULL : (source_files = (g_list_free (source_files), NULL)));
}


static void vala_code_generator_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_NAMESPACE (ns));
	vala_code_node_accept_children (VALA_CODE_NODE (ns), VALA_CODE_VISITOR (self));
}


static void vala_code_generator_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en)
{
	ValaCodeGenerator * self;
	ValaCCodeEnum* __temp49;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ENUM (en));
	__temp49 = NULL;
	self->priv->cenum = (__temp49 = vala_ccode_enum_new (vala_data_type_get_cname (VALA_DATA_TYPE (en), FALSE)), (self->priv->cenum == NULL ? NULL : (self->priv->cenum = (g_object_unref (self->priv->cenum), NULL))), __temp49);
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (en))) != NULL) {
		ValaCCodeComment* __temp50;
		__temp50 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE ((__temp50 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (en)))))));
		(__temp50 == NULL ? NULL : (__temp50 = (g_object_unref (__temp50), NULL)));
	}
	vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (self->priv->cenum));
	vala_code_node_accept_children (VALA_CODE_NODE (en), VALA_CODE_VISITOR (self));
	if (vala_enum_get_error_domain (en)) {
		char* __temp51;
		char* __temp52;
		char* quark_fun_name;
		ValaCCodeMacroReplacement* error_domain_define;
		ValaCCodeFunction* cquark_fun;
		ValaCCodeBlock* cquark_block;
		ValaCCodeFunctionCall* cquark_call;
		ValaCCodeConstant* __temp55;
		char* __temp54;
		char* __temp53;
		ValaCCodeReturnStatement* __temp56;
		ValaCCodeFunction* __temp57;
		__temp51 = NULL;
		__temp52 = NULL;
		quark_fun_name = (__temp52 = g_strconcat ((__temp51 = vala_data_type_get_lower_case_cprefix (VALA_DATA_TYPE (en))), "quark", NULL), (__temp51 = (g_free (__temp51), NULL)), __temp52);
		error_domain_define = vala_ccode_macro_replacement_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (en), NULL), g_strconcat (quark_fun_name, " ()", NULL));
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (error_domain_define));
		cquark_fun = vala_ccode_function_new (quark_fun_name, "GQuark");
		cquark_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		cquark_call = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_quark_from_static_string")));
		__temp55 = NULL;
		__temp54 = NULL;
		__temp53 = NULL;
		vala_ccode_function_call_add_argument (cquark_call, VALA_CCODE_EXPRESSION ((__temp55 = vala_ccode_constant_new (g_strconcat ((__temp54 = g_strconcat ("\"", (__temp53 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (en), NULL)), NULL)), "-quark\"", NULL)))));
		(__temp55 == NULL ? NULL : (__temp55 = (g_object_unref (__temp55), NULL)));
		(__temp54 = (g_free (__temp54), NULL));
		(__temp53 = (g_free (__temp53), NULL));
		__temp56 = NULL;
		vala_ccode_block_add_statement (cquark_block, VALA_CCODE_NODE ((__temp56 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (cquark_call)))));
		(__temp56 == NULL ? NULL : (__temp56 = (g_object_unref (__temp56), NULL)));
		__temp57 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp57 = vala_ccode_function_copy (cquark_fun))));
		(__temp57 = (g_object_unref (__temp57), NULL));
		(vala_ccode_function_set_block (cquark_fun, cquark_block), vala_ccode_function_get_block (cquark_fun));
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (cquark_fun));
		(quark_fun_name = (g_free (quark_fun_name), NULL));
		(error_domain_define == NULL ? NULL : (error_domain_define = (g_object_unref (error_domain_define), NULL)));
		(cquark_fun == NULL ? NULL : (cquark_fun = (g_object_unref (cquark_fun), NULL)));
		(cquark_block == NULL ? NULL : (cquark_block = (g_object_unref (cquark_block), NULL)));
		(cquark_call == NULL ? NULL : (cquark_call = (g_object_unref (cquark_call), NULL)));
	}
}


static void vala_code_generator_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev)
{
	ValaCodeGenerator * self;
	char* val;
	char* __temp61;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ENUM_VALUE (ev));
	val = NULL;
	if (VALA_IS_LITERAL_EXPRESSION (vala_enum_value_get_value (ev))) {
		ValaLiteral* __temp58;
		ValaLiteral* lit;
		__temp58 = NULL;
		lit = (__temp58 = vala_literal_expression_get_literal ((VALA_LITERAL_EXPRESSION (vala_enum_value_get_value (ev)))), (__temp58 == NULL ? NULL : g_object_ref (__temp58)));
		if (VALA_IS_INTEGER_LITERAL (lit)) {
			char* __temp60;
			const char* __temp59;
			__temp60 = NULL;
			__temp59 = NULL;
			val = (__temp60 = (__temp59 = vala_integer_literal_get_value ((VALA_INTEGER_LITERAL (lit))), (__temp59 == NULL ? NULL : g_strdup (__temp59))), (val = (g_free (val), NULL)), __temp60);
		}
		(lit == NULL ? NULL : (lit = (g_object_unref (lit), NULL)));
	}
	__temp61 = NULL;
	vala_ccode_enum_add_value (self->priv->cenum, (__temp61 = vala_enum_value_get_cname (ev)), val);
	(__temp61 = (g_free (__temp61), NULL));
	(val = (g_free (val), NULL));
}


static void vala_code_generator_real_visit_flags (ValaCodeVisitor* base, ValaFlags* fl)
{
	ValaCodeGenerator * self;
	ValaCCodeEnum* __temp62;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_FLAGS (fl));
	__temp62 = NULL;
	self->priv->cenum = (__temp62 = vala_ccode_enum_new (vala_data_type_get_cname (VALA_DATA_TYPE (fl), FALSE)), (self->priv->cenum == NULL ? NULL : (self->priv->cenum = (g_object_unref (self->priv->cenum), NULL))), __temp62);
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (fl))) != NULL) {
		ValaCCodeComment* __temp63;
		__temp63 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE ((__temp63 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (fl)))))));
		(__temp63 == NULL ? NULL : (__temp63 = (g_object_unref (__temp63), NULL)));
	}
	vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (self->priv->cenum));
	vala_code_node_accept_children (VALA_CODE_NODE (fl), VALA_CODE_VISITOR (self));
}


static void vala_code_generator_real_visit_flags_value (ValaCodeVisitor* base, ValaFlagsValue* fv)
{
	ValaCodeGenerator * self;
	char* val;
	char* __temp67;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_FLAGS_VALUE (fv));
	val = NULL;
	if (VALA_IS_LITERAL_EXPRESSION (vala_flags_value_get_value (fv))) {
		ValaLiteral* __temp64;
		ValaLiteral* lit;
		__temp64 = NULL;
		lit = (__temp64 = vala_literal_expression_get_literal ((VALA_LITERAL_EXPRESSION (vala_flags_value_get_value (fv)))), (__temp64 == NULL ? NULL : g_object_ref (__temp64)));
		if (VALA_IS_INTEGER_LITERAL (lit)) {
			char* __temp66;
			const char* __temp65;
			__temp66 = NULL;
			__temp65 = NULL;
			val = (__temp66 = (__temp65 = vala_integer_literal_get_value ((VALA_INTEGER_LITERAL (lit))), (__temp65 == NULL ? NULL : g_strdup (__temp65))), (val = (g_free (val), NULL)), __temp66);
		}
		(lit == NULL ? NULL : (lit = (g_object_unref (lit), NULL)));
	}
	__temp67 = NULL;
	vala_ccode_enum_add_value (self->priv->cenum, (__temp67 = vala_flags_value_get_cname (fv)), val);
	(__temp67 = (g_free (__temp67), NULL));
	(val = (g_free (val), NULL));
}


static void vala_code_generator_real_visit_callback (ValaCodeVisitor* base, ValaCallback* cb)
{
	ValaCodeGenerator * self;
	ValaCCodeFunctionDeclarator* cfundecl;
	ValaCCodeTypeDefinition* ctypedef;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CALLBACK (cb));
	vala_code_node_accept_children (VALA_CODE_NODE (cb), VALA_CODE_VISITOR (self));
	cfundecl = vala_ccode_function_declarator_new (vala_data_type_get_cname (VALA_DATA_TYPE (cb), FALSE));
	{
		GList* __temp68;
		GList* param_it;
		__temp68 = NULL;
		__temp68 = vala_callback_get_parameters (cb);
		for (param_it = __temp68; param_it != NULL; param_it = param_it->next) {
			ValaFormalParameter* param;
			param = param_it->data;
			{
				vala_ccode_function_declarator_add_parameter (cfundecl, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
			}
		}
		(__temp68 == NULL ? NULL : (__temp68 = (g_list_free (__temp68), NULL)));
	}
	ctypedef = vala_ccode_type_definition_new (vala_type_reference_get_cname (vala_callback_get_return_type (cb), FALSE, FALSE), VALA_CCODE_DECLARATOR (cfundecl));
	if (VALA_DATA_TYPE (cb)->access != VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (ctypedef));
	} else {
		vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (ctypedef));
	}
	(cfundecl == NULL ? NULL : (cfundecl = (g_object_unref (cfundecl), NULL)));
	(ctypedef == NULL ? NULL : (ctypedef = (g_object_unref (ctypedef), NULL)));
}


static void vala_code_generator_real_visit_member (ValaCodeVisitor* base, ValaMember* m)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_MEMBER (m));
	/* stuff meant for all lockable members */
	if (VALA_IS_LOCKABLE (m) && vala_lockable_get_lock_used ((VALA_LOCKABLE (m)))) {
		char* __temp70;
		char* __temp69;
		ValaCCodeExpressionStatement* __temp71;
		ValaCCodeFunctionCall* fc;
		ValaCCodeMemberAccess* __temp72;
		ValaCCodeIdentifier* __temp73;
		__temp70 = NULL;
		__temp69 = NULL;
		vala_ccode_struct_add_field (self->priv->instance_priv_struct, (__temp69 = vala_type_reference_get_cname (self->priv->mutex_type, FALSE, FALSE)), (__temp70 = vala_code_generator_get_symbol_lock_name (self, vala_code_node_get_symbol (VALA_CODE_NODE (m)))));
		(__temp70 = (g_free (__temp70), NULL));
		(__temp69 = (g_free (__temp69), NULL));
		__temp71 = NULL;
		vala_ccode_fragment_append (self->priv->instance_init_fragment, VALA_CCODE_NODE ((__temp71 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), "priv")), vala_code_generator_get_symbol_lock_name (self, vala_code_node_get_symbol (VALA_CODE_NODE (m))))), VALA_CCODE_EXPRESSION (vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_method_get_cname (vala_struct_get_default_construction_method ((VALA_STRUCT (vala_type_reference_get_data_type (self->priv->mutex_type))))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
		(__temp71 == NULL ? NULL : (__temp71 = (g_object_unref (__temp71), NULL)));
		fc = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("VALA_FREE_CHECKED")));
		__temp72 = NULL;
		vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((__temp72 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), "priv")), vala_code_generator_get_symbol_lock_name (self, vala_code_node_get_symbol (VALA_CODE_NODE (m)))))));
		(__temp72 == NULL ? NULL : (__temp72 = (g_object_unref (__temp72), NULL)));
		__temp73 = NULL;
		vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((__temp73 = vala_ccode_identifier_new (vala_data_type_get_free_function (vala_type_reference_get_data_type (self->priv->mutex_type))))));
		(__temp73 == NULL ? NULL : (__temp73 = (g_object_unref (__temp73), NULL)));
		if (self->priv->instance_dispose_fragment != NULL) {
			ValaCCodeExpressionStatement* __temp74;
			__temp74 = NULL;
			vala_ccode_fragment_append (self->priv->instance_dispose_fragment, VALA_CCODE_NODE ((__temp74 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
			(__temp74 == NULL ? NULL : (__temp74 = (g_object_unref (__temp74), NULL)));
		}
		(fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL)));
	}
}


static void vala_code_generator_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CONSTANT (c));
	vala_code_node_accept_children (VALA_CODE_NODE (c), VALA_CODE_VISITOR (self));
	if (VALA_IS_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (c)))))) {
		ValaDataType* __temp75;
		ValaDataType* t;
		ValaCCodeDeclaration* cdecl_;
		char* arr;
		ValaCCodeVariableDeclarator* __temp78;
		char* __temp77;
		__temp75 = NULL;
		t = (__temp75 = VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (c))))), (__temp75 == NULL ? NULL : g_object_ref (__temp75)));
		cdecl_ = vala_ccode_declaration_new (vala_type_reference_get_const_cname (vala_constant_get_type_reference (c)));
		arr = g_strdup ("");
		if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_constant_get_type_reference (c)))) {
			char* __temp76;
			__temp76 = NULL;
			arr = (__temp76 = g_strdup ("[]"), (arr = (g_free (arr), NULL)), __temp76);
		}
		__temp78 = NULL;
		__temp77 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp78 = vala_ccode_variable_declarator_new_with_initializer (g_strdup_printf ("%s%s", (__temp77 = vala_constant_get_cname (c)), arr), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_constant_get_initializer (c))))))));
		(__temp78 == NULL ? NULL : (__temp78 = (g_object_unref (__temp78), NULL)));
		(__temp77 = (g_free (__temp77), NULL));
		(vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_declaration_get_modifiers (cdecl_));
		if (c->access != VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE (cdecl_));
		} else {
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (cdecl_));
		}
		(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
		(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
		(arr = (g_free (arr), NULL));
	}
}


static void vala_code_generator_real_visit_field (ValaCodeVisitor* base, ValaField* f)
{
	ValaCodeGenerator * self;
	ValaCCodeExpression* lhs;
	ValaCCodeStruct* st;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_FIELD (f));
	vala_code_node_accept_children (VALA_CODE_NODE (f), VALA_CODE_VISITOR (self));
	lhs = NULL;
	st = NULL;
	if (f->access != VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
		ValaCCodeStruct* __temp80;
		ValaCCodeStruct* __temp79;
		__temp80 = NULL;
		__temp79 = NULL;
		st = (__temp80 = (__temp79 = self->priv->instance_struct, (__temp79 == NULL ? NULL : g_object_ref (__temp79))), (st == NULL ? NULL : (st = (g_object_unref (st), NULL))), __temp80);
		if (vala_field_get_instance (f)) {
			ValaCCodeExpression* __temp81;
			__temp81 = NULL;
			lhs = (__temp81 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), vala_field_get_cname (f))), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), __temp81);
		}
	} else {
		if (f->access == VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
			if (vala_field_get_instance (f)) {
				ValaCCodeStruct* __temp83;
				ValaCCodeStruct* __temp82;
				ValaCCodeExpression* __temp84;
				__temp83 = NULL;
				__temp82 = NULL;
				st = (__temp83 = (__temp82 = self->priv->instance_priv_struct, (__temp82 == NULL ? NULL : g_object_ref (__temp82))), (st == NULL ? NULL : (st = (g_object_unref (st), NULL))), __temp83);
				__temp84 = NULL;
				lhs = (__temp84 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), "priv")), vala_field_get_cname (f))), (lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL))), __temp84);
			} else {
				if (VALA_IS_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (f)))))) {
					ValaDataType* __temp85;
					ValaDataType* t;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* var_decl;
					__temp85 = NULL;
					t = (__temp85 = VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (f))))), (__temp85 == NULL ? NULL : g_object_ref (__temp85)));
					cdecl_ = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_field_get_type_reference (f), FALSE, FALSE));
					var_decl = vala_ccode_variable_declarator_new (vala_field_get_cname (f));
					if (vala_field_get_initializer (f) != NULL) {
						(vala_ccode_variable_declarator_set_initializer (var_decl, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_field_get_initializer (f))))), vala_ccode_variable_declarator_get_initializer (var_decl));
					}
					vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR (var_decl));
					(vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_declaration_get_modifiers (cdecl_));
					vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (cdecl_));
					(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
					(var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL)));
				}
			}
		}
	}
	if (vala_field_get_instance (f)) {
		char* __temp87;
		char* __temp86;
		__temp87 = NULL;
		__temp86 = NULL;
		vala_ccode_struct_add_field (st, (__temp86 = vala_type_reference_get_cname (vala_field_get_type_reference (f), FALSE, FALSE)), (__temp87 = vala_field_get_cname (f)));
		(__temp87 = (g_free (__temp87), NULL));
		(__temp86 = (g_free (__temp86), NULL));
		if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_field_get_type_reference (f))) && !vala_field_get_no_array_length (f)) {
			ValaArray* __temp88;
			ValaArray* arr;
			/* create fields to store array dimensions*/
			__temp88 = NULL;
			arr = (__temp88 = VALA_ARRAY (vala_type_reference_get_data_type (vala_field_get_type_reference (f))), (__temp88 == NULL ? NULL : g_object_ref (__temp88)));
			{
				gint dim;
				dim = 0;
				for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
					ValaTypeReference* len_type;
					char* __temp90;
					char* __temp89;
					len_type = vala_type_reference_new ();
					(vala_type_reference_set_data_type (len_type, vala_type_reference_get_data_type (self->priv->int_type)), vala_type_reference_get_data_type (len_type));
					__temp90 = NULL;
					__temp89 = NULL;
					vala_ccode_struct_add_field (st, (__temp89 = vala_type_reference_get_cname (len_type, FALSE, FALSE)), (__temp90 = vala_code_generator_get_array_length_cname (self, vala_field_get_name (f), dim)));
					(__temp90 = (g_free (__temp90), NULL));
					(__temp89 = (g_free (__temp89), NULL));
					(len_type == NULL ? NULL : (len_type = (g_object_unref (len_type), NULL)));
				}
			}
			(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
		}
		if (vala_field_get_initializer (f) != NULL) {
			ValaCCodeExpressionStatement* __temp91;
			__temp91 = NULL;
			vala_ccode_fragment_append (self->priv->instance_init_fragment, VALA_CCODE_NODE ((__temp91 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (lhs, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_field_get_initializer (f)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
			(__temp91 == NULL ? NULL : (__temp91 = (g_object_unref (__temp91), NULL)));
			if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_field_get_type_reference (f))) && !vala_field_get_no_array_length (f) && VALA_IS_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f))) {
				ValaMemberAccess* ma;
				ValaCCodeExpression* array_len_lhs;
				GList* sizes;
				ValaExpression* __temp92;
				ValaExpression* size;
				ValaCCodeExpressionStatement* __temp93;
				ma = vala_member_access_new_simple (vala_field_get_name (f), NULL);
				(vala_expression_set_symbol_reference (VALA_EXPRESSION (ma), vala_code_node_get_symbol (VALA_CODE_NODE (f))), vala_expression_get_symbol_reference (VALA_EXPRESSION (ma)));
				array_len_lhs = vala_code_generator_get_array_length_cexpression (self, VALA_EXPRESSION (ma), 1);
				sizes = vala_array_creation_expression_get_sizes ((VALA_ARRAY_CREATION_EXPRESSION (vala_field_get_initializer (f))));
				__temp92 = NULL;
				size = (__temp92 = VALA_EXPRESSION (sizes->data), (__temp92 == NULL ? NULL : g_object_ref (__temp92)));
				__temp93 = NULL;
				vala_ccode_fragment_append (self->priv->instance_init_fragment, VALA_CCODE_NODE ((__temp93 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (array_len_lhs, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (size))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
				(__temp93 == NULL ? NULL : (__temp93 = (g_object_unref (__temp93), NULL)));
				(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
				(array_len_lhs = (g_object_unref (array_len_lhs), NULL));
				(sizes == NULL ? NULL : (sizes = (g_list_free (sizes), NULL)));
				(size == NULL ? NULL : (size = (g_object_unref (size), NULL)));
			}
		}
		if (vala_type_reference_get_takes_ownership (vala_field_get_type_reference (f)) && self->priv->instance_dispose_fragment != NULL) {
			ValaCCodeExpressionStatement* __temp94;
			__temp94 = NULL;
			vala_ccode_fragment_append (self->priv->instance_dispose_fragment, VALA_CCODE_NODE ((__temp94 = vala_ccode_expression_statement_new (vala_code_generator_get_unref_expression (self, lhs, vala_field_get_type_reference (f))))));
			(__temp94 == NULL ? NULL : (__temp94 = (g_object_unref (__temp94), NULL)));
		}
	}
	(lhs == NULL ? NULL : (lhs = (g_object_unref (lhs), NULL)));
	(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
}


static void vala_code_generator_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_FORMAL_PARAMETER (p));
	vala_code_node_accept_children (VALA_CODE_NODE (p), VALA_CODE_VISITOR (self));
	if (!vala_formal_parameter_get_ellipsis (p)) {
		ValaCCodeFormalParameter* __temp95;
		__temp95 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (p), VALA_CCODE_NODE ((__temp95 = vala_ccode_formal_parameter_new (vala_formal_parameter_get_name (p), vala_type_reference_get_cname (vala_formal_parameter_get_type_reference (p), FALSE, !vala_type_reference_get_takes_ownership (vala_formal_parameter_get_type_reference (p))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (p)));
		(__temp95 == NULL ? NULL : (__temp95 = (g_object_unref (__temp95), NULL)));
	}
}


static void vala_code_generator_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop)
{
	ValaCodeGenerator * self;
	char* __temp96;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_PROPERTY (prop));
	vala_code_node_accept_children (VALA_CODE_NODE (prop), VALA_CODE_VISITOR (self));
	__temp96 = NULL;
	vala_ccode_enum_add_value (self->priv->prop_enum, (__temp96 = vala_property_get_upper_case_cname (prop)), NULL);
	(__temp96 = (g_free (__temp96), NULL));
}


static void vala_code_generator_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc)
{
	ValaCodeGenerator * self;
	ValaProperty* __temp97;
	ValaProperty* prop;
	ValaTypeReference* __temp101;
	ValaDataType* __temp102;
	ValaDataType* t;
	ValaTypeReference* this_type;
	ValaCCodeFormalParameter* cselfparam;
	ValaCCodeFormalParameter* cvalueparam;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_PROPERTY_ACCESSOR (acc));
	__temp97 = NULL;
	prop = (__temp97 = VALA_PROPERTY (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (acc))))), (__temp97 == NULL ? NULL : g_object_ref (__temp97)));
	if (vala_property_accessor_get_readable (acc)) {
		ValaTypeReference* __temp99;
		ValaTypeReference* __temp98;
		__temp99 = NULL;
		__temp98 = NULL;
		self->priv->current_return_type = (__temp99 = (__temp98 = vala_property_get_type_reference (prop), (__temp98 == NULL ? NULL : g_object_ref (__temp98))), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), __temp99);
	} else {
		ValaTypeReference* __temp100;
		/* void*/
		__temp100 = NULL;
		self->priv->current_return_type = (__temp100 = vala_type_reference_new (), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), __temp100);
	}
	vala_code_node_accept_children (VALA_CODE_NODE (acc), VALA_CODE_VISITOR (self));
	__temp101 = NULL;
	self->priv->current_return_type = (__temp101 = NULL, (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), __temp101);
	__temp102 = NULL;
	t = (__temp102 = VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (prop))))), (__temp102 == NULL ? NULL : g_object_ref (__temp102)));
	this_type = vala_type_reference_new ();
	(vala_type_reference_set_data_type (this_type, t), vala_type_reference_get_data_type (this_type));
	cselfparam = vala_ccode_formal_parameter_new ("self", vala_type_reference_get_cname (this_type, FALSE, FALSE));
	cvalueparam = vala_ccode_formal_parameter_new ("value", vala_type_reference_get_cname (vala_property_get_type_reference (prop), FALSE, TRUE));
	if (vala_property_get_is_abstract (prop) || vala_property_get_is_virtual (prop)) {
		ValaCCodeFunction* __temp107;
		ValaCCodeBlock* block;
		if (vala_property_accessor_get_readable (acc)) {
			ValaCCodeFunction* __temp104;
			char* __temp103;
			__temp104 = NULL;
			__temp103 = NULL;
			self->priv->function = (__temp104 = vala_ccode_function_new (g_strdup_printf ("%s_get_%s", (__temp103 = vala_data_type_get_lower_case_cname (t, NULL)), vala_property_get_name (prop)), vala_type_reference_get_cname (vala_property_get_type_reference (prop), FALSE, FALSE)), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp104);
			(__temp103 = (g_free (__temp103), NULL));
		} else {
			ValaCCodeFunction* __temp106;
			char* __temp105;
			__temp106 = NULL;
			__temp105 = NULL;
			self->priv->function = (__temp106 = vala_ccode_function_new (g_strdup_printf ("%s_set_%s", (__temp105 = vala_data_type_get_lower_case_cname (t, NULL)), vala_property_get_name (prop)), "void"), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp106);
			(__temp105 = (g_free (__temp105), NULL));
		}
		vala_ccode_function_add_parameter (self->priv->function, cselfparam);
		if (vala_property_accessor_get_writable (acc) || vala_property_accessor_get_construction (acc)) {
			vala_ccode_function_add_parameter (self->priv->function, cvalueparam);
		}
		__temp107 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp107 = vala_ccode_function_copy (self->priv->function))));
		(__temp107 = (g_object_unref (__temp107), NULL));
		block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		(vala_ccode_function_set_block (self->priv->function, block), vala_ccode_function_get_block (self->priv->function));
		if (vala_property_accessor_get_readable (acc)) {
			ValaCCodeDeclaration* decl;
			ValaCCodeVariableDeclarator* __temp108;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* __temp109;
			ValaCCodeConstant* __temp110;
			ValaCCodeUnaryExpression* __temp111;
			ValaCCodeConstant* __temp112;
			ValaCCodeExpressionStatement* __temp113;
			ValaCCodeReturnStatement* __temp114;
			/* declare temporary variable to save the property value*/
			decl = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_property_get_type_reference (prop), FALSE, FALSE));
			__temp108 = NULL;
			vala_ccode_declaration_add_declarator (decl, VALA_CCODE_DECLARATOR ((__temp108 = vala_ccode_variable_declarator_new ("value"))));
			(__temp108 == NULL ? NULL : (__temp108 = (g_object_unref (__temp108), NULL)));
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE (decl));
			ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_get")));
			ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT")));
			__temp109 = NULL;
			vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((__temp109 = vala_ccode_identifier_new ("self"))));
			(__temp109 == NULL ? NULL : (__temp109 = (g_object_unref (__temp109), NULL)));
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
			/* property name is second argument of g_object_get*/
			__temp110 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp110 = vala_property_get_canonical_cconstant (prop))));
			(__temp110 = (g_object_unref (__temp110), NULL));
			__temp111 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp111 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("value"))))));
			(__temp111 == NULL ? NULL : (__temp111 = (g_object_unref (__temp111), NULL)));
			__temp112 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp112 = vala_ccode_constant_new ("NULL"))));
			(__temp112 == NULL ? NULL : (__temp112 = (g_object_unref (__temp112), NULL)));
			__temp113 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((__temp113 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(__temp113 == NULL ? NULL : (__temp113 = (g_object_unref (__temp113), NULL)));
			__temp114 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((__temp114 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("value"))))));
			(__temp114 == NULL ? NULL : (__temp114 = (g_object_unref (__temp114), NULL)));
			(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
		} else {
			ValaCCodeFunctionCall* ccall;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* __temp115;
			ValaCCodeConstant* __temp116;
			ValaCCodeIdentifier* __temp117;
			ValaCCodeConstant* __temp118;
			ValaCCodeExpressionStatement* __temp119;
			ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_set")));
			ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT")));
			__temp115 = NULL;
			vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((__temp115 = vala_ccode_identifier_new ("self"))));
			(__temp115 == NULL ? NULL : (__temp115 = (g_object_unref (__temp115), NULL)));
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
			/* property name is second argument of g_object_set*/
			__temp116 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp116 = vala_property_get_canonical_cconstant (prop))));
			(__temp116 = (g_object_unref (__temp116), NULL));
			__temp117 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp117 = vala_ccode_identifier_new ("value"))));
			(__temp117 == NULL ? NULL : (__temp117 = (g_object_unref (__temp117), NULL)));
			__temp118 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp118 = vala_ccode_constant_new ("NULL"))));
			(__temp118 == NULL ? NULL : (__temp118 = (g_object_unref (__temp118), NULL)));
			__temp119 = NULL;
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((__temp119 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(__temp119 == NULL ? NULL : (__temp119 = (g_object_unref (__temp119), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
		}
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
		(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	}
	if (!vala_property_get_is_abstract (prop)) {
		gboolean is_virtual;
		char* prefix;
		is_virtual = vala_property_get_base_property (prop) != NULL || vala_property_get_base_interface_property (prop) != NULL;
		prefix = vala_data_type_get_lower_case_cname (t, NULL);
		if (is_virtual) {
			char* __temp120;
			__temp120 = NULL;
			prefix = (__temp120 = g_strconcat (prefix, ("_real"), NULL), (prefix = (g_free (prefix), NULL)), __temp120);
		}
		if (vala_property_accessor_get_readable (acc)) {
			ValaCCodeFunction* __temp121;
			__temp121 = NULL;
			self->priv->function = (__temp121 = vala_ccode_function_new (g_strdup_printf ("%s_get_%s", prefix, vala_property_get_name (prop)), vala_type_reference_get_cname (vala_property_get_type_reference (prop), FALSE, FALSE)), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp121);
		} else {
			ValaCCodeFunction* __temp122;
			__temp122 = NULL;
			self->priv->function = (__temp122 = vala_ccode_function_new (g_strdup_printf ("%s_set_%s", prefix, vala_property_get_name (prop)), "void"), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp122);
		}
		if (is_virtual) {
			(vala_ccode_function_set_modifiers (self->priv->function, vala_ccode_function_get_modifiers (self->priv->function) | (VALA_CCODE_MODIFIERS_STATIC)), vala_ccode_function_get_modifiers (self->priv->function));
		}
		vala_ccode_function_add_parameter (self->priv->function, cselfparam);
		if (vala_property_accessor_get_writable (acc) || vala_property_accessor_get_construction (acc)) {
			vala_ccode_function_add_parameter (self->priv->function, cvalueparam);
		}
		if (!is_virtual) {
			ValaCCodeFunction* __temp123;
			__temp123 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp123 = vala_ccode_function_copy (self->priv->function))));
			(__temp123 = (g_object_unref (__temp123), NULL));
		}
		if (vala_property_accessor_get_body (acc) != NULL) {
			ValaCCodeStatement* __temp124;
			(vala_ccode_function_set_block (self->priv->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_accessor_get_body (acc))))), vala_ccode_function_get_block (self->priv->function));
			__temp124 = NULL;
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE ((__temp124 = vala_code_generator_create_property_type_check_statement (self, prop, vala_property_accessor_get_readable (acc), t, TRUE, "self"))));
			(__temp124 == NULL ? NULL : (__temp124 = (g_object_unref (__temp124), NULL)));
		}
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
		(prefix = (g_free (prefix), NULL));
	}
	(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
	(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
	(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
	(cselfparam == NULL ? NULL : (cselfparam = (g_object_unref (cselfparam), NULL)));
	(cvalueparam == NULL ? NULL : (cvalueparam = (g_object_unref (cvalueparam), NULL)));
}


static void vala_code_generator_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c)
{
	ValaCodeGenerator * self;
	ValaClass* __temp125;
	ValaClass* cl;
	ValaCCodeFunction* __temp127;
	char* __temp126;
	ValaCCodeFormalParameter* __temp128;
	ValaCCodeFormalParameter* __temp129;
	ValaCCodeFormalParameter* __temp130;
	ValaCCodeFunction* __temp131;
	ValaCCodeBlock* cblock;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* __temp132;
	ValaCCodeDeclaration* __temp134;
	char* __temp133;
	ValaCCodeVariableDeclarator* __temp135;
	ValaCCodeDeclaration* __temp136;
	ValaCCodeVariableDeclarator* __temp137;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* __temp138;
	char* __temp139;
	ValaCCodeFunctionCall* __temp140;
	ValaCCodeFunctionCall* ccast;
	ValaCCodeExpressionStatement* __temp141;
	ValaCCodeFunctionCall* __temp142;
	ValaCCodeIdentifier* __temp143;
	ValaCCodeFunctionCall* __temp144;
	ValaCCodeExpressionStatement* __temp145;
	ValaCCodeFunctionCall* __temp146;
	ValaCCodeIdentifier* __temp147;
	ValaCCodeIdentifier* __temp148;
	ValaCCodeIdentifier* __temp149;
	ValaCCodeExpressionStatement* __temp150;
	ValaCCodeFunctionCall* __temp151;
	ValaCCodeIdentifier* __temp152;
	ValaCCodeDeclaration* __temp154;
	char* __temp153;
	ValaCCodeVariableDeclarator* __temp155;
	ValaCCodeReturnStatement* __temp157;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CONSTRUCTOR (c));
	self->priv->current_method_inner_error = FALSE;
	vala_code_node_accept_children (VALA_CODE_NODE (c), VALA_CODE_VISITOR (self));
	__temp125 = NULL;
	cl = (__temp125 = VALA_CLASS (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (c))))), (__temp125 == NULL ? NULL : g_object_ref (__temp125)));
	__temp127 = NULL;
	__temp126 = NULL;
	self->priv->function = (__temp127 = vala_ccode_function_new (g_strdup_printf ("%s_constructor", (__temp126 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))), "GObject *"), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp127);
	(__temp126 = (g_free (__temp126), NULL));
	(vala_ccode_function_set_modifiers (self->priv->function, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (self->priv->function));
	__temp128 = NULL;
	vala_ccode_function_add_parameter (self->priv->function, (__temp128 = vala_ccode_formal_parameter_new ("type", "GType")));
	(__temp128 == NULL ? NULL : (__temp128 = (g_object_unref (__temp128), NULL)));
	__temp129 = NULL;
	vala_ccode_function_add_parameter (self->priv->function, (__temp129 = vala_ccode_formal_parameter_new ("n_construct_properties", "guint")));
	(__temp129 == NULL ? NULL : (__temp129 = (g_object_unref (__temp129), NULL)));
	__temp130 = NULL;
	vala_ccode_function_add_parameter (self->priv->function, (__temp130 = vala_ccode_formal_parameter_new ("construct_properties", "GObjectConstructParam *")));
	(__temp130 == NULL ? NULL : (__temp130 = (g_object_unref (__temp130), NULL)));
	__temp131 = NULL;
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((__temp131 = vala_ccode_function_copy (self->priv->function))));
	(__temp131 = (g_object_unref (__temp131), NULL));
	cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	cdecl_ = vala_ccode_declaration_new ("GObject *");
	__temp132 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp132 = vala_ccode_variable_declarator_new ("obj"))));
	(__temp132 == NULL ? NULL : (__temp132 = (g_object_unref (__temp132), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	__temp134 = NULL;
	__temp133 = NULL;
	cdecl_ = (__temp134 = vala_ccode_declaration_new (g_strdup_printf ("%sClass *", (__temp133 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), __temp134);
	(__temp133 = (g_free (__temp133), NULL));
	__temp135 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp135 = vala_ccode_variable_declarator_new ("klass"))));
	(__temp135 == NULL ? NULL : (__temp135 = (g_object_unref (__temp135), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	__temp136 = NULL;
	cdecl_ = (__temp136 = vala_ccode_declaration_new ("GObjectClass *"), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), __temp136);
	__temp137 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp137 = vala_ccode_variable_declarator_new ("parent_class"))));
	(__temp137 == NULL ? NULL : (__temp137 = (g_object_unref (__temp137), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_class_peek")));
	__temp138 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp138 = vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")))));
	(__temp138 == NULL ? NULL : (__temp138 = (g_object_unref (__temp138), NULL)));
	__temp139 = NULL;
	__temp140 = NULL;
	ccast = (__temp140 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_CLASS", (__temp139 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))), (__temp139 = (g_free (__temp139), NULL)), __temp140);
	vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (ccall));
	__temp141 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp141 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("klass")), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp141 == NULL ? NULL : (__temp141 = (g_object_unref (__temp141), NULL)));
	__temp142 = NULL;
	ccall = (__temp142 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_class_peek_parent"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp142);
	__temp143 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp143 = vala_ccode_identifier_new ("klass"))));
	(__temp143 == NULL ? NULL : (__temp143 = (g_object_unref (__temp143), NULL)));
	__temp144 = NULL;
	ccast = (__temp144 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT_CLASS"))), (ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL))), __temp144);
	vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (ccall));
	__temp145 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp145 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("parent_class")), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp145 == NULL ? NULL : (__temp145 = (g_object_unref (__temp145), NULL)));
	__temp146 = NULL;
	ccall = (__temp146 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("parent_class")), "constructor"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp146);
	__temp147 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp147 = vala_ccode_identifier_new ("type"))));
	(__temp147 == NULL ? NULL : (__temp147 = (g_object_unref (__temp147), NULL)));
	__temp148 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp148 = vala_ccode_identifier_new ("n_construct_properties"))));
	(__temp148 == NULL ? NULL : (__temp148 = (g_object_unref (__temp148), NULL)));
	__temp149 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp149 = vala_ccode_identifier_new ("construct_properties"))));
	(__temp149 == NULL ? NULL : (__temp149 = (g_object_unref (__temp149), NULL)));
	__temp150 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp150 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("obj")), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp150 == NULL ? NULL : (__temp150 = (g_object_unref (__temp150), NULL)));
	__temp151 = NULL;
	ccall = (__temp151 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp151);
	__temp152 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp152 = vala_ccode_identifier_new ("obj"))));
	(__temp152 == NULL ? NULL : (__temp152 = (g_object_unref (__temp152), NULL)));
	__temp154 = NULL;
	__temp153 = NULL;
	cdecl_ = (__temp154 = vala_ccode_declaration_new (g_strdup_printf ("%s *", (__temp153 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), __temp154);
	(__temp153 = (g_free (__temp153), NULL));
	__temp155 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp155 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(__temp155 == NULL ? NULL : (__temp155 = (g_object_unref (__temp155), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	if (self->priv->current_method_inner_error) {
		ValaCCodeDeclaration* cdecl_;
		ValaCCodeVariableDeclarator* __temp156;
		/* always separate error parameter and inner_error local variable
		 * as error may be set to NULL but we're always interested in inner errors
		 */
		cdecl_ = vala_ccode_declaration_new ("GError *");
		__temp156 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp156 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"))))));
		(__temp156 == NULL ? NULL : (__temp156 = (g_object_unref (__temp156), NULL)));
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
		(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	}
	vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_constructor_get_body (c))));
	__temp157 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp157 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("obj"))))));
	(__temp157 == NULL ? NULL : (__temp157 = (g_object_unref (__temp157), NULL)));
	(vala_ccode_function_set_block (self->priv->function, cblock), vala_ccode_function_get_block (self->priv->function));
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (c))) != NULL) {
		ValaCCodeComment* __temp158;
		__temp158 = NULL;
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE ((__temp158 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (c)))))));
		(__temp158 == NULL ? NULL : (__temp158 = (g_object_unref (__temp158), NULL)));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
	(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
}


static void vala_code_generator_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_DESTRUCTOR (d));
	vala_code_node_accept_children (VALA_CODE_NODE (d), VALA_CODE_VISITOR (self));
}


static void vala_code_generator_real_visit_begin_block (ValaCodeVisitor* base, ValaBlock* b)
{
	ValaCodeGenerator * self;
	ValaSymbol* __temp160;
	ValaSymbol* __temp159;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_BLOCK (b));
	__temp160 = NULL;
	__temp159 = NULL;
	self->priv->current_symbol = (__temp160 = (__temp159 = vala_code_node_get_symbol (VALA_CODE_NODE (b)), (__temp159 == NULL ? NULL : g_object_ref (__temp159))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp160);
}


static void vala_code_generator_add_object_creation (ValaCodeGenerator* self, ValaCCodeBlock* b)
{
	ValaClass* __temp161;
	ValaClass* cl;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeConstant* __temp162;
	ValaCCodeConstant* __temp163;
	ValaCCodeConstant* __temp164;
	ValaCCodeVariableDeclarator* cdecl_;
	char* __temp165;
	ValaCCodeDeclaration* __temp166;
	ValaCCodeDeclaration* cdeclaration;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CCODE_BLOCK (b));
	__temp161 = NULL;
	cl = (__temp161 = VALA_CLASS (vala_symbol_get_node (self->priv->current_type_symbol)), (__temp161 == NULL ? NULL : g_object_ref (__temp161)));
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_newv")));
	__temp162 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp162 = vala_ccode_constant_new (vala_data_type_get_type_id (VALA_DATA_TYPE (cl))))));
	(__temp162 == NULL ? NULL : (__temp162 = (g_object_unref (__temp162), NULL)));
	__temp163 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp163 = vala_ccode_constant_new ("__params_it - __params"))));
	(__temp163 == NULL ? NULL : (__temp163 = (g_object_unref (__temp163), NULL)));
	__temp164 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp164 = vala_ccode_constant_new ("__params"))));
	(__temp164 == NULL ? NULL : (__temp164 = (g_object_unref (__temp164), NULL)));
	cdecl_ = vala_ccode_variable_declarator_new ("self");
	(vala_ccode_variable_declarator_set_initializer (cdecl_, VALA_CCODE_EXPRESSION (ccall)), vala_ccode_variable_declarator_get_initializer (cdecl_));
	__temp165 = NULL;
	__temp166 = NULL;
	cdeclaration = (__temp166 = vala_ccode_declaration_new (g_strdup_printf ("%s *", (__temp165 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (__temp165 = (g_free (__temp165), NULL)), __temp166);
	vala_ccode_declaration_add_declarator (cdeclaration, VALA_CCODE_DECLARATOR (cdecl_));
	vala_ccode_block_add_statement (b, VALA_CCODE_NODE (cdeclaration));
	(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(cdeclaration == NULL ? NULL : (cdeclaration = (g_object_unref (cdeclaration), NULL)));
}


static void vala_code_generator_real_visit_end_block (ValaCodeVisitor* base, ValaBlock* b)
{
	ValaCodeGenerator * self;
	GList* local_vars;
	ValaCCodeBlock* cblock;
	ValaSymbol* __temp176;
	ValaSymbol* __temp175;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_BLOCK (b));
	local_vars = vala_block_get_local_variables (b);
	{
		GList* __temp167;
		GList* decl_it;
		__temp167 = NULL;
		__temp167 = local_vars;
		for (decl_it = __temp167; decl_it != NULL; decl_it = decl_it->next) {
			ValaVariableDeclarator* decl;
			decl = decl_it->data;
			{
				(vala_symbol_set_active (vala_code_node_get_symbol (VALA_CODE_NODE (decl)), FALSE), vala_symbol_get_active (vala_code_node_get_symbol (VALA_CODE_NODE (decl))));
			}
		}
	}
	cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	{
		GList* __temp171;
		GList* stmt_it;
		__temp171 = NULL;
		__temp171 = vala_block_get_statements (b);
		for (stmt_it = __temp171; stmt_it != NULL; stmt_it = stmt_it->next) {
			ValaStatement* stmt;
			stmt = stmt_it->data;
			{
				ValaSourceReference* __temp168;
				ValaSourceReference* src;
				__temp168 = NULL;
				src = (__temp168 = vala_code_node_get_source_reference (VALA_CODE_NODE (stmt)), (__temp168 == NULL ? NULL : g_object_ref (__temp168)));
				if (src != NULL && vala_source_reference_get_comment (src) != NULL) {
					ValaCCodeComment* __temp169;
					__temp169 = NULL;
					vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp169 = vala_ccode_comment_new (vala_source_reference_get_comment (src)))));
					(__temp169 == NULL ? NULL : (__temp169 = (g_object_unref (__temp169), NULL)));
				}
				if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)))) {
					{
						GList* __temp170;
						GList* cstmt_it;
						__temp170 = NULL;
						__temp170 = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)))));
						for (cstmt_it = __temp170; cstmt_it != NULL; cstmt_it = cstmt_it->next) {
							ValaCCodeStatement* cstmt;
							cstmt = cstmt_it->data;
							{
								vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cstmt));
							}
						}
						(__temp170 == NULL ? NULL : (__temp170 = (g_list_free (__temp170), NULL)));
					}
				} else {
					vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)))));
				}
				(src == NULL ? NULL : (src = (g_object_unref (src), NULL)));
			}
		}
		(__temp171 == NULL ? NULL : (__temp171 = (g_list_free (__temp171), NULL)));
	}
	if (vala_code_generator_get_memory_management (self)) {
		{
			GList* __temp174;
			GList* decl_it;
			__temp174 = NULL;
			__temp174 = local_vars;
			for (decl_it = __temp174; decl_it != NULL; decl_it = decl_it->next) {
				ValaVariableDeclarator* decl;
				decl = decl_it->data;
				{
					if (vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
						ValaCCodeExpressionStatement* __temp173;
						ValaCCodeIdentifier* __temp172;
						__temp173 = NULL;
						__temp172 = NULL;
						vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp173 = vala_ccode_expression_statement_new (vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((__temp172 = vala_ccode_identifier_new (vala_code_generator_get_variable_cname (self, vala_variable_declarator_get_name (decl))))), vala_variable_declarator_get_type_reference (decl))))));
						(__temp173 == NULL ? NULL : (__temp173 = (g_object_unref (__temp173), NULL)));
						(__temp172 == NULL ? NULL : (__temp172 = (g_object_unref (__temp172), NULL)));
					}
				}
			}
		}
	}
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (b), VALA_CCODE_NODE (cblock)), vala_code_node_get_ccodenode (VALA_CODE_NODE (b)));
	__temp176 = NULL;
	__temp175 = NULL;
	self->priv->current_symbol = (__temp176 = (__temp175 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (__temp175 == NULL ? NULL : g_object_ref (__temp175))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp176);
	(local_vars == NULL ? NULL : (local_vars = (g_list_free (local_vars), NULL)));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
}


static void vala_code_generator_real_visit_empty_statement (ValaCodeVisitor* base, ValaEmptyStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeEmptyStatement* __temp177;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_EMPTY_STATEMENT (stmt));
	__temp177 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp177 = g_object_new (VALA_TYPE_CCODE_EMPTY_STATEMENT, NULL)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(__temp177 == NULL ? NULL : (__temp177 = (g_object_unref (__temp177), NULL)));
}


static gboolean vala_code_generator_struct_has_instance_fields (ValaCodeGenerator* self, ValaStruct* st)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (VALA_IS_STRUCT (st), FALSE);
	{
		GList* __temp179;
		GList* f_it;
		__temp179 = NULL;
		__temp179 = vala_struct_get_fields (st);
		for (f_it = __temp179; f_it != NULL; f_it = f_it->next) {
			ValaField* f;
			f = f_it->data;
			{
				if (vala_field_get_instance (f)) {
					return TRUE;
				}
			}
		}
		(__temp179 == NULL ? NULL : (__temp179 = (g_list_free (__temp179), NULL)));
	}
	return FALSE;
}


static void vala_code_generator_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeFragment* cfrag;
	GList* __temp195;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_DECLARATION_STATEMENT (stmt));
	/* split declaration statement as var declarators
	 * might have different types */
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	{
		GList* __temp193;
		GList* decl_it;
		__temp193 = NULL;
		__temp193 = vala_local_variable_declaration_get_variable_declarators (vala_declaration_statement_get_declaration (stmt));
		for (decl_it = __temp193; decl_it != NULL; decl_it = decl_it->next) {
			ValaVariableDeclarator* decl;
			decl = decl_it->data;
			{
				ValaCCodeDeclaration* cdecl_;
				cdecl_ = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_variable_declarator_get_type_reference (decl), FALSE, !vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))));
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR (VALA_CCODE_VARIABLE_DECLARATOR (vala_code_node_get_ccodenode (VALA_CODE_NODE (decl)))));
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE (cdecl_));
				if (vala_variable_declarator_get_initializer (decl) != NULL && vala_expression_get_can_fail (vala_variable_declarator_get_initializer (decl))) {
					vala_code_generator_add_simple_check (self, VALA_CODE_NODE (vala_variable_declarator_get_initializer (decl)), cfrag);
				}
				/* try to initialize uninitialized variables */
				if (vala_variable_declarator_get_initializer (decl) == NULL && VALA_IS_STRUCT (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
					if (vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
						ValaCCodeConstant* __temp181;
						__temp181 = NULL;
						(vala_ccode_variable_declarator_set_initializer ((VALA_CCODE_VARIABLE_DECLARATOR (vala_code_node_get_ccodenode (VALA_CODE_NODE (decl)))), VALA_CCODE_EXPRESSION ((__temp181 = vala_ccode_constant_new ("NULL")))), vala_ccode_variable_declarator_get_initializer ((VALA_CCODE_VARIABLE_DECLARATOR (vala_code_node_get_ccodenode (VALA_CODE_NODE (decl))))));
						(__temp181 == NULL ? NULL : (__temp181 = (g_object_unref (__temp181), NULL)));
					} else {
						char* __temp182;
						gboolean __temp183;
						__temp182 = NULL;
						if ((__temp183 = (__temp182 = vala_data_type_get_default_value (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) != NULL, (__temp182 = (g_free (__temp182), NULL)), __temp183)) {
							ValaCCodeConstant* __temp184;
							__temp184 = NULL;
							(vala_ccode_variable_declarator_set_initializer ((VALA_CCODE_VARIABLE_DECLARATOR (vala_code_node_get_ccodenode (VALA_CODE_NODE (decl)))), VALA_CCODE_EXPRESSION ((__temp184 = vala_ccode_constant_new (vala_data_type_get_default_value (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))))))), vala_ccode_variable_declarator_get_initializer ((VALA_CCODE_VARIABLE_DECLARATOR (vala_code_node_get_ccodenode (VALA_CODE_NODE (decl))))));
							(__temp184 == NULL ? NULL : (__temp184 = (g_object_unref (__temp184), NULL)));
						} else {
							if (VALA_IS_STRUCT (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))) && vala_code_generator_struct_has_instance_fields (self, VALA_STRUCT (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))))) {
								ValaStruct* __temp185;
								ValaStruct* st;
								ValaCCodeFunctionCall* czero;
								ValaCCodeUnaryExpression* __temp186;
								ValaCCodeConstant* __temp187;
								ValaCCodeIdentifier* __temp189;
								char* __temp188;
								ValaCCodeExpressionStatement* __temp190;
								__temp185 = NULL;
								st = (__temp185 = VALA_STRUCT (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))), (__temp185 == NULL ? NULL : g_object_ref (__temp185)));
								/* memset needs string.h */
								self->priv->string_h_needed = TRUE;
								czero = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("memset")));
								__temp186 = NULL;
								vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((__temp186 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_code_generator_get_variable_cname (self, vala_variable_declarator_get_name (decl))))))));
								(__temp186 == NULL ? NULL : (__temp186 = (g_object_unref (__temp186), NULL)));
								__temp187 = NULL;
								vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((__temp187 = vala_ccode_constant_new ("0"))));
								(__temp187 == NULL ? NULL : (__temp187 = (g_object_unref (__temp187), NULL)));
								__temp189 = NULL;
								__temp188 = NULL;
								vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((__temp189 = vala_ccode_identifier_new (g_strdup_printf ("sizeof (%s)", (__temp188 = vala_type_reference_get_cname (vala_variable_declarator_get_type_reference (decl), FALSE, FALSE)))))));
								(__temp189 == NULL ? NULL : (__temp189 = (g_object_unref (__temp189), NULL)));
								(__temp188 = (g_free (__temp188), NULL));
								__temp190 = NULL;
								vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp190 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (czero)))));
								(__temp190 == NULL ? NULL : (__temp190 = (g_object_unref (__temp190), NULL)));
								(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
								(czero == NULL ? NULL : (czero = (g_object_unref (czero), NULL)));
							} else {
								char* __temp192;
								char* __temp191;
								__temp192 = NULL;
								__temp191 = NULL;
								vala_report_warning (vala_code_node_get_source_reference (VALA_CODE_NODE (decl)), (__temp192 = g_strdup_printf ("unable to initialize a variable of type `%s'", (__temp191 = vala_symbol_get_full_name (vala_code_node_get_symbol (VALA_CODE_NODE (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))))))));
								(__temp192 = (g_free (__temp192), NULL));
								(__temp191 = (g_free (__temp191), NULL));
							}
						}
					}
				}
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			}
		}
		(__temp193 == NULL ? NULL : (__temp193 = (g_list_free (__temp193), NULL)));
	}
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	{
		GList* __temp194;
		GList* decl_it;
		__temp194 = NULL;
		__temp194 = vala_local_variable_declaration_get_variable_declarators (vala_declaration_statement_get_declaration (stmt));
		for (decl_it = __temp194; decl_it != NULL; decl_it = decl_it->next) {
			ValaVariableDeclarator* decl;
			decl = decl_it->data;
			{
				if (vala_variable_declarator_get_initializer (decl) != NULL) {
					vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), vala_variable_declarator_get_initializer (decl)->temp_vars);
				}
			}
		}
		(__temp194 == NULL ? NULL : (__temp194 = (g_list_free (__temp194), NULL)));
	}
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), self->priv->temp_vars);
	__temp195 = NULL;
	self->priv->temp_vars = (__temp195 = NULL, (self->priv->temp_vars == NULL ? NULL : (self->priv->temp_vars = (g_list_foreach (self->priv->temp_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_vars), NULL))), __temp195);
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static char* vala_code_generator_get_variable_cname (ValaCodeGenerator* self, const char* name)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (GPOINTER_TO_INT (g_hash_table_lookup (self->priv->c_keywords, name))) {
		return g_strconcat (name, "_", NULL);
	} else {
		return g_strdup (name);
	}
}


static void vala_code_generator_real_visit_variable_declarator (ValaCodeVisitor* base, ValaVariableDeclarator* decl)
{
	ValaCodeGenerator * self;
	ValaCCodeExpression* rhs;
	ValaCCodeVariableDeclarator* __temp212;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_VARIABLE_DECLARATOR (decl));
	if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
		ValaArray* __temp198;
		ValaArray* arr;
		/* create variables to store array dimensions*/
		__temp198 = NULL;
		arr = (__temp198 = VALA_ARRAY (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))), (__temp198 == NULL ? NULL : g_object_ref (__temp198)));
		{
			gint dim;
			dim = 0;
			for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
				ValaVariableDeclarator* len_decl;
				ValaTypeReference* __temp199;
				ValaVariableDeclarator* __temp200;
				len_decl = vala_variable_declarator_new (vala_code_generator_get_array_length_cname (self, vala_variable_declarator_get_name (decl), dim), NULL, NULL);
				__temp199 = NULL;
				(vala_variable_declarator_set_type_reference (len_decl, (__temp199 = vala_type_reference_new ())), vala_variable_declarator_get_type_reference (len_decl));
				(__temp199 == NULL ? NULL : (__temp199 = (g_object_unref (__temp199), NULL)));
				(vala_type_reference_set_data_type (vala_variable_declarator_get_type_reference (len_decl), vala_type_reference_get_data_type (self->priv->int_type)), vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (len_decl)));
				__temp200 = NULL;
				self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp200 = len_decl, (__temp200 == NULL ? NULL : g_object_ref (__temp200))));
				(len_decl == NULL ? NULL : (len_decl = (g_object_unref (len_decl), NULL)));
			}
		}
		(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
	}
	rhs = NULL;
	if (vala_variable_declarator_get_initializer (decl) != NULL) {
		ValaCCodeExpression* __temp202;
		ValaCCodeExpression* __temp201;
		__temp202 = NULL;
		__temp201 = NULL;
		rhs = (__temp202 = (__temp201 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_variable_declarator_get_initializer (decl)))), (__temp201 == NULL ? NULL : g_object_ref (__temp201))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp202);
		if (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_variable_declarator_get_initializer (decl))) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))) && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_variable_declarator_get_initializer (decl))) != vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))) {
			ValaCCodeExpression* __temp203;
			/* FIXME: use C cast if debugging disabled*/
			__temp203 = NULL;
			rhs = (__temp203 = VALA_CCODE_EXPRESSION (vala_instance_cast_new (rhs, vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp203);
		}
		if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
			ValaArray* __temp204;
			ValaArray* arr;
			ValaCCodeCommaExpression* ccomma;
			ValaVariableDeclarator* temp_decl;
			ValaVariableDeclarator* __temp205;
			ValaCCodeAssignment* __temp206;
			ValaCCodeIdentifier* __temp208;
			ValaCCodeExpression* __temp210;
			ValaCCodeCommaExpression* __temp209;
			__temp204 = NULL;
			arr = (__temp204 = VALA_ARRAY (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))), (__temp204 == NULL ? NULL : g_object_ref (__temp204)));
			ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
			temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_variable_declarator_get_type_reference (decl), TRUE);
			__temp205 = NULL;
			self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp205 = temp_decl, (__temp205 == NULL ? NULL : g_object_ref (__temp205))));
			__temp206 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp206 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl))), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp206 == NULL ? NULL : (__temp206 = (g_object_unref (__temp206), NULL)));
			{
				gint dim;
				dim = 0;
				for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
					ValaCCodeIdentifier* lhs_array_len;
					ValaCCodeExpression* rhs_array_len;
					ValaCCodeAssignment* __temp207;
					lhs_array_len = vala_ccode_identifier_new (vala_code_generator_get_array_length_cname (self, vala_variable_declarator_get_name (decl), dim));
					rhs_array_len = vala_code_generator_get_array_length_cexpression (self, vala_variable_declarator_get_initializer (decl), dim);
					__temp207 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp207 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (lhs_array_len), rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(__temp207 == NULL ? NULL : (__temp207 = (g_object_unref (__temp207), NULL)));
					(lhs_array_len == NULL ? NULL : (lhs_array_len = (g_object_unref (lhs_array_len), NULL)));
					(rhs_array_len = (g_object_unref (rhs_array_len), NULL));
				}
			}
			__temp208 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp208 = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl)))));
			(__temp208 == NULL ? NULL : (__temp208 = (g_object_unref (__temp208), NULL)));
			__temp210 = NULL;
			__temp209 = NULL;
			rhs = (__temp210 = VALA_CCODE_EXPRESSION ((__temp209 = ccomma, (__temp209 == NULL ? NULL : g_object_ref (__temp209)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp210);
			(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		}
	} else {
		if (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
			ValaCCodeExpression* __temp211;
			__temp211 = NULL;
			rhs = (__temp211 = VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp211);
		}
	}
	__temp212 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (decl), VALA_CCODE_NODE ((__temp212 = vala_ccode_variable_declarator_new_with_initializer (vala_code_generator_get_variable_cname (self, vala_variable_declarator_get_name (decl)), rhs)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (decl)));
	(__temp212 == NULL ? NULL : (__temp212 = (g_object_unref (__temp212), NULL)));
	(vala_symbol_set_active (vala_code_node_get_symbol (VALA_CODE_NODE (decl)), TRUE), vala_symbol_get_active (vala_code_node_get_symbol (VALA_CODE_NODE (decl))));
	(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
}


static void vala_code_generator_real_visit_end_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_INITIALIZER_LIST (list));
	if (vala_expression_get_expected_type (VALA_EXPRESSION (list)) != NULL && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_expression_get_expected_type (VALA_EXPRESSION (list))))) {
	} else {
		ValaCCodeInitializerList* clist;
		/* TODO */
		clist = g_object_new (VALA_TYPE_CCODE_INITIALIZER_LIST, NULL);
		{
			GList* __temp213;
			GList* expr_it;
			__temp213 = NULL;
			__temp213 = vala_initializer_list_get_initializers (list);
			for (expr_it = __temp213; expr_it != NULL; expr_it = expr_it->next) {
				ValaExpression* expr;
				expr = expr_it->data;
				{
					vala_ccode_initializer_list_append (clist, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))));
				}
			}
			(__temp213 == NULL ? NULL : (__temp213 = (g_list_free (__temp213), NULL)));
		}
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (list), VALA_CCODE_NODE (clist)), vala_code_node_get_ccodenode (VALA_CODE_NODE (list)));
		(clist == NULL ? NULL : (clist = (g_object_unref (clist), NULL)));
	}
}


static ValaVariableDeclarator* vala_code_generator_get_temp_variable_declarator (ValaCodeGenerator* self, ValaTypeReference* type, gboolean takes_ownership)
{
	ValaVariableDeclarator* decl;
	ValaTypeReference* __temp214;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type), NULL);
	decl = vala_variable_declarator_new (g_strdup_printf ("__temp%d", self->priv->next_temp_var_id), NULL, NULL);
	__temp214 = NULL;
	(vala_variable_declarator_set_type_reference (decl, (__temp214 = vala_type_reference_copy (type))), vala_variable_declarator_get_type_reference (decl));
	(__temp214 = (g_object_unref (__temp214), NULL));
	(vala_type_reference_set_is_ref (vala_variable_declarator_get_type_reference (decl), FALSE), vala_type_reference_get_is_ref (vala_variable_declarator_get_type_reference (decl)));
	(vala_type_reference_set_is_out (vala_variable_declarator_get_type_reference (decl), FALSE), vala_type_reference_get_is_out (vala_variable_declarator_get_type_reference (decl)));
	(vala_type_reference_set_takes_ownership (vala_variable_declarator_get_type_reference (decl), takes_ownership), vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl)));
	self->priv->next_temp_var_id++;
	return decl;
	(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
}


static ValaCCodeExpression* vala_code_generator_get_destroy_func_expression (ValaCodeGenerator* self, ValaTypeReference* type)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type), NULL);
	if (vala_type_reference_get_data_type (type) != NULL) {
		char* unref_function;
		ValaCCodeIdentifier* __temp218;
		unref_function = NULL;
		if (vala_data_type_is_reference_counting (vala_type_reference_get_data_type (type))) {
			char* __temp216;
			__temp216 = NULL;
			unref_function = (__temp216 = vala_data_type_get_unref_function (vala_type_reference_get_data_type (type)), (unref_function = (g_free (unref_function), NULL)), __temp216);
		} else {
			char* __temp217;
			__temp217 = NULL;
			unref_function = (__temp217 = vala_data_type_get_free_function (vala_type_reference_get_data_type (type)), (unref_function = (g_free (unref_function), NULL)), __temp217);
		}
		__temp218 = NULL;
		return VALA_CCODE_EXPRESSION ((__temp218 = vala_ccode_identifier_new (unref_function), (unref_function = (g_free (unref_function), NULL)), __temp218));
		(unref_function = (g_free (unref_function), NULL));
	} else {
		if (vala_type_reference_get_type_parameter (type) != NULL && self->priv->current_class != NULL) {
			char* __temp219;
			char* __temp220;
			char* func_name;
			ValaCCodeMemberAccess* __temp221;
			__temp219 = NULL;
			__temp220 = NULL;
			func_name = (__temp220 = g_strdup_printf ("%s_destroy_func", (__temp219 = g_utf8_strdown (vala_type_parameter_get_name (vala_type_reference_get_type_parameter (type)), -1))), (__temp219 = (g_free (__temp219), NULL)), __temp220);
			__temp221 = NULL;
			return VALA_CCODE_EXPRESSION ((__temp221 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), "priv")), func_name), (func_name = (g_free (func_name), NULL)), __temp221));
			(func_name = (g_free (func_name), NULL));
		} else {
			return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
		}
	}
}


static ValaCCodeExpression* vala_code_generator_get_unref_expression (ValaCodeGenerator* self, ValaCCodeExpression* cvar, ValaTypeReference* type)
{
	ValaCCodeBinaryExpression* cisnull;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeCommaExpression* ccomma;
	ValaCCodeConstant* __temp231;
	ValaCCodeAssignment* cassign;
	char* __temp232;
	gboolean __temp233;
	ValaCCodeConditionalExpression* __temp235;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cvar), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type), NULL);
	/* (foo == NULL ? NULL : foo = (unref (foo), NULL)) 
	 can be simplified to
	 * foo = (unref (foo), NULL)
	 * if foo is of static type non-null
	 */
	if (vala_type_reference_get_is_null (type)) {
		return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
	}
	cisnull = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, cvar, VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
	if (vala_type_reference_get_data_type (type) == NULL) {
		ValaCCodeBinaryExpression* cunrefisnull;
		ValaCCodeBinaryExpression* __temp225;
		if (self->priv->current_class == NULL) {
			ValaCCodeConstant* __temp224;
			__temp224 = NULL;
			return VALA_CCODE_EXPRESSION ((__temp224 = vala_ccode_constant_new ("NULL"), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), __temp224));
		}
		/* unref functions are optional for type parameters*/
		cunrefisnull = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, vala_code_generator_get_destroy_func_expression (self, type), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
		__temp225 = NULL;
		cisnull = (__temp225 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (cisnull), VALA_CCODE_EXPRESSION (cunrefisnull)), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), __temp225);
		(cunrefisnull == NULL ? NULL : (cunrefisnull = (g_object_unref (cunrefisnull), NULL)));
	}
	ccall = vala_ccode_function_call_new (vala_code_generator_get_destroy_func_expression (self, type));
	vala_ccode_function_call_add_argument (ccall, cvar);
	/* set freed references to NULL to prevent further use */
	ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
	/* TODO cleanup*/
	if (vala_type_reference_get_data_type (type) != NULL && !vala_data_type_is_reference_counting (vala_type_reference_get_data_type (type))) {
		char* unref_function;
		unref_function = vala_data_type_get_free_function (vala_type_reference_get_data_type (type));
		if (g_utf8_collate (unref_function, "g_list_free") == 0) {
			gboolean is_ref;
			gboolean is_class;
			gboolean is_interface;
			is_ref = FALSE;
			is_class = FALSE;
			is_interface = FALSE;
			{
				GList* __temp226;
				GList* type_arg_it;
				__temp226 = NULL;
				__temp226 = vala_type_reference_get_type_arguments (type);
				for (type_arg_it = __temp226; type_arg_it != NULL; type_arg_it = type_arg_it->next) {
					ValaTypeReference* type_arg;
					type_arg = type_arg_it->data;
					{
						is_ref = is_ref | (vala_type_reference_get_takes_ownership (type_arg));
						is_class = is_class | (VALA_IS_CLASS (vala_type_reference_get_data_type (type_arg)));
						is_interface = is_interface | (VALA_IS_INTERFACE (vala_type_reference_get_data_type (type_arg)));
					}
				}
				(__temp226 == NULL ? NULL : (__temp226 = (g_list_free (__temp226), NULL)));
			}
			if (is_ref) {
				ValaCCodeFunctionCall* cunrefcall;
				ValaCCodeConstant* __temp229;
				cunrefcall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_list_foreach")));
				vala_ccode_function_call_add_argument (cunrefcall, cvar);
				if (is_class || is_interface) {
					ValaCCodeIdentifier* __temp227;
					__temp227 = NULL;
					vala_ccode_function_call_add_argument (cunrefcall, VALA_CCODE_EXPRESSION ((__temp227 = vala_ccode_identifier_new ("(GFunc) g_object_unref"))));
					(__temp227 == NULL ? NULL : (__temp227 = (g_object_unref (__temp227), NULL)));
				} else {
					ValaCCodeIdentifier* __temp228;
					__temp228 = NULL;
					vala_ccode_function_call_add_argument (cunrefcall, VALA_CCODE_EXPRESSION ((__temp228 = vala_ccode_identifier_new ("(GFunc) g_free"))));
					(__temp228 == NULL ? NULL : (__temp228 = (g_object_unref (__temp228), NULL)));
				}
				__temp229 = NULL;
				vala_ccode_function_call_add_argument (cunrefcall, VALA_CCODE_EXPRESSION ((__temp229 = vala_ccode_constant_new ("NULL"))));
				(__temp229 == NULL ? NULL : (__temp229 = (g_object_unref (__temp229), NULL)));
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cunrefcall));
				(cunrefcall == NULL ? NULL : (cunrefcall = (g_object_unref (cunrefcall), NULL)));
			}
		} else {
			if (g_utf8_collate (unref_function, "g_string_free") == 0) {
				ValaCCodeConstant* __temp230;
				__temp230 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp230 = vala_ccode_constant_new ("TRUE"))));
				(__temp230 == NULL ? NULL : (__temp230 = (g_object_unref (__temp230), NULL)));
			}
		}
		(unref_function = (g_free (unref_function), NULL));
	}
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
	__temp231 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp231 = vala_ccode_constant_new ("NULL"))));
	(__temp231 == NULL ? NULL : (__temp231 = (g_object_unref (__temp231), NULL)));
	cassign = vala_ccode_assignment_new (cvar, VALA_CCODE_EXPRESSION (ccomma), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	/* g_free (NULL) is allowed*/
	__temp232 = NULL;
	if ((__temp233 = vala_type_reference_get_non_null (type) || (vala_type_reference_get_data_type (type) != NULL && !vala_data_type_is_reference_counting (vala_type_reference_get_data_type (type)) && g_utf8_collate ((__temp232 = vala_data_type_get_free_function (vala_type_reference_get_data_type (type))), "g_free") == 0), (__temp232 = (g_free (__temp232), NULL)), __temp233)) {
		ValaCCodeParenthesizedExpression* __temp234;
		__temp234 = NULL;
		return VALA_CCODE_EXPRESSION ((__temp234 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (cassign)), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), (ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL))), (cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL))), __temp234));
	}
	__temp235 = NULL;
	return VALA_CCODE_EXPRESSION ((__temp235 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (cisnull), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")), VALA_CCODE_EXPRESSION (vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (cassign)))), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), (ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL))), (cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL))), __temp235));
	(cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	(cassign == NULL ? NULL : (cassign = (g_object_unref (cassign), NULL)));
}


static void vala_code_generator_real_visit_end_full_expression (ValaCodeVisitor* base, ValaExpression* expr)
{
	ValaCodeGenerator * self;
	GList* __temp238;
	GList* __temp241;
	ValaVariableDeclarator* full_expr_decl;
	ValaVariableDeclarator* __temp242;
	ValaCCodeCommaExpression* expr_list;
	ValaCCodeAssignment* __temp243;
	ValaCCodeIdentifier* __temp247;
	GList* __temp248;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_EXPRESSION (expr));
	if (!vala_code_generator_get_memory_management (self)) {
		GList* __temp236;
		GList* __temp237;
		__temp236 = NULL;
		self->priv->temp_vars = (__temp236 = NULL, (self->priv->temp_vars == NULL ? NULL : (self->priv->temp_vars = (g_list_foreach (self->priv->temp_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_vars), NULL))), __temp236);
		__temp237 = NULL;
		self->priv->temp_ref_vars = (__temp237 = NULL, (self->priv->temp_ref_vars == NULL ? NULL : (self->priv->temp_ref_vars = (g_list_foreach (self->priv->temp_ref_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_ref_vars), NULL))), __temp237);
		return;
	}
	/* expr is a full expression, i.e. an initializer, the
	 * expression in an expression statement, the controlling
	 * expression in if, while, for, or foreach statements
	 *
	 * we unref temporary variables at the end of a full
	 * expression
	 
	 can't automatically deep copy lists yet, so do it
	 * manually for now
	 * replace with
	 * expr.temp_vars = temp_vars;
	 * when deep list copying works
	 */
	__temp238 = NULL;
	expr->temp_vars = (__temp238 = NULL, (expr->temp_vars == NULL ? NULL : (expr->temp_vars = (g_list_foreach (expr->temp_vars, (GFunc) g_object_unref, NULL), g_list_free (expr->temp_vars), NULL))), __temp238);
	{
		GList* __temp240;
		GList* decl1_it;
		__temp240 = NULL;
		__temp240 = self->priv->temp_vars;
		for (decl1_it = __temp240; decl1_it != NULL; decl1_it = decl1_it->next) {
			ValaVariableDeclarator* decl1;
			decl1 = decl1_it->data;
			{
				ValaVariableDeclarator* __temp239;
				__temp239 = NULL;
				expr->temp_vars = g_list_append (expr->temp_vars, (__temp239 = decl1, (__temp239 == NULL ? NULL : g_object_ref (__temp239))));
			}
		}
	}
	__temp241 = NULL;
	self->priv->temp_vars = (__temp241 = NULL, (self->priv->temp_vars == NULL ? NULL : (self->priv->temp_vars = (g_list_foreach (self->priv->temp_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_vars), NULL))), __temp241);
	if (self->priv->temp_ref_vars == NULL) {
		return;
	}
	/* nothing to do without temporary variables */
	full_expr_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (expr), TRUE);
	__temp242 = NULL;
	expr->temp_vars = g_list_append (expr->temp_vars, (__temp242 = full_expr_decl, (__temp242 == NULL ? NULL : g_object_ref (__temp242))));
	expr_list = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
	__temp243 = NULL;
	vala_ccode_comma_expression_append_expression (expr_list, VALA_CCODE_EXPRESSION ((__temp243 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (full_expr_decl))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(__temp243 == NULL ? NULL : (__temp243 = (g_object_unref (__temp243), NULL)));
	{
		GList* __temp246;
		GList* decl_it;
		__temp246 = NULL;
		__temp246 = self->priv->temp_ref_vars;
		for (decl_it = __temp246; decl_it != NULL; decl_it = decl_it->next) {
			ValaVariableDeclarator* decl;
			decl = decl_it->data;
			{
				ValaCCodeExpression* __temp245;
				ValaCCodeIdentifier* __temp244;
				__temp245 = NULL;
				__temp244 = NULL;
				vala_ccode_comma_expression_append_expression (expr_list, (__temp245 = vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((__temp244 = vala_ccode_identifier_new (vala_variable_declarator_get_name (decl)))), vala_variable_declarator_get_type_reference (decl))));
				(__temp245 == NULL ? NULL : (__temp245 = (g_object_unref (__temp245), NULL)));
				(__temp244 == NULL ? NULL : (__temp244 = (g_object_unref (__temp244), NULL)));
			}
		}
	}
	__temp247 = NULL;
	vala_ccode_comma_expression_append_expression (expr_list, VALA_CCODE_EXPRESSION ((__temp247 = vala_ccode_identifier_new (vala_variable_declarator_get_name (full_expr_decl)))));
	(__temp247 == NULL ? NULL : (__temp247 = (g_object_unref (__temp247), NULL)));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (expr_list)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	__temp248 = NULL;
	self->priv->temp_ref_vars = (__temp248 = NULL, (self->priv->temp_ref_vars == NULL ? NULL : (self->priv->temp_ref_vars = (g_list_foreach (self->priv->temp_ref_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_ref_vars), NULL))), __temp248);
	(full_expr_decl == NULL ? NULL : (full_expr_decl = (g_object_unref (full_expr_decl), NULL)));
	(expr_list == NULL ? NULL : (expr_list = (g_object_unref (expr_list), NULL)));
}


static void vala_code_generator_append_temp_decl (ValaCodeGenerator* self, ValaCCodeFragment* cfrag, GList* temp_vars)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CCODE_FRAGMENT (cfrag));
	{
		GList* __temp250;
		GList* decl_it;
		__temp250 = NULL;
		__temp250 = temp_vars;
		for (decl_it = __temp250; decl_it != NULL; decl_it = decl_it->next) {
			ValaVariableDeclarator* decl;
			decl = decl_it->data;
			{
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* vardecl;
				cdecl_ = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_variable_declarator_get_type_reference (decl), TRUE, !vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))));
				vardecl = vala_ccode_variable_declarator_new (vala_variable_declarator_get_name (decl));
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR (vardecl));
				if (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl)))) {
					ValaCCodeConstant* __temp249;
					__temp249 = NULL;
					(vala_ccode_variable_declarator_set_initializer (vardecl, VALA_CCODE_EXPRESSION ((__temp249 = vala_ccode_constant_new ("NULL")))), vala_ccode_variable_declarator_get_initializer (vardecl));
					(__temp249 == NULL ? NULL : (__temp249 = (g_object_unref (__temp249), NULL)));
				}
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE (cdecl_));
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				(vardecl == NULL ? NULL : (vardecl = (g_object_unref (vardecl), NULL)));
			}
		}
	}
}


static void vala_code_generator_add_simple_check (ValaCodeGenerator* self, ValaCodeNode* node, ValaCCodeFragment* cfrag)
{
	ValaCCodeFragment* cprint_frag;
	ValaCCodeFunctionCall* ccritical;
	ValaCCodeConstant* __temp251;
	ValaCCodeConstant* __temp252;
	ValaCCodeConstant* __temp253;
	ValaCCodeMemberAccess* __temp254;
	ValaCCodeExpressionStatement* __temp255;
	ValaCCodeFunctionCall* cclear;
	ValaCCodeUnaryExpression* __temp256;
	ValaCCodeExpressionStatement* __temp257;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CODE_NODE (node));
	g_return_if_fail (VALA_IS_CCODE_FRAGMENT (cfrag));
	cprint_frag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	ccritical = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_critical")));
	__temp251 = NULL;
	vala_ccode_function_call_add_argument (ccritical, VALA_CCODE_EXPRESSION ((__temp251 = vala_ccode_constant_new ("\"file %s: line %d: uncaught error: %s\""))));
	(__temp251 == NULL ? NULL : (__temp251 = (g_object_unref (__temp251), NULL)));
	__temp252 = NULL;
	vala_ccode_function_call_add_argument (ccritical, VALA_CCODE_EXPRESSION ((__temp252 = vala_ccode_constant_new ("__FILE__"))));
	(__temp252 == NULL ? NULL : (__temp252 = (g_object_unref (__temp252), NULL)));
	__temp253 = NULL;
	vala_ccode_function_call_add_argument (ccritical, VALA_CCODE_EXPRESSION ((__temp253 = vala_ccode_constant_new ("__LINE__"))));
	(__temp253 == NULL ? NULL : (__temp253 = (g_object_unref (__temp253), NULL)));
	__temp254 = NULL;
	vala_ccode_function_call_add_argument (ccritical, VALA_CCODE_EXPRESSION ((__temp254 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("inner_error")), "message"))));
	(__temp254 == NULL ? NULL : (__temp254 = (g_object_unref (__temp254), NULL)));
	__temp255 = NULL;
	vala_ccode_fragment_append (cprint_frag, VALA_CCODE_NODE ((__temp255 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccritical)))));
	(__temp255 == NULL ? NULL : (__temp255 = (g_object_unref (__temp255), NULL)));
	cclear = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_clear_error")));
	__temp256 = NULL;
	vala_ccode_function_call_add_argument (cclear, VALA_CCODE_EXPRESSION ((__temp256 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("inner_error"))))));
	(__temp256 == NULL ? NULL : (__temp256 = (g_object_unref (__temp256), NULL)));
	__temp257 = NULL;
	vala_ccode_fragment_append (cprint_frag, VALA_CCODE_NODE ((__temp257 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cclear)))));
	(__temp257 == NULL ? NULL : (__temp257 = (g_object_unref (__temp257), NULL)));
	if (self->priv->current_try != NULL) {
		ValaCCodeBlock* cerror_block;
		ValaCCodeBinaryExpression* ccond;
		ValaCCodeIfStatement* __temp262;
		/* surrounding try found
		 TODO might be the wrong one when using nested try statements*/
		cerror_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		{
			GList* __temp261;
			GList* clause_it;
			__temp261 = NULL;
			__temp261 = vala_try_statement_get_catch_clauses (self->priv->current_try);
			for (clause_it = __temp261; clause_it != NULL; clause_it = clause_it->next) {
				ValaCatchClause* clause;
				clause = clause_it->data;
				{
					ValaCCodeBinaryExpression* ccond;
					ValaCCodeBlock* cgoto_block;
					ValaCCodeGotoStatement* __temp259;
					char* __temp258;
					ValaCCodeIfStatement* __temp260;
					/* go to catch clause if error domain matches*/
					ccond = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("inner_error")), "domain")), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_catch_clause_get_type_reference (clause)), NULL))));
					cgoto_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
					__temp259 = NULL;
					__temp258 = NULL;
					vala_ccode_block_add_statement (cgoto_block, VALA_CCODE_NODE ((__temp259 = vala_ccode_goto_statement_new (g_strdup_printf ("__catch%d_%s", self->priv->current_try_id, (__temp258 = vala_data_type_get_lower_case_cname (vala_type_reference_get_data_type (vala_catch_clause_get_type_reference (clause)), NULL)))))));
					(__temp259 == NULL ? NULL : (__temp259 = (g_object_unref (__temp259), NULL)));
					(__temp258 = (g_free (__temp258), NULL));
					__temp260 = NULL;
					vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE ((__temp260 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cgoto_block), NULL))));
					(__temp260 == NULL ? NULL : (__temp260 = (g_object_unref (__temp260), NULL)));
					(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
					(cgoto_block == NULL ? NULL : (cgoto_block = (g_object_unref (cgoto_block), NULL)));
				}
			}
			(__temp261 == NULL ? NULL : (__temp261 = (g_list_free (__temp261), NULL)));
		}
		/* print critical message if no catch clause matches*/
		vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE (cprint_frag));
		/* check error domain if expression failed*/
		ccond = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("inner_error")), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
		__temp262 = NULL;
		vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp262 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cerror_block), NULL))));
		(__temp262 == NULL ? NULL : (__temp262 = (g_object_unref (__temp262), NULL)));
		(cerror_block == NULL ? NULL : (cerror_block = (g_object_unref (cerror_block), NULL)));
		(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
	} else {
		GList* __temp263;
		gboolean __temp264;
		__temp263 = NULL;
		if ((__temp264 = self->priv->current_method != NULL && g_list_length ((__temp263 = vala_method_get_error_domains (self->priv->current_method))) > 0, (__temp263 == NULL ? NULL : (__temp263 = (g_list_free (__temp263), NULL))), __temp264)) {
			ValaCCodeFunctionCall* cpropagate;
			ValaCCodeIdentifier* __temp265;
			ValaCCodeIdentifier* __temp266;
			ValaCCodeBlock* cerror_block;
			ValaCCodeExpressionStatement* __temp267;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeIfStatement* __temp270;
			/* current method can fail, propagate error
			 TODO ensure one of the error domains matches*/
			cpropagate = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_propagate_error")));
			__temp265 = NULL;
			vala_ccode_function_call_add_argument (cpropagate, VALA_CCODE_EXPRESSION ((__temp265 = vala_ccode_identifier_new ("error"))));
			(__temp265 == NULL ? NULL : (__temp265 = (g_object_unref (__temp265), NULL)));
			__temp266 = NULL;
			vala_ccode_function_call_add_argument (cpropagate, VALA_CCODE_EXPRESSION ((__temp266 = vala_ccode_identifier_new ("inner_error"))));
			(__temp266 == NULL ? NULL : (__temp266 = (g_object_unref (__temp266), NULL)));
			cerror_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			__temp267 = NULL;
			vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE ((__temp267 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cpropagate)))));
			(__temp267 == NULL ? NULL : (__temp267 = (g_object_unref (__temp267), NULL)));
			if (self->priv->current_return_type != NULL && vala_type_reference_get_data_type (self->priv->current_return_type) != NULL) {
				ValaCCodeReturnStatement* __temp268;
				__temp268 = NULL;
				vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE ((__temp268 = vala_ccode_return_statement_new (vala_code_generator_default_value_for_type (self, vala_type_reference_get_data_type (self->priv->current_return_type))))));
				(__temp268 == NULL ? NULL : (__temp268 = (g_object_unref (__temp268), NULL)));
			} else {
				ValaCCodeReturnStatement* __temp269;
				__temp269 = NULL;
				vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE ((__temp269 = vala_ccode_return_statement_new (NULL))));
				(__temp269 == NULL ? NULL : (__temp269 = (g_object_unref (__temp269), NULL)));
			}
			ccond = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("inner_error")), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
			__temp270 = NULL;
			vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp270 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cerror_block), NULL))));
			(__temp270 == NULL ? NULL : (__temp270 = (g_object_unref (__temp270), NULL)));
			(cpropagate == NULL ? NULL : (cpropagate = (g_object_unref (cpropagate), NULL)));
			(cerror_block == NULL ? NULL : (cerror_block = (g_object_unref (cerror_block), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
		} else {
			ValaCCodeBlock* cerror_block;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeIfStatement* __temp271;
			/* TODO improve check and move to semantic analyzer*/
			vala_report_warning (vala_code_node_get_source_reference (node), "unhandled error");
			cerror_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			/* print critical message*/
			vala_ccode_block_add_statement (cerror_block, VALA_CCODE_NODE (cprint_frag));
			/* check error domain if expression failed*/
			ccond = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("inner_error")), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
			__temp271 = NULL;
			vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp271 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cerror_block), NULL))));
			(__temp271 == NULL ? NULL : (__temp271 = (g_object_unref (__temp271), NULL)));
			(cerror_block == NULL ? NULL : (cerror_block = (g_object_unref (cerror_block), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
		}
	}
	(cprint_frag == NULL ? NULL : (cprint_frag = (g_object_unref (cprint_frag), NULL)));
	(ccritical == NULL ? NULL : (ccritical = (g_object_unref (ccritical), NULL)));
	(cclear == NULL ? NULL : (cclear = (g_object_unref (cclear), NULL)));
}


static void vala_code_generator_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeExpressionStatement* __temp272;
	ValaCCodeFragment* cfrag;
	GList* __temp278;
	GList* __temp279;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_EXPRESSION_STATEMENT (stmt));
	__temp272 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp272 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_expression_statement_get_expression (stmt)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(__temp272 == NULL ? NULL : (__temp272 = (g_object_unref (__temp272), NULL)));
	if (vala_code_node_get_tree_can_fail (VALA_CODE_NODE (stmt)) && vala_expression_get_can_fail (vala_expression_statement_get_expression (stmt))) {
		ValaCCodeFragment* cfrag;
		/* simple case, no node breakdown necessary*/
		cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
		vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
		vala_code_generator_add_simple_check (self, VALA_CODE_NODE (vala_expression_statement_get_expression (stmt)), cfrag);
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
		(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
	}
	/* free temporary objects */
	if (!vala_code_generator_get_memory_management (self)) {
		GList* __temp273;
		GList* __temp274;
		__temp273 = NULL;
		self->priv->temp_vars = (__temp273 = NULL, (self->priv->temp_vars == NULL ? NULL : (self->priv->temp_vars = (g_list_foreach (self->priv->temp_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_vars), NULL))), __temp273);
		__temp274 = NULL;
		self->priv->temp_ref_vars = (__temp274 = NULL, (self->priv->temp_ref_vars == NULL ? NULL : (self->priv->temp_ref_vars = (g_list_foreach (self->priv->temp_ref_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_ref_vars), NULL))), __temp274);
		return;
	}
	if (self->priv->temp_vars == NULL) {
		return;
	}
	/* nothing to do without temporary variables */
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	vala_code_generator_append_temp_decl (self, cfrag, self->priv->temp_vars);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	{
		GList* __temp277;
		GList* decl_it;
		__temp277 = NULL;
		__temp277 = self->priv->temp_ref_vars;
		for (decl_it = __temp277; decl_it != NULL; decl_it = decl_it->next) {
			ValaVariableDeclarator* decl;
			decl = decl_it->data;
			{
				ValaCCodeExpressionStatement* __temp276;
				ValaCCodeIdentifier* __temp275;
				__temp276 = NULL;
				__temp275 = NULL;
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp276 = vala_ccode_expression_statement_new (vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((__temp275 = vala_ccode_identifier_new (vala_variable_declarator_get_name (decl)))), vala_variable_declarator_get_type_reference (decl))))));
				(__temp276 == NULL ? NULL : (__temp276 = (g_object_unref (__temp276), NULL)));
				(__temp275 == NULL ? NULL : (__temp275 = (g_object_unref (__temp275), NULL)));
			}
		}
	}
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	__temp278 = NULL;
	self->priv->temp_vars = (__temp278 = NULL, (self->priv->temp_vars == NULL ? NULL : (self->priv->temp_vars = (g_list_foreach (self->priv->temp_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_vars), NULL))), __temp278);
	__temp279 = NULL;
	self->priv->temp_ref_vars = (__temp279 = NULL, (self->priv->temp_ref_vars == NULL ? NULL : (self->priv->temp_ref_vars = (g_list_foreach (self->priv->temp_ref_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_ref_vars), NULL))), __temp279);
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_code_generator_create_temp_decl (ValaCodeGenerator* self, ValaStatement* stmt, GList* temp_vars)
{
	ValaCCodeFragment* cfrag;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_STATEMENT (stmt));
	/* declare temporary variables */
	if (temp_vars == NULL) {
		return;
	}
	/* nothing to do without temporary variables */
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	vala_code_generator_append_temp_decl (self, cfrag, temp_vars);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_code_generator_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_IF_STATEMENT (stmt));
	if (vala_if_statement_get_false_statement (stmt) != NULL) {
		ValaCCodeIfStatement* __temp280;
		__temp280 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp280 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_if_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_if_statement_get_true_statement (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_if_statement_get_false_statement (stmt)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
		(__temp280 == NULL ? NULL : (__temp280 = (g_object_unref (__temp280), NULL)));
	} else {
		ValaCCodeIfStatement* __temp281;
		__temp281 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp281 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_if_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_if_statement_get_true_statement (stmt)))), NULL)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
		(__temp281 == NULL ? NULL : (__temp281 = (g_object_unref (__temp281), NULL)));
	}
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), vala_if_statement_get_condition (stmt)->temp_vars);
}


static void vala_code_generator_real_visit_switch_statement (ValaCodeVisitor* base, ValaSwitchStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaVariableDeclarator* temp_decl;
	ValaVariableDeclarator* __temp282;
	ValaCCodeIdentifier* ctemp;
	ValaCCodeAssignment* cinit;
	ValaCCodeFragment* cswitchblock;
	ValaCCodeExpressionStatement* __temp283;
	GList* default_statements;
	ValaCCodeStatement* ctopstmt;
	ValaCCodeIfStatement* coldif;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_SWITCH_STATEMENT (stmt));
	/* we need a temporary variable to save the property value*/
	temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (vala_switch_statement_get_expression (stmt)), TRUE);
	__temp282 = NULL;
	vala_switch_statement_get_expression (stmt)->temp_vars = g_list_prepend (vala_switch_statement_get_expression (stmt)->temp_vars, (__temp282 = temp_decl, (__temp282 == NULL ? NULL : g_object_ref (__temp282))));
	ctemp = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl));
	cinit = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_switch_statement_get_expression (stmt)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	cswitchblock = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	__temp283 = NULL;
	vala_ccode_fragment_append (cswitchblock, VALA_CCODE_NODE ((__temp283 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinit)))));
	(__temp283 == NULL ? NULL : (__temp283 = (g_object_unref (__temp283), NULL)));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cswitchblock)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), vala_switch_statement_get_expression (stmt)->temp_vars);
	default_statements = NULL;
	/* generate nested if statements*/
	ctopstmt = NULL;
	coldif = NULL;
	{
		GList* __temp295;
		GList* section_it;
		__temp295 = NULL;
		__temp295 = vala_switch_statement_get_sections (stmt);
		for (section_it = __temp295; section_it != NULL; section_it = section_it->next) {
			ValaSwitchSection* section;
			section = section_it->data;
			{
				if (vala_switch_section_has_default_label (section)) {
					GList* __temp284;
					__temp284 = NULL;
					default_statements = (__temp284 = vala_switch_section_get_statements (section), (default_statements == NULL ? NULL : (default_statements = (g_list_free (default_statements), NULL))), __temp284);
				} else {
					ValaCCodeBinaryExpression* cor;
					ValaCCodeBlock* cblock;
					ValaCCodeDoStatement* cdo;
					ValaCCodeIfStatement* cif;
					ValaCCodeIfStatement* __temp294;
					ValaCCodeIfStatement* __temp293;
					cor = NULL;
					{
						GList* __temp288;
						GList* label_it;
						__temp288 = NULL;
						__temp288 = vala_switch_section_get_labels (section);
						for (label_it = __temp288; label_it != NULL; label_it = label_it->next) {
							ValaSwitchLabel* label;
							label = label_it->data;
							{
								ValaCCodeBinaryExpression* ccmp;
								ccmp = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_switch_label_get_expression (label)))));
								if (cor == NULL) {
									ValaCCodeBinaryExpression* __temp286;
									ValaCCodeBinaryExpression* __temp285;
									__temp286 = NULL;
									__temp285 = NULL;
									cor = (__temp286 = (__temp285 = ccmp, (__temp285 == NULL ? NULL : g_object_ref (__temp285))), (cor == NULL ? NULL : (cor = (g_object_unref (cor), NULL))), __temp286);
								} else {
									ValaCCodeBinaryExpression* __temp287;
									__temp287 = NULL;
									cor = (__temp287 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (cor), VALA_CCODE_EXPRESSION (ccmp)), (cor == NULL ? NULL : (cor = (g_object_unref (cor), NULL))), __temp287);
								}
								(ccmp == NULL ? NULL : (ccmp = (g_object_unref (ccmp), NULL)));
							}
						}
						(__temp288 == NULL ? NULL : (__temp288 = (g_list_free (__temp288), NULL)));
					}
					cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
					{
						GList* __temp290;
						GList* body_stmt_it;
						__temp290 = NULL;
						__temp290 = vala_switch_section_get_statements (section);
						for (body_stmt_it = __temp290; body_stmt_it != NULL; body_stmt_it = body_stmt_it->next) {
							ValaStatement* body_stmt;
							body_stmt = body_stmt_it->data;
							{
								if (VALA_IS_CCODE_FRAGMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (body_stmt)))) {
									{
										GList* __temp289;
										GList* cstmt_it;
										__temp289 = NULL;
										__temp289 = vala_ccode_fragment_get_children ((VALA_CCODE_FRAGMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (body_stmt)))));
										for (cstmt_it = __temp289; cstmt_it != NULL; cstmt_it = cstmt_it->next) {
											ValaCCodeStatement* cstmt;
											cstmt = cstmt_it->data;
											{
												vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cstmt));
											}
										}
										(__temp289 == NULL ? NULL : (__temp289 = (g_list_free (__temp289), NULL)));
									}
								} else {
									vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (body_stmt)))));
								}
							}
						}
						(__temp290 == NULL ? NULL : (__temp290 = (g_list_free (__temp290), NULL)));
					}
					cdo = vala_ccode_do_statement_new (VALA_CCODE_STATEMENT (cblock), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("0")));
					cif = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (cor), VALA_CCODE_STATEMENT (cdo), NULL);
					if (coldif != NULL) {
						(vala_ccode_if_statement_set_false_statement (coldif, VALA_CCODE_STATEMENT (cif)), vala_ccode_if_statement_get_false_statement (coldif));
					} else {
						ValaCCodeStatement* __temp292;
						ValaCCodeIfStatement* __temp291;
						__temp292 = NULL;
						__temp291 = NULL;
						ctopstmt = (__temp292 = VALA_CCODE_STATEMENT ((__temp291 = cif, (__temp291 == NULL ? NULL : g_object_ref (__temp291)))), (ctopstmt == NULL ? NULL : (ctopstmt = (g_object_unref (ctopstmt), NULL))), __temp292);
					}
					__temp294 = NULL;
					__temp293 = NULL;
					coldif = (__temp294 = (__temp293 = cif, (__temp293 == NULL ? NULL : g_object_ref (__temp293))), (coldif == NULL ? NULL : (coldif = (g_object_unref (coldif), NULL))), __temp294);
					(cor == NULL ? NULL : (cor = (g_object_unref (cor), NULL)));
					(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
					(cdo == NULL ? NULL : (cdo = (g_object_unref (cdo), NULL)));
					(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
				}
			}
		}
		(__temp295 == NULL ? NULL : (__temp295 = (g_list_free (__temp295), NULL)));
	}
	if (default_statements != NULL) {
		ValaCCodeBlock* cblock;
		ValaCCodeDoStatement* cdo;
		cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		{
			GList* __temp296;
			GList* body_stmt_it;
			__temp296 = NULL;
			__temp296 = default_statements;
			for (body_stmt_it = __temp296; body_stmt_it != NULL; body_stmt_it = body_stmt_it->next) {
				ValaStatement* body_stmt;
				body_stmt = body_stmt_it->data;
				{
					vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (body_stmt)))));
				}
			}
		}
		cdo = vala_ccode_do_statement_new (VALA_CCODE_STATEMENT (cblock), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("0")));
		if (coldif == NULL) {
			ValaCCodeStatement* __temp298;
			ValaCCodeDoStatement* __temp297;
			/* there is only one section and that section
			 contains a default label*/
			__temp298 = NULL;
			__temp297 = NULL;
			ctopstmt = (__temp298 = VALA_CCODE_STATEMENT ((__temp297 = cdo, (__temp297 == NULL ? NULL : g_object_ref (__temp297)))), (ctopstmt == NULL ? NULL : (ctopstmt = (g_object_unref (ctopstmt), NULL))), __temp298);
		} else {
			(vala_ccode_if_statement_set_false_statement (coldif, VALA_CCODE_STATEMENT (cdo)), vala_ccode_if_statement_get_false_statement (coldif));
		}
		(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
		(cdo == NULL ? NULL : (cdo = (g_object_unref (cdo), NULL)));
	}
	vala_ccode_fragment_append (cswitchblock, VALA_CCODE_NODE (ctopstmt));
	(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
	(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
	(cinit == NULL ? NULL : (cinit = (g_object_unref (cinit), NULL)));
	(cswitchblock == NULL ? NULL : (cswitchblock = (g_object_unref (cswitchblock), NULL)));
	(default_statements == NULL ? NULL : (default_statements = (g_list_free (default_statements), NULL)));
	(ctopstmt == NULL ? NULL : (ctopstmt = (g_object_unref (ctopstmt), NULL)));
	(coldif == NULL ? NULL : (coldif = (g_object_unref (coldif), NULL)));
}


static void vala_code_generator_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeWhileStatement* __temp299;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_WHILE_STATEMENT (stmt));
	__temp299 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp299 = vala_ccode_while_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_while_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_while_statement_get_body (stmt)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(__temp299 == NULL ? NULL : (__temp299 = (g_object_unref (__temp299), NULL)));
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), vala_while_statement_get_condition (stmt)->temp_vars);
}


static void vala_code_generator_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeDoStatement* __temp300;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_DO_STATEMENT (stmt));
	__temp300 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp300 = vala_ccode_do_statement_new (VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_do_statement_get_body (stmt)))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_do_statement_get_condition (stmt)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(__temp300 == NULL ? NULL : (__temp300 = (g_object_unref (__temp300), NULL)));
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), vala_do_statement_get_condition (stmt)->temp_vars);
}


static void vala_code_generator_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeForStatement* cfor;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_FOR_STATEMENT (stmt));
	cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_for_statement_get_condition (stmt)))), VALA_CCODE_STATEMENT (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_for_statement_get_body (stmt)))));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfor)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	{
		GList* __temp301;
		GList* init_expr_it;
		__temp301 = NULL;
		__temp301 = vala_for_statement_get_initializer (stmt);
		for (init_expr_it = __temp301; init_expr_it != NULL; init_expr_it = init_expr_it->next) {
			ValaExpression* init_expr;
			init_expr = init_expr_it->data;
			{
				vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (init_expr))));
				vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), init_expr->temp_vars);
			}
		}
		(__temp301 == NULL ? NULL : (__temp301 = (g_list_free (__temp301), NULL)));
	}
	{
		GList* __temp302;
		GList* it_expr_it;
		__temp302 = NULL;
		__temp302 = vala_for_statement_get_iterator (stmt);
		for (it_expr_it = __temp302; it_expr_it != NULL; it_expr_it = it_expr_it->next) {
			ValaExpression* it_expr;
			it_expr = it_expr_it->data;
			{
				vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (it_expr))));
				vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), it_expr->temp_vars);
			}
		}
		(__temp302 == NULL ? NULL : (__temp302 = (g_list_free (__temp302), NULL)));
	}
	vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), vala_for_statement_get_condition (stmt)->temp_vars);
	(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
}


static void vala_code_generator_real_visit_end_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeBlock* cblock;
	ValaCCodeForStatement* cfor;
	ValaVariableDeclarator* collection_backup;
	ValaVariableDeclarator* __temp303;
	ValaCCodeFragment* cfrag;
	ValaCCodeExpressionStatement* __temp304;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_FOREACH_STATEMENT (stmt));
	cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	cfor = NULL;
	collection_backup = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)), TRUE);
	__temp303 = NULL;
	vala_foreach_statement_get_collection (stmt)->temp_vars = g_list_prepend (vala_foreach_statement_get_collection (stmt)->temp_vars, (__temp303 = collection_backup, (__temp303 == NULL ? NULL : g_object_ref (__temp303))));
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	vala_code_generator_append_temp_decl (self, cfrag, vala_foreach_statement_get_collection (stmt)->temp_vars);
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfrag));
	__temp304 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp304 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (collection_backup))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_foreach_statement_get_collection (stmt)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp304 == NULL ? NULL : (__temp304 = (g_object_unref (__temp304), NULL)));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cblock)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt))))) {
		ValaArray* __temp305;
		ValaArray* arr;
		ValaCCodeExpression* array_len;
		__temp305 = NULL;
		arr = (__temp305 = VALA_ARRAY (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)))), (__temp305 == NULL ? NULL : g_object_ref (__temp305)));
		array_len = vala_code_generator_get_array_length_cexpression (self, vala_foreach_statement_get_collection (stmt), 1);
		/* the array has no length parameter i.e. is NULL-terminated array */
		if (VALA_IS_CCODE_CONSTANT (array_len)) {
			char* it_name;
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* __temp306;
			ValaCCodeBlock* cbody;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* __temp307;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* __temp308;
			ValaCCodeAssignment* __temp309;
			it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
			citdecl = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)), FALSE, FALSE));
			__temp306 = NULL;
			vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR ((__temp306 = vala_ccode_variable_declarator_new (it_name))));
			(__temp306 == NULL ? NULL : (__temp306 = (g_object_unref (__temp306), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (citdecl));
			cbody = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			cdecl_ = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_foreach_statement_get_type_reference (stmt), FALSE, FALSE));
			__temp307 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp307 = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("*%s", it_name)))))));
			(__temp307 == NULL ? NULL : (__temp307 = (g_object_unref (__temp307), NULL)));
			vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cdecl_));
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_foreach_statement_get_body (stmt))));
			ccond = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("*%s", it_name))), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
			cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cbody));
			__temp308 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION ((__temp308 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (collection_backup))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp308 == NULL ? NULL : (__temp308 = (g_object_unref (__temp308), NULL)));
			__temp309 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION ((__temp309 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("1")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp309 == NULL ? NULL : (__temp309 = (g_object_unref (__temp309), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfor));
			(it_name = (g_free (it_name), NULL));
			(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
			(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
		} else {
			char* it_name;
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* __temp310;
			ValaCCodeBlock* cbody;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* __temp311;
			ValaCCodeBinaryExpression* ccond_ind1;
			ValaCCodeBinaryExpression* ccond_ind2;
			ValaCCodeBinaryExpression* ccond_ind;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* __temp316;
			ValaCCodeAssignment* __temp317;
			/* the array has a length parameter */
			it_name = (g_strconcat (vala_foreach_statement_get_variable_name (stmt), "_it", NULL));
			citdecl = vala_ccode_declaration_new ("int");
			__temp310 = NULL;
			vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR ((__temp310 = vala_ccode_variable_declarator_new (it_name))));
			(__temp310 == NULL ? NULL : (__temp310 = (g_object_unref (__temp310), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (citdecl));
			cbody = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			cdecl_ = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_foreach_statement_get_type_reference (stmt), FALSE, FALSE));
			__temp311 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp311 = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), VALA_CCODE_EXPRESSION (vala_ccode_element_access_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (collection_backup))), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name))))))));
			(__temp311 == NULL ? NULL : (__temp311 = (g_object_unref (__temp311), NULL)));
			vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cdecl_));
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_foreach_statement_get_body (stmt))));
			ccond_ind1 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, array_len, VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("-1")));
			ccond_ind2 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_LESS_THAN, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), array_len);
			ccond_ind = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, VALA_CCODE_EXPRESSION (ccond_ind1), VALA_CCODE_EXPRESSION (ccond_ind2));
			/* only check for null if the containers elements are of reference-type */
			ccond = NULL;
			if (vala_data_type_is_reference_type (vala_array_get_element_type (arr))) {
				ValaCCodeBinaryExpression* ccond_term1;
				ValaCCodeBinaryExpression* ccond_term2;
				ValaCCodeBinaryExpression* ccond_term;
				ValaCCodeBinaryExpression* __temp312;
				ccond_term1 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, array_len, VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("-1")));
				ccond_term2 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_element_access_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (collection_backup))), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)))), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
				ccond_term = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, VALA_CCODE_EXPRESSION (ccond_term1), VALA_CCODE_EXPRESSION (ccond_term2));
				__temp312 = NULL;
				ccond = (__temp312 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (ccond_ind))), VALA_CCODE_EXPRESSION (vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (ccond_term)))), (ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL))), __temp312);
				(ccond_term1 == NULL ? NULL : (ccond_term1 = (g_object_unref (ccond_term1), NULL)));
				(ccond_term2 == NULL ? NULL : (ccond_term2 = (g_object_unref (ccond_term2), NULL)));
				(ccond_term == NULL ? NULL : (ccond_term = (g_object_unref (ccond_term), NULL)));
			} else {
				ValaCCodeFunctionCall* cassert;
				ValaCCodeExpressionStatement* __temp313;
				ValaCCodeBinaryExpression* __temp315;
				ValaCCodeBinaryExpression* __temp314;
				/* assert when trying to iterate over value-type arrays of unknown length */
				cassert = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_assert")));
				vala_ccode_function_call_add_argument (cassert, VALA_CCODE_EXPRESSION (ccond_ind1));
				__temp313 = NULL;
				vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp313 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cassert)))));
				(__temp313 == NULL ? NULL : (__temp313 = (g_object_unref (__temp313), NULL)));
				__temp315 = NULL;
				__temp314 = NULL;
				ccond = (__temp315 = (__temp314 = ccond_ind2, (__temp314 == NULL ? NULL : g_object_ref (__temp314))), (ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL))), __temp315);
				(cassert == NULL ? NULL : (cassert = (g_object_unref (cassert), NULL)));
			}
			cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cbody));
			__temp316 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION ((__temp316 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("0")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp316 == NULL ? NULL : (__temp316 = (g_object_unref (__temp316), NULL)));
			__temp317 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION ((__temp317 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("1")))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp317 == NULL ? NULL : (__temp317 = (g_object_unref (__temp317), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfor));
			(it_name = (g_free (it_name), NULL));
			(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
			(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			(ccond_ind1 == NULL ? NULL : (ccond_ind1 = (g_object_unref (ccond_ind1), NULL)));
			(ccond_ind2 == NULL ? NULL : (ccond_ind2 = (g_object_unref (ccond_ind2), NULL)));
			(ccond_ind == NULL ? NULL : (ccond_ind = (g_object_unref (ccond_ind), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
		}
		(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
		(array_len = (g_object_unref (array_len), NULL));
	} else {
		if (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt))) == self->priv->list_type || vala_type_reference_get_data_type (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt))) == self->priv->slist_type) {
			char* it_name;
			ValaCCodeDeclaration* citdecl;
			ValaCCodeVariableDeclarator* __temp318;
			ValaCCodeBlock* cbody;
			ValaCCodeExpression* element_expr;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* __temp324;
			ValaCCodeBinaryExpression* ccond;
			ValaCCodeForStatement* cfor;
			ValaCCodeAssignment* __temp325;
			ValaCCodeAssignment* __temp326;
			it_name = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt));
			citdecl = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)), FALSE, FALSE));
			__temp318 = NULL;
			vala_ccode_declaration_add_declarator (citdecl, VALA_CCODE_DECLARATOR ((__temp318 = vala_ccode_variable_declarator_new (it_name))));
			(__temp318 == NULL ? NULL : (__temp318 = (g_object_unref (__temp318), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (citdecl));
			cbody = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
			element_expr = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), "data"));
			/* cast pointer to actual type if appropriate */
			if (VALA_IS_STRUCT (vala_type_reference_get_data_type (vala_foreach_statement_get_type_reference (stmt)))) {
				ValaStruct* __temp319;
				ValaStruct* st;
				__temp319 = NULL;
				st = (__temp319 = VALA_STRUCT (vala_type_reference_get_data_type (vala_foreach_statement_get_type_reference (stmt))), (__temp319 == NULL ? NULL : g_object_ref (__temp319)));
				if (VALA_DATA_TYPE (st) == vala_type_reference_get_data_type (self->priv->uint_type)) {
					ValaCCodeFunctionCall* cconv;
					ValaCCodeExpression* __temp321;
					ValaCCodeFunctionCall* __temp320;
					cconv = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("GPOINTER_TO_UINT")));
					vala_ccode_function_call_add_argument (cconv, element_expr);
					__temp321 = NULL;
					__temp320 = NULL;
					element_expr = (__temp321 = VALA_CCODE_EXPRESSION ((__temp320 = cconv, (__temp320 == NULL ? NULL : g_object_ref (__temp320)))), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), __temp321);
					(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
				} else {
					if (VALA_DATA_TYPE (st) == vala_type_reference_get_data_type (self->priv->bool_type) || vala_struct_is_integer_type (st)) {
						ValaCCodeFunctionCall* cconv;
						ValaCCodeExpression* __temp323;
						ValaCCodeFunctionCall* __temp322;
						cconv = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("GPOINTER_TO_INT")));
						vala_ccode_function_call_add_argument (cconv, element_expr);
						__temp323 = NULL;
						__temp322 = NULL;
						element_expr = (__temp323 = VALA_CCODE_EXPRESSION ((__temp322 = cconv, (__temp322 == NULL ? NULL : g_object_ref (__temp322)))), (element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL))), __temp323);
						(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
					}
				}
				(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
			}
			cdecl_ = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_foreach_statement_get_type_reference (stmt), FALSE, FALSE));
			__temp324 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp324 = vala_ccode_variable_declarator_new_with_initializer (vala_foreach_statement_get_variable_name (stmt), element_expr))));
			(__temp324 == NULL ? NULL : (__temp324 = (g_object_unref (__temp324), NULL)));
			vala_ccode_block_add_statement (cbody, VALA_CCODE_NODE (cdecl_));
			vala_ccode_block_add_statement (cbody, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_foreach_statement_get_body (stmt))));
			ccond = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
			cfor = vala_ccode_for_statement_new (VALA_CCODE_EXPRESSION (ccond), VALA_CCODE_STATEMENT (cbody));
			__temp325 = NULL;
			vala_ccode_for_statement_add_initializer (cfor, VALA_CCODE_EXPRESSION ((__temp325 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (collection_backup))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp325 == NULL ? NULL : (__temp325 = (g_object_unref (__temp325), NULL)));
			__temp326 = NULL;
			vala_ccode_for_statement_add_iterator (cfor, VALA_CCODE_EXPRESSION ((__temp326 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (it_name)), "next")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp326 == NULL ? NULL : (__temp326 = (g_object_unref (__temp326), NULL)));
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cfor));
			(it_name = (g_free (it_name), NULL));
			(citdecl == NULL ? NULL : (citdecl = (g_object_unref (citdecl), NULL)));
			(cbody == NULL ? NULL : (cbody = (g_object_unref (cbody), NULL)));
			(element_expr == NULL ? NULL : (element_expr = (g_object_unref (element_expr), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			(ccond == NULL ? NULL : (ccond = (g_object_unref (ccond), NULL)));
			(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
		}
	}
	if (vala_code_generator_get_memory_management (self) && vala_type_reference_get_transfers_ownership (vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)))) {
		ValaCCodeExpressionStatement* __temp328;
		ValaCCodeIdentifier* __temp327;
		__temp328 = NULL;
		__temp327 = NULL;
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp328 = vala_ccode_expression_statement_new (vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((__temp327 = vala_ccode_identifier_new (vala_variable_declarator_get_name (collection_backup)))), vala_expression_get_static_type (vala_foreach_statement_get_collection (stmt)))))));
		(__temp328 == NULL ? NULL : (__temp328 = (g_object_unref (__temp328), NULL)));
		(__temp327 == NULL ? NULL : (__temp327 = (g_object_unref (__temp327), NULL)));
	}
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	(cfor == NULL ? NULL : (cfor = (g_object_unref (cfor), NULL)));
	(collection_backup == NULL ? NULL : (collection_backup = (g_object_unref (collection_backup), NULL)));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_code_generator_real_visit_break_statement (ValaCodeVisitor* base, ValaBreakStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeBreakStatement* __temp329;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_BREAK_STATEMENT (stmt));
	__temp329 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp329 = g_object_new (VALA_TYPE_CCODE_BREAK_STATEMENT, NULL)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(__temp329 == NULL ? NULL : (__temp329 = (g_object_unref (__temp329), NULL)));
}


static void vala_code_generator_real_visit_continue_statement (ValaCodeVisitor* base, ValaContinueStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeContinueStatement* __temp330;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CONTINUE_STATEMENT (stmt));
	__temp330 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp330 = g_object_new (VALA_TYPE_CCODE_CONTINUE_STATEMENT, NULL)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(__temp330 == NULL ? NULL : (__temp330 = (g_object_unref (__temp330), NULL)));
}


static void vala_code_generator_append_local_free (ValaCodeGenerator* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop)
{
	ValaBlock* __temp331;
	ValaBlock* b;
	GList* local_vars;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (sym == NULL || VALA_IS_SYMBOL (sym));
	g_return_if_fail (cfrag == NULL || VALA_IS_CCODE_FRAGMENT (cfrag));
	__temp331 = NULL;
	b = (__temp331 = VALA_BLOCK (vala_symbol_get_node (sym)), (__temp331 == NULL ? NULL : g_object_ref (__temp331)));
	local_vars = vala_block_get_local_variables (b);
	{
		GList* __temp334;
		GList* decl_it;
		__temp334 = NULL;
		__temp334 = local_vars;
		for (decl_it = __temp334; decl_it != NULL; decl_it = decl_it->next) {
			ValaVariableDeclarator* decl;
			decl = decl_it->data;
			{
				if (vala_symbol_get_active (vala_code_node_get_symbol (VALA_CODE_NODE (decl))) && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))) && vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
					ValaCCodeExpressionStatement* __temp333;
					ValaCCodeIdentifier* __temp332;
					__temp333 = NULL;
					__temp332 = NULL;
					vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp333 = vala_ccode_expression_statement_new (vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((__temp332 = vala_ccode_identifier_new (vala_code_generator_get_variable_cname (self, vala_variable_declarator_get_name (decl))))), vala_variable_declarator_get_type_reference (decl))))));
					(__temp333 == NULL ? NULL : (__temp333 = (g_object_unref (__temp333), NULL)));
					(__temp332 == NULL ? NULL : (__temp332 = (g_object_unref (__temp332), NULL)));
				}
			}
		}
	}
	if (VALA_IS_BLOCK (vala_symbol_get_node (vala_symbol_get_parent_symbol (sym)))) {
		vala_code_generator_append_local_free (self, vala_symbol_get_parent_symbol (sym), cfrag, stop_at_loop);
	}
	(b == NULL ? NULL : (b = (g_object_unref (b), NULL)));
	(local_vars == NULL ? NULL : (local_vars = (g_list_free (local_vars), NULL)));
}


static void vala_code_generator_create_local_free (ValaCodeGenerator* self, ValaStatement* stmt)
{
	ValaCCodeFragment* cfrag;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (stmt == NULL || VALA_IS_STATEMENT (stmt));
	if (!vala_code_generator_get_memory_management (self)) {
		return;
	}
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	vala_code_generator_append_local_free (self, self->priv->current_symbol, cfrag, FALSE);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static gboolean vala_code_generator_append_local_free_expr (ValaCodeGenerator* self, ValaSymbol* sym, ValaCCodeCommaExpression* ccomma, gboolean stop_at_loop)
{
	gboolean found;
	ValaBlock* __temp335;
	ValaBlock* b;
	GList* local_vars;
	gboolean __temp339;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (sym == NULL || VALA_IS_SYMBOL (sym), FALSE);
	g_return_val_if_fail (ccomma == NULL || VALA_IS_CCODE_COMMA_EXPRESSION (ccomma), FALSE);
	found = FALSE;
	__temp335 = NULL;
	b = (__temp335 = VALA_BLOCK (vala_symbol_get_node (sym)), (__temp335 == NULL ? NULL : g_object_ref (__temp335)));
	local_vars = vala_block_get_local_variables (b);
	{
		GList* __temp338;
		GList* decl_it;
		__temp338 = NULL;
		__temp338 = local_vars;
		for (decl_it = __temp338; decl_it != NULL; decl_it = decl_it->next) {
			ValaVariableDeclarator* decl;
			decl = decl_it->data;
			{
				if (vala_symbol_get_active (vala_code_node_get_symbol (VALA_CODE_NODE (decl))) && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_variable_declarator_get_type_reference (decl))) && vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
					ValaCCodeExpression* __temp337;
					ValaCCodeIdentifier* __temp336;
					found = TRUE;
					__temp337 = NULL;
					__temp336 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (__temp337 = vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION ((__temp336 = vala_ccode_identifier_new (vala_code_generator_get_variable_cname (self, vala_variable_declarator_get_name (decl))))), vala_variable_declarator_get_type_reference (decl))));
					(__temp337 == NULL ? NULL : (__temp337 = (g_object_unref (__temp337), NULL)));
					(__temp336 == NULL ? NULL : (__temp336 = (g_object_unref (__temp336), NULL)));
				}
			}
		}
	}
	if (VALA_IS_BLOCK (vala_symbol_get_node (vala_symbol_get_parent_symbol (sym)))) {
		found = found || vala_code_generator_append_local_free_expr (self, vala_symbol_get_parent_symbol (sym), ccomma, stop_at_loop);
	}
	return (__temp339 = found, (b == NULL ? NULL : (b = (g_object_unref (b), NULL))), (local_vars == NULL ? NULL : (local_vars = (g_list_free (local_vars), NULL))), __temp339);
	(b == NULL ? NULL : (b = (g_object_unref (b), NULL)));
	(local_vars == NULL ? NULL : (local_vars = (g_list_free (local_vars), NULL)));
}


static void vala_code_generator_create_local_free_expr (ValaCodeGenerator* self, ValaExpression* expr)
{
	ValaVariableDeclarator* return_expr_decl;
	ValaCCodeCommaExpression* ccomma;
	ValaCCodeAssignment* __temp340;
	ValaCCodeIdentifier* __temp341;
	ValaVariableDeclarator* __temp342;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (expr == NULL || VALA_IS_EXPRESSION (expr));
	if (!vala_code_generator_get_memory_management (self)) {
		return;
	}
	return_expr_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (expr), TRUE);
	ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
	__temp340 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp340 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (return_expr_decl))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(__temp340 == NULL ? NULL : (__temp340 = (g_object_unref (__temp340), NULL)));
	if (!vala_code_generator_append_local_free_expr (self, self->priv->current_symbol, ccomma, FALSE)) {
		(return_expr_decl == NULL ? NULL : (return_expr_decl = (g_object_unref (return_expr_decl), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		return;
	}
	/* no local variables need to be freed */
	__temp341 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp341 = vala_ccode_identifier_new (vala_variable_declarator_get_name (return_expr_decl)))));
	(__temp341 == NULL ? NULL : (__temp341 = (g_object_unref (__temp341), NULL)));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	__temp342 = NULL;
	expr->temp_vars = g_list_append (expr->temp_vars, (__temp342 = return_expr_decl, (__temp342 == NULL ? NULL : g_object_ref (__temp342))));
	(return_expr_decl == NULL ? NULL : (return_expr_decl = (g_object_unref (return_expr_decl), NULL)));
	(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
}


static void vala_code_generator_real_visit_begin_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_RETURN_STATEMENT (stmt));
	if (vala_return_statement_get_return_expression (stmt) != NULL) {
		/* avoid unnecessary ref/unref pair*/
		if (vala_expression_get_ref_missing (vala_return_statement_get_return_expression (stmt)) && vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)) != NULL && VALA_IS_VARIABLE_DECLARATOR (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt))))) {
			ValaVariableDeclarator* __temp343;
			ValaVariableDeclarator* decl;
			__temp343 = NULL;
			decl = (__temp343 = VALA_VARIABLE_DECLARATOR (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)))), (__temp343 == NULL ? NULL : g_object_ref (__temp343)));
			if (vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
				/* return expression is local variable taking ownership and
				 * current method is transferring ownership */
				(vala_expression_set_ref_sink (vala_return_statement_get_return_expression (stmt), TRUE), vala_expression_get_ref_sink (vala_return_statement_get_return_expression (stmt)));
				/* don't ref expression*/
				(vala_expression_set_ref_missing (vala_return_statement_get_return_expression (stmt), FALSE), vala_expression_get_ref_missing (vala_return_statement_get_return_expression (stmt)));
			}
			(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
		}
	}
}


static void vala_code_generator_real_visit_end_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_RETURN_STATEMENT (stmt));
	if (vala_return_statement_get_return_expression (stmt) == NULL) {
		ValaCCodeReturnStatement* __temp344;
		__temp344 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp344 = vala_ccode_return_statement_new (NULL)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
		(__temp344 == NULL ? NULL : (__temp344 = (g_object_unref (__temp344), NULL)));
		vala_code_generator_create_local_free (self, VALA_STATEMENT (stmt));
	} else {
		ValaSymbol* return_expression_symbol;
		ValaCCodeReturnStatement* __temp354;
		return_expression_symbol = NULL;
		/* avoid unnecessary ref/unref pair*/
		if (vala_expression_get_ref_sink (vala_return_statement_get_return_expression (stmt)) && vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)) != NULL && VALA_IS_VARIABLE_DECLARATOR (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt))))) {
			ValaVariableDeclarator* __temp345;
			ValaVariableDeclarator* decl;
			__temp345 = NULL;
			decl = (__temp345 = VALA_VARIABLE_DECLARATOR (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt)))), (__temp345 == NULL ? NULL : g_object_ref (__temp345)));
			if (vala_type_reference_get_takes_ownership (vala_variable_declarator_get_type_reference (decl))) {
				ValaSymbol* __temp347;
				ValaSymbol* __temp346;
				/* return expression is local variable taking ownership and
				 * current method is transferring ownership 
				 don't unref expression*/
				__temp347 = NULL;
				__temp346 = NULL;
				return_expression_symbol = (__temp347 = (__temp346 = vala_code_node_get_symbol (VALA_CODE_NODE (decl)), (__temp346 == NULL ? NULL : g_object_ref (__temp346))), (return_expression_symbol == NULL ? NULL : (return_expression_symbol = (g_object_unref (return_expression_symbol), NULL))), __temp347);
				(vala_symbol_set_active (return_expression_symbol, FALSE), vala_symbol_get_active (return_expression_symbol));
			}
			(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
		}
		/* return array length if appropriate*/
		if (self->priv->current_method != NULL && !vala_method_get_no_array_length (self->priv->current_method) && VALA_IS_ARRAY (vala_type_reference_get_data_type (self->priv->current_return_type))) {
			ValaVariableDeclarator* return_expr_decl;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeAssignment* __temp348;
			ValaArray* __temp349;
			ValaArray* arr;
			ValaCCodeIdentifier* __temp351;
			ValaVariableDeclarator* __temp352;
			return_expr_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (vala_return_statement_get_return_expression (stmt)), TRUE);
			ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
			__temp348 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp348 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (return_expr_decl))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp348 == NULL ? NULL : (__temp348 = (g_object_unref (__temp348), NULL)));
			__temp349 = NULL;
			arr = (__temp349 = VALA_ARRAY (vala_type_reference_get_data_type (self->priv->current_return_type)), (__temp349 == NULL ? NULL : g_object_ref (__temp349)));
			{
				gint dim;
				dim = 0;
				for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
					ValaCCodeUnaryExpression* len_l;
					ValaCCodeExpression* len_r;
					ValaCCodeAssignment* __temp350;
					len_l = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_code_generator_get_array_length_cname (self, "result", dim))));
					len_r = vala_code_generator_get_array_length_cexpression (self, vala_return_statement_get_return_expression (stmt), dim);
					__temp350 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp350 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (len_l), len_r, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(__temp350 == NULL ? NULL : (__temp350 = (g_object_unref (__temp350), NULL)));
					(len_l == NULL ? NULL : (len_l = (g_object_unref (len_l), NULL)));
					(len_r = (g_object_unref (len_r), NULL));
				}
			}
			__temp351 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp351 = vala_ccode_identifier_new (vala_variable_declarator_get_name (return_expr_decl)))));
			(__temp351 == NULL ? NULL : (__temp351 = (g_object_unref (__temp351), NULL)));
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt)), VALA_CCODE_NODE (ccomma)), vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt))));
			__temp352 = NULL;
			vala_return_statement_get_return_expression (stmt)->temp_vars = g_list_append (vala_return_statement_get_return_expression (stmt)->temp_vars, (__temp352 = return_expr_decl, (__temp352 == NULL ? NULL : g_object_ref (__temp352))));
			(return_expr_decl == NULL ? NULL : (return_expr_decl = (g_object_unref (return_expr_decl), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
		}
		vala_code_generator_create_local_free_expr (self, vala_return_statement_get_return_expression (stmt));
		if (vala_expression_get_static_type (vala_return_statement_get_return_expression (stmt)) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_return_statement_get_return_expression (stmt))) != vala_type_reference_get_data_type (self->priv->current_return_type)) {
			/* cast required */
			if (VALA_IS_CLASS (vala_type_reference_get_data_type (self->priv->current_return_type)) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (self->priv->current_return_type))) {
				ValaInstanceCast* __temp353;
				__temp353 = NULL;
				(vala_code_node_set_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt)), VALA_CCODE_NODE ((__temp353 = vala_instance_cast_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt)))), vala_type_reference_get_data_type (self->priv->current_return_type))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt))));
				(__temp353 == NULL ? NULL : (__temp353 = (g_object_unref (__temp353), NULL)));
			}
		}
		__temp354 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE ((__temp354 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_return_statement_get_return_expression (stmt)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
		(__temp354 == NULL ? NULL : (__temp354 = (g_object_unref (__temp354), NULL)));
		vala_code_generator_create_temp_decl (self, VALA_STATEMENT (stmt), vala_return_statement_get_return_expression (stmt)->temp_vars);
		if (return_expression_symbol != NULL) {
			(vala_symbol_set_active (return_expression_symbol, TRUE), vala_symbol_get_active (return_expression_symbol));
		}
		(return_expression_symbol == NULL ? NULL : (return_expression_symbol = (g_object_unref (return_expression_symbol), NULL)));
	}
}


static void vala_code_generator_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeFragment* cfrag;
	ValaCCodeExpressionStatement* __temp355;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_THROW_STATEMENT (stmt));
	vala_code_node_accept_children (VALA_CODE_NODE (stmt), VALA_CODE_VISITOR (self));
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	__temp355 = NULL;
	vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp355 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_throw_statement_get_error_expression (stmt))))))));
	(__temp355 == NULL ? NULL : (__temp355 = (g_object_unref (__temp355), NULL)));
	if (self->priv->current_return_type != NULL && vala_type_reference_get_data_type (self->priv->current_return_type) != NULL) {
		ValaCCodeReturnStatement* __temp356;
		__temp356 = NULL;
		vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp356 = vala_ccode_return_statement_new (vala_code_generator_default_value_for_type (self, vala_type_reference_get_data_type (self->priv->current_return_type))))));
		(__temp356 == NULL ? NULL : (__temp356 = (g_object_unref (__temp356), NULL)));
	} else {
		ValaCCodeReturnStatement* __temp357;
		__temp357 = NULL;
		vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp357 = vala_ccode_return_statement_new (NULL))));
		(__temp357 == NULL ? NULL : (__temp357 = (g_object_unref (__temp357), NULL)));
	}
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_code_generator_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaTryStatement* __temp358;
	ValaTryStatement* old_try;
	gint old_try_id;
	ValaTryStatement* __temp359;
	ValaCCodeFragment* cfrag;
	ValaCCodeLabel* __temp362;
	ValaTryStatement* __temp365;
	ValaTryStatement* __temp364;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_TRY_STATEMENT (stmt));
	__temp358 = NULL;
	old_try = (__temp358 = self->priv->current_try, (__temp358 == NULL ? NULL : g_object_ref (__temp358)));
	old_try_id = self->priv->current_try_id;
	__temp359 = NULL;
	self->priv->current_try = (__temp359 = g_object_ref (stmt), (self->priv->current_try == NULL ? NULL : (self->priv->current_try = (g_object_unref (self->priv->current_try), NULL))), __temp359);
	self->priv->current_try_id = self->priv->next_try_id++;
	vala_code_node_accept_children (VALA_CODE_NODE (stmt), VALA_CODE_VISITOR (self));
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_try_statement_get_body (stmt))));
	{
		GList* __temp361;
		GList* clause_it;
		__temp361 = NULL;
		__temp361 = vala_try_statement_get_catch_clauses (stmt);
		for (clause_it = __temp361; clause_it != NULL; clause_it = clause_it->next) {
			ValaCatchClause* clause;
			clause = clause_it->data;
			{
				ValaCCodeGotoStatement* __temp360;
				__temp360 = NULL;
				vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp360 = vala_ccode_goto_statement_new (g_strdup_printf ("__finally%d", self->priv->current_try_id)))));
				(__temp360 == NULL ? NULL : (__temp360 = (g_object_unref (__temp360), NULL)));
				vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (VALA_CODE_NODE (clause)));
			}
		}
		(__temp361 == NULL ? NULL : (__temp361 = (g_list_free (__temp361), NULL)));
	}
	__temp362 = NULL;
	vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp362 = vala_ccode_label_new (g_strdup_printf ("__finally%d", self->priv->current_try_id)))));
	(__temp362 == NULL ? NULL : (__temp362 = (g_object_unref (__temp362), NULL)));
	if (vala_try_statement_get_finally_body (stmt) != NULL) {
		vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_try_statement_get_finally_body (stmt))));
	} else {
		ValaCCodeEmptyStatement* __temp363;
		/* avoid gcc error: label at end of compound statement*/
		__temp363 = NULL;
		vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp363 = g_object_new (VALA_TYPE_CCODE_EMPTY_STATEMENT, NULL))));
		(__temp363 == NULL ? NULL : (__temp363 = (g_object_unref (__temp363), NULL)));
	}
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cfrag)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	__temp365 = NULL;
	__temp364 = NULL;
	self->priv->current_try = (__temp365 = (__temp364 = old_try, (__temp364 == NULL ? NULL : g_object_ref (__temp364))), (self->priv->current_try == NULL ? NULL : (self->priv->current_try = (g_object_unref (self->priv->current_try), NULL))), __temp365);
	self->priv->current_try_id = old_try_id;
	(old_try == NULL ? NULL : (old_try = (g_object_unref (old_try), NULL)));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
}


static void vala_code_generator_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause)
{
	ValaCodeGenerator * self;
	ValaCCodeFragment* cfrag;
	ValaCCodeLabel* __temp367;
	char* __temp366;
	ValaCCodeBlock* cblock;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* __temp368;
	ValaCCodeExpressionStatement* __temp369;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CATCH_CLAUSE (clause));
	vala_code_node_accept_children (VALA_CODE_NODE (clause), VALA_CODE_VISITOR (self));
	cfrag = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	__temp367 = NULL;
	__temp366 = NULL;
	vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE ((__temp367 = vala_ccode_label_new (g_strdup_printf ("__catch%d_%s", self->priv->current_try_id, (__temp366 = vala_data_type_get_lower_case_cname (vala_type_reference_get_data_type (vala_catch_clause_get_type_reference (clause)), NULL)))))));
	(__temp367 == NULL ? NULL : (__temp367 = (g_object_unref (__temp367), NULL)));
	(__temp366 = (g_free (__temp366), NULL));
	cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	cdecl_ = vala_ccode_declaration_new ("GError *");
	__temp368 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp368 = vala_ccode_variable_declarator_new_with_initializer (vala_catch_clause_get_variable_name (clause), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("inner_error"))))));
	(__temp368 == NULL ? NULL : (__temp368 = (g_object_unref (__temp368), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	__temp369 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp369 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("inner_error")), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp369 == NULL ? NULL : (__temp369 = (g_object_unref (__temp369), NULL)));
	vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_catch_clause_get_body (clause))));
	vala_ccode_fragment_append (cfrag, VALA_CCODE_NODE (cblock));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (clause), VALA_CCODE_NODE (cfrag)), vala_code_node_get_ccodenode (VALA_CODE_NODE (clause)));
	(cfrag == NULL ? NULL : (cfrag = (g_object_unref (cfrag), NULL)));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
}


static char* vala_code_generator_get_symbol_lock_name (ValaCodeGenerator* self, ValaSymbol* sym)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SYMBOL (sym), NULL);
	return g_strdup_printf ("__lock_%s", vala_symbol_get_name (sym));
}


/**
 * Visit operation called for lock statements.
 *
 * @param stmt a lock statement
 */
static void vala_code_generator_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt)
{
	ValaCodeGenerator * self;
	ValaCCodeFragment* cn;
	ValaCCodeExpression* l;
	ValaCCodeFunctionCall* fc;
	ValaExpression* __temp371;
	ValaExpression* inner_node;
	ValaCCodeExpression* __temp376;
	ValaCCodeFunctionCall* __temp378;
	ValaSymbol* __temp377;
	ValaCCodeExpressionStatement* __temp379;
	ValaCCodeFunctionCall* __temp381;
	ValaSymbol* __temp380;
	ValaCCodeExpressionStatement* __temp382;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_LOCK_STATEMENT (stmt));
	cn = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
	l = NULL;
	fc = NULL;
	__temp371 = NULL;
	inner_node = (__temp371 = vala_member_access_get_inner ((VALA_MEMBER_ACCESS (vala_lock_statement_get_resource (stmt)))), (__temp371 == NULL ? NULL : g_object_ref (__temp371)));
	if (inner_node == NULL) {
		ValaCCodeExpression* __temp372;
		__temp372 = NULL;
		l = (__temp372 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), __temp372);
	} else {
		if (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt)))) != VALA_CODE_NODE (self->priv->current_class)) {
			ValaCCodeExpression* __temp373;
			__temp373 = NULL;
			l = (__temp373 = VALA_CCODE_EXPRESSION (vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt)))))), NULL))))), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), __temp373);
			vala_ccode_function_call_add_argument ((VALA_CCODE_FUNCTION_CALL (l)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (inner_node))));
		} else {
			ValaCCodeExpression* __temp375;
			ValaCCodeExpression* __temp374;
			__temp375 = NULL;
			__temp374 = NULL;
			l = (__temp375 = (__temp374 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (inner_node))), (__temp374 == NULL ? NULL : g_object_ref (__temp374))), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), __temp375);
		}
	}
	__temp376 = NULL;
	l = (__temp376 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (l, "priv")), vala_code_generator_get_symbol_lock_name (self, vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt))))), (l == NULL ? NULL : (l = (g_object_unref (l), NULL))), __temp376);
	__temp378 = NULL;
	__temp377 = NULL;
	fc = (__temp378 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_method_get_cname ((VALA_METHOD (vala_symbol_get_node ((__temp377 = vala_symbol_lookup (vala_code_node_get_symbol (VALA_CODE_NODE (vala_type_reference_get_data_type (self->priv->mutex_type))), "lock"))))))))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), __temp378);
	(__temp377 == NULL ? NULL : (__temp377 = (g_object_unref (__temp377), NULL)));
	vala_ccode_function_call_add_argument (fc, l);
	__temp379 = NULL;
	vala_ccode_fragment_append (cn, VALA_CCODE_NODE ((__temp379 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
	(__temp379 == NULL ? NULL : (__temp379 = (g_object_unref (__temp379), NULL)));
	vala_ccode_fragment_append (cn, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_lock_statement_get_body (stmt))));
	__temp381 = NULL;
	__temp380 = NULL;
	fc = (__temp381 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_method_get_cname ((VALA_METHOD (vala_symbol_get_node ((__temp380 = vala_symbol_lookup (vala_code_node_get_symbol (VALA_CODE_NODE (vala_type_reference_get_data_type (self->priv->mutex_type))), "unlock"))))))))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), __temp381);
	(__temp380 == NULL ? NULL : (__temp380 = (g_object_unref (__temp380), NULL)));
	vala_ccode_function_call_add_argument (fc, l);
	__temp382 = NULL;
	vala_ccode_fragment_append (cn, VALA_CCODE_NODE ((__temp382 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
	(__temp382 == NULL ? NULL : (__temp382 = (g_object_unref (__temp382), NULL)));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (stmt), VALA_CCODE_NODE (cn)), vala_code_node_get_ccodenode (VALA_CODE_NODE (stmt)));
	(cn == NULL ? NULL : (cn = (g_object_unref (cn), NULL)));
	(l == NULL ? NULL : (l = (g_object_unref (l), NULL)));
	(fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL)));
	(inner_node == NULL ? NULL : (inner_node = (g_object_unref (inner_node), NULL)));
}


/**
 * Visit operations called for array creation expresions.
 *
 * @param expr an array creation expression
 */
static void vala_code_generator_real_visit_end_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeFunctionCall* gnew;
	ValaCCodeIdentifier* __temp383;
	gboolean first;
	ValaCCodeExpression* cexpr;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (expr));
	gnew = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_new0")));
	__temp383 = NULL;
	vala_ccode_function_call_add_argument (gnew, VALA_CCODE_EXPRESSION ((__temp383 = vala_ccode_identifier_new (vala_type_reference_get_cname (vala_array_creation_expression_get_element_type (expr), FALSE, FALSE)))));
	(__temp383 == NULL ? NULL : (__temp383 = (g_object_unref (__temp383), NULL)));
	first = TRUE;
	cexpr = NULL;
	{
		GList* __temp387;
		GList* size_it;
		__temp387 = NULL;
		__temp387 = vala_array_creation_expression_get_sizes (expr);
		for (size_it = __temp387; size_it != NULL; size_it = size_it->next) {
			ValaExpression* size;
			size = size_it->data;
			{
				if (first) {
					ValaCCodeExpression* __temp385;
					ValaCCodeExpression* __temp384;
					__temp385 = NULL;
					__temp384 = NULL;
					cexpr = (__temp385 = (__temp384 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (size))), (__temp384 == NULL ? NULL : g_object_ref (__temp384))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp385);
					first = FALSE;
				} else {
					ValaCCodeExpression* __temp386;
					__temp386 = NULL;
					cexpr = (__temp386 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, cexpr, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (size))))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp386);
				}
			}
		}
		(__temp387 == NULL ? NULL : (__temp387 = (g_list_free (__temp387), NULL)));
	}
	vala_ccode_function_call_add_argument (gnew, cexpr);
	if (vala_array_creation_expression_get_initializer_list (expr) != NULL) {
		ValaCCodeCommaExpression* ce;
		ValaVariableDeclarator* temp_var;
		ValaCCodeIdentifier* name_cnode;
		gint i;
		ValaVariableDeclarator* __temp388;
		ValaCCodeAssignment* __temp389;
		/* FIXME rank > 1 not supported yet*/
		if (vala_array_creation_expression_get_rank (expr) > 1) {
			(vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE), vala_code_node_get_error (VALA_CODE_NODE (expr)));
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "Creating arrays with rank greater than 1 with initializers is not supported yet");
		}
		ce = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
		temp_var = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (VALA_EXPRESSION (expr)), TRUE);
		name_cnode = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_var));
		i = 0;
		__temp388 = NULL;
		self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp388 = temp_var, (__temp388 == NULL ? NULL : g_object_ref (__temp388))));
		__temp389 = NULL;
		vala_ccode_comma_expression_append_expression (ce, VALA_CCODE_EXPRESSION ((__temp389 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (name_cnode), VALA_CCODE_EXPRESSION (gnew), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(__temp389 == NULL ? NULL : (__temp389 = (g_object_unref (__temp389), NULL)));
		{
			GList* __temp391;
			GList* e_it;
			__temp391 = NULL;
			__temp391 = vala_initializer_list_get_initializers (vala_array_creation_expression_get_initializer_list (expr));
			for (e_it = __temp391; e_it != NULL; e_it = e_it->next) {
				ValaExpression* e;
				e = e_it->data;
				{
					ValaCCodeAssignment* __temp390;
					__temp390 = NULL;
					vala_ccode_comma_expression_append_expression (ce, VALA_CCODE_EXPRESSION ((__temp390 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_element_access_new (VALA_CCODE_EXPRESSION (name_cnode), VALA_CCODE_EXPRESSION (vala_ccode_constant_new (g_strdup_printf ("%i", i))))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (e))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(__temp390 == NULL ? NULL : (__temp390 = (g_object_unref (__temp390), NULL)));
					i++;
				}
			}
			(__temp391 == NULL ? NULL : (__temp391 = (g_list_free (__temp391), NULL)));
		}
		vala_ccode_comma_expression_append_expression (ce, VALA_CCODE_EXPRESSION (name_cnode));
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ce)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(ce == NULL ? NULL : (ce = (g_object_unref (ce), NULL)));
		(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
		(name_cnode == NULL ? NULL : (name_cnode = (g_object_unref (name_cnode), NULL)));
	} else {
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (gnew)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	}
	(gnew == NULL ? NULL : (gnew = (g_object_unref (gnew), NULL)));
	(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
}


static void vala_code_generator_real_visit_boolean_literal (ValaCodeVisitor* base, ValaBooleanLiteral* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeConstant* __temp392;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_BOOLEAN_LITERAL (expr));
	__temp392 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp392 = vala_ccode_constant_new ((vala_boolean_literal_get_value (expr) ? "TRUE" : "FALSE"))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp392 == NULL ? NULL : (__temp392 = (g_object_unref (__temp392), NULL)));
}


static void vala_code_generator_real_visit_character_literal (ValaCodeVisitor* base, ValaCharacterLiteral* expr)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CHARACTER_LITERAL (expr));
	if (vala_character_literal_get_char (expr) >= 0x20 && vala_character_literal_get_char (expr) < 0x80) {
		ValaCCodeConstant* __temp393;
		__temp393 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp393 = vala_ccode_constant_new (vala_character_literal_get_value (expr))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(__temp393 == NULL ? NULL : (__temp393 = (g_object_unref (__temp393), NULL)));
	} else {
		ValaCCodeConstant* __temp394;
		__temp394 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp394 = vala_ccode_constant_new (g_strdup_printf ("%uU", vala_character_literal_get_char (expr)))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(__temp394 == NULL ? NULL : (__temp394 = (g_object_unref (__temp394), NULL)));
	}
}


static void vala_code_generator_real_visit_integer_literal (ValaCodeVisitor* base, ValaIntegerLiteral* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeConstant* __temp395;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_INTEGER_LITERAL (expr));
	__temp395 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp395 = vala_ccode_constant_new (vala_integer_literal_get_value (expr))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp395 == NULL ? NULL : (__temp395 = (g_object_unref (__temp395), NULL)));
}


static void vala_code_generator_real_visit_real_literal (ValaCodeVisitor* base, ValaRealLiteral* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeConstant* __temp396;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_REAL_LITERAL (expr));
	__temp396 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp396 = vala_ccode_constant_new (vala_real_literal_get_value (expr))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp396 == NULL ? NULL : (__temp396 = (g_object_unref (__temp396), NULL)));
}


static void vala_code_generator_real_visit_string_literal (ValaCodeVisitor* base, ValaStringLiteral* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeConstant* __temp397;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_STRING_LITERAL (expr));
	__temp397 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp397 = vala_ccode_constant_new (vala_string_literal_get_value (expr))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp397 == NULL ? NULL : (__temp397 = (g_object_unref (__temp397), NULL)));
}


static void vala_code_generator_real_visit_null_literal (ValaCodeVisitor* base, ValaNullLiteral* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeConstant* __temp398;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_NULL_LITERAL (expr));
	__temp398 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp398 = vala_ccode_constant_new ("NULL")))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp398 == NULL ? NULL : (__temp398 = (g_object_unref (__temp398), NULL)));
}


static void vala_code_generator_real_visit_literal_expression (ValaCodeVisitor* base, ValaLiteralExpression* expr)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_LITERAL_EXPRESSION (expr));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_literal_expression_get_literal (expr)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_code_generator_real_visit_parenthesized_expression (ValaCodeVisitor* base, ValaParenthesizedExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeParenthesizedExpression* __temp399;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_PARENTHESIZED_EXPRESSION (expr));
	__temp399 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp399 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_parenthesized_expression_get_inner (expr)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp399 == NULL ? NULL : (__temp399 = (g_object_unref (__temp399), NULL)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static ValaCCodeExpression* vala_code_generator_get_array_length_cexpression (ValaCodeGenerator* self, ValaExpression* array_expr, gint dim)
{
	gboolean is_out;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (array_expr), NULL);
	is_out = FALSE;
	if (VALA_IS_UNARY_EXPRESSION (array_expr)) {
		ValaUnaryExpression* __temp400;
		ValaUnaryExpression* unary_expr;
		__temp400 = NULL;
		unary_expr = (__temp400 = VALA_UNARY_EXPRESSION (array_expr), (__temp400 == NULL ? NULL : g_object_ref (__temp400)));
		if (vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_OUT) {
			array_expr = vala_unary_expression_get_inner (unary_expr);
			is_out = TRUE;
		}
		(unary_expr == NULL ? NULL : (unary_expr = (g_object_unref (unary_expr), NULL)));
	}
	if (VALA_IS_ARRAY_CREATION_EXPRESSION (array_expr)) {
		GList* size;
		ValaExpression* __temp401;
		ValaExpression* length_expr;
		ValaCCodeExpression* __temp402;
		ValaCCodeExpression* __temp403;
		size = vala_array_creation_expression_get_sizes ((VALA_ARRAY_CREATION_EXPRESSION (array_expr)));
		__temp401 = NULL;
		length_expr = (__temp401 = g_list_nth_data (size, dim - 1), (__temp401 == NULL ? NULL : g_object_ref (__temp401)));
		__temp402 = NULL;
		__temp403 = NULL;
		return (__temp403 = (__temp402 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (length_expr))), (__temp402 == NULL ? NULL : g_object_ref (__temp402))), (size == NULL ? NULL : (size = (g_list_free (size), NULL))), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp403);
		(size == NULL ? NULL : (size = (g_list_free (size), NULL)));
		(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
	} else {
		if (VALA_IS_INVOCATION_EXPRESSION (array_expr)) {
			ValaInvocationExpression* __temp404;
			ValaInvocationExpression* invocation_expr;
			GList* size;
			ValaCCodeExpression* __temp405;
			ValaCCodeExpression* __temp406;
			__temp404 = NULL;
			invocation_expr = (__temp404 = VALA_INVOCATION_EXPRESSION (array_expr), (__temp404 == NULL ? NULL : g_object_ref (__temp404)));
			size = vala_invocation_expression_get_array_sizes (invocation_expr);
			__temp405 = NULL;
			__temp406 = NULL;
			return (__temp406 = (__temp405 = g_list_nth_data (size, dim - 1), (__temp405 == NULL ? NULL : g_object_ref (__temp405))), (invocation_expr == NULL ? NULL : (invocation_expr = (g_object_unref (invocation_expr), NULL))), (size == NULL ? NULL : (size = (g_list_free (size), NULL))), __temp406);
			(invocation_expr == NULL ? NULL : (invocation_expr = (g_object_unref (invocation_expr), NULL)));
			(size == NULL ? NULL : (size = (g_list_free (size), NULL)));
		} else {
			if (vala_expression_get_symbol_reference (array_expr) != NULL) {
				if (VALA_IS_FORMAL_PARAMETER (vala_symbol_get_node (vala_expression_get_symbol_reference (array_expr)))) {
					ValaFormalParameter* __temp407;
					ValaFormalParameter* param;
					__temp407 = NULL;
					param = (__temp407 = VALA_FORMAL_PARAMETER (vala_symbol_get_node (vala_expression_get_symbol_reference (array_expr))), (__temp407 == NULL ? NULL : g_object_ref (__temp407)));
					if (!vala_formal_parameter_get_no_array_length (param)) {
						ValaCCodeIdentifier* length_expr;
						length_expr = vala_ccode_identifier_new (vala_code_generator_get_array_length_cname (self, vala_formal_parameter_get_name (param), dim));
						if (is_out) {
							ValaCCodeUnaryExpression* __temp408;
							__temp408 = NULL;
							return VALA_CCODE_EXPRESSION ((__temp408 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (length_expr)), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp408));
						} else {
							ValaCCodeIdentifier* __temp409;
							__temp409 = NULL;
							return VALA_CCODE_EXPRESSION ((__temp409 = length_expr, (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), __temp409));
						}
						(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
					}
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				} else {
					if (VALA_IS_VARIABLE_DECLARATOR (vala_symbol_get_node (vala_expression_get_symbol_reference (array_expr)))) {
						ValaVariableDeclarator* __temp410;
						ValaVariableDeclarator* decl;
						ValaCCodeIdentifier* length_expr;
						__temp410 = NULL;
						decl = (__temp410 = VALA_VARIABLE_DECLARATOR (vala_symbol_get_node (vala_expression_get_symbol_reference (array_expr))), (__temp410 == NULL ? NULL : g_object_ref (__temp410)));
						length_expr = vala_ccode_identifier_new (vala_code_generator_get_array_length_cname (self, vala_variable_declarator_get_name (decl), dim));
						if (is_out) {
							ValaCCodeUnaryExpression* __temp411;
							__temp411 = NULL;
							return VALA_CCODE_EXPRESSION ((__temp411 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (length_expr)), (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp411));
						} else {
							ValaCCodeIdentifier* __temp412;
							__temp412 = NULL;
							return VALA_CCODE_EXPRESSION ((__temp412 = length_expr, (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), __temp412));
						}
						(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
						(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
					} else {
						if (VALA_IS_FIELD (vala_symbol_get_node (vala_expression_get_symbol_reference (array_expr)))) {
							ValaField* __temp413;
							ValaField* field;
							__temp413 = NULL;
							field = (__temp413 = VALA_FIELD (vala_symbol_get_node (vala_expression_get_symbol_reference (array_expr))), (__temp413 == NULL ? NULL : g_object_ref (__temp413)));
							if (!vala_field_get_no_array_length (field)) {
								char* length_cname;
								ValaMemberAccess* __temp414;
								ValaMemberAccess* ma;
								ValaCCodeExpression* pub_inst;
								ValaDataType* base_type;
								ValaCCodeExpression* length_expr;
								length_cname = vala_code_generator_get_array_length_cname (self, vala_field_get_name (field), dim);
								__temp414 = NULL;
								ma = (__temp414 = VALA_MEMBER_ACCESS (array_expr), (__temp414 == NULL ? NULL : g_object_ref (__temp414)));
								pub_inst = NULL;
								base_type = NULL;
								length_expr = NULL;
								if (vala_member_access_get_inner (ma) == NULL) {
									ValaCCodeExpression* __temp415;
									__temp415 = NULL;
									pub_inst = (__temp415 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), __temp415);
									if (self->priv->current_type_symbol != NULL) {
										ValaDataType* __temp417;
										ValaDataType* __temp416;
										/* base type is available if this is a type method */
										__temp417 = NULL;
										__temp416 = NULL;
										base_type = (__temp417 = (__temp416 = VALA_DATA_TYPE (vala_symbol_get_node (self->priv->current_type_symbol)), (__temp416 == NULL ? NULL : g_object_ref (__temp416))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), __temp417);
									}
								} else {
									ValaCCodeExpression* __temp419;
									ValaCCodeExpression* __temp418;
									__temp419 = NULL;
									__temp418 = NULL;
									pub_inst = (__temp419 = (__temp418 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (__temp418 == NULL ? NULL : g_object_ref (__temp418))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), __temp419);
									if (vala_expression_get_static_type (vala_member_access_get_inner (ma)) != NULL) {
										ValaDataType* __temp421;
										ValaDataType* __temp420;
										__temp421 = NULL;
										__temp420 = NULL;
										base_type = (__temp421 = (__temp420 = vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))), (__temp420 == NULL ? NULL : g_object_ref (__temp420))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), __temp421);
									}
								}
								if (vala_field_get_instance (field)) {
									ValaCCodeExpression* typed_inst;
									ValaCCodeExpression* inst;
									typed_inst = NULL;
									if (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (field)))) != VALA_CODE_NODE (base_type)) {
										ValaCCodeExpression* __temp422;
										/* FIXME: use C cast if debugging disabled*/
										__temp422 = NULL;
										typed_inst = (__temp422 = VALA_CCODE_EXPRESSION (vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (field)))))), NULL))))), (typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL))), __temp422);
										vala_ccode_function_call_add_argument ((VALA_CCODE_FUNCTION_CALL (typed_inst)), pub_inst);
									} else {
										ValaCCodeExpression* __temp424;
										ValaCCodeExpression* __temp423;
										__temp424 = NULL;
										__temp423 = NULL;
										typed_inst = (__temp424 = (__temp423 = pub_inst, (__temp423 == NULL ? NULL : g_object_ref (__temp423))), (typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL))), __temp424);
									}
									inst = NULL;
									if (field->access == VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
										ValaCCodeExpression* __temp425;
										__temp425 = NULL;
										inst = (__temp425 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (typed_inst, "priv")), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), __temp425);
									} else {
										ValaCCodeExpression* __temp427;
										ValaCCodeExpression* __temp426;
										__temp427 = NULL;
										__temp426 = NULL;
										inst = (__temp427 = (__temp426 = typed_inst, (__temp426 == NULL ? NULL : g_object_ref (__temp426))), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), __temp427);
									}
									if (vala_data_type_is_reference_type ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (field)))))))) {
										ValaCCodeExpression* __temp428;
										__temp428 = NULL;
										length_expr = (__temp428 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (inst, length_cname)), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp428);
									} else {
										ValaCCodeExpression* __temp429;
										__temp429 = NULL;
										length_expr = (__temp429 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new (inst, length_cname, FALSE)), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp429);
									}
									(typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL)));
									(inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL)));
								} else {
									ValaCCodeExpression* __temp430;
									__temp430 = NULL;
									length_expr = (__temp430 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (length_cname)), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp430);
								}
								if (is_out) {
									ValaCCodeUnaryExpression* __temp431;
									__temp431 = NULL;
									return VALA_CCODE_EXPRESSION ((__temp431 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, length_expr), (length_cname = (g_free (length_cname), NULL)), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), (length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL))), __temp431));
								} else {
									ValaCCodeExpression* __temp432;
									__temp432 = NULL;
									return (__temp432 = length_expr, (length_cname = (g_free (length_cname), NULL)), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), __temp432);
								}
								(length_cname = (g_free (length_cname), NULL));
								(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
								(pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL)));
								(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
								(length_expr == NULL ? NULL : (length_expr = (g_object_unref (length_expr), NULL)));
							}
							(field == NULL ? NULL : (field = (g_object_unref (field), NULL)));
						}
					}
				}
			}
		}
	}
	if (!is_out) {
		return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("-1"));
	} else {
		return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
	}
}


/* allow arrays with unknown length even for value types
 * as else it may be impossible to bind some libraries
 * users of affected libraries should explicitly set
 * the array length as early as possible
 * by setting the virtual length field of the array
 */
static void vala_code_generator_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr)
{
	ValaCodeGenerator * self;
	GList* indices;
	gint rank;
	ValaCCodeExpression* __temp435;
	ValaCCodeExpression* ccontainer;
	ValaCCodeExpression* __temp436;
	ValaCCodeExpression* cindex;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ELEMENT_ACCESS (expr));
	indices = vala_element_access_get_indices (expr);
	rank = g_list_length (indices);
	__temp435 = NULL;
	ccontainer = (__temp435 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_element_access_get_container (expr)))), (__temp435 == NULL ? NULL : g_object_ref (__temp435)));
	__temp436 = NULL;
	cindex = (__temp436 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (g_list_nth_data (indices, 0)))), (__temp436 == NULL ? NULL : g_object_ref (__temp436)));
	if (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_element_access_get_container (expr))) == vala_type_reference_get_data_type (self->priv->string_type)) {
		ValaCCodeFunctionCall* coffsetcall;
		ValaCCodeFunctionCall* ccall;
		/* access to unichar in a string*/
		coffsetcall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_utf8_offset_to_pointer")));
		vala_ccode_function_call_add_argument (coffsetcall, ccontainer);
		vala_ccode_function_call_add_argument (coffsetcall, cindex);
		ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_utf8_get_char")));
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (coffsetcall));
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(coffsetcall == NULL ? NULL : (coffsetcall = (g_object_unref (coffsetcall), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	} else {
		ValaCCodeElementAccess* __temp438;
		{
			gint i;
			i = 0;
			for (i = 1; i < rank; i++) {
				ValaCCodeBinaryExpression* cmul;
				ValaCCodeExpression* __temp437;
				/* access to element in an array*/
				cmul = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, cindex, vala_code_generator_get_array_length_cexpression (self, vala_element_access_get_container (expr), i + 1));
				__temp437 = NULL;
				cindex = (__temp437 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (cmul), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (g_list_nth_data (indices, i)))))), (cindex == NULL ? NULL : (cindex = (g_object_unref (cindex), NULL))), __temp437);
				(cmul == NULL ? NULL : (cmul = (g_object_unref (cmul), NULL)));
			}
		}
		__temp438 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp438 = vala_ccode_element_access_new (ccontainer, cindex)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(__temp438 == NULL ? NULL : (__temp438 = (g_object_unref (__temp438), NULL)));
	}
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(indices == NULL ? NULL : (indices = (g_list_free (indices), NULL)));
	(ccontainer == NULL ? NULL : (ccontainer = (g_object_unref (ccontainer), NULL)));
	(cindex == NULL ? NULL : (cindex = (g_object_unref (cindex), NULL)));
}


static void vala_code_generator_real_visit_base_access (ValaCodeVisitor* base, ValaBaseAccess* expr)
{
	ValaCodeGenerator * self;
	ValaInstanceCast* __temp439;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_BASE_ACCESS (expr));
	__temp439 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp439 = vala_instance_cast_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), vala_type_reference_get_data_type (vala_expression_get_static_type (VALA_EXPRESSION (expr))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp439 == NULL ? NULL : (__temp439 = (g_object_unref (__temp439), NULL)));
}


static void vala_code_generator_real_visit_postfix_expression (ValaCodeVisitor* base, ValaPostfixExpression* expr)
{
	ValaCodeGenerator * self;
	ValaMemberAccess* ma;
	ValaCCodeUnaryOperator op;
	ValaCCodeUnaryExpression* __temp444;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_POSTFIX_EXPRESSION (expr));
	ma = vala_code_generator_find_property_access (self, vala_postfix_expression_get_inner (expr));
	if (ma != NULL) {
		ValaProperty* __temp440;
		ValaProperty* prop;
		ValaCCodeCommaExpression* ccomma;
		ValaVariableDeclarator* temp_decl;
		ValaVariableDeclarator* __temp441;
		ValaCCodeAssignment* __temp442;
		ValaCCodeBinaryOperator op;
		ValaCCodeBinaryExpression* cexpr;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* __temp443;
		/* property postfix expression*/
		__temp440 = NULL;
		prop = (__temp440 = VALA_PROPERTY (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (ma)))), (__temp440 == NULL ? NULL : g_object_ref (__temp440)));
		ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
		/* assign current value to temp variable*/
		temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_property_get_type_reference (prop), TRUE);
		__temp441 = NULL;
		self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp441 = temp_decl, (__temp441 == NULL ? NULL : g_object_ref (__temp441))));
		__temp442 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp442 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_postfix_expression_get_inner (expr)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(__temp442 == NULL ? NULL : (__temp442 = (g_object_unref (__temp442), NULL)));
		/* increment/decrement property*/
		op = (vala_postfix_expression_get_increment (expr) ? VALA_CCODE_BINARY_OPERATOR_PLUS : VALA_CCODE_BINARY_OPERATOR_MINUS);
		cexpr = vala_ccode_binary_expression_new (op, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl))), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("1")));
		ccall = vala_code_generator_get_property_set_call (self, prop, ma, VALA_CCODE_EXPRESSION (cexpr));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
		/* return previous value*/
		__temp443 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp443 = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl)))));
		(__temp443 == NULL ? NULL : (__temp443 = (g_object_unref (__temp443), NULL)));
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
		return;
		(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	}
	op = (vala_postfix_expression_get_increment (expr) ? VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT : VALA_CCODE_UNARY_OPERATOR_POSTFIX_DECREMENT);
	__temp444 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp444 = vala_ccode_unary_expression_new (op, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_postfix_expression_get_inner (expr)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp444 == NULL ? NULL : (__temp444 = (g_object_unref (__temp444), NULL)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
}


static ValaMemberAccess* vala_code_generator_find_property_access (ValaCodeGenerator* self, ValaExpression* expr)
{
	ValaMemberAccess* __temp448;
	ValaMemberAccess* ma;
	gpointer __temp450;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (expr), NULL);
	if (VALA_IS_PARENTHESIZED_EXPRESSION (expr)) {
		ValaParenthesizedExpression* __temp445;
		ValaParenthesizedExpression* pe;
		ValaMemberAccess* __temp446;
		__temp445 = NULL;
		pe = (__temp445 = VALA_PARENTHESIZED_EXPRESSION (expr), (__temp445 == NULL ? NULL : g_object_ref (__temp445)));
		__temp446 = NULL;
		return (__temp446 = vala_code_generator_find_property_access (self, vala_parenthesized_expression_get_inner (pe)), (pe == NULL ? NULL : (pe = (g_object_unref (pe), NULL))), __temp446);
		(pe == NULL ? NULL : (pe = (g_object_unref (pe), NULL)));
	}
	if (!(VALA_IS_MEMBER_ACCESS (expr))) {
		return VALA_MEMBER_ACCESS (NULL);
	}
	__temp448 = NULL;
	ma = (__temp448 = VALA_MEMBER_ACCESS (expr), (__temp448 == NULL ? NULL : g_object_ref (__temp448)));
	if (VALA_IS_PROPERTY (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (ma))))) {
		return ma;
	}
	return VALA_MEMBER_ACCESS ((__temp450 = NULL, (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), __temp450));
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
}


static ValaCCodeExpression* vala_code_generator_get_ref_expression (ValaCodeGenerator* self, ValaExpression* expr)
{
	char* ref_function;
	ValaCCodeFunctionCall* ccall;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_EXPRESSION (expr), NULL);
	/* (temp = expr, temp == NULL ? NULL : ref (temp))
	 *
	 * can be simplified to
	 * ref (expr)
	 * if static type of expr is non-null
	 */
	if (vala_type_reference_get_data_type (vala_expression_get_static_type (expr)) == NULL && vala_type_reference_get_type_parameter (vala_expression_get_static_type (expr)) != NULL) {
		ValaCCodeExpression* __temp451;
		vala_report_warning (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "Missing generics support for memory management");
		__temp451 = NULL;
		return (__temp451 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), (__temp451 == NULL ? NULL : g_object_ref (__temp451)));
	}
	ref_function = NULL;
	if (vala_data_type_is_reference_counting (vala_type_reference_get_data_type (vala_expression_get_static_type (expr)))) {
		char* __temp453;
		__temp453 = NULL;
		ref_function = (__temp453 = vala_data_type_get_ref_function (vala_type_reference_get_data_type (vala_expression_get_static_type (expr))), (ref_function = (g_free (ref_function), NULL)), __temp453);
	} else {
		char* __temp455;
		if (vala_type_reference_get_data_type (vala_expression_get_static_type (expr)) != vala_type_reference_get_data_type (self->priv->string_type)) {
			char* __temp454;
			/* duplicating non-reference counted structs may cause side-effects (and performance issues)*/
			__temp454 = NULL;
			vala_report_warning (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), (__temp454 = g_strdup_printf ("duplicating %s instance, use weak variable or explicitly invoke copy method", vala_data_type_get_name (vala_type_reference_get_data_type (vala_expression_get_static_type (expr))))));
			(__temp454 = (g_free (__temp454), NULL));
		}
		__temp455 = NULL;
		ref_function = (__temp455 = vala_data_type_get_dup_function (vala_type_reference_get_data_type (vala_expression_get_static_type (expr))), (ref_function = (g_free (ref_function), NULL)), __temp455);
	}
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (ref_function)));
	if (vala_type_reference_get_non_null (vala_expression_get_static_type (expr))) {
		ValaCCodeFunctionCall* __temp456;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))));
		__temp456 = NULL;
		return VALA_CCODE_EXPRESSION ((__temp456 = ccall, (ref_function = (g_free (ref_function), NULL)), __temp456));
	} else {
		ValaVariableDeclarator* decl;
		ValaVariableDeclarator* __temp457;
		ValaCCodeIdentifier* ctemp;
		ValaCCodeBinaryExpression* cisnull;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* __temp458;
		ValaCCodeConditionalExpression* __temp462;
		ValaCCodeCommaExpression* __temp463;
		decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (expr), FALSE);
		__temp457 = NULL;
		self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp457 = decl, (__temp457 == NULL ? NULL : g_object_ref (__temp457))));
		ctemp = vala_ccode_identifier_new (vala_variable_declarator_get_name (decl));
		cisnull = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ctemp));
		ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
		__temp458 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp458 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (ctemp), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(__temp458 == NULL ? NULL : (__temp458 = (g_object_unref (__temp458), NULL)));
		if (g_utf8_collate (ref_function, "g_list_copy") == 0) {
			gboolean is_ref;
			gboolean is_class;
			gboolean is_interface;
			is_ref = FALSE;
			is_class = FALSE;
			is_interface = FALSE;
			{
				GList* __temp459;
				GList* type_arg_it;
				__temp459 = NULL;
				__temp459 = vala_type_reference_get_type_arguments (vala_expression_get_static_type (expr));
				for (type_arg_it = __temp459; type_arg_it != NULL; type_arg_it = type_arg_it->next) {
					ValaTypeReference* type_arg;
					type_arg = type_arg_it->data;
					{
						is_ref = is_ref | (vala_type_reference_get_takes_ownership (type_arg));
						is_class = is_class | (VALA_IS_CLASS (vala_type_reference_get_data_type (type_arg)));
						is_interface = is_interface | (VALA_IS_INTERFACE (vala_type_reference_get_data_type (type_arg)));
					}
				}
				(__temp459 == NULL ? NULL : (__temp459 = (g_list_free (__temp459), NULL)));
			}
			if (is_ref && (is_class || is_interface)) {
				ValaCCodeFunctionCall* crefcall;
				ValaCCodeIdentifier* __temp460;
				ValaCCodeConstant* __temp461;
				crefcall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_list_foreach")));
				vala_ccode_function_call_add_argument (crefcall, VALA_CCODE_EXPRESSION (ctemp));
				__temp460 = NULL;
				vala_ccode_function_call_add_argument (crefcall, VALA_CCODE_EXPRESSION ((__temp460 = vala_ccode_identifier_new ("(GFunc) g_object_ref"))));
				(__temp460 == NULL ? NULL : (__temp460 = (g_object_unref (__temp460), NULL)));
				__temp461 = NULL;
				vala_ccode_function_call_add_argument (crefcall, VALA_CCODE_EXPRESSION ((__temp461 = vala_ccode_constant_new ("NULL"))));
				(__temp461 == NULL ? NULL : (__temp461 = (g_object_unref (__temp461), NULL)));
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (crefcall));
				(crefcall == NULL ? NULL : (crefcall = (g_object_unref (crefcall), NULL)));
			}
		}
		__temp462 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp462 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (cisnull), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")), VALA_CCODE_EXPRESSION (ccall)))));
		(__temp462 == NULL ? NULL : (__temp462 = (g_object_unref (__temp462), NULL)));
		__temp463 = NULL;
		return VALA_CCODE_EXPRESSION ((__temp463 = ccomma, (decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL))), (ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL))), (cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL))), __temp463));
		(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
		(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
		(cisnull == NULL ? NULL : (cisnull = (g_object_unref (cisnull), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	}
	(ref_function = (g_free (ref_function), NULL));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
}


static void vala_code_generator_visit_expression (ValaCodeGenerator* self, ValaExpression* expr)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_EXPRESSION (expr));
	if (vala_expression_get_static_type (expr) != NULL && vala_type_reference_get_transfers_ownership (vala_expression_get_static_type (expr)) && vala_type_reference_get_floating_reference (vala_expression_get_static_type (expr))) {
		ValaCCodeFunctionCall* csink;
		/* constructor of GInitiallyUnowned subtype
		 * returns floating reference, sink it
		 */
		csink = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_ref_sink")));
		vala_ccode_function_call_add_argument (csink, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))));
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (csink)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(csink == NULL ? NULL : (csink = (g_object_unref (csink), NULL)));
	}
	if (vala_expression_get_ref_leaked (expr)) {
		ValaVariableDeclarator* decl;
		ValaVariableDeclarator* __temp464;
		ValaVariableDeclarator* __temp465;
		ValaCCodeParenthesizedExpression* __temp466;
		decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (expr), TRUE);
		__temp464 = NULL;
		self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp464 = decl, (__temp464 == NULL ? NULL : g_object_ref (__temp464))));
		__temp465 = NULL;
		self->priv->temp_ref_vars = g_list_prepend (self->priv->temp_ref_vars, (__temp465 = decl, (__temp465 == NULL ? NULL : g_object_ref (__temp465))));
		__temp466 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp466 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_code_generator_get_variable_cname (self, vala_variable_declarator_get_name (decl)))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(__temp466 == NULL ? NULL : (__temp466 = (g_object_unref (__temp466), NULL)));
		(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
	} else {
		if (vala_expression_get_ref_missing (expr)) {
			ValaCCodeExpression* __temp467;
			__temp467 = NULL;
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp467 = vala_code_generator_get_ref_expression (self, expr)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
			(__temp467 == NULL ? NULL : (__temp467 = (g_object_unref (__temp467), NULL)));
		}
	}
}


static void vala_code_generator_real_visit_end_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_OBJECT_CREATION_EXPRESSION (expr));
	if (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)) == NULL) {
		/* no creation method*/
		if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
			ValaCCodeFunctionCall* ccall;
			ValaCCodeConstant* __temp468;
			ValaCCodeConstant* __temp469;
			ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_new")));
			__temp468 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp468 = vala_ccode_constant_new (vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)))))));
			(__temp468 == NULL ? NULL : (__temp468 = (g_object_unref (__temp468), NULL)));
			__temp469 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp469 = vala_ccode_constant_new ("NULL"))));
			(__temp469 == NULL ? NULL : (__temp469 = (g_object_unref (__temp469), NULL)));
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		} else {
			if (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)) == self->priv->list_type || vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)) == self->priv->slist_type) {
				ValaCCodeConstant* __temp470;
				/* NULL is an empty list*/
				__temp470 = NULL;
				(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp470 = vala_ccode_constant_new ("NULL")))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
				(__temp470 == NULL ? NULL : (__temp470 = (g_object_unref (__temp470), NULL)));
			} else {
				ValaCCodeFunctionCall* ccall;
				ValaCCodeConstant* __temp471;
				ValaCCodeConstant* __temp472;
				ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_new0")));
				__temp471 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp471 = vala_ccode_constant_new (vala_data_type_get_cname (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)), FALSE)))));
				(__temp471 == NULL ? NULL : (__temp471 = (g_object_unref (__temp471), NULL)));
				__temp472 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp472 = vala_ccode_constant_new ("1"))));
				(__temp472 == NULL ? NULL : (__temp472 = (g_object_unref (__temp472), NULL)));
				(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
				(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			}
		}
	} else {
		if (VALA_IS_METHOD (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
			ValaMethod* __temp473;
			ValaMethod* m;
			GList* params;
			ValaCCodeFunctionCall* ccall;
			gboolean ellipsis;
			gint i;
			GList* params_it;
			/* use creation method*/
			__temp473 = NULL;
			m = (__temp473 = VALA_METHOD (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp473 == NULL ? NULL : g_object_ref (__temp473)));
			params = vala_invokable_get_parameters (VALA_INVOKABLE (m));
			ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_method_get_cname (m))));
			if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_object_creation_expression_get_type_reference (expr)))) {
				{
					GList* __temp476;
					GList* type_arg_it;
					__temp476 = NULL;
					__temp476 = vala_type_reference_get_type_arguments (vala_object_creation_expression_get_type_reference (expr));
					for (type_arg_it = __temp476; type_arg_it != NULL; type_arg_it = type_arg_it->next) {
						ValaTypeReference* type_arg;
						type_arg = type_arg_it->data;
						{
							if (vala_type_reference_get_takes_ownership (type_arg)) {
								ValaCCodeExpression* __temp474;
								__temp474 = NULL;
								vala_ccode_function_call_add_argument (ccall, (__temp474 = vala_code_generator_get_destroy_func_expression (self, type_arg)));
								(__temp474 == NULL ? NULL : (__temp474 = (g_object_unref (__temp474), NULL)));
							} else {
								ValaCCodeConstant* __temp475;
								__temp475 = NULL;
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp475 = vala_ccode_constant_new ("NULL"))));
								(__temp475 == NULL ? NULL : (__temp475 = (g_object_unref (__temp475), NULL)));
							}
						}
					}
					(__temp476 == NULL ? NULL : (__temp476 = (g_list_free (__temp476), NULL)));
				}
			}
			ellipsis = FALSE;
			i = 1;
			params_it = params;
			{
				GList* __temp481;
				GList* arg_it;
				__temp481 = NULL;
				__temp481 = vala_object_creation_expression_get_argument_list (expr);
				for (arg_it = __temp481; arg_it != NULL; arg_it = arg_it->next) {
					ValaExpression* arg;
					arg = arg_it->data;
					{
						ValaCCodeExpression* __temp477;
						ValaCCodeExpression* cexpr;
						/* explicitly use strong reference as ccall gets
						 * unrefed at end of inner block
						 */
						__temp477 = NULL;
						cexpr = (__temp477 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (arg))), (__temp477 == NULL ? NULL : g_object_ref (__temp477)));
						if (params_it != NULL) {
							ValaFormalParameter* __temp478;
							ValaFormalParameter* param;
							__temp478 = NULL;
							param = (__temp478 = VALA_FORMAL_PARAMETER (params_it->data), (__temp478 == NULL ? NULL : g_object_ref (__temp478)));
							ellipsis = vala_formal_parameter_get_ellipsis (param);
							if (!vala_formal_parameter_get_ellipsis (param) && vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))) && vala_type_reference_get_data_type (vala_expression_get_static_type (arg)) != NULL && vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)) != vala_type_reference_get_data_type (vala_expression_get_static_type (arg))) {
								ValaCCodeFunctionCall* ccall;
								ValaCCodeExpression* __temp480;
								ValaCCodeFunctionCall* __temp479;
								/* FIXME: use C cast if debugging disabled*/
								ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)), NULL))));
								vala_ccode_function_call_add_argument (ccall, cexpr);
								__temp480 = NULL;
								__temp479 = NULL;
								cexpr = (__temp480 = VALA_CCODE_EXPRESSION ((__temp479 = ccall, (__temp479 == NULL ? NULL : g_object_ref (__temp479)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp480);
								(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							}
							(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
						}
						vala_ccode_function_call_add_argument (ccall, cexpr);
						i++;
						if (params_it != NULL) {
							params_it = params_it->next;
						}
						(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
					}
				}
				(__temp481 == NULL ? NULL : (__temp481 = (g_list_free (__temp481), NULL)));
			}
			while (params_it != NULL) {
				ValaFormalParameter* __temp482;
				ValaFormalParameter* param;
				__temp482 = NULL;
				param = (__temp482 = VALA_FORMAL_PARAMETER (params_it->data), (__temp482 == NULL ? NULL : g_object_ref (__temp482)));
				if (vala_formal_parameter_get_ellipsis (param)) {
					ellipsis = TRUE;
					break;
				}
				if (vala_formal_parameter_get_default_expression (param) == NULL) {
					char* __temp483;
					__temp483 = NULL;
					vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), (__temp483 = g_strdup_printf ("no default expression for argument %d", i)));
					(__temp483 = (g_free (__temp483), NULL));
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
					(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
					return;
				}
				/* evaluate default expression here as the code
				 * generator might not have visited the formal
				 * parameter yet */
				vala_code_node_accept (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)), VALA_CODE_VISITOR (self));
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)))));
				i++;
				params_it = params_it->next;
				(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			}
			if (vala_expression_get_can_fail (VALA_EXPRESSION (expr))) {
				ValaCCodeUnaryExpression* __temp484;
				/* method can fail*/
				self->priv->current_method_inner_error = TRUE;
				__temp484 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp484 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("inner_error"))))));
				(__temp484 == NULL ? NULL : (__temp484 = (g_object_unref (__temp484), NULL)));
			}
			if (ellipsis) {
				ValaCCodeConstant* __temp485;
				/* ensure variable argument list ends with NULL*/
				__temp485 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp485 = vala_ccode_constant_new ("NULL"))));
				(__temp485 == NULL ? NULL : (__temp485 = (g_object_unref (__temp485), NULL)));
			}
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		} else {
			if (VALA_IS_ENUM_VALUE (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
				ValaEnumValue* __temp486;
				ValaEnumValue* ev;
				ValaEnum* __temp487;
				ValaEnum* en;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeIdentifier* __temp488;
				ValaCCodeIdentifier* __temp489;
				ValaCCodeIdentifier* __temp490;
				/* error code*/
				__temp486 = NULL;
				ev = (__temp486 = VALA_ENUM_VALUE (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp486 == NULL ? NULL : g_object_ref (__temp486)));
				__temp487 = NULL;
				en = (__temp487 = VALA_ENUM (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (ev))))), (__temp487 == NULL ? NULL : g_object_ref (__temp487)));
				ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_set_error")));
				__temp488 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp488 = vala_ccode_identifier_new ("error"))));
				(__temp488 == NULL ? NULL : (__temp488 = (g_object_unref (__temp488), NULL)));
				__temp489 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp489 = vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (en), NULL)))));
				(__temp489 == NULL ? NULL : (__temp489 = (g_object_unref (__temp489), NULL)));
				__temp490 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp490 = vala_ccode_identifier_new (vala_enum_value_get_cname (ev)))));
				(__temp490 == NULL ? NULL : (__temp490 = (g_object_unref (__temp490), NULL)));
				{
					GList* __temp491;
					GList* arg_it;
					__temp491 = NULL;
					__temp491 = vala_object_creation_expression_get_argument_list (expr);
					for (arg_it = __temp491; arg_it != NULL; arg_it = arg_it->next) {
						ValaExpression* arg;
						arg = arg_it->data;
						{
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (arg))));
						}
					}
					(__temp491 == NULL ? NULL : (__temp491 = (g_list_free (__temp491), NULL)));
				}
				(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
				(ev == NULL ? NULL : (ev = (g_object_unref (ev), NULL)));
				(en == NULL ? NULL : (en = (g_object_unref (en), NULL)));
				(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			} else {
				g_assert (FALSE);
			}
		}
	}
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_code_generator_real_visit_sizeof_expression (ValaCodeVisitor* base, ValaSizeofExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeFunctionCall* csizeof;
	ValaCCodeIdentifier* __temp492;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_SIZEOF_EXPRESSION (expr));
	csizeof = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("sizeof")));
	__temp492 = NULL;
	vala_ccode_function_call_add_argument (csizeof, VALA_CCODE_EXPRESSION ((__temp492 = vala_ccode_identifier_new (vala_data_type_get_cname (vala_type_reference_get_data_type (vala_sizeof_expression_get_type_reference (expr)), FALSE)))));
	(__temp492 == NULL ? NULL : (__temp492 = (g_object_unref (__temp492), NULL)));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (csizeof)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(csizeof == NULL ? NULL : (csizeof = (g_object_unref (csizeof), NULL)));
}


static void vala_code_generator_real_visit_typeof_expression (ValaCodeVisitor* base, ValaTypeofExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeIdentifier* __temp493;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_TYPEOF_EXPRESSION (expr));
	__temp493 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp493 = vala_ccode_identifier_new (vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_typeof_expression_get_type_reference (expr))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp493 == NULL ? NULL : (__temp493 = (g_object_unref (__temp493), NULL)));
}


static void vala_code_generator_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeUnaryOperator op;
	ValaCCodeUnaryExpression* __temp494;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_UNARY_EXPRESSION (expr));
	if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_PLUS) {
		op = VALA_CCODE_UNARY_OPERATOR_PLUS;
	} else {
		if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_MINUS) {
			op = VALA_CCODE_UNARY_OPERATOR_MINUS;
		} else {
			if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_LOGICAL_NEGATION) {
				op = VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION;
			} else {
				if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT) {
					op = VALA_CCODE_UNARY_OPERATOR_BITWISE_COMPLEMENT;
				} else {
					if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_INCREMENT) {
						op = VALA_CCODE_UNARY_OPERATOR_PREFIX_INCREMENT;
					} else {
						if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_DECREMENT) {
							op = VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT;
						} else {
							if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_REF) {
								op = VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF;
							} else {
								if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_OUT) {
									op = VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF;
								}
							}
						}
					}
				}
			}
		}
	}
	__temp494 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp494 = vala_ccode_unary_expression_new (op, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_unary_expression_get_inner (expr)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp494 == NULL ? NULL : (__temp494 = (g_object_unref (__temp494), NULL)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_code_generator_real_visit_cast_expression (ValaCodeVisitor* base, ValaCastExpression* expr)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CAST_EXPRESSION (expr));
	if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_cast_expression_get_type_reference (expr))) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (vala_cast_expression_get_type_reference (expr)))) {
		ValaInstanceCast* __temp495;
		/* GObject cast*/
		__temp495 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp495 = vala_instance_cast_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_cast_expression_get_inner (expr)))), vala_type_reference_get_data_type (vala_cast_expression_get_type_reference (expr)))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(__temp495 == NULL ? NULL : (__temp495 = (g_object_unref (__temp495), NULL)));
	} else {
		ValaCCodeCastExpression* __temp496;
		__temp496 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp496 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_cast_expression_get_inner (expr)))), vala_type_reference_get_cname (vala_cast_expression_get_type_reference (expr), FALSE, FALSE))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(__temp496 == NULL ? NULL : (__temp496 = (g_object_unref (__temp496), NULL)));
	}
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
}


static void vala_code_generator_real_visit_pointer_indirection (ValaCodeVisitor* base, ValaPointerIndirection* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeUnaryExpression* __temp497;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_POINTER_INDIRECTION (expr));
	__temp497 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp497 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_pointer_indirection_get_inner (expr)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp497 == NULL ? NULL : (__temp497 = (g_object_unref (__temp497), NULL)));
}


static void vala_code_generator_real_visit_addressof_expression (ValaCodeVisitor* base, ValaAddressofExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeUnaryExpression* __temp498;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ADDRESSOF_EXPRESSION (expr));
	__temp498 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp498 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_addressof_expression_get_inner (expr)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp498 == NULL ? NULL : (__temp498 = (g_object_unref (__temp498), NULL)));
}


static void vala_code_generator_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeCommaExpression* ccomma;
	ValaVariableDeclarator* temp_decl;
	ValaVariableDeclarator* __temp499;
	ValaCCodeIdentifier* cvar;
	ValaCCodeAssignment* __temp500;
	ValaCCodeAssignment* __temp501;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_REFERENCE_TRANSFER_EXPRESSION (expr));
	/* (tmp = var, var = null, tmp) */
	ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
	temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (VALA_EXPRESSION (expr)), TRUE);
	__temp499 = NULL;
	self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp499 = temp_decl, (__temp499 == NULL ? NULL : g_object_ref (__temp499))));
	cvar = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl));
	__temp500 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp500 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cvar), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_reference_transfer_expression_get_inner (expr)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(__temp500 == NULL ? NULL : (__temp500 = (g_object_unref (__temp500), NULL)));
	__temp501 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp501 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_reference_transfer_expression_get_inner (expr)))), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
	(__temp501 == NULL ? NULL : (__temp501 = (g_object_unref (__temp501), NULL)));
	vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvar));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
	(cvar == NULL ? NULL : (cvar = (g_object_unref (cvar), NULL)));
}


static void vala_code_generator_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeBinaryOperator op;
	ValaCCodeExpression* __temp502;
	ValaCCodeExpression* cleft;
	ValaCCodeExpression* __temp503;
	ValaCCodeExpression* cright;
	ValaCCodeBinaryExpression* __temp508;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_BINARY_EXPRESSION (expr));
	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_PLUS) {
		op = VALA_CCODE_BINARY_OPERATOR_PLUS;
	} else {
		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MINUS) {
			op = VALA_CCODE_BINARY_OPERATOR_MINUS;
		} else {
			if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MUL) {
				op = VALA_CCODE_BINARY_OPERATOR_MUL;
			} else {
				if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_DIV) {
					op = VALA_CCODE_BINARY_OPERATOR_DIV;
				} else {
					if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MOD) {
						op = VALA_CCODE_BINARY_OPERATOR_MOD;
					} else {
						if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_SHIFT_LEFT) {
							op = VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT;
						} else {
							if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_SHIFT_RIGHT) {
								op = VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT;
							} else {
								if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN) {
									op = VALA_CCODE_BINARY_OPERATOR_LESS_THAN;
								} else {
									if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN) {
										op = VALA_CCODE_BINARY_OPERATOR_GREATER_THAN;
									} else {
										if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL) {
											op = VALA_CCODE_BINARY_OPERATOR_LESS_THAN_OR_EQUAL;
										} else {
											if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL) {
												op = VALA_CCODE_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL;
											} else {
												if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY) {
													op = VALA_CCODE_BINARY_OPERATOR_EQUALITY;
												} else {
													if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY) {
														op = VALA_CCODE_BINARY_OPERATOR_INEQUALITY;
													} else {
														if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_AND) {
															op = VALA_CCODE_BINARY_OPERATOR_BITWISE_AND;
														} else {
															if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_OR) {
																op = VALA_CCODE_BINARY_OPERATOR_BITWISE_OR;
															} else {
																if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_XOR) {
																	op = VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR;
																} else {
																	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_AND) {
																		op = VALA_CCODE_BINARY_OPERATOR_AND;
																	} else {
																		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_OR) {
																			op = VALA_CCODE_BINARY_OPERATOR_OR;
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	__temp502 = NULL;
	cleft = (__temp502 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_binary_expression_get_left (expr)))), (__temp502 == NULL ? NULL : g_object_ref (__temp502)));
	__temp503 = NULL;
	cright = (__temp503 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_binary_expression_get_right (expr)))), (__temp503 == NULL ? NULL : g_object_ref (__temp503)));
	if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY) {
		if (vala_expression_get_static_type (vala_binary_expression_get_left (expr)) != NULL && vala_expression_get_static_type (vala_binary_expression_get_right (expr)) != NULL && VALA_IS_CLASS (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_left (expr)))) && VALA_IS_CLASS (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_right (expr))))) {
			ValaClass* __temp504;
			ValaClass* left_cl;
			ValaClass* __temp505;
			ValaClass* right_cl;
			__temp504 = NULL;
			left_cl = (__temp504 = VALA_CLASS (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_left (expr)))), (__temp504 == NULL ? NULL : g_object_ref (__temp504)));
			__temp505 = NULL;
			right_cl = (__temp505 = VALA_CLASS (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_binary_expression_get_right (expr)))), (__temp505 == NULL ? NULL : g_object_ref (__temp505)));
			if (left_cl != right_cl) {
				if (vala_data_type_is_subtype_of (VALA_DATA_TYPE (left_cl), VALA_DATA_TYPE (right_cl))) {
					ValaCCodeExpression* __temp506;
					__temp506 = NULL;
					cleft = (__temp506 = VALA_CCODE_EXPRESSION (vala_instance_cast_new (cleft, VALA_DATA_TYPE (right_cl))), (cleft == NULL ? NULL : (cleft = (g_object_unref (cleft), NULL))), __temp506);
				} else {
					if (vala_data_type_is_subtype_of (VALA_DATA_TYPE (right_cl), VALA_DATA_TYPE (left_cl))) {
						ValaCCodeExpression* __temp507;
						__temp507 = NULL;
						cright = (__temp507 = VALA_CCODE_EXPRESSION (vala_instance_cast_new (cright, VALA_DATA_TYPE (left_cl))), (cright == NULL ? NULL : (cright = (g_object_unref (cright), NULL))), __temp507);
					}
				}
			}
			(left_cl == NULL ? NULL : (left_cl = (g_object_unref (left_cl), NULL)));
			(right_cl == NULL ? NULL : (right_cl = (g_object_unref (right_cl), NULL)));
		}
	}
	__temp508 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp508 = vala_ccode_binary_expression_new (op, cleft, cright)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp508 == NULL ? NULL : (__temp508 = (g_object_unref (__temp508), NULL)));
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(cleft == NULL ? NULL : (cleft = (g_object_unref (cleft), NULL)));
	(cright == NULL ? NULL : (cright = (g_object_unref (cright), NULL)));
}


static void vala_code_generator_real_visit_type_check (ValaCodeVisitor* base, ValaTypeCheck* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeFunctionCall* ccheck;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_TYPE_CHECK (expr));
	ccheck = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_type_check_get_type_reference (expr)), "IS_"))));
	vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_type_check_get_expression (expr)))));
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccheck)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL)));
}


static void vala_code_generator_real_visit_conditional_expression (ValaCodeVisitor* base, ValaConditionalExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeConditionalExpression* __temp509;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CONDITIONAL_EXPRESSION (expr));
	__temp509 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp509 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_conditional_expression_get_condition (expr)))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_conditional_expression_get_true_expression (expr)))), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_conditional_expression_get_false_expression (expr)))))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
	(__temp509 == NULL ? NULL : (__temp509 = (g_object_unref (__temp509), NULL)));
}


static void vala_code_generator_real_visit_end_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l)
{
	ValaCodeGenerator * self;
	ValaCCodeIdentifier* __temp510;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_LAMBDA_EXPRESSION (l));
	__temp510 = NULL;
	(vala_code_node_set_ccodenode (VALA_CODE_NODE (l), VALA_CCODE_NODE ((__temp510 = vala_ccode_identifier_new (vala_method_get_cname (vala_lambda_expression_get_method (l)))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (l)));
	(__temp510 == NULL ? NULL : (__temp510 = (g_object_unref (__temp510), NULL)));
}


static void vala_code_generator_real_visit_end_assignment (ValaCodeVisitor* base, ValaAssignment* a)
{
	ValaCodeGenerator * self;
	ValaMemberAccess* ma;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_ASSIGNMENT (a));
	ma = NULL;
	if (VALA_IS_MEMBER_ACCESS (vala_assignment_get_left (a))) {
		ValaMemberAccess* __temp512;
		ValaMemberAccess* __temp511;
		__temp512 = NULL;
		__temp511 = NULL;
		ma = (__temp512 = (__temp511 = VALA_MEMBER_ACCESS (vala_assignment_get_left (a)), (__temp511 == NULL ? NULL : g_object_ref (__temp511))), (ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL))), __temp512);
	}
	if (vala_expression_get_symbol_reference (vala_assignment_get_left (a)) != NULL && VALA_IS_PROPERTY (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_assignment_get_left (a))))) {
		ValaProperty* __temp513;
		ValaProperty* prop;
		__temp513 = NULL;
		prop = (__temp513 = VALA_PROPERTY (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_assignment_get_left (a)))), (__temp513 == NULL ? NULL : g_object_ref (__temp513)));
		if (self->priv->current_class != NULL && vala_member_access_get_inner (ma) == NULL && self->priv->in_creation_method) {
			ValaCCodeIdentifier* cpointer;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeMemberAccess* cnamemember;
			ValaCCodeAssignment* cnameassign;
			ValaCCodeUnaryExpression* gvaluearg;
			ValaCCodeFunctionCall* cvalueinit;
			ValaCCodeIdentifier* __temp514;
			ValaCCodeFunctionCall* cvalueset;
			ValaCCodeUnaryExpression* __temp515;
			/* this property is used as a construction parameter*/
			cpointer = vala_ccode_identifier_new ("__params_it");
			ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
			/* set name in array for current parameter*/
			cnamemember = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (cpointer), "name");
			cnameassign = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cnamemember), VALA_CCODE_EXPRESSION (vala_property_get_canonical_cconstant (prop)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cnameassign));
			gvaluearg = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (cpointer), "value")));
			/* initialize GValue in array for current parameter*/
			cvalueinit = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_value_init")));
			vala_ccode_function_call_add_argument (cvalueinit, VALA_CCODE_EXPRESSION (gvaluearg));
			__temp514 = NULL;
			vala_ccode_function_call_add_argument (cvalueinit, VALA_CCODE_EXPRESSION ((__temp514 = vala_ccode_identifier_new (vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)))))));
			(__temp514 == NULL ? NULL : (__temp514 = (g_object_unref (__temp514), NULL)));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvalueinit));
			/* set GValue for current parameter*/
			cvalueset = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_generator_get_value_setter_function (self, vala_property_get_type_reference (prop))));
			vala_ccode_function_call_add_argument (cvalueset, VALA_CCODE_EXPRESSION (gvaluearg));
			vala_ccode_function_call_add_argument (cvalueset, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_right (a)))));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvalueset));
			/* move pointer to next parameter in array*/
			__temp515 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp515 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, VALA_CCODE_EXPRESSION (cpointer)))));
			(__temp515 == NULL ? NULL : (__temp515 = (g_object_unref (__temp515), NULL)));
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE (ccomma)), vala_code_node_get_ccodenode (VALA_CODE_NODE (a)));
			(cpointer == NULL ? NULL : (cpointer = (g_object_unref (cpointer), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
			(cnamemember == NULL ? NULL : (cnamemember = (g_object_unref (cnamemember), NULL)));
			(cnameassign == NULL ? NULL : (cnameassign = (g_object_unref (cnameassign), NULL)));
			(gvaluearg == NULL ? NULL : (gvaluearg = (g_object_unref (gvaluearg), NULL)));
			(cvalueinit == NULL ? NULL : (cvalueinit = (g_object_unref (cvalueinit), NULL)));
			(cvalueset == NULL ? NULL : (cvalueset = (g_object_unref (cvalueset), NULL)));
		} else {
			ValaCCodeExpression* __temp516;
			ValaCCodeExpression* cexpr;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeCommaExpression* ccomma;
			__temp516 = NULL;
			cexpr = (__temp516 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_right (a)))), (__temp516 == NULL ? NULL : g_object_ref (__temp516)));
			if (!vala_property_get_no_accessor_method (prop) && vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_property_get_type_reference (prop))) && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_right (a))) != NULL && vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) != vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_right (a)))) {
				ValaCCodeFunctionCall* ccast;
				ValaCCodeExpression* __temp518;
				ValaCCodeFunctionCall* __temp517;
				/* cast is necessary */
				ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)), NULL))));
				vala_ccode_function_call_add_argument (ccast, cexpr);
				__temp518 = NULL;
				__temp517 = NULL;
				cexpr = (__temp518 = VALA_CCODE_EXPRESSION ((__temp517 = ccast, (__temp517 == NULL ? NULL : g_object_ref (__temp517)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp518);
				(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
			}
			if (vala_assignment_get_operator (a) != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
				ValaCCodeBinaryOperator cop;
				ValaCCodeExpression* __temp519;
				if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_OR) {
					cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_OR;
				} else {
					if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_AND) {
						cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_AND;
					} else {
						if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR) {
							cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR;
						} else {
							if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_ADD) {
								cop = VALA_CCODE_BINARY_OPERATOR_PLUS;
							} else {
								if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SUB) {
									cop = VALA_CCODE_BINARY_OPERATOR_MINUS;
								} else {
									if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_MUL) {
										cop = VALA_CCODE_BINARY_OPERATOR_MUL;
									} else {
										if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_DIV) {
											cop = VALA_CCODE_BINARY_OPERATOR_DIV;
										} else {
											if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_PERCENT) {
												cop = VALA_CCODE_BINARY_OPERATOR_MOD;
											} else {
												if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT) {
													cop = VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT;
												} else {
													if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT) {
														cop = VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT;
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
				__temp519 = NULL;
				cexpr = (__temp519 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (cop, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_left (a)))), VALA_CCODE_EXPRESSION (vala_ccode_parenthesized_expression_new (cexpr)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp519);
			}
			ccall = vala_code_generator_get_property_set_call (self, prop, ma, cexpr);
			/* assignments are expressions, so return the current property value*/
			ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
			/* update property*/
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (ma))));
			/* current property value*/
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE (ccomma)), vala_code_node_get_ccodenode (VALA_CODE_NODE (a)));
			(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		}
		(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
	} else {
		if (vala_expression_get_symbol_reference (vala_assignment_get_left (a)) != NULL && VALA_IS_SIGNAL (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_assignment_get_left (a))))) {
			ValaSignal* __temp520;
			ValaSignal* sig;
			ValaMethod* __temp521;
			ValaMethod* m;
			char* connect_func;
			gboolean disconnect;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeCastExpression* __temp538;
			__temp520 = NULL;
			sig = (__temp520 = VALA_SIGNAL (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_assignment_get_left (a)))), (__temp520 == NULL ? NULL : g_object_ref (__temp520)));
			__temp521 = NULL;
			m = (__temp521 = VALA_METHOD (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_assignment_get_right (a)))), (__temp521 == NULL ? NULL : g_object_ref (__temp521)));
			connect_func = NULL;
			disconnect = FALSE;
			if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_ADD) {
				char* __temp522;
				__temp522 = NULL;
				connect_func = (__temp522 = g_strdup ("g_signal_connect_object"), (connect_func = (g_free (connect_func), NULL)), __temp522);
				if (!vala_method_get_instance (m)) {
					char* __temp523;
					__temp523 = NULL;
					connect_func = (__temp523 = g_strdup ("g_signal_connect"), (connect_func = (g_free (connect_func), NULL)), __temp523);
				}
			} else {
				if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SUB) {
					char* __temp524;
					__temp524 = NULL;
					connect_func = (__temp524 = g_strdup ("g_signal_handlers_disconnect_matched"), (connect_func = (g_free (connect_func), NULL)), __temp524);
					disconnect = TRUE;
				} else {
					(vala_code_node_set_error (VALA_CODE_NODE (a), TRUE), vala_code_node_get_error (VALA_CODE_NODE (a)));
					vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (a)), "Specified compound assignment type for signals not supported.");
					(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					(connect_func = (g_free (connect_func), NULL));
					(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
					return;
				}
			}
			ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (connect_func)));
			if (vala_member_access_get_inner (ma) != NULL) {
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))));
			} else {
				ValaCCodeIdentifier* __temp525;
				__temp525 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp525 = vala_ccode_identifier_new ("self"))));
				(__temp525 == NULL ? NULL : (__temp525 = (g_object_unref (__temp525), NULL)));
			}
			if (!disconnect) {
				ValaCCodeConstant* __temp526;
				__temp526 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp526 = vala_signal_get_canonical_cconstant (sig))));
				(__temp526 = (g_object_unref (__temp526), NULL));
			} else {
				ValaCCodeConstant* __temp527;
				ValaCCodeCommaExpression* ccomma;
				ValaVariableDeclarator* temp_decl;
				ValaVariableDeclarator* __temp528;
				ValaCCodeFunctionCall* parse_call;
				ValaCCodeConstant* __temp529;
				ValaDataType* __temp530;
				ValaDataType* decl_type;
				ValaCCodeIdentifier* __temp531;
				ValaCCodeUnaryExpression* __temp532;
				ValaCCodeConstant* __temp533;
				ValaCCodeConstant* __temp534;
				ValaCCodeIdentifier* __temp535;
				ValaCCodeConstant* __temp536;
				ValaCCodeConstant* __temp537;
				__temp527 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp527 = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA"))));
				(__temp527 == NULL ? NULL : (__temp527 = (g_object_unref (__temp527), NULL)));
				/* get signal id*/
				ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
				temp_decl = vala_code_generator_get_temp_variable_declarator (self, self->priv->uint_type, TRUE);
				__temp528 = NULL;
				self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp528 = temp_decl, (__temp528 == NULL ? NULL : g_object_ref (__temp528))));
				parse_call = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_signal_parse_name")));
				__temp529 = NULL;
				vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((__temp529 = vala_signal_get_canonical_cconstant (sig))));
				(__temp529 = (g_object_unref (__temp529), NULL));
				__temp530 = NULL;
				decl_type = (__temp530 = VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (sig))))), (__temp530 == NULL ? NULL : g_object_ref (__temp530)));
				__temp531 = NULL;
				vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((__temp531 = vala_ccode_identifier_new (vala_data_type_get_type_id (decl_type)))));
				(__temp531 == NULL ? NULL : (__temp531 = (g_object_unref (__temp531), NULL)));
				__temp532 = NULL;
				vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((__temp532 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl)))))));
				(__temp532 == NULL ? NULL : (__temp532 = (g_object_unref (__temp532), NULL)));
				__temp533 = NULL;
				vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((__temp533 = vala_ccode_constant_new ("NULL"))));
				(__temp533 == NULL ? NULL : (__temp533 = (g_object_unref (__temp533), NULL)));
				__temp534 = NULL;
				vala_ccode_function_call_add_argument (parse_call, VALA_CCODE_EXPRESSION ((__temp534 = vala_ccode_constant_new ("FALSE"))));
				(__temp534 == NULL ? NULL : (__temp534 = (g_object_unref (__temp534), NULL)));
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (parse_call));
				__temp535 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp535 = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl)))));
				(__temp535 == NULL ? NULL : (__temp535 = (g_object_unref (__temp535), NULL)));
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccomma));
				__temp536 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp536 = vala_ccode_constant_new ("0"))));
				(__temp536 == NULL ? NULL : (__temp536 = (g_object_unref (__temp536), NULL)));
				__temp537 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp537 = vala_ccode_constant_new ("NULL"))));
				(__temp537 == NULL ? NULL : (__temp537 = (g_object_unref (__temp537), NULL)));
				(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
				(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
				(parse_call == NULL ? NULL : (parse_call = (g_object_unref (parse_call), NULL)));
				(decl_type == NULL ? NULL : (decl_type = (g_object_unref (decl_type), NULL)));
			}
			__temp538 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp538 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_method_get_cname (m))), "GCallback"))));
			(__temp538 == NULL ? NULL : (__temp538 = (g_object_unref (__temp538), NULL)));
			if (vala_method_get_instance (m)) {
				if (VALA_IS_MEMBER_ACCESS (vala_assignment_get_right (a))) {
					ValaMemberAccess* __temp539;
					ValaMemberAccess* right_ma;
					__temp539 = NULL;
					right_ma = (__temp539 = VALA_MEMBER_ACCESS (vala_assignment_get_right (a)), (__temp539 == NULL ? NULL : g_object_ref (__temp539)));
					if (vala_member_access_get_inner (right_ma) != NULL) {
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (right_ma)))));
					} else {
						ValaCCodeIdentifier* __temp540;
						__temp540 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp540 = vala_ccode_identifier_new ("self"))));
						(__temp540 == NULL ? NULL : (__temp540 = (g_object_unref (__temp540), NULL)));
					}
					(right_ma == NULL ? NULL : (right_ma = (g_object_unref (right_ma), NULL)));
				} else {
					if (VALA_IS_LAMBDA_EXPRESSION (vala_assignment_get_right (a))) {
						ValaCCodeIdentifier* __temp541;
						__temp541 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp541 = vala_ccode_identifier_new ("self"))));
						(__temp541 == NULL ? NULL : (__temp541 = (g_object_unref (__temp541), NULL)));
					}
				}
				if (!disconnect) {
					ValaCCodeConstant* __temp542;
					__temp542 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp542 = vala_ccode_constant_new ("0"))));
					(__temp542 == NULL ? NULL : (__temp542 = (g_object_unref (__temp542), NULL)));
				}
			} else {
				ValaCCodeConstant* __temp543;
				__temp543 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp543 = vala_ccode_constant_new ("NULL"))));
				(__temp543 == NULL ? NULL : (__temp543 = (g_object_unref (__temp543), NULL)));
			}
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (a)));
			(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			(connect_func = (g_free (connect_func), NULL));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		} else {
			ValaCCodeExpression* __temp544;
			ValaCCodeExpression* rhs;
			gboolean unref_old;
			gboolean array;
			ValaCCodeAssignmentOperator cop;
			ValaCCodeAssignment* __temp554;
			/* explicitly use strong reference as ccast gets
			 * unrefed at end of inner block
			 */
			__temp544 = NULL;
			rhs = (__temp544 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_right (a)))), (__temp544 == NULL ? NULL : g_object_ref (__temp544)));
			if (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a))) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_right (a))) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a)))) && vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_right (a))) != vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a)))) {
				ValaCCodeFunctionCall* ccast;
				ValaCCodeExpression* __temp546;
				ValaCCodeFunctionCall* __temp545;
				ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a))), NULL))));
				vala_ccode_function_call_add_argument (ccast, rhs);
				__temp546 = NULL;
				__temp545 = NULL;
				rhs = (__temp546 = VALA_CCODE_EXPRESSION ((__temp545 = ccast, (__temp545 == NULL ? NULL : g_object_ref (__temp545)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp546);
				(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
			}
			unref_old = (vala_code_generator_get_memory_management (self) && vala_type_reference_get_takes_ownership (vala_expression_get_static_type (vala_assignment_get_left (a))));
			array = FALSE;
			if (VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_assignment_get_left (a))))) {
				array = !(VALA_IS_CCODE_CONSTANT (vala_code_generator_get_array_length_cexpression (self, vala_assignment_get_left (a), 1)));
			}
			if (unref_old || array) {
				ValaCCodeCommaExpression* ccomma;
				ValaVariableDeclarator* temp_decl;
				ValaVariableDeclarator* __temp547;
				ValaCCodeAssignment* __temp548;
				ValaCCodeIdentifier* __temp551;
				ValaCCodeExpression* __temp553;
				ValaCCodeCommaExpression* __temp552;
				ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
				temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (vala_assignment_get_left (a)), TRUE);
				__temp547 = NULL;
				self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp547 = temp_decl, (__temp547 == NULL ? NULL : g_object_ref (__temp547))));
				__temp548 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp548 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl))), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
				(__temp548 == NULL ? NULL : (__temp548 = (g_object_unref (__temp548), NULL)));
				if (unref_old) {
					ValaCCodeExpression* __temp549;
					/* unref old value */
					__temp549 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (__temp549 = vala_code_generator_get_unref_expression (self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_left (a)))), vala_expression_get_static_type (vala_assignment_get_left (a)))));
					(__temp549 == NULL ? NULL : (__temp549 = (g_object_unref (__temp549), NULL)));
				}
				if (array) {
					ValaCCodeExpression* lhs_array_len;
					ValaCCodeExpression* rhs_array_len;
					ValaCCodeAssignment* __temp550;
					lhs_array_len = vala_code_generator_get_array_length_cexpression (self, vala_assignment_get_left (a), 1);
					rhs_array_len = vala_code_generator_get_array_length_cexpression (self, vala_assignment_get_right (a), 1);
					__temp550 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp550 = vala_ccode_assignment_new (lhs_array_len, rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
					(__temp550 == NULL ? NULL : (__temp550 = (g_object_unref (__temp550), NULL)));
					(lhs_array_len = (g_object_unref (lhs_array_len), NULL));
					(rhs_array_len = (g_object_unref (rhs_array_len), NULL));
				}
				__temp551 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp551 = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl)))));
				(__temp551 == NULL ? NULL : (__temp551 = (g_object_unref (__temp551), NULL)));
				__temp553 = NULL;
				__temp552 = NULL;
				rhs = (__temp553 = VALA_CCODE_EXPRESSION ((__temp552 = ccomma, (__temp552 == NULL ? NULL : g_object_ref (__temp552)))), (rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL))), __temp553);
				(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
				(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
			}
			cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE;
			if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_OR) {
				cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_OR;
			} else {
				if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_AND) {
					cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_AND;
				} else {
					if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR) {
						cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_XOR;
					} else {
						if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_ADD) {
							cop = VALA_CCODE_ASSIGNMENT_OPERATOR_ADD;
						} else {
							if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SUB) {
								cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SUB;
							} else {
								if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_MUL) {
									cop = VALA_CCODE_ASSIGNMENT_OPERATOR_MUL;
								} else {
									if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_DIV) {
										cop = VALA_CCODE_ASSIGNMENT_OPERATOR_DIV;
									} else {
										if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_PERCENT) {
											cop = VALA_CCODE_ASSIGNMENT_OPERATOR_PERCENT;
										} else {
											if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT) {
												cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_LEFT;
											} else {
												if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT) {
													cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_RIGHT;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			__temp554 = NULL;
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (a), VALA_CCODE_NODE ((__temp554 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_assignment_get_left (a)))), rhs, cop)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (a)));
			(__temp554 == NULL ? NULL : (__temp554 = (g_object_unref (__temp554), NULL)));
			(rhs == NULL ? NULL : (rhs = (g_object_unref (rhs), NULL)));
		}
	}
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
}


static ValaCCodeFunctionCall* vala_code_generator_get_property_set_call (ValaCodeGenerator* self, ValaProperty* prop, ValaMemberAccess* ma, ValaCCodeExpression* cexpr)
{
	ValaClass* __temp555;
	ValaClass* cl;
	char* set_func;
	ValaProperty* base_property;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeExpression* instance;
	gboolean req_cast;
	ValaCCodeFunctionCall* __temp570;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_PROPERTY (prop), NULL);
	g_return_val_if_fail (VALA_IS_MEMBER_ACCESS (ma), NULL);
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (cexpr), NULL);
	__temp555 = NULL;
	cl = (__temp555 = VALA_CLASS (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (prop))))), (__temp555 == NULL ? NULL : g_object_ref (__temp555)));
	set_func = g_strdup ("g_object_set");
	base_property = g_object_ref (prop);
	if (!vala_property_get_no_accessor_method (prop)) {
		ValaDataType* __temp560;
		ValaDataType* base_property_type;
		char* __temp562;
		char* __temp561;
		if (vala_property_get_base_property (prop) != NULL) {
			ValaProperty* __temp557;
			ValaProperty* __temp556;
			__temp557 = NULL;
			__temp556 = NULL;
			base_property = (__temp557 = (__temp556 = vala_property_get_base_property (prop), (__temp556 == NULL ? NULL : g_object_ref (__temp556))), (base_property = (g_object_unref (base_property), NULL)), __temp557);
		} else {
			if (vala_property_get_base_interface_property (prop) != NULL) {
				ValaProperty* __temp559;
				ValaProperty* __temp558;
				__temp559 = NULL;
				__temp558 = NULL;
				base_property = (__temp559 = (__temp558 = vala_property_get_base_interface_property (prop), (__temp558 == NULL ? NULL : g_object_ref (__temp558))), (base_property = (g_object_unref (base_property), NULL)), __temp559);
			}
		}
		__temp560 = NULL;
		base_property_type = (__temp560 = VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (base_property))))), (__temp560 == NULL ? NULL : g_object_ref (__temp560)));
		__temp562 = NULL;
		__temp561 = NULL;
		set_func = (__temp562 = g_strdup_printf ("%s_set_%s", (__temp561 = vala_data_type_get_lower_case_cname (base_property_type, NULL)), vala_property_get_name (base_property)), (set_func = (g_free (set_func), NULL)), __temp562);
		(__temp561 = (g_free (__temp561), NULL));
		(base_property_type == NULL ? NULL : (base_property_type = (g_object_unref (base_property_type), NULL)));
	}
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (set_func)));
	/* target instance is first argument */
	instance = NULL;
	req_cast = FALSE;
	if (vala_member_access_get_inner (ma) == NULL) {
		ValaCCodeExpression* __temp563;
		__temp563 = NULL;
		instance = (__temp563 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp563);
		/* require casts for inherited properties */
		req_cast = (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (base_property))) != self->priv->current_type_symbol);
	} else {
		ValaCCodeExpression* __temp565;
		ValaCCodeExpression* __temp564;
		__temp565 = NULL;
		__temp564 = NULL;
		instance = (__temp565 = (__temp564 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (__temp564 == NULL ? NULL : g_object_ref (__temp564))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp565);
		/* require casts if the type of the used instance is
		 * different than the type which declared the property */
		req_cast = vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (base_property)))) != VALA_CODE_NODE (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))));
	}
	if (req_cast && vala_data_type_is_reference_type ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (prop)))))))) {
		ValaCCodeFunctionCall* ccast;
		ValaCCodeExpression* __temp567;
		ValaCCodeFunctionCall* __temp566;
		ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (base_property)))))), NULL))));
		vala_ccode_function_call_add_argument (ccast, instance);
		__temp567 = NULL;
		__temp566 = NULL;
		instance = (__temp567 = VALA_CCODE_EXPRESSION ((__temp566 = ccast, (__temp566 == NULL ? NULL : g_object_ref (__temp566)))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp567);
		(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
	}
	vala_ccode_function_call_add_argument (ccall, instance);
	if (vala_property_get_no_accessor_method (prop)) {
		ValaCCodeConstant* __temp568;
		/* property name is second argument of g_object_set */
		__temp568 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp568 = vala_property_get_canonical_cconstant (prop))));
		(__temp568 = (g_object_unref (__temp568), NULL));
	}
	vala_ccode_function_call_add_argument (ccall, cexpr);
	if (vala_property_get_no_accessor_method (prop)) {
		ValaCCodeConstant* __temp569;
		__temp569 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp569 = vala_ccode_constant_new ("NULL"))));
		(__temp569 == NULL ? NULL : (__temp569 = (g_object_unref (__temp569), NULL)));
	}
	__temp570 = NULL;
	return (__temp570 = ccall, (cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL))), (set_func = (g_free (set_func), NULL)), (base_property = (g_object_unref (base_property), NULL)), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp570);
	(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	(set_func = (g_free (set_func), NULL));
	(base_property = (g_object_unref (base_property), NULL));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
}


static void vala_code_generator_real_visit_class (ValaCodeVisitor* base, ValaClass* cl)
{
	ValaCodeGenerator * self;
	ValaSymbol* __temp572;
	ValaSymbol* __temp571;
	ValaSymbol* __temp574;
	ValaSymbol* __temp573;
	ValaClass* __temp575;
	ValaCCodeStruct* __temp577;
	char* __temp576;
	ValaCCodeStruct* __temp579;
	char* __temp578;
	ValaCCodeStruct* __temp581;
	char* __temp580;
	ValaCCodeEnum* __temp582;
	char* __temp584;
	char* __temp583;
	ValaCCodeFragment* __temp585;
	ValaCCodeFragment* __temp586;
	ValaCCodeNewline* __temp587;
	char* __temp588;
	char* __temp589;
	char* macro;
	ValaCCodeMacroReplacement* __temp590;
	char* __temp593;
	char* __temp592;
	char* __temp591;
	ValaCCodeMacroReplacement* __temp595;
	char* __temp594;
	char* __temp598;
	char* __temp597;
	char* __temp596;
	ValaCCodeMacroReplacement* __temp600;
	char* __temp599;
	char* __temp602;
	char* __temp601;
	ValaCCodeMacroReplacement* __temp604;
	char* __temp603;
	char* __temp606;
	char* __temp605;
	ValaCCodeMacroReplacement* __temp608;
	char* __temp607;
	char* __temp611;
	char* __temp610;
	char* __temp609;
	ValaCCodeMacroReplacement* __temp613;
	char* __temp612;
	ValaCCodeNewline* __temp614;
	ValaCCodeTypeDefinition* __temp619;
	char* __temp618;
	char* __temp620;
	char* __temp622;
	char* __temp621;
	char* __temp624;
	char* __temp623;
	ValaSymbol* __temp640;
	ValaClass* __temp641;
	ValaCCodeFragment* __temp642;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CLASS (cl));
	__temp572 = NULL;
	__temp571 = NULL;
	self->priv->current_symbol = (__temp572 = (__temp571 = vala_code_node_get_symbol (VALA_CODE_NODE (cl)), (__temp571 == NULL ? NULL : g_object_ref (__temp571))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp572);
	__temp574 = NULL;
	__temp573 = NULL;
	self->priv->current_type_symbol = (__temp574 = (__temp573 = vala_code_node_get_symbol (VALA_CODE_NODE (cl)), (__temp573 == NULL ? NULL : g_object_ref (__temp573))), (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), __temp574);
	__temp575 = NULL;
	self->priv->current_class = (__temp575 = g_object_ref (cl), (self->priv->current_class == NULL ? NULL : (self->priv->current_class = (g_object_unref (self->priv->current_class), NULL))), __temp575);
	if (vala_class_get_is_static (cl)) {
		return;
	}
	__temp577 = NULL;
	__temp576 = NULL;
	self->priv->instance_struct = (__temp577 = vala_ccode_struct_new (g_strdup_printf ("_%s", (__temp576 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (self->priv->instance_struct == NULL ? NULL : (self->priv->instance_struct = (g_object_unref (self->priv->instance_struct), NULL))), __temp577);
	(__temp576 = (g_free (__temp576), NULL));
	__temp579 = NULL;
	__temp578 = NULL;
	self->priv->type_struct = (__temp579 = vala_ccode_struct_new (g_strdup_printf ("_%sClass", (__temp578 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (self->priv->type_struct == NULL ? NULL : (self->priv->type_struct = (g_object_unref (self->priv->type_struct), NULL))), __temp579);
	(__temp578 = (g_free (__temp578), NULL));
	__temp581 = NULL;
	__temp580 = NULL;
	self->priv->instance_priv_struct = (__temp581 = vala_ccode_struct_new (g_strdup_printf ("_%sPrivate", (__temp580 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (self->priv->instance_priv_struct == NULL ? NULL : (self->priv->instance_priv_struct = (g_object_unref (self->priv->instance_priv_struct), NULL))), __temp581);
	(__temp580 = (g_free (__temp580), NULL));
	__temp582 = NULL;
	self->priv->prop_enum = (__temp582 = vala_ccode_enum_new (NULL), (self->priv->prop_enum == NULL ? NULL : (self->priv->prop_enum = (g_object_unref (self->priv->prop_enum), NULL))), __temp582);
	__temp584 = NULL;
	__temp583 = NULL;
	vala_ccode_enum_add_value (self->priv->prop_enum, (__temp584 = g_strdup_printf ("%s_DUMMY_PROPERTY", (__temp583 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))), NULL);
	(__temp584 = (g_free (__temp584), NULL));
	(__temp583 = (g_free (__temp583), NULL));
	__temp585 = NULL;
	self->priv->instance_init_fragment = (__temp585 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->instance_init_fragment == NULL ? NULL : (self->priv->instance_init_fragment = (g_object_unref (self->priv->instance_init_fragment), NULL))), __temp585);
	__temp586 = NULL;
	self->priv->instance_dispose_fragment = (__temp586 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->instance_dispose_fragment == NULL ? NULL : (self->priv->instance_dispose_fragment = (g_object_unref (self->priv->instance_dispose_fragment), NULL))), __temp586);
	__temp587 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp587 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp587 == NULL ? NULL : (__temp587 = (g_object_unref (__temp587), NULL)));
	__temp588 = NULL;
	__temp589 = NULL;
	macro = (__temp589 = g_strdup_printf ("(%s_get_type ())", (__temp588 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))), (__temp588 = (g_free (__temp588), NULL)), __temp589);
	__temp590 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp590 = vala_ccode_macro_replacement_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_"), macro))));
	(__temp590 == NULL ? NULL : (__temp590 = (g_object_unref (__temp590), NULL)));
	__temp593 = NULL;
	__temp592 = NULL;
	__temp591 = NULL;
	macro = (__temp593 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_CAST ((obj), %s, %s))", (__temp591 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")), (__temp592 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), (macro = (g_free (macro), NULL)), __temp593);
	(__temp592 = (g_free (__temp592), NULL));
	(__temp591 = (g_free (__temp591), NULL));
	__temp595 = NULL;
	__temp594 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp595 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s(obj)", (__temp594 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL))), macro))));
	(__temp595 == NULL ? NULL : (__temp595 = (g_object_unref (__temp595), NULL)));
	(__temp594 = (g_free (__temp594), NULL));
	__temp598 = NULL;
	__temp597 = NULL;
	__temp596 = NULL;
	macro = (__temp598 = g_strdup_printf ("(G_TYPE_CHECK_CLASS_CAST ((klass), %s, %sClass))", (__temp596 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")), (__temp597 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), (macro = (g_free (macro), NULL)), __temp598);
	(__temp597 = (g_free (__temp597), NULL));
	(__temp596 = (g_free (__temp596), NULL));
	__temp600 = NULL;
	__temp599 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp600 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s_CLASS(klass)", (__temp599 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL))), macro))));
	(__temp600 == NULL ? NULL : (__temp600 = (g_object_unref (__temp600), NULL)));
	(__temp599 = (g_free (__temp599), NULL));
	__temp602 = NULL;
	__temp601 = NULL;
	macro = (__temp602 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_TYPE ((obj), %s))", (__temp601 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_"))), (macro = (g_free (macro), NULL)), __temp602);
	(__temp601 = (g_free (__temp601), NULL));
	__temp604 = NULL;
	__temp603 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp604 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s(obj)", (__temp603 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "IS_"))), macro))));
	(__temp604 == NULL ? NULL : (__temp604 = (g_object_unref (__temp604), NULL)));
	(__temp603 = (g_free (__temp603), NULL));
	__temp606 = NULL;
	__temp605 = NULL;
	macro = (__temp606 = g_strdup_printf ("(G_TYPE_CHECK_CLASS_TYPE ((klass), %s))", (__temp605 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_"))), (macro = (g_free (macro), NULL)), __temp606);
	(__temp605 = (g_free (__temp605), NULL));
	__temp608 = NULL;
	__temp607 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp608 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s_CLASS(klass)", (__temp607 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "IS_"))), macro))));
	(__temp608 == NULL ? NULL : (__temp608 = (g_object_unref (__temp608), NULL)));
	(__temp607 = (g_free (__temp607), NULL));
	__temp611 = NULL;
	__temp610 = NULL;
	__temp609 = NULL;
	macro = (__temp611 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_CLASS ((obj), %s, %sClass))", (__temp609 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")), (__temp610 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), (macro = (g_free (macro), NULL)), __temp611);
	(__temp610 = (g_free (__temp610), NULL));
	(__temp609 = (g_free (__temp609), NULL));
	__temp613 = NULL;
	__temp612 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp613 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s_GET_CLASS(obj)", (__temp612 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL))), macro))));
	(__temp613 == NULL ? NULL : (__temp613 = (g_object_unref (__temp613), NULL)));
	(__temp612 = (g_free (__temp612), NULL));
	__temp614 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp614 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp614 == NULL ? NULL : (__temp614 = (g_object_unref (__temp614), NULL)));
	if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (cl)))) == NULL) {
		ValaCCodeTypeDefinition* __temp615;
		ValaCCodeTypeDefinition* __temp617;
		char* __temp616;
		__temp615 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp615 = vala_ccode_type_definition_new (g_strdup_printf ("struct %s", vala_ccode_struct_get_name (self->priv->instance_struct)), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))));
		(__temp615 == NULL ? NULL : (__temp615 = (g_object_unref (__temp615), NULL)));
		__temp617 = NULL;
		__temp616 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp617 = vala_ccode_type_definition_new (g_strdup_printf ("struct %s", vala_ccode_struct_get_name (self->priv->type_struct)), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (g_strdup_printf ("%sClass", (__temp616 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))))));
		(__temp617 == NULL ? NULL : (__temp617 = (g_object_unref (__temp617), NULL)));
		(__temp616 = (g_free (__temp616), NULL));
	}
	__temp619 = NULL;
	__temp618 = NULL;
	vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp619 = vala_ccode_type_definition_new (g_strdup_printf ("struct %s", vala_ccode_struct_get_name (self->priv->instance_priv_struct)), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (g_strdup_printf ("%sPrivate", (__temp618 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))))));
	(__temp619 == NULL ? NULL : (__temp619 = (g_object_unref (__temp619), NULL)));
	(__temp618 = (g_free (__temp618), NULL));
	__temp620 = NULL;
	vala_ccode_struct_add_field (self->priv->instance_struct, (__temp620 = vala_data_type_get_cname (VALA_DATA_TYPE (vala_class_get_base_class (cl)), FALSE)), "parent");
	(__temp620 = (g_free (__temp620), NULL));
	__temp622 = NULL;
	__temp621 = NULL;
	vala_ccode_struct_add_field (self->priv->instance_struct, (__temp622 = g_strdup_printf ("%sPrivate *", (__temp621 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), "priv");
	(__temp622 = (g_free (__temp622), NULL));
	(__temp621 = (g_free (__temp621), NULL));
	__temp624 = NULL;
	__temp623 = NULL;
	vala_ccode_struct_add_field (self->priv->type_struct, (__temp624 = g_strdup_printf ("%sClass", (__temp623 = vala_data_type_get_cname (VALA_DATA_TYPE (vala_class_get_base_class (cl)), FALSE)))), "parent");
	(__temp624 = (g_free (__temp624), NULL));
	(__temp623 = (g_free (__temp623), NULL));
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (cl))) != NULL) {
		ValaCCodeComment* __temp625;
		__temp625 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE ((__temp625 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (cl)))))));
		(__temp625 == NULL ? NULL : (__temp625 = (g_object_unref (__temp625), NULL)));
	}
	vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (self->priv->instance_struct));
	vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (self->priv->type_struct));
	/* only add the *Private struct if it is not empty, i.e. we actually have private data */
	if (vala_class_get_has_private_fields (cl)) {
		char* __temp628;
		char* __temp627;
		char* __temp626;
		ValaCCodeMacroReplacement* __temp630;
		char* __temp629;
		vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (self->priv->instance_priv_struct));
		__temp628 = NULL;
		__temp627 = NULL;
		__temp626 = NULL;
		macro = (__temp628 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_PRIVATE ((o), %s, %sPrivate))", (__temp626 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")), (__temp627 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), (macro = (g_free (macro), NULL)), __temp628);
		(__temp627 = (g_free (__temp627), NULL));
		(__temp626 = (g_free (__temp626), NULL));
		__temp630 = NULL;
		__temp629 = NULL;
		vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((__temp630 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s_GET_PRIVATE(o)", (__temp629 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL))), macro))));
		(__temp630 == NULL ? NULL : (__temp630 = (g_object_unref (__temp630), NULL)));
		(__temp629 = (g_free (__temp629), NULL));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (self->priv->prop_enum));
	vala_code_node_accept_children (VALA_CODE_NODE (cl), VALA_CODE_VISITOR (self));
	if (!vala_class_get_is_static (cl)) {
		GList* __temp632;
		gboolean __temp633;
		ValaClassRegisterFunction* type_fun;
		ValaCCodeFragment* __temp634;
		ValaCCodeFragment* __temp635;
		if (vala_code_generator_class_has_readable_properties (self, cl)) {
			vala_code_generator_add_get_property_function (self, cl);
		}
		if (vala_code_generator_class_has_writable_properties (self, cl)) {
			vala_code_generator_add_set_property_function (self, cl);
		}
		vala_code_generator_add_class_init_function (self, cl);
		{
			GList* __temp631;
			GList* base_type_it;
			__temp631 = NULL;
			__temp631 = vala_class_get_base_types (cl);
			for (base_type_it = __temp631; base_type_it != NULL; base_type_it = base_type_it->next) {
				ValaTypeReference* base_type;
				base_type = base_type_it->data;
				{
					if (VALA_IS_INTERFACE (vala_type_reference_get_data_type (base_type))) {
						vala_code_generator_add_interface_init_function (self, cl, VALA_INTERFACE (vala_type_reference_get_data_type (base_type)));
					}
				}
			}
			(__temp631 == NULL ? NULL : (__temp631 = (g_list_free (__temp631), NULL)));
		}
		vala_code_generator_add_instance_init_function (self, cl);
		__temp632 = NULL;
		if ((__temp633 = vala_code_generator_get_memory_management (self) && (__temp632 = vala_class_get_fields (cl)) != NULL, (__temp632 == NULL ? NULL : (__temp632 = (g_list_free (__temp632), NULL))), __temp633)) {
			vala_code_generator_add_dispose_function (self, cl);
		}
		type_fun = vala_class_register_function_new (cl);
		vala_type_register_function_init_from_type (VALA_TYPE_REGISTER_FUNCTION (type_fun), self->priv->in_plugin);
		__temp634 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp634 = vala_type_register_function_get_declaration (VALA_TYPE_REGISTER_FUNCTION (type_fun)))));
		(__temp634 = (g_object_unref (__temp634), NULL));
		__temp635 = NULL;
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE ((__temp635 = vala_type_register_function_get_definition (VALA_TYPE_REGISTER_FUNCTION (type_fun)))));
		(__temp635 = (g_object_unref (__temp635), NULL));
		if (self->priv->in_plugin) {
			char* __temp636;
			ValaCCodeFunctionCall* __temp637;
			ValaCCodeFunctionCall* register_call;
			ValaCCodeIdentifier* __temp638;
			ValaCCodeExpressionStatement* __temp639;
			/* FIXME resolve potential dependency issues, i.e. base types have to be registered before derived types*/
			__temp636 = NULL;
			__temp637 = NULL;
			register_call = (__temp637 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_register_type", (__temp636 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL)))))), (__temp636 = (g_free (__temp636), NULL)), __temp637);
			__temp638 = NULL;
			vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION ((__temp638 = vala_ccode_identifier_new (self->priv->module_init_param_name))));
			(__temp638 == NULL ? NULL : (__temp638 = (g_object_unref (__temp638), NULL)));
			__temp639 = NULL;
			vala_ccode_fragment_append (self->priv->module_init_fragment, VALA_CCODE_NODE ((__temp639 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (register_call)))));
			(__temp639 == NULL ? NULL : (__temp639 = (g_object_unref (__temp639), NULL)));
			(register_call == NULL ? NULL : (register_call = (g_object_unref (register_call), NULL)));
		}
		(type_fun == NULL ? NULL : (type_fun = (g_object_unref (type_fun), NULL)));
	}
	__temp640 = NULL;
	self->priv->current_type_symbol = (__temp640 = NULL, (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), __temp640);
	__temp641 = NULL;
	self->priv->current_class = (__temp641 = NULL, (self->priv->current_class == NULL ? NULL : (self->priv->current_class = (g_object_unref (self->priv->current_class), NULL))), __temp641);
	__temp642 = NULL;
	self->priv->instance_dispose_fragment = (__temp642 = NULL, (self->priv->instance_dispose_fragment == NULL ? NULL : (self->priv->instance_dispose_fragment = (g_object_unref (self->priv->instance_dispose_fragment), NULL))), __temp642);
	(macro = (g_free (macro), NULL));
}


static void vala_code_generator_add_class_init_function (ValaCodeGenerator* self, ValaClass* cl)
{
	char* __temp643;
	ValaCCodeFunction* __temp644;
	ValaCCodeFunction* class_init;
	ValaCCodeFormalParameter* __temp646;
	char* __temp645;
	ValaCCodeBlock* init_block;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeDeclaration* parent_decl;
	char* __temp647;
	ValaCCodeVariableDeclarator* __temp648;
	ValaCCodeVariableDeclarator* parent_var_decl;
	ValaCCodeConstant* __temp649;
	ValaCCodeFunctionCall* __temp650;
	ValaCCodeIdentifier* __temp651;
	char* __temp652;
	ValaCCodeAssignment* __temp653;
	ValaCCodeAssignment* parent_assignment;
	ValaCCodeExpressionStatement* __temp654;
	ValaCCodeFunctionCall* __temp660;
	ValaCCodeIdentifier* __temp661;
	GList* __temp669;
	gboolean __temp670;
	GList* methods;
	GList* props;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	__temp643 = NULL;
	__temp644 = NULL;
	class_init = (__temp644 = vala_ccode_function_new (g_strdup_printf ("%s_class_init", (__temp643 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))), "void"), (__temp643 = (g_free (__temp643), NULL)), __temp644);
	__temp646 = NULL;
	__temp645 = NULL;
	vala_ccode_function_add_parameter (class_init, (__temp646 = vala_ccode_formal_parameter_new ("klass", g_strdup_printf ("%sClass *", (__temp645 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))));
	(__temp646 == NULL ? NULL : (__temp646 = (g_object_unref (__temp646), NULL)));
	(__temp645 = (g_free (__temp645), NULL));
	(vala_ccode_function_set_modifiers (class_init, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (class_init));
	init_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	(vala_ccode_function_set_block (class_init, init_block), vala_ccode_function_get_block (class_init));
	ccall = NULL;
	/* save pointer to parent class */
	parent_decl = vala_ccode_declaration_new ("gpointer");
	__temp647 = NULL;
	__temp648 = NULL;
	parent_var_decl = (__temp648 = vala_ccode_variable_declarator_new (g_strdup_printf ("%s_parent_class", (__temp647 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL)))), (__temp647 = (g_free (__temp647), NULL)), __temp648);
	__temp649 = NULL;
	(vala_ccode_variable_declarator_set_initializer (parent_var_decl, VALA_CCODE_EXPRESSION ((__temp649 = vala_ccode_constant_new ("NULL")))), vala_ccode_variable_declarator_get_initializer (parent_var_decl));
	(__temp649 == NULL ? NULL : (__temp649 = (g_object_unref (__temp649), NULL)));
	vala_ccode_declaration_add_declarator (parent_decl, VALA_CCODE_DECLARATOR (parent_var_decl));
	(vala_ccode_declaration_set_modifiers (parent_decl, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_declaration_get_modifiers (parent_decl));
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (parent_decl));
	__temp650 = NULL;
	ccall = (__temp650 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_class_peek_parent"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp650);
	__temp651 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp651 = vala_ccode_identifier_new ("klass"))));
	(__temp651 == NULL ? NULL : (__temp651 = (g_object_unref (__temp651), NULL)));
	__temp652 = NULL;
	__temp653 = NULL;
	parent_assignment = (__temp653 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_parent_class", (__temp652 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (__temp652 = (g_free (__temp652), NULL)), __temp653);
	__temp654 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp654 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (parent_assignment)))));
	(__temp654 == NULL ? NULL : (__temp654 = (g_object_unref (__temp654), NULL)));
	/* add struct for private fields */
	if (vala_class_get_has_private_fields (cl)) {
		ValaCCodeFunctionCall* __temp655;
		ValaCCodeIdentifier* __temp656;
		ValaCCodeConstant* __temp658;
		char* __temp657;
		ValaCCodeExpressionStatement* __temp659;
		__temp655 = NULL;
		ccall = (__temp655 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_class_add_private"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp655);
		__temp656 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp656 = vala_ccode_identifier_new ("klass"))));
		(__temp656 == NULL ? NULL : (__temp656 = (g_object_unref (__temp656), NULL)));
		__temp658 = NULL;
		__temp657 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp658 = vala_ccode_constant_new (g_strdup_printf ("sizeof (%sPrivate)", (__temp657 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))));
		(__temp658 == NULL ? NULL : (__temp658 = (g_object_unref (__temp658), NULL)));
		(__temp657 = (g_free (__temp657), NULL));
		__temp659 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp659 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
		(__temp659 == NULL ? NULL : (__temp659 = (g_object_unref (__temp659), NULL)));
	}
	/* set property handlers */
	__temp660 = NULL;
	ccall = (__temp660 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT_CLASS"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp660);
	__temp661 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp661 = vala_ccode_identifier_new ("klass"))));
	(__temp661 == NULL ? NULL : (__temp661 = (g_object_unref (__temp661), NULL)));
	if (vala_code_generator_class_has_readable_properties (self, cl)) {
		ValaCCodeExpressionStatement* __temp663;
		char* __temp662;
		__temp663 = NULL;
		__temp662 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp663 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccall), "get_property")), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_get_property", (__temp662 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
		(__temp663 == NULL ? NULL : (__temp663 = (g_object_unref (__temp663), NULL)));
		(__temp662 = (g_free (__temp662), NULL));
	}
	if (vala_code_generator_class_has_writable_properties (self, cl)) {
		ValaCCodeExpressionStatement* __temp665;
		char* __temp664;
		__temp665 = NULL;
		__temp664 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp665 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccall), "set_property")), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_set_property", (__temp664 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
		(__temp665 == NULL ? NULL : (__temp665 = (g_object_unref (__temp665), NULL)));
		(__temp664 = (g_free (__temp664), NULL));
	}
	/* set constructor */
	if (vala_class_get_constructor (cl) != NULL) {
		ValaCCodeFunctionCall* ccast;
		ValaCCodeIdentifier* __temp666;
		ValaCCodeExpressionStatement* __temp668;
		char* __temp667;
		ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT_CLASS")));
		__temp666 = NULL;
		vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((__temp666 = vala_ccode_identifier_new ("klass"))));
		(__temp666 == NULL ? NULL : (__temp666 = (g_object_unref (__temp666), NULL)));
		__temp668 = NULL;
		__temp667 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp668 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), "constructor")), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_constructor", (__temp667 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
		(__temp668 == NULL ? NULL : (__temp668 = (g_object_unref (__temp668), NULL)));
		(__temp667 = (g_free (__temp667), NULL));
		(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
	}
	/* set dispose function */
	__temp669 = NULL;
	if ((__temp670 = vala_code_generator_get_memory_management (self) && (__temp669 = vala_class_get_fields (cl)) != NULL, (__temp669 == NULL ? NULL : (__temp669 = (g_list_free (__temp669), NULL))), __temp670)) {
		ValaCCodeFunctionCall* ccast;
		ValaCCodeIdentifier* __temp671;
		ValaCCodeExpressionStatement* __temp673;
		char* __temp672;
		ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT_CLASS")));
		__temp671 = NULL;
		vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((__temp671 = vala_ccode_identifier_new ("klass"))));
		(__temp671 == NULL ? NULL : (__temp671 = (g_object_unref (__temp671), NULL)));
		__temp673 = NULL;
		__temp672 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp673 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), "dispose")), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_dispose", (__temp672 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
		(__temp673 == NULL ? NULL : (__temp673 = (g_object_unref (__temp673), NULL)));
		(__temp672 = (g_free (__temp672), NULL));
		(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
	}
	/* connect overridden methods */
	methods = vala_class_get_methods (cl);
	{
		GList* __temp679;
		GList* m_it;
		__temp679 = NULL;
		__temp679 = methods;
		for (m_it = __temp679; m_it != NULL; m_it = m_it->next) {
			ValaMethod* m;
			m = m_it->data;
			{
				ValaCodeNode* __temp674;
				ValaCodeNode* base_type;
				char* __temp675;
				ValaCCodeFunctionCall* __temp676;
				ValaCCodeFunctionCall* ccast;
				ValaCCodeIdentifier* __temp677;
				ValaCCodeExpressionStatement* __temp678;
				if (vala_method_get_base_method (m) == NULL) {
					continue;
				}
				__temp674 = NULL;
				base_type = (__temp674 = vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (vala_method_get_base_method (m))))), (__temp674 == NULL ? NULL : g_object_ref (__temp674)));
				__temp675 = NULL;
				__temp676 = NULL;
				ccast = (__temp676 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_CLASS", (__temp675 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE ((VALA_CLASS (base_type))), NULL)))))), (__temp675 = (g_free (__temp675), NULL)), __temp676);
				__temp677 = NULL;
				vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((__temp677 = vala_ccode_identifier_new ("klass"))));
				(__temp677 == NULL ? NULL : (__temp677 = (g_object_unref (__temp677), NULL)));
				__temp678 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp678 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), vala_method_get_name (m))), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_method_get_real_cname (m))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
				(__temp678 == NULL ? NULL : (__temp678 = (g_object_unref (__temp678), NULL)));
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
				(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
			}
		}
	}
	{
		GList* __temp692;
		GList* type_param_it;
		__temp692 = NULL;
		__temp692 = vala_class_get_type_parameters (cl);
		for (type_param_it = __temp692; type_param_it != NULL; type_param_it = type_param_it->next) {
			ValaTypeParameter* type_param;
			type_param = type_param_it->data;
			{
				char* __temp680;
				char* __temp681;
				char* func_name;
				char* __temp682;
				ValaCCodeConstant* __temp683;
				ValaCCodeConstant* func_name_constant;
				char* __temp685;
				char* __temp684;
				char* __temp686;
				char* enum_value;
				ValaCCodeFunctionCall* cinst;
				ValaCCodeConstant* __temp687;
				ValaCCodeFunctionCall* cspec;
				ValaCCodeConstant* __temp688;
				ValaCCodeConstant* __temp689;
				ValaCCodeConstant* __temp690;
				ValaCCodeExpressionStatement* __temp691;
				/* create destroy_func properties for generic types */
				__temp680 = NULL;
				__temp681 = NULL;
				func_name = (__temp681 = g_strdup_printf ("%s_destroy_func", (__temp680 = g_utf8_strdown (vala_type_parameter_get_name (type_param), -1))), (__temp680 = (g_free (__temp680), NULL)), __temp681);
				__temp682 = NULL;
				__temp683 = NULL;
				func_name_constant = (__temp683 = vala_ccode_constant_new (g_strdup_printf ("\"%s-destroy-func\"", (__temp682 = g_utf8_strdown (vala_type_parameter_get_name (type_param), -1)))), (__temp682 = (g_free (__temp682), NULL)), __temp683);
				__temp685 = NULL;
				__temp684 = NULL;
				__temp686 = NULL;
				enum_value = (__temp686 = g_utf8_strup ((__temp685 = g_strdup_printf ("%s_%s", (__temp684 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL)), func_name)), -1), (__temp685 = (g_free (__temp685), NULL)), (__temp684 = (g_free (__temp684), NULL)), __temp686);
				cinst = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_class_install_property")));
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
				__temp687 = NULL;
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp687 = vala_ccode_constant_new (enum_value))));
				(__temp687 == NULL ? NULL : (__temp687 = (g_object_unref (__temp687), NULL)));
				cspec = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_param_spec_pointer")));
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (func_name_constant));
				__temp688 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp688 = vala_ccode_constant_new ("\"destroy func\""))));
				(__temp688 == NULL ? NULL : (__temp688 = (g_object_unref (__temp688), NULL)));
				__temp689 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp689 = vala_ccode_constant_new ("\"destroy func\""))));
				(__temp689 == NULL ? NULL : (__temp689 = (g_object_unref (__temp689), NULL)));
				__temp690 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp690 = vala_ccode_constant_new ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY"))));
				(__temp690 == NULL ? NULL : (__temp690 = (g_object_unref (__temp690), NULL)));
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (cspec));
				__temp691 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp691 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
				(__temp691 == NULL ? NULL : (__temp691 = (g_object_unref (__temp691), NULL)));
				vala_ccode_enum_add_value (self->priv->prop_enum, enum_value, NULL);
				vala_ccode_struct_add_field (self->priv->instance_priv_struct, "GDestroyNotify", func_name);
				(func_name = (g_free (func_name), NULL));
				(func_name_constant == NULL ? NULL : (func_name_constant = (g_object_unref (func_name_constant), NULL)));
				(enum_value = (g_free (enum_value), NULL));
				(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
				(cspec == NULL ? NULL : (cspec = (g_object_unref (cspec), NULL)));
			}
		}
		(__temp692 == NULL ? NULL : (__temp692 = (g_list_free (__temp692), NULL)));
	}
	/* create properties */
	props = vala_class_get_properties (cl);
	{
		GList* __temp699;
		GList* prop_it;
		__temp699 = NULL;
		__temp699 = props;
		for (prop_it = __temp699; prop_it != NULL; prop_it = prop_it->next) {
			ValaProperty* prop;
			prop = prop_it->data;
			{
				if (vala_property_get_overrides (prop) || vala_property_get_base_interface_property (prop) != NULL) {
					ValaCCodeFunctionCall* cinst;
					ValaCCodeConstant* __temp693;
					ValaCCodeConstant* __temp694;
					ValaCCodeExpressionStatement* __temp695;
					cinst = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_class_override_property")));
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
					__temp693 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp693 = vala_ccode_constant_new (vala_property_get_upper_case_cname (prop)))));
					(__temp693 == NULL ? NULL : (__temp693 = (g_object_unref (__temp693), NULL)));
					__temp694 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp694 = vala_property_get_canonical_cconstant (prop))));
					(__temp694 = (g_object_unref (__temp694), NULL));
					__temp695 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp695 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
					(__temp695 == NULL ? NULL : (__temp695 = (g_object_unref (__temp695), NULL)));
					(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
				} else {
					ValaCCodeFunctionCall* cinst;
					ValaCCodeConstant* __temp696;
					ValaCCodeFunctionCall* __temp697;
					ValaCCodeExpressionStatement* __temp698;
					cinst = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_class_install_property")));
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
					__temp696 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp696 = vala_ccode_constant_new (vala_property_get_upper_case_cname (prop)))));
					(__temp696 == NULL ? NULL : (__temp696 = (g_object_unref (__temp696), NULL)));
					__temp697 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp697 = vala_code_generator_get_param_spec (self, prop))));
					(__temp697 = (g_object_unref (__temp697), NULL));
					__temp698 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp698 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
					(__temp698 == NULL ? NULL : (__temp698 = (g_object_unref (__temp698), NULL)));
					(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
				}
			}
		}
	}
	{
		GList* __temp701;
		GList* sig_it;
		__temp701 = NULL;
		__temp701 = vala_class_get_signals (cl);
		for (sig_it = __temp701; sig_it != NULL; sig_it = sig_it->next) {
			ValaSignal* sig;
			sig = sig_it->data;
			{
				ValaCCodeExpressionStatement* __temp700;
				/* create signals */
				__temp700 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp700 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_generator_get_signal_creation (self, sig, VALA_DATA_TYPE (cl)))))));
				(__temp700 == NULL ? NULL : (__temp700 = (g_object_unref (__temp700), NULL)));
			}
		}
		(__temp701 == NULL ? NULL : (__temp701 = (g_list_free (__temp701), NULL)));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (class_init));
	(class_init == NULL ? NULL : (class_init = (g_object_unref (class_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(parent_decl == NULL ? NULL : (parent_decl = (g_object_unref (parent_decl), NULL)));
	(parent_var_decl == NULL ? NULL : (parent_var_decl = (g_object_unref (parent_var_decl), NULL)));
	(parent_assignment == NULL ? NULL : (parent_assignment = (g_object_unref (parent_assignment), NULL)));
	(methods == NULL ? NULL : (methods = (g_list_free (methods), NULL)));
	(props == NULL ? NULL : (props = (g_list_free (props), NULL)));
}


static void vala_code_generator_add_interface_init_function (ValaCodeGenerator* self, ValaClass* cl, ValaInterface* iface)
{
	char* __temp703;
	char* __temp702;
	ValaCCodeFunction* __temp704;
	ValaCCodeFunction* iface_init;
	ValaCCodeFormalParameter* __temp706;
	char* __temp705;
	ValaCCodeBlock* init_block;
	ValaCCodeFunctionCall* ccall;
	char* __temp708;
	char* __temp707;
	char* __temp709;
	char* parent_iface_var;
	char* __temp710;
	ValaCCodeDeclaration* __temp711;
	ValaCCodeDeclaration* parent_decl;
	ValaCCodeVariableDeclarator* parent_var_decl;
	ValaCCodeConstant* __temp712;
	ValaCCodeFunctionCall* __temp713;
	ValaCCodeIdentifier* __temp714;
	ValaCCodeAssignment* parent_assignment;
	ValaCCodeExpressionStatement* __temp715;
	GList* methods;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	__temp703 = NULL;
	__temp702 = NULL;
	__temp704 = NULL;
	iface_init = (__temp704 = vala_ccode_function_new (g_strdup_printf ("%s_%s_interface_init", (__temp702 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL)), (__temp703 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (iface), NULL))), "void"), (__temp703 = (g_free (__temp703), NULL)), (__temp702 = (g_free (__temp702), NULL)), __temp704);
	__temp706 = NULL;
	__temp705 = NULL;
	vala_ccode_function_add_parameter (iface_init, (__temp706 = vala_ccode_formal_parameter_new ("iface", g_strdup_printf ("%s *", (__temp705 = vala_interface_get_type_cname (iface))))));
	(__temp706 == NULL ? NULL : (__temp706 = (g_object_unref (__temp706), NULL)));
	(__temp705 = (g_free (__temp705), NULL));
	(vala_ccode_function_set_modifiers (iface_init, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (iface_init));
	init_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	(vala_ccode_function_set_block (iface_init, init_block), vala_ccode_function_get_block (iface_init));
	ccall = NULL;
	/* save pointer to parent vtable */
	__temp708 = NULL;
	__temp707 = NULL;
	__temp709 = NULL;
	parent_iface_var = (__temp709 = g_strdup_printf ("%s_%s_parent_iface", (__temp707 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL)), (__temp708 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (iface), NULL))), (__temp708 = (g_free (__temp708), NULL)), (__temp707 = (g_free (__temp707), NULL)), __temp709);
	__temp710 = NULL;
	__temp711 = NULL;
	parent_decl = (__temp711 = vala_ccode_declaration_new (g_strconcat ((__temp710 = vala_interface_get_type_cname (iface)), "*", NULL)), (__temp710 = (g_free (__temp710), NULL)), __temp711);
	parent_var_decl = vala_ccode_variable_declarator_new (parent_iface_var);
	__temp712 = NULL;
	(vala_ccode_variable_declarator_set_initializer (parent_var_decl, VALA_CCODE_EXPRESSION ((__temp712 = vala_ccode_constant_new ("NULL")))), vala_ccode_variable_declarator_get_initializer (parent_var_decl));
	(__temp712 == NULL ? NULL : (__temp712 = (g_object_unref (__temp712), NULL)));
	vala_ccode_declaration_add_declarator (parent_decl, VALA_CCODE_DECLARATOR (parent_var_decl));
	(vala_ccode_declaration_set_modifiers (parent_decl, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_declaration_get_modifiers (parent_decl));
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE (parent_decl));
	__temp713 = NULL;
	ccall = (__temp713 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_interface_peek_parent"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp713);
	__temp714 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp714 = vala_ccode_identifier_new ("iface"))));
	(__temp714 == NULL ? NULL : (__temp714 = (g_object_unref (__temp714), NULL)));
	parent_assignment = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (parent_iface_var)), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	__temp715 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp715 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (parent_assignment)))));
	(__temp715 == NULL ? NULL : (__temp715 = (g_object_unref (__temp715), NULL)));
	methods = vala_class_get_methods (cl);
	{
		GList* __temp718;
		GList* m_it;
		__temp718 = NULL;
		__temp718 = methods;
		for (m_it = __temp718; m_it != NULL; m_it = m_it->next) {
			ValaMethod* m;
			m = m_it->data;
			{
				ValaCodeNode* __temp716;
				ValaCodeNode* base_type;
				ValaCCodeIdentifier* ciface;
				ValaCCodeExpressionStatement* __temp717;
				if (vala_method_get_base_interface_method (m) == NULL) {
					continue;
				}
				__temp716 = NULL;
				base_type = (__temp716 = vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (vala_method_get_base_interface_method (m))))), (__temp716 == NULL ? NULL : g_object_ref (__temp716)));
				if (base_type != VALA_CODE_NODE (iface)) {
					continue;
				}
				ciface = vala_ccode_identifier_new ("iface");
				__temp717 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp717 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ciface), vala_method_get_name (m))), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_method_get_real_cname (m))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
				(__temp717 == NULL ? NULL : (__temp717 = (g_object_unref (__temp717), NULL)));
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
				(ciface == NULL ? NULL : (ciface = (g_object_unref (ciface), NULL)));
			}
		}
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (iface_init));
	(iface_init == NULL ? NULL : (iface_init = (g_object_unref (iface_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(parent_iface_var = (g_free (parent_iface_var), NULL));
	(parent_decl == NULL ? NULL : (parent_decl = (g_object_unref (parent_decl), NULL)));
	(parent_var_decl == NULL ? NULL : (parent_var_decl = (g_object_unref (parent_var_decl), NULL)));
	(parent_assignment == NULL ? NULL : (parent_assignment = (g_object_unref (parent_assignment), NULL)));
	(methods == NULL ? NULL : (methods = (g_list_free (methods), NULL)));
}


static void vala_code_generator_add_instance_init_function (ValaCodeGenerator* self, ValaClass* cl)
{
	char* __temp719;
	ValaCCodeFunction* __temp720;
	ValaCCodeFunction* instance_init;
	ValaCCodeFormalParameter* __temp722;
	char* __temp721;
	ValaCCodeBlock* init_block;
	ValaSymbol* init_sym;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	__temp719 = NULL;
	__temp720 = NULL;
	instance_init = (__temp720 = vala_ccode_function_new (g_strdup_printf ("%s_init", (__temp719 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))), "void"), (__temp719 = (g_free (__temp719), NULL)), __temp720);
	__temp722 = NULL;
	__temp721 = NULL;
	vala_ccode_function_add_parameter (instance_init, (__temp722 = vala_ccode_formal_parameter_new ("self", g_strdup_printf ("%s *", (__temp721 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))))));
	(__temp722 == NULL ? NULL : (__temp722 = (g_object_unref (__temp722), NULL)));
	(__temp721 = (g_free (__temp721), NULL));
	(vala_ccode_function_set_modifiers (instance_init, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (instance_init));
	init_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	(vala_ccode_function_set_block (instance_init, init_block), vala_ccode_function_get_block (instance_init));
	if (vala_class_get_has_private_fields (cl)) {
		char* __temp723;
		ValaCCodeFunctionCall* __temp724;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* __temp725;
		ValaCCodeExpressionStatement* __temp726;
		__temp723 = NULL;
		__temp724 = NULL;
		ccall = (__temp724 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_GET_PRIVATE", (__temp723 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))), (__temp723 = (g_free (__temp723), NULL)), __temp724);
		__temp725 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp725 = vala_ccode_identifier_new ("self"))));
		(__temp725 == NULL ? NULL : (__temp725 = (g_object_unref (__temp725), NULL)));
		__temp726 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp726 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), "priv")), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
		(__temp726 == NULL ? NULL : (__temp726 = (g_object_unref (__temp726), NULL)));
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	}
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE (self->priv->instance_init_fragment));
	init_sym = vala_symbol_lookup (vala_code_node_get_symbol (VALA_CODE_NODE (cl)), "init");
	if (init_sym != NULL) {
		ValaMethod* __temp727;
		ValaMethod* init_fun;
		__temp727 = NULL;
		init_fun = (__temp727 = VALA_METHOD (vala_symbol_get_node (init_sym)), (__temp727 == NULL ? NULL : g_object_ref (__temp727)));
		vala_ccode_block_add_statement (init_block, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_method_get_body (init_fun))));
		(init_fun == NULL ? NULL : (init_fun = (g_object_unref (init_fun), NULL)));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (instance_init));
	(instance_init == NULL ? NULL : (instance_init = (g_object_unref (instance_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(init_sym == NULL ? NULL : (init_sym = (g_object_unref (init_sym), NULL)));
}


static void vala_code_generator_add_dispose_function (ValaCodeGenerator* self, ValaClass* cl)
{
	ValaCCodeFunction* __temp729;
	char* __temp728;
	ValaCCodeFormalParameter* __temp730;
	ValaCCodeFunction* __temp731;
	ValaCCodeBlock* cblock;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* __temp732;
	char* __temp733;
	ValaCCodeDeclaration* __temp734;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* __temp735;
	ValaCCodeDeclaration* __temp737;
	char* __temp736;
	ValaCCodeVariableDeclarator* __temp738;
	ValaCCodeDeclaration* __temp739;
	ValaCCodeVariableDeclarator* __temp740;
	ValaCCodeFunctionCall* __temp741;
	ValaCCodeIdentifier* __temp742;
	char* __temp743;
	ValaCCodeFunctionCall* __temp744;
	ValaCCodeFunctionCall* ccast;
	ValaCCodeExpressionStatement* __temp745;
	ValaCCodeFunctionCall* __temp746;
	ValaCCodeIdentifier* __temp747;
	ValaCCodeFunctionCall* __temp748;
	ValaCCodeExpressionStatement* __temp749;
	ValaCCodeFunctionCall* __temp750;
	ValaCCodeIdentifier* __temp751;
	ValaCCodeExpressionStatement* __temp752;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	__temp729 = NULL;
	__temp728 = NULL;
	self->priv->function = (__temp729 = vala_ccode_function_new (g_strdup_printf ("%s_dispose", (__temp728 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))), "void"), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp729);
	(__temp728 = (g_free (__temp728), NULL));
	(vala_ccode_function_set_modifiers (self->priv->function, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (self->priv->function));
	__temp730 = NULL;
	vala_ccode_function_add_parameter (self->priv->function, (__temp730 = vala_ccode_formal_parameter_new ("obj", "GObject *")));
	(__temp730 == NULL ? NULL : (__temp730 = (g_object_unref (__temp730), NULL)));
	__temp731 = NULL;
	vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((__temp731 = vala_ccode_function_copy (self->priv->function))));
	(__temp731 = (g_object_unref (__temp731), NULL));
	cblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL))));
	__temp732 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp732 = vala_ccode_identifier_new ("obj"))));
	(__temp732 == NULL ? NULL : (__temp732 = (g_object_unref (__temp732), NULL)));
	__temp733 = NULL;
	__temp734 = NULL;
	cdecl_ = (__temp734 = vala_ccode_declaration_new (g_strdup_printf ("%s *", (__temp733 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (__temp733 = (g_free (__temp733), NULL)), __temp734);
	__temp735 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp735 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(__temp735 == NULL ? NULL : (__temp735 = (g_object_unref (__temp735), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (self->priv->instance_dispose_fragment));
	__temp737 = NULL;
	__temp736 = NULL;
	cdecl_ = (__temp737 = vala_ccode_declaration_new (g_strdup_printf ("%sClass *", (__temp736 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), __temp737);
	(__temp736 = (g_free (__temp736), NULL));
	__temp738 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp738 = vala_ccode_variable_declarator_new ("klass"))));
	(__temp738 == NULL ? NULL : (__temp738 = (g_object_unref (__temp738), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	__temp739 = NULL;
	cdecl_ = (__temp739 = vala_ccode_declaration_new ("GObjectClass *"), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), __temp739);
	__temp740 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp740 = vala_ccode_variable_declarator_new ("parent_class"))));
	(__temp740 == NULL ? NULL : (__temp740 = (g_object_unref (__temp740), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	__temp741 = NULL;
	ccall = (__temp741 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_class_peek"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp741);
	__temp742 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp742 = vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), "TYPE_")))));
	(__temp742 == NULL ? NULL : (__temp742 = (g_object_unref (__temp742), NULL)));
	__temp743 = NULL;
	__temp744 = NULL;
	ccast = (__temp744 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_CLASS", (__temp743 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))), (__temp743 = (g_free (__temp743), NULL)), __temp744);
	vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (ccall));
	__temp745 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp745 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("klass")), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp745 == NULL ? NULL : (__temp745 = (g_object_unref (__temp745), NULL)));
	__temp746 = NULL;
	ccall = (__temp746 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_class_peek_parent"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp746);
	__temp747 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp747 = vala_ccode_identifier_new ("klass"))));
	(__temp747 == NULL ? NULL : (__temp747 = (g_object_unref (__temp747), NULL)));
	__temp748 = NULL;
	ccast = (__temp748 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT_CLASS"))), (ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL))), __temp748);
	vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (ccall));
	__temp749 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp749 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("parent_class")), VALA_CCODE_EXPRESSION (ccast), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp749 == NULL ? NULL : (__temp749 = (g_object_unref (__temp749), NULL)));
	__temp750 = NULL;
	ccall = (__temp750 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("parent_class")), "dispose"))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp750);
	__temp751 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp751 = vala_ccode_identifier_new ("obj"))));
	(__temp751 == NULL ? NULL : (__temp751 = (g_object_unref (__temp751), NULL)));
	__temp752 = NULL;
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((__temp752 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
	(__temp752 == NULL ? NULL : (__temp752 = (g_object_unref (__temp752), NULL)));
	(vala_ccode_function_set_block (self->priv->function, cblock), vala_ccode_function_get_block (self->priv->function));
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
	(cblock == NULL ? NULL : (cblock = (g_object_unref (cblock), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
}


static ValaCCodeIdentifier* vala_code_generator_get_value_setter_function (ValaCodeGenerator* self, ValaTypeReference* type_reference)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type_reference), NULL);
	if (VALA_IS_CLASS (vala_type_reference_get_data_type (type_reference)) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (type_reference))) {
		return vala_ccode_identifier_new ("g_value_set_object");
	} else {
		if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->string_type)) {
			return vala_ccode_identifier_new ("g_value_set_string");
		} else {
			if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->int_type) || VALA_IS_ENUM (vala_type_reference_get_data_type (type_reference))) {
				return vala_ccode_identifier_new ("g_value_set_int");
			} else {
				if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->uint_type)) {
					return vala_ccode_identifier_new ("g_value_set_uint");
				} else {
					if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->long_type)) {
						return vala_ccode_identifier_new ("g_value_set_long");
					} else {
						if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->ulong_type)) {
							return vala_ccode_identifier_new ("g_value_set_ulong");
						} else {
							if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->bool_type)) {
								return vala_ccode_identifier_new ("g_value_set_boolean");
							} else {
								if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->float_type)) {
									return vala_ccode_identifier_new ("g_value_set_float");
								} else {
									if (vala_type_reference_get_data_type (type_reference) == vala_type_reference_get_data_type (self->priv->double_type)) {
										return vala_ccode_identifier_new ("g_value_set_double");
									} else {
										return vala_ccode_identifier_new ("g_value_set_pointer");
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static gboolean vala_code_generator_class_has_readable_properties (ValaCodeGenerator* self, ValaClass* cl)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (VALA_IS_CLASS (cl), FALSE);
	{
		GList* __temp764;
		GList* prop_it;
		__temp764 = NULL;
		__temp764 = vala_class_get_properties (cl);
		for (prop_it = __temp764; prop_it != NULL; prop_it = prop_it->next) {
			ValaProperty* prop;
			prop = prop_it->data;
			{
				if (vala_property_get_get_accessor (prop) != NULL && !vala_property_get_is_abstract (prop)) {
					return TRUE;
				}
			}
		}
		(__temp764 == NULL ? NULL : (__temp764 = (g_list_free (__temp764), NULL)));
	}
	return FALSE;
}


static gboolean vala_code_generator_class_has_writable_properties (ValaCodeGenerator* self, ValaClass* cl)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (VALA_IS_CLASS (cl), FALSE);
	{
		GList* __temp767;
		GList* prop_it;
		__temp767 = NULL;
		__temp767 = vala_class_get_properties (cl);
		for (prop_it = __temp767; prop_it != NULL; prop_it = prop_it->next) {
			ValaProperty* prop;
			prop = prop_it->data;
			{
				if (vala_property_get_set_accessor (prop) != NULL && !vala_property_get_is_abstract (prop)) {
					return TRUE;
				}
			}
		}
		(__temp767 == NULL ? NULL : (__temp767 = (g_list_free (__temp767), NULL)));
	}
	return FALSE;
}


static void vala_code_generator_add_get_property_function (ValaCodeGenerator* self, ValaClass* cl)
{
	char* __temp769;
	ValaCCodeFunction* __temp770;
	ValaCCodeFunction* get_prop;
	ValaCCodeFormalParameter* __temp771;
	ValaCCodeFormalParameter* __temp772;
	ValaCCodeFormalParameter* __temp773;
	ValaCCodeFormalParameter* __temp774;
	ValaCCodeBlock* block;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* __temp775;
	char* __temp776;
	ValaCCodeDeclaration* __temp777;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* __temp778;
	ValaCCodeSwitchStatement* cswitch;
	GList* props;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	__temp769 = NULL;
	__temp770 = NULL;
	get_prop = (__temp770 = vala_ccode_function_new (g_strdup_printf ("%s_get_property", (__temp769 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))), "void"), (__temp769 = (g_free (__temp769), NULL)), __temp770);
	(vala_ccode_function_set_modifiers (get_prop, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (get_prop));
	__temp771 = NULL;
	vala_ccode_function_add_parameter (get_prop, (__temp771 = vala_ccode_formal_parameter_new ("object", "GObject *")));
	(__temp771 == NULL ? NULL : (__temp771 = (g_object_unref (__temp771), NULL)));
	__temp772 = NULL;
	vala_ccode_function_add_parameter (get_prop, (__temp772 = vala_ccode_formal_parameter_new ("property_id", "guint")));
	(__temp772 == NULL ? NULL : (__temp772 = (g_object_unref (__temp772), NULL)));
	__temp773 = NULL;
	vala_ccode_function_add_parameter (get_prop, (__temp773 = vala_ccode_formal_parameter_new ("value", "GValue *")));
	(__temp773 == NULL ? NULL : (__temp773 = (g_object_unref (__temp773), NULL)));
	__temp774 = NULL;
	vala_ccode_function_add_parameter (get_prop, (__temp774 = vala_ccode_formal_parameter_new ("pspec", "GParamSpec *")));
	(__temp774 == NULL ? NULL : (__temp774 = (g_object_unref (__temp774), NULL)));
	block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL))));
	__temp775 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp775 = vala_ccode_identifier_new ("object"))));
	(__temp775 == NULL ? NULL : (__temp775 = (g_object_unref (__temp775), NULL)));
	__temp776 = NULL;
	__temp777 = NULL;
	cdecl_ = (__temp777 = vala_ccode_declaration_new (g_strdup_printf ("%s *", (__temp776 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (__temp776 = (g_free (__temp776), NULL)), __temp777);
	__temp778 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp778 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(__temp778 == NULL ? NULL : (__temp778 = (g_object_unref (__temp778), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
	cswitch = vala_ccode_switch_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("property_id")));
	props = vala_class_get_properties (cl);
	{
		GList* __temp785;
		GList* prop_it;
		__temp785 = NULL;
		__temp785 = props;
		for (prop_it = __temp785; prop_it != NULL; prop_it = prop_it->next) {
			ValaProperty* prop;
			prop = prop_it->data;
			{
				gboolean is_virtual;
				char* prefix;
				ValaCCodeCaseStatement* ccase;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeIdentifier* __temp780;
				ValaCCodeFunctionCall* csetcall;
				ValaCCodeIdentifier* __temp781;
				ValaCCodeIdentifier* __temp782;
				ValaCCodeExpressionStatement* __temp783;
				ValaCCodeBreakStatement* __temp784;
				if (vala_property_get_get_accessor (prop) == NULL || vala_property_get_is_abstract (prop)) {
					continue;
				}
				is_virtual = vala_property_get_base_property (prop) != NULL || vala_property_get_base_interface_property (prop) != NULL;
				prefix = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL);
				if (is_virtual) {
					char* __temp779;
					__temp779 = NULL;
					prefix = (__temp779 = g_strconcat (prefix, ("_real"), NULL), (prefix = (g_free (prefix), NULL)), __temp779);
				}
				ccase = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_property_get_upper_case_cname (prop))));
				ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_get_%s", prefix, vala_property_get_name (prop)))));
				__temp780 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp780 = vala_ccode_identifier_new ("self"))));
				(__temp780 == NULL ? NULL : (__temp780 = (g_object_unref (__temp780), NULL)));
				csetcall = vala_ccode_function_call_new (NULL);
				__temp781 = NULL;
				(vala_ccode_function_call_set_call (csetcall, VALA_CCODE_EXPRESSION ((__temp781 = vala_code_generator_get_value_setter_function (self, vala_property_get_type_reference (prop))))), vala_ccode_function_call_get_call (csetcall));
				(__temp781 = (g_object_unref (__temp781), NULL));
				__temp782 = NULL;
				vala_ccode_function_call_add_argument (csetcall, VALA_CCODE_EXPRESSION ((__temp782 = vala_ccode_identifier_new ("value"))));
				(__temp782 == NULL ? NULL : (__temp782 = (g_object_unref (__temp782), NULL)));
				vala_ccode_function_call_add_argument (csetcall, VALA_CCODE_EXPRESSION (ccall));
				__temp783 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((__temp783 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (csetcall)))));
				(__temp783 == NULL ? NULL : (__temp783 = (g_object_unref (__temp783), NULL)));
				__temp784 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((__temp784 = g_object_new (VALA_TYPE_CCODE_BREAK_STATEMENT, NULL))));
				(__temp784 == NULL ? NULL : (__temp784 = (g_object_unref (__temp784), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				(prefix = (g_free (prefix), NULL));
				(ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL)));
				(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
				(csetcall == NULL ? NULL : (csetcall = (g_object_unref (csetcall), NULL)));
			}
		}
	}
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cswitch));
	(vala_ccode_function_set_block (get_prop, block), vala_ccode_function_get_block (get_prop));
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (get_prop));
	(get_prop == NULL ? NULL : (get_prop = (g_object_unref (get_prop), NULL)));
	(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(cswitch == NULL ? NULL : (cswitch = (g_object_unref (cswitch), NULL)));
	(props == NULL ? NULL : (props = (g_list_free (props), NULL)));
}


static void vala_code_generator_add_set_property_function (ValaCodeGenerator* self, ValaClass* cl)
{
	char* __temp786;
	ValaCCodeFunction* __temp787;
	ValaCCodeFunction* set_prop;
	ValaCCodeFormalParameter* __temp788;
	ValaCCodeFormalParameter* __temp789;
	ValaCCodeFormalParameter* __temp790;
	ValaCCodeFormalParameter* __temp791;
	ValaCCodeBlock* block;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* __temp792;
	char* __temp793;
	ValaCCodeDeclaration* __temp794;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* __temp795;
	ValaCCodeSwitchStatement* cswitch;
	GList* props;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	__temp786 = NULL;
	__temp787 = NULL;
	set_prop = (__temp787 = vala_ccode_function_new (g_strdup_printf ("%s_set_property", (__temp786 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL))), "void"), (__temp786 = (g_free (__temp786), NULL)), __temp787);
	(vala_ccode_function_set_modifiers (set_prop, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (set_prop));
	__temp788 = NULL;
	vala_ccode_function_add_parameter (set_prop, (__temp788 = vala_ccode_formal_parameter_new ("object", "GObject *")));
	(__temp788 == NULL ? NULL : (__temp788 = (g_object_unref (__temp788), NULL)));
	__temp789 = NULL;
	vala_ccode_function_add_parameter (set_prop, (__temp789 = vala_ccode_formal_parameter_new ("property_id", "guint")));
	(__temp789 == NULL ? NULL : (__temp789 = (g_object_unref (__temp789), NULL)));
	__temp790 = NULL;
	vala_ccode_function_add_parameter (set_prop, (__temp790 = vala_ccode_formal_parameter_new ("value", "const GValue *")));
	(__temp790 == NULL ? NULL : (__temp790 = (g_object_unref (__temp790), NULL)));
	__temp791 = NULL;
	vala_ccode_function_add_parameter (set_prop, (__temp791 = vala_ccode_formal_parameter_new ("pspec", "GParamSpec *")));
	(__temp791 == NULL ? NULL : (__temp791 = (g_object_unref (__temp791), NULL)));
	block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL))));
	__temp792 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp792 = vala_ccode_identifier_new ("object"))));
	(__temp792 == NULL ? NULL : (__temp792 = (g_object_unref (__temp792), NULL)));
	__temp793 = NULL;
	__temp794 = NULL;
	cdecl_ = (__temp794 = vala_ccode_declaration_new (g_strdup_printf ("%s *", (__temp793 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (__temp793 = (g_free (__temp793), NULL)), __temp794);
	__temp795 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp795 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(__temp795 == NULL ? NULL : (__temp795 = (g_object_unref (__temp795), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
	cswitch = vala_ccode_switch_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("property_id")));
	props = vala_class_get_properties (cl);
	{
		GList* __temp811;
		GList* prop_it;
		__temp811 = NULL;
		__temp811 = props;
		for (prop_it = __temp811; prop_it != NULL; prop_it = prop_it->next) {
			ValaProperty* prop;
			prop = prop_it->data;
			{
				gboolean is_virtual;
				char* prefix;
				ValaCCodeCaseStatement* ccase;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeIdentifier* __temp797;
				ValaCCodeFunctionCall* cgetcall;
				ValaCCodeIdentifier* __temp808;
				ValaCCodeExpressionStatement* __temp809;
				ValaCCodeBreakStatement* __temp810;
				if (vala_property_get_set_accessor (prop) == NULL || vala_property_get_is_abstract (prop)) {
					continue;
				}
				is_virtual = vala_property_get_base_property (prop) != NULL || vala_property_get_base_interface_property (prop) != NULL;
				prefix = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL);
				if (is_virtual) {
					char* __temp796;
					__temp796 = NULL;
					prefix = (__temp796 = g_strconcat (prefix, ("_real"), NULL), (prefix = (g_free (prefix), NULL)), __temp796);
				}
				ccase = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_property_get_upper_case_cname (prop))));
				ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_set_%s", prefix, vala_property_get_name (prop)))));
				__temp797 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp797 = vala_ccode_identifier_new ("self"))));
				(__temp797 == NULL ? NULL : (__temp797 = (g_object_unref (__temp797), NULL)));
				cgetcall = vala_ccode_function_call_new (NULL);
				if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_property_get_type_reference (prop))) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)))) {
					ValaCCodeIdentifier* __temp798;
					__temp798 = NULL;
					(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp798 = vala_ccode_identifier_new ("g_value_get_object")))), vala_ccode_function_call_get_call (cgetcall));
					(__temp798 == NULL ? NULL : (__temp798 = (g_object_unref (__temp798), NULL)));
				} else {
					if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "string") == 0) {
						ValaCCodeIdentifier* __temp799;
						__temp799 = NULL;
						(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp799 = vala_ccode_identifier_new ("g_value_get_string")))), vala_ccode_function_call_get_call (cgetcall));
						(__temp799 == NULL ? NULL : (__temp799 = (g_object_unref (__temp799), NULL)));
					} else {
						if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "int") == 0 || VALA_IS_ENUM (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)))) {
							ValaCCodeIdentifier* __temp800;
							__temp800 = NULL;
							(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp800 = vala_ccode_identifier_new ("g_value_get_int")))), vala_ccode_function_call_get_call (cgetcall));
							(__temp800 == NULL ? NULL : (__temp800 = (g_object_unref (__temp800), NULL)));
						} else {
							if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "uint") == 0) {
								ValaCCodeIdentifier* __temp801;
								__temp801 = NULL;
								(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp801 = vala_ccode_identifier_new ("g_value_get_uint")))), vala_ccode_function_call_get_call (cgetcall));
								(__temp801 == NULL ? NULL : (__temp801 = (g_object_unref (__temp801), NULL)));
							} else {
								if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "long") == 0) {
									ValaCCodeIdentifier* __temp802;
									__temp802 = NULL;
									(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp802 = vala_ccode_identifier_new ("g_value_get_long")))), vala_ccode_function_call_get_call (cgetcall));
									(__temp802 == NULL ? NULL : (__temp802 = (g_object_unref (__temp802), NULL)));
								} else {
									if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "ulong") == 0) {
										ValaCCodeIdentifier* __temp803;
										__temp803 = NULL;
										(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp803 = vala_ccode_identifier_new ("g_value_get_ulong")))), vala_ccode_function_call_get_call (cgetcall));
										(__temp803 == NULL ? NULL : (__temp803 = (g_object_unref (__temp803), NULL)));
									} else {
										if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "bool") == 0) {
											ValaCCodeIdentifier* __temp804;
											__temp804 = NULL;
											(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp804 = vala_ccode_identifier_new ("g_value_get_boolean")))), vala_ccode_function_call_get_call (cgetcall));
											(__temp804 == NULL ? NULL : (__temp804 = (g_object_unref (__temp804), NULL)));
										} else {
											if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "float") == 0) {
												ValaCCodeIdentifier* __temp805;
												__temp805 = NULL;
												(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp805 = vala_ccode_identifier_new ("g_value_get_float")))), vala_ccode_function_call_get_call (cgetcall));
												(__temp805 == NULL ? NULL : (__temp805 = (g_object_unref (__temp805), NULL)));
											} else {
												if (g_utf8_collate (vala_type_reference_get_type_name (vala_property_get_type_reference (prop)), "double") == 0) {
													ValaCCodeIdentifier* __temp806;
													__temp806 = NULL;
													(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp806 = vala_ccode_identifier_new ("g_value_get_double")))), vala_ccode_function_call_get_call (cgetcall));
													(__temp806 == NULL ? NULL : (__temp806 = (g_object_unref (__temp806), NULL)));
												} else {
													ValaCCodeIdentifier* __temp807;
													__temp807 = NULL;
													(vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((__temp807 = vala_ccode_identifier_new ("g_value_get_pointer")))), vala_ccode_function_call_get_call (cgetcall));
													(__temp807 == NULL ? NULL : (__temp807 = (g_object_unref (__temp807), NULL)));
												}
											}
										}
									}
								}
							}
						}
					}
				}
				__temp808 = NULL;
				vala_ccode_function_call_add_argument (cgetcall, VALA_CCODE_EXPRESSION ((__temp808 = vala_ccode_identifier_new ("value"))));
				(__temp808 == NULL ? NULL : (__temp808 = (g_object_unref (__temp808), NULL)));
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (cgetcall));
				__temp809 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((__temp809 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
				(__temp809 == NULL ? NULL : (__temp809 = (g_object_unref (__temp809), NULL)));
				__temp810 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((__temp810 = g_object_new (VALA_TYPE_CCODE_BREAK_STATEMENT, NULL))));
				(__temp810 == NULL ? NULL : (__temp810 = (g_object_unref (__temp810), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				(prefix = (g_free (prefix), NULL));
				(ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL)));
				(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
				(cgetcall == NULL ? NULL : (cgetcall = (g_object_unref (cgetcall), NULL)));
			}
		}
	}
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cswitch));
	{
		GList* __temp820;
		GList* type_param_it;
		__temp820 = NULL;
		__temp820 = vala_class_get_type_parameters (cl);
		for (type_param_it = __temp820; type_param_it != NULL; type_param_it = type_param_it->next) {
			ValaTypeParameter* type_param;
			type_param = type_param_it->data;
			{
				char* __temp812;
				char* __temp813;
				char* func_name;
				char* __temp815;
				char* __temp814;
				char* __temp816;
				char* enum_value;
				ValaCCodeCaseStatement* ccase;
				ValaCCodeMemberAccess* cfield;
				ValaCCodeFunctionCall* cgetcall;
				ValaCCodeIdentifier* __temp817;
				ValaCCodeExpressionStatement* __temp818;
				ValaCCodeBreakStatement* __temp819;
				/* destroy func properties for generic types */
				__temp812 = NULL;
				__temp813 = NULL;
				func_name = (__temp813 = g_strdup_printf ("%s_destroy_func", (__temp812 = g_utf8_strdown (vala_type_parameter_get_name (type_param), -1))), (__temp812 = (g_free (__temp812), NULL)), __temp813);
				__temp815 = NULL;
				__temp814 = NULL;
				__temp816 = NULL;
				enum_value = (__temp816 = g_utf8_strup ((__temp815 = g_strdup_printf ("%s_%s", (__temp814 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (cl), NULL)), func_name)), -1), (__temp815 = (g_free (__temp815), NULL)), (__temp814 = (g_free (__temp814), NULL)), __temp816);
				ccase = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (enum_value)));
				cfield = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), "priv")), func_name);
				cgetcall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_value_get_pointer")));
				__temp817 = NULL;
				vala_ccode_function_call_add_argument (cgetcall, VALA_CCODE_EXPRESSION ((__temp817 = vala_ccode_identifier_new ("value"))));
				(__temp817 == NULL ? NULL : (__temp817 = (g_object_unref (__temp817), NULL)));
				__temp818 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((__temp818 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cfield), VALA_CCODE_EXPRESSION (cgetcall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
				(__temp818 == NULL ? NULL : (__temp818 = (g_object_unref (__temp818), NULL)));
				__temp819 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((__temp819 = g_object_new (VALA_TYPE_CCODE_BREAK_STATEMENT, NULL))));
				(__temp819 == NULL ? NULL : (__temp819 = (g_object_unref (__temp819), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				(func_name = (g_free (func_name), NULL));
				(enum_value = (g_free (enum_value), NULL));
				(ccase == NULL ? NULL : (ccase = (g_object_unref (ccase), NULL)));
				(cfield == NULL ? NULL : (cfield = (g_object_unref (cfield), NULL)));
				(cgetcall == NULL ? NULL : (cgetcall = (g_object_unref (cgetcall), NULL)));
			}
		}
		(__temp820 == NULL ? NULL : (__temp820 = (g_list_free (__temp820), NULL)));
	}
	(vala_ccode_function_set_block (set_prop, block), vala_ccode_function_get_block (set_prop));
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (set_prop));
	(set_prop == NULL ? NULL : (set_prop = (g_object_unref (set_prop), NULL)));
	(block == NULL ? NULL : (block = (g_object_unref (block), NULL)));
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(cswitch == NULL ? NULL : (cswitch = (g_object_unref (cswitch), NULL)));
	(props == NULL ? NULL : (props = (g_list_free (props), NULL)));
}


static void vala_code_generator_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface)
{
	ValaCodeGenerator * self;
	ValaSymbol* __temp822;
	ValaSymbol* __temp821;
	ValaSymbol* __temp824;
	ValaSymbol* __temp823;
	ValaSymbol* __temp852;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	__temp822 = NULL;
	__temp821 = NULL;
	self->priv->current_symbol = (__temp822 = (__temp821 = vala_code_node_get_symbol (VALA_CODE_NODE (iface)), (__temp821 == NULL ? NULL : g_object_ref (__temp821))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp822);
	__temp824 = NULL;
	__temp823 = NULL;
	self->priv->current_type_symbol = (__temp824 = (__temp823 = vala_code_node_get_symbol (VALA_CODE_NODE (iface)), (__temp823 == NULL ? NULL : g_object_ref (__temp823))), (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), __temp824);
	if (!vala_interface_get_is_static (iface)) {
		ValaCCodeStruct* __temp826;
		char* __temp825;
		ValaCCodeNewline* __temp827;
		char* __temp828;
		char* __temp829;
		char* macro;
		ValaCCodeMacroReplacement* __temp830;
		char* __temp833;
		char* __temp832;
		char* __temp831;
		ValaCCodeMacroReplacement* __temp835;
		char* __temp834;
		char* __temp837;
		char* __temp836;
		ValaCCodeMacroReplacement* __temp839;
		char* __temp838;
		char* __temp842;
		char* __temp841;
		char* __temp840;
		ValaCCodeMacroReplacement* __temp844;
		char* __temp843;
		ValaCCodeNewline* __temp845;
		__temp826 = NULL;
		__temp825 = NULL;
		self->priv->type_struct = (__temp826 = vala_ccode_struct_new (g_strdup_printf ("_%s", (__temp825 = vala_interface_get_type_cname (iface)))), (self->priv->type_struct == NULL ? NULL : (self->priv->type_struct = (g_object_unref (self->priv->type_struct), NULL))), __temp826);
		(__temp825 = (g_free (__temp825), NULL));
		__temp827 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp827 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
		(__temp827 == NULL ? NULL : (__temp827 = (g_object_unref (__temp827), NULL)));
		__temp828 = NULL;
		__temp829 = NULL;
		macro = (__temp829 = g_strdup_printf ("(%s_get_type ())", (__temp828 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (iface), NULL))), (__temp828 = (g_free (__temp828), NULL)), __temp829);
		__temp830 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp830 = vala_ccode_macro_replacement_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "TYPE_"), macro))));
		(__temp830 == NULL ? NULL : (__temp830 = (g_object_unref (__temp830), NULL)));
		__temp833 = NULL;
		__temp832 = NULL;
		__temp831 = NULL;
		macro = (__temp833 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_CAST ((obj), %s, %s))", (__temp831 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "TYPE_")), (__temp832 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE))), (macro = (g_free (macro), NULL)), __temp833);
		(__temp832 = (g_free (__temp832), NULL));
		(__temp831 = (g_free (__temp831), NULL));
		__temp835 = NULL;
		__temp834 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp835 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s(obj)", (__temp834 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), NULL))), macro))));
		(__temp835 == NULL ? NULL : (__temp835 = (g_object_unref (__temp835), NULL)));
		(__temp834 = (g_free (__temp834), NULL));
		__temp837 = NULL;
		__temp836 = NULL;
		macro = (__temp837 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_TYPE ((obj), %s))", (__temp836 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "TYPE_"))), (macro = (g_free (macro), NULL)), __temp837);
		(__temp836 = (g_free (__temp836), NULL));
		__temp839 = NULL;
		__temp838 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp839 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s(obj)", (__temp838 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "IS_"))), macro))));
		(__temp839 == NULL ? NULL : (__temp839 = (g_object_unref (__temp839), NULL)));
		(__temp838 = (g_free (__temp838), NULL));
		__temp842 = NULL;
		__temp841 = NULL;
		__temp840 = NULL;
		macro = (__temp842 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_INTERFACE ((obj), %s, %s))", (__temp840 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), "TYPE_")), (__temp841 = vala_interface_get_type_cname (iface))), (macro = (g_free (macro), NULL)), __temp842);
		(__temp841 = (g_free (__temp841), NULL));
		(__temp840 = (g_free (__temp840), NULL));
		__temp844 = NULL;
		__temp843 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp844 = vala_ccode_macro_replacement_new (g_strdup_printf ("%s_GET_INTERFACE(obj)", (__temp843 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), NULL))), macro))));
		(__temp844 == NULL ? NULL : (__temp844 = (g_object_unref (__temp844), NULL)));
		(__temp843 = (g_free (__temp843), NULL));
		__temp845 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp845 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
		(__temp845 == NULL ? NULL : (__temp845 = (g_object_unref (__temp845), NULL)));
		if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (iface)))) == NULL) {
			ValaCCodeTypeDefinition* __temp847;
			char* __temp846;
			ValaCCodeTypeDefinition* __temp848;
			__temp847 = NULL;
			__temp846 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp847 = vala_ccode_type_definition_new (g_strdup_printf ("struct _%s", (__temp846 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE))), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE)))))));
			(__temp847 == NULL ? NULL : (__temp847 = (g_object_unref (__temp847), NULL)));
			(__temp846 = (g_free (__temp846), NULL));
			__temp848 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp848 = vala_ccode_type_definition_new (g_strdup_printf ("struct %s", vala_ccode_struct_get_name (self->priv->type_struct)), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (vala_interface_get_type_cname (iface)))))));
			(__temp848 == NULL ? NULL : (__temp848 = (g_object_unref (__temp848), NULL)));
		}
		vala_ccode_struct_add_field (self->priv->type_struct, "GTypeInterface", "parent");
		if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (iface))) != NULL) {
			ValaCCodeComment* __temp849;
			__temp849 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE ((__temp849 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (iface)))))));
			(__temp849 == NULL ? NULL : (__temp849 = (g_object_unref (__temp849), NULL)));
		}
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (self->priv->type_struct));
		(macro = (g_free (macro), NULL));
	}
	vala_code_node_accept_children (VALA_CODE_NODE (iface), VALA_CODE_VISITOR (self));
	if (!vala_interface_get_is_static (iface)) {
		ValaInterfaceRegisterFunction* type_fun;
		ValaCCodeFragment* __temp850;
		ValaCCodeFragment* __temp851;
		vala_code_generator_add_interface_base_init_function (self, iface);
		type_fun = vala_interface_register_function_new (iface);
		vala_type_register_function_init_from_type (VALA_TYPE_REGISTER_FUNCTION (type_fun), FALSE);
		__temp850 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp850 = vala_type_register_function_get_declaration (VALA_TYPE_REGISTER_FUNCTION (type_fun)))));
		(__temp850 = (g_object_unref (__temp850), NULL));
		__temp851 = NULL;
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE ((__temp851 = vala_type_register_function_get_definition (VALA_TYPE_REGISTER_FUNCTION (type_fun)))));
		(__temp851 = (g_object_unref (__temp851), NULL));
		(type_fun == NULL ? NULL : (type_fun = (g_object_unref (type_fun), NULL)));
	}
	__temp852 = NULL;
	self->priv->current_type_symbol = (__temp852 = NULL, (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), __temp852);
}


static ValaCCodeFunctionCall* vala_code_generator_get_param_spec (ValaCodeGenerator* self, ValaProperty* prop)
{
	ValaCCodeFunctionCall* cspec;
	ValaCCodeConstant* __temp853;
	ValaCCodeConstant* __temp854;
	ValaCCodeConstant* __temp855;
	char* pflags;
	ValaCCodeConstant* __temp891;
	ValaCCodeFunctionCall* __temp892;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_PROPERTY (prop), NULL);
	cspec = vala_ccode_function_call_new (NULL);
	__temp853 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp853 = vala_property_get_canonical_cconstant (prop))));
	(__temp853 = (g_object_unref (__temp853), NULL));
	__temp854 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp854 = vala_ccode_constant_new ("\"foo\""))));
	(__temp854 == NULL ? NULL : (__temp854 = (g_object_unref (__temp854), NULL)));
	__temp855 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp855 = vala_ccode_constant_new ("\"bar\""))));
	(__temp855 == NULL ? NULL : (__temp855 = (g_object_unref (__temp855), NULL)));
	if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_property_get_type_reference (prop))) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)))) {
		ValaCCodeIdentifier* __temp856;
		ValaCCodeIdentifier* __temp857;
		__temp856 = NULL;
		(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp856 = vala_ccode_identifier_new ("g_param_spec_object")))), vala_ccode_function_call_get_call (cspec));
		(__temp856 == NULL ? NULL : (__temp856 = (g_object_unref (__temp856), NULL)));
		__temp857 = NULL;
		vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp857 = vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)), "TYPE_")))));
		(__temp857 == NULL ? NULL : (__temp857 = (g_object_unref (__temp857), NULL)));
	} else {
		if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->string_type)) {
			ValaCCodeIdentifier* __temp858;
			ValaCCodeConstant* __temp859;
			__temp858 = NULL;
			(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp858 = vala_ccode_identifier_new ("g_param_spec_string")))), vala_ccode_function_call_get_call (cspec));
			(__temp858 == NULL ? NULL : (__temp858 = (g_object_unref (__temp858), NULL)));
			__temp859 = NULL;
			vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp859 = vala_ccode_constant_new ("NULL"))));
			(__temp859 == NULL ? NULL : (__temp859 = (g_object_unref (__temp859), NULL)));
		} else {
			if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->int_type) || VALA_IS_ENUM (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)))) {
				ValaCCodeIdentifier* __temp860;
				ValaCCodeConstant* __temp861;
				ValaCCodeConstant* __temp862;
				ValaCCodeConstant* __temp863;
				__temp860 = NULL;
				(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp860 = vala_ccode_identifier_new ("g_param_spec_int")))), vala_ccode_function_call_get_call (cspec));
				(__temp860 == NULL ? NULL : (__temp860 = (g_object_unref (__temp860), NULL)));
				__temp861 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp861 = vala_ccode_constant_new ("G_MININT"))));
				(__temp861 == NULL ? NULL : (__temp861 = (g_object_unref (__temp861), NULL)));
				__temp862 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp862 = vala_ccode_constant_new ("G_MAXINT"))));
				(__temp862 == NULL ? NULL : (__temp862 = (g_object_unref (__temp862), NULL)));
				__temp863 = NULL;
				vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp863 = vala_ccode_constant_new ("0"))));
				(__temp863 == NULL ? NULL : (__temp863 = (g_object_unref (__temp863), NULL)));
			} else {
				if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->uint_type)) {
					ValaCCodeIdentifier* __temp864;
					ValaCCodeConstant* __temp865;
					ValaCCodeConstant* __temp866;
					ValaCCodeConstant* __temp867;
					__temp864 = NULL;
					(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp864 = vala_ccode_identifier_new ("g_param_spec_uint")))), vala_ccode_function_call_get_call (cspec));
					(__temp864 == NULL ? NULL : (__temp864 = (g_object_unref (__temp864), NULL)));
					__temp865 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp865 = vala_ccode_constant_new ("0"))));
					(__temp865 == NULL ? NULL : (__temp865 = (g_object_unref (__temp865), NULL)));
					__temp866 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp866 = vala_ccode_constant_new ("G_MAXUINT"))));
					(__temp866 == NULL ? NULL : (__temp866 = (g_object_unref (__temp866), NULL)));
					__temp867 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp867 = vala_ccode_constant_new ("0U"))));
					(__temp867 == NULL ? NULL : (__temp867 = (g_object_unref (__temp867), NULL)));
				} else {
					if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->long_type)) {
						ValaCCodeIdentifier* __temp868;
						ValaCCodeConstant* __temp869;
						ValaCCodeConstant* __temp870;
						ValaCCodeConstant* __temp871;
						__temp868 = NULL;
						(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp868 = vala_ccode_identifier_new ("g_param_spec_long")))), vala_ccode_function_call_get_call (cspec));
						(__temp868 == NULL ? NULL : (__temp868 = (g_object_unref (__temp868), NULL)));
						__temp869 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp869 = vala_ccode_constant_new ("G_MINLONG"))));
						(__temp869 == NULL ? NULL : (__temp869 = (g_object_unref (__temp869), NULL)));
						__temp870 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp870 = vala_ccode_constant_new ("G_MAXLONG"))));
						(__temp870 == NULL ? NULL : (__temp870 = (g_object_unref (__temp870), NULL)));
						__temp871 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp871 = vala_ccode_constant_new ("0L"))));
						(__temp871 == NULL ? NULL : (__temp871 = (g_object_unref (__temp871), NULL)));
					} else {
						if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->ulong_type)) {
							ValaCCodeIdentifier* __temp872;
							ValaCCodeConstant* __temp873;
							ValaCCodeConstant* __temp874;
							ValaCCodeConstant* __temp875;
							__temp872 = NULL;
							(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp872 = vala_ccode_identifier_new ("g_param_spec_ulong")))), vala_ccode_function_call_get_call (cspec));
							(__temp872 == NULL ? NULL : (__temp872 = (g_object_unref (__temp872), NULL)));
							__temp873 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp873 = vala_ccode_constant_new ("0"))));
							(__temp873 == NULL ? NULL : (__temp873 = (g_object_unref (__temp873), NULL)));
							__temp874 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp874 = vala_ccode_constant_new ("G_MAXULONG"))));
							(__temp874 == NULL ? NULL : (__temp874 = (g_object_unref (__temp874), NULL)));
							__temp875 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp875 = vala_ccode_constant_new ("0UL"))));
							(__temp875 == NULL ? NULL : (__temp875 = (g_object_unref (__temp875), NULL)));
						} else {
							if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->bool_type)) {
								ValaCCodeIdentifier* __temp876;
								ValaCCodeConstant* __temp877;
								__temp876 = NULL;
								(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp876 = vala_ccode_identifier_new ("g_param_spec_boolean")))), vala_ccode_function_call_get_call (cspec));
								(__temp876 == NULL ? NULL : (__temp876 = (g_object_unref (__temp876), NULL)));
								__temp877 = NULL;
								vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp877 = vala_ccode_constant_new ("FALSE"))));
								(__temp877 == NULL ? NULL : (__temp877 = (g_object_unref (__temp877), NULL)));
							} else {
								if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->float_type)) {
									ValaCCodeIdentifier* __temp878;
									ValaCCodeConstant* __temp879;
									ValaCCodeConstant* __temp880;
									ValaCCodeConstant* __temp881;
									__temp878 = NULL;
									(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp878 = vala_ccode_identifier_new ("g_param_spec_float")))), vala_ccode_function_call_get_call (cspec));
									(__temp878 == NULL ? NULL : (__temp878 = (g_object_unref (__temp878), NULL)));
									__temp879 = NULL;
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp879 = vala_ccode_constant_new ("-G_MAXFLOAT"))));
									(__temp879 == NULL ? NULL : (__temp879 = (g_object_unref (__temp879), NULL)));
									__temp880 = NULL;
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp880 = vala_ccode_constant_new ("G_MAXFLOAT"))));
									(__temp880 == NULL ? NULL : (__temp880 = (g_object_unref (__temp880), NULL)));
									__temp881 = NULL;
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp881 = vala_ccode_constant_new ("0.0F"))));
									(__temp881 == NULL ? NULL : (__temp881 = (g_object_unref (__temp881), NULL)));
								} else {
									if (vala_type_reference_get_data_type (vala_property_get_type_reference (prop)) == vala_type_reference_get_data_type (self->priv->double_type)) {
										ValaCCodeIdentifier* __temp882;
										ValaCCodeConstant* __temp883;
										ValaCCodeConstant* __temp884;
										ValaCCodeConstant* __temp885;
										__temp882 = NULL;
										(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp882 = vala_ccode_identifier_new ("g_param_spec_double")))), vala_ccode_function_call_get_call (cspec));
										(__temp882 == NULL ? NULL : (__temp882 = (g_object_unref (__temp882), NULL)));
										__temp883 = NULL;
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp883 = vala_ccode_constant_new ("-G_MAXDOUBLE"))));
										(__temp883 == NULL ? NULL : (__temp883 = (g_object_unref (__temp883), NULL)));
										__temp884 = NULL;
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp884 = vala_ccode_constant_new ("G_MAXDOUBLE"))));
										(__temp884 == NULL ? NULL : (__temp884 = (g_object_unref (__temp884), NULL)));
										__temp885 = NULL;
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp885 = vala_ccode_constant_new ("0.0"))));
										(__temp885 == NULL ? NULL : (__temp885 = (g_object_unref (__temp885), NULL)));
									} else {
										ValaCCodeIdentifier* __temp886;
										__temp886 = NULL;
										(vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((__temp886 = vala_ccode_identifier_new ("g_param_spec_pointer")))), vala_ccode_function_call_get_call (cspec));
										(__temp886 == NULL ? NULL : (__temp886 = (g_object_unref (__temp886), NULL)));
									}
								}
							}
						}
					}
				}
			}
		}
	}
	pflags = g_strdup ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB");
	if (vala_property_get_get_accessor (prop) != NULL) {
		char* __temp887;
		__temp887 = NULL;
		pflags = (__temp887 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_READABLE"), (pflags = (g_free (pflags), NULL)), __temp887);
	}
	if (vala_property_get_set_accessor (prop) != NULL) {
		char* __temp888;
		__temp888 = NULL;
		pflags = (__temp888 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_WRITABLE"), (pflags = (g_free (pflags), NULL)), __temp888);
		if (vala_property_accessor_get_construction (vala_property_get_set_accessor (prop))) {
			if (vala_property_accessor_get_writable (vala_property_get_set_accessor (prop))) {
				char* __temp889;
				__temp889 = NULL;
				pflags = (__temp889 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_CONSTRUCT"), (pflags = (g_free (pflags), NULL)), __temp889);
			} else {
				char* __temp890;
				__temp890 = NULL;
				pflags = (__temp890 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_CONSTRUCT_ONLY"), (pflags = (g_free (pflags), NULL)), __temp890);
			}
		}
	}
	__temp891 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((__temp891 = vala_ccode_constant_new (pflags))));
	(__temp891 == NULL ? NULL : (__temp891 = (g_object_unref (__temp891), NULL)));
	__temp892 = NULL;
	return (__temp892 = cspec, (pflags = (g_free (pflags), NULL)), __temp892);
	(cspec == NULL ? NULL : (cspec = (g_object_unref (cspec), NULL)));
	(pflags = (g_free (pflags), NULL));
}


static ValaCCodeFunctionCall* vala_code_generator_get_signal_creation (ValaCodeGenerator* self, ValaSignal* sig, ValaDataType* type)
{
	ValaCCodeFunctionCall* csignew;
	ValaCCodeConstant* __temp893;
	ValaCCodeIdentifier* __temp894;
	ValaCCodeConstant* __temp895;
	ValaCCodeConstant* __temp896;
	ValaCCodeConstant* __temp897;
	ValaCCodeConstant* __temp898;
	char* marshaller;
	ValaCCodeIdentifier* marshal_arg;
	GList* params;
	guint params_len;
	ValaCCodeConstant* __temp902;
	ValaCCodeFunctionCall* __temp906;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SIGNAL (sig), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (type), NULL);
	csignew = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_signal_new")));
	__temp893 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp893 = vala_ccode_constant_new (g_strdup_printf ("\"%s\"", vala_signal_get_name (sig))))));
	(__temp893 == NULL ? NULL : (__temp893 = (g_object_unref (__temp893), NULL)));
	__temp894 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp894 = vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (type, "TYPE_")))));
	(__temp894 == NULL ? NULL : (__temp894 = (g_object_unref (__temp894), NULL)));
	__temp895 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp895 = vala_ccode_constant_new ("G_SIGNAL_RUN_LAST"))));
	(__temp895 == NULL ? NULL : (__temp895 = (g_object_unref (__temp895), NULL)));
	__temp896 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp896 = vala_ccode_constant_new ("0"))));
	(__temp896 == NULL ? NULL : (__temp896 = (g_object_unref (__temp896), NULL)));
	__temp897 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp897 = vala_ccode_constant_new ("NULL"))));
	(__temp897 == NULL ? NULL : (__temp897 = (g_object_unref (__temp897), NULL)));
	__temp898 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp898 = vala_ccode_constant_new ("NULL"))));
	(__temp898 == NULL ? NULL : (__temp898 = (g_object_unref (__temp898), NULL)));
	marshaller = vala_code_generator_get_signal_marshaller_function (self, sig, NULL);
	marshal_arg = vala_ccode_identifier_new (marshaller);
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION (marshal_arg));
	params = vala_invokable_get_parameters (VALA_INVOKABLE (sig));
	params_len = g_list_length (params);
	if (vala_type_reference_get_type_parameter (vala_signal_get_return_type (sig)) != NULL) {
		ValaCCodeConstant* __temp899;
		__temp899 = NULL;
		vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp899 = vala_ccode_constant_new ("G_TYPE_POINTER"))));
		(__temp899 == NULL ? NULL : (__temp899 = (g_object_unref (__temp899), NULL)));
	} else {
		if (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)) == NULL) {
			ValaCCodeConstant* __temp900;
			__temp900 = NULL;
			vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp900 = vala_ccode_constant_new ("G_TYPE_NONE"))));
			(__temp900 == NULL ? NULL : (__temp900 = (g_object_unref (__temp900), NULL)));
		} else {
			ValaCCodeConstant* __temp901;
			__temp901 = NULL;
			vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp901 = vala_ccode_constant_new (vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)))))));
			(__temp901 == NULL ? NULL : (__temp901 = (g_object_unref (__temp901), NULL)));
		}
	}
	__temp902 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp902 = vala_ccode_constant_new (g_strdup_printf ("%d", params_len)))));
	(__temp902 == NULL ? NULL : (__temp902 = (g_object_unref (__temp902), NULL)));
	{
		GList* __temp905;
		GList* param_it;
		__temp905 = NULL;
		__temp905 = params;
		for (param_it = __temp905; param_it != NULL; param_it = param_it->next) {
			ValaFormalParameter* param;
			param = param_it->data;
			{
				if (vala_type_reference_get_type_parameter (vala_formal_parameter_get_type_reference (param)) != NULL) {
					ValaCCodeConstant* __temp903;
					__temp903 = NULL;
					vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp903 = vala_ccode_constant_new ("G_TYPE_POINTER"))));
					(__temp903 == NULL ? NULL : (__temp903 = (g_object_unref (__temp903), NULL)));
				} else {
					ValaCCodeConstant* __temp904;
					__temp904 = NULL;
					vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((__temp904 = vala_ccode_constant_new (vala_data_type_get_type_id (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)))))));
					(__temp904 == NULL ? NULL : (__temp904 = (g_object_unref (__temp904), NULL)));
				}
			}
		}
	}
	(vala_ccode_identifier_set_name (marshal_arg, marshaller), vala_ccode_identifier_get_name (marshal_arg));
	__temp906 = NULL;
	return (__temp906 = csignew, (marshaller = (g_free (marshaller), NULL)), (marshal_arg == NULL ? NULL : (marshal_arg = (g_object_unref (marshal_arg), NULL))), (params == NULL ? NULL : (params = (g_list_free (params), NULL))), __temp906);
	(csignew == NULL ? NULL : (csignew = (g_object_unref (csignew), NULL)));
	(marshaller = (g_free (marshaller), NULL));
	(marshal_arg == NULL ? NULL : (marshal_arg = (g_object_unref (marshal_arg), NULL)));
	(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
}


static void vala_code_generator_add_interface_base_init_function (ValaCodeGenerator* self, ValaInterface* iface)
{
	char* __temp907;
	ValaCCodeFunction* __temp908;
	ValaCCodeFunction* base_init;
	ValaCCodeFormalParameter* __temp910;
	char* __temp909;
	ValaCCodeBlock* init_block;
	ValaCCodeBlock* __temp911;
	ValaCCodeDeclaration* decl;
	ValaCCodeVariableDeclarator* __temp912;
	ValaCCodeIfStatement* cif;
	ValaCCodeExpressionStatement* __temp913;
	GList* props;
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	__temp907 = NULL;
	__temp908 = NULL;
	base_init = (__temp908 = vala_ccode_function_new (g_strdup_printf ("%s_base_init", (__temp907 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (iface), NULL))), "void"), (__temp907 = (g_free (__temp907), NULL)), __temp908);
	__temp910 = NULL;
	__temp909 = NULL;
	vala_ccode_function_add_parameter (base_init, (__temp910 = vala_ccode_formal_parameter_new ("iface", g_strdup_printf ("%sIface *", (__temp909 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE))))));
	(__temp910 == NULL ? NULL : (__temp910 = (g_object_unref (__temp910), NULL)));
	(__temp909 = (g_free (__temp909), NULL));
	(vala_ccode_function_set_modifiers (base_init, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (base_init));
	init_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	/* make sure not to run the initialization code twice */
	__temp911 = NULL;
	(vala_ccode_function_set_block (base_init, (__temp911 = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL))), vala_ccode_function_get_block (base_init));
	(__temp911 == NULL ? NULL : (__temp911 = (g_object_unref (__temp911), NULL)));
	decl = vala_ccode_declaration_new (vala_type_reference_get_cname (self->priv->bool_type, FALSE, FALSE));
	(vala_ccode_declaration_set_modifiers (decl, vala_ccode_declaration_get_modifiers (decl) | (VALA_CCODE_MODIFIERS_STATIC)), vala_ccode_declaration_get_modifiers (decl));
	__temp912 = NULL;
	vala_ccode_declaration_add_declarator (decl, VALA_CCODE_DECLARATOR ((__temp912 = vala_ccode_variable_declarator_new_with_initializer ("initialized", VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("FALSE"))))));
	(__temp912 == NULL ? NULL : (__temp912 = (g_object_unref (__temp912), NULL)));
	vala_ccode_block_add_statement (vala_ccode_function_get_block (base_init), VALA_CCODE_NODE (decl));
	cif = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("initialized")))), VALA_CCODE_STATEMENT (init_block), NULL);
	vala_ccode_block_add_statement (vala_ccode_function_get_block (base_init), VALA_CCODE_NODE (cif));
	__temp913 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp913 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("initialized")), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("TRUE")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp913 == NULL ? NULL : (__temp913 = (g_object_unref (__temp913), NULL)));
	/* create properties */
	props = vala_interface_get_properties (iface);
	{
		GList* __temp917;
		GList* prop_it;
		__temp917 = NULL;
		__temp917 = props;
		for (prop_it = __temp917; prop_it != NULL; prop_it = prop_it->next) {
			ValaProperty* prop;
			prop = prop_it->data;
			{
				ValaCCodeFunctionCall* cinst;
				ValaCCodeIdentifier* __temp914;
				ValaCCodeFunctionCall* __temp915;
				ValaCCodeExpressionStatement* __temp916;
				cinst = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_interface_install_property")));
				__temp914 = NULL;
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp914 = vala_ccode_identifier_new ("iface"))));
				(__temp914 == NULL ? NULL : (__temp914 = (g_object_unref (__temp914), NULL)));
				__temp915 = NULL;
				vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((__temp915 = vala_code_generator_get_param_spec (self, prop))));
				(__temp915 = (g_object_unref (__temp915), NULL));
				__temp916 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp916 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
				(__temp916 == NULL ? NULL : (__temp916 = (g_object_unref (__temp916), NULL)));
				(cinst == NULL ? NULL : (cinst = (g_object_unref (cinst), NULL)));
			}
		}
	}
	{
		GList* __temp919;
		GList* sig_it;
		__temp919 = NULL;
		__temp919 = vala_interface_get_signals (iface);
		for (sig_it = __temp919; sig_it != NULL; sig_it = sig_it->next) {
			ValaSignal* sig;
			sig = sig_it->data;
			{
				ValaCCodeExpressionStatement* __temp918;
				/* create signals */
				__temp918 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((__temp918 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_generator_get_signal_creation (self, sig, VALA_DATA_TYPE (iface)))))));
				(__temp918 == NULL ? NULL : (__temp918 = (g_object_unref (__temp918), NULL)));
			}
		}
		(__temp919 == NULL ? NULL : (__temp919 = (g_list_free (__temp919), NULL)));
	}
	vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (base_init));
	(base_init == NULL ? NULL : (base_init = (g_object_unref (base_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (g_object_unref (init_block), NULL)));
	(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
	(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
	(props == NULL ? NULL : (props = (g_list_free (props), NULL)));
}


static void vala_code_generator_real_visit_end_invocation_expression (ValaCodeVisitor* base, ValaInvocationExpression* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeFunctionCall* ccall;
	ValaMethod* m;
	GList* params;
	ValaMemberAccess* __temp920;
	ValaMemberAccess* ma;
	ValaCCodeExpression* instance;
	gboolean ellipsis;
	gint i;
	GList* params_it;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_INVOCATION_EXPRESSION (expr));
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_invocation_expression_get_call (expr)))));
	m = NULL;
	params = NULL;
	if (!(VALA_IS_MEMBER_ACCESS (vala_invocation_expression_get_call (expr)))) {
		(vala_code_node_set_error (VALA_CODE_NODE (expr), TRUE), vala_code_node_get_error (VALA_CODE_NODE (expr)));
		vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), "unsupported method invocation");
		(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
		(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
		return;
	}
	__temp920 = NULL;
	ma = (__temp920 = VALA_MEMBER_ACCESS (vala_invocation_expression_get_call (expr)), (__temp920 == NULL ? NULL : g_object_ref (__temp920)));
	if (VALA_IS_INVOKABLE (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_invocation_expression_get_call (expr))))) {
		ValaInvokable* __temp921;
		ValaInvokable* i;
		GList* __temp922;
		__temp921 = NULL;
		i = (__temp921 = VALA_INVOKABLE (vala_symbol_get_node (vala_expression_get_symbol_reference (vala_invocation_expression_get_call (expr)))), (__temp921 == NULL ? NULL : g_object_ref (__temp921)));
		__temp922 = NULL;
		params = (__temp922 = vala_invokable_get_parameters (i), (params == NULL ? NULL : (params = (g_list_free (params), NULL))), __temp922);
		if (VALA_IS_METHOD (i)) {
			ValaMethod* __temp924;
			ValaMethod* __temp923;
			__temp924 = NULL;
			__temp923 = NULL;
			m = (__temp924 = (__temp923 = VALA_METHOD (i), (__temp923 == NULL ? NULL : g_object_ref (__temp923))), (m == NULL ? NULL : (m = (g_object_unref (m), NULL))), __temp924);
		} else {
			if (VALA_IS_SIGNAL (i)) {
				ValaCCodeFunctionCall* __temp926;
				ValaCCodeFunctionCall* __temp925;
				__temp926 = NULL;
				__temp925 = NULL;
				ccall = (__temp926 = (__temp925 = VALA_CCODE_FUNCTION_CALL (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_invocation_expression_get_call (expr)))), (__temp925 == NULL ? NULL : g_object_ref (__temp925))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp926);
			}
		}
		(i == NULL ? NULL : (i = (g_object_unref (i), NULL)));
	}
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		ValaArray* __temp927;
		ValaArray* array;
		ValaCCodeIdentifier* __temp928;
		__temp927 = NULL;
		array = (__temp927 = VALA_ARRAY (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m))))), (__temp927 == NULL ? NULL : g_object_ref (__temp927)));
		__temp928 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp928 = vala_ccode_identifier_new (vala_data_type_get_cname (VALA_DATA_TYPE (array), FALSE)))));
		(__temp928 == NULL ? NULL : (__temp928 = (g_object_unref (__temp928), NULL)));
		(array == NULL ? NULL : (array = (g_object_unref (array), NULL)));
	}
	/* explicitly use strong reference as ccall gets unrefed
	 * at end of inner block
	 */
	instance = NULL;
	if (m != NULL && vala_method_get_instance (m)) {
		ValaMethod* __temp929;
		ValaMethod* base_method;
		gboolean req_cast;
		__temp929 = NULL;
		base_method = (__temp929 = m, (__temp929 == NULL ? NULL : g_object_ref (__temp929)));
		if (vala_method_get_base_interface_method (m) != NULL) {
			ValaMethod* __temp931;
			ValaMethod* __temp930;
			__temp931 = NULL;
			__temp930 = NULL;
			base_method = (__temp931 = (__temp930 = vala_method_get_base_interface_method (m), (__temp930 == NULL ? NULL : g_object_ref (__temp930))), (base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL))), __temp931);
		} else {
			if (vala_method_get_base_method (m) != NULL) {
				ValaMethod* __temp933;
				ValaMethod* __temp932;
				__temp933 = NULL;
				__temp932 = NULL;
				base_method = (__temp933 = (__temp932 = vala_method_get_base_method (m), (__temp932 == NULL ? NULL : g_object_ref (__temp932))), (base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL))), __temp933);
			}
		}
		req_cast = FALSE;
		if (vala_member_access_get_inner (ma) == NULL) {
			ValaCCodeExpression* __temp934;
			__temp934 = NULL;
			instance = (__temp934 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp934);
			/* require casts for overriden and inherited methods */
			req_cast = vala_method_get_overrides (m) || vala_method_get_base_interface_method (m) != NULL || (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m))) != self->priv->current_type_symbol);
		} else {
			ValaCCodeExpression* __temp936;
			ValaCCodeExpression* __temp935;
			__temp936 = NULL;
			__temp935 = NULL;
			instance = (__temp936 = (__temp935 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (__temp935 == NULL ? NULL : g_object_ref (__temp935))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp936);
			/* reqiure casts if the type of the used instance is
			 * different than the type which declared the method */
			req_cast = vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (base_method)))) != VALA_CODE_NODE (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))));
		}
		if (vala_method_get_instance_by_reference (m) && (vala_member_access_get_inner (ma) != NULL || vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m))) != self->priv->current_type_symbol)) {
			ValaCCodeExpression* __temp937;
			__temp937 = NULL;
			instance = (__temp937 = VALA_CCODE_EXPRESSION (vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance)), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp937);
		}
		if (req_cast && vala_data_type_is_reference_type ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m)))))))) {
			ValaCCodeFunctionCall* ccall;
			ValaCCodeExpression* __temp939;
			ValaCCodeFunctionCall* __temp938;
			/* FIXME: use C cast if debugging disabled*/
			ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (base_method)))))), NULL))));
			vala_ccode_function_call_add_argument (ccall, instance);
			__temp939 = NULL;
			__temp938 = NULL;
			instance = (__temp939 = VALA_CCODE_EXPRESSION ((__temp938 = ccall, (__temp938 == NULL ? NULL : g_object_ref (__temp938)))), (instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL))), __temp939);
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		}
		if (!vala_method_get_instance_last (m)) {
			vala_ccode_function_call_add_argument (ccall, instance);
		}
		(base_method == NULL ? NULL : (base_method = (g_object_unref (base_method), NULL)));
	}
	ellipsis = FALSE;
	i = 1;
	params_it = params;
	{
		GList* __temp950;
		GList* arg_it;
		__temp950 = NULL;
		__temp950 = vala_invocation_expression_get_argument_list (expr);
		for (arg_it = __temp950; arg_it != NULL; arg_it = arg_it->next) {
			ValaExpression* arg;
			arg = arg_it->data;
			{
				ValaCCodeExpression* __temp940;
				ValaCCodeExpression* cexpr;
				/* explicitly use strong reference as ccall gets
				 * unrefed at end of inner block
				 */
				__temp940 = NULL;
				cexpr = (__temp940 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (arg))), (__temp940 == NULL ? NULL : g_object_ref (__temp940)));
				if (params_it != NULL) {
					ValaFormalParameter* __temp941;
					ValaFormalParameter* param;
					__temp941 = NULL;
					param = (__temp941 = VALA_FORMAL_PARAMETER (params_it->data), (__temp941 == NULL ? NULL : g_object_ref (__temp941)));
					ellipsis = vala_formal_parameter_get_ellipsis (param);
					if (!ellipsis) {
						if (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)) != NULL && vala_data_type_is_reference_type (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))) && vala_type_reference_get_data_type (vala_expression_get_static_type (arg)) != NULL) {
							if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
								ValaArray* __temp942;
								ValaArray* arr;
								__temp942 = NULL;
								arr = (__temp942 = VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))), (__temp942 == NULL ? NULL : g_object_ref (__temp942)));
								{
									gint dim;
									dim = 0;
									for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
										ValaCCodeExpression* __temp943;
										__temp943 = NULL;
										vala_ccode_function_call_add_argument (ccall, (__temp943 = vala_code_generator_get_array_length_cexpression (self, arg, dim)));
										(__temp943 = (g_object_unref (__temp943), NULL));
									}
								}
								(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
							}
							if (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)) != vala_type_reference_get_data_type (vala_expression_get_static_type (arg))) {
								ValaCCodeFunctionCall* ccall;
								ValaCCodeExpression* __temp945;
								ValaCCodeFunctionCall* __temp944;
								/* FIXME: use C cast if debugging disabled*/
								ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)), NULL))));
								vala_ccode_function_call_add_argument (ccall, cexpr);
								__temp945 = NULL;
								__temp944 = NULL;
								cexpr = (__temp945 = VALA_CCODE_EXPRESSION ((__temp944 = ccall, (__temp944 == NULL ? NULL : g_object_ref (__temp944)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp945);
								(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							}
						} else {
							if (VALA_IS_CALLBACK (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
								ValaCCodeExpression* __temp946;
								__temp946 = NULL;
								cexpr = (__temp946 = VALA_CCODE_EXPRESSION (vala_ccode_cast_expression_new (cexpr, vala_data_type_get_cname (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)), FALSE))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp946);
							} else {
								if (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)) == NULL && VALA_IS_STRUCT (vala_type_reference_get_data_type (vala_expression_get_static_type (arg)))) {
									ValaStruct* __temp947;
									ValaStruct* st;
									/* convert integer to pointer if this is a generic method parameter */
									__temp947 = NULL;
									st = (__temp947 = VALA_STRUCT (vala_type_reference_get_data_type (vala_expression_get_static_type (arg))), (__temp947 == NULL ? NULL : g_object_ref (__temp947)));
									if (VALA_DATA_TYPE (st) == vala_type_reference_get_data_type (self->priv->bool_type) || vala_struct_is_integer_type (st)) {
										ValaCCodeFunctionCall* cconv;
										ValaCCodeExpression* __temp949;
										ValaCCodeFunctionCall* __temp948;
										cconv = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("GINT_TO_POINTER")));
										vala_ccode_function_call_add_argument (cconv, cexpr);
										__temp949 = NULL;
										__temp948 = NULL;
										cexpr = (__temp949 = VALA_CCODE_EXPRESSION ((__temp948 = cconv, (__temp948 == NULL ? NULL : g_object_ref (__temp948)))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp949);
										(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
									}
									(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
								}
							}
						}
					}
					(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
				}
				vala_ccode_function_call_add_argument (ccall, cexpr);
				i++;
				if (params_it != NULL) {
					params_it = params_it->next;
				}
				(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
			}
		}
		(__temp950 == NULL ? NULL : (__temp950 = (g_list_free (__temp950), NULL)));
	}
	while (params_it != NULL) {
		ValaFormalParameter* __temp951;
		ValaFormalParameter* param;
		__temp951 = NULL;
		param = (__temp951 = VALA_FORMAL_PARAMETER (params_it->data), (__temp951 == NULL ? NULL : g_object_ref (__temp951)));
		if (vala_formal_parameter_get_ellipsis (param)) {
			ellipsis = TRUE;
			break;
		}
		if (vala_formal_parameter_get_default_expression (param) == NULL) {
			char* __temp952;
			__temp952 = NULL;
			vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (expr)), (__temp952 = g_strdup_printf ("no default expression for argument %d", i)));
			(__temp952 = (g_free (__temp952), NULL));
			(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
			(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
			(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
			(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
			(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
			return;
		}
		/* evaluate default expression here as the code
		 * generator might not have visited the formal
		 * parameter yet */
		vala_code_node_accept (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)), VALA_CODE_VISITOR (self));
		if (!vala_formal_parameter_get_no_array_length (param) && vala_formal_parameter_get_type_reference (param) != NULL && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
			ValaArray* __temp953;
			ValaArray* arr;
			__temp953 = NULL;
			arr = (__temp953 = VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))), (__temp953 == NULL ? NULL : g_object_ref (__temp953)));
			{
				gint dim;
				dim = 0;
				for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
					ValaCCodeExpression* __temp954;
					__temp954 = NULL;
					vala_ccode_function_call_add_argument (ccall, (__temp954 = vala_code_generator_get_array_length_cexpression (self, vala_formal_parameter_get_default_expression (param), dim)));
					(__temp954 = (g_object_unref (__temp954), NULL));
				}
			}
			(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
		}
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_formal_parameter_get_default_expression (param)))));
		i++;
		params_it = params_it->next;
		(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
	}
	/* add length argument for methods returning arrays */
	if (m != NULL && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_method_get_return_type (m)))) {
		ValaArray* __temp955;
		ValaArray* arr;
		__temp955 = NULL;
		arr = (__temp955 = VALA_ARRAY (vala_type_reference_get_data_type (vala_method_get_return_type (m))), (__temp955 == NULL ? NULL : g_object_ref (__temp955)));
		{
			gint dim;
			dim = 0;
			for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
				if (!vala_method_get_no_array_length (m)) {
					ValaVariableDeclarator* temp_decl;
					ValaCCodeIdentifier* temp_ref;
					ValaVariableDeclarator* __temp956;
					ValaCCodeUnaryExpression* __temp957;
					temp_decl = vala_code_generator_get_temp_variable_declarator (self, self->priv->int_type, TRUE);
					temp_ref = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl));
					__temp956 = NULL;
					self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp956 = temp_decl, (__temp956 == NULL ? NULL : g_object_ref (__temp956))));
					__temp957 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp957 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (temp_ref)))));
					(__temp957 == NULL ? NULL : (__temp957 = (g_object_unref (__temp957), NULL)));
					vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION (temp_ref));
					(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
					(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
				} else {
					ValaCCodeConstant* __temp958;
					__temp958 = NULL;
					vala_invocation_expression_append_array_size (expr, VALA_CCODE_EXPRESSION ((__temp958 = vala_ccode_constant_new ("-1"))));
					(__temp958 == NULL ? NULL : (__temp958 = (g_object_unref (__temp958), NULL)));
				}
			}
		}
		(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
	}
	if (vala_expression_get_can_fail (VALA_EXPRESSION (expr))) {
		ValaCCodeUnaryExpression* __temp959;
		/* method can fail*/
		self->priv->current_method_inner_error = TRUE;
		__temp959 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp959 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("inner_error"))))));
		(__temp959 == NULL ? NULL : (__temp959 = (g_object_unref (__temp959), NULL)));
	}
	if (m != NULL && vala_method_get_instance (m) && vala_method_get_instance_last (m)) {
		vala_ccode_function_call_add_argument (ccall, instance);
	} else {
		if (ellipsis) {
			/* ensure variable argument list ends with NULL
			 * except when using printf-style arguments */
			if (m == NULL || !vala_method_get_printf_format (m)) {
				ValaCCodeConstant* __temp960;
				__temp960 = NULL;
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp960 = vala_ccode_constant_new ("NULL"))));
				(__temp960 == NULL ? NULL : (__temp960 = (g_object_unref (__temp960), NULL)));
			}
		}
	}
	if (m != NULL && vala_method_get_instance (m) && vala_method_get_returns_modified_pointer (m)) {
		ValaCCodeAssignment* __temp961;
		__temp961 = NULL;
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp961 = vala_ccode_assignment_new (instance, VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(__temp961 == NULL ? NULL : (__temp961 = (g_object_unref (__temp961), NULL)));
	} else {
		/* cast pointer to actual type if this is a generic method return value */
		if (m != NULL && vala_type_reference_get_type_parameter (vala_method_get_return_type (m)) != NULL && vala_type_reference_get_data_type (vala_expression_get_static_type (VALA_EXPRESSION (expr))) != NULL) {
			if (VALA_IS_STRUCT (vala_type_reference_get_data_type (vala_expression_get_static_type (VALA_EXPRESSION (expr))))) {
				ValaStruct* __temp962;
				ValaStruct* st;
				__temp962 = NULL;
				st = (__temp962 = VALA_STRUCT (vala_type_reference_get_data_type (vala_expression_get_static_type (VALA_EXPRESSION (expr)))), (__temp962 == NULL ? NULL : g_object_ref (__temp962)));
				if (VALA_DATA_TYPE (st) == vala_type_reference_get_data_type (self->priv->uint_type)) {
					ValaCCodeFunctionCall* cconv;
					ValaCCodeFunctionCall* __temp964;
					ValaCCodeFunctionCall* __temp963;
					cconv = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("GPOINTER_TO_UINT")));
					vala_ccode_function_call_add_argument (cconv, VALA_CCODE_EXPRESSION (ccall));
					__temp964 = NULL;
					__temp963 = NULL;
					ccall = (__temp964 = (__temp963 = cconv, (__temp963 == NULL ? NULL : g_object_ref (__temp963))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp964);
					(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
				} else {
					if (VALA_DATA_TYPE (st) == vala_type_reference_get_data_type (self->priv->bool_type) || vala_struct_is_integer_type (st)) {
						ValaCCodeFunctionCall* cconv;
						ValaCCodeFunctionCall* __temp966;
						ValaCCodeFunctionCall* __temp965;
						cconv = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("GPOINTER_TO_INT")));
						vala_ccode_function_call_add_argument (cconv, VALA_CCODE_EXPRESSION (ccall));
						__temp966 = NULL;
						__temp965 = NULL;
						ccall = (__temp966 = (__temp965 = cconv, (__temp965 == NULL ? NULL : g_object_ref (__temp965))), (ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL))), __temp966);
						(cconv == NULL ? NULL : (cconv = (g_object_unref (cconv), NULL)));
					}
				}
				(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
			}
		}
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	}
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		ValaCCodeExpression* __temp968;
		GList* __temp967;
		ValaCCodeExpression* __temp969;
		ValaCCodeExpression* new_size;
		ValaVariableDeclarator* temp_decl;
		ValaCCodeIdentifier* temp_ref;
		ValaVariableDeclarator* __temp970;
		ValaCCodeExpression* clen;
		ValaCCodeExpression* __temp971;
		ValaCCodeExpression* celems;
		char* __temp972;
		ValaCCodeIdentifier* __temp973;
		ValaCCodeIdentifier* csizeof;
		ValaCCodeParenthesizedExpression* cdelta;
		ValaCCodeBinaryExpression* ccheck;
		ValaCCodeFunctionCall* czero;
		ValaCCodeBinaryExpression* __temp974;
		ValaCCodeConstant* __temp975;
		ValaCCodeBinaryExpression* __temp976;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* __temp977;
		ValaCCodeConditionalExpression* __temp978;
		ValaCCodeAssignment* __temp979;
		/* FIXME: size expression must not be evaluated twice at runtime (potential side effects)*/
		__temp968 = NULL;
		__temp967 = NULL;
		__temp969 = NULL;
		new_size = (__temp969 = (__temp968 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((VALA_CODE_NODE ((__temp967 = vala_invocation_expression_get_argument_list (expr))->data)))), (__temp968 == NULL ? NULL : g_object_ref (__temp968))), (__temp967 == NULL ? NULL : (__temp967 = (g_list_free (__temp967), NULL))), __temp969);
		temp_decl = vala_code_generator_get_temp_variable_declarator (self, self->priv->int_type, TRUE);
		temp_ref = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl));
		__temp970 = NULL;
		self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp970 = temp_decl, (__temp970 == NULL ? NULL : g_object_ref (__temp970))));
		/* memset needs string.h */
		self->priv->string_h_needed = TRUE;
		clen = vala_code_generator_get_array_length_cexpression (self, vala_member_access_get_inner (ma), 1);
		__temp971 = NULL;
		celems = (__temp971 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))), (__temp971 == NULL ? NULL : g_object_ref (__temp971)));
		__temp972 = NULL;
		__temp973 = NULL;
		csizeof = (__temp973 = vala_ccode_identifier_new (g_strdup_printf ("sizeof (%s)", (__temp972 = vala_data_type_get_cname (vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (ma))), FALSE)))), (__temp972 = (g_free (__temp972), NULL)), __temp973);
		cdelta = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (temp_ref), clen)));
		ccheck = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, VALA_CCODE_EXPRESSION (temp_ref), clen);
		czero = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("memset")));
		__temp974 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((__temp974 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, celems, clen))));
		(__temp974 == NULL ? NULL : (__temp974 = (g_object_unref (__temp974), NULL)));
		__temp975 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((__temp975 = vala_ccode_constant_new ("0"))));
		(__temp975 == NULL ? NULL : (__temp975 = (g_object_unref (__temp975), NULL)));
		__temp976 = NULL;
		vala_ccode_function_call_add_argument (czero, VALA_CCODE_EXPRESSION ((__temp976 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION (csizeof), VALA_CCODE_EXPRESSION (cdelta)))));
		(__temp976 == NULL ? NULL : (__temp976 = (g_object_unref (__temp976), NULL)));
		ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
		__temp977 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp977 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (temp_ref), new_size, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(__temp977 == NULL ? NULL : (__temp977 = (g_object_unref (__temp977), NULL)));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))));
		__temp978 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp978 = vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (ccheck), VALA_CCODE_EXPRESSION (czero), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"))))));
		(__temp978 == NULL ? NULL : (__temp978 = (g_object_unref (__temp978), NULL)));
		__temp979 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp979 = vala_ccode_assignment_new (vala_code_generator_get_array_length_cexpression (self, vala_member_access_get_inner (ma), 1), VALA_CCODE_EXPRESSION (temp_ref), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
		(__temp979 == NULL ? NULL : (__temp979 = (g_object_unref (__temp979), NULL)));
		(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
		(new_size == NULL ? NULL : (new_size = (g_object_unref (new_size), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
		(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
		(clen = (g_object_unref (clen), NULL));
		(celems == NULL ? NULL : (celems = (g_object_unref (celems), NULL)));
		(csizeof == NULL ? NULL : (csizeof = (g_object_unref (csizeof), NULL)));
		(cdelta == NULL ? NULL : (cdelta = (g_object_unref (cdelta), NULL)));
		(ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL)));
		(czero == NULL ? NULL : (czero = (g_object_unref (czero), NULL)));
		(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
	} else {
		if (m == self->priv->substring_method) {
			ValaVariableDeclarator* temp_decl;
			ValaCCodeIdentifier* temp_ref;
			ValaVariableDeclarator* __temp980;
			GList* args;
			ValaCCodeFunctionCall* coffsetcall;
			ValaCCodeFunctionCall* coffsetcall2;
			ValaCCodeFunctionCall* cndupcall;
			ValaCCodeBinaryExpression* __temp981;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeAssignment* __temp982;
			temp_decl = vala_code_generator_get_temp_variable_declarator (self, self->priv->string_type, TRUE);
			temp_ref = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl));
			__temp980 = NULL;
			self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp980 = temp_decl, (__temp980 == NULL ? NULL : g_object_ref (__temp980))));
			args = vala_ccode_function_call_get_arguments (ccall);
			coffsetcall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_utf8_offset_to_pointer")));
			/* full string*/
			vala_ccode_function_call_add_argument (coffsetcall, g_list_nth_data (args, 0));
			/* offset*/
			vala_ccode_function_call_add_argument (coffsetcall, g_list_nth_data (args, 1));
			coffsetcall2 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_utf8_offset_to_pointer")));
			vala_ccode_function_call_add_argument (coffsetcall2, VALA_CCODE_EXPRESSION (temp_ref));
			/* len*/
			vala_ccode_function_call_add_argument (coffsetcall2, g_list_nth_data (args, 2));
			cndupcall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_strndup")));
			vala_ccode_function_call_add_argument (cndupcall, VALA_CCODE_EXPRESSION (temp_ref));
			__temp981 = NULL;
			vala_ccode_function_call_add_argument (cndupcall, VALA_CCODE_EXPRESSION ((__temp981 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, VALA_CCODE_EXPRESSION (coffsetcall2), VALA_CCODE_EXPRESSION (temp_ref)))));
			(__temp981 == NULL ? NULL : (__temp981 = (g_object_unref (__temp981), NULL)));
			ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
			__temp982 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp982 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (temp_ref), VALA_CCODE_EXPRESSION (coffsetcall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
			(__temp982 == NULL ? NULL : (__temp982 = (g_object_unref (__temp982), NULL)));
			vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cndupcall));
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
			(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
			(temp_ref == NULL ? NULL : (temp_ref = (g_object_unref (temp_ref), NULL)));
			(args == NULL ? NULL : (args = (g_list_free (args), NULL)));
			(coffsetcall == NULL ? NULL : (coffsetcall = (g_object_unref (coffsetcall), NULL)));
			(coffsetcall2 == NULL ? NULL : (coffsetcall2 = (g_object_unref (coffsetcall2), NULL)));
			(cndupcall == NULL ? NULL : (cndupcall = (g_object_unref (cndupcall), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
		}
	}
	(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
	(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
	(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
	(instance == NULL ? NULL : (instance = (g_object_unref (instance), NULL)));
}


static void vala_code_generator_process_cmember (ValaCodeGenerator* self, ValaMemberAccess* expr, ValaCCodeExpression* pub_inst, ValaDataType* base_type)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	g_return_if_fail (VALA_IS_MEMBER_ACCESS (expr));
	g_return_if_fail (pub_inst == NULL || VALA_IS_CCODE_EXPRESSION (pub_inst));
	g_return_if_fail (base_type == NULL || VALA_IS_DATA_TYPE (base_type));
	if (VALA_IS_METHOD (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
		ValaMethod* __temp983;
		ValaMethod* m;
		__temp983 = NULL;
		m = (__temp983 = VALA_METHOD (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp983 == NULL ? NULL : g_object_ref (__temp983)));
		if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (expr))) {
			if (vala_method_get_base_interface_method (m) != NULL) {
				ValaInterface* __temp984;
				ValaInterface* base_iface;
				char* __temp986;
				char* __temp985;
				char* __temp987;
				char* parent_iface_var;
				ValaCCodeMemberAccess* __temp988;
				__temp984 = NULL;
				base_iface = (__temp984 = VALA_INTERFACE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (vala_method_get_base_interface_method (m)))))), (__temp984 == NULL ? NULL : g_object_ref (__temp984)));
				__temp986 = NULL;
				__temp985 = NULL;
				__temp987 = NULL;
				parent_iface_var = (__temp987 = g_strdup_printf ("%s_%s_parent_iface", (__temp985 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (self->priv->current_class), NULL)), (__temp986 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (base_iface), NULL))), (__temp986 = (g_free (__temp986), NULL)), (__temp985 = (g_free (__temp985), NULL)), __temp987);
				__temp988 = NULL;
				(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp988 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (parent_iface_var)), vala_method_get_name (m))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
				(__temp988 == NULL ? NULL : (__temp988 = (g_object_unref (__temp988), NULL)));
				(base_iface == NULL ? NULL : (base_iface = (g_object_unref (base_iface), NULL)));
				(parent_iface_var = (g_free (parent_iface_var), NULL));
				(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
				return;
				(base_iface == NULL ? NULL : (base_iface = (g_object_unref (base_iface), NULL)));
				(parent_iface_var = (g_free (parent_iface_var), NULL));
			} else {
				if (vala_method_get_base_method (m) != NULL) {
					ValaClass* __temp989;
					ValaClass* base_class;
					char* __temp990;
					ValaCCodeFunctionCall* __temp991;
					ValaCCodeFunctionCall* vcast;
					ValaCCodeIdentifier* __temp993;
					char* __temp992;
					ValaCCodeMemberAccess* __temp994;
					__temp989 = NULL;
					base_class = (__temp989 = VALA_CLASS (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (vala_method_get_base_method (m)))))), (__temp989 == NULL ? NULL : g_object_ref (__temp989)));
					__temp990 = NULL;
					__temp991 = NULL;
					vcast = (__temp991 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_CLASS", (__temp990 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (base_class), NULL)))))), (__temp990 = (g_free (__temp990), NULL)), __temp991);
					__temp993 = NULL;
					__temp992 = NULL;
					vala_ccode_function_call_add_argument (vcast, VALA_CCODE_EXPRESSION ((__temp993 = vala_ccode_identifier_new (g_strdup_printf ("%s_parent_class", (__temp992 = vala_data_type_get_lower_case_cname (VALA_DATA_TYPE (self->priv->current_class), NULL)))))));
					(__temp993 == NULL ? NULL : (__temp993 = (g_object_unref (__temp993), NULL)));
					(__temp992 = (g_free (__temp992), NULL));
					__temp994 = NULL;
					(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp994 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vcast), vala_method_get_name (m))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
					(__temp994 == NULL ? NULL : (__temp994 = (g_object_unref (__temp994), NULL)));
					(base_class == NULL ? NULL : (base_class = (g_object_unref (base_class), NULL)));
					(vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL)));
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					return;
					(base_class == NULL ? NULL : (base_class = (g_object_unref (base_class), NULL)));
					(vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL)));
				}
			}
		}
		if (vala_method_get_base_interface_method (m) != NULL) {
			ValaCCodeIdentifier* __temp995;
			__temp995 = NULL;
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp995 = vala_ccode_identifier_new (vala_method_get_cname (vala_method_get_base_interface_method (m)))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
			(__temp995 == NULL ? NULL : (__temp995 = (g_object_unref (__temp995), NULL)));
		} else {
			if (vala_method_get_base_method (m) != NULL) {
				ValaCCodeIdentifier* __temp996;
				__temp996 = NULL;
				(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp996 = vala_ccode_identifier_new (vala_method_get_cname (vala_method_get_base_method (m)))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
				(__temp996 == NULL ? NULL : (__temp996 = (g_object_unref (__temp996), NULL)));
			} else {
				ValaCCodeIdentifier* __temp997;
				__temp997 = NULL;
				(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp997 = vala_ccode_identifier_new (vala_method_get_cname (m))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
				(__temp997 == NULL ? NULL : (__temp997 = (g_object_unref (__temp997), NULL)));
			}
		}
		(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	} else {
		if (VALA_IS_ARRAY_LENGTH_FIELD (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
			ValaCCodeExpression* __temp998;
			__temp998 = NULL;
			(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp998 = vala_code_generator_get_array_length_cexpression (self, vala_member_access_get_inner (expr), 1)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
			(__temp998 = (g_object_unref (__temp998), NULL));
		} else {
			if (VALA_IS_FIELD (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
				ValaField* __temp999;
				ValaField* f;
				__temp999 = NULL;
				f = (__temp999 = VALA_FIELD (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp999 == NULL ? NULL : g_object_ref (__temp999)));
				if (vala_field_get_instance (f)) {
					ValaCCodeExpression* typed_inst;
					ValaCCodeExpression* inst;
					typed_inst = NULL;
					if (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (f)))) != VALA_CODE_NODE (base_type)) {
						ValaCCodeExpression* __temp1000;
						/* FIXME: use C cast if debugging disabled*/
						__temp1000 = NULL;
						typed_inst = (__temp1000 = VALA_CCODE_EXPRESSION (vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (f)))))), NULL))))), (typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL))), __temp1000);
						vala_ccode_function_call_add_argument ((VALA_CCODE_FUNCTION_CALL (typed_inst)), pub_inst);
					} else {
						ValaCCodeExpression* __temp1002;
						ValaCCodeExpression* __temp1001;
						__temp1002 = NULL;
						__temp1001 = NULL;
						typed_inst = (__temp1002 = (__temp1001 = pub_inst, (__temp1001 == NULL ? NULL : g_object_ref (__temp1001))), (typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL))), __temp1002);
					}
					inst = NULL;
					if (f->access == VALA_MEMBER_ACCESSIBILITY_PRIVATE) {
						ValaCCodeExpression* __temp1003;
						__temp1003 = NULL;
						inst = (__temp1003 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (typed_inst, "priv")), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), __temp1003);
					} else {
						ValaCCodeExpression* __temp1005;
						ValaCCodeExpression* __temp1004;
						__temp1005 = NULL;
						__temp1004 = NULL;
						inst = (__temp1005 = (__temp1004 = typed_inst, (__temp1004 == NULL ? NULL : g_object_ref (__temp1004))), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), __temp1005);
					}
					if (vala_data_type_is_reference_type ((VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (f)))))))) {
						ValaCCodeMemberAccess* __temp1006;
						__temp1006 = NULL;
						(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1006 = vala_ccode_member_access_new_pointer (inst, vala_field_get_cname (f))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
						(__temp1006 == NULL ? NULL : (__temp1006 = (g_object_unref (__temp1006), NULL)));
					} else {
						ValaCCodeMemberAccess* __temp1007;
						__temp1007 = NULL;
						(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1007 = vala_ccode_member_access_new (inst, vala_field_get_cname (f), FALSE)))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
						(__temp1007 == NULL ? NULL : (__temp1007 = (g_object_unref (__temp1007), NULL)));
					}
					(typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL)));
					(inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL)));
				} else {
					ValaCCodeIdentifier* __temp1008;
					__temp1008 = NULL;
					(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1008 = vala_ccode_identifier_new (vala_field_get_cname (f))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
					(__temp1008 == NULL ? NULL : (__temp1008 = (g_object_unref (__temp1008), NULL)));
				}
				(f == NULL ? NULL : (f = (g_object_unref (f), NULL)));
			} else {
				if (VALA_IS_CONSTANT (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
					ValaConstant* __temp1009;
					ValaConstant* c;
					ValaCCodeIdentifier* __temp1010;
					__temp1009 = NULL;
					c = (__temp1009 = VALA_CONSTANT (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp1009 == NULL ? NULL : g_object_ref (__temp1009)));
					__temp1010 = NULL;
					(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1010 = vala_ccode_identifier_new (vala_constant_get_cname (c))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
					(__temp1010 == NULL ? NULL : (__temp1010 = (g_object_unref (__temp1010), NULL)));
					(c == NULL ? NULL : (c = (g_object_unref (c), NULL)));
				} else {
					if (VALA_IS_PROPERTY (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
						ValaProperty* __temp1011;
						ValaProperty* prop;
						__temp1011 = NULL;
						prop = (__temp1011 = VALA_PROPERTY (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp1011 == NULL ? NULL : g_object_ref (__temp1011)));
						if (!vala_property_get_no_accessor_method (prop)) {
							ValaProperty* __temp1012;
							ValaProperty* base_property;
							ValaDataType* __temp1017;
							ValaDataType* base_property_type;
							char* __temp1018;
							ValaCCodeFunctionCall* __temp1019;
							ValaCCodeFunctionCall* ccall;
							ValaCCodeExpression* __temp1020;
							ValaCCodeExpression* typed_pub_inst;
							__temp1012 = NULL;
							base_property = (__temp1012 = prop, (__temp1012 == NULL ? NULL : g_object_ref (__temp1012)));
							if (vala_property_get_base_property (prop) != NULL) {
								ValaProperty* __temp1014;
								ValaProperty* __temp1013;
								__temp1014 = NULL;
								__temp1013 = NULL;
								base_property = (__temp1014 = (__temp1013 = vala_property_get_base_property (prop), (__temp1013 == NULL ? NULL : g_object_ref (__temp1013))), (base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL))), __temp1014);
							} else {
								if (vala_property_get_base_interface_property (prop) != NULL) {
									ValaProperty* __temp1016;
									ValaProperty* __temp1015;
									__temp1016 = NULL;
									__temp1015 = NULL;
									base_property = (__temp1016 = (__temp1015 = vala_property_get_base_interface_property (prop), (__temp1015 == NULL ? NULL : g_object_ref (__temp1015))), (base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL))), __temp1016);
								}
							}
							__temp1017 = NULL;
							base_property_type = (__temp1017 = VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (base_property))))), (__temp1017 == NULL ? NULL : g_object_ref (__temp1017)));
							__temp1018 = NULL;
							__temp1019 = NULL;
							ccall = (__temp1019 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_get_%s", (__temp1018 = vala_data_type_get_lower_case_cname (base_property_type, NULL)), vala_property_get_name (base_property))))), (__temp1018 = (g_free (__temp1018), NULL)), __temp1019);
							__temp1020 = NULL;
							typed_pub_inst = (__temp1020 = pub_inst, (__temp1020 == NULL ? NULL : g_object_ref (__temp1020)));
							/* cast if necessary */
							if (base_property_type != base_type) {
								ValaCCodeFunctionCall* ccast;
								ValaCCodeExpression* __temp1022;
								ValaCCodeFunctionCall* __temp1021;
								/* FIXME: use C cast if debugging disabled*/
								ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (base_property_type, NULL))));
								vala_ccode_function_call_add_argument (ccast, pub_inst);
								__temp1022 = NULL;
								__temp1021 = NULL;
								typed_pub_inst = (__temp1022 = VALA_CCODE_EXPRESSION ((__temp1021 = ccast, (__temp1021 == NULL ? NULL : g_object_ref (__temp1021)))), (typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL))), __temp1022);
								(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
							}
							vala_ccode_function_call_add_argument (ccall, typed_pub_inst);
							(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
							(base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL)));
							(base_property_type == NULL ? NULL : (base_property_type = (g_object_unref (base_property_type), NULL)));
							(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							(typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL)));
						} else {
							ValaCCodeFunctionCall* ccall;
							ValaCCodeFunctionCall* ccast;
							ValaCCodeConstant* __temp1023;
							ValaVariableDeclarator* temp_decl;
							ValaVariableDeclarator* __temp1024;
							ValaCCodeIdentifier* ctemp;
							ValaCCodeUnaryExpression* __temp1025;
							ValaCCodeConstant* __temp1026;
							ValaCCodeCommaExpression* ccomma;
							ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_object_get")));
							ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT")));
							vala_ccode_function_call_add_argument (ccast, pub_inst);
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
							/* property name is second argument of g_object_get*/
							__temp1023 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1023 = vala_property_get_canonical_cconstant (prop))));
							(__temp1023 = (g_object_unref (__temp1023), NULL));
							/* we need a temporary variable to save the property value*/
							temp_decl = vala_code_generator_get_temp_variable_declarator (self, vala_expression_get_static_type (VALA_EXPRESSION (expr)), TRUE);
							__temp1024 = NULL;
							self->priv->temp_vars = g_list_prepend (self->priv->temp_vars, (__temp1024 = temp_decl, (__temp1024 == NULL ? NULL : g_object_ref (__temp1024))));
							ctemp = vala_ccode_identifier_new (vala_variable_declarator_get_name (temp_decl));
							__temp1025 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1025 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (ctemp)))));
							(__temp1025 == NULL ? NULL : (__temp1025 = (g_object_unref (__temp1025), NULL)));
							__temp1026 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1026 = vala_ccode_constant_new ("NULL"))));
							(__temp1026 == NULL ? NULL : (__temp1026 = (g_object_unref (__temp1026), NULL)));
							ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
							vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
							vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ctemp));
							(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
							(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
							(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
							(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
							(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
							(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
						}
						(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
					} else {
						if (VALA_IS_ENUM_VALUE (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
							ValaEnumValue* __temp1027;
							ValaEnumValue* ev;
							ValaCCodeConstant* __temp1028;
							__temp1027 = NULL;
							ev = (__temp1027 = VALA_ENUM_VALUE (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp1027 == NULL ? NULL : g_object_ref (__temp1027)));
							__temp1028 = NULL;
							(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1028 = vala_ccode_constant_new (vala_enum_value_get_cname (ev))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
							(__temp1028 == NULL ? NULL : (__temp1028 = (g_object_unref (__temp1028), NULL)));
							(ev == NULL ? NULL : (ev = (g_object_unref (ev), NULL)));
						} else {
							if (VALA_IS_VARIABLE_DECLARATOR (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
								ValaVariableDeclarator* __temp1029;
								ValaVariableDeclarator* decl;
								ValaCCodeIdentifier* __temp1030;
								__temp1029 = NULL;
								decl = (__temp1029 = VALA_VARIABLE_DECLARATOR (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp1029 == NULL ? NULL : g_object_ref (__temp1029)));
								__temp1030 = NULL;
								(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1030 = vala_ccode_identifier_new (vala_code_generator_get_variable_cname (self, vala_variable_declarator_get_name (decl)))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
								(__temp1030 == NULL ? NULL : (__temp1030 = (g_object_unref (__temp1030), NULL)));
								(decl == NULL ? NULL : (decl = (g_object_unref (decl), NULL)));
							} else {
								if (VALA_IS_FORMAL_PARAMETER (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
									ValaFormalParameter* __temp1031;
									ValaFormalParameter* p;
									__temp1031 = NULL;
									p = (__temp1031 = VALA_FORMAL_PARAMETER (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp1031 == NULL ? NULL : g_object_ref (__temp1031)));
									if (g_utf8_collate (vala_formal_parameter_get_name (p), "this") == 0) {
										(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (pub_inst)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
									} else {
										if (vala_type_reference_get_is_out (vala_formal_parameter_get_type_reference (p)) || vala_type_reference_get_is_ref (vala_formal_parameter_get_type_reference (p))) {
											ValaCCodeIdentifier* __temp1032;
											__temp1032 = NULL;
											(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1032 = vala_ccode_identifier_new (g_strdup_printf ("(*%s)", vala_formal_parameter_get_name (p)))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
											(__temp1032 == NULL ? NULL : (__temp1032 = (g_object_unref (__temp1032), NULL)));
										} else {
											ValaCCodeIdentifier* __temp1033;
											__temp1033 = NULL;
											(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((__temp1033 = vala_ccode_identifier_new (vala_formal_parameter_get_name (p))))), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
											(__temp1033 == NULL ? NULL : (__temp1033 = (g_object_unref (__temp1033), NULL)));
										}
									}
									(p == NULL ? NULL : (p = (g_object_unref (p), NULL)));
								} else {
									if (VALA_IS_SIGNAL (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))))) {
										ValaSignal* __temp1034;
										ValaSignal* sig;
										ValaDataType* __temp1035;
										ValaDataType* cl;
										__temp1034 = NULL;
										sig = (__temp1034 = VALA_SIGNAL (vala_symbol_get_node (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))), (__temp1034 == NULL ? NULL : g_object_ref (__temp1034)));
										__temp1035 = NULL;
										cl = (__temp1035 = VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (sig))))), (__temp1035 == NULL ? NULL : g_object_ref (__temp1035)));
										if (vala_signal_get_has_emitter (sig)) {
											char* __temp1036;
											ValaCCodeFunctionCall* __temp1037;
											ValaCCodeFunctionCall* ccall;
											ValaCCodeExpression* __temp1038;
											ValaCCodeExpression* typed_pub_inst;
											__temp1036 = NULL;
											__temp1037 = NULL;
											ccall = (__temp1037 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_%s", (__temp1036 = vala_data_type_get_lower_case_cname (cl, NULL)), vala_signal_get_name (sig))))), (__temp1036 = (g_free (__temp1036), NULL)), __temp1037);
											/* explicitly use strong reference as ccast
											 * gets unrefed at the end of the inner block
											 */
											__temp1038 = NULL;
											typed_pub_inst = (__temp1038 = pub_inst, (__temp1038 == NULL ? NULL : g_object_ref (__temp1038)));
											/* cast if necessary */
											if (cl != base_type) {
												ValaCCodeFunctionCall* ccast;
												ValaCCodeExpression* __temp1040;
												ValaCCodeFunctionCall* __temp1039;
												/* FIXME: use C cast if debugging disabled*/
												ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (cl, NULL))));
												vala_ccode_function_call_add_argument (ccast, pub_inst);
												__temp1040 = NULL;
												__temp1039 = NULL;
												typed_pub_inst = (__temp1040 = VALA_CCODE_EXPRESSION ((__temp1039 = ccast, (__temp1039 == NULL ? NULL : g_object_ref (__temp1039)))), (typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL))), __temp1040);
												(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
											}
											vala_ccode_function_call_add_argument (ccall, typed_pub_inst);
											(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
											(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
											(typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL)));
										} else {
											ValaCCodeFunctionCall* ccall;
											ValaCCodeFunctionCall* ccast;
											ValaCCodeConstant* __temp1041;
											ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_signal_emit_by_name")));
											/* FIXME: use C cast if debugging disabled*/
											ccast = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("G_OBJECT")));
											vala_ccode_function_call_add_argument (ccast, pub_inst);
											vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
											__temp1041 = NULL;
											vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1041 = vala_signal_get_canonical_cconstant (sig))));
											(__temp1041 = (g_object_unref (__temp1041), NULL));
											(vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall)), vala_code_node_get_ccodenode (VALA_CODE_NODE (expr)));
											(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
											(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
										}
										(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
										(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static void vala_code_generator_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr)
{
	ValaCodeGenerator * self;
	ValaCCodeExpression* pub_inst;
	ValaDataType* base_type;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_MEMBER_ACCESS (expr));
	pub_inst = NULL;
	base_type = NULL;
	if (vala_member_access_get_inner (expr) == NULL) {
		ValaCCodeExpression* __temp1042;
		__temp1042 = NULL;
		pub_inst = (__temp1042 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), __temp1042);
		if (self->priv->current_type_symbol != NULL) {
			ValaDataType* __temp1044;
			ValaDataType* __temp1043;
			/* base type is available if this is a type method */
			__temp1044 = NULL;
			__temp1043 = NULL;
			base_type = (__temp1044 = (__temp1043 = VALA_DATA_TYPE (vala_symbol_get_node (self->priv->current_type_symbol)), (__temp1043 == NULL ? NULL : g_object_ref (__temp1043))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), __temp1044);
			if (!vala_data_type_is_reference_type (base_type)) {
				ValaCCodeExpression* __temp1045;
				__temp1045 = NULL;
				pub_inst = (__temp1045 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("(*self)")), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), __temp1045);
			}
		}
	} else {
		ValaCCodeExpression* __temp1047;
		ValaCCodeExpression* __temp1046;
		__temp1047 = NULL;
		__temp1046 = NULL;
		pub_inst = (__temp1047 = (__temp1046 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (expr)))), (__temp1046 == NULL ? NULL : g_object_ref (__temp1046))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), __temp1047);
		if (vala_expression_get_static_type (vala_member_access_get_inner (expr)) != NULL) {
			ValaDataType* __temp1049;
			ValaDataType* __temp1048;
			__temp1049 = NULL;
			__temp1048 = NULL;
			base_type = (__temp1049 = (__temp1048 = vala_type_reference_get_data_type (vala_expression_get_static_type (vala_member_access_get_inner (expr))), (__temp1048 == NULL ? NULL : g_object_ref (__temp1048))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), __temp1049);
		}
	}
	vala_code_generator_process_cmember (self, expr, pub_inst, base_type);
	vala_code_generator_visit_expression (self, VALA_EXPRESSION (expr));
	(pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL)));
	(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
}


static void vala_code_generator_real_visit_method (ValaCodeVisitor* base, ValaMethod* m)
{
	ValaCodeGenerator * self;
	ValaMethod* __temp1050;
	ValaMethod* old_method;
	ValaTypeReference* __temp1051;
	ValaTypeReference* old_return_type;
	gboolean old_method_inner_error;
	ValaSymbol* __temp1053;
	ValaSymbol* __temp1052;
	ValaMethod* __temp1054;
	ValaTypeReference* __temp1056;
	ValaTypeReference* __temp1055;
	gboolean inner_error;
	ValaSymbol* __temp1058;
	ValaSymbol* __temp1057;
	ValaMethod* __temp1060;
	ValaMethod* __temp1059;
	ValaTypeReference* __temp1062;
	ValaTypeReference* __temp1061;
	ValaCCodeFunction* __temp1064;
	ValaCCodeFunctionDeclarator* vdeclarator;
	ValaCCodeFormalParameter* instance_param;
	GList* params;
	GList* __temp1078;
	gboolean __temp1079;
	gboolean return_value;
	gboolean args_parameter;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_METHOD (m));
	__temp1050 = NULL;
	old_method = (__temp1050 = self->priv->current_method, (__temp1050 == NULL ? NULL : g_object_ref (__temp1050)));
	__temp1051 = NULL;
	old_return_type = (__temp1051 = self->priv->current_return_type, (__temp1051 == NULL ? NULL : g_object_ref (__temp1051)));
	old_method_inner_error = self->priv->current_method_inner_error;
	__temp1053 = NULL;
	__temp1052 = NULL;
	self->priv->current_symbol = (__temp1053 = (__temp1052 = vala_code_node_get_symbol (VALA_CODE_NODE (m)), (__temp1052 == NULL ? NULL : g_object_ref (__temp1052))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp1053);
	__temp1054 = NULL;
	self->priv->current_method = (__temp1054 = g_object_ref (m), (self->priv->current_method == NULL ? NULL : (self->priv->current_method = (g_object_unref (self->priv->current_method), NULL))), __temp1054);
	__temp1056 = NULL;
	__temp1055 = NULL;
	self->priv->current_return_type = (__temp1056 = (__temp1055 = vala_method_get_return_type (m), (__temp1055 == NULL ? NULL : g_object_ref (__temp1055))), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), __temp1056);
	self->priv->current_method_inner_error = FALSE;
	if (VALA_IS_CREATION_METHOD (m)) {
		self->priv->in_creation_method = TRUE;
	}
	vala_code_node_accept_children (VALA_CODE_NODE (m), VALA_CODE_VISITOR (self));
	if (VALA_IS_CREATION_METHOD (m)) {
		if (self->priv->current_class != NULL && vala_method_get_body (m) != NULL) {
			vala_code_generator_add_object_creation (self, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_method_get_body (m)))));
		}
		self->priv->in_creation_method = FALSE;
	}
	inner_error = self->priv->current_method_inner_error;
	__temp1058 = NULL;
	__temp1057 = NULL;
	self->priv->current_symbol = (__temp1058 = (__temp1057 = vala_symbol_get_parent_symbol (self->priv->current_symbol), (__temp1057 == NULL ? NULL : g_object_ref (__temp1057))), (self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL))), __temp1058);
	__temp1060 = NULL;
	__temp1059 = NULL;
	self->priv->current_method = (__temp1060 = (__temp1059 = self->priv->current_method, (__temp1059 == NULL ? NULL : g_object_ref (__temp1059))), (self->priv->current_method == NULL ? NULL : (self->priv->current_method = (g_object_unref (self->priv->current_method), NULL))), __temp1060);
	__temp1062 = NULL;
	__temp1061 = NULL;
	self->priv->current_return_type = (__temp1062 = (__temp1061 = old_return_type, (__temp1061 == NULL ? NULL : g_object_ref (__temp1061))), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL))), __temp1062);
	self->priv->current_method_inner_error = old_method_inner_error;
	if (self->priv->current_type_symbol != NULL && VALA_IS_INTERFACE (vala_symbol_get_node (self->priv->current_type_symbol))) {
		ValaInterface* __temp1063;
		ValaInterface* iface;
		__temp1063 = NULL;
		iface = (__temp1063 = VALA_INTERFACE (vala_symbol_get_node (self->priv->current_type_symbol)), (__temp1063 == NULL ? NULL : g_object_ref (__temp1063)));
		if (vala_interface_get_is_static (iface)) {
			(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
			(old_method == NULL ? NULL : (old_method = (g_object_unref (old_method), NULL)));
			(old_return_type == NULL ? NULL : (old_return_type = (g_object_unref (old_return_type), NULL)));
			return;
		}
		(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
	}
	__temp1064 = NULL;
	self->priv->function = (__temp1064 = vala_ccode_function_new (vala_method_get_real_cname (m), vala_type_reference_get_cname (vala_method_get_return_type (m), FALSE, FALSE)), (self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL))), __temp1064);
	vdeclarator = NULL;
	instance_param = NULL;
	if (vala_method_get_instance (m)) {
		ValaTypeReference* this_type;
		ValaDataType* __temp1065;
		this_type = vala_type_reference_new ();
		__temp1065 = NULL;
		(vala_type_reference_set_data_type (this_type, (__temp1065 = vala_code_generator_find_parent_type (self, VALA_CODE_NODE (m)))), vala_type_reference_get_data_type (this_type));
		(__temp1065 == NULL ? NULL : (__temp1065 = (g_object_unref (__temp1065), NULL)));
		if (vala_method_get_base_interface_method (m) != NULL) {
			ValaTypeReference* base_type;
			ValaCCodeFormalParameter* __temp1066;
			base_type = vala_type_reference_new ();
			(vala_type_reference_set_data_type (base_type, VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (vala_method_get_base_interface_method (m))))))), vala_type_reference_get_data_type (base_type));
			__temp1066 = NULL;
			instance_param = (__temp1066 = vala_ccode_formal_parameter_new ("base", vala_type_reference_get_cname (base_type, FALSE, FALSE)), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), __temp1066);
			(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
		} else {
			if (vala_method_get_overrides (m)) {
				ValaTypeReference* base_type;
				ValaCCodeFormalParameter* __temp1067;
				base_type = vala_type_reference_new ();
				(vala_type_reference_set_data_type (base_type, VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (vala_method_get_base_method (m))))))), vala_type_reference_get_data_type (base_type));
				__temp1067 = NULL;
				instance_param = (__temp1067 = vala_ccode_formal_parameter_new ("base", vala_type_reference_get_cname (base_type, FALSE, FALSE)), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), __temp1067);
				(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
			} else {
				if (vala_method_get_instance_by_reference (m)) {
					ValaCCodeFormalParameter* __temp1068;
					__temp1068 = NULL;
					instance_param = (__temp1068 = vala_ccode_formal_parameter_new ("*self", vala_type_reference_get_cname (this_type, FALSE, FALSE)), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), __temp1068);
				} else {
					ValaCCodeFormalParameter* __temp1069;
					__temp1069 = NULL;
					instance_param = (__temp1069 = vala_ccode_formal_parameter_new ("self", vala_type_reference_get_cname (this_type, FALSE, FALSE)), (instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL))), __temp1069);
				}
			}
		}
		if (!vala_method_get_instance_last (m)) {
			vala_ccode_function_add_parameter (self->priv->function, instance_param);
		}
		if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m)) {
			ValaCCodeDeclaration* vdecl;
			ValaCCodeFunctionDeclarator* __temp1070;
			vdecl = vala_ccode_declaration_new (vala_type_reference_get_cname (vala_method_get_return_type (m), FALSE, FALSE));
			__temp1070 = NULL;
			vdeclarator = (__temp1070 = vala_ccode_function_declarator_new (vala_method_get_name (m)), (vdeclarator == NULL ? NULL : (vdeclarator = (g_object_unref (vdeclarator), NULL))), __temp1070);
			vala_ccode_declaration_add_declarator (vdecl, VALA_CCODE_DECLARATOR (vdeclarator));
			vala_ccode_struct_add_declaration (self->priv->type_struct, vdecl);
			vala_ccode_function_declarator_add_parameter (vdeclarator, instance_param);
			(vdecl == NULL ? NULL : (vdecl = (g_object_unref (vdecl), NULL)));
		}
		(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
	}
	if (VALA_IS_CREATION_METHOD (m) && self->priv->current_class != NULL) {
		{
			GList* __temp1073;
			GList* type_param_it;
			__temp1073 = NULL;
			__temp1073 = vala_class_get_type_parameters (self->priv->current_class);
			for (type_param_it = __temp1073; type_param_it != NULL; type_param_it = type_param_it->next) {
				ValaTypeParameter* type_param;
				type_param = type_param_it->data;
				{
					char* __temp1071;
					ValaCCodeFormalParameter* __temp1072;
					ValaCCodeFormalParameter* cparam;
					/* memory management for generic types*/
					__temp1071 = NULL;
					__temp1072 = NULL;
					cparam = (__temp1072 = vala_ccode_formal_parameter_new (g_strdup_printf ("%s_destroy_func", (__temp1071 = g_utf8_strdown (vala_type_parameter_get_name (type_param), -1))), "GDestroyNotify"), (__temp1071 = (g_free (__temp1071), NULL)), __temp1072);
					vala_ccode_function_add_parameter (self->priv->function, cparam);
					(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
				}
			}
			(__temp1073 == NULL ? NULL : (__temp1073 = (g_list_free (__temp1073), NULL)));
		}
	}
	params = vala_invokable_get_parameters (VALA_INVOKABLE (m));
	{
		GList* __temp1076;
		GList* param_it;
		__temp1076 = NULL;
		__temp1076 = params;
		for (param_it = __temp1076; param_it != NULL; param_it = param_it->next) {
			ValaFormalParameter* param;
			param = param_it->data;
			{
				if (!vala_formal_parameter_get_no_array_length (param) && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)))) {
					ValaArray* __temp1074;
					ValaArray* arr;
					char* length_ctype;
					__temp1074 = NULL;
					arr = (__temp1074 = VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))), (__temp1074 == NULL ? NULL : g_object_ref (__temp1074)));
					length_ctype = g_strdup ("int");
					if (vala_type_reference_get_is_out (vala_formal_parameter_get_type_reference (param))) {
						char* __temp1075;
						__temp1075 = NULL;
						length_ctype = (__temp1075 = g_strdup ("int*"), (length_ctype = (g_free (length_ctype), NULL)), __temp1075);
					}
					{
						gint dim;
						dim = 0;
						for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
							ValaCCodeFormalParameter* cparam;
							cparam = vala_ccode_formal_parameter_new (vala_code_generator_get_array_length_cname (self, vala_formal_parameter_get_name (param), dim), length_ctype);
							vala_ccode_function_add_parameter (self->priv->function, cparam);
							if (vdeclarator != NULL) {
								vala_ccode_function_declarator_add_parameter (vdeclarator, cparam);
							}
							(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
						}
					}
					(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
					(length_ctype = (g_free (length_ctype), NULL));
				}
				vala_ccode_function_add_parameter (self->priv->function, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
				if (vdeclarator != NULL) {
					vala_ccode_function_declarator_add_parameter (vdeclarator, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
				}
			}
		}
	}
	/* return array length if appropriate*/
	if (!vala_method_get_no_array_length (m) && VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_method_get_return_type (m)))) {
		ValaArray* __temp1077;
		ValaArray* arr;
		__temp1077 = NULL;
		arr = (__temp1077 = VALA_ARRAY (vala_type_reference_get_data_type (vala_method_get_return_type (m))), (__temp1077 == NULL ? NULL : g_object_ref (__temp1077)));
		{
			gint dim;
			dim = 0;
			for (dim = 1; dim <= vala_array_get_rank (arr); dim++) {
				ValaCCodeFormalParameter* cparam;
				cparam = vala_ccode_formal_parameter_new (vala_code_generator_get_array_length_cname (self, "result", dim), "int*");
				vala_ccode_function_add_parameter (self->priv->function, cparam);
				if (vdeclarator != NULL) {
					vala_ccode_function_declarator_add_parameter (vdeclarator, cparam);
				}
				(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
			}
		}
		(arr == NULL ? NULL : (arr = (g_object_unref (arr), NULL)));
	}
	if (vala_method_get_instance (m) && vala_method_get_instance_last (m)) {
		vala_ccode_function_add_parameter (self->priv->function, instance_param);
	}
	__temp1078 = NULL;
	if ((__temp1079 = g_list_length ((__temp1078 = vala_method_get_error_domains (m))) > 0, (__temp1078 == NULL ? NULL : (__temp1078 = (g_list_free (__temp1078), NULL))), __temp1079)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("error", "GError**");
		vala_ccode_function_add_parameter (self->priv->function, cparam);
		if (vdeclarator != NULL) {
			vala_ccode_function_declarator_add_parameter (vdeclarator, cparam);
		}
		(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
	}
	/* real function declaration and definition not needed
	 * for abstract methods */
	if (!vala_method_get_is_abstract (m)) {
		if (m->access != VALA_MEMBER_ACCESSIBILITY_PRIVATE && vala_method_get_base_method (m) == NULL && vala_method_get_base_interface_method (m) == NULL) {
			ValaCCodeFunction* __temp1080;
			/* public methods need function declaration in
			 * header file except virtual/overridden methods */
			__temp1080 = NULL;
			vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp1080 = vala_ccode_function_copy (self->priv->function))));
			(__temp1080 = (g_object_unref (__temp1080), NULL));
		} else {
			ValaCCodeFunction* __temp1081;
			/* declare all other functions in source file to
			 * avoid dependency on order within source file */
			(vala_ccode_function_set_modifiers (self->priv->function, vala_ccode_function_get_modifiers (self->priv->function) | (VALA_CCODE_MODIFIERS_STATIC)), vala_ccode_function_get_modifiers (self->priv->function));
			__temp1081 = NULL;
			vala_ccode_fragment_append (self->priv->source_type_member_declaration, VALA_CCODE_NODE ((__temp1081 = vala_ccode_function_copy (self->priv->function))));
			(__temp1081 = (g_object_unref (__temp1081), NULL));
		}
		/* Methods imported from a plain C file don't
		 * have a body, e.g. Vala.Parser.parse_file () */
		if (vala_method_get_body (m) != NULL) {
			ValaCCodeFragment* cinit;
			(vala_ccode_function_set_block (self->priv->function, VALA_CCODE_BLOCK (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_method_get_body (m))))), vala_ccode_function_get_block (self->priv->function));
			cinit = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL);
			vala_ccode_block_prepend_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE (cinit));
			if (VALA_IS_CLASS (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m)))))) {
				ValaClass* __temp1082;
				ValaClass* cl;
				__temp1082 = NULL;
				cl = (__temp1082 = VALA_CLASS (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m))))), (__temp1082 == NULL ? NULL : g_object_ref (__temp1082)));
				if (vala_method_get_overrides (m) || vala_method_get_base_interface_method (m) != NULL) {
					ValaCCodeFunctionCall* ccall;
					ValaCCodeIdentifier* __temp1083;
					char* __temp1084;
					ValaCCodeDeclaration* __temp1085;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* __temp1086;
					ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL))));
					__temp1083 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1083 = vala_ccode_identifier_new ("base"))));
					(__temp1083 == NULL ? NULL : (__temp1083 = (g_object_unref (__temp1083), NULL)));
					__temp1084 = NULL;
					__temp1085 = NULL;
					cdecl_ = (__temp1085 = vala_ccode_declaration_new (g_strdup_printf ("%s *", (__temp1084 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))), (__temp1084 = (g_free (__temp1084), NULL)), __temp1085);
					__temp1086 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp1086 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
					(__temp1086 == NULL ? NULL : (__temp1086 = (g_object_unref (__temp1086), NULL)));
					vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
					(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				} else {
					if (vala_method_get_instance (m)) {
						ValaCCodeStatement* __temp1087;
						__temp1087 = NULL;
						vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((__temp1087 = vala_code_generator_create_method_type_check_statement (self, m, VALA_DATA_TYPE (cl), TRUE, "self"))));
						(__temp1087 == NULL ? NULL : (__temp1087 = (g_object_unref (__temp1087), NULL)));
					}
				}
				(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
			}
			{
				GList* __temp1089;
				GList* param_it;
				__temp1089 = NULL;
				__temp1089 = vala_invokable_get_parameters (VALA_INVOKABLE (m));
				for (param_it = __temp1089; param_it != NULL; param_it = param_it->next) {
					ValaFormalParameter* param;
					param = param_it->data;
					{
						ValaDataType* __temp1088;
						ValaDataType* t;
						__temp1088 = NULL;
						t = (__temp1088 = vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param)), (__temp1088 == NULL ? NULL : g_object_ref (__temp1088)));
						if (t != NULL && vala_data_type_is_reference_type (t) && !vala_type_reference_get_is_out (vala_formal_parameter_get_type_reference (param))) {
							ValaCCodeStatement* type_check;
							type_check = vala_code_generator_create_method_type_check_statement (self, m, t, vala_type_reference_get_non_null (vala_formal_parameter_get_type_reference (param)), vala_formal_parameter_get_name (param));
							if (type_check != NULL) {
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (type_check));
							}
							(type_check == NULL ? NULL : (type_check = (g_object_unref (type_check), NULL)));
						}
						(t == NULL ? NULL : (t = (g_object_unref (t), NULL)));
					}
				}
				(__temp1089 == NULL ? NULL : (__temp1089 = (g_list_free (__temp1089), NULL)));
			}
			if (inner_error) {
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* __temp1090;
				/* always separate error parameter and inner_error local variable
				 * as error may be set to NULL but we're always interested in inner errors
				 */
				cdecl_ = vala_ccode_declaration_new ("GError *");
				__temp1090 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp1090 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"))))));
				(__temp1090 == NULL ? NULL : (__temp1090 = (g_object_unref (__temp1090), NULL)));
				vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
				(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
			}
			if (vala_code_node_get_source_reference (VALA_CODE_NODE (m)) != NULL && vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m))) != NULL) {
				ValaCCodeComment* __temp1091;
				__temp1091 = NULL;
				vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE ((__temp1091 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (m)))))));
				(__temp1091 == NULL ? NULL : (__temp1091 = (g_object_unref (__temp1091), NULL)));
			}
			vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (self->priv->function));
			if (VALA_IS_CREATION_METHOD (m)) {
				if (self->priv->current_class != NULL) {
					gint n_params;
					GList* __temp1092;
					ValaCCodeFunctionCall* cparamsinit;
					ValaCCodeIdentifier* __temp1093;
					ValaCCodeConstant* __temp1094;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* __temp1095;
					ValaCCodeDeclaration* __temp1096;
					ValaCCodeVariableDeclarator* __temp1097;
					n_params = vala_creation_method_get_n_construction_params ((VALA_CREATION_METHOD (m)));
					__temp1092 = NULL;
					n_params = n_params + (((gint) g_list_length ((__temp1092 = vala_class_get_type_parameters (self->priv->current_class)))));
					(__temp1092 == NULL ? NULL : (__temp1092 = (g_list_free (__temp1092), NULL)));
					/* declare construction parameter array*/
					cparamsinit = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_new0")));
					__temp1093 = NULL;
					vala_ccode_function_call_add_argument (cparamsinit, VALA_CCODE_EXPRESSION ((__temp1093 = vala_ccode_identifier_new ("GParameter"))));
					(__temp1093 == NULL ? NULL : (__temp1093 = (g_object_unref (__temp1093), NULL)));
					__temp1094 = NULL;
					vala_ccode_function_call_add_argument (cparamsinit, VALA_CCODE_EXPRESSION ((__temp1094 = vala_ccode_constant_new (g_strdup_printf ("%i", n_params)))));
					(__temp1094 == NULL ? NULL : (__temp1094 = (g_object_unref (__temp1094), NULL)));
					cdecl_ = vala_ccode_declaration_new ("GParameter *");
					__temp1095 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp1095 = vala_ccode_variable_declarator_new_with_initializer ("__params", VALA_CCODE_EXPRESSION (cparamsinit)))));
					(__temp1095 == NULL ? NULL : (__temp1095 = (g_object_unref (__temp1095), NULL)));
					vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
					__temp1096 = NULL;
					cdecl_ = (__temp1096 = vala_ccode_declaration_new ("GParameter *"), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), __temp1096);
					__temp1097 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp1097 = vala_ccode_variable_declarator_new_with_initializer ("__params_it", VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("__params"))))));
					(__temp1097 == NULL ? NULL : (__temp1097 = (g_object_unref (__temp1097), NULL)));
					vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
					{
						GList* __temp1107;
						GList* type_param_it;
						__temp1107 = NULL;
						__temp1107 = vala_class_get_type_parameters (self->priv->current_class);
						for (type_param_it = __temp1107; type_param_it != NULL; type_param_it = type_param_it->next) {
							ValaTypeParameter* type_param;
							type_param = type_param_it->data;
							{
								char* __temp1098;
								char* __temp1099;
								char* func_name;
								char* __temp1100;
								ValaCCodeConstant* __temp1101;
								ValaCCodeConstant* func_name_constant;
								ValaCCodeIdentifier* cpointer;
								ValaCCodeCommaExpression* ccomma;
								ValaCCodeMemberAccess* cnamemember;
								ValaCCodeAssignment* __temp1102;
								ValaCCodeUnaryExpression* gvaluearg;
								ValaCCodeFunctionCall* cvalueinit;
								ValaCCodeIdentifier* __temp1103;
								ValaCCodeFunctionCall* cvalueset;
								ValaCCodeIdentifier* __temp1104;
								ValaCCodeUnaryExpression* __temp1105;
								ValaCCodeExpressionStatement* __temp1106;
								/* destroy func properties for generic types */
								__temp1098 = NULL;
								__temp1099 = NULL;
								func_name = (__temp1099 = g_strdup_printf ("%s_destroy_func", (__temp1098 = g_utf8_strdown (vala_type_parameter_get_name (type_param), -1))), (__temp1098 = (g_free (__temp1098), NULL)), __temp1099);
								__temp1100 = NULL;
								__temp1101 = NULL;
								func_name_constant = (__temp1101 = vala_ccode_constant_new (g_strdup_printf ("\"%s-destroy-func\"", (__temp1100 = g_utf8_strdown (vala_type_parameter_get_name (type_param), -1)))), (__temp1100 = (g_free (__temp1100), NULL)), __temp1101);
								/* this property is used as a construction parameter*/
								cpointer = vala_ccode_identifier_new ("__params_it");
								ccomma = g_object_new (VALA_TYPE_CCODE_COMMA_EXPRESSION, NULL);
								/* set name in array for current parameter*/
								cnamemember = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (cpointer), "name");
								__temp1102 = NULL;
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp1102 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cnamemember), VALA_CCODE_EXPRESSION (func_name_constant), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))));
								(__temp1102 == NULL ? NULL : (__temp1102 = (g_object_unref (__temp1102), NULL)));
								gvaluearg = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (cpointer), "value")));
								/* initialize GValue in array for current parameter*/
								cvalueinit = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_value_init")));
								vala_ccode_function_call_add_argument (cvalueinit, VALA_CCODE_EXPRESSION (gvaluearg));
								__temp1103 = NULL;
								vala_ccode_function_call_add_argument (cvalueinit, VALA_CCODE_EXPRESSION ((__temp1103 = vala_ccode_identifier_new ("G_TYPE_POINTER"))));
								(__temp1103 == NULL ? NULL : (__temp1103 = (g_object_unref (__temp1103), NULL)));
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvalueinit));
								/* set GValue for current parameter*/
								cvalueset = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_value_set_pointer")));
								vala_ccode_function_call_add_argument (cvalueset, VALA_CCODE_EXPRESSION (gvaluearg));
								__temp1104 = NULL;
								vala_ccode_function_call_add_argument (cvalueset, VALA_CCODE_EXPRESSION ((__temp1104 = vala_ccode_identifier_new (func_name))));
								(__temp1104 == NULL ? NULL : (__temp1104 = (g_object_unref (__temp1104), NULL)));
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (cvalueset));
								/* move pointer to next parameter in array*/
								__temp1105 = NULL;
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION ((__temp1105 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, VALA_CCODE_EXPRESSION (cpointer)))));
								(__temp1105 == NULL ? NULL : (__temp1105 = (g_object_unref (__temp1105), NULL)));
								__temp1106 = NULL;
								vala_ccode_fragment_append (cinit, VALA_CCODE_NODE ((__temp1106 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccomma)))));
								(__temp1106 == NULL ? NULL : (__temp1106 = (g_object_unref (__temp1106), NULL)));
								(func_name = (g_free (func_name), NULL));
								(func_name_constant == NULL ? NULL : (func_name_constant = (g_object_unref (func_name_constant), NULL)));
								(cpointer == NULL ? NULL : (cpointer = (g_object_unref (cpointer), NULL)));
								(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
								(cnamemember == NULL ? NULL : (cnamemember = (g_object_unref (cnamemember), NULL)));
								(gvaluearg == NULL ? NULL : (gvaluearg = (g_object_unref (gvaluearg), NULL)));
								(cvalueinit == NULL ? NULL : (cvalueinit = (g_object_unref (cvalueinit), NULL)));
								(cvalueset == NULL ? NULL : (cvalueset = (g_object_unref (cvalueset), NULL)));
							}
						}
						(__temp1107 == NULL ? NULL : (__temp1107 = (g_list_free (__temp1107), NULL)));
					}
					(cparamsinit == NULL ? NULL : (cparamsinit = (g_object_unref (cparamsinit), NULL)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
				} else {
					ValaStruct* __temp1108;
					ValaStruct* st;
					char* __temp1109;
					ValaCCodeDeclaration* __temp1110;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeFunctionCall* ccall;
					ValaCCodeConstant* __temp1111;
					ValaCCodeConstant* __temp1112;
					ValaCCodeVariableDeclarator* __temp1113;
					__temp1108 = NULL;
					st = (__temp1108 = VALA_STRUCT (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m))))), (__temp1108 == NULL ? NULL : g_object_ref (__temp1108)));
					__temp1109 = NULL;
					__temp1110 = NULL;
					cdecl_ = (__temp1110 = vala_ccode_declaration_new (g_strconcat ((__temp1109 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)), "*", NULL)), (__temp1109 = (g_free (__temp1109), NULL)), __temp1110);
					ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_new0")));
					__temp1111 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1111 = vala_ccode_constant_new (vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)))));
					(__temp1111 == NULL ? NULL : (__temp1111 = (g_object_unref (__temp1111), NULL)));
					__temp1112 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((__temp1112 = vala_ccode_constant_new ("1"))));
					(__temp1112 == NULL ? NULL : (__temp1112 = (g_object_unref (__temp1112), NULL)));
					__temp1113 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((__temp1113 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
					(__temp1113 == NULL ? NULL : (__temp1113 = (g_object_unref (__temp1113), NULL)));
					vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (cdecl_));
					(st == NULL ? NULL : (st = (g_object_unref (st), NULL)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
					(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
				}
			}
			if (vala_code_context_get_module_init_method (self->priv->context) == m && self->priv->in_plugin) {
				/* GTypeModule-based plug-in, register types*/
				vala_ccode_fragment_append (cinit, VALA_CCODE_NODE (self->priv->module_init_fragment));
			}
			(cinit == NULL ? NULL : (cinit = (g_object_unref (cinit), NULL)));
		}
	}
	if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m)) {
		ValaCCodeFunction* vfunc;
		ValaTypeReference* this_type;
		ValaCCodeFormalParameter* cparam;
		ValaCCodeBlock* vblock;
		ValaCCodeFunctionCall* vcast;
		ValaCCodeIdentifier* __temp1120;
		ValaCCodeFunctionCall* vcall;
		ValaCCodeIdentifier* __temp1121;
		GList* params;
		ValaCCodeFunction* __temp1126;
		vfunc = vala_ccode_function_new (vala_method_get_cname (m), vala_type_reference_get_cname (vala_method_get_return_type (m), FALSE, FALSE));
		this_type = vala_type_reference_new ();
		(vala_type_reference_set_data_type (this_type, VALA_DATA_TYPE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m)))))), vala_type_reference_get_data_type (this_type));
		cparam = vala_ccode_formal_parameter_new ("self", vala_type_reference_get_cname (this_type, FALSE, FALSE));
		vala_ccode_function_add_parameter (vfunc, cparam);
		vblock = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		vcast = NULL;
		if (VALA_IS_INTERFACE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m)))))) {
			ValaInterface* __temp1114;
			ValaInterface* iface;
			ValaCCodeFunctionCall* __temp1116;
			char* __temp1115;
			__temp1114 = NULL;
			iface = (__temp1114 = VALA_INTERFACE (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m))))), (__temp1114 == NULL ? NULL : g_object_ref (__temp1114)));
			__temp1116 = NULL;
			__temp1115 = NULL;
			vcast = (__temp1116 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_GET_INTERFACE", (__temp1115 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (iface), NULL)))))), (vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL))), __temp1116);
			(__temp1115 = (g_free (__temp1115), NULL));
			(iface == NULL ? NULL : (iface = (g_object_unref (iface), NULL)));
		} else {
			ValaClass* __temp1117;
			ValaClass* cl;
			ValaCCodeFunctionCall* __temp1119;
			char* __temp1118;
			__temp1117 = NULL;
			cl = (__temp1117 = VALA_CLASS (vala_symbol_get_node (vala_symbol_get_parent_symbol (vala_code_node_get_symbol (VALA_CODE_NODE (m))))), (__temp1117 == NULL ? NULL : g_object_ref (__temp1117)));
			__temp1119 = NULL;
			__temp1118 = NULL;
			vcast = (__temp1119 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%s_GET_CLASS", (__temp1118 = vala_data_type_get_upper_case_cname (VALA_DATA_TYPE (cl), NULL)))))), (vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL))), __temp1119);
			(__temp1118 = (g_free (__temp1118), NULL));
			(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
		}
		__temp1120 = NULL;
		vala_ccode_function_call_add_argument (vcast, VALA_CCODE_EXPRESSION ((__temp1120 = vala_ccode_identifier_new ("self"))));
		(__temp1120 == NULL ? NULL : (__temp1120 = (g_object_unref (__temp1120), NULL)));
		vcall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vcast), vala_method_get_name (m))));
		__temp1121 = NULL;
		vala_ccode_function_call_add_argument (vcall, VALA_CCODE_EXPRESSION ((__temp1121 = vala_ccode_identifier_new ("self"))));
		(__temp1121 == NULL ? NULL : (__temp1121 = (g_object_unref (__temp1121), NULL)));
		params = vala_invokable_get_parameters (VALA_INVOKABLE (m));
		{
			GList* __temp1123;
			GList* param_it;
			__temp1123 = NULL;
			__temp1123 = params;
			for (param_it = __temp1123; param_it != NULL; param_it = param_it->next) {
				ValaFormalParameter* param;
				param = param_it->data;
				{
					ValaCCodeIdentifier* __temp1122;
					vala_ccode_function_add_parameter (vfunc, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
					__temp1122 = NULL;
					vala_ccode_function_call_add_argument (vcall, VALA_CCODE_EXPRESSION ((__temp1122 = vala_ccode_identifier_new (vala_formal_parameter_get_name (param)))));
					(__temp1122 == NULL ? NULL : (__temp1122 = (g_object_unref (__temp1122), NULL)));
				}
			}
		}
		if (vala_type_reference_get_data_type (vala_method_get_return_type (m)) == NULL) {
			ValaCCodeExpressionStatement* __temp1124;
			__temp1124 = NULL;
			vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE ((__temp1124 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vcall)))));
			(__temp1124 == NULL ? NULL : (__temp1124 = (g_object_unref (__temp1124), NULL)));
		} else {
			ValaCCodeReturnStatement* __temp1125;
			/* pass method return value */
			__temp1125 = NULL;
			vala_ccode_block_add_statement (vblock, VALA_CCODE_NODE ((__temp1125 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vcall)))));
			(__temp1125 == NULL ? NULL : (__temp1125 = (g_object_unref (__temp1125), NULL)));
		}
		__temp1126 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_member_declaration, VALA_CCODE_NODE ((__temp1126 = vala_ccode_function_copy (vfunc))));
		(__temp1126 = (g_object_unref (__temp1126), NULL));
		(vala_ccode_function_set_block (vfunc, vblock), vala_ccode_function_get_block (vfunc));
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (vfunc));
		(vfunc == NULL ? NULL : (vfunc = (g_object_unref (vfunc), NULL)));
		(this_type == NULL ? NULL : (this_type = (g_object_unref (this_type), NULL)));
		(cparam == NULL ? NULL : (cparam = (g_object_unref (cparam), NULL)));
		(vblock == NULL ? NULL : (vblock = (g_object_unref (vblock), NULL)));
		(vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL)));
		(vcall == NULL ? NULL : (vcall = (g_object_unref (vcall), NULL)));
		(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaCCodeReturnStatement* creturn;
		ValaCCodeIdentifier* __temp1127;
		creturn = vala_ccode_return_statement_new (NULL);
		__temp1127 = NULL;
		(vala_ccode_return_statement_set_return_expression (creturn, VALA_CCODE_EXPRESSION ((__temp1127 = vala_ccode_identifier_new ("self")))), vala_ccode_return_statement_get_return_expression (creturn));
		(__temp1127 == NULL ? NULL : (__temp1127 = (g_object_unref (__temp1127), NULL)));
		vala_ccode_block_add_statement (vala_ccode_function_get_block (self->priv->function), VALA_CCODE_NODE (creturn));
		(creturn == NULL ? NULL : (creturn = (g_object_unref (creturn), NULL)));
	}
	return_value = TRUE;
	args_parameter = TRUE;
	if (vala_code_generator_is_possible_entry_point (self, m, &return_value, &args_parameter)) {
		ValaCCodeFunction* cmain;
		ValaCCodeFormalParameter* __temp1128;
		ValaCCodeFormalParameter* __temp1129;
		ValaCCodeBlock* main_block;
		ValaCCodeExpressionStatement* __temp1132;
		ValaCCodeFunctionCall* main_call;
		/* m is possible entry point, add appropriate startup code*/
		cmain = vala_ccode_function_new ("main", "int");
		__temp1128 = NULL;
		vala_ccode_function_add_parameter (cmain, (__temp1128 = vala_ccode_formal_parameter_new ("argc", "int")));
		(__temp1128 == NULL ? NULL : (__temp1128 = (g_object_unref (__temp1128), NULL)));
		__temp1129 = NULL;
		vala_ccode_function_add_parameter (cmain, (__temp1129 = vala_ccode_formal_parameter_new ("argv", "char **")));
		(__temp1129 == NULL ? NULL : (__temp1129 = (g_object_unref (__temp1129), NULL)));
		main_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
		if (vala_code_context_get_thread (self->priv->context)) {
			ValaCCodeFunctionCall* thread_init_call;
			ValaCCodeConstant* __temp1130;
			ValaCCodeExpressionStatement* __temp1131;
			thread_init_call = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_thread_init")));
			__temp1130 = NULL;
			vala_ccode_function_call_add_argument (thread_init_call, VALA_CCODE_EXPRESSION ((__temp1130 = vala_ccode_constant_new ("NULL"))));
			(__temp1130 == NULL ? NULL : (__temp1130 = (g_object_unref (__temp1130), NULL)));
			__temp1131 = NULL;
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((__temp1131 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (thread_init_call)))));
			(__temp1131 == NULL ? NULL : (__temp1131 = (g_object_unref (__temp1131), NULL)));
			(thread_init_call == NULL ? NULL : (thread_init_call = (g_object_unref (thread_init_call), NULL)));
		}
		__temp1132 = NULL;
		vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((__temp1132 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_type_init"))))))));
		(__temp1132 == NULL ? NULL : (__temp1132 = (g_object_unref (__temp1132), NULL)));
		main_call = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_ccode_function_get_name (self->priv->function))));
		if (args_parameter) {
			ValaCCodeIdentifier* __temp1133;
			ValaCCodeIdentifier* __temp1134;
			__temp1133 = NULL;
			vala_ccode_function_call_add_argument (main_call, VALA_CCODE_EXPRESSION ((__temp1133 = vala_ccode_identifier_new ("argc"))));
			(__temp1133 == NULL ? NULL : (__temp1133 = (g_object_unref (__temp1133), NULL)));
			__temp1134 = NULL;
			vala_ccode_function_call_add_argument (main_call, VALA_CCODE_EXPRESSION ((__temp1134 = vala_ccode_identifier_new ("argv"))));
			(__temp1134 == NULL ? NULL : (__temp1134 = (g_object_unref (__temp1134), NULL)));
		}
		if (return_value) {
			ValaCCodeReturnStatement* __temp1135;
			__temp1135 = NULL;
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((__temp1135 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (main_call)))));
			(__temp1135 == NULL ? NULL : (__temp1135 = (g_object_unref (__temp1135), NULL)));
		} else {
			ValaCCodeExpressionStatement* __temp1136;
			ValaCCodeReturnStatement* __temp1137;
			/* method returns void, always use 0 as exit code*/
			__temp1136 = NULL;
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((__temp1136 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (main_call)))));
			(__temp1136 == NULL ? NULL : (__temp1136 = (g_object_unref (__temp1136), NULL)));
			__temp1137 = NULL;
			vala_ccode_block_add_statement (main_block, VALA_CCODE_NODE ((__temp1137 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("0"))))));
			(__temp1137 == NULL ? NULL : (__temp1137 = (g_object_unref (__temp1137), NULL)));
		}
		(vala_ccode_function_set_block (cmain, main_block), vala_ccode_function_get_block (cmain));
		vala_ccode_fragment_append (self->priv->source_type_member_definition, VALA_CCODE_NODE (cmain));
		(cmain == NULL ? NULL : (cmain = (g_object_unref (cmain), NULL)));
		(main_block == NULL ? NULL : (main_block = (g_object_unref (main_block), NULL)));
		(main_call == NULL ? NULL : (main_call = (g_object_unref (main_call), NULL)));
	}
	(old_method == NULL ? NULL : (old_method = (g_object_unref (old_method), NULL)));
	(old_return_type == NULL ? NULL : (old_return_type = (g_object_unref (old_return_type), NULL)));
	(vdeclarator == NULL ? NULL : (vdeclarator = (g_object_unref (vdeclarator), NULL)));
	(instance_param == NULL ? NULL : (instance_param = (g_object_unref (instance_param), NULL)));
	(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
}


static ValaCCodeStatement* vala_code_generator_create_method_type_check_statement (ValaCodeGenerator* self, ValaMethod* m, ValaDataType* t, gboolean non_null, const char* var_name)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_METHOD (m), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (t), NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	return vala_code_generator_create_type_check_statement (self, VALA_CODE_NODE (m), vala_type_reference_get_data_type (vala_method_get_return_type (m)), t, non_null, var_name);
}


static ValaCCodeStatement* vala_code_generator_create_property_type_check_statement (ValaCodeGenerator* self, ValaProperty* prop, gboolean getter, ValaDataType* t, gboolean non_null, const char* var_name)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_PROPERTY (prop), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (t), NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	if (getter) {
		return vala_code_generator_create_type_check_statement (self, VALA_CODE_NODE (prop), vala_type_reference_get_data_type (vala_property_get_type_reference (prop)), t, non_null, var_name);
	} else {
		return vala_code_generator_create_type_check_statement (self, VALA_CODE_NODE (prop), NULL, t, non_null, var_name);
	}
}


static ValaCCodeStatement* vala_code_generator_create_type_check_statement (ValaCodeGenerator* self, ValaCodeNode* method_node, ValaDataType* ret_type, ValaDataType* t, gboolean non_null, const char* var_name)
{
	ValaCCodeFunctionCall* ccheck;
	ValaCCodeExpressionStatement* __temp1148;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_CODE_NODE (method_node), NULL);
	g_return_val_if_fail (ret_type == NULL || VALA_IS_DATA_TYPE (ret_type), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (t), NULL);
	g_return_val_if_fail (var_name != NULL, NULL);
	ccheck = vala_ccode_function_call_new (NULL);
	if (VALA_IS_CLASS (t) || VALA_IS_INTERFACE (t)) {
		ValaCCodeFunctionCall* ctype_check;
		ValaCCodeIdentifier* __temp1141;
		ValaCCodeFunctionCall* __temp1142;
		ValaCCodeExpression* cexpr;
		ctype_check = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_upper_case_cname (t, "IS_"))));
		__temp1141 = NULL;
		vala_ccode_function_call_add_argument (ctype_check, VALA_CCODE_EXPRESSION ((__temp1141 = vala_ccode_identifier_new (var_name))));
		(__temp1141 == NULL ? NULL : (__temp1141 = (g_object_unref (__temp1141), NULL)));
		__temp1142 = NULL;
		cexpr = VALA_CCODE_EXPRESSION ((__temp1142 = ctype_check, (__temp1142 == NULL ? NULL : g_object_ref (__temp1142))));
		if (!non_null) {
			ValaCCodeBinaryExpression* cnull;
			ValaCCodeExpression* __temp1143;
			cnull = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (var_name)), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
			__temp1143 = NULL;
			cexpr = (__temp1143 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION (cnull), VALA_CCODE_EXPRESSION (ctype_check))), (cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL))), __temp1143);
			(cnull == NULL ? NULL : (cnull = (g_object_unref (cnull), NULL)));
		}
		vala_ccode_function_call_add_argument (ccheck, cexpr);
		(ctype_check == NULL ? NULL : (ctype_check = (g_object_unref (ctype_check), NULL)));
		(cexpr == NULL ? NULL : (cexpr = (g_object_unref (cexpr), NULL)));
	} else {
		if (!non_null) {
			gpointer __temp1144;
			return VALA_CCODE_STATEMENT ((__temp1144 = NULL, (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), __temp1144));
		} else {
			ValaCCodeBinaryExpression* cnonnull;
			cnonnull = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (var_name)), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL")));
			vala_ccode_function_call_add_argument (ccheck, VALA_CCODE_EXPRESSION (cnonnull));
			(cnonnull == NULL ? NULL : (cnonnull = (g_object_unref (cnonnull), NULL)));
		}
	}
	if (ret_type == NULL) {
		ValaCCodeIdentifier* __temp1145;
		/* void function */
		__temp1145 = NULL;
		(vala_ccode_function_call_set_call (ccheck, VALA_CCODE_EXPRESSION ((__temp1145 = vala_ccode_identifier_new ("g_return_if_fail")))), vala_ccode_function_call_get_call (ccheck));
		(__temp1145 == NULL ? NULL : (__temp1145 = (g_object_unref (__temp1145), NULL)));
	} else {
		ValaCCodeIdentifier* __temp1146;
		ValaCCodeExpression* cdefault;
		__temp1146 = NULL;
		(vala_ccode_function_call_set_call (ccheck, VALA_CCODE_EXPRESSION ((__temp1146 = vala_ccode_identifier_new ("g_return_val_if_fail")))), vala_ccode_function_call_get_call (ccheck));
		(__temp1146 == NULL ? NULL : (__temp1146 = (g_object_unref (__temp1146), NULL)));
		cdefault = vala_code_generator_default_value_for_type (self, ret_type);
		if (cdefault != NULL) {
			vala_ccode_function_call_add_argument (ccheck, cdefault);
		} else {
			ValaCCodeExpressionStatement* __temp1147;
			vala_report_warning (vala_code_node_get_source_reference (method_node), "not supported return type for runtime type checks");
			__temp1147 = NULL;
			return VALA_CCODE_STATEMENT ((__temp1147 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("0"))), (cdefault == NULL ? NULL : (cdefault = (g_object_unref (cdefault), NULL))), __temp1147));
		}
		(cdefault == NULL ? NULL : (cdefault = (g_object_unref (cdefault), NULL)));
	}
	__temp1148 = NULL;
	return VALA_CCODE_STATEMENT ((__temp1148 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccheck)), (ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL))), __temp1148));
	(ccheck == NULL ? NULL : (ccheck = (g_object_unref (ccheck), NULL)));
}


static ValaCCodeExpression* vala_code_generator_default_value_for_type (ValaCodeGenerator* self, ValaDataType* type)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (type), NULL);
	if (vala_data_type_is_reference_type (type) || VALA_IS_POINTER (type)) {
		return VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"));
	} else {
		char* __temp1150;
		gboolean __temp1151;
		__temp1150 = NULL;
		if ((__temp1151 = (__temp1150 = vala_data_type_get_default_value (type)) != NULL, (__temp1150 = (g_free (__temp1150), NULL)), __temp1151)) {
			return VALA_CCODE_EXPRESSION (vala_ccode_constant_new (vala_data_type_get_default_value (type)));
		}
	}
	return VALA_CCODE_EXPRESSION (NULL);
}


static ValaDataType* vala_code_generator_find_parent_type (ValaCodeGenerator* self, ValaCodeNode* node)
{
	ValaSymbol* __temp1154;
	ValaSymbol* sym;
	gpointer __temp1159;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (node == NULL || VALA_IS_CODE_NODE (node), NULL);
	__temp1154 = NULL;
	sym = (__temp1154 = vala_code_node_get_symbol (node), (__temp1154 == NULL ? NULL : g_object_ref (__temp1154)));
	while (sym != NULL) {
		ValaSymbol* __temp1158;
		ValaSymbol* __temp1157;
		if (VALA_IS_DATA_TYPE (vala_symbol_get_node (sym))) {
			ValaDataType* __temp1155;
			ValaDataType* __temp1156;
			__temp1155 = NULL;
			__temp1156 = NULL;
			return (__temp1156 = (__temp1155 = VALA_DATA_TYPE (vala_symbol_get_node (sym)), (__temp1155 == NULL ? NULL : g_object_ref (__temp1155))), (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), __temp1156);
		}
		__temp1158 = NULL;
		__temp1157 = NULL;
		sym = (__temp1158 = (__temp1157 = vala_symbol_get_parent_symbol (sym), (__temp1157 == NULL ? NULL : g_object_ref (__temp1157))), (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), __temp1158);
	}
	return VALA_DATA_TYPE ((__temp1159 = NULL, (sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL))), __temp1159));
	(sym == NULL ? NULL : (sym = (g_object_unref (sym), NULL)));
}


static char* vala_code_generator_get_array_length_cname (ValaCodeGenerator* self, const char* array_cname, gint dim)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (array_cname != NULL, NULL);
	return g_strdup_printf ("%s_length%d", array_cname, dim);
}


static void vala_code_generator_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_CREATION_METHOD (m));
	vala_code_visitor_visit_method (VALA_CODE_VISITOR (self), VALA_METHOD (m));
}


static gboolean vala_code_generator_is_possible_entry_point (ValaCodeGenerator* self, ValaMethod* m, gboolean* return_value, gboolean* args_parameter)
{
	GList* params;
	ValaFormalParameter* __temp1166;
	ValaFormalParameter* param;
	ValaArray* __temp1169;
	ValaArray* array_type;
	gboolean __temp1171;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	g_return_val_if_fail (VALA_IS_METHOD (m), FALSE);
	if (vala_method_get_name (m) == NULL || g_utf8_collate (vala_method_get_name (m), "main") != 0) {
		return FALSE;
	}
	/* method must be called "main"*/
	if (vala_method_get_instance (m)) {
		return FALSE;
	}
	/* method must be static*/
	if (vala_type_reference_get_data_type (vala_method_get_return_type (m)) == NULL) {
		(*return_value) = FALSE;
	} else {
		if (vala_type_reference_get_data_type (vala_method_get_return_type (m)) == vala_type_reference_get_data_type (self->priv->int_type)) {
			(*return_value) = TRUE;
		} else {
			return FALSE;
		}
	}
	/* return type must be void or int*/
	params = vala_invokable_get_parameters (VALA_INVOKABLE (m));
	if (g_list_length (params) == 0) {
		gboolean __temp1164;
		/* method may have no parameters*/
		(*args_parameter) = FALSE;
		return (__temp1164 = TRUE, (params == NULL ? NULL : (params = (g_list_free (params), NULL))), __temp1164);
	}
	if (g_list_length (params) > 1) {
		gboolean __temp1165;
		return (__temp1165 = FALSE, (params == NULL ? NULL : (params = (g_list_free (params), NULL))), __temp1165);
	}
	/* method must not have more than one parameter*/
	__temp1166 = NULL;
	param = (__temp1166 = VALA_FORMAL_PARAMETER (params->data), (__temp1166 == NULL ? NULL : g_object_ref (__temp1166)));
	if (vala_type_reference_get_is_out (vala_formal_parameter_get_type_reference (param))) {
		gboolean __temp1167;
		return (__temp1167 = FALSE, (params == NULL ? NULL : (params = (g_list_free (params), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), __temp1167);
	}
	/* parameter must not be an out parameter*/
	if (!(VALA_IS_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))))) {
		gboolean __temp1168;
		return (__temp1168 = FALSE, (params == NULL ? NULL : (params = (g_list_free (params), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), __temp1168);
	}
	/* parameter must be an array*/
	__temp1169 = NULL;
	array_type = (__temp1169 = VALA_ARRAY (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (param))), (__temp1169 == NULL ? NULL : g_object_ref (__temp1169)));
	if (vala_array_get_element_type (array_type) != vala_type_reference_get_data_type (self->priv->string_type)) {
		gboolean __temp1170;
		return (__temp1170 = FALSE, (params == NULL ? NULL : (params = (g_list_free (params), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), (array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL))), __temp1170);
	}
	/* parameter must be an array of strings*/
	(*args_parameter) = TRUE;
	return (__temp1171 = TRUE, (params == NULL ? NULL : (params = (g_list_free (params), NULL))), (param == NULL ? NULL : (param = (g_object_unref (param), NULL))), (array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL))), __temp1171);
	(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
	(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
	(array_type == NULL ? NULL : (array_type = (g_object_unref (array_type), NULL)));
}


static char* vala_code_generator_get_marshaller_type_name (ValaCodeGenerator* self, ValaTypeReference* t)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (t == NULL || VALA_IS_TYPE_REFERENCE (t), NULL);
	if (vala_type_reference_get_type_parameter (t) != NULL) {
		return g_strdup (("POINTER"));
	} else {
		if (vala_type_reference_get_data_type (t) == NULL) {
			return g_strdup (("VOID"));
		} else {
			return vala_data_type_get_marshaller_type_name (vala_type_reference_get_data_type (t));
		}
	}
}


static char* vala_code_generator_get_signal_marshaller_function (ValaCodeGenerator* self, ValaSignal* sig, const char* prefix)
{
	char* signature;
	char* ret;
	GList* params;
	char* __temp1176;
	char* __temp1175;
	char* __temp1181;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SIGNAL (sig), NULL);
	signature = vala_code_generator_get_signal_signature (self, sig);
	ret = NULL;
	params = vala_invokable_get_parameters (VALA_INVOKABLE (sig));
	if (prefix == NULL) {
		/* FIXME remove equality check with cast in next revision*/
		if (GPOINTER_TO_INT (g_hash_table_lookup (self->priv->predefined_marshal_list, signature)) != ((gboolean) NULL)) {
			prefix = "g_cclosure_marshal";
		} else {
			prefix = "g_cclosure_user_marshal";
		}
	}
	__temp1176 = NULL;
	__temp1175 = NULL;
	ret = (__temp1176 = g_strdup_printf ("%s_%s_", prefix, (__temp1175 = vala_code_generator_get_marshaller_type_name (self, vala_signal_get_return_type (sig)))), (ret = (g_free (ret), NULL)), __temp1176);
	(__temp1175 = (g_free (__temp1175), NULL));
	if (params == NULL) {
		char* __temp1177;
		__temp1177 = NULL;
		ret = (__temp1177 = g_strconcat (ret, "_VOID", NULL), (ret = (g_free (ret), NULL)), __temp1177);
	} else {
		{
			GList* __temp1180;
			GList* p_it;
			__temp1180 = NULL;
			__temp1180 = params;
			for (p_it = __temp1180; p_it != NULL; p_it = p_it->next) {
				ValaFormalParameter* p;
				p = p_it->data;
				{
					char* __temp1179;
					char* __temp1178;
					__temp1179 = NULL;
					__temp1178 = NULL;
					ret = (__temp1179 = g_strdup_printf ("%s_%s", ret, (__temp1178 = vala_code_generator_get_marshaller_type_name (self, vala_formal_parameter_get_type_reference (p)))), (ret = (g_free (ret), NULL)), __temp1179);
					(__temp1178 = (g_free (__temp1178), NULL));
				}
			}
		}
	}
	__temp1181 = NULL;
	return (__temp1181 = ret, (signature = (g_free (signature), NULL)), (params == NULL ? NULL : (params = (g_list_free (params), NULL))), __temp1181);
	(signature = (g_free (signature), NULL));
	(ret = (g_free (ret), NULL));
	(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
}


static char* vala_code_generator_get_value_type_name_from_type_reference (ValaCodeGenerator* self, ValaTypeReference* t)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (t), NULL);
	if (vala_type_reference_get_type_parameter (t) != NULL) {
		return g_strdup ("gpointer");
	} else {
		if (vala_type_reference_get_data_type (t) == NULL) {
			return g_strdup ("void");
		} else {
			if (VALA_IS_CLASS (vala_type_reference_get_data_type (t)) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (t))) {
				return g_strdup ("GObject *");
			} else {
				if (VALA_IS_STRUCT (vala_type_reference_get_data_type (t))) {
					if (vala_data_type_is_reference_type (VALA_DATA_TYPE ((VALA_STRUCT (vala_type_reference_get_data_type (t)))))) {
						return g_strdup ("gpointer");
					} else {
						return vala_data_type_get_cname (vala_type_reference_get_data_type (t), FALSE);
					}
				} else {
					if (VALA_IS_ENUM (vala_type_reference_get_data_type (t))) {
						return g_strdup ("gint");
					} else {
						if (VALA_IS_FLAGS (vala_type_reference_get_data_type (t))) {
							return g_strdup ("guint");
						} else {
							if (VALA_IS_ARRAY (vala_type_reference_get_data_type (t))) {
								return g_strdup ("gpointer");
							}
						}
					}
				}
			}
		}
	}
	return NULL;
}


static char* vala_code_generator_get_signal_signature (ValaCodeGenerator* self, ValaSignal* sig)
{
	char* signature;
	GList* params;
	char* __temp1192;
	char* __temp1191;
	char* __temp1199;
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (VALA_IS_SIGNAL (sig), NULL);
	signature = NULL;
	params = vala_invokable_get_parameters (VALA_INVOKABLE (sig));
	__temp1192 = NULL;
	__temp1191 = NULL;
	signature = (__temp1192 = g_strdup_printf ("%s:", (__temp1191 = vala_code_generator_get_marshaller_type_name (self, vala_signal_get_return_type (sig)))), (signature = (g_free (signature), NULL)), __temp1192);
	(__temp1191 = (g_free (__temp1191), NULL));
	if (params == NULL) {
		char* __temp1193;
		__temp1193 = NULL;
		signature = (__temp1193 = g_strconcat (signature, "VOID", NULL), (signature = (g_free (signature), NULL)), __temp1193);
	} else {
		gboolean first;
		first = TRUE;
		{
			GList* __temp1198;
			GList* p_it;
			__temp1198 = NULL;
			__temp1198 = params;
			for (p_it = __temp1198; p_it != NULL; p_it = p_it->next) {
				ValaFormalParameter* p;
				p = p_it->data;
				{
					if (first) {
						char* __temp1195;
						char* __temp1194;
						__temp1195 = NULL;
						__temp1194 = NULL;
						signature = (__temp1195 = g_strconcat (signature, (__temp1194 = vala_code_generator_get_marshaller_type_name (self, vala_formal_parameter_get_type_reference (p))), NULL), (signature = (g_free (signature), NULL)), __temp1195);
						(__temp1194 = (g_free (__temp1194), NULL));
						first = FALSE;
					} else {
						char* __temp1197;
						char* __temp1196;
						__temp1197 = NULL;
						__temp1196 = NULL;
						signature = (__temp1197 = g_strdup_printf ("%s,%s", signature, (__temp1196 = vala_code_generator_get_marshaller_type_name (self, vala_formal_parameter_get_type_reference (p)))), (signature = (g_free (signature), NULL)), __temp1197);
						(__temp1196 = (g_free (__temp1196), NULL));
					}
				}
			}
		}
	}
	__temp1199 = NULL;
	return (__temp1199 = signature, (params == NULL ? NULL : (params = (g_list_free (params), NULL))), __temp1199);
	(signature = (g_free (signature), NULL));
	(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
}


static void vala_code_generator_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig)
{
	ValaCodeGenerator * self;
	char* signature;
	GList* params;
	gint n_params;
	gint i;
	char* __temp1200;
	ValaCCodeFunction* signal_marshaller;
	ValaCCodeFormalParameter* __temp1201;
	ValaCCodeFormalParameter* __temp1202;
	ValaCCodeFormalParameter* __temp1203;
	ValaCCodeFormalParameter* __temp1204;
	ValaCCodeFormalParameter* __temp1205;
	ValaCCodeFormalParameter* __temp1206;
	ValaCCodeFunction* __temp1207;
	ValaCCodeBlock* marshaller_body;
	ValaCCodeFunctionDeclarator* callback_decl;
	ValaCCodeFormalParameter* __temp1208;
	ValaCCodeFormalParameter* __temp1211;
	ValaCCodeTypeDefinition* __temp1212;
	ValaCCodeDeclaration* var_decl;
	ValaCCodeVariableDeclarator* __temp1213;
	ValaCCodeDeclaration* __temp1214;
	ValaCCodeVariableDeclarator* __temp1215;
	ValaCCodeDeclaration* __temp1216;
	ValaCCodeVariableDeclarator* __temp1217;
	ValaCCodeVariableDeclarator* __temp1218;
	ValaCCodeFunctionCall* fc;
	ValaCCodeFunctionCall* __temp1224;
	ValaCCodeBinaryExpression* __temp1225;
	ValaCCodeExpressionStatement* __temp1226;
	ValaCCodeMemberAccess* data;
	ValaCCodeMemberAccess* param;
	ValaCCodeFunctionCall* cond;
	ValaCCodeIdentifier* __temp1227;
	ValaCCodeBlock* true_block;
	ValaCCodeExpressionStatement* __temp1228;
	ValaCCodeExpressionStatement* __temp1229;
	ValaCCodeBlock* false_block;
	ValaCCodeExpressionStatement* __temp1230;
	ValaCCodeExpressionStatement* __temp1231;
	ValaCCodeIfStatement* __temp1232;
	ValaCCodeAssignment* c_assign;
	ValaCCodeExpressionStatement* __temp1233;
	ValaCCodeFunctionCall* __temp1234;
	ValaCCodeIdentifier* __temp1235;
	ValaCCodeIdentifier* __temp1240;
	const char* __temp1250;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_SIGNAL (sig));
	vala_code_node_accept_children (VALA_CODE_NODE (sig), VALA_CODE_VISITOR (self));
	signature = NULL;
	params = vala_invokable_get_parameters (VALA_INVOKABLE (sig));
	n_params = 0;
	i = 0;
	/* check whether a signal with the same signature already exists for this source file (or predefined) */
	__temp1200 = NULL;
	signature = (__temp1200 = vala_code_generator_get_signal_signature (self, sig), (signature = (g_free (signature), NULL)), __temp1200);
	/* FIXME remove equality checks with cast in next revision*/
	if (GPOINTER_TO_INT (g_hash_table_lookup (self->priv->predefined_marshal_list, signature)) != ((gboolean) NULL) || GPOINTER_TO_INT (g_hash_table_lookup (self->priv->user_marshal_list, signature)) != ((gboolean) NULL)) {
		(signature = (g_free (signature), NULL));
		(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
		return;
	}
	signal_marshaller = vala_ccode_function_new (vala_code_generator_get_signal_marshaller_function (self, sig, NULL), "void");
	(vala_ccode_function_set_modifiers (signal_marshaller, VALA_CCODE_MODIFIERS_STATIC), vala_ccode_function_get_modifiers (signal_marshaller));
	__temp1201 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (__temp1201 = vala_ccode_formal_parameter_new ("closure", "GClosure *")));
	(__temp1201 == NULL ? NULL : (__temp1201 = (g_object_unref (__temp1201), NULL)));
	__temp1202 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (__temp1202 = vala_ccode_formal_parameter_new ("return_value", "GValue *")));
	(__temp1202 == NULL ? NULL : (__temp1202 = (g_object_unref (__temp1202), NULL)));
	__temp1203 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (__temp1203 = vala_ccode_formal_parameter_new ("n_param_values", "guint")));
	(__temp1203 == NULL ? NULL : (__temp1203 = (g_object_unref (__temp1203), NULL)));
	__temp1204 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (__temp1204 = vala_ccode_formal_parameter_new ("param_values", "const GValue *")));
	(__temp1204 == NULL ? NULL : (__temp1204 = (g_object_unref (__temp1204), NULL)));
	__temp1205 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (__temp1205 = vala_ccode_formal_parameter_new ("invocation_hint", "gpointer")));
	(__temp1205 == NULL ? NULL : (__temp1205 = (g_object_unref (__temp1205), NULL)));
	__temp1206 = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, (__temp1206 = vala_ccode_formal_parameter_new ("marshal_data", "gpointer")));
	(__temp1206 == NULL ? NULL : (__temp1206 = (g_object_unref (__temp1206), NULL)));
	__temp1207 = NULL;
	vala_ccode_fragment_append (self->priv->source_signal_marshaller_declaration, VALA_CCODE_NODE ((__temp1207 = vala_ccode_function_copy (signal_marshaller))));
	(__temp1207 = (g_object_unref (__temp1207), NULL));
	marshaller_body = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	callback_decl = vala_ccode_function_declarator_new (vala_code_generator_get_signal_marshaller_function (self, sig, "GMarshalFunc"));
	__temp1208 = NULL;
	vala_ccode_function_declarator_add_parameter (callback_decl, (__temp1208 = vala_ccode_formal_parameter_new ("data1", "gpointer")));
	(__temp1208 == NULL ? NULL : (__temp1208 = (g_object_unref (__temp1208), NULL)));
	n_params = 1;
	{
		GList* __temp1210;
		GList* p_it;
		__temp1210 = NULL;
		__temp1210 = params;
		for (p_it = __temp1210; p_it != NULL; p_it = p_it->next) {
			ValaFormalParameter* p;
			p = p_it->data;
			{
				ValaCCodeFormalParameter* __temp1209;
				__temp1209 = NULL;
				vala_ccode_function_declarator_add_parameter (callback_decl, (__temp1209 = vala_ccode_formal_parameter_new (g_strdup_printf ("arg_%d", n_params), vala_code_generator_get_value_type_name_from_type_reference (self, vala_formal_parameter_get_type_reference (p)))));
				(__temp1209 == NULL ? NULL : (__temp1209 = (g_object_unref (__temp1209), NULL)));
				n_params++;
			}
		}
	}
	__temp1211 = NULL;
	vala_ccode_function_declarator_add_parameter (callback_decl, (__temp1211 = vala_ccode_formal_parameter_new ("data2", "gpointer")));
	(__temp1211 == NULL ? NULL : (__temp1211 = (g_object_unref (__temp1211), NULL)));
	__temp1212 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp1212 = vala_ccode_type_definition_new (vala_code_generator_get_value_type_name_from_type_reference (self, vala_signal_get_return_type (sig)), VALA_CCODE_DECLARATOR (callback_decl)))));
	(__temp1212 == NULL ? NULL : (__temp1212 = (g_object_unref (__temp1212), NULL)));
	var_decl = vala_ccode_declaration_new (vala_code_generator_get_signal_marshaller_function (self, sig, "GMarshalFunc"));
	(vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER), vala_ccode_declaration_get_modifiers (var_decl));
	__temp1213 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((__temp1213 = vala_ccode_variable_declarator_new ("callback"))));
	(__temp1213 == NULL ? NULL : (__temp1213 = (g_object_unref (__temp1213), NULL)));
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
	__temp1214 = NULL;
	var_decl = (__temp1214 = vala_ccode_declaration_new ("GCClosure *"), (var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL))), __temp1214);
	(vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER), vala_ccode_declaration_get_modifiers (var_decl));
	__temp1215 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((__temp1215 = vala_ccode_variable_declarator_new_with_initializer ("cc", VALA_CCODE_EXPRESSION (vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("closure")), "GCClosure *"))))));
	(__temp1215 == NULL ? NULL : (__temp1215 = (g_object_unref (__temp1215), NULL)));
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
	__temp1216 = NULL;
	var_decl = (__temp1216 = vala_ccode_declaration_new ("gpointer"), (var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL))), __temp1216);
	(vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER), vala_ccode_declaration_get_modifiers (var_decl));
	__temp1217 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((__temp1217 = vala_ccode_variable_declarator_new ("data1"))));
	(__temp1217 == NULL ? NULL : (__temp1217 = (g_object_unref (__temp1217), NULL)));
	__temp1218 = NULL;
	vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((__temp1218 = vala_ccode_variable_declarator_new ("data2"))));
	(__temp1218 == NULL ? NULL : (__temp1218 = (g_object_unref (__temp1218), NULL)));
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
	fc = NULL;
	if (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)) != NULL) {
		ValaCCodeDeclaration* __temp1219;
		ValaCCodeVariableDeclarator* __temp1220;
		ValaCCodeFunctionCall* __temp1221;
		ValaCCodeBinaryExpression* __temp1222;
		ValaCCodeExpressionStatement* __temp1223;
		__temp1219 = NULL;
		var_decl = (__temp1219 = vala_ccode_declaration_new (vala_code_generator_get_value_type_name_from_type_reference (self, vala_signal_get_return_type (sig))), (var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL))), __temp1219);
		__temp1220 = NULL;
		vala_ccode_declaration_add_declarator (var_decl, VALA_CCODE_DECLARATOR ((__temp1220 = vala_ccode_variable_declarator_new ("v_return"))));
		(__temp1220 == NULL ? NULL : (__temp1220 = (g_object_unref (__temp1220), NULL)));
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE (var_decl));
		__temp1221 = NULL;
		fc = (__temp1221 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_return_if_fail"))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), __temp1221);
		__temp1222 = NULL;
		vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((__temp1222 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("return_value")), VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("NULL"))))));
		(__temp1222 == NULL ? NULL : (__temp1222 = (g_object_unref (__temp1222), NULL)));
		__temp1223 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp1223 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
		(__temp1223 == NULL ? NULL : (__temp1223 = (g_object_unref (__temp1223), NULL)));
	}
	__temp1224 = NULL;
	fc = (__temp1224 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_return_if_fail"))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), __temp1224);
	__temp1225 = NULL;
	vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((__temp1225 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("n_param_values")), VALA_CCODE_EXPRESSION (vala_ccode_constant_new (g_strdup_printf ("%i", n_params)))))));
	(__temp1225 == NULL ? NULL : (__temp1225 = (g_object_unref (__temp1225), NULL)));
	__temp1226 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp1226 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
	(__temp1226 == NULL ? NULL : (__temp1226 = (g_object_unref (__temp1226), NULL)));
	data = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("closure")), "data", TRUE);
	param = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION (vala_ccode_member_access_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("param_values")), "data[0]", TRUE)), "v_pointer", FALSE);
	cond = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_constant_new ("G_CCLOSURE_SWAP_DATA")));
	__temp1227 = NULL;
	vala_ccode_function_call_add_argument (cond, VALA_CCODE_EXPRESSION ((__temp1227 = vala_ccode_identifier_new ("closure"))));
	(__temp1227 == NULL ? NULL : (__temp1227 = (g_object_unref (__temp1227), NULL)));
	true_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	__temp1228 = NULL;
	vala_ccode_block_add_statement (true_block, VALA_CCODE_NODE ((__temp1228 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("data1")), VALA_CCODE_EXPRESSION (data), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp1228 == NULL ? NULL : (__temp1228 = (g_object_unref (__temp1228), NULL)));
	__temp1229 = NULL;
	vala_ccode_block_add_statement (true_block, VALA_CCODE_NODE ((__temp1229 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("data2")), VALA_CCODE_EXPRESSION (param), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp1229 == NULL ? NULL : (__temp1229 = (g_object_unref (__temp1229), NULL)));
	false_block = g_object_new (VALA_TYPE_CCODE_BLOCK, NULL);
	__temp1230 = NULL;
	vala_ccode_block_add_statement (false_block, VALA_CCODE_NODE ((__temp1230 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("data1")), VALA_CCODE_EXPRESSION (param), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp1230 == NULL ? NULL : (__temp1230 = (g_object_unref (__temp1230), NULL)));
	__temp1231 = NULL;
	vala_ccode_block_add_statement (false_block, VALA_CCODE_NODE ((__temp1231 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("data2")), VALA_CCODE_EXPRESSION (data), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
	(__temp1231 == NULL ? NULL : (__temp1231 = (g_object_unref (__temp1231), NULL)));
	__temp1232 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp1232 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (cond), VALA_CCODE_STATEMENT (true_block), VALA_CCODE_STATEMENT (false_block)))));
	(__temp1232 == NULL ? NULL : (__temp1232 = (g_object_unref (__temp1232), NULL)));
	c_assign = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("callback")), VALA_CCODE_EXPRESSION (vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (vala_ccode_conditional_expression_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("marshal_data")), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("marshal_data")), VALA_CCODE_EXPRESSION (vala_ccode_member_access_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("cc")), "callback", TRUE)))), vala_code_generator_get_signal_marshaller_function (self, sig, "GMarshalFunc"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	__temp1233 = NULL;
	vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp1233 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (c_assign)))));
	(__temp1233 == NULL ? NULL : (__temp1233 = (g_object_unref (__temp1233), NULL)));
	__temp1234 = NULL;
	fc = (__temp1234 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("callback"))), (fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL))), __temp1234);
	__temp1235 = NULL;
	vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((__temp1235 = vala_ccode_identifier_new ("data1"))));
	(__temp1235 == NULL ? NULL : (__temp1235 = (g_object_unref (__temp1235), NULL)));
	i = 1;
	{
		GList* __temp1239;
		GList* p_it;
		__temp1239 = NULL;
		__temp1239 = params;
		for (p_it = __temp1239; p_it != NULL; p_it = p_it->next) {
			ValaFormalParameter* p;
			p = p_it->data;
			{
				char* get_value_function;
				ValaCCodeFunctionCall* inner_fc;
				ValaCCodeBinaryExpression* __temp1238;
				get_value_function = NULL;
				if (vala_type_reference_get_type_parameter (vala_formal_parameter_get_type_reference (p)) != NULL) {
					char* __temp1236;
					__temp1236 = NULL;
					get_value_function = (__temp1236 = g_strdup ("g_value_get_pointer"), (get_value_function = (g_free (get_value_function), NULL)), __temp1236);
				} else {
					char* __temp1237;
					__temp1237 = NULL;
					get_value_function = (__temp1237 = vala_data_type_get_get_value_function (vala_type_reference_get_data_type (vala_formal_parameter_get_type_reference (p))), (get_value_function = (g_free (get_value_function), NULL)), __temp1237);
				}
				inner_fc = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (get_value_function)));
				__temp1238 = NULL;
				vala_ccode_function_call_add_argument (inner_fc, VALA_CCODE_EXPRESSION ((__temp1238 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("param_values")), VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (g_strdup_printf ("%i", i)))))));
				(__temp1238 == NULL ? NULL : (__temp1238 = (g_object_unref (__temp1238), NULL)));
				vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION (inner_fc));
				i++;
				(get_value_function = (g_free (get_value_function), NULL));
				(inner_fc == NULL ? NULL : (inner_fc = (g_object_unref (inner_fc), NULL)));
			}
		}
	}
	__temp1240 = NULL;
	vala_ccode_function_call_add_argument (fc, VALA_CCODE_EXPRESSION ((__temp1240 = vala_ccode_identifier_new ("data2"))));
	(__temp1240 == NULL ? NULL : (__temp1240 = (g_object_unref (__temp1240), NULL)));
	if (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)) != NULL) {
		ValaCCodeExpressionStatement* __temp1241;
		ValaCCodeFunctionCall* set_fc;
		ValaCCodeIdentifier* __temp1246;
		ValaCCodeIdentifier* __temp1247;
		ValaCCodeExpressionStatement* __temp1248;
		__temp1241 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp1241 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("v_return")), VALA_CCODE_EXPRESSION (fc), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))))));
		(__temp1241 == NULL ? NULL : (__temp1241 = (g_object_unref (__temp1241), NULL)));
		set_fc = NULL;
		if (vala_type_reference_get_type_parameter (vala_signal_get_return_type (sig)) != NULL) {
			ValaCCodeFunctionCall* __temp1242;
			__temp1242 = NULL;
			set_fc = (__temp1242 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_value_set_pointer"))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), __temp1242);
		} else {
			if (VALA_IS_CLASS (vala_type_reference_get_data_type (vala_signal_get_return_type (sig))) || VALA_IS_INTERFACE (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)))) {
				ValaCCodeFunctionCall* __temp1243;
				__temp1243 = NULL;
				set_fc = (__temp1243 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_value_take_object"))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), __temp1243);
			} else {
				if (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)) == vala_type_reference_get_data_type (self->priv->string_type)) {
					ValaCCodeFunctionCall* __temp1244;
					__temp1244 = NULL;
					set_fc = (__temp1244 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("g_value_take_string"))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), __temp1244);
				} else {
					ValaCCodeFunctionCall* __temp1245;
					__temp1245 = NULL;
					set_fc = (__temp1245 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_ccode_identifier_new (vala_data_type_get_set_value_function (vala_type_reference_get_data_type (vala_signal_get_return_type (sig)))))), (set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL))), __temp1245);
				}
			}
		}
		__temp1246 = NULL;
		vala_ccode_function_call_add_argument (set_fc, VALA_CCODE_EXPRESSION ((__temp1246 = vala_ccode_identifier_new ("return_value"))));
		(__temp1246 == NULL ? NULL : (__temp1246 = (g_object_unref (__temp1246), NULL)));
		__temp1247 = NULL;
		vala_ccode_function_call_add_argument (set_fc, VALA_CCODE_EXPRESSION ((__temp1247 = vala_ccode_identifier_new ("v_return"))));
		(__temp1247 == NULL ? NULL : (__temp1247 = (g_object_unref (__temp1247), NULL)));
		__temp1248 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp1248 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (set_fc)))));
		(__temp1248 == NULL ? NULL : (__temp1248 = (g_object_unref (__temp1248), NULL)));
		(set_fc == NULL ? NULL : (set_fc = (g_object_unref (set_fc), NULL)));
	} else {
		ValaCCodeExpressionStatement* __temp1249;
		__temp1249 = NULL;
		vala_ccode_block_add_statement (marshaller_body, VALA_CCODE_NODE ((__temp1249 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (fc)))));
		(__temp1249 == NULL ? NULL : (__temp1249 = (g_object_unref (__temp1249), NULL)));
	}
	(vala_ccode_function_set_block (signal_marshaller, marshaller_body), vala_ccode_function_get_block (signal_marshaller));
	vala_ccode_fragment_append (self->priv->source_signal_marshaller_definition, VALA_CCODE_NODE (signal_marshaller));
	__temp1250 = NULL;
	g_hash_table_insert (self->priv->user_marshal_list, (__temp1250 = signature, (__temp1250 == NULL ? NULL : g_strdup (__temp1250))), GINT_TO_POINTER (TRUE));
	(signature = (g_free (signature), NULL));
	(params == NULL ? NULL : (params = (g_list_free (params), NULL)));
	(signal_marshaller == NULL ? NULL : (signal_marshaller = (g_object_unref (signal_marshaller), NULL)));
	(marshaller_body == NULL ? NULL : (marshaller_body = (g_object_unref (marshaller_body), NULL)));
	(callback_decl == NULL ? NULL : (callback_decl = (g_object_unref (callback_decl), NULL)));
	(var_decl == NULL ? NULL : (var_decl = (g_object_unref (var_decl), NULL)));
	(fc == NULL ? NULL : (fc = (g_object_unref (fc), NULL)));
	(data == NULL ? NULL : (data = (g_object_unref (data), NULL)));
	(param == NULL ? NULL : (param = (g_object_unref (param), NULL)));
	(cond == NULL ? NULL : (cond = (g_object_unref (cond), NULL)));
	(true_block == NULL ? NULL : (true_block = (g_object_unref (true_block), NULL)));
	(false_block == NULL ? NULL : (false_block = (g_object_unref (false_block), NULL)));
	(c_assign == NULL ? NULL : (c_assign = (g_object_unref (c_assign), NULL)));
}


static ValaCCodeIncludeDirective* vala_code_generator_get_internal_include (ValaCodeGenerator* self, const char* filename)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	return vala_ccode_include_directive_new (filename, vala_code_context_get_library (self->priv->context) == NULL);
}


static void vala_code_generator_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file)
{
	ValaCodeGenerator * self;
	ValaCCodeFragment* __temp1252;
	ValaCCodeFragment* __temp1253;
	ValaCCodeFragment* __temp1254;
	ValaCCodeFragment* __temp1255;
	ValaCCodeFragment* __temp1256;
	ValaCCodeFragment* __temp1257;
	ValaCCodeFragment* __temp1258;
	ValaCCodeFragment* __temp1259;
	ValaCCodeFragment* __temp1260;
	ValaCCodeFragment* __temp1261;
	GHashTable* __temp1262;
	ValaCCodeIncludeDirective* __temp1263;
	ValaCCodeIncludeDirective* __temp1264;
	ValaCCodeIncludeDirective* __temp1265;
	GList* used_includes;
	char* __temp1266;
	ValaCCodeMacroReplacement* __temp1291;
	ValaCCodeMacroReplacement* __temp1292;
	char* __temp1293;
	char* __temp1294;
	char* header_define;
	ValaCCodeComment* comment;
	ValaCCodeWriter* writer;
	ValaCCodeOnceSection* once;
	ValaCCodeNewline* __temp1297;
	ValaCCodeNewline* __temp1298;
	ValaCCodeIdentifier* __temp1299;
	ValaCCodeNewline* __temp1300;
	ValaCCodeNewline* __temp1301;
	ValaCCodeNewline* __temp1302;
	ValaCCodeNewline* __temp1303;
	ValaCCodeNewline* __temp1304;
	ValaCCodeIdentifier* __temp1305;
	ValaCCodeNewline* __temp1306;
	ValaCCodeNewline* __temp1307;
	ValaCCodeWriter* __temp1308;
	ValaCCodeFragment* __temp1309;
	ValaCCodeFragment* __temp1310;
	ValaCCodeFragment* __temp1311;
	ValaCCodeFragment* __temp1312;
	ValaCCodeFragment* __temp1313;
	ValaCCodeFragment* __temp1314;
	ValaCCodeFragment* __temp1315;
	ValaCCodeFragment* __temp1316;
	ValaCCodeFragment* __temp1317;
	ValaCCodeFragment* __temp1318;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_SOURCE_FILE (source_file));
	__temp1252 = NULL;
	self->priv->header_begin = (__temp1252 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->header_begin == NULL ? NULL : (self->priv->header_begin = (g_object_unref (self->priv->header_begin), NULL))), __temp1252);
	__temp1253 = NULL;
	self->priv->header_type_declaration = (__temp1253 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->header_type_declaration == NULL ? NULL : (self->priv->header_type_declaration = (g_object_unref (self->priv->header_type_declaration), NULL))), __temp1253);
	__temp1254 = NULL;
	self->priv->header_type_definition = (__temp1254 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->header_type_definition == NULL ? NULL : (self->priv->header_type_definition = (g_object_unref (self->priv->header_type_definition), NULL))), __temp1254);
	__temp1255 = NULL;
	self->priv->header_type_member_declaration = (__temp1255 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->header_type_member_declaration == NULL ? NULL : (self->priv->header_type_member_declaration = (g_object_unref (self->priv->header_type_member_declaration), NULL))), __temp1255);
	__temp1256 = NULL;
	self->priv->source_begin = (__temp1256 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_begin == NULL ? NULL : (self->priv->source_begin = (g_object_unref (self->priv->source_begin), NULL))), __temp1256);
	__temp1257 = NULL;
	self->priv->source_include_directives = (__temp1257 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_include_directives == NULL ? NULL : (self->priv->source_include_directives = (g_object_unref (self->priv->source_include_directives), NULL))), __temp1257);
	__temp1258 = NULL;
	self->priv->source_type_member_declaration = (__temp1258 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_type_member_declaration == NULL ? NULL : (self->priv->source_type_member_declaration = (g_object_unref (self->priv->source_type_member_declaration), NULL))), __temp1258);
	__temp1259 = NULL;
	self->priv->source_type_member_definition = (__temp1259 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_type_member_definition == NULL ? NULL : (self->priv->source_type_member_definition = (g_object_unref (self->priv->source_type_member_definition), NULL))), __temp1259);
	__temp1260 = NULL;
	self->priv->source_signal_marshaller_definition = (__temp1260 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_signal_marshaller_definition == NULL ? NULL : (self->priv->source_signal_marshaller_definition = (g_object_unref (self->priv->source_signal_marshaller_definition), NULL))), __temp1260);
	__temp1261 = NULL;
	self->priv->source_signal_marshaller_declaration = (__temp1261 = g_object_new (VALA_TYPE_CCODE_FRAGMENT, NULL), (self->priv->source_signal_marshaller_declaration == NULL ? NULL : (self->priv->source_signal_marshaller_declaration = (g_object_unref (self->priv->source_signal_marshaller_declaration), NULL))), __temp1261);
	__temp1262 = NULL;
	self->priv->user_marshal_list = (__temp1262 = g_hash_table_new (g_str_hash, g_str_equal), (self->priv->user_marshal_list == NULL ? NULL : (self->priv->user_marshal_list = (g_hash_table_unref (self->priv->user_marshal_list), NULL))), __temp1262);
	self->priv->next_temp_var_id = 0;
	self->priv->string_h_needed = FALSE;
	__temp1263 = NULL;
	vala_ccode_fragment_append (self->priv->header_begin, VALA_CCODE_NODE ((__temp1263 = vala_ccode_include_directive_new ("glib.h", FALSE))));
	(__temp1263 == NULL ? NULL : (__temp1263 = (g_object_unref (__temp1263), NULL)));
	__temp1264 = NULL;
	vala_ccode_fragment_append (self->priv->header_begin, VALA_CCODE_NODE ((__temp1264 = vala_ccode_include_directive_new ("glib-object.h", FALSE))));
	(__temp1264 == NULL ? NULL : (__temp1264 = (g_object_unref (__temp1264), NULL)));
	__temp1265 = NULL;
	vala_ccode_fragment_append (self->priv->source_include_directives, VALA_CCODE_NODE ((__temp1265 = vala_ccode_include_directive_new (vala_source_file_get_cheader_filename (source_file), TRUE))));
	(__temp1265 == NULL ? NULL : (__temp1265 = (g_object_unref (__temp1265), NULL)));
	used_includes = NULL;
	used_includes = g_list_append (used_includes, "glib.h");
	used_includes = g_list_append (used_includes, "glib-object.h");
	__temp1266 = NULL;
	used_includes = g_list_append (used_includes, (__temp1266 = vala_source_file_get_cheader_filename (source_file)));
	(__temp1266 = (g_free (__temp1266), NULL));
	{
		GList* __temp1268;
		GList* filename1_it;
		__temp1268 = NULL;
		__temp1268 = vala_source_file_get_header_external_includes (source_file);
		for (filename1_it = __temp1268; filename1_it != NULL; filename1_it = filename1_it->next) {
			char* filename1;
			filename1 = filename1_it->data;
			{
				if (g_list_find_custom (used_includes, filename1, ((GCompareFunc) strcmp)) == NULL) {
					ValaCCodeIncludeDirective* __temp1267;
					__temp1267 = NULL;
					vala_ccode_fragment_append (self->priv->header_begin, VALA_CCODE_NODE ((__temp1267 = vala_ccode_include_directive_new (filename1, FALSE))));
					(__temp1267 == NULL ? NULL : (__temp1267 = (g_object_unref (__temp1267), NULL)));
					used_includes = g_list_append (used_includes, filename1);
				}
			}
		}
	}
	{
		GList* __temp1270;
		GList* filename2_it;
		__temp1270 = NULL;
		__temp1270 = vala_source_file_get_header_internal_includes (source_file);
		for (filename2_it = __temp1270; filename2_it != NULL; filename2_it = filename2_it->next) {
			char* filename2;
			filename2 = filename2_it->data;
			{
				if (g_list_find_custom (used_includes, filename2, ((GCompareFunc) strcmp)) == NULL) {
					ValaCCodeIncludeDirective* __temp1269;
					__temp1269 = NULL;
					vala_ccode_fragment_append (self->priv->header_begin, VALA_CCODE_NODE ((__temp1269 = vala_code_generator_get_internal_include (self, filename2))));
					(__temp1269 == NULL ? NULL : (__temp1269 = (g_object_unref (__temp1269), NULL)));
					used_includes = g_list_append (used_includes, filename2);
				}
			}
		}
	}
	{
		GList* __temp1272;
		GList* filename3_it;
		__temp1272 = NULL;
		__temp1272 = vala_source_file_get_source_external_includes (source_file);
		for (filename3_it = __temp1272; filename3_it != NULL; filename3_it = filename3_it->next) {
			char* filename3;
			filename3 = filename3_it->data;
			{
				if (g_list_find_custom (used_includes, filename3, ((GCompareFunc) strcmp)) == NULL) {
					ValaCCodeIncludeDirective* __temp1271;
					__temp1271 = NULL;
					vala_ccode_fragment_append (self->priv->source_include_directives, VALA_CCODE_NODE ((__temp1271 = vala_ccode_include_directive_new (filename3, FALSE))));
					(__temp1271 == NULL ? NULL : (__temp1271 = (g_object_unref (__temp1271), NULL)));
					used_includes = g_list_append (used_includes, filename3);
				}
			}
		}
	}
	{
		GList* __temp1274;
		GList* filename4_it;
		__temp1274 = NULL;
		__temp1274 = vala_source_file_get_source_internal_includes (source_file);
		for (filename4_it = __temp1274; filename4_it != NULL; filename4_it = filename4_it->next) {
			char* filename4;
			filename4 = filename4_it->data;
			{
				if (g_list_find_custom (used_includes, filename4, ((GCompareFunc) strcmp)) == NULL) {
					ValaCCodeIncludeDirective* __temp1273;
					__temp1273 = NULL;
					vala_ccode_fragment_append (self->priv->source_include_directives, VALA_CCODE_NODE ((__temp1273 = vala_code_generator_get_internal_include (self, filename4))));
					(__temp1273 == NULL ? NULL : (__temp1273 = (g_object_unref (__temp1273), NULL)));
					used_includes = g_list_append (used_includes, filename4);
				}
			}
		}
	}
	if (vala_source_file_get_is_cycle_head (source_file)) {
		{
			GList* __temp1290;
			GList* cycle_file_it;
			__temp1290 = NULL;
			__temp1290 = vala_source_file_get_cycle (source_file)->files;
			for (cycle_file_it = __temp1290; cycle_file_it != NULL; cycle_file_it = cycle_file_it->next) {
				ValaSourceFile* cycle_file;
				cycle_file = cycle_file_it->data;
				{
					GList* namespaces;
					namespaces = vala_source_file_get_namespaces (cycle_file);
					{
						GList* __temp1289;
						GList* ns_it;
						__temp1289 = NULL;
						__temp1289 = namespaces;
						for (ns_it = __temp1289; ns_it != NULL; ns_it = ns_it->next) {
							ValaNamespace* ns;
							ns = ns_it->data;
							{
								GList* structs;
								GList* classes;
								GList* ifaces;
								structs = vala_namespace_get_structs (ns);
								{
									GList* __temp1277;
									GList* st_it;
									__temp1277 = NULL;
									__temp1277 = structs;
									for (st_it = __temp1277; st_it != NULL; st_it = st_it->next) {
										ValaStruct* st;
										st = st_it->data;
										{
											ValaCCodeTypeDefinition* __temp1276;
											char* __temp1275;
											__temp1276 = NULL;
											__temp1275 = NULL;
											vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp1276 = vala_ccode_type_definition_new (g_strdup_printf ("struct _%s", (__temp1275 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE))), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)))))));
											(__temp1276 == NULL ? NULL : (__temp1276 = (g_object_unref (__temp1276), NULL)));
											(__temp1275 = (g_free (__temp1275), NULL));
										}
									}
								}
								classes = vala_namespace_get_classes (ns);
								{
									GList* __temp1283;
									GList* cl_it;
									__temp1283 = NULL;
									__temp1283 = classes;
									for (cl_it = __temp1283; cl_it != NULL; cl_it = cl_it->next) {
										ValaClass* cl;
										cl = cl_it->data;
										{
											ValaCCodeTypeDefinition* __temp1279;
											char* __temp1278;
											ValaCCodeTypeDefinition* __temp1282;
											char* __temp1281;
											char* __temp1280;
											__temp1279 = NULL;
											__temp1278 = NULL;
											vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp1279 = vala_ccode_type_definition_new (g_strdup_printf ("struct _%s", (__temp1278 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))));
											(__temp1279 == NULL ? NULL : (__temp1279 = (g_object_unref (__temp1279), NULL)));
											(__temp1278 = (g_free (__temp1278), NULL));
											__temp1282 = NULL;
											__temp1281 = NULL;
											__temp1280 = NULL;
											vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp1282 = vala_ccode_type_definition_new (g_strdup_printf ("struct _%sClass", (__temp1280 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE))), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (g_strdup_printf ("%sClass", (__temp1281 = vala_data_type_get_cname (VALA_DATA_TYPE (cl), FALSE)))))))));
											(__temp1282 == NULL ? NULL : (__temp1282 = (g_object_unref (__temp1282), NULL)));
											(__temp1281 = (g_free (__temp1281), NULL));
											(__temp1280 = (g_free (__temp1280), NULL));
										}
									}
								}
								ifaces = vala_namespace_get_interfaces (ns);
								{
									GList* __temp1288;
									GList* iface_it;
									__temp1288 = NULL;
									__temp1288 = ifaces;
									for (iface_it = __temp1288; iface_it != NULL; iface_it = iface_it->next) {
										ValaInterface* iface;
										iface = iface_it->data;
										{
											ValaCCodeTypeDefinition* __temp1285;
											char* __temp1284;
											ValaCCodeTypeDefinition* __temp1287;
											char* __temp1286;
											__temp1285 = NULL;
											__temp1284 = NULL;
											vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp1285 = vala_ccode_type_definition_new (g_strdup_printf ("struct _%s", (__temp1284 = vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE))), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (vala_data_type_get_cname (VALA_DATA_TYPE (iface), FALSE)))))));
											(__temp1285 == NULL ? NULL : (__temp1285 = (g_object_unref (__temp1285), NULL)));
											(__temp1284 = (g_free (__temp1284), NULL));
											__temp1287 = NULL;
											__temp1286 = NULL;
											vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp1287 = vala_ccode_type_definition_new (g_strdup_printf ("struct _%s", (__temp1286 = vala_interface_get_type_cname (iface))), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (vala_interface_get_type_cname (iface)))))));
											(__temp1287 == NULL ? NULL : (__temp1287 = (g_object_unref (__temp1287), NULL)));
											(__temp1286 = (g_free (__temp1286), NULL));
										}
									}
								}
								(structs == NULL ? NULL : (structs = (g_list_free (structs), NULL)));
								(classes == NULL ? NULL : (classes = (g_list_free (classes), NULL)));
								(ifaces == NULL ? NULL : (ifaces = (g_list_free (ifaces), NULL)));
							}
						}
					}
					(namespaces == NULL ? NULL : (namespaces = (g_list_free (namespaces), NULL)));
				}
			}
		}
	}
	/* generate hardcoded "well-known" macros */
	__temp1291 = NULL;
	vala_ccode_fragment_append (self->priv->source_begin, VALA_CCODE_NODE ((__temp1291 = vala_ccode_macro_replacement_new ("VALA_FREE_CHECKED(o,f)", "((o) == NULL ? NULL : ((o) = (f (o), NULL)))"))));
	(__temp1291 == NULL ? NULL : (__temp1291 = (g_object_unref (__temp1291), NULL)));
	__temp1292 = NULL;
	vala_ccode_fragment_append (self->priv->source_begin, VALA_CCODE_NODE ((__temp1292 = vala_ccode_macro_replacement_new ("VALA_FREE_UNCHECKED(o,f)", "((o) = (f (o), NULL))"))));
	(__temp1292 == NULL ? NULL : (__temp1292 = (g_object_unref (__temp1292), NULL)));
	vala_source_file_accept_children (source_file, VALA_CODE_VISITOR (self));
	__temp1293 = NULL;
	__temp1294 = NULL;
	header_define = (__temp1294 = vala_code_generator_get_define_for_filename ((__temp1293 = vala_source_file_get_cheader_filename (source_file))), (__temp1293 = (g_free (__temp1293), NULL)), __temp1294);
	if (self->priv->string_h_needed) {
		ValaCCodeIncludeDirective* __temp1295;
		__temp1295 = NULL;
		vala_ccode_fragment_append (self->priv->source_include_directives, VALA_CCODE_NODE ((__temp1295 = vala_ccode_include_directive_new ("string.h", FALSE))));
		(__temp1295 == NULL ? NULL : (__temp1295 = (g_object_unref (__temp1295), NULL)));
	}
	comment = NULL;
	if (vala_source_file_get_comment (source_file) != NULL) {
		ValaCCodeComment* __temp1296;
		__temp1296 = NULL;
		comment = (__temp1296 = vala_ccode_comment_new (vala_source_file_get_comment (source_file)), (comment == NULL ? NULL : (comment = (g_object_unref (comment), NULL))), __temp1296);
	}
	writer = vala_ccode_writer_new (vala_source_file_get_cheader_filename (source_file));
	if (comment != NULL) {
		vala_ccode_node_write (VALA_CCODE_NODE (comment), writer);
	}
	vala_ccode_writer_write_newline (writer);
	once = vala_ccode_once_section_new (header_define);
	__temp1297 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp1297 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp1297 == NULL ? NULL : (__temp1297 = (g_object_unref (__temp1297), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->priv->header_begin));
	__temp1298 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp1298 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp1298 == NULL ? NULL : (__temp1298 = (g_object_unref (__temp1298), NULL)));
	__temp1299 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp1299 = vala_ccode_identifier_new ("G_BEGIN_DECLS"))));
	(__temp1299 == NULL ? NULL : (__temp1299 = (g_object_unref (__temp1299), NULL)));
	__temp1300 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp1300 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp1300 == NULL ? NULL : (__temp1300 = (g_object_unref (__temp1300), NULL)));
	__temp1301 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp1301 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp1301 == NULL ? NULL : (__temp1301 = (g_object_unref (__temp1301), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->priv->header_type_declaration));
	__temp1302 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp1302 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp1302 == NULL ? NULL : (__temp1302 = (g_object_unref (__temp1302), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->priv->header_type_definition));
	__temp1303 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp1303 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp1303 == NULL ? NULL : (__temp1303 = (g_object_unref (__temp1303), NULL)));
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE (self->priv->header_type_member_declaration));
	__temp1304 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp1304 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp1304 == NULL ? NULL : (__temp1304 = (g_object_unref (__temp1304), NULL)));
	__temp1305 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp1305 = vala_ccode_identifier_new ("G_END_DECLS"))));
	(__temp1305 == NULL ? NULL : (__temp1305 = (g_object_unref (__temp1305), NULL)));
	__temp1306 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp1306 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp1306 == NULL ? NULL : (__temp1306 = (g_object_unref (__temp1306), NULL)));
	__temp1307 = NULL;
	vala_ccode_fragment_append (VALA_CCODE_FRAGMENT (once), VALA_CCODE_NODE ((__temp1307 = g_object_new (VALA_TYPE_CCODE_NEWLINE, NULL))));
	(__temp1307 == NULL ? NULL : (__temp1307 = (g_object_unref (__temp1307), NULL)));
	vala_ccode_node_write (VALA_CCODE_NODE (once), writer);
	vala_ccode_writer_close (writer);
	__temp1308 = NULL;
	writer = (__temp1308 = vala_ccode_writer_new (vala_source_file_get_csource_filename (source_file)), (writer == NULL ? NULL : (writer = (g_object_unref (writer), NULL))), __temp1308);
	if (comment != NULL) {
		vala_ccode_node_write (VALA_CCODE_NODE (comment), writer);
	}
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_begin), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_include_directives), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_declaration (VALA_CCODE_NODE (self->priv->source_type_member_declaration), writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_type_member_declaration), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write_declaration (VALA_CCODE_NODE (self->priv->source_signal_marshaller_declaration), writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_signal_marshaller_declaration), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_type_member_definition), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->source_signal_marshaller_definition), writer);
	vala_ccode_writer_write_newline (writer);
	vala_ccode_writer_close (writer);
	__temp1309 = NULL;
	self->priv->header_begin = (__temp1309 = NULL, (self->priv->header_begin == NULL ? NULL : (self->priv->header_begin = (g_object_unref (self->priv->header_begin), NULL))), __temp1309);
	__temp1310 = NULL;
	self->priv->header_type_declaration = (__temp1310 = NULL, (self->priv->header_type_declaration == NULL ? NULL : (self->priv->header_type_declaration = (g_object_unref (self->priv->header_type_declaration), NULL))), __temp1310);
	__temp1311 = NULL;
	self->priv->header_type_definition = (__temp1311 = NULL, (self->priv->header_type_definition == NULL ? NULL : (self->priv->header_type_definition = (g_object_unref (self->priv->header_type_definition), NULL))), __temp1311);
	__temp1312 = NULL;
	self->priv->header_type_member_declaration = (__temp1312 = NULL, (self->priv->header_type_member_declaration == NULL ? NULL : (self->priv->header_type_member_declaration = (g_object_unref (self->priv->header_type_member_declaration), NULL))), __temp1312);
	__temp1313 = NULL;
	self->priv->source_begin = (__temp1313 = NULL, (self->priv->source_begin == NULL ? NULL : (self->priv->source_begin = (g_object_unref (self->priv->source_begin), NULL))), __temp1313);
	__temp1314 = NULL;
	self->priv->source_include_directives = (__temp1314 = NULL, (self->priv->source_include_directives == NULL ? NULL : (self->priv->source_include_directives = (g_object_unref (self->priv->source_include_directives), NULL))), __temp1314);
	__temp1315 = NULL;
	self->priv->source_type_member_declaration = (__temp1315 = NULL, (self->priv->source_type_member_declaration == NULL ? NULL : (self->priv->source_type_member_declaration = (g_object_unref (self->priv->source_type_member_declaration), NULL))), __temp1315);
	__temp1316 = NULL;
	self->priv->source_type_member_definition = (__temp1316 = NULL, (self->priv->source_type_member_definition == NULL ? NULL : (self->priv->source_type_member_definition = (g_object_unref (self->priv->source_type_member_definition), NULL))), __temp1316);
	__temp1317 = NULL;
	self->priv->source_signal_marshaller_definition = (__temp1317 = NULL, (self->priv->source_signal_marshaller_definition == NULL ? NULL : (self->priv->source_signal_marshaller_definition = (g_object_unref (self->priv->source_signal_marshaller_definition), NULL))), __temp1317);
	__temp1318 = NULL;
	self->priv->source_signal_marshaller_declaration = (__temp1318 = NULL, (self->priv->source_signal_marshaller_declaration == NULL ? NULL : (self->priv->source_signal_marshaller_declaration = (g_object_unref (self->priv->source_signal_marshaller_declaration), NULL))), __temp1318);
	(used_includes == NULL ? NULL : (used_includes = (g_list_free (used_includes), NULL)));
	(header_define = (g_free (header_define), NULL));
	(comment == NULL ? NULL : (comment = (g_object_unref (comment), NULL)));
	(writer == NULL ? NULL : (writer = (g_object_unref (writer), NULL)));
	(once == NULL ? NULL : (once = (g_object_unref (once), NULL)));
}


static char* vala_code_generator_get_define_for_filename (const char* filename)
{
	GString* define;
	char* i;
	const char* __temp1321;
	char* __temp1322;
	g_return_val_if_fail (filename != NULL, NULL);
	define = g_string_new ("__");
	i = g_strdup (filename);
	while (g_utf8_strlen (i, -1) > 0) {
		gunichar c;
		char* __temp1320;
		const char* __temp1319;
		c = g_utf8_get_char (i);
		if (g_unichar_isalnum (c) && c < 0x80) {
			g_string_append_unichar (define, g_unichar_toupper (c));
		} else {
			g_string_append_c (define, '_');
		}
		__temp1320 = NULL;
		__temp1319 = NULL;
		i = (__temp1320 = (__temp1319 = g_utf8_next_char (i), (__temp1319 == NULL ? NULL : g_strdup (__temp1319))), (i = (g_free (i), NULL)), __temp1320);
	}
	g_string_append (define, "__");
	__temp1321 = NULL;
	__temp1322 = NULL;
	return (__temp1322 = (__temp1321 = define->str, (__temp1321 == NULL ? NULL : g_strdup (__temp1321))), (define == NULL ? NULL : (define = (g_string_free (define, TRUE), NULL))), (i = (g_free (i), NULL)), __temp1322);
	(define == NULL ? NULL : (define = (g_string_free (define, TRUE), NULL)));
	(i = (g_free (i), NULL));
}


static void vala_code_generator_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st)
{
	ValaCodeGenerator * self;
	ValaSymbol* __temp1324;
	ValaSymbol* __temp1323;
	ValaCCodeStruct* __temp1326;
	char* __temp1325;
	ValaSymbol* __temp1330;
	self = VALA_CODE_GENERATOR (base);
	g_return_if_fail (VALA_IS_STRUCT (st));
	__temp1324 = NULL;
	__temp1323 = NULL;
	self->priv->current_type_symbol = (__temp1324 = (__temp1323 = vala_code_node_get_symbol (VALA_CODE_NODE (st)), (__temp1323 == NULL ? NULL : g_object_ref (__temp1323))), (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), __temp1324);
	__temp1326 = NULL;
	__temp1325 = NULL;
	self->priv->instance_struct = (__temp1326 = vala_ccode_struct_new (g_strdup_printf ("_%s", (__temp1325 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)))), (self->priv->instance_struct == NULL ? NULL : (self->priv->instance_struct = (g_object_unref (self->priv->instance_struct), NULL))), __temp1326);
	(__temp1325 = (g_free (__temp1325), NULL));
	if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (st)))) == NULL) {
		ValaCCodeTypeDefinition* __temp1328;
		char* __temp1327;
		__temp1328 = NULL;
		__temp1327 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_declaration, VALA_CCODE_NODE ((__temp1328 = vala_ccode_type_definition_new (g_strdup_printf ("struct _%s", (__temp1327 = vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE))), VALA_CCODE_DECLARATOR (vala_ccode_variable_declarator_new (vala_data_type_get_cname (VALA_DATA_TYPE (st), FALSE)))))));
		(__temp1328 == NULL ? NULL : (__temp1328 = (g_object_unref (__temp1328), NULL)));
		(__temp1327 = (g_free (__temp1327), NULL));
	}
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (st))) != NULL) {
		ValaCCodeComment* __temp1329;
		__temp1329 = NULL;
		vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE ((__temp1329 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (st)))))));
		(__temp1329 == NULL ? NULL : (__temp1329 = (g_object_unref (__temp1329), NULL)));
	}
	vala_ccode_fragment_append (self->priv->header_type_definition, VALA_CCODE_NODE (self->priv->instance_struct));
	vala_code_node_accept_children (VALA_CODE_NODE (st), VALA_CODE_VISITOR (self));
	__temp1330 = NULL;
	self->priv->current_type_symbol = (__temp1330 = NULL, (self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL))), __temp1330);
}


gboolean vala_code_generator_get_memory_management (ValaCodeGenerator* self)
{
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (self), FALSE);
	return self->priv->_memory_management;
}


void vala_code_generator_set_memory_management (ValaCodeGenerator* self, gboolean value)
{
	g_return_if_fail (VALA_IS_CODE_GENERATOR (self));
	self->priv->_memory_management = value;
}


static GObject * vala_code_generator_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties)
{
	GObject * obj;
	ValaCodeGeneratorClass * klass;
	GObjectClass * parent_class;
	ValaCodeGenerator * self;
	klass = VALA_CODE_GENERATOR_CLASS (g_type_class_peek (VALA_TYPE_CODE_GENERATOR));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = VALA_CODE_GENERATOR (obj);
	{
		GHashTable* __temp1332;
		GHashTable* __temp1333;
		__temp1332 = NULL;
		self->priv->predefined_marshal_list = (__temp1332 = g_hash_table_new (g_str_hash, g_str_equal), (self->priv->predefined_marshal_list == NULL ? NULL : (self->priv->predefined_marshal_list = (g_hash_table_unref (self->priv->predefined_marshal_list), NULL))), __temp1332);
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:VOID"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:BOOLEAN"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:CHAR"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:UCHAR"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:INT"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:UINT"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:LONG"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:ULONG"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:ENUM"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:FLAGS"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:FLOAT"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:DOUBLE"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:STRING"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:POINTER"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:OBJECT"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("STRING:OBJECT,POINTER"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("VOID:UINT,POINTER"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->predefined_marshal_list, g_strdup ("BOOLEAN:FLAGS"), GINT_TO_POINTER (TRUE));
		__temp1333 = NULL;
		self->priv->c_keywords = (__temp1333 = g_hash_table_new (g_str_hash, g_str_equal), (self->priv->c_keywords == NULL ? NULL : (self->priv->c_keywords = (g_hash_table_unref (self->priv->c_keywords), NULL))), __temp1333);
		/* C99 keywords*/
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("_Bool"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("_Complex"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("_Imaginary"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("auto"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("break"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("case"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("char"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("const"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("continue"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("default"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("do"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("double"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("else"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("enum"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("extern"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("float"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("for"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("goto"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("if"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("inline"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("int"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("long"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("register"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("restrict"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("return"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("short"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("signed"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("sizeof"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("static"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("struct"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("switch"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("typedef"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("union"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("unsigned"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("void"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("volatile"), GINT_TO_POINTER (TRUE));
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("while"), GINT_TO_POINTER (TRUE));
		/* MSVC keywords*/
		g_hash_table_insert (self->priv->c_keywords, g_strdup ("cdecl"), GINT_TO_POINTER (TRUE));
	}
	return obj;
}


static void vala_code_generator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (object);
	switch (property_id) {
		case VALA_CODE_GENERATOR_MEMORY_MANAGEMENT:
		g_value_set_boolean (value, vala_code_generator_get_memory_management (self));
		break;
	}
}


static void vala_code_generator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaCodeGenerator * self;
	self = VALA_CODE_GENERATOR (object);
	switch (property_id) {
		case VALA_CODE_GENERATOR_MEMORY_MANAGEMENT:
		vala_code_generator_set_memory_management (self, g_value_get_boolean (value));
		break;
	}
}


static void vala_code_generator_class_init (ValaCodeGeneratorClass * klass)
{
	vala_code_generator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCodeGeneratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_code_generator_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_code_generator_set_property;
	G_OBJECT_CLASS (klass)->constructor = vala_code_generator_constructor;
	G_OBJECT_CLASS (klass)->dispose = vala_code_generator_dispose;
	VALA_CODE_VISITOR_CLASS (klass)->visit_namespace = vala_code_generator_real_visit_namespace;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = vala_code_generator_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum_value = vala_code_generator_real_visit_enum_value;
	VALA_CODE_VISITOR_CLASS (klass)->visit_flags = vala_code_generator_real_visit_flags;
	VALA_CODE_VISITOR_CLASS (klass)->visit_flags_value = vala_code_generator_real_visit_flags_value;
	VALA_CODE_VISITOR_CLASS (klass)->visit_callback = vala_code_generator_real_visit_callback;
	VALA_CODE_VISITOR_CLASS (klass)->visit_member = vala_code_generator_real_visit_member;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constant = vala_code_generator_real_visit_constant;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = vala_code_generator_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_formal_parameter = vala_code_generator_real_visit_formal_parameter;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property = vala_code_generator_real_visit_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property_accessor = vala_code_generator_real_visit_property_accessor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constructor = vala_code_generator_real_visit_constructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_destructor = vala_code_generator_real_visit_destructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_block = vala_code_generator_real_visit_begin_block;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_block = vala_code_generator_real_visit_end_block;
	VALA_CODE_VISITOR_CLASS (klass)->visit_empty_statement = vala_code_generator_real_visit_empty_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_declaration_statement = vala_code_generator_real_visit_declaration_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_variable_declarator = vala_code_generator_real_visit_variable_declarator;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_initializer_list = vala_code_generator_real_visit_end_initializer_list;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_full_expression = vala_code_generator_real_visit_end_full_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_expression_statement = vala_code_generator_real_visit_expression_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_if_statement = vala_code_generator_real_visit_if_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_statement = vala_code_generator_real_visit_switch_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_while_statement = vala_code_generator_real_visit_while_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_do_statement = vala_code_generator_real_visit_do_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_for_statement = vala_code_generator_real_visit_for_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_foreach_statement = vala_code_generator_real_visit_end_foreach_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_break_statement = vala_code_generator_real_visit_break_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_continue_statement = vala_code_generator_real_visit_continue_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_begin_return_statement = vala_code_generator_real_visit_begin_return_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_return_statement = vala_code_generator_real_visit_end_return_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_throw_statement = vala_code_generator_real_visit_throw_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_try_statement = vala_code_generator_real_visit_try_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_catch_clause = vala_code_generator_real_visit_catch_clause;
	VALA_CODE_VISITOR_CLASS (klass)->visit_lock_statement = vala_code_generator_real_visit_lock_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_array_creation_expression = vala_code_generator_real_visit_end_array_creation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_boolean_literal = vala_code_generator_real_visit_boolean_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_character_literal = vala_code_generator_real_visit_character_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_integer_literal = vala_code_generator_real_visit_integer_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_real_literal = vala_code_generator_real_visit_real_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_string_literal = vala_code_generator_real_visit_string_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_null_literal = vala_code_generator_real_visit_null_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_literal_expression = vala_code_generator_real_visit_literal_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_parenthesized_expression = vala_code_generator_real_visit_parenthesized_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_element_access = vala_code_generator_real_visit_element_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_base_access = vala_code_generator_real_visit_base_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_postfix_expression = vala_code_generator_real_visit_postfix_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_object_creation_expression = vala_code_generator_real_visit_end_object_creation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_sizeof_expression = vala_code_generator_real_visit_sizeof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_typeof_expression = vala_code_generator_real_visit_typeof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_unary_expression = vala_code_generator_real_visit_unary_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_cast_expression = vala_code_generator_real_visit_cast_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_pointer_indirection = vala_code_generator_real_visit_pointer_indirection;
	VALA_CODE_VISITOR_CLASS (klass)->visit_addressof_expression = vala_code_generator_real_visit_addressof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_reference_transfer_expression = vala_code_generator_real_visit_reference_transfer_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_binary_expression = vala_code_generator_real_visit_binary_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_type_check = vala_code_generator_real_visit_type_check;
	VALA_CODE_VISITOR_CLASS (klass)->visit_conditional_expression = vala_code_generator_real_visit_conditional_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_lambda_expression = vala_code_generator_real_visit_end_lambda_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_assignment = vala_code_generator_real_visit_end_assignment;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = vala_code_generator_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = vala_code_generator_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_end_invocation_expression = vala_code_generator_real_visit_end_invocation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_member_access = vala_code_generator_real_visit_member_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method = vala_code_generator_real_visit_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_creation_method = vala_code_generator_real_visit_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_signal = vala_code_generator_real_visit_signal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = vala_code_generator_real_visit_source_file;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = vala_code_generator_real_visit_struct;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CODE_GENERATOR_MEMORY_MANAGEMENT, g_param_spec_boolean ("memory-management", "foo", "bar", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_code_generator_init (ValaCodeGenerator * self)
{
	self->priv = VALA_CODE_GENERATOR_GET_PRIVATE (self);
	self->priv->next_temp_var_id = 0;
	self->priv->current_try_id = 0;
	self->priv->next_try_id = 0;
	self->priv->in_creation_method = FALSE;
	self->priv->current_method_inner_error = FALSE;
	self->priv->in_plugin = FALSE;
}


static void vala_code_generator_dispose (GObject * obj)
{
	ValaCodeGenerator * self;
	ValaCodeGeneratorClass * klass;
	GObjectClass * parent_class;
	self = VALA_CODE_GENERATOR (obj);
	(self->priv->context == NULL ? NULL : (self->priv->context = (g_object_unref (self->priv->context), NULL)));
	(self->priv->root_symbol == NULL ? NULL : (self->priv->root_symbol = (g_object_unref (self->priv->root_symbol), NULL)));
	(self->priv->current_symbol == NULL ? NULL : (self->priv->current_symbol = (g_object_unref (self->priv->current_symbol), NULL)));
	(self->priv->current_type_symbol == NULL ? NULL : (self->priv->current_type_symbol = (g_object_unref (self->priv->current_type_symbol), NULL)));
	(self->priv->current_class == NULL ? NULL : (self->priv->current_class = (g_object_unref (self->priv->current_class), NULL)));
	(self->priv->current_method == NULL ? NULL : (self->priv->current_method = (g_object_unref (self->priv->current_method), NULL)));
	(self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (g_object_unref (self->priv->current_return_type), NULL)));
	(self->priv->current_try == NULL ? NULL : (self->priv->current_try = (g_object_unref (self->priv->current_try), NULL)));
	(self->priv->header_begin == NULL ? NULL : (self->priv->header_begin = (g_object_unref (self->priv->header_begin), NULL)));
	(self->priv->header_type_declaration == NULL ? NULL : (self->priv->header_type_declaration = (g_object_unref (self->priv->header_type_declaration), NULL)));
	(self->priv->header_type_definition == NULL ? NULL : (self->priv->header_type_definition = (g_object_unref (self->priv->header_type_definition), NULL)));
	(self->priv->header_type_member_declaration == NULL ? NULL : (self->priv->header_type_member_declaration = (g_object_unref (self->priv->header_type_member_declaration), NULL)));
	(self->priv->source_begin == NULL ? NULL : (self->priv->source_begin = (g_object_unref (self->priv->source_begin), NULL)));
	(self->priv->source_include_directives == NULL ? NULL : (self->priv->source_include_directives = (g_object_unref (self->priv->source_include_directives), NULL)));
	(self->priv->source_type_member_declaration == NULL ? NULL : (self->priv->source_type_member_declaration = (g_object_unref (self->priv->source_type_member_declaration), NULL)));
	(self->priv->source_signal_marshaller_declaration == NULL ? NULL : (self->priv->source_signal_marshaller_declaration = (g_object_unref (self->priv->source_signal_marshaller_declaration), NULL)));
	(self->priv->source_type_member_definition == NULL ? NULL : (self->priv->source_type_member_definition = (g_object_unref (self->priv->source_type_member_definition), NULL)));
	(self->priv->instance_init_fragment == NULL ? NULL : (self->priv->instance_init_fragment = (g_object_unref (self->priv->instance_init_fragment), NULL)));
	(self->priv->instance_dispose_fragment == NULL ? NULL : (self->priv->instance_dispose_fragment = (g_object_unref (self->priv->instance_dispose_fragment), NULL)));
	(self->priv->source_signal_marshaller_definition == NULL ? NULL : (self->priv->source_signal_marshaller_definition = (g_object_unref (self->priv->source_signal_marshaller_definition), NULL)));
	(self->priv->module_init_fragment == NULL ? NULL : (self->priv->module_init_fragment = (g_object_unref (self->priv->module_init_fragment), NULL)));
	(self->priv->instance_struct == NULL ? NULL : (self->priv->instance_struct = (g_object_unref (self->priv->instance_struct), NULL)));
	(self->priv->type_struct == NULL ? NULL : (self->priv->type_struct = (g_object_unref (self->priv->type_struct), NULL)));
	(self->priv->instance_priv_struct == NULL ? NULL : (self->priv->instance_priv_struct = (g_object_unref (self->priv->instance_priv_struct), NULL)));
	(self->priv->prop_enum == NULL ? NULL : (self->priv->prop_enum = (g_object_unref (self->priv->prop_enum), NULL)));
	(self->priv->cenum == NULL ? NULL : (self->priv->cenum = (g_object_unref (self->priv->cenum), NULL)));
	(self->priv->function == NULL ? NULL : (self->priv->function = (g_object_unref (self->priv->function), NULL)));
	(self->priv->block == NULL ? NULL : (self->priv->block = (g_object_unref (self->priv->block), NULL)));
	(self->priv->temp_vars == NULL ? NULL : (self->priv->temp_vars = (g_list_foreach (self->priv->temp_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_vars), NULL)));
	(self->priv->temp_ref_vars == NULL ? NULL : (self->priv->temp_ref_vars = (g_list_foreach (self->priv->temp_ref_vars, (GFunc) g_object_unref, NULL), g_list_free (self->priv->temp_ref_vars), NULL)));
	(self->priv->user_marshal_list == NULL ? NULL : (self->priv->user_marshal_list = (g_hash_table_unref (self->priv->user_marshal_list), NULL)));
	(self->priv->predefined_marshal_list == NULL ? NULL : (self->priv->predefined_marshal_list = (g_hash_table_unref (self->priv->predefined_marshal_list), NULL)));
	(self->priv->c_keywords == NULL ? NULL : (self->priv->c_keywords = (g_hash_table_unref (self->priv->c_keywords), NULL)));
	(self->priv->bool_type == NULL ? NULL : (self->priv->bool_type = (g_object_unref (self->priv->bool_type), NULL)));
	(self->priv->char_type == NULL ? NULL : (self->priv->char_type = (g_object_unref (self->priv->char_type), NULL)));
	(self->priv->unichar_type == NULL ? NULL : (self->priv->unichar_type = (g_object_unref (self->priv->unichar_type), NULL)));
	(self->priv->short_type == NULL ? NULL : (self->priv->short_type = (g_object_unref (self->priv->short_type), NULL)));
	(self->priv->ushort_type == NULL ? NULL : (self->priv->ushort_type = (g_object_unref (self->priv->ushort_type), NULL)));
	(self->priv->int_type == NULL ? NULL : (self->priv->int_type = (g_object_unref (self->priv->int_type), NULL)));
	(self->priv->uint_type == NULL ? NULL : (self->priv->uint_type = (g_object_unref (self->priv->uint_type), NULL)));
	(self->priv->long_type == NULL ? NULL : (self->priv->long_type = (g_object_unref (self->priv->long_type), NULL)));
	(self->priv->ulong_type == NULL ? NULL : (self->priv->ulong_type = (g_object_unref (self->priv->ulong_type), NULL)));
	(self->priv->int64_type == NULL ? NULL : (self->priv->int64_type = (g_object_unref (self->priv->int64_type), NULL)));
	(self->priv->uint64_type == NULL ? NULL : (self->priv->uint64_type = (g_object_unref (self->priv->uint64_type), NULL)));
	(self->priv->string_type == NULL ? NULL : (self->priv->string_type = (g_object_unref (self->priv->string_type), NULL)));
	(self->priv->float_type == NULL ? NULL : (self->priv->float_type = (g_object_unref (self->priv->float_type), NULL)));
	(self->priv->double_type == NULL ? NULL : (self->priv->double_type = (g_object_unref (self->priv->double_type), NULL)));
	(self->priv->list_type == NULL ? NULL : (self->priv->list_type = (g_object_unref (self->priv->list_type), NULL)));
	(self->priv->slist_type == NULL ? NULL : (self->priv->slist_type = (g_object_unref (self->priv->slist_type), NULL)));
	(self->priv->mutex_type == NULL ? NULL : (self->priv->mutex_type = (g_object_unref (self->priv->mutex_type), NULL)));
	(self->priv->type_module_type == NULL ? NULL : (self->priv->type_module_type = (g_object_unref (self->priv->type_module_type), NULL)));
	(self->priv->substring_method == NULL ? NULL : (self->priv->substring_method = (g_object_unref (self->priv->substring_method), NULL)));
	(self->priv->module_init_param_name = (g_free (self->priv->module_init_param_name), NULL));
	klass = VALA_CODE_GENERATOR_CLASS (g_type_class_peek (VALA_TYPE_CODE_GENERATOR));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_code_generator_get_type ()
{
	static GType vala_code_generator_type_id = 0;
	if (G_UNLIKELY (vala_code_generator_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCodeGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_code_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCodeGenerator), 0, (GInstanceInitFunc) vala_code_generator_init };
		vala_code_generator_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaCodeGenerator", &g_define_type_info, 0);
	}
	return vala_code_generator_type_id;
}




