/* valadostatement.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALADOSTATEMENT_H__
#define __VALADOSTATEMENT_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valastatement.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_DO_STATEMENT (vala_do_statement_get_type ())
#define VALA_DO_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DO_STATEMENT, ValaDoStatement))
#define VALA_DO_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DO_STATEMENT, ValaDoStatementClass))
#define VALA_IS_DO_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DO_STATEMENT))
#define VALA_IS_DO_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DO_STATEMENT))
#define VALA_DO_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DO_STATEMENT, ValaDoStatementClass))

typedef struct _ValaDoStatementPrivate ValaDoStatementPrivate;

/**
 * Represents a do iteration statement in the source code.
 */
struct _ValaDoStatement {
	ValaStatement parent;
	ValaDoStatementPrivate * priv;
};
struct _ValaDoStatementClass {
	ValaStatementClass parent;
};

ValaDoStatement* vala_do_statement_new (ValaStatement* _body, ValaExpression* cond, ValaSourceReference* source);
ValaStatement* vala_do_statement_get_body (ValaDoStatement* self);
void vala_do_statement_set_body (ValaDoStatement* self, ValaStatement* value);
ValaExpression* vala_do_statement_get_condition (ValaDoStatement* self);
void vala_do_statement_set_condition (ValaDoStatement* self, ValaExpression* value);
GType vala_do_statement_get_type ();

G_END_DECLS

#endif
