/* valatrystatement.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */
#define VALA_FREE_CHECKED(o,f) ((o) == NULL ? NULL : ((o) = (f (o), NULL)))
#define VALA_FREE_UNCHECKED(o,f) ((o) = (f (o), NULL))

#include "valatrystatement.h"
#include <vala/valablock.h>
#include <vala/valasourcereference.h>
#include <vala/valatrystatement.h>
#include <vala/valacatchclause.h>
#include <vala/valacodevisitor.h>

struct _ValaTryStatementPrivate {
	ValaBlock* _body;
	ValaBlock* _finally_body;
	GList* catch_clauses;
};
#define VALA_TRY_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TRY_STATEMENT, ValaTryStatementPrivate))
enum  {
	VALA_TRY_STATEMENT_DUMMY_PROPERTY,
	VALA_TRY_STATEMENT_BODY,
	VALA_TRY_STATEMENT_FINALLY_BODY
};
static void vala_try_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_try_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_try_statement_parent_class = NULL;
static void vala_try_statement_dispose (GObject * obj);


/**
 * Creates a new try statement.
 *
 * @param body             body of the try statement
 * @param finally_body     body of the optional finally clause
 * @param source_reference reference to source code
 * @return                 newly created try statement
 */
ValaTryStatement* vala_try_statement_new (ValaBlock* body, ValaBlock* finally_body, ValaSourceReference* source_reference)
{
	GParameter * __params;
	GParameter * __params_it;
	ValaTryStatement * self;
	g_return_val_if_fail (VALA_IS_BLOCK (body), NULL);
	g_return_val_if_fail (finally_body == NULL || VALA_IS_BLOCK (finally_body), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	__params = g_new0 (GParameter, 3);
	__params_it = __params;
	(__params_it->name = "body", g_value_init (&__params_it->value, VALA_TYPE_BLOCK), g_value_set_object (&__params_it->value, body), __params_it++);
	(__params_it->name = "finally-body", g_value_init (&__params_it->value, VALA_TYPE_BLOCK), g_value_set_object (&__params_it->value, finally_body), __params_it++);
	(__params_it->name = "source-reference", g_value_init (&__params_it->value, VALA_TYPE_SOURCE_REFERENCE), g_value_set_object (&__params_it->value, source_reference), __params_it++);
	self = g_object_newv (VALA_TYPE_TRY_STATEMENT, __params_it - __params, __params);
	return self;
}


/**
 * Appends the specified clause to the list of catch clauses.
 *
 * @param clause a catch clause
 */
void vala_try_statement_add_catch_clause (ValaTryStatement* self, ValaCatchClause* clause)
{
	g_return_if_fail (VALA_IS_TRY_STATEMENT (self));
	g_return_if_fail (VALA_IS_CATCH_CLAUSE (clause));
	self->priv->catch_clauses = g_list_append (self->priv->catch_clauses, g_object_ref (clause));
}


/**
 * Returns a copy of the list of catch clauses.
 *
 * @return list of catch clauses
 */
GList* vala_try_statement_get_catch_clauses (ValaTryStatement* self)
{
	g_return_val_if_fail (VALA_IS_TRY_STATEMENT (self), NULL);
	return g_list_copy (self->priv->catch_clauses);
}


static void vala_try_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaTryStatement * self;
	self = VALA_TRY_STATEMENT (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_try_statement (visitor, self);
}


static void vala_try_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor)
{
	ValaTryStatement * self;
	self = VALA_TRY_STATEMENT (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (vala_try_statement_get_body (self)), visitor);
	{
		GList* __temp1;
		GList* clause_it;
		__temp1 = NULL;
		__temp1 = self->priv->catch_clauses;
		for (clause_it = __temp1; clause_it != NULL; clause_it = clause_it->next) {
			ValaCatchClause* clause;
			clause = clause_it->data;
			{
				vala_code_node_accept (VALA_CODE_NODE (clause), visitor);
			}
		}
	}
}


ValaBlock* vala_try_statement_get_body (ValaTryStatement* self)
{
	g_return_val_if_fail (VALA_IS_TRY_STATEMENT (self), NULL);
	return self->priv->_body;
}


void vala_try_statement_set_body (ValaTryStatement* self, ValaBlock* value)
{
	ValaBlock* __temp3;
	g_return_if_fail (VALA_IS_TRY_STATEMENT (self));
	__temp3 = NULL;
	self->priv->_body = (__temp3 = g_object_ref (value), (self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL))), __temp3);
}


ValaBlock* vala_try_statement_get_finally_body (ValaTryStatement* self)
{
	g_return_val_if_fail (VALA_IS_TRY_STATEMENT (self), NULL);
	return self->priv->_finally_body;
}


void vala_try_statement_set_finally_body (ValaTryStatement* self, ValaBlock* value)
{
	ValaBlock* __temp6;
	ValaBlock* __temp5;
	g_return_if_fail (VALA_IS_TRY_STATEMENT (self));
	__temp6 = NULL;
	__temp5 = NULL;
	self->priv->_finally_body = (__temp6 = (__temp5 = value, (__temp5 == NULL ? NULL : g_object_ref (__temp5))), (self->priv->_finally_body == NULL ? NULL : (self->priv->_finally_body = (g_object_unref (self->priv->_finally_body), NULL))), __temp6);
}


static void vala_try_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec)
{
	ValaTryStatement * self;
	self = VALA_TRY_STATEMENT (object);
	switch (property_id) {
		case VALA_TRY_STATEMENT_BODY:
		g_value_set_object (value, vala_try_statement_get_body (self));
		break;
		case VALA_TRY_STATEMENT_FINALLY_BODY:
		g_value_set_object (value, vala_try_statement_get_finally_body (self));
		break;
	}
}


static void vala_try_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec)
{
	ValaTryStatement * self;
	self = VALA_TRY_STATEMENT (object);
	switch (property_id) {
		case VALA_TRY_STATEMENT_BODY:
		vala_try_statement_set_body (self, g_value_get_object (value));
		break;
		case VALA_TRY_STATEMENT_FINALLY_BODY:
		vala_try_statement_set_finally_body (self, g_value_get_object (value));
		break;
	}
}


static void vala_try_statement_class_init (ValaTryStatementClass * klass)
{
	vala_try_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaTryStatementPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_try_statement_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_try_statement_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_try_statement_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_try_statement_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_try_statement_real_accept_children;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_TRY_STATEMENT_BODY, g_param_spec_object ("body", "foo", "bar", VALA_TYPE_BLOCK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_TRY_STATEMENT_FINALLY_BODY, g_param_spec_object ("finally-body", "foo", "bar", VALA_TYPE_BLOCK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_try_statement_init (ValaTryStatement * self)
{
	self->priv = VALA_TRY_STATEMENT_GET_PRIVATE (self);
}


static void vala_try_statement_dispose (GObject * obj)
{
	ValaTryStatement * self;
	ValaTryStatementClass * klass;
	GObjectClass * parent_class;
	self = VALA_TRY_STATEMENT (obj);
	(self->priv->_body == NULL ? NULL : (self->priv->_body = (g_object_unref (self->priv->_body), NULL)));
	(self->priv->_finally_body == NULL ? NULL : (self->priv->_finally_body = (g_object_unref (self->priv->_finally_body), NULL)));
	(self->priv->catch_clauses == NULL ? NULL : (self->priv->catch_clauses = (g_list_foreach (self->priv->catch_clauses, (GFunc) g_object_unref, NULL), g_list_free (self->priv->catch_clauses), NULL)));
	klass = VALA_TRY_STATEMENT_CLASS (g_type_class_peek (VALA_TYPE_TRY_STATEMENT));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	parent_class->dispose (obj);
}


GType vala_try_statement_get_type ()
{
	static GType vala_try_statement_type_id = 0;
	if (G_UNLIKELY (vala_try_statement_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTryStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_try_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTryStatement), 0, (GInstanceInitFunc) vala_try_statement_init };
		vala_try_statement_type_id = g_type_register_static (VALA_TYPE_STATEMENT, "ValaTryStatement", &g_define_type_info, 0);
	}
	return vala_try_statement_type_id;
}




