/* valaccodedeclarator.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodedeclarator.h>

enum  {
	VALA_CCODE_DECLARATOR_DUMMY_PROPERTY
};
static void vala_ccode_declarator_real_write_initialization (ValaCCodeDeclarator* self, ValaCCodeWriter* writer);
static gpointer vala_ccode_declarator_parent_class = NULL;


/**
 * Writes initialization statements for this declarator with the
 * specified C code writer if necessary.
 *
 * @param writer a C code writer
 */
static void vala_ccode_declarator_real_write_initialization (ValaCCodeDeclarator* self, ValaCCodeWriter* writer) {
	g_return_if_fail (VALA_IS_CCODE_DECLARATOR (self));
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
}


void vala_ccode_declarator_write_initialization (ValaCCodeDeclarator* self, ValaCCodeWriter* writer) {
	VALA_CCODE_DECLARATOR_GET_CLASS (self)->write_initialization (self, writer);
}


static void vala_ccode_declarator_class_init (ValaCCodeDeclaratorClass * klass) {
	vala_ccode_declarator_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_DECLARATOR_CLASS (klass)->write_initialization = vala_ccode_declarator_real_write_initialization;
}


static void vala_ccode_declarator_init (ValaCCodeDeclarator * self) {
}


GType vala_ccode_declarator_get_type (void) {
	static GType vala_ccode_declarator_type_id = 0;
	if (G_UNLIKELY (vala_ccode_declarator_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeDeclaratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_declarator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeDeclarator), 0, (GInstanceInitFunc) vala_ccode_declarator_init };
		vala_ccode_declarator_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeDeclarator", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_ccode_declarator_type_id;
}




