/* valaccodebinding.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __GOBJECT_VALACCODEBINDING_H__
#define __GOBJECT_VALACCODEBINDING_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodebinding.h>
#include <gobject/valaccodegenerator.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_BINDING (vala_ccode_binding_get_type ())
#define VALA_CCODE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BINDING, ValaCCodeBinding))
#define VALA_CCODE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BINDING, ValaCCodeBindingClass))
#define VALA_IS_CCODE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BINDING))
#define VALA_IS_CCODE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BINDING))
#define VALA_CCODE_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BINDING, ValaCCodeBindingClass))

typedef struct _ValaCCodeBinding ValaCCodeBinding;
typedef struct _ValaCCodeBindingClass ValaCCodeBindingClass;
typedef struct _ValaCCodeBindingPrivate ValaCCodeBindingPrivate;

/**
 * The link between a source code node and generated code.
 */
struct _ValaCCodeBinding {
	ValaCodeBinding parent;
	ValaCCodeBindingPrivate * priv;
};
struct _ValaCCodeBindingClass {
	ValaCodeBindingClass parent;
};

ValaCCodeGenerator* vala_ccode_binding_get_codegen (ValaCCodeBinding* self);
void vala_ccode_binding_set_codegen (ValaCCodeBinding* self, ValaCCodeGenerator* value);
GType vala_ccode_binding_get_type (void);

G_END_DECLS

#endif
