/* valacastexpression.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valacastexpression.h>
#include <vala/valatypereference.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>

struct _ValaCastExpressionPrivate {
	ValaTypeReference* _type_reference;
	gboolean _is_silent_cast;
	ValaExpression* _inner;
};
#define VALA_CAST_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CAST_EXPRESSION, ValaCastExpressionPrivate))
enum  {
	VALA_CAST_EXPRESSION_DUMMY_PROPERTY,
	VALA_CAST_EXPRESSION_INNER,
	VALA_CAST_EXPRESSION_TYPE_REFERENCE,
	VALA_CAST_EXPRESSION_IS_SILENT_CAST
};
static void vala_cast_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_cast_expression_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node);
static gpointer vala_cast_expression_parent_class = NULL;
static void vala_cast_expression_dispose (GObject * obj);


/**
 * Creates a new cast expression.
 *
 * @param inner expression to be cast
 * @param type  target type
 * @return      newly created cast expression
 */
ValaCastExpression* vala_cast_expression_new (ValaExpression* inner, ValaTypeReference* type_reference, ValaSourceReference* source_reference, gboolean is_silent_cast) {
	GParameter * __params;
	GParameter * __params_it;
	ValaCastExpression * self;
	g_return_val_if_fail (VALA_IS_EXPRESSION (inner), NULL);
	g_return_val_if_fail (VALA_IS_TYPE_REFERENCE (type_reference), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	__params = g_new0 (GParameter, 3);
	__params_it = __params;
	(__params_it->name = "inner", g_value_init (&__params_it->value, VALA_TYPE_EXPRESSION), g_value_set_object (&__params_it->value, inner), __params_it++);
	(__params_it->name = "type-reference", g_value_init (&__params_it->value, VALA_TYPE_TYPE_REFERENCE), g_value_set_object (&__params_it->value, type_reference), __params_it++);
	(__params_it->name = "is-silent-cast", g_value_init (&__params_it->value, G_TYPE_BOOLEAN), g_value_set_boolean (&__params_it->value, is_silent_cast), __params_it++);
	self = g_object_newv (VALA_TYPE_CAST_EXPRESSION, __params_it - __params, __params);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_cast_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaCastExpression * self;
	self = VALA_CAST_EXPRESSION (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (vala_cast_expression_get_inner (self)), visitor);
	vala_code_node_accept (VALA_CODE_NODE (vala_cast_expression_get_type_reference (self)), visitor);
	vala_code_visitor_visit_cast_expression (visitor, self);
}


static void vala_cast_expression_real_replace (ValaCodeNode* base, ValaCodeNode* old_node, ValaCodeNode* new_node) {
	ValaCastExpression * self;
	self = VALA_CAST_EXPRESSION (base);
	g_return_if_fail (VALA_IS_CODE_NODE (old_node));
	g_return_if_fail (VALA_IS_CODE_NODE (new_node));
	if (VALA_CODE_NODE (vala_cast_expression_get_inner (self)) == old_node) {
		vala_cast_expression_set_inner (self, VALA_EXPRESSION (new_node));
	}
}


ValaExpression* vala_cast_expression_get_inner (ValaCastExpression* self) {
	g_return_val_if_fail (VALA_IS_CAST_EXPRESSION (self), NULL);
	return self->priv->_inner;
}


void vala_cast_expression_set_inner (ValaCastExpression* self, ValaExpression* value) {
	ValaExpression* _tmp1;
	g_return_if_fail (VALA_IS_CAST_EXPRESSION (self));
	_tmp1 = NULL;
	self->priv->_inner = (_tmp1 = g_object_ref (value), (self->priv->_inner == NULL ? NULL : (self->priv->_inner = (g_object_unref (self->priv->_inner), NULL))), _tmp1);
	vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_inner), VALA_CODE_NODE (self));
}


ValaTypeReference* vala_cast_expression_get_type_reference (ValaCastExpression* self) {
	g_return_val_if_fail (VALA_IS_CAST_EXPRESSION (self), NULL);
	return self->priv->_type_reference;
}


void vala_cast_expression_set_type_reference (ValaCastExpression* self, ValaTypeReference* value) {
	ValaTypeReference* _tmp1;
	g_return_if_fail (VALA_IS_CAST_EXPRESSION (self));
	_tmp1 = NULL;
	self->priv->_type_reference = (_tmp1 = g_object_ref (value), (self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL))), _tmp1);
}


gboolean vala_cast_expression_get_is_silent_cast (ValaCastExpression* self) {
	g_return_val_if_fail (VALA_IS_CAST_EXPRESSION (self), FALSE);
	return self->priv->_is_silent_cast;
}


void vala_cast_expression_set_is_silent_cast (ValaCastExpression* self, gboolean value) {
	g_return_if_fail (VALA_IS_CAST_EXPRESSION (self));
	self->priv->_is_silent_cast = value;
}


static void vala_cast_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCastExpression * self;
	self = VALA_CAST_EXPRESSION (object);
	switch (property_id) {
		case VALA_CAST_EXPRESSION_INNER:
		g_value_set_object (value, vala_cast_expression_get_inner (self));
		break;
		case VALA_CAST_EXPRESSION_TYPE_REFERENCE:
		g_value_set_object (value, vala_cast_expression_get_type_reference (self));
		break;
		case VALA_CAST_EXPRESSION_IS_SILENT_CAST:
		g_value_set_boolean (value, vala_cast_expression_get_is_silent_cast (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_cast_expression_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCastExpression * self;
	self = VALA_CAST_EXPRESSION (object);
	switch (property_id) {
		case VALA_CAST_EXPRESSION_INNER:
		vala_cast_expression_set_inner (self, g_value_get_object (value));
		break;
		case VALA_CAST_EXPRESSION_TYPE_REFERENCE:
		vala_cast_expression_set_type_reference (self, g_value_get_object (value));
		break;
		case VALA_CAST_EXPRESSION_IS_SILENT_CAST:
		vala_cast_expression_set_is_silent_cast (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_cast_expression_class_init (ValaCastExpressionClass * klass) {
	vala_cast_expression_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCastExpressionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_cast_expression_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_cast_expression_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_cast_expression_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_cast_expression_real_accept;
	VALA_CODE_NODE_CLASS (klass)->replace = vala_cast_expression_real_replace;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CAST_EXPRESSION_INNER, g_param_spec_object ("inner", "inner", "inner", VALA_TYPE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CAST_EXPRESSION_TYPE_REFERENCE, g_param_spec_object ("type-reference", "type-reference", "type-reference", VALA_TYPE_TYPE_REFERENCE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CAST_EXPRESSION_IS_SILENT_CAST, g_param_spec_boolean ("is-silent-cast", "is-silent-cast", "is-silent-cast", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_cast_expression_init (ValaCastExpression * self) {
	self->priv = VALA_CAST_EXPRESSION_GET_PRIVATE (self);
}


static void vala_cast_expression_dispose (GObject * obj) {
	ValaCastExpression * self;
	self = VALA_CAST_EXPRESSION (obj);
	(self->priv->_type_reference == NULL ? NULL : (self->priv->_type_reference = (g_object_unref (self->priv->_type_reference), NULL)));
	(self->priv->_inner == NULL ? NULL : (self->priv->_inner = (g_object_unref (self->priv->_inner), NULL)));
	G_OBJECT_CLASS (vala_cast_expression_parent_class)->dispose (obj);
}


GType vala_cast_expression_get_type (void) {
	static GType vala_cast_expression_type_id = 0;
	if (G_UNLIKELY (vala_cast_expression_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCastExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_cast_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCastExpression), 0, (GInstanceInitFunc) vala_cast_expression_init };
		vala_cast_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaCastExpression", &g_define_type_info, 0);
	}
	return vala_cast_expression_type_id;
}




