/* valaccodefile.c generated by valac, the Vala compiler
 * generated from valaccodefile.vala, do not modify */

/* valaccodefile.vala
 *
 * Copyright (C) 2009-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_CCODE_FILE (vala_ccode_file_get_type ())
#define VALA_CCODE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_FILE, ValaCCodeFile))
#define VALA_CCODE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_FILE, ValaCCodeFileClass))
#define VALA_IS_CCODE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_FILE))
#define VALA_IS_CCODE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_FILE))
#define VALA_CCODE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_FILE, ValaCCodeFileClass))

typedef struct _ValaCCodeFile ValaCCodeFile;
typedef struct _ValaCCodeFileClass ValaCCodeFileClass;
typedef struct _ValaCCodeFilePrivate ValaCCodeFilePrivate;

#define VALA_TYPE_CCODE_NODE (vala_ccode_node_get_type ())
#define VALA_CCODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_NODE, ValaCCodeNode))
#define VALA_CCODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_NODE, ValaCCodeNodeClass))
#define VALA_IS_CCODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_NODE))
#define VALA_IS_CCODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_NODE))
#define VALA_CCODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_NODE, ValaCCodeNodeClass))

typedef struct _ValaCCodeNode ValaCCodeNode;
typedef struct _ValaCCodeNodeClass ValaCCodeNodeClass;

#define VALA_TYPE_CCODE_FRAGMENT (vala_ccode_fragment_get_type ())
#define VALA_CCODE_FRAGMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_FRAGMENT, ValaCCodeFragment))
#define VALA_CCODE_FRAGMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_FRAGMENT, ValaCCodeFragmentClass))
#define VALA_IS_CCODE_FRAGMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_FRAGMENT))
#define VALA_IS_CCODE_FRAGMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_FRAGMENT))
#define VALA_CCODE_FRAGMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_FRAGMENT, ValaCCodeFragmentClass))

typedef struct _ValaCCodeFragment ValaCCodeFragment;
typedef struct _ValaCCodeFragmentClass ValaCCodeFragmentClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))

#define VALA_TYPE_CCODE_COMMENT (vala_ccode_comment_get_type ())
#define VALA_CCODE_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_COMMENT, ValaCCodeComment))
#define VALA_CCODE_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_COMMENT, ValaCCodeCommentClass))
#define VALA_IS_CCODE_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_COMMENT))
#define VALA_IS_CCODE_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_COMMENT))
#define VALA_CCODE_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_COMMENT, ValaCCodeCommentClass))

typedef struct _ValaCCodeComment ValaCCodeComment;
typedef struct _ValaCCodeCommentClass ValaCCodeCommentClass;

#define VALA_TYPE_CCODE_INCLUDE_DIRECTIVE (vala_ccode_include_directive_get_type ())
#define VALA_CCODE_INCLUDE_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_INCLUDE_DIRECTIVE, ValaCCodeIncludeDirective))
#define VALA_CCODE_INCLUDE_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_INCLUDE_DIRECTIVE, ValaCCodeIncludeDirectiveClass))
#define VALA_IS_CCODE_INCLUDE_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_INCLUDE_DIRECTIVE))
#define VALA_IS_CCODE_INCLUDE_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_INCLUDE_DIRECTIVE))
#define VALA_CCODE_INCLUDE_DIRECTIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_INCLUDE_DIRECTIVE, ValaCCodeIncludeDirectiveClass))

typedef struct _ValaCCodeIncludeDirective ValaCCodeIncludeDirective;
typedef struct _ValaCCodeIncludeDirectiveClass ValaCCodeIncludeDirectiveClass;

#define VALA_TYPE_CCODE_FUNCTION (vala_ccode_function_get_type ())
#define VALA_CCODE_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_FUNCTION, ValaCCodeFunction))
#define VALA_CCODE_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_FUNCTION, ValaCCodeFunctionClass))
#define VALA_IS_CCODE_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_FUNCTION))
#define VALA_IS_CCODE_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_FUNCTION))
#define VALA_CCODE_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_FUNCTION, ValaCCodeFunctionClass))

typedef struct _ValaCCodeFunction ValaCCodeFunction;
typedef struct _ValaCCodeFunctionClass ValaCCodeFunctionClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define VALA_TYPE_CCODE_WRITER (vala_ccode_writer_get_type ())
#define VALA_CCODE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_WRITER, ValaCCodeWriter))
#define VALA_CCODE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_WRITER, ValaCCodeWriterClass))
#define VALA_IS_CCODE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_WRITER))
#define VALA_IS_CCODE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_WRITER))
#define VALA_CCODE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_WRITER, ValaCCodeWriterClass))

typedef struct _ValaCCodeWriter ValaCCodeWriter;
typedef struct _ValaCCodeWriterClass ValaCCodeWriterClass;
#define _vala_ccode_writer_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_writer_unref (var), NULL)))

#define VALA_TYPE_CCODE_ONCE_SECTION (vala_ccode_once_section_get_type ())
#define VALA_CCODE_ONCE_SECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ONCE_SECTION, ValaCCodeOnceSection))
#define VALA_CCODE_ONCE_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ONCE_SECTION, ValaCCodeOnceSectionClass))
#define VALA_IS_CCODE_ONCE_SECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ONCE_SECTION))
#define VALA_IS_CCODE_ONCE_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ONCE_SECTION))
#define VALA_CCODE_ONCE_SECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ONCE_SECTION, ValaCCodeOnceSectionClass))

typedef struct _ValaCCodeOnceSection ValaCCodeOnceSection;
typedef struct _ValaCCodeOnceSectionClass ValaCCodeOnceSectionClass;

#define VALA_TYPE_CCODE_NEWLINE (vala_ccode_newline_get_type ())
#define VALA_CCODE_NEWLINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_NEWLINE, ValaCCodeNewline))
#define VALA_CCODE_NEWLINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_NEWLINE, ValaCCodeNewlineClass))
#define VALA_IS_CCODE_NEWLINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_NEWLINE))
#define VALA_IS_CCODE_NEWLINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_NEWLINE))
#define VALA_CCODE_NEWLINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_NEWLINE, ValaCCodeNewlineClass))

typedef struct _ValaCCodeNewline ValaCCodeNewline;
typedef struct _ValaCCodeNewlineClass ValaCCodeNewlineClass;

#define VALA_TYPE_CCODE_EXPRESSION (vala_ccode_expression_get_type ())
#define VALA_CCODE_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_EXPRESSION, ValaCCodeExpression))
#define VALA_CCODE_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_EXPRESSION, ValaCCodeExpressionClass))
#define VALA_IS_CCODE_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_EXPRESSION))
#define VALA_IS_CCODE_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_EXPRESSION))
#define VALA_CCODE_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_EXPRESSION, ValaCCodeExpressionClass))

typedef struct _ValaCCodeExpression ValaCCodeExpression;
typedef struct _ValaCCodeExpressionClass ValaCCodeExpressionClass;

#define VALA_TYPE_CCODE_IDENTIFIER (vala_ccode_identifier_get_type ())
#define VALA_CCODE_IDENTIFIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_IDENTIFIER, ValaCCodeIdentifier))
#define VALA_CCODE_IDENTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_IDENTIFIER, ValaCCodeIdentifierClass))
#define VALA_IS_CCODE_IDENTIFIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_IDENTIFIER))
#define VALA_IS_CCODE_IDENTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_IDENTIFIER))
#define VALA_CCODE_IDENTIFIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_IDENTIFIER, ValaCCodeIdentifierClass))

typedef struct _ValaCCodeIdentifier ValaCCodeIdentifier;
typedef struct _ValaCCodeIdentifierClass ValaCCodeIdentifierClass;
typedef struct _ValaParamSpecCCodeFile ValaParamSpecCCodeFile;

struct _ValaCCodeFile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeFilePrivate * priv;
};

struct _ValaCCodeFileClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeFile *self);
};

struct _ValaCCodeFilePrivate {
	gboolean _is_header;
	ValaSet* declarations;
	ValaSet* includes;
	ValaCCodeFragment* comments;
	ValaCCodeFragment* include_directives;
	ValaCCodeFragment* type_declaration;
	ValaCCodeFragment* type_definition;
	ValaCCodeFragment* type_member_declaration;
	ValaCCodeFragment* constant_declaration;
	ValaCCodeFragment* type_member_definition;
};

struct _ValaParamSpecCCodeFile {
	GParamSpec parent_instance;
};


static gpointer vala_ccode_file_parent_class = NULL;

gpointer vala_ccode_file_ref (gpointer instance);
void vala_ccode_file_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_file (GValue* value, gpointer v_object);
void vala_value_take_ccode_file (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_file (const GValue* value);
GType vala_ccode_file_get_type (void) G_GNUC_CONST;
gpointer vala_ccode_node_ref (gpointer instance);
void vala_ccode_node_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_node (GValue* value, gpointer v_object);
void vala_value_take_ccode_node (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_node (const GValue* value);
GType vala_ccode_node_get_type (void) G_GNUC_CONST;
GType vala_ccode_fragment_get_type (void) G_GNUC_CONST;
#define VALA_CCODE_FILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_FILE, ValaCCodeFilePrivate))
enum  {
	VALA_CCODE_FILE_DUMMY_PROPERTY
};
ValaCCodeFragment* vala_ccode_fragment_new (void);
ValaCCodeFragment* vala_ccode_fragment_construct (GType object_type);
gboolean vala_ccode_file_add_declaration (ValaCCodeFile* self, const gchar* name);
GType vala_ccode_comment_get_type (void) G_GNUC_CONST;
void vala_ccode_file_add_comment (ValaCCodeFile* self, ValaCCodeComment* comment);
void vala_ccode_fragment_append (ValaCCodeFragment* self, ValaCCodeNode* node);
void vala_ccode_file_add_include (ValaCCodeFile* self, const gchar* filename, gboolean local);
ValaCCodeIncludeDirective* vala_ccode_include_directive_new (const gchar* _filename, gboolean _local);
ValaCCodeIncludeDirective* vala_ccode_include_directive_construct (GType object_type, const gchar* _filename, gboolean _local);
GType vala_ccode_include_directive_get_type (void) G_GNUC_CONST;
void vala_ccode_file_add_type_declaration (ValaCCodeFile* self, ValaCCodeNode* node);
void vala_ccode_file_add_type_definition (ValaCCodeFile* self, ValaCCodeNode* node);
void vala_ccode_file_add_type_member_declaration (ValaCCodeFile* self, ValaCCodeNode* node);
void vala_ccode_file_add_constant_declaration (ValaCCodeFile* self, ValaCCodeNode* node);
void vala_ccode_file_add_type_member_definition (ValaCCodeFile* self, ValaCCodeNode* node);
GType vala_ccode_function_get_type (void) G_GNUC_CONST;
void vala_ccode_file_add_function_declaration (ValaCCodeFile* self, ValaCCodeFunction* func);
ValaCCodeFunction* vala_ccode_function_copy (ValaCCodeFunction* self);
void vala_ccode_function_set_is_declaration (ValaCCodeFunction* self, gboolean value);
void vala_ccode_file_add_function (ValaCCodeFile* self, ValaCCodeFunction* func);
ValaList* vala_ccode_file_get_symbols (ValaCCodeFile* self);
ValaList* vala_ccode_fragment_get_children (ValaCCodeFragment* self);
const gchar* vala_ccode_function_get_name (ValaCCodeFunction* self);
static gchar* vala_ccode_file_get_define_for_filename (const gchar* filename);
gboolean vala_ccode_file_store (ValaCCodeFile* self, const gchar* filename, const gchar* source_filename, gboolean write_version, gboolean line_directives, const gchar* begin_decls, const gchar* end_decls);
ValaCCodeWriter* vala_ccode_writer_new (const gchar* filename, const gchar* source_filename);
ValaCCodeWriter* vala_ccode_writer_construct (GType object_type, const gchar* filename, const gchar* source_filename);
gpointer vala_ccode_writer_ref (gpointer instance);
void vala_ccode_writer_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_writer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_writer (GValue* value, gpointer v_object);
void vala_value_take_ccode_writer (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_writer (const GValue* value);
GType vala_ccode_writer_get_type (void) G_GNUC_CONST;
gboolean vala_ccode_writer_open (ValaCCodeWriter* self, gboolean write_version);
gboolean vala_ccode_file_get_is_header (ValaCCodeFile* self);
void vala_ccode_writer_set_line_directives (ValaCCodeWriter* self, gboolean value);
void vala_ccode_node_write (ValaCCodeNode* self, ValaCCodeWriter* writer);
void vala_ccode_writer_write_newline (ValaCCodeWriter* self);
void vala_ccode_node_write_combined (ValaCCodeNode* self, ValaCCodeWriter* writer);
void vala_ccode_node_write_declaration (ValaCCodeNode* self, ValaCCodeWriter* writer);
const gchar* vala_ccode_writer_get_filename (ValaCCodeWriter* self);
ValaCCodeOnceSection* vala_ccode_once_section_new (const gchar* def);
ValaCCodeOnceSection* vala_ccode_once_section_construct (GType object_type, const gchar* def);
GType vala_ccode_once_section_get_type (void) G_GNUC_CONST;
ValaCCodeNewline* vala_ccode_newline_new (void);
ValaCCodeNewline* vala_ccode_newline_construct (GType object_type);
GType vala_ccode_newline_get_type (void) G_GNUC_CONST;
ValaCCodeIdentifier* vala_ccode_identifier_new (const gchar* _name);
ValaCCodeIdentifier* vala_ccode_identifier_construct (GType object_type, const gchar* _name);
GType vala_ccode_expression_get_type (void) G_GNUC_CONST;
GType vala_ccode_identifier_get_type (void) G_GNUC_CONST;
void vala_ccode_writer_close (ValaCCodeWriter* self);
ValaCCodeFile* vala_ccode_file_new (void);
ValaCCodeFile* vala_ccode_file_construct (GType object_type);
void vala_ccode_file_set_is_header (ValaCCodeFile* self, gboolean value);
static void vala_ccode_file_finalize (ValaCCodeFile* obj);


gboolean vala_ccode_file_add_declaration (ValaCCodeFile* self, const gchar* name) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = vala_collection_contains ((ValaCollection*) self->priv->declarations, name);
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	vala_collection_add ((ValaCollection*) self->priv->declarations, name);
	result = FALSE;
	return result;
}


void vala_ccode_file_add_comment (ValaCCodeFile* self, ValaCCodeComment* comment) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment != NULL);
	vala_ccode_fragment_append (self->priv->comments, (ValaCCodeNode*) comment);
}


void vala_ccode_file_add_include (ValaCCodeFile* self, const gchar* filename, gboolean local) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_tmp0_ = vala_collection_contains ((ValaCollection*) self->priv->includes, filename);
	if (!_tmp0_) {
		ValaCCodeIncludeDirective* _tmp1_ = NULL;
		ValaCCodeIncludeDirective* _tmp2_;
		_tmp1_ = vala_ccode_include_directive_new (filename, local);
		_tmp2_ = _tmp1_;
		vala_ccode_fragment_append (self->priv->include_directives, (ValaCCodeNode*) _tmp2_);
		_vala_ccode_node_unref0 (_tmp2_);
		vala_collection_add ((ValaCollection*) self->priv->includes, filename);
	}
}


void vala_ccode_file_add_type_declaration (ValaCCodeFile* self, ValaCCodeNode* node) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	vala_ccode_fragment_append (self->priv->type_declaration, node);
}


void vala_ccode_file_add_type_definition (ValaCCodeFile* self, ValaCCodeNode* node) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	vala_ccode_fragment_append (self->priv->type_definition, node);
}


void vala_ccode_file_add_type_member_declaration (ValaCCodeFile* self, ValaCCodeNode* node) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	vala_ccode_fragment_append (self->priv->type_member_declaration, node);
}


void vala_ccode_file_add_constant_declaration (ValaCCodeFile* self, ValaCCodeNode* node) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	vala_ccode_fragment_append (self->priv->constant_declaration, node);
}


void vala_ccode_file_add_type_member_definition (ValaCCodeFile* self, ValaCCodeNode* node) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	vala_ccode_fragment_append (self->priv->type_member_definition, node);
}


void vala_ccode_file_add_function_declaration (ValaCCodeFile* self, ValaCCodeFunction* func) {
	ValaCCodeFunction* _tmp0_ = NULL;
	ValaCCodeFunction* decl;
	g_return_if_fail (self != NULL);
	g_return_if_fail (func != NULL);
	_tmp0_ = vala_ccode_function_copy (func);
	decl = _tmp0_;
	vala_ccode_function_set_is_declaration (decl, TRUE);
	vala_ccode_fragment_append (self->priv->type_member_declaration, (ValaCCodeNode*) decl);
	_vala_ccode_node_unref0 (decl);
}


void vala_ccode_file_add_function (ValaCCodeFile* self, ValaCCodeFunction* func) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (func != NULL);
	vala_ccode_fragment_append (self->priv->type_member_definition, (ValaCCodeNode*) func);
}


static gpointer _vala_ccode_node_ref0 (gpointer self) {
	return self ? vala_ccode_node_ref (self) : NULL;
}


ValaList* vala_ccode_file_get_symbols (ValaCCodeFile* self) {
	ValaList* result = NULL;
	ValaArrayList* _tmp0_ = NULL;
	ValaArrayList* symbols;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	symbols = _tmp0_;
	{
		ValaList* _tmp1_ = NULL;
		ValaList* _node_list;
		gint _tmp2_;
		gint _node_size;
		gint _node_index;
		_tmp1_ = vala_ccode_fragment_get_children (self->priv->type_member_declaration);
		_node_list = _tmp1_;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _node_list);
		_node_size = _tmp2_;
		_node_index = -1;
		while (TRUE) {
			gpointer _tmp3_ = NULL;
			ValaCCodeNode* node;
			ValaCCodeNode* _tmp4_;
			ValaCCodeFunction* _tmp5_;
			ValaCCodeFunction* func;
			_node_index = _node_index + 1;
			if (!(_node_index < _node_size)) {
				break;
			}
			_tmp3_ = vala_list_get (_node_list, _node_index);
			node = (ValaCCodeNode*) _tmp3_;
			_tmp5_ = _vala_ccode_node_ref0 ((_tmp4_ = node, VALA_IS_CCODE_FUNCTION (_tmp4_) ? ((ValaCCodeFunction*) _tmp4_) : NULL));
			func = _tmp5_;
			if (func != NULL) {
				const gchar* _tmp6_ = NULL;
				_tmp6_ = vala_ccode_function_get_name (func);
				vala_collection_add ((ValaCollection*) symbols, _tmp6_);
			}
			_vala_ccode_node_unref0 (func);
			_vala_ccode_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
	result = (ValaList*) symbols;
	return result;
}


static gunichar string_get_char (const gchar* self, gint index) {
	gunichar result = 0U;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = g_utf8_get_char (((gchar*) self) + index);
	result = _tmp0_;
	return result;
}


static gchar* vala_ccode_file_get_define_for_filename (const gchar* filename) {
	gchar* result = NULL;
	GString* _tmp0_ = NULL;
	GString* define;
	gchar* _tmp1_;
	gchar* i;
	gchar* _tmp10_;
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = g_string_new ("__");
	define = _tmp0_;
	_tmp1_ = g_strdup (filename);
	i = _tmp1_;
	while (TRUE) {
		glong _tmp2_;
		gunichar _tmp3_;
		gunichar c;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp2_ = strlen (i);
		if (!(_tmp2_ > 0)) {
			break;
		}
		_tmp3_ = string_get_char (i, 0);
		c = _tmp3_;
		_tmp5_ = g_unichar_isalnum (c);
		if (_tmp5_) {
			_tmp4_ = c < 0x80;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			gunichar _tmp6_;
			_tmp6_ = g_unichar_toupper (c);
			g_string_append_unichar (define, _tmp6_);
		} else {
			g_string_append_c (define, '_');
		}
		_tmp7_ = g_utf8_next_char (i);
		_tmp8_ = g_strdup (_tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (i);
		i = _tmp9_;
	}
	g_string_append (define, "__");
	_tmp10_ = g_strdup (define->str);
	result = _tmp10_;
	_g_free0 (i);
	_g_string_free0 (define);
	return result;
}


gboolean vala_ccode_file_store (ValaCCodeFile* self, const gchar* filename, const gchar* source_filename, gboolean write_version, gboolean line_directives, const gchar* begin_decls, const gchar* end_decls) {
	gboolean result = FALSE;
	ValaCCodeWriter* _tmp0_ = NULL;
	ValaCCodeWriter* writer;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = vala_ccode_writer_new (filename, source_filename);
	writer = _tmp0_;
	_tmp1_ = vala_ccode_writer_open (writer, write_version);
	if (!_tmp1_) {
		result = FALSE;
		_vala_ccode_writer_unref0 (writer);
		return result;
	}
	if (!self->priv->_is_header) {
		vala_ccode_writer_set_line_directives (writer, line_directives);
		vala_ccode_node_write ((ValaCCodeNode*) self->priv->comments, writer);
		vala_ccode_writer_write_newline (writer);
		vala_ccode_node_write ((ValaCCodeNode*) self->priv->include_directives, writer);
		vala_ccode_writer_write_newline (writer);
		vala_ccode_node_write_combined ((ValaCCodeNode*) self->priv->type_declaration, writer);
		vala_ccode_writer_write_newline (writer);
		vala_ccode_node_write_combined ((ValaCCodeNode*) self->priv->type_definition, writer);
		vala_ccode_writer_write_newline (writer);
		vala_ccode_node_write_declaration ((ValaCCodeNode*) self->priv->type_member_declaration, writer);
		vala_ccode_writer_write_newline (writer);
		vala_ccode_node_write ((ValaCCodeNode*) self->priv->type_member_declaration, writer);
		vala_ccode_writer_write_newline (writer);
		vala_ccode_node_write_combined ((ValaCCodeNode*) self->priv->constant_declaration, writer);
		vala_ccode_writer_write_newline (writer);
		vala_ccode_node_write ((ValaCCodeNode*) self->priv->type_member_definition, writer);
		vala_ccode_writer_write_newline (writer);
	} else {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		ValaCCodeOnceSection* _tmp5_ = NULL;
		ValaCCodeOnceSection* _tmp6_;
		ValaCCodeOnceSection* once;
		ValaCCodeNewline* _tmp7_ = NULL;
		ValaCCodeNewline* _tmp8_;
		ValaCCodeNewline* _tmp9_ = NULL;
		ValaCCodeNewline* _tmp10_;
		ValaCCodeNewline* _tmp15_ = NULL;
		ValaCCodeNewline* _tmp16_;
		ValaCCodeNewline* _tmp17_ = NULL;
		ValaCCodeNewline* _tmp18_;
		ValaCCodeNewline* _tmp19_ = NULL;
		ValaCCodeNewline* _tmp20_;
		ValaCCodeNewline* _tmp21_ = NULL;
		ValaCCodeNewline* _tmp22_;
		ValaCCodeNewline* _tmp23_ = NULL;
		ValaCCodeNewline* _tmp24_;
		ValaCCodeNewline* _tmp29_ = NULL;
		ValaCCodeNewline* _tmp30_;
		vala_ccode_writer_write_newline (writer);
		_tmp2_ = vala_ccode_writer_get_filename (writer);
		_tmp3_ = vala_ccode_file_get_define_for_filename (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_ccode_once_section_new (_tmp4_);
		once = (_tmp6_ = _tmp5_, _g_free0 (_tmp4_), _tmp6_);
		_tmp7_ = vala_ccode_newline_new ();
		_tmp8_ = _tmp7_;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) _tmp8_);
		_vala_ccode_node_unref0 (_tmp8_);
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) self->priv->include_directives);
		_tmp9_ = vala_ccode_newline_new ();
		_tmp10_ = _tmp9_;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) _tmp10_);
		_vala_ccode_node_unref0 (_tmp10_);
		if (begin_decls != NULL) {
			ValaCCodeIdentifier* _tmp11_ = NULL;
			ValaCCodeIdentifier* _tmp12_;
			ValaCCodeNewline* _tmp13_ = NULL;
			ValaCCodeNewline* _tmp14_;
			_tmp11_ = vala_ccode_identifier_new (begin_decls);
			_tmp12_ = _tmp11_;
			vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) _tmp12_);
			_vala_ccode_node_unref0 (_tmp12_);
			_tmp13_ = vala_ccode_newline_new ();
			_tmp14_ = _tmp13_;
			vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) _tmp14_);
			_vala_ccode_node_unref0 (_tmp14_);
		}
		_tmp15_ = vala_ccode_newline_new ();
		_tmp16_ = _tmp15_;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) _tmp16_);
		_vala_ccode_node_unref0 (_tmp16_);
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) self->priv->type_declaration);
		_tmp17_ = vala_ccode_newline_new ();
		_tmp18_ = _tmp17_;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) _tmp18_);
		_vala_ccode_node_unref0 (_tmp18_);
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) self->priv->type_definition);
		_tmp19_ = vala_ccode_newline_new ();
		_tmp20_ = _tmp19_;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) _tmp20_);
		_vala_ccode_node_unref0 (_tmp20_);
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) self->priv->type_member_declaration);
		_tmp21_ = vala_ccode_newline_new ();
		_tmp22_ = _tmp21_;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) _tmp22_);
		_vala_ccode_node_unref0 (_tmp22_);
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) self->priv->constant_declaration);
		_tmp23_ = vala_ccode_newline_new ();
		_tmp24_ = _tmp23_;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) _tmp24_);
		_vala_ccode_node_unref0 (_tmp24_);
		if (begin_decls != NULL) {
			ValaCCodeIdentifier* _tmp25_ = NULL;
			ValaCCodeIdentifier* _tmp26_;
			ValaCCodeNewline* _tmp27_ = NULL;
			ValaCCodeNewline* _tmp28_;
			_tmp25_ = vala_ccode_identifier_new (end_decls);
			_tmp26_ = _tmp25_;
			vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) _tmp26_);
			_vala_ccode_node_unref0 (_tmp26_);
			_tmp27_ = vala_ccode_newline_new ();
			_tmp28_ = _tmp27_;
			vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) _tmp28_);
			_vala_ccode_node_unref0 (_tmp28_);
		}
		_tmp29_ = vala_ccode_newline_new ();
		_tmp30_ = _tmp29_;
		vala_ccode_fragment_append ((ValaCCodeFragment*) once, (ValaCCodeNode*) _tmp30_);
		_vala_ccode_node_unref0 (_tmp30_);
		vala_ccode_node_write ((ValaCCodeNode*) once, writer);
		_vala_ccode_node_unref0 (once);
	}
	vala_ccode_writer_close (writer);
	result = TRUE;
	_vala_ccode_writer_unref0 (writer);
	return result;
}


ValaCCodeFile* vala_ccode_file_construct (GType object_type) {
	ValaCCodeFile* self = NULL;
	self = (ValaCCodeFile*) g_type_create_instance (object_type);
	return self;
}


ValaCCodeFile* vala_ccode_file_new (void) {
	return vala_ccode_file_construct (VALA_TYPE_CCODE_FILE);
}


gboolean vala_ccode_file_get_is_header (ValaCCodeFile* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_header;
	return result;
}


void vala_ccode_file_set_is_header (ValaCCodeFile* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_header = value;
}


static void vala_value_ccode_file_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_ccode_file_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_ccode_file_unref (value->data[0].v_pointer);
	}
}


static void vala_value_ccode_file_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_ccode_file_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_ccode_file_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_ccode_file_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCCodeFile* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_ccode_file_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_ccode_file_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCCodeFile** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_ccode_file_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_ccode_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCCodeFile* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_CCODE_FILE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_ccode_file (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_FILE), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_ccode_file (GValue* value, gpointer v_object) {
	ValaCCodeFile* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_ccode_file_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_file_unref (old);
	}
}


void vala_value_take_ccode_file (GValue* value, gpointer v_object) {
	ValaCCodeFile* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CCODE_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CCODE_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_ccode_file_unref (old);
	}
}


static void vala_ccode_file_class_init (ValaCCodeFileClass * klass) {
	vala_ccode_file_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_FILE_CLASS (klass)->finalize = vala_ccode_file_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeFilePrivate));
}


static void vala_ccode_file_instance_init (ValaCCodeFile * self) {
	ValaHashSet* _tmp0_ = NULL;
	ValaHashSet* _tmp1_ = NULL;
	ValaCCodeFragment* _tmp2_ = NULL;
	ValaCCodeFragment* _tmp3_ = NULL;
	ValaCCodeFragment* _tmp4_ = NULL;
	ValaCCodeFragment* _tmp5_ = NULL;
	ValaCCodeFragment* _tmp6_ = NULL;
	ValaCCodeFragment* _tmp7_ = NULL;
	ValaCCodeFragment* _tmp8_ = NULL;
	self->priv = VALA_CCODE_FILE_GET_PRIVATE (self);
	_tmp0_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	self->priv->declarations = (ValaSet*) _tmp0_;
	_tmp1_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	self->priv->includes = (ValaSet*) _tmp1_;
	_tmp2_ = vala_ccode_fragment_new ();
	self->priv->comments = _tmp2_;
	_tmp3_ = vala_ccode_fragment_new ();
	self->priv->include_directives = _tmp3_;
	_tmp4_ = vala_ccode_fragment_new ();
	self->priv->type_declaration = _tmp4_;
	_tmp5_ = vala_ccode_fragment_new ();
	self->priv->type_definition = _tmp5_;
	_tmp6_ = vala_ccode_fragment_new ();
	self->priv->type_member_declaration = _tmp6_;
	_tmp7_ = vala_ccode_fragment_new ();
	self->priv->constant_declaration = _tmp7_;
	_tmp8_ = vala_ccode_fragment_new ();
	self->priv->type_member_definition = _tmp8_;
	self->ref_count = 1;
}


static void vala_ccode_file_finalize (ValaCCodeFile* obj) {
	ValaCCodeFile * self;
	self = VALA_CCODE_FILE (obj);
	_vala_iterable_unref0 (self->priv->declarations);
	_vala_iterable_unref0 (self->priv->includes);
	_vala_ccode_node_unref0 (self->priv->comments);
	_vala_ccode_node_unref0 (self->priv->include_directives);
	_vala_ccode_node_unref0 (self->priv->type_declaration);
	_vala_ccode_node_unref0 (self->priv->type_definition);
	_vala_ccode_node_unref0 (self->priv->type_member_declaration);
	_vala_ccode_node_unref0 (self->priv->constant_declaration);
	_vala_ccode_node_unref0 (self->priv->type_member_definition);
}


GType vala_ccode_file_get_type (void) {
	static volatile gsize vala_ccode_file_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_file_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_ccode_file_init, vala_value_ccode_file_free_value, vala_value_ccode_file_copy_value, vala_value_ccode_file_peek_pointer, "p", vala_value_ccode_file_collect_value, "p", vala_value_ccode_file_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeFile), 0, (GInstanceInitFunc) vala_ccode_file_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_ccode_file_type_id;
		vala_ccode_file_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCCodeFile", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_ccode_file_type_id__volatile, vala_ccode_file_type_id);
	}
	return vala_ccode_file_type_id__volatile;
}


gpointer vala_ccode_file_ref (gpointer instance) {
	ValaCCodeFile* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_ccode_file_unref (gpointer instance) {
	ValaCCodeFile* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_CCODE_FILE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



