/* valagdbusmodule.c generated by valac, the Vala compiler
 * generated from valagdbusmodule.vala, do not modify */

/* valagdbusmodule.vala
 *
 * Copyright (C) 2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>


#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT (vala_ccode_base_module_emit_context_get_type ())
#define VALA_CCODE_BASE_MODULE_EMIT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT, ValaCCodeBaseModuleEmitContext))
#define VALA_CCODE_BASE_MODULE_EMIT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT, ValaCCodeBaseModuleEmitContextClass))
#define VALA_CCODE_BASE_MODULE_IS_EMIT_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT))
#define VALA_CCODE_BASE_MODULE_IS_EMIT_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT))
#define VALA_CCODE_BASE_MODULE_EMIT_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_CCODE_BASE_MODULE_TYPE_EMIT_CONTEXT, ValaCCodeBaseModuleEmitContextClass))

typedef struct _ValaCCodeBaseModuleEmitContext ValaCCodeBaseModuleEmitContext;
typedef struct _ValaCCodeBaseModuleEmitContextClass ValaCCodeBaseModuleEmitContextClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE (vala_ccode_member_access_module_get_type ())
#define VALA_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModule))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))

typedef struct _ValaCCodeMemberAccessModule ValaCCodeMemberAccessModule;
typedef struct _ValaCCodeMemberAccessModuleClass ValaCCodeMemberAccessModuleClass;
typedef struct _ValaCCodeMemberAccessModulePrivate ValaCCodeMemberAccessModulePrivate;

#define VALA_TYPE_CCODE_ASSIGNMENT_MODULE (vala_ccode_assignment_module_get_type ())
#define VALA_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModule))
#define VALA_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_CCODE_ASSIGNMENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))

typedef struct _ValaCCodeAssignmentModule ValaCCodeAssignmentModule;
typedef struct _ValaCCodeAssignmentModuleClass ValaCCodeAssignmentModuleClass;
typedef struct _ValaCCodeAssignmentModulePrivate ValaCCodeAssignmentModulePrivate;

#define VALA_TYPE_CCODE_METHOD_CALL_MODULE (vala_ccode_method_call_module_get_type ())
#define VALA_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule))
#define VALA_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))
#define VALA_IS_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_IS_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_CCODE_METHOD_CALL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))

typedef struct _ValaCCodeMethodCallModule ValaCCodeMethodCallModule;
typedef struct _ValaCCodeMethodCallModuleClass ValaCCodeMethodCallModuleClass;
typedef struct _ValaCCodeMethodCallModulePrivate ValaCCodeMethodCallModulePrivate;

#define VALA_TYPE_CCODE_ARRAY_MODULE (vala_ccode_array_module_get_type ())
#define VALA_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModule))
#define VALA_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))
#define VALA_IS_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_IS_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_CCODE_ARRAY_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))

typedef struct _ValaCCodeArrayModule ValaCCodeArrayModule;
typedef struct _ValaCCodeArrayModuleClass ValaCCodeArrayModuleClass;
typedef struct _ValaCCodeArrayModulePrivate ValaCCodeArrayModulePrivate;

#define VALA_TYPE_CCODE_DELEGATE_MODULE (vala_ccode_delegate_module_get_type ())
#define VALA_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModule))
#define VALA_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))
#define VALA_IS_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_IS_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_CCODE_DELEGATE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))

typedef struct _ValaCCodeDelegateModule ValaCCodeDelegateModule;
typedef struct _ValaCCodeDelegateModuleClass ValaCCodeDelegateModuleClass;
typedef struct _ValaCCodeDelegateModulePrivate ValaCCodeDelegateModulePrivate;

#define VALA_TYPE_GERROR_MODULE (vala_gerror_module_get_type ())
#define VALA_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModule))
#define VALA_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))
#define VALA_IS_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GERROR_MODULE))
#define VALA_IS_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GERROR_MODULE))
#define VALA_GERROR_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))

typedef struct _ValaGErrorModule ValaGErrorModule;
typedef struct _ValaGErrorModuleClass ValaGErrorModuleClass;
typedef struct _ValaGErrorModulePrivate ValaGErrorModulePrivate;

#define VALA_TYPE_GTYPE_MODULE (vala_gtype_module_get_type ())
#define VALA_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModule))
#define VALA_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))
#define VALA_IS_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GTYPE_MODULE))
#define VALA_IS_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GTYPE_MODULE))
#define VALA_GTYPE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))

typedef struct _ValaGTypeModule ValaGTypeModule;
typedef struct _ValaGTypeModuleClass ValaGTypeModuleClass;
typedef struct _ValaGTypeModulePrivate ValaGTypeModulePrivate;

#define VALA_TYPE_TYPEREGISTER_FUNCTION (vala_typeregister_function_get_type ())
#define VALA_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunction))
#define VALA_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))
#define VALA_IS_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_IS_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_TYPEREGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))

typedef struct _ValaTypeRegisterFunction ValaTypeRegisterFunction;
typedef struct _ValaTypeRegisterFunctionClass ValaTypeRegisterFunctionClass;

#define VALA_TYPE_GOBJECT_MODULE (vala_gobject_module_get_type ())
#define VALA_GOBJECT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule))
#define VALA_GOBJECT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModuleClass))
#define VALA_IS_GOBJECT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GOBJECT_MODULE))
#define VALA_IS_GOBJECT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GOBJECT_MODULE))
#define VALA_GOBJECT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModuleClass))

typedef struct _ValaGObjectModule ValaGObjectModule;
typedef struct _ValaGObjectModuleClass ValaGObjectModuleClass;
typedef struct _ValaGObjectModulePrivate ValaGObjectModulePrivate;

#define VALA_TYPE_GSIGNAL_MODULE (vala_gsignal_module_get_type ())
#define VALA_GSIGNAL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModule))
#define VALA_GSIGNAL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModuleClass))
#define VALA_IS_GSIGNAL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GSIGNAL_MODULE))
#define VALA_IS_GSIGNAL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GSIGNAL_MODULE))
#define VALA_GSIGNAL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModuleClass))

typedef struct _ValaGSignalModule ValaGSignalModule;
typedef struct _ValaGSignalModuleClass ValaGSignalModuleClass;
typedef struct _ValaGSignalModulePrivate ValaGSignalModulePrivate;

#define VALA_TYPE_GASYNC_MODULE (vala_gasync_module_get_type ())
#define VALA_GASYNC_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GASYNC_MODULE, ValaGAsyncModule))
#define VALA_GASYNC_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GASYNC_MODULE, ValaGAsyncModuleClass))
#define VALA_IS_GASYNC_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GASYNC_MODULE))
#define VALA_IS_GASYNC_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GASYNC_MODULE))
#define VALA_GASYNC_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GASYNC_MODULE, ValaGAsyncModuleClass))

typedef struct _ValaGAsyncModule ValaGAsyncModule;
typedef struct _ValaGAsyncModuleClass ValaGAsyncModuleClass;
typedef struct _ValaGAsyncModulePrivate ValaGAsyncModulePrivate;

#define VALA_TYPE_GVARIANT_MODULE (vala_gvariant_module_get_type ())
#define VALA_GVARIANT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GVARIANT_MODULE, ValaGVariantModule))
#define VALA_GVARIANT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GVARIANT_MODULE, ValaGVariantModuleClass))
#define VALA_IS_GVARIANT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GVARIANT_MODULE))
#define VALA_IS_GVARIANT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GVARIANT_MODULE))
#define VALA_GVARIANT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GVARIANT_MODULE, ValaGVariantModuleClass))

typedef struct _ValaGVariantModule ValaGVariantModule;
typedef struct _ValaGVariantModuleClass ValaGVariantModuleClass;
typedef struct _ValaGVariantModulePrivate ValaGVariantModulePrivate;

#define VALA_TYPE_GD_BUS_MODULE (vala_gd_bus_module_get_type ())
#define VALA_GD_BUS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GD_BUS_MODULE, ValaGDBusModule))
#define VALA_GD_BUS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GD_BUS_MODULE, ValaGDBusModuleClass))
#define VALA_IS_GD_BUS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GD_BUS_MODULE))
#define VALA_IS_GD_BUS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GD_BUS_MODULE))
#define VALA_GD_BUS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GD_BUS_MODULE, ValaGDBusModuleClass))

typedef struct _ValaGDBusModule ValaGDBusModule;
typedef struct _ValaGDBusModuleClass ValaGDBusModuleClass;
typedef struct _ValaGDBusModulePrivate ValaGDBusModulePrivate;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaCCodeBaseModule {
	ValaCodeGenerator parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaCCodeBaseModuleEmitContext* emit_context;
	ValaCCodeFile* header_file;
	ValaCCodeFile* internal_header_file;
	ValaCCodeFile* cfile;
	ValaCCodeBaseModuleEmitContext* class_init_context;
	ValaCCodeBaseModuleEmitContext* base_init_context;
	ValaCCodeBaseModuleEmitContext* class_finalize_context;
	ValaCCodeBaseModuleEmitContext* base_finalize_context;
	ValaCCodeBaseModuleEmitContext* instance_init_context;
	ValaCCodeBaseModuleEmitContext* instance_finalize_context;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaSet* user_marshal_set;
	ValaSet* predefined_marshal_set;
	gint next_regex_id;
	gboolean in_constructor;
	gboolean in_static_or_class_context;
	gint next_coroutine_state;
	ValaDataType* void_type;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* regex_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaClass* gnode_type;
	ValaClass* gvaluearray_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaTypeSymbol* gthreadpool_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaClass* gvariant_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_proxy_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	gchar* module_init_param_name;
	gboolean gvaluecollector_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	ValaSet* wrappers;
};

struct _ValaCCodeBaseModuleClass {
	ValaCodeGeneratorClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	gboolean (*generate_enum_declaration) (ValaCCodeBaseModule* self, ValaEnum* en, ValaCCodeFile* decl_space);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeFile* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeFile* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeFile* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeFile* decl_space, ValaMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, ValaMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup);
	gchar* (*append_struct_array_free) (ValaCCodeBaseModule* self, ValaStruct* st);
	ValaCCodeExpression* (*destroy_value) (ValaCCodeBaseModule* self, ValaTargetValue* value, gboolean is_macro_definition);
	void (*append_local_free) (ValaCCodeBaseModule* self, ValaSymbol* sym, gboolean stop_at_loop);
	gchar* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const gchar* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr, ValaCCodeExpression** delegate_target_destroy_notify);
	ValaCCodeExpression* (*get_delegate_target_cvalue) (ValaCCodeBaseModule* self, ValaTargetValue* value);
	ValaCCodeExpression* (*get_delegate_target_destroy_notify_cvalue) (ValaCCodeBaseModule* self, ValaTargetValue* value);
	gchar* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const gchar* delegate_cname);
	ValaCCodeExpression* (*get_ref_cexpression) (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeFile* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeFile* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeFile* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeFile* decl_space);
	ValaCCodeExpression* (*deserialize_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaCCodeExpression* variant_expr, ValaCCodeExpression* expr);
	ValaCCodeExpression* (*serialize_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaCCodeExpression* expr);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
	gboolean (*is_gobject_property) (ValaCCodeBaseModule* self, ValaProperty* prop);
	gchar* (*get_custom_creturn_type) (ValaCCodeBaseModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeBaseModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeBaseModule* self, ValaMethod* method);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeBaseModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeBaseModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	void (*register_dbus_info) (ValaCCodeBaseModule* self, ValaObjectTypeSymbol* bindable);
	gchar* (*get_dynamic_property_getter_cname) (ValaCCodeBaseModule* self, ValaDynamicProperty* node);
	gchar* (*get_dynamic_property_setter_cname) (ValaCCodeBaseModule* self, ValaDynamicProperty* node);
	gchar* (*get_dynamic_signal_cname) (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
	gchar* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
	gchar* (*get_dynamic_signal_connect_after_wrapper_name) (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
	gchar* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeBaseModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeBaseModule* self, ValaList* params, ValaDataType* return_type, gboolean dbus);
	gchar* (*get_marshaller_function) (ValaCCodeBaseModule* self, ValaList* params, ValaDataType* return_type, const gchar* prefix, gboolean dbus);
	gchar* (*get_array_length_cname) (ValaCCodeBaseModule* self, const gchar* array_cname, gint dim);
	gchar* (*get_parameter_array_length_cname) (ValaCCodeBaseModule* self, ValaParameter* param, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeBaseModule* self, ValaExpression* array_expr, gint dim);
	ValaCCodeExpression* (*get_array_length_cvalue) (ValaCCodeBaseModule* self, ValaTargetValue* value, gint dim);
	gchar* (*get_array_size_cname) (ValaCCodeBaseModule* self, const gchar* array_cname);
	void (*add_simple_check) (ValaCCodeBaseModule* self, ValaCodeNode* node, gboolean always_fails);
	gchar* (*generate_ready_function) (ValaCCodeBaseModule* self, ValaMethod* m);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeFile* decl_space, ValaCCodeFunction* cfunc, ValaMap* cparam_map, ValaMap* carg_map);
	ValaCCodeParameter* (*generate_parameter) (ValaCCodeMethodModule* self, ValaParameter* param, ValaCCodeFile* decl_space, ValaMap* cparam_map, ValaMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};

struct _ValaCCodeMemberAccessModule {
	ValaCCodeControlFlowModule parent_instance;
	ValaCCodeMemberAccessModulePrivate * priv;
};

struct _ValaCCodeMemberAccessModuleClass {
	ValaCCodeControlFlowModuleClass parent_class;
};

struct _ValaCCodeAssignmentModule {
	ValaCCodeMemberAccessModule parent_instance;
	ValaCCodeAssignmentModulePrivate * priv;
};

struct _ValaCCodeAssignmentModuleClass {
	ValaCCodeMemberAccessModuleClass parent_class;
};

struct _ValaCCodeMethodCallModule {
	ValaCCodeAssignmentModule parent_instance;
	ValaCCodeMethodCallModulePrivate * priv;
};

struct _ValaCCodeMethodCallModuleClass {
	ValaCCodeAssignmentModuleClass parent_class;
};

struct _ValaCCodeArrayModule {
	ValaCCodeMethodCallModule parent_instance;
	ValaCCodeArrayModulePrivate * priv;
};

struct _ValaCCodeArrayModuleClass {
	ValaCCodeMethodCallModuleClass parent_class;
};

struct _ValaCCodeDelegateModule {
	ValaCCodeArrayModule parent_instance;
	ValaCCodeDelegateModulePrivate * priv;
};

struct _ValaCCodeDelegateModuleClass {
	ValaCCodeArrayModuleClass parent_class;
};

struct _ValaGErrorModule {
	ValaCCodeDelegateModule parent_instance;
	ValaGErrorModulePrivate * priv;
};

struct _ValaGErrorModuleClass {
	ValaCCodeDelegateModuleClass parent_class;
	void (*return_with_exception) (ValaGErrorModule* self, ValaCCodeExpression* error_expr);
};

struct _ValaGTypeModule {
	ValaGErrorModule parent_instance;
	ValaGTypeModulePrivate * priv;
};

struct _ValaGTypeModuleClass {
	ValaGErrorModuleClass parent_class;
	void (*generate_virtual_method_declaration) (ValaGTypeModule* self, ValaMethod* m, ValaCCodeFile* decl_space, ValaCCodeStruct* type_struct);
	void (*generate_class_init) (ValaGTypeModule* self, ValaClass* cl);
	ValaTypeRegisterFunction* (*create_interface_register_function) (ValaGTypeModule* self, ValaInterface* iface);
};

struct _ValaGObjectModule {
	ValaGTypeModule parent_instance;
	ValaGObjectModulePrivate * priv;
};

struct _ValaGObjectModuleClass {
	ValaGTypeModuleClass parent_class;
};

struct _ValaGSignalModule {
	ValaGObjectModule parent_instance;
	ValaGSignalModulePrivate * priv;
};

struct _ValaGSignalModuleClass {
	ValaGObjectModuleClass parent_class;
	ValaCCodeExpression* (*get_dbus_g_type) (ValaGSignalModule* self, ValaDataType* data_type);
};

struct _ValaGAsyncModule {
	ValaGSignalModule parent_instance;
	ValaGAsyncModulePrivate * priv;
};

struct _ValaGAsyncModuleClass {
	ValaGSignalModuleClass parent_class;
};

struct _ValaGVariantModule {
	ValaGAsyncModule parent_instance;
	ValaGVariantModulePrivate * priv;
};

struct _ValaGVariantModuleClass {
	ValaGAsyncModuleClass parent_class;
};

struct _ValaGDBusModule {
	ValaGVariantModule parent_instance;
	ValaGDBusModulePrivate * priv;
};

struct _ValaGDBusModuleClass {
	ValaGVariantModuleClass parent_class;
};


static gpointer vala_gd_bus_module_parent_class = NULL;

GType vala_ccode_base_module_get_type (void) G_GNUC_CONST;
gpointer vala_ccode_base_module_emit_context_ref (gpointer instance);
void vala_ccode_base_module_emit_context_unref (gpointer instance);
GParamSpec* vala_ccode_base_module_param_spec_emit_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_ccode_base_module_value_set_emit_context (GValue* value, gpointer v_object);
void vala_ccode_base_module_value_take_emit_context (GValue* value, gpointer v_object);
gpointer vala_ccode_base_module_value_get_emit_context (const GValue* value);
GType vala_ccode_base_module_emit_context_get_type (void) G_GNUC_CONST;
GType vala_ccode_struct_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_method_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_control_flow_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_member_access_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_assignment_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_method_call_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_array_module_get_type (void) G_GNUC_CONST;
GType vala_ccode_delegate_module_get_type (void) G_GNUC_CONST;
GType vala_gerror_module_get_type (void) G_GNUC_CONST;
GType vala_gtype_module_get_type (void) G_GNUC_CONST;
gpointer vala_typeregister_function_ref (gpointer instance);
void vala_typeregister_function_unref (gpointer instance);
GParamSpec* vala_param_spec_typeregister_function (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_typeregister_function (GValue* value, gpointer v_object);
void vala_value_take_typeregister_function (GValue* value, gpointer v_object);
gpointer vala_value_get_typeregister_function (const GValue* value);
GType vala_typeregister_function_get_type (void) G_GNUC_CONST;
GType vala_gobject_module_get_type (void) G_GNUC_CONST;
GType vala_gsignal_module_get_type (void) G_GNUC_CONST;
GType vala_gasync_module_get_type (void) G_GNUC_CONST;
GType vala_gvariant_module_get_type (void) G_GNUC_CONST;
GType vala_gd_bus_module_get_type (void) G_GNUC_CONST;
enum  {
	VALA_GD_BUS_MODULE_DUMMY_PROPERTY
};
gchar* vala_gd_bus_module_get_dbus_name (ValaTypeSymbol* symbol);
gchar* vala_gd_bus_module_get_dbus_name_for_member (ValaSymbol* symbol);
gboolean vala_gd_bus_module_is_dbus_no_reply (ValaMethod* m);
static void vala_gd_bus_module_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain);
void vala_ccode_base_module_generate_error_domain_declaration (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeFile* decl_space);
static gboolean vala_gd_bus_module_is_file_descriptor (ValaGDBusModule* self, ValaDataType* type);
gboolean vala_gd_bus_module_dbus_method_uses_file_descriptor (ValaGDBusModule* self, ValaMethod* method);
static ValaCCodeExpression* vala_gd_bus_module_get_file_descriptor (ValaGDBusModule* self, ValaDataType* type, ValaCCodeExpression* expr);
void vala_gd_bus_module_send_dbus_value (ValaGDBusModule* self, ValaDataType* type, ValaCCodeExpression* builder_expr, ValaCCodeExpression* expr, ValaSymbol* sym);
ValaCCodeFunction* vala_ccode_base_module_get_ccode (ValaCCodeBaseModule* self);
void vala_gvariant_module_write_expression (ValaGVariantModule* self, ValaDataType* type, ValaCCodeExpression* builder_expr, ValaCCodeExpression* expr, ValaSymbol* sym);
static ValaCCodeExpression* vala_gd_bus_module_create_from_file_descriptor (ValaGDBusModule* self, ValaDataType* type, ValaCCodeExpression* expr);
void vala_gd_bus_module_receive_dbus_value (ValaGDBusModule* self, ValaDataType* type, ValaCCodeExpression* message_expr, ValaCCodeExpression* iter_expr, ValaCCodeExpression* target_expr, ValaSymbol* sym);
void vala_gvariant_module_read_expression (ValaGVariantModule* self, ValaDataType* type, ValaCCodeExpression* iter_expr, ValaCCodeExpression* target_expr, ValaSymbol* sym);
ValaGDBusModule* vala_gd_bus_module_new (void);
ValaGDBusModule* vala_gd_bus_module_construct (GType object_type);
ValaGVariantModule* vala_gvariant_module_new (void);
ValaGVariantModule* vala_gvariant_module_construct (GType object_type);


gchar* vala_gd_bus_module_get_dbus_name (ValaTypeSymbol* symbol) {
	gchar* result = NULL;
	ValaAttribute* _tmp0_ = NULL;
	ValaAttribute* dbus;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) symbol, "DBus");
	dbus = _tmp0_;
	if (dbus == NULL) {
		result = NULL;
		_vala_code_node_unref0 (dbus);
		return result;
	}
	_tmp1_ = vala_attribute_get_string (dbus, "name");
	result = _tmp1_;
	_vala_code_node_unref0 (dbus);
	return result;
}


gchar* vala_gd_bus_module_get_dbus_name_for_member (ValaSymbol* symbol) {
	gchar* result = NULL;
	ValaAttribute* _tmp0_ = NULL;
	ValaAttribute* dbus;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) symbol, "DBus");
	dbus = _tmp0_;
	if (dbus != NULL) {
		gboolean _tmp2_;
		_tmp2_ = vala_attribute_has_argument (dbus, "name");
		_tmp1_ = _tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp3_ = NULL;
		_tmp3_ = vala_attribute_get_string (dbus, "name");
		result = _tmp3_;
		_vala_code_node_unref0 (dbus);
		return result;
	}
	_tmp4_ = vala_symbol_get_name (symbol);
	_tmp5_ = vala_symbol_lower_case_to_camel_case (_tmp4_);
	result = _tmp5_;
	_vala_code_node_unref0 (dbus);
	return result;
}


gboolean vala_gd_bus_module_is_dbus_no_reply (ValaMethod* m) {
	gboolean result = FALSE;
	ValaAttribute* _tmp0_ = NULL;
	ValaAttribute* dbus_attribute;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (m != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) m, "DBus");
	dbus_attribute = _tmp0_;
	if (dbus_attribute != NULL) {
		gboolean _tmp3_;
		_tmp3_ = vala_attribute_has_argument (dbus_attribute, "no_reply");
		_tmp2_ = _tmp3_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp4_;
		_tmp4_ = vala_attribute_get_bool (dbus_attribute, "no_reply");
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = TRUE;
		_vala_code_node_unref0 (dbus_attribute);
		return result;
	}
	result = FALSE;
	_vala_code_node_unref0 (dbus_attribute);
	return result;
}


static void vala_gd_bus_module_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain) {
	ValaGDBusModule * self;
	gchar* _tmp0_ = NULL;
	gchar* edomain_dbus_name;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaCCodeInitializerList* _tmp3_ = NULL;
	ValaCCodeInitializerList* error_entries;
	ValaCCodeDeclaration* _tmp22_ = NULL;
	ValaCCodeDeclaration* _cdecl_;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_;
	gchar* _tmp25_;
	ValaCCodeVariableDeclarator* _tmp26_ = NULL;
	ValaCCodeVariableDeclarator* _tmp27_;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* quark_fun_name;
	ValaTypeSymbol* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_;
	ValaCCodeFunction* _tmp34_ = NULL;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunction* cquark_fun;
	ValaCCodeBlock* _tmp36_ = NULL;
	ValaCCodeBlock* cquark_block;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_;
	gchar* quark_name;
	ValaCCodeDeclaration* _tmp41_ = NULL;
	ValaCCodeDeclaration* _tmp42_;
	ValaCCodeConstant* _tmp43_ = NULL;
	ValaCCodeConstant* _tmp44_;
	ValaCCodeVariableDeclarator* _tmp45_ = NULL;
	ValaCCodeVariableDeclarator* _tmp46_;
	ValaCCodeIdentifier* _tmp47_ = NULL;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_ = NULL;
	ValaCCodeFunctionCall* _tmp50_;
	ValaCCodeFunctionCall* register_call;
	gchar* _tmp51_ = NULL;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	ValaCCodeConstant* _tmp55_ = NULL;
	ValaCCodeConstant* _tmp56_;
	ValaCCodeIdentifier* _tmp57_ = NULL;
	ValaCCodeIdentifier* _tmp58_;
	ValaCCodeUnaryExpression* _tmp59_ = NULL;
	ValaCCodeUnaryExpression* _tmp60_;
	gchar* _tmp61_ = NULL;
	gchar* _tmp62_;
	gchar* _tmp63_;
	ValaCCodeIdentifier* _tmp64_ = NULL;
	ValaCCodeIdentifier* _tmp65_;
	ValaCCodeIdentifier* _tmp66_ = NULL;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeFunctionCall* _tmp68_ = NULL;
	ValaCCodeFunctionCall* _tmp69_;
	ValaCCodeFunctionCall* nentries;
	gchar* _tmp70_ = NULL;
	gchar* _tmp71_;
	gchar* _tmp72_;
	ValaCCodeIdentifier* _tmp73_ = NULL;
	ValaCCodeIdentifier* _tmp74_;
	ValaCCodeExpressionStatement* _tmp75_ = NULL;
	ValaCCodeExpressionStatement* _tmp76_;
	ValaCCodeIdentifier* _tmp77_ = NULL;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeCastExpression* _tmp79_ = NULL;
	ValaCCodeCastExpression* _tmp80_;
	ValaCCodeReturnStatement* _tmp81_ = NULL;
	ValaCCodeReturnStatement* _tmp82_;
	self = (ValaGDBusModule*) base;
	g_return_if_fail (edomain != NULL);
	_tmp0_ = vala_gd_bus_module_get_dbus_name ((ValaTypeSymbol*) edomain);
	edomain_dbus_name = _tmp0_;
	if (edomain_dbus_name == NULL) {
		VALA_CODE_VISITOR_CLASS (vala_gd_bus_module_parent_class)->visit_error_domain ((ValaCodeVisitor*) VALA_GVARIANT_MODULE (self), edomain);
		_g_free0 (edomain_dbus_name);
		return;
	}
	vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, ((ValaCCodeBaseModule*) self)->cfile);
	_tmp1_ = vala_symbol_is_internal_symbol ((ValaSymbol*) edomain);
	if (!_tmp1_) {
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, ((ValaCCodeBaseModule*) self)->header_file);
	}
	_tmp2_ = vala_symbol_is_private_symbol ((ValaSymbol*) edomain);
	if (!_tmp2_) {
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, ((ValaCCodeBaseModule*) self)->internal_header_file);
	}
	_tmp3_ = vala_ccode_initializer_list_new ();
	error_entries = _tmp3_;
	{
		ValaList* _tmp4_ = NULL;
		ValaList* _ecode_list;
		gint _tmp5_;
		gint _ecode_size;
		gint _ecode_index;
		_tmp4_ = vala_error_domain_get_codes (edomain);
		_ecode_list = _tmp4_;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _ecode_list);
		_ecode_size = _tmp5_;
		_ecode_index = -1;
		while (TRUE) {
			gpointer _tmp6_ = NULL;
			ValaErrorCode* ecode;
			gchar* _tmp7_ = NULL;
			gchar* ecode_dbus_name;
			ValaCCodeInitializerList* _tmp13_ = NULL;
			ValaCCodeInitializerList* error_entry;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			ValaCCodeIdentifier* _tmp16_ = NULL;
			ValaCCodeIdentifier* _tmp17_;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_;
			ValaCCodeConstant* _tmp20_ = NULL;
			ValaCCodeConstant* _tmp21_;
			_ecode_index = _ecode_index + 1;
			if (!(_ecode_index < _ecode_size)) {
				break;
			}
			_tmp6_ = vala_list_get (_ecode_list, _ecode_index);
			ecode = (ValaErrorCode*) _tmp6_;
			_tmp7_ = vala_gd_bus_module_get_dbus_name ((ValaTypeSymbol*) ecode);
			ecode_dbus_name = _tmp7_;
			if (ecode_dbus_name == NULL) {
				const gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				_tmp8_ = vala_symbol_get_name ((ValaSymbol*) ecode);
				_tmp9_ = g_utf8_strdown (_tmp8_, (gssize) (-1));
				_tmp10_ = _tmp9_;
				_tmp11_ = vala_symbol_lower_case_to_camel_case (_tmp10_);
				_tmp12_ = _tmp11_;
				_g_free0 (ecode_dbus_name);
				ecode_dbus_name = _tmp12_;
				_g_free0 (_tmp10_);
			}
			_tmp13_ = vala_ccode_initializer_list_new ();
			error_entry = _tmp13_;
			_tmp14_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) ecode, FALSE);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_ccode_identifier_new (_tmp15_);
			_tmp17_ = _tmp16_;
			vala_ccode_initializer_list_append (error_entry, (ValaCCodeExpression*) _tmp17_);
			_vala_ccode_node_unref0 (_tmp17_);
			_g_free0 (_tmp15_);
			_tmp18_ = g_strdup_printf ("\"%s.%s\"", edomain_dbus_name, ecode_dbus_name);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_ccode_constant_new (_tmp19_);
			_tmp21_ = _tmp20_;
			vala_ccode_initializer_list_append (error_entry, (ValaCCodeExpression*) _tmp21_);
			_vala_ccode_node_unref0 (_tmp21_);
			_g_free0 (_tmp19_);
			vala_ccode_initializer_list_append (error_entries, (ValaCCodeExpression*) error_entry);
			_vala_ccode_node_unref0 (error_entry);
			_g_free0 (ecode_dbus_name);
			_vala_code_node_unref0 (ecode);
		}
		_vala_iterable_unref0 (_ecode_list);
	}
	_tmp22_ = vala_ccode_declaration_new ("const GDBusErrorEntry");
	_cdecl_ = _tmp22_;
	_tmp23_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) edomain, NULL);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_strconcat (_tmp24_, "_entries[]", NULL);
	_tmp26_ = vala_ccode_variable_declarator_new (_tmp25_, (ValaCCodeExpression*) error_entries, NULL);
	_tmp27_ = _tmp26_;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) _tmp27_);
	_vala_ccode_node_unref0 (_tmp27_);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp24_);
	vala_ccode_declaration_set_modifiers (_cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_file_add_constant_declaration (((ValaCCodeBaseModule*) self)->cfile, (ValaCCodeNode*) _cdecl_);
	_tmp28_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) edomain);
	_tmp29_ = _tmp28_;
	quark_fun_name = (_tmp30_ = g_strconcat (_tmp29_, "quark", NULL), _g_free0 (_tmp29_), _tmp30_);
	_tmp31_ = vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->gquark_type);
	_tmp32_ = vala_typesymbol_get_cname (_tmp31_, FALSE);
	_tmp33_ = _tmp32_;
	_tmp34_ = vala_ccode_function_new (quark_fun_name, _tmp33_);
	cquark_fun = (_tmp35_ = _tmp34_, _g_free0 (_tmp33_), _tmp35_);
	_tmp36_ = vala_ccode_block_new ();
	cquark_block = _tmp36_;
	_tmp37_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) edomain);
	_tmp38_ = _tmp37_;
	_tmp39_ = g_strdup_printf ("%squark_volatile", _tmp38_);
	quark_name = (_tmp40_ = _tmp39_, _g_free0 (_tmp38_), _tmp40_);
	_tmp41_ = vala_ccode_declaration_new ("gsize");
	_tmp42_ = _tmp41_;
	_vala_ccode_node_unref0 (_cdecl_);
	_cdecl_ = _tmp42_;
	_tmp43_ = vala_ccode_constant_new ("0");
	_tmp44_ = _tmp43_;
	_tmp45_ = vala_ccode_variable_declarator_new (quark_name, (ValaCCodeExpression*) _tmp44_, NULL);
	_tmp46_ = _tmp45_;
	vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) _tmp46_);
	_vala_ccode_node_unref0 (_tmp46_);
	_vala_ccode_node_unref0 (_tmp44_);
	vala_ccode_declaration_set_modifiers (_cdecl_, VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_VOLATILE);
	vala_ccode_block_add_statement (cquark_block, (ValaCCodeNode*) _cdecl_);
	_tmp47_ = vala_ccode_identifier_new ("g_dbus_error_register_error_domain");
	_tmp48_ = _tmp47_;
	_tmp49_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp48_);
	register_call = (_tmp50_ = _tmp49_, _vala_ccode_node_unref0 (_tmp48_), _tmp50_);
	_tmp51_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) edomain, NULL);
	_tmp52_ = _tmp51_;
	_tmp53_ = g_strconcat ("\"", _tmp52_, NULL);
	_tmp54_ = g_strconcat (_tmp53_, "-quark\"", NULL);
	_tmp55_ = vala_ccode_constant_new (_tmp54_);
	_tmp56_ = _tmp55_;
	vala_ccode_function_call_add_argument (register_call, (ValaCCodeExpression*) _tmp56_);
	_vala_ccode_node_unref0 (_tmp56_);
	_g_free0 (_tmp54_);
	_g_free0 (_tmp53_);
	_g_free0 (_tmp52_);
	_tmp57_ = vala_ccode_identifier_new (quark_name);
	_tmp58_ = _tmp57_;
	_tmp59_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp58_);
	_tmp60_ = _tmp59_;
	vala_ccode_function_call_add_argument (register_call, (ValaCCodeExpression*) _tmp60_);
	_vala_ccode_node_unref0 (_tmp60_);
	_vala_ccode_node_unref0 (_tmp58_);
	_tmp61_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) edomain, NULL);
	_tmp62_ = _tmp61_;
	_tmp63_ = g_strconcat (_tmp62_, "_entries", NULL);
	_tmp64_ = vala_ccode_identifier_new (_tmp63_);
	_tmp65_ = _tmp64_;
	vala_ccode_function_call_add_argument (register_call, (ValaCCodeExpression*) _tmp65_);
	_vala_ccode_node_unref0 (_tmp65_);
	_g_free0 (_tmp63_);
	_g_free0 (_tmp62_);
	_tmp66_ = vala_ccode_identifier_new ("G_N_ELEMENTS");
	_tmp67_ = _tmp66_;
	_tmp68_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp67_);
	nentries = (_tmp69_ = _tmp68_, _vala_ccode_node_unref0 (_tmp67_), _tmp69_);
	_tmp70_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) edomain, NULL);
	_tmp71_ = _tmp70_;
	_tmp72_ = g_strconcat (_tmp71_, "_entries", NULL);
	_tmp73_ = vala_ccode_identifier_new (_tmp72_);
	_tmp74_ = _tmp73_;
	vala_ccode_function_call_add_argument (nentries, (ValaCCodeExpression*) _tmp74_);
	_vala_ccode_node_unref0 (_tmp74_);
	_g_free0 (_tmp72_);
	_g_free0 (_tmp71_);
	vala_ccode_function_call_add_argument (register_call, (ValaCCodeExpression*) nentries);
	_tmp75_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) register_call);
	_tmp76_ = _tmp75_;
	vala_ccode_block_add_statement (cquark_block, (ValaCCodeNode*) _tmp76_);
	_vala_ccode_node_unref0 (_tmp76_);
	_tmp77_ = vala_ccode_identifier_new (quark_name);
	_tmp78_ = _tmp77_;
	_tmp79_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp78_, "GQuark");
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) _tmp80_);
	_tmp82_ = _tmp81_;
	vala_ccode_block_add_statement (cquark_block, (ValaCCodeNode*) _tmp82_);
	_vala_ccode_node_unref0 (_tmp82_);
	_vala_ccode_node_unref0 (_tmp80_);
	_vala_ccode_node_unref0 (_tmp78_);
	vala_ccode_function_set_block (cquark_fun, cquark_block);
	vala_ccode_file_add_function (((ValaCCodeBaseModule*) self)->cfile, cquark_fun);
	_vala_ccode_node_unref0 (nentries);
	_vala_ccode_node_unref0 (register_call);
	_g_free0 (quark_name);
	_vala_ccode_node_unref0 (cquark_block);
	_vala_ccode_node_unref0 (cquark_fun);
	_g_free0 (quark_fun_name);
	_vala_ccode_node_unref0 (_cdecl_);
	_vala_ccode_node_unref0 (error_entries);
	_g_free0 (edomain_dbus_name);
}


static gboolean vala_gd_bus_module_is_file_descriptor (ValaGDBusModule* self, ValaDataType* type) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	if (VALA_IS_OBJECT_TYPE (type)) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		ValaTypeSymbol* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gboolean _tmp5_;
		_tmp2_ = vala_data_type_get_data_type (type);
		_tmp3_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp2_);
		_tmp4_ = _tmp3_;
		if ((_tmp5_ = g_strcmp0 (_tmp4_, "GLib.UnixInputStream") == 0, _g_free0 (_tmp4_), _tmp5_)) {
			_tmp1_ = TRUE;
		} else {
			ValaTypeSymbol* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			_tmp6_ = vala_data_type_get_data_type (type);
			_tmp7_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp1_ = g_strcmp0 (_tmp8_, "GLib.UnixOutputStream") == 0;
			_g_free0 (_tmp8_);
		}
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			ValaTypeSymbol* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			_tmp9_ = vala_data_type_get_data_type (type);
			_tmp10_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp0_ = g_strcmp0 (_tmp11_, "GLib.Socket") == 0;
			_g_free0 (_tmp11_);
		}
		if (_tmp0_) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


gboolean vala_gd_bus_module_dbus_method_uses_file_descriptor (ValaGDBusModule* self, ValaMethod* method) {
	gboolean result = FALSE;
	ValaDataType* _tmp5_ = NULL;
	gboolean _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (method != NULL, FALSE);
	{
		ValaList* _tmp0_ = NULL;
		ValaList* _param_list;
		gint _tmp1_;
		gint _param_size;
		gint _param_index;
		_tmp0_ = vala_method_get_parameters (method);
		_param_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _param_list);
		_param_size = _tmp1_;
		_param_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			ValaParameter* param;
			ValaDataType* _tmp3_ = NULL;
			gboolean _tmp4_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_param_list, _param_index);
			param = (ValaParameter*) _tmp2_;
			_tmp3_ = vala_variable_get_variable_type ((ValaVariable*) param);
			_tmp4_ = vala_gd_bus_module_is_file_descriptor (self, _tmp3_);
			if (_tmp4_) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp5_ = vala_method_get_return_type (method);
	_tmp6_ = vala_gd_bus_module_is_file_descriptor (self, _tmp5_);
	if (_tmp6_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static ValaCCodeExpression* vala_gd_bus_module_get_file_descriptor (ValaGDBusModule* self, ValaDataType* type, ValaCCodeExpression* expr) {
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	if (VALA_IS_OBJECT_TYPE (type)) {
		ValaTypeSymbol* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gboolean _tmp3_;
		_tmp0_ = vala_data_type_get_data_type (type);
		_tmp1_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp0_);
		_tmp2_ = _tmp1_;
		if ((_tmp3_ = g_strcmp0 (_tmp2_, "GLib.UnixInputStream") == 0, _g_free0 (_tmp2_), _tmp3_)) {
			ValaCCodeIdentifier* _tmp4_ = NULL;
			ValaCCodeIdentifier* _tmp5_;
			ValaCCodeFunctionCall* _tmp6_ = NULL;
			ValaCCodeFunctionCall* _tmp7_;
			ValaCCodeFunctionCall* _result_;
			_tmp4_ = vala_ccode_identifier_new ("g_unix_input_stream_get_fd");
			_tmp5_ = _tmp4_;
			_tmp6_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp5_);
			_result_ = (_tmp7_ = _tmp6_, _vala_ccode_node_unref0 (_tmp5_), _tmp7_);
			vala_ccode_function_call_add_argument (_result_, expr);
			result = (ValaCCodeExpression*) _result_;
			return result;
		} else {
			ValaTypeSymbol* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			gboolean _tmp11_;
			_tmp8_ = vala_data_type_get_data_type (type);
			_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			if ((_tmp11_ = g_strcmp0 (_tmp10_, "GLib.UnixOutputStream") == 0, _g_free0 (_tmp10_), _tmp11_)) {
				ValaCCodeIdentifier* _tmp12_ = NULL;
				ValaCCodeIdentifier* _tmp13_;
				ValaCCodeFunctionCall* _tmp14_ = NULL;
				ValaCCodeFunctionCall* _tmp15_;
				ValaCCodeFunctionCall* _result_;
				_tmp12_ = vala_ccode_identifier_new ("g_unix_output_stream_get_fd");
				_tmp13_ = _tmp12_;
				_tmp14_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp13_);
				_result_ = (_tmp15_ = _tmp14_, _vala_ccode_node_unref0 (_tmp13_), _tmp15_);
				vala_ccode_function_call_add_argument (_result_, expr);
				result = (ValaCCodeExpression*) _result_;
				return result;
			} else {
				ValaTypeSymbol* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_;
				gboolean _tmp19_;
				_tmp16_ = vala_data_type_get_data_type (type);
				_tmp17_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp16_);
				_tmp18_ = _tmp17_;
				if ((_tmp19_ = g_strcmp0 (_tmp18_, "GLib.Socket") == 0, _g_free0 (_tmp18_), _tmp19_)) {
					ValaCCodeIdentifier* _tmp20_ = NULL;
					ValaCCodeIdentifier* _tmp21_;
					ValaCCodeFunctionCall* _tmp22_ = NULL;
					ValaCCodeFunctionCall* _tmp23_;
					ValaCCodeFunctionCall* _result_;
					_tmp20_ = vala_ccode_identifier_new ("g_socket_get_fd");
					_tmp21_ = _tmp20_;
					_tmp22_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp21_);
					_result_ = (_tmp23_ = _tmp22_, _vala_ccode_node_unref0 (_tmp21_), _tmp23_);
					vala_ccode_function_call_add_argument (_result_, expr);
					result = (ValaCCodeExpression*) _result_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}


void vala_gd_bus_module_send_dbus_value (ValaGDBusModule* self, ValaDataType* type, ValaCCodeExpression* builder_expr, ValaCCodeExpression* expr, ValaSymbol* sym) {
	ValaCCodeExpression* _tmp0_ = NULL;
	ValaCCodeExpression* fd;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (builder_expr != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_gd_bus_module_get_file_descriptor (self, type, expr);
	fd = _tmp0_;
	if (fd != NULL) {
		ValaCCodeIdentifier* _tmp1_ = NULL;
		ValaCCodeIdentifier* _tmp2_;
		ValaCCodeFunctionCall* _tmp3_ = NULL;
		ValaCCodeFunctionCall* _tmp4_;
		ValaCCodeFunctionCall* fd_append;
		ValaCCodeIdentifier* _tmp5_ = NULL;
		ValaCCodeIdentifier* _tmp6_;
		ValaCCodeConstant* _tmp7_ = NULL;
		ValaCCodeConstant* _tmp8_;
		ValaCCodeIdentifier* _tmp9_ = NULL;
		ValaCCodeIdentifier* _tmp10_;
		ValaCCodeFunctionCall* _tmp11_ = NULL;
		ValaCCodeFunctionCall* _tmp12_;
		ValaCCodeFunctionCall* builder_add;
		ValaCCodeUnaryExpression* _tmp13_ = NULL;
		ValaCCodeUnaryExpression* _tmp14_;
		ValaCCodeConstant* _tmp15_ = NULL;
		ValaCCodeConstant* _tmp16_;
		ValaCCodeFunction* _tmp17_ = NULL;
		_tmp1_ = vala_ccode_identifier_new ("g_unix_fd_list_append");
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2_);
		fd_append = (_tmp4_ = _tmp3_, _vala_ccode_node_unref0 (_tmp2_), _tmp4_);
		_tmp5_ = vala_ccode_identifier_new ("_fd_list");
		_tmp6_ = _tmp5_;
		vala_ccode_function_call_add_argument (fd_append, (ValaCCodeExpression*) _tmp6_);
		_vala_ccode_node_unref0 (_tmp6_);
		vala_ccode_function_call_add_argument (fd_append, fd);
		_tmp7_ = vala_ccode_constant_new ("NULL");
		_tmp8_ = _tmp7_;
		vala_ccode_function_call_add_argument (fd_append, (ValaCCodeExpression*) _tmp8_);
		_vala_ccode_node_unref0 (_tmp8_);
		_tmp9_ = vala_ccode_identifier_new ("g_variant_builder_add");
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp10_);
		builder_add = (_tmp12_ = _tmp11_, _vala_ccode_node_unref0 (_tmp10_), _tmp12_);
		_tmp13_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, builder_expr);
		_tmp14_ = _tmp13_;
		vala_ccode_function_call_add_argument (builder_add, (ValaCCodeExpression*) _tmp14_);
		_vala_ccode_node_unref0 (_tmp14_);
		_tmp15_ = vala_ccode_constant_new ("\"h\"");
		_tmp16_ = _tmp15_;
		vala_ccode_function_call_add_argument (builder_add, (ValaCCodeExpression*) _tmp16_);
		_vala_ccode_node_unref0 (_tmp16_);
		vala_ccode_function_call_add_argument (builder_add, (ValaCCodeExpression*) fd_append);
		_tmp17_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		vala_ccode_function_add_expression (_tmp17_, (ValaCCodeExpression*) builder_add);
		_vala_ccode_node_unref0 (builder_add);
		_vala_ccode_node_unref0 (fd_append);
	} else {
		vala_gvariant_module_write_expression ((ValaGVariantModule*) self, type, builder_expr, expr, sym);
	}
	_vala_ccode_node_unref0 (fd);
}


static ValaCCodeExpression* vala_gd_bus_module_create_from_file_descriptor (ValaGDBusModule* self, ValaDataType* type, ValaCCodeExpression* expr) {
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	if (VALA_IS_OBJECT_TYPE (type)) {
		ValaTypeSymbol* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gboolean _tmp3_;
		_tmp0_ = vala_data_type_get_data_type (type);
		_tmp1_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp0_);
		_tmp2_ = _tmp1_;
		if ((_tmp3_ = g_strcmp0 (_tmp2_, "GLib.UnixInputStream") == 0, _g_free0 (_tmp2_), _tmp3_)) {
			ValaCCodeIdentifier* _tmp4_ = NULL;
			ValaCCodeIdentifier* _tmp5_;
			ValaCCodeFunctionCall* _tmp6_ = NULL;
			ValaCCodeFunctionCall* _tmp7_;
			ValaCCodeFunctionCall* _result_;
			ValaCCodeConstant* _tmp8_ = NULL;
			ValaCCodeConstant* _tmp9_;
			ValaCCodeCastExpression* _tmp10_ = NULL;
			_tmp4_ = vala_ccode_identifier_new ("g_unix_input_stream_new");
			_tmp5_ = _tmp4_;
			_tmp6_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp5_);
			_result_ = (_tmp7_ = _tmp6_, _vala_ccode_node_unref0 (_tmp5_), _tmp7_);
			vala_ccode_function_call_add_argument (_result_, expr);
			_tmp8_ = vala_ccode_constant_new ("TRUE");
			_tmp9_ = _tmp8_;
			vala_ccode_function_call_add_argument (_result_, (ValaCCodeExpression*) _tmp9_);
			_vala_ccode_node_unref0 (_tmp9_);
			_tmp10_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _result_, "GUnixInputStream *");
			result = (ValaCCodeExpression*) _tmp10_;
			_vala_ccode_node_unref0 (_result_);
			return result;
		} else {
			ValaTypeSymbol* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			gboolean _tmp14_;
			_tmp11_ = vala_data_type_get_data_type (type);
			_tmp12_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp11_);
			_tmp13_ = _tmp12_;
			if ((_tmp14_ = g_strcmp0 (_tmp13_, "GLib.UnixOutputStream") == 0, _g_free0 (_tmp13_), _tmp14_)) {
				ValaCCodeIdentifier* _tmp15_ = NULL;
				ValaCCodeIdentifier* _tmp16_;
				ValaCCodeFunctionCall* _tmp17_ = NULL;
				ValaCCodeFunctionCall* _tmp18_;
				ValaCCodeFunctionCall* _result_;
				ValaCCodeConstant* _tmp19_ = NULL;
				ValaCCodeConstant* _tmp20_;
				ValaCCodeCastExpression* _tmp21_ = NULL;
				_tmp15_ = vala_ccode_identifier_new ("g_unix_output_stream_new");
				_tmp16_ = _tmp15_;
				_tmp17_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp16_);
				_result_ = (_tmp18_ = _tmp17_, _vala_ccode_node_unref0 (_tmp16_), _tmp18_);
				vala_ccode_function_call_add_argument (_result_, expr);
				_tmp19_ = vala_ccode_constant_new ("TRUE");
				_tmp20_ = _tmp19_;
				vala_ccode_function_call_add_argument (_result_, (ValaCCodeExpression*) _tmp20_);
				_vala_ccode_node_unref0 (_tmp20_);
				_tmp21_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _result_, "GUnixOutputStream *");
				result = (ValaCCodeExpression*) _tmp21_;
				_vala_ccode_node_unref0 (_result_);
				return result;
			} else {
				ValaTypeSymbol* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_;
				gboolean _tmp25_;
				_tmp22_ = vala_data_type_get_data_type (type);
				_tmp23_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp22_);
				_tmp24_ = _tmp23_;
				if ((_tmp25_ = g_strcmp0 (_tmp24_, "GLib.Socket") == 0, _g_free0 (_tmp24_), _tmp25_)) {
					ValaCCodeIdentifier* _tmp26_ = NULL;
					ValaCCodeIdentifier* _tmp27_;
					ValaCCodeFunctionCall* _tmp28_ = NULL;
					ValaCCodeFunctionCall* _tmp29_;
					ValaCCodeFunctionCall* _result_;
					ValaCCodeConstant* _tmp30_ = NULL;
					ValaCCodeConstant* _tmp31_;
					_tmp26_ = vala_ccode_identifier_new ("g_socket_new_from_fd");
					_tmp27_ = _tmp26_;
					_tmp28_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp27_);
					_result_ = (_tmp29_ = _tmp28_, _vala_ccode_node_unref0 (_tmp27_), _tmp29_);
					vala_ccode_function_call_add_argument (_result_, expr);
					_tmp30_ = vala_ccode_constant_new ("NULL");
					_tmp31_ = _tmp30_;
					vala_ccode_function_call_add_argument (_result_, (ValaCCodeExpression*) _tmp31_);
					_vala_ccode_node_unref0 (_tmp31_);
					result = (ValaCCodeExpression*) _result_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}


void vala_gd_bus_module_receive_dbus_value (ValaGDBusModule* self, ValaDataType* type, ValaCCodeExpression* message_expr, ValaCCodeExpression* iter_expr, ValaCCodeExpression* target_expr, ValaSymbol* sym) {
	ValaCCodeIdentifier* _tmp0_ = NULL;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_ = NULL;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* fd_list;
	ValaCCodeIdentifier* _tmp4_ = NULL;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeFunctionCall* _tmp6_ = NULL;
	ValaCCodeFunctionCall* _tmp7_;
	ValaCCodeFunctionCall* fd;
	ValaCCodeIdentifier* _tmp8_ = NULL;
	ValaCCodeIdentifier* _tmp9_;
	ValaCCodeConstant* _tmp10_ = NULL;
	ValaCCodeConstant* _tmp11_;
	ValaCCodeExpression* _tmp12_ = NULL;
	ValaCCodeExpression* stream;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (message_expr != NULL);
	g_return_if_fail (iter_expr != NULL);
	g_return_if_fail (target_expr != NULL);
	_tmp0_ = vala_ccode_identifier_new ("g_dbus_message_get_unix_fd_list");
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1_);
	fd_list = (_tmp3_ = _tmp2_, _vala_ccode_node_unref0 (_tmp1_), _tmp3_);
	vala_ccode_function_call_add_argument (fd_list, message_expr);
	_tmp4_ = vala_ccode_identifier_new ("g_unix_fd_list_get");
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp5_);
	fd = (_tmp7_ = _tmp6_, _vala_ccode_node_unref0 (_tmp5_), _tmp7_);
	vala_ccode_function_call_add_argument (fd, (ValaCCodeExpression*) fd_list);
	_tmp8_ = vala_ccode_identifier_new ("_fd_index");
	_tmp9_ = _tmp8_;
	vala_ccode_function_call_add_argument (fd, (ValaCCodeExpression*) _tmp9_);
	_vala_ccode_node_unref0 (_tmp9_);
	_tmp10_ = vala_ccode_constant_new ("NULL");
	_tmp11_ = _tmp10_;
	vala_ccode_function_call_add_argument (fd, (ValaCCodeExpression*) _tmp11_);
	_vala_ccode_node_unref0 (_tmp11_);
	_tmp12_ = vala_gd_bus_module_create_from_file_descriptor (self, type, (ValaCCodeExpression*) fd);
	stream = _tmp12_;
	if (stream != NULL) {
		ValaCCodeIdentifier* _tmp13_ = NULL;
		ValaCCodeIdentifier* _tmp14_;
		ValaCCodeFunctionCall* _tmp15_ = NULL;
		ValaCCodeFunctionCall* _tmp16_;
		ValaCCodeFunctionCall* get_fd;
		ValaCCodeUnaryExpression* _tmp17_ = NULL;
		ValaCCodeUnaryExpression* _tmp18_;
		ValaCCodeConstant* _tmp19_ = NULL;
		ValaCCodeConstant* _tmp20_;
		ValaCCodeIdentifier* _tmp21_ = NULL;
		ValaCCodeIdentifier* _tmp22_;
		ValaCCodeUnaryExpression* _tmp23_ = NULL;
		ValaCCodeUnaryExpression* _tmp24_;
		ValaCCodeFunction* _tmp25_ = NULL;
		ValaCCodeFunction* _tmp26_ = NULL;
		ValaCCodeAssignment* _tmp27_ = NULL;
		ValaCCodeAssignment* _tmp28_;
		_tmp13_ = vala_ccode_identifier_new ("g_variant_iter_next");
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp14_);
		get_fd = (_tmp16_ = _tmp15_, _vala_ccode_node_unref0 (_tmp14_), _tmp16_);
		_tmp17_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, iter_expr);
		_tmp18_ = _tmp17_;
		vala_ccode_function_call_add_argument (get_fd, (ValaCCodeExpression*) _tmp18_);
		_vala_ccode_node_unref0 (_tmp18_);
		_tmp19_ = vala_ccode_constant_new ("\"h\"");
		_tmp20_ = _tmp19_;
		vala_ccode_function_call_add_argument (get_fd, (ValaCCodeExpression*) _tmp20_);
		_vala_ccode_node_unref0 (_tmp20_);
		_tmp21_ = vala_ccode_identifier_new ("_fd_index");
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp22_);
		_tmp24_ = _tmp23_;
		vala_ccode_function_call_add_argument (get_fd, (ValaCCodeExpression*) _tmp24_);
		_vala_ccode_node_unref0 (_tmp24_);
		_vala_ccode_node_unref0 (_tmp22_);
		_tmp25_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		vala_ccode_function_add_expression (_tmp25_, (ValaCCodeExpression*) get_fd);
		_tmp26_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp27_ = vala_ccode_assignment_new (target_expr, stream, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
		_tmp28_ = _tmp27_;
		vala_ccode_function_add_expression (_tmp26_, (ValaCCodeExpression*) _tmp28_);
		_vala_ccode_node_unref0 (_tmp28_);
		_vala_ccode_node_unref0 (get_fd);
	} else {
		vala_gvariant_module_read_expression ((ValaGVariantModule*) self, type, iter_expr, target_expr, sym);
	}
	_vala_ccode_node_unref0 (stream);
	_vala_ccode_node_unref0 (fd);
	_vala_ccode_node_unref0 (fd_list);
}


ValaGDBusModule* vala_gd_bus_module_construct (GType object_type) {
	ValaGDBusModule* self = NULL;
	self = (ValaGDBusModule*) vala_gvariant_module_construct (object_type);
	return self;
}


ValaGDBusModule* vala_gd_bus_module_new (void) {
	return vala_gd_bus_module_construct (VALA_TYPE_GD_BUS_MODULE);
}


static void vala_gd_bus_module_class_init (ValaGDBusModuleClass * klass) {
	vala_gd_bus_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_domain = vala_gd_bus_module_real_visit_error_domain;
}


static void vala_gd_bus_module_instance_init (ValaGDBusModule * self) {
}


GType vala_gd_bus_module_get_type (void) {
	static volatile gsize vala_gd_bus_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gd_bus_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGDBusModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gd_bus_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGDBusModule), 0, (GInstanceInitFunc) vala_gd_bus_module_instance_init, NULL };
		GType vala_gd_bus_module_type_id;
		vala_gd_bus_module_type_id = g_type_register_static (VALA_TYPE_GVARIANT_MODULE, "ValaGDBusModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_gd_bus_module_type_id__volatile, vala_gd_bus_module_type_id);
	}
	return vala_gd_bus_module_type_id__volatile;
}



