/* valaccodereturnstatement.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodereturnstatement.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodelinedirective.h>




struct _ValaCCodeReturnStatementPrivate {
	ValaCCodeExpression* _return_expression;
};

#define VALA_CCODE_RETURN_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_RETURN_STATEMENT, ValaCCodeReturnStatementPrivate))
enum  {
	VALA_CCODE_RETURN_STATEMENT_DUMMY_PROPERTY
};
static void vala_ccode_return_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_return_statement_parent_class = NULL;
static void vala_ccode_return_statement_finalize (ValaCCodeNode* obj);



ValaCCodeReturnStatement* vala_ccode_return_statement_construct (GType object_type, ValaCCodeExpression* expr) {
	ValaCCodeReturnStatement* self;
	g_return_val_if_fail (expr == NULL || VALA_IS_CCODE_EXPRESSION (expr), NULL);
	self = ((ValaCCodeReturnStatement*) (g_type_create_instance (object_type)));
	vala_ccode_return_statement_set_return_expression (self, expr);
	return self;
}


ValaCCodeReturnStatement* vala_ccode_return_statement_new (ValaCCodeExpression* expr) {
	return vala_ccode_return_statement_construct (VALA_TYPE_CCODE_RETURN_STATEMENT, expr);
}


static void vala_ccode_return_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeReturnStatement * self;
	self = VALA_CCODE_RETURN_STATEMENT (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_indent (writer, vala_ccode_node_get_line (VALA_CCODE_NODE (self)));
	vala_ccode_writer_write_string (writer, "return");
	if (self->priv->_return_expression != NULL) {
		vala_ccode_writer_write_string (writer, " ");
		vala_ccode_node_write (VALA_CCODE_NODE (self->priv->_return_expression), writer);
	}
	vala_ccode_writer_write_string (writer, ";");
	vala_ccode_writer_write_newline (writer);
}


ValaCCodeExpression* vala_ccode_return_statement_get_return_expression (ValaCCodeReturnStatement* self) {
	g_return_val_if_fail (VALA_IS_CCODE_RETURN_STATEMENT (self), NULL);
	return self->priv->_return_expression;
}


void vala_ccode_return_statement_set_return_expression (ValaCCodeReturnStatement* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_RETURN_STATEMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_return_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_ccode_node_ref (_tmp1))), (self->priv->_return_expression == NULL ? NULL : (self->priv->_return_expression = (vala_ccode_node_unref (self->priv->_return_expression), NULL))), _tmp2);
}


static void vala_ccode_return_statement_class_init (ValaCCodeReturnStatementClass * klass) {
	vala_ccode_return_statement_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_return_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeReturnStatementPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_return_statement_real_write;
}


static void vala_ccode_return_statement_instance_init (ValaCCodeReturnStatement * self) {
	self->priv = VALA_CCODE_RETURN_STATEMENT_GET_PRIVATE (self);
}


static void vala_ccode_return_statement_finalize (ValaCCodeNode* obj) {
	ValaCCodeReturnStatement * self;
	self = VALA_CCODE_RETURN_STATEMENT (obj);
	(self->priv->_return_expression == NULL ? NULL : (self->priv->_return_expression = (vala_ccode_node_unref (self->priv->_return_expression), NULL)));
	VALA_CCODE_NODE_CLASS (vala_ccode_return_statement_parent_class)->finalize (obj);
}


GType vala_ccode_return_statement_get_type (void) {
	static GType vala_ccode_return_statement_type_id = 0;
	if (vala_ccode_return_statement_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeReturnStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_return_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeReturnStatement), 0, (GInstanceInitFunc) vala_ccode_return_statement_instance_init, NULL };
		vala_ccode_return_statement_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeReturnStatement", &g_define_type_info, 0);
	}
	return vala_ccode_return_statement_type_id;
}




