/* arraylist.vala
 *
 * Copyright (C) 2004-2005  Novell, Inc
 * Copyright (C) 2005  David Waite
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __GEE_ARRAYLIST_H__
#define __GEE_ARRAYLIST_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/collectionobject.h>
#include <gee/iterable.h>
#include <gee/collection.h>
#include <gee/list.h>
#include <gee/iterator.h>

G_BEGIN_DECLS


#define GEE_TYPE_ARRAY_LIST (gee_array_list_get_type ())
#define GEE_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ARRAY_LIST, GeeArrayList))
#define GEE_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ARRAY_LIST, GeeArrayListClass))
#define GEE_IS_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ARRAY_LIST))
#define GEE_IS_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ARRAY_LIST))
#define GEE_ARRAY_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ARRAY_LIST, GeeArrayListClass))

typedef struct _GeeArrayList GeeArrayList;
typedef struct _GeeArrayListClass GeeArrayListClass;
typedef struct _GeeArrayListPrivate GeeArrayListPrivate;

/**
 * Arrays of arbitrary elements which grow automatically as elements are added.
 */
struct _GeeArrayList {
	GeeCollectionObject parent_instance;
	GeeArrayListPrivate * priv;
};

struct _GeeArrayListClass {
	GeeCollectionObjectClass parent_class;
};


GeeArrayList* gee_array_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func);
GeeArrayList* gee_array_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func);
void gee_array_list_set_equal_func (GeeArrayList* self, GEqualFunc value);
GType gee_array_list_get_type (void);


G_END_DECLS

#endif
