/* valaccodeexpressionbinding.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valaccodeexpressionbinding.h>




struct _ValaCCodeExpressionBindingPrivate {
	ValaCCodeExpression* _codenode;
};

#define VALA_CCODE_EXPRESSION_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_EXPRESSION_BINDING, ValaCCodeExpressionBindingPrivate))
enum  {
	VALA_CCODE_EXPRESSION_BINDING_DUMMY_PROPERTY
};
static gpointer vala_ccode_expression_binding_parent_class = NULL;
static void vala_ccode_expression_binding_finalize (ValaCodeBinding* obj);



ValaCCodeExpression* vala_ccode_expression_binding_get_codenode (ValaCCodeExpressionBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION_BINDING (self), NULL);
	return self->priv->_codenode;
}


void vala_ccode_expression_binding_set_codenode (ValaCCodeExpressionBinding* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_EXPRESSION_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_codenode = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_ccode_node_ref (_tmp1))), (self->priv->_codenode == NULL ? NULL : (self->priv->_codenode = (vala_ccode_node_unref (self->priv->_codenode), NULL))), _tmp2);
}


static void vala_ccode_expression_binding_class_init (ValaCCodeExpressionBindingClass * klass) {
	vala_ccode_expression_binding_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_BINDING_CLASS (klass)->finalize = vala_ccode_expression_binding_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeExpressionBindingPrivate));
}


static void vala_ccode_expression_binding_instance_init (ValaCCodeExpressionBinding * self) {
	self->priv = VALA_CCODE_EXPRESSION_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_expression_binding_finalize (ValaCodeBinding* obj) {
	ValaCCodeExpressionBinding * self;
	self = VALA_CCODE_EXPRESSION_BINDING (obj);
	(self->priv->_codenode == NULL ? NULL : (self->priv->_codenode = (vala_ccode_node_unref (self->priv->_codenode), NULL)));
	VALA_CODE_BINDING_CLASS (vala_ccode_expression_binding_parent_class)->finalize (obj);
}


GType vala_ccode_expression_binding_get_type (void) {
	static GType vala_ccode_expression_binding_type_id = 0;
	if (vala_ccode_expression_binding_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeExpressionBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_expression_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeExpressionBinding), 0, (GInstanceInitFunc) vala_ccode_expression_binding_instance_init, NULL };
		vala_ccode_expression_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_BINDING, "ValaCCodeExpressionBinding", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_ccode_expression_binding_type_id;
}




