/* valacodebinding.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALACODEBINDING_H__
#define __VALA_VALACODEBINDING_H__

#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS


#define VALA_TYPE_CODE_BINDING (vala_code_binding_get_type ())
#define VALA_CODE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_BINDING, ValaCodeBinding))
#define VALA_CODE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_BINDING, ValaCodeBindingClass))
#define VALA_IS_CODE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_BINDING))
#define VALA_IS_CODE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_BINDING))
#define VALA_CODE_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_BINDING, ValaCodeBindingClass))

typedef struct _ValaCodeBinding ValaCodeBinding;
typedef struct _ValaCodeBindingClass ValaCodeBindingClass;
typedef struct _ValaCodeBindingPrivate ValaCodeBindingPrivate;
typedef struct _ValaParamSpecCodeBinding ValaParamSpecCodeBinding;

/**
 * The link between a source code node and generated code.
 */
struct _ValaCodeBinding {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeBindingPrivate * priv;
};

struct _ValaCodeBindingClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeBinding *self);
};

struct _ValaParamSpecCodeBinding {
	GParamSpec parent_instance;
};


GParamSpec* vala_param_spec_code_binding (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
gpointer vala_value_get_code_binding (const GValue* value);
void vala_value_set_code_binding (GValue* value, gpointer v_object);
GType vala_code_binding_get_type (void);
gpointer vala_code_binding_ref (gpointer instance);
void vala_code_binding_unref (gpointer instance);


G_END_DECLS

#endif
