/* valaelementaccess.vala
 *
 * Copyright (C) 2006-2008  Raffaele Sandrini, Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAELEMENTACCESS_H__
#define __VALA_VALAELEMENTACCESS_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/list.h>
#include <vala/valaexpression.h>
#include <vala/valacodenode.h>
#include <vala/valacodebinding.h>

G_BEGIN_DECLS


#define VALA_TYPE_ELEMENT_ACCESS (vala_element_access_get_type ())
#define VALA_ELEMENT_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess))
#define VALA_ELEMENT_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccessClass))
#define VALA_IS_ELEMENT_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ELEMENT_ACCESS))
#define VALA_IS_ELEMENT_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ELEMENT_ACCESS))
#define VALA_ELEMENT_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccessClass))

typedef struct _ValaElementAccessPrivate ValaElementAccessPrivate;

/**
 * Represents an array access expression e.g. "a[1,2]".
 */
struct _ValaElementAccess {
	ValaExpression parent_instance;
	ValaElementAccessPrivate * priv;
};

struct _ValaElementAccessClass {
	ValaExpressionClass parent_class;
};


void vala_element_access_append_index (ValaElementAccess* self, ValaExpression* index);
GeeList* vala_element_access_get_indices (ValaElementAccess* self);
ValaElementAccess* vala_element_access_construct (GType object_type, ValaExpression* container, ValaSourceReference* source_reference);
ValaElementAccess* vala_element_access_new (ValaExpression* container, ValaSourceReference* source_reference);
ValaExpression* vala_element_access_get_container (ValaElementAccess* self);
void vala_element_access_set_container (ValaElementAccess* self, ValaExpression* value);
GType vala_element_access_get_type (void);


G_END_DECLS

#endif
