/* valaobjecttype.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaobjecttype.h>
#include <vala/valacodenode.h>
#include <vala/valatypesymbol.h>
#include <vala/valaclass.h>
#include <vala/valamethod.h>




struct _ValaObjectTypePrivate {
	ValaObjectTypeSymbol* _type_symbol;
};

#define VALA_OBJECT_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_OBJECT_TYPE, ValaObjectTypePrivate))
enum  {
	VALA_OBJECT_TYPE_DUMMY_PROPERTY
};
static ValaDataType* vala_object_type_real_copy (ValaDataType* base);
static char* vala_object_type_real_get_cname (ValaDataType* base);
static gboolean vala_object_type_real_stricter (ValaDataType* base, ValaDataType* target_type);
static gboolean vala_object_type_real_is_invokable (ValaDataType* base);
static ValaDataType* vala_object_type_real_get_return_type (ValaDataType* base);
static GeeList* vala_object_type_real_get_parameters (ValaDataType* base);
static gpointer vala_object_type_parent_class = NULL;
static void vala_object_type_finalize (ValaCodeNode* obj);



ValaObjectType* vala_object_type_construct (GType object_type, ValaObjectTypeSymbol* type_symbol) {
	ValaObjectType* self;
	g_return_val_if_fail (VALA_IS_OBJECT_TYPE_SYMBOL (type_symbol), NULL);
	self = ((ValaObjectType*) (g_type_create_instance (object_type)));
	vala_object_type_set_type_symbol (self, type_symbol);
	vala_data_type_set_data_type (VALA_DATA_TYPE (self), VALA_TYPESYMBOL (type_symbol));
	return self;
}


ValaObjectType* vala_object_type_new (ValaObjectTypeSymbol* type_symbol) {
	return vala_object_type_construct (VALA_TYPE_OBJECT_TYPE, type_symbol);
}


static ValaDataType* vala_object_type_real_copy (ValaDataType* base) {
	ValaObjectType * self;
	ValaObjectType* result;
	self = VALA_OBJECT_TYPE (base);
	result = vala_object_type_new (self->priv->_type_symbol);
	vala_code_node_set_source_reference (VALA_CODE_NODE (result), vala_code_node_get_source_reference (VALA_CODE_NODE (self)));
	vala_data_type_set_value_owned (VALA_DATA_TYPE (result), vala_data_type_get_value_owned (VALA_DATA_TYPE (self)));
	vala_data_type_set_nullable (VALA_DATA_TYPE (result), vala_data_type_get_nullable (VALA_DATA_TYPE (self)));
	vala_data_type_set_is_dynamic (VALA_DATA_TYPE (result), vala_data_type_get_is_dynamic (VALA_DATA_TYPE (self)));
	vala_data_type_set_floating_reference (VALA_DATA_TYPE (result), vala_data_type_get_floating_reference (VALA_DATA_TYPE (self)));
	{
		GeeList* arg_collection;
		int arg_it;
		arg_collection = vala_data_type_get_type_arguments (VALA_DATA_TYPE (self));
		for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
			ValaDataType* arg;
			arg = ((ValaDataType*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
			{
				ValaDataType* _tmp0;
				_tmp0 = NULL;
				vala_data_type_add_type_argument (VALA_DATA_TYPE (result), (_tmp0 = vala_data_type_copy (arg)));
				(_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL)));
				(arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL)));
			}
		}
		(arg_collection == NULL ? NULL : (arg_collection = (gee_collection_object_unref (arg_collection), NULL)));
	}
	return VALA_DATA_TYPE (result);
}


static char* vala_object_type_real_get_cname (ValaDataType* base) {
	ValaObjectType * self;
	char* _tmp0;
	char* _tmp1;
	self = VALA_OBJECT_TYPE (base);
	_tmp0 = NULL;
	_tmp1 = NULL;
	return (_tmp1 = g_strdup_printf ("%s*", (_tmp0 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_type_symbol), !vala_data_type_get_value_owned (VALA_DATA_TYPE (self))))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
}


static gboolean vala_object_type_real_stricter (ValaDataType* base, ValaDataType* target_type) {
	ValaObjectType * self;
	ValaObjectType* _tmp1;
	ValaDataType* _tmp0;
	ValaObjectType* obj_target_type;
	gboolean _tmp5;
	self = VALA_OBJECT_TYPE (base);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (target_type), FALSE);
	_tmp1 = NULL;
	_tmp0 = NULL;
	obj_target_type = (_tmp1 = (_tmp0 = target_type, (VALA_IS_OBJECT_TYPE (_tmp0) ? ((ValaObjectType*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	if (obj_target_type == NULL) {
		gboolean _tmp2;
		return (_tmp2 = FALSE, (obj_target_type == NULL ? NULL : (obj_target_type = (vala_code_node_unref (obj_target_type), NULL))), _tmp2);
	}
	if (vala_data_type_get_value_owned (VALA_DATA_TYPE (self)) != vala_data_type_get_value_owned (target_type)) {
		gboolean _tmp3;
		return (_tmp3 = FALSE, (obj_target_type == NULL ? NULL : (obj_target_type = (vala_code_node_unref (obj_target_type), NULL))), _tmp3);
	}
	if (vala_data_type_get_nullable (VALA_DATA_TYPE (self)) && !vala_data_type_get_nullable (target_type)) {
		gboolean _tmp4;
		return (_tmp4 = FALSE, (obj_target_type == NULL ? NULL : (obj_target_type = (vala_code_node_unref (obj_target_type), NULL))), _tmp4);
	}
	return (_tmp5 = vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (self->priv->_type_symbol), VALA_TYPESYMBOL (obj_target_type->priv->_type_symbol)), (obj_target_type == NULL ? NULL : (obj_target_type = (vala_code_node_unref (obj_target_type), NULL))), _tmp5);
}


static gboolean vala_object_type_real_is_invokable (ValaDataType* base) {
	ValaObjectType * self;
	ValaClass* _tmp1;
	ValaObjectTypeSymbol* _tmp0;
	ValaClass* cl;
	self = VALA_OBJECT_TYPE (base);
	_tmp1 = NULL;
	_tmp0 = NULL;
	cl = (_tmp1 = (_tmp0 = self->priv->_type_symbol, (VALA_IS_CLASS (_tmp0) ? ((ValaClass*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	if (cl != NULL && vala_class_get_default_construction_method (cl) != NULL) {
		gboolean _tmp2;
		return (_tmp2 = TRUE, (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), _tmp2);
	} else {
		gboolean _tmp3;
		return (_tmp3 = FALSE, (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), _tmp3);
	}
	(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
}


static ValaDataType* vala_object_type_real_get_return_type (ValaDataType* base) {
	ValaObjectType * self;
	ValaClass* _tmp1;
	ValaObjectTypeSymbol* _tmp0;
	ValaClass* cl;
	self = VALA_OBJECT_TYPE (base);
	_tmp1 = NULL;
	_tmp0 = NULL;
	cl = (_tmp1 = (_tmp0 = self->priv->_type_symbol, (VALA_IS_CLASS (_tmp0) ? ((ValaClass*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	if (cl != NULL && vala_class_get_default_construction_method (cl) != NULL) {
		ValaDataType* _tmp2;
		ValaDataType* _tmp3;
		_tmp2 = NULL;
		_tmp3 = NULL;
		return (_tmp3 = (_tmp2 = vala_method_get_return_type (vala_class_get_default_construction_method (cl)), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2))), (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), _tmp3);
	} else {
		ValaDataType* _tmp4;
		_tmp4 = NULL;
		return (_tmp4 = NULL, (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), _tmp4);
	}
	(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
}


static GeeList* vala_object_type_real_get_parameters (ValaDataType* base) {
	ValaObjectType * self;
	ValaClass* _tmp1;
	ValaObjectTypeSymbol* _tmp0;
	ValaClass* cl;
	self = VALA_OBJECT_TYPE (base);
	_tmp1 = NULL;
	_tmp0 = NULL;
	cl = (_tmp1 = (_tmp0 = self->priv->_type_symbol, (VALA_IS_CLASS (_tmp0) ? ((ValaClass*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	if (cl != NULL && vala_class_get_default_construction_method (cl) != NULL) {
		GeeList* _tmp2;
		_tmp2 = NULL;
		return (_tmp2 = vala_method_get_parameters (vala_class_get_default_construction_method (cl)), (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), _tmp2);
	} else {
		GeeList* _tmp3;
		_tmp3 = NULL;
		return (_tmp3 = NULL, (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), _tmp3);
	}
	(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
}


ValaObjectTypeSymbol* vala_object_type_get_type_symbol (ValaObjectType* self) {
	g_return_val_if_fail (VALA_IS_OBJECT_TYPE (self), NULL);
	return self->priv->_type_symbol;
}


void vala_object_type_set_type_symbol (ValaObjectType* self, ValaObjectTypeSymbol* value) {
	g_return_if_fail (VALA_IS_OBJECT_TYPE (self));
	self->priv->_type_symbol = value;
}


static void vala_object_type_class_init (ValaObjectTypeClass * klass) {
	vala_object_type_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_object_type_finalize;
	g_type_class_add_private (klass, sizeof (ValaObjectTypePrivate));
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_object_type_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->get_cname = vala_object_type_real_get_cname;
	VALA_DATA_TYPE_CLASS (klass)->stricter = vala_object_type_real_stricter;
	VALA_DATA_TYPE_CLASS (klass)->is_invokable = vala_object_type_real_is_invokable;
	VALA_DATA_TYPE_CLASS (klass)->get_return_type = vala_object_type_real_get_return_type;
	VALA_DATA_TYPE_CLASS (klass)->get_parameters = vala_object_type_real_get_parameters;
}


static void vala_object_type_instance_init (ValaObjectType * self) {
	self->priv = VALA_OBJECT_TYPE_GET_PRIVATE (self);
}


static void vala_object_type_finalize (ValaCodeNode* obj) {
	ValaObjectType * self;
	self = VALA_OBJECT_TYPE (obj);
	VALA_CODE_NODE_CLASS (vala_object_type_parent_class)->finalize (obj);
}


GType vala_object_type_get_type (void) {
	static GType vala_object_type_type_id = 0;
	if (vala_object_type_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaObjectTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectType), 0, (GInstanceInitFunc) vala_object_type_instance_init, NULL };
		vala_object_type_type_id = g_type_register_static (VALA_TYPE_REFERENCE_TYPE, "ValaObjectType", &g_define_type_info, 0);
	}
	return vala_object_type_type_id;
}




