/* clutter-json-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "ClutterJson", lower_case_cprefix = "clutter_json_")]
namespace ClutterJson {
	[CCode (cname = "JsonGenerator", cheader_filename = "clutter/json/json-glib.h")]
	public class JsonGenerator : GLib.Object {
		public weak GLib.Object parent_instance;
		public ClutterJson.JsonGeneratorPrivate priv;
		[CCode (has_construct_function = false)]
		public JsonGenerator ();
		public void set_root (ClutterJson.JsonNode node);
		public string to_data (out size_t length);
		public bool to_file (string filename) throws GLib.Error;
		public uint indent { get; set; }
		public bool pretty { get; set; }
	}
	[CCode (cname = "JsonParser", cheader_filename = "clutter/json/json-glib.h")]
	public class JsonParser : GLib.Object {
		public weak GLib.Object parent_instance;
		public ClutterJson.JsonParserPrivate priv;
		public uint get_current_line ();
		public uint get_current_pos ();
		public ClutterJson.JsonNode get_root ();
		public bool load_from_data (string data, ssize_t length) throws GLib.Error;
		public bool load_from_file (string filename) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public JsonParser ();
		public virtual signal void array_element (ClutterJson.JsonArray array, int index_);
		public virtual signal void array_end (ClutterJson.JsonArray array);
		public virtual signal void array_start ();
		public virtual signal void error (void* error);
		public virtual signal void object_end (ClutterJson.JsonObject object);
		public virtual signal void object_member (ClutterJson.JsonObject object, string member_name);
		public virtual signal void object_start ();
		public virtual signal void parse_end ();
		public virtual signal void parse_start ();
	}
	[CCode (type_id = "CLUTTER_JSON_TYPE_JSON_ARRAY", cheader_filename = "clutter/json/json-glib.h")]
	public struct JsonArray {
		public void add_array_element (ClutterJson.JsonArray value);
		public void add_boolean_element (bool value);
		public void add_double_element (double value);
		public void add_element (ClutterJson.JsonNode node);
		public void add_int_element (int value);
		public void add_null_element ();
		public void add_object_element (ClutterJson.JsonObject value);
		public void add_string_element (string value);
		public ClutterJson.JsonNode dup_element (uint index_);
		public void foreach_element ([CCode (delegate_target_pos = 0)] ClutterJson.JsonArrayForeach func);
		public ClutterJson.JsonArray get_array_element (uint index_);
		public bool get_boolean_element (uint index_);
		public double get_double_element (uint index_);
		public ClutterJson.JsonNode get_element (uint index_);
		public GLib.List get_elements ();
		public int get_int_element (uint index_);
		public uint get_length ();
		public bool get_null_element (uint index_);
		public ClutterJson.JsonObject get_object_element (uint index_);
		public unowned string get_string_element (uint index_);
		public ClutterJson.JsonArray @ref ();
		public void remove_element (uint index_);
		public void unref ();
	}
	[CCode (type_id = "CLUTTER_JSON_TYPE_JSON_GENERATOR_PRIVATE", cheader_filename = "clutter/json/json-glib.h")]
	public struct JsonGeneratorPrivate {
	}
	[CCode (type_id = "CLUTTER_JSON_TYPE_JSON_NODE", cheader_filename = "clutter/json/json-glib.h")]
	public struct JsonNode {
		public ClutterJson.JsonNode copy ();
		public ClutterJson.JsonArray dup_array ();
		public ClutterJson.JsonObject dup_object ();
		public string dup_string ();
		public void free ();
		public ClutterJson.JsonArray get_array ();
		public bool get_boolean ();
		public double get_double ();
		public int get_int ();
		public ClutterJson.JsonNodeType get_node_type ();
		public ClutterJson.JsonObject get_object ();
		public ClutterJson.JsonNode get_parent ();
		public unowned string get_string ();
		public void get_value (GLib.Value value);
		public GLib.Type get_value_type ();
		public bool is_null ();
		public void set_array (ClutterJson.JsonArray array);
		public void set_boolean (bool value);
		public void set_double (double value);
		public void set_int (int value);
		public void set_object (ClutterJson.JsonObject object);
		public void set_string (string value);
		public void set_value (GLib.Value value);
		public void take_array (ClutterJson.JsonArray array);
		public void take_object (ClutterJson.JsonObject object);
		public unowned string type_name ();
	}
	[CCode (type_id = "CLUTTER_JSON_TYPE_JSON_OBJECT", cheader_filename = "clutter/json/json-glib.h")]
	public struct JsonObject {
		public void add_member (string member_name, ClutterJson.JsonNode node);
		public ClutterJson.JsonNode dup_member (string member_name);
		public void foreach_member ([CCode (delegate_target_pos = 0)] ClutterJson.JsonObjectForeach func);
		public ClutterJson.JsonArray get_array_member (string member_name);
		public bool get_boolean_member (string member_name);
		public double get_double_member (string member_name);
		public int get_int_member (string member_name);
		public ClutterJson.JsonNode get_member (string member_name);
		public GLib.List get_members ();
		public bool get_null_member (string member_name);
		public ClutterJson.JsonObject get_object_member (string member_name);
		public uint get_size ();
		public unowned string get_string_member (string member_name);
		public GLib.List get_values ();
		public bool has_member (string member_name);
		public ClutterJson.JsonObject @ref ();
		public void remove_member (string member_name);
		public void set_array_member (string member_name, ClutterJson.JsonArray value);
		public void set_boolean_member (string member_name, bool value);
		public void set_double_member (string member_name, double value);
		public void set_int_member (string member_name, int value);
		public void set_member (string member_name, ClutterJson.JsonNode node);
		public void set_null_member (string member_name);
		public void set_object_member (string member_name, ClutterJson.JsonObject value);
		public void set_string_member (string member_name, string value);
		public void unref ();
	}
	[CCode (type_id = "CLUTTER_JSON_TYPE_JSON_PARSER_PRIVATE", cheader_filename = "clutter/json/json-glib.h")]
	public struct JsonParserPrivate {
	}
	[CCode (cprefix = "JSON_NODE_", cheader_filename = "clutter/json/json-glib.h")]
	public enum JsonNodeType {
		OBJECT,
		ARRAY,
		VALUE,
		NULL
	}
	[CCode (cprefix = "JSON_PARSER_ERROR_", cheader_filename = "clutter/json/json-glib.h")]
	public enum JsonParserError {
		PARSE,
		UNKNOWN
	}
	[CCode (cprefix = "JSON_TOKEN_", cheader_filename = "clutter/json/json-glib.h")]
	public enum JsonTokenType {
		INVALID,
		TRUE,
		FALSE,
		NULL,
		LAST
	}
	[CCode (cheader_filename = "clutter/json/json-glib.h", has_target = false)]
	public delegate void JsonArrayForeach (ClutterJson.JsonArray array, uint index_, ClutterJson.JsonNode element_node, void* user_data);
	[CCode (cheader_filename = "clutter/json/json-glib.h", has_target = false)]
	public delegate void JsonObjectForeach (ClutterJson.JsonObject object, string member_name, ClutterJson.JsonNode member_node, void* user_data);
	[CCode (cheader_filename = "clutter/json/json-glib.h")]
	public static ClutterJson.JsonArray json_array_sized_new (uint n_elements);
}
