/* valavapigen.c generated by valac, the Vala compiler
 * generated from valavapigen.vala, do not modify */

/* valavapigen.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <valagee.h>
#include <config.h>


#define VALA_TYPE_VAPI_GEN (vala_vapi_gen_get_type ())
#define VALA_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGen))
#define VALA_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))
#define VALA_IS_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VAPI_GEN))
#define VALA_IS_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VAPI_GEN))
#define VALA_VAPI_GEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))

typedef struct _ValaVAPIGen ValaVAPIGen;
typedef struct _ValaVAPIGenClass ValaVAPIGenClass;
typedef struct _ValaVAPIGenPrivate ValaVAPIGenPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

#define VALA_TYPE_GIDL_PARSER (vala_gidl_parser_get_type ())
#define VALA_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParser))
#define VALA_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))
#define VALA_IS_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIDL_PARSER))
#define VALA_IS_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIDL_PARSER))
#define VALA_GIDL_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))

typedef struct _ValaGIdlParser ValaGIdlParser;
typedef struct _ValaGIdlParserClass ValaGIdlParserClass;
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _ValaVAPIGen {
	GObject parent_instance;
	ValaVAPIGenPrivate * priv;
};

struct _ValaVAPIGenClass {
	GObjectClass parent_class;
};

struct _ValaVAPIGenPrivate {
	ValaCodeContext* context;
};


static char* vala_vapi_gen_directory;
static char* vala_vapi_gen_directory = NULL;
static gboolean vala_vapi_gen_version;
static gboolean vala_vapi_gen_version = FALSE;
static gboolean vala_vapi_gen_quiet_mode;
static gboolean vala_vapi_gen_quiet_mode = FALSE;
static char** vala_vapi_gen_sources;
static char** vala_vapi_gen_sources = NULL;
static char** vala_vapi_gen_vapi_directories;
static char** vala_vapi_gen_vapi_directories = NULL;
static char* vala_vapi_gen_library;
static char* vala_vapi_gen_library = NULL;
static char** vala_vapi_gen_packages;
static char** vala_vapi_gen_packages = NULL;
static char* vala_vapi_gen_metadata_filename;
static char* vala_vapi_gen_metadata_filename = NULL;
static gpointer vala_vapi_gen_parent_class = NULL;

GType vala_vapi_gen_get_type (void);
#define VALA_VAPI_GEN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_VAPI_GEN, ValaVAPIGenPrivate))
enum  {
	VALA_VAPI_GEN_DUMMY_PROPERTY
};
static gint vala_vapi_gen_quit (ValaVAPIGen* self);
static gboolean vala_vapi_gen_add_package (ValaVAPIGen* self, const char* pkg);
static char** vala_vapi_gen_get_packages_from_depsfile (const char* depsfile, int* result_length1);
ValaGIdlParser* vala_gidl_parser_new (void);
ValaGIdlParser* vala_gidl_parser_construct (GType object_type);
GType vala_gidl_parser_get_type (void);
void vala_gidl_parser_parse (ValaGIdlParser* self, ValaCodeContext* context);
static gint vala_vapi_gen_run (ValaVAPIGen* self);
ValaVAPIGen* vala_vapi_gen_new (void);
ValaVAPIGen* vala_vapi_gen_construct (GType object_type);
static gint vala_vapi_gen_main (char** args, int args_length1);
static void vala_vapi_gen_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const GOptionEntry VALA_VAPI_GEN_options[] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_vapi_gen_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_vapi_gen_library, "Library name", "NAME"}, {"metadata", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_vapi_gen_metadata_filename, "Metadata filename", "FILE"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_vapi_gen_directory, "Output directory", "DIRECTORY"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_version, "Display version number", NULL}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_vapi_gen_quiet_mode, "Do not print messages to the console", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_sources, NULL, "FILE..."}, {NULL}};


static gint vala_vapi_gen_quit (ValaVAPIGen* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) == 0) {
		if (!vala_vapi_gen_quiet_mode) {
			fprintf (stdout, "Generation succeeded - %d warning(s)\n", vala_report_get_warnings (vala_code_context_get_report (self->priv->context)));
		}
		result = 0;
		return result;
	} else {
		if (!vala_vapi_gen_quiet_mode) {
			fprintf (stdout, "Generation failed: %d error(s), %d warning(s)\n", vala_report_get_errors (vala_code_context_get_report (self->priv->context)), vala_report_get_warnings (vala_code_context_get_report (self->priv->context)));
		}
		result = 1;
		return result;
	}
}


static char* string_strip (const char* self) {
	char* result;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static gboolean vala_vapi_gen_add_package (ValaVAPIGen* self, const char* pkg) {
	gboolean result;
	GError * _inner_error_;
	char* package_path;
	ValaSourceFile* _tmp0_;
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp3_;
	char* deps_filename;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (pkg != NULL, FALSE);
	_inner_error_ = NULL;
	if (vala_code_context_has_package (self->priv->context, pkg)) {
		result = TRUE;
		return result;
	}
	package_path = vala_code_context_get_package_path (self->priv->context, pkg, vala_vapi_gen_vapi_directories, _vala_array_length (vala_vapi_gen_vapi_directories));
	if (package_path == NULL) {
		result = FALSE;
		_g_free0 (package_path);
		return result;
	}
	vala_code_context_add_package (self->priv->context, pkg);
	vala_code_context_add_source_file (self->priv->context, _tmp0_ = vala_source_file_new (self->priv->context, package_path, TRUE, NULL));
	_vala_source_file_unref0 (_tmp0_);
	deps_filename = (_tmp3_ = g_build_filename (_tmp1_ = g_path_get_dirname (package_path), _tmp2_ = g_strdup_printf ("%s.deps", pkg), NULL), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _tmp3_);
	if (g_file_test (deps_filename, G_FILE_TEST_EXISTS)) {
		{
			char* deps_content;
			gulong deps_len = 0UL;
			char* _tmp6_;
			gboolean _tmp5_;
			char* _tmp4_ = NULL;
			deps_content = NULL;
			_tmp5_ = g_file_get_contents (deps_filename, &_tmp4_, &deps_len, &_inner_error_);
			deps_content = (_tmp6_ = _tmp4_, _g_free0 (deps_content), _tmp6_);
			_tmp5_;
			if (_inner_error_ != NULL) {
				_g_free0 (deps_content);
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch2_g_file_error;
				}
				goto __finally2;
			}
			{
				char** _tmp7_;
				char** dep_collection;
				int dep_collection_length1;
				int dep_it;
				dep_collection = _tmp7_ = g_strsplit (deps_content, "\n", 0);
				dep_collection_length1 = _vala_array_length (_tmp7_);
				for (dep_it = 0; dep_it < _vala_array_length (_tmp7_); dep_it = dep_it + 1) {
					char* dep;
					dep = g_strdup (dep_collection[dep_it]);
					{
						char* _tmp8_;
						dep = (_tmp8_ = string_strip (dep), _g_free0 (dep), _tmp8_);
						if (_vala_strcmp0 (dep, "") != 0) {
							if (!vala_vapi_gen_add_package (self, dep)) {
								char* _tmp9_;
								vala_report_error (NULL, _tmp9_ = g_strdup_printf ("%s, dependency of %s, not found in specified Vala API directories", dep, pkg));
								_g_free0 (_tmp9_);
							}
						}
						_g_free0 (dep);
					}
				}
				dep_collection = (_vala_array_free (dep_collection, dep_collection_length1, (GDestroyNotify) g_free), NULL);
			}
			_g_free0 (deps_content);
		}
		goto __finally2;
		__catch2_g_file_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				char* _tmp10_;
				vala_report_error (NULL, _tmp10_ = g_strdup_printf ("Unable to read dependency file: %s", e->message));
				_g_free0 (_tmp10_);
				_g_error_free0 (e);
			}
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_free0 (package_path);
			_g_free0 (deps_filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = TRUE;
	_g_free0 (package_path);
	_g_free0 (deps_filename);
	return result;
}


static char** vala_vapi_gen_get_packages_from_depsfile (const char* depsfile, int* result_length1) {
	char** result;
	GError * _inner_error_;
	g_return_val_if_fail (depsfile != NULL, NULL);
	_inner_error_ = NULL;
	{
		char* contents;
		char* _tmp2_;
		gboolean _tmp1_;
		char* _tmp0_ = NULL;
		char** _tmp4_;
		char* _tmp3_;
		char** _tmp5_;
		char** _tmp6_;
		contents = NULL;
		_tmp1_ = g_file_get_contents (depsfile, &_tmp0_, NULL, &_inner_error_);
		contents = (_tmp2_ = _tmp0_, _g_free0 (contents), _tmp2_);
		_tmp1_;
		if (_inner_error_ != NULL) {
			_g_free0 (contents);
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch3_g_file_error;
			}
			goto __finally3;
		}
		result = (_tmp6_ = (_tmp5_ = _tmp4_ = g_strsplit (_tmp3_ = string_strip (contents), "\n", 0), _g_free0 (_tmp3_), _tmp5_), *result_length1 = _vala_array_length (_tmp4_), _tmp6_);
		_g_free0 (contents);
		return result;
		_g_free0 (contents);
	}
	goto __finally3;
	__catch3_g_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			gpointer _tmp7_;
			result = (_tmp7_ = NULL, *result_length1 = 0, _tmp7_);
			_g_error_free0 (e);
			return result;
			_g_error_free0 (e);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static gint vala_vapi_gen_run (ValaVAPIGen* self) {
	gint result;
	ValaCodeContext* _tmp0_;
	char** _tmp13_;
	ValaParser* parser;
	ValaGirParser* girparser;
	ValaGIdlParser* gidlparser;
	ValaSymbolResolver* resolver;
	ValaSemanticAnalyzer* analyzer;
	gboolean _tmp14_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	self->priv->context = (_tmp0_ = vala_code_context_new (), _vala_code_context_unref0 (self->priv->context), _tmp0_);
	vala_code_context_set_profile (self->priv->context, VALA_PROFILE_GOBJECT);
	vala_code_context_push (self->priv->context);
	if (!vala_vapi_gen_add_package (self, "glib-2.0")) {
		vala_report_error (NULL, "glib-2.0 not found in specified Vala API directories");
	}
	if (!vala_vapi_gen_add_package (self, "gobject-2.0")) {
		vala_report_error (NULL, "gobject-2.0 not found in specified Vala API directories");
	}
	{
		char** source_collection;
		int source_collection_length1;
		int source_it;
		source_collection = vala_vapi_gen_sources;
		source_collection_length1 = _vala_array_length (vala_vapi_gen_sources);
		for (source_it = 0; source_it < _vala_array_length (vala_vapi_gen_sources); source_it = source_it + 1) {
			char* source;
			source = g_strdup (source_collection[source_it]);
			{
				char* _tmp1_;
				char* _tmp2_;
				char* depsfile;
				char** _tmp4_;
				gint deps_size;
				gint deps_length1;
				gint _tmp3_;
				char** deps;
				if (!g_str_has_suffix (source, ".gi")) {
					_g_free0 (source);
					continue;
				}
				depsfile = (_tmp2_ = g_strconcat (_tmp1_ = string_substring (source, (glong) 0, g_utf8_strlen (source, -1) - g_utf8_strlen ("gi", -1)), "deps", NULL), _g_free0 (_tmp1_), _tmp2_);
				if (!g_file_test (depsfile, G_FILE_TEST_EXISTS)) {
					_g_free0 (source);
					_g_free0 (depsfile);
					continue;
				}
				deps = (_tmp4_ = vala_vapi_gen_get_packages_from_depsfile (depsfile, &_tmp3_), deps_length1 = _tmp3_, deps_size = deps_length1, _tmp4_);
				{
					char** dep_collection;
					int dep_collection_length1;
					int dep_it;
					dep_collection = deps;
					dep_collection_length1 = deps_length1;
					for (dep_it = 0; dep_it < deps_length1; dep_it = dep_it + 1) {
						char* dep;
						dep = g_strdup (dep_collection[dep_it]);
						{
							if (!vala_vapi_gen_add_package (self, dep)) {
								char* _tmp5_;
								vala_report_error (NULL, _tmp5_ = g_strdup_printf ("%s not found in specified Vala API directories", dep));
								_g_free0 (_tmp5_);
							}
							_g_free0 (dep);
						}
					}
				}
				_g_free0 (source);
				_g_free0 (depsfile);
				deps = (_vala_array_free (deps, deps_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	if (vala_vapi_gen_library != NULL) {
		char* depsfile;
		depsfile = g_strconcat (vala_vapi_gen_library, ".deps", NULL);
		if (g_file_test (depsfile, G_FILE_TEST_EXISTS)) {
			char** _tmp7_;
			gint deps_size;
			gint deps_length1;
			gint _tmp6_;
			char** deps;
			deps = (_tmp7_ = vala_vapi_gen_get_packages_from_depsfile (depsfile, &_tmp6_), deps_length1 = _tmp6_, deps_size = deps_length1, _tmp7_);
			{
				char** dep_collection;
				int dep_collection_length1;
				int dep_it;
				dep_collection = deps;
				dep_collection_length1 = deps_length1;
				for (dep_it = 0; dep_it < deps_length1; dep_it = dep_it + 1) {
					char* dep;
					dep = g_strdup (dep_collection[dep_it]);
					{
						if (!vala_vapi_gen_add_package (self, dep)) {
							char* _tmp8_;
							vala_report_error (NULL, _tmp8_ = g_strdup_printf ("%s not found in specified Vala API directories", dep));
							_g_free0 (_tmp8_);
						}
						_g_free0 (dep);
					}
				}
			}
			deps = (_vala_array_free (deps, deps_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (depsfile);
	}
	if (vala_vapi_gen_packages != NULL) {
		char** _tmp10_;
		{
			char** package_collection;
			int package_collection_length1;
			int package_it;
			package_collection = vala_vapi_gen_packages;
			package_collection_length1 = _vala_array_length (vala_vapi_gen_packages);
			for (package_it = 0; package_it < _vala_array_length (vala_vapi_gen_packages); package_it = package_it + 1) {
				char* package;
				package = g_strdup (package_collection[package_it]);
				{
					if (!vala_vapi_gen_add_package (self, package)) {
						char* _tmp9_;
						vala_report_error (NULL, _tmp9_ = g_strdup_printf ("%s not found in specified Vala API directories", package));
						_g_free0 (_tmp9_);
					}
					_g_free0 (package);
				}
			}
		}
		vala_vapi_gen_packages = (_tmp10_ = NULL, vala_vapi_gen_packages = (_vala_array_free (vala_vapi_gen_packages, _vala_array_length (vala_vapi_gen_packages), (GDestroyNotify) g_free), NULL), _tmp10_);
	}
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	{
		char** source_collection;
		int source_collection_length1;
		int source_it;
		source_collection = vala_vapi_gen_sources;
		source_collection_length1 = _vala_array_length (vala_vapi_gen_sources);
		for (source_it = 0; source_it < _vala_array_length (vala_vapi_gen_sources); source_it = source_it + 1) {
			char* source;
			source = g_strdup (source_collection[source_it]);
			{
				if (g_file_test (source, G_FILE_TEST_EXISTS)) {
					ValaSourceFile* _tmp11_;
					vala_code_context_add_source_file (self->priv->context, _tmp11_ = vala_source_file_new (self->priv->context, source, TRUE, NULL));
					_vala_source_file_unref0 (_tmp11_);
				} else {
					char* _tmp12_;
					vala_report_error (NULL, _tmp12_ = g_strdup_printf ("%s not found", source));
					_g_free0 (_tmp12_);
				}
				_g_free0 (source);
			}
		}
	}
	vala_vapi_gen_sources = (_tmp13_ = NULL, vala_vapi_gen_sources = (_vala_array_free (vala_vapi_gen_sources, _vala_array_length (vala_vapi_gen_sources), (GDestroyNotify) g_free), NULL), _tmp13_);
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	parser = vala_parser_new ();
	vala_parser_parse (parser, self->priv->context);
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	girparser = vala_gir_parser_new ();
	if (vala_vapi_gen_metadata_filename != NULL) {
		vala_gir_parser_parse_metadata (girparser, vala_vapi_gen_metadata_filename);
	}
	vala_gir_parser_parse (girparser, self->priv->context);
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (parser);
		_vala_code_visitor_unref0 (girparser);
		return result;
	}
	gidlparser = vala_gidl_parser_new ();
	vala_gidl_parser_parse (gidlparser, self->priv->context);
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (parser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (gidlparser);
		return result;
	}
	resolver = vala_symbol_resolver_new ();
	vala_symbol_resolver_resolve (resolver, self->priv->context);
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (parser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (resolver);
		return result;
	}
	analyzer = vala_semantic_analyzer_new ();
	vala_semantic_analyzer_analyze (analyzer, self->priv->context);
	if (vala_report_get_errors (vala_code_context_get_report (self->priv->context)) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (parser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (resolver);
		_vala_code_visitor_unref0 (analyzer);
		return result;
	}
	if (vala_vapi_gen_library == NULL) {
		gint _tmp16__length1;
		char** _tmp16_;
		gint _tmp15_;
		_tmp14_ = (_tmp16_ = vala_gir_parser_get_package_names (girparser, &_tmp15_), _tmp16__length1 = _tmp15_, _tmp16_) != NULL;
		_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		char** _tmp18_;
		gint names_size;
		gint names_length1;
		gint _tmp17_;
		char** names;
		char* _tmp19_;
		names = (_tmp18_ = vala_gir_parser_get_package_names (girparser, &_tmp17_), names_length1 = _tmp17_, names_size = names_length1, _tmp18_);
		if (names_length1 != 1) {
			vala_report_error (NULL, "multiple packages encountered and no library name given");
			result = vala_vapi_gen_quit (self);
			names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
			_vala_code_visitor_unref0 (parser);
			_vala_code_visitor_unref0 (girparser);
			_vala_code_visitor_unref0 (gidlparser);
			_vala_code_visitor_unref0 (resolver);
			_vala_code_visitor_unref0 (analyzer);
			return result;
		}
		vala_vapi_gen_library = (_tmp19_ = g_strdup (names[0]), _g_free0 (vala_vapi_gen_library), _tmp19_);
		names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	}
	if (vala_vapi_gen_library != NULL) {
		ValaCodeWriter* interface_writer;
		char* _tmp22_;
		char* _tmp23_;
		{
			ValaList* _tmp20_;
			ValaIterator* _tmp21_;
			ValaIterator* _file_it;
			_file_it = (_tmp21_ = vala_iterable_iterator ((ValaIterable*) (_tmp20_ = vala_code_context_get_source_files (self->priv->context))), _vala_collection_object_unref0 (_tmp20_), _tmp21_);
			while (TRUE) {
				ValaSourceFile* file;
				if (!vala_iterator_next (_file_it)) {
					break;
				}
				file = (ValaSourceFile*) vala_iterator_get (_file_it);
				if (!g_str_has_suffix (vala_source_file_get_filename (file), ".vapi")) {
					vala_source_file_set_external_package (file, FALSE);
				}
				_vala_source_file_unref0 (file);
			}
			_vala_collection_object_unref0 (_file_it);
		}
		interface_writer = vala_code_writer_new (FALSE, FALSE);
		vala_code_writer_write_file (interface_writer, self->priv->context, _tmp22_ = g_strdup_printf ("%s.vapi", vala_vapi_gen_library));
		_g_free0 (_tmp22_);
		vala_vapi_gen_library = (_tmp23_ = NULL, _g_free0 (vala_vapi_gen_library), _tmp23_);
		_vala_code_visitor_unref0 (interface_writer);
	}
	result = vala_vapi_gen_quit (self);
	_vala_code_visitor_unref0 (parser);
	_vala_code_visitor_unref0 (girparser);
	_vala_code_visitor_unref0 (gidlparser);
	_vala_code_visitor_unref0 (resolver);
	_vala_code_visitor_unref0 (analyzer);
	return result;
}


static gint vala_vapi_gen_main (char** args, int args_length1) {
	gint result;
	GError * _inner_error_;
	ValaVAPIGen* vapigen;
	_inner_error_ = NULL;
	{
		GOptionContext* opt_context;
		opt_context = g_option_context_new ("- Vala API Generator");
		g_option_context_set_help_enabled (opt_context, TRUE);
		g_option_context_add_main_entries (opt_context, VALA_VAPI_GEN_options, NULL);
		g_option_context_parse (opt_context, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch4_g_option_error;
			}
			goto __finally4;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally4;
	__catch4_g_option_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stdout, "%s\n", e->message);
			fprintf (stdout, "Run '%s --help' to see a full list of available command line options.\n", args[0]);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (vala_vapi_gen_version) {
		fprintf (stdout, "Vala API Generator %s\n", PACKAGE_VERSION);
		result = 0;
		return result;
	}
	if (vala_vapi_gen_sources == NULL) {
		fprintf (stderr, "No source file specified.\n");
		result = 1;
		return result;
	}
	vapigen = vala_vapi_gen_new ();
	result = vala_vapi_gen_run (vapigen);
	_g_object_unref0 (vapigen);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return vala_vapi_gen_main (argv, argc);
}


ValaVAPIGen* vala_vapi_gen_construct (GType object_type) {
	ValaVAPIGen * self;
	self = (ValaVAPIGen*) g_object_new (object_type, NULL);
	return self;
}


ValaVAPIGen* vala_vapi_gen_new (void) {
	return vala_vapi_gen_construct (VALA_TYPE_VAPI_GEN);
}


static void vala_vapi_gen_class_init (ValaVAPIGenClass * klass) {
	vala_vapi_gen_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaVAPIGenPrivate));
	G_OBJECT_CLASS (klass)->finalize = vala_vapi_gen_finalize;
}


static void vala_vapi_gen_instance_init (ValaVAPIGen * self) {
	self->priv = VALA_VAPI_GEN_GET_PRIVATE (self);
}


static void vala_vapi_gen_finalize (GObject* obj) {
	ValaVAPIGen * self;
	self = VALA_VAPI_GEN (obj);
	_vala_code_context_unref0 (self->priv->context);
	G_OBJECT_CLASS (vala_vapi_gen_parent_class)->finalize (obj);
}


GType vala_vapi_gen_get_type (void) {
	static GType vala_vapi_gen_type_id = 0;
	if (vala_vapi_gen_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaVAPIGenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_vapi_gen_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaVAPIGen), 0, (GInstanceInitFunc) vala_vapi_gen_instance_init, NULL };
		vala_vapi_gen_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaVAPIGen", &g_define_type_info, 0);
	}
	return vala_vapi_gen_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




