/* X-Chat
 * Copyright (C) 1998 Peter Zelezny.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "xchat.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <fcntl.h>
#include "cfgfiles.h"
#include "gtkutil.h"


extern GSList *fkey_list;

extern int waitline(int sok, char *buf, int bufsize);


GtkWidget *fkey_entries[10];



void fkeys_save(void)
{
   int fh;
   GSList *list;
   char tbuf[256];

   snprintf(tbuf, sizeof tbuf, "%s/fkeys.conf", get_xdir());

   fh = open(tbuf, O_TRUNC | O_WRONLY | O_CREAT, 0600);
   if(fh != -1)
   {
      list = fkey_list;
      while(list)
      {
	 char *macro = (char *)list -> data;
	 write(fh, macro, strlen(macro));
	 write(fh, "\n", 1);
	 list = list -> next;
      }
      close(fh);
   } 
}

void fkeys_apply_button(GtkWidget *button, GtkWidget *win)
{
   int i = 0;
   GSList *list = fkey_list;

   while(list)
   {
      free(list -> data);
      list -> data = strdup(gtk_entry_get_text(GTK_ENTRY(fkey_entries[i])));
      i++;
      if(i == 10) break;
      list = list -> next;
   }
   gtk_widget_destroy(win);
}

void fkeys_save_button(GtkWidget *button, GtkWidget *win)
{
   fkeys_apply_button(0, win);
   fkeys_save();
}

void fkeys_edit(void)
{
   int i;
   char tbuf[16];
   GSList *list = fkey_list;
   GtkWidget *win, *wid, *vbox, *hbox;

   win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_window_set_title(GTK_WINDOW(win), "X-Chat: Function Keys");
   gtk_widget_set_usize(win, 300, 0);
   gtk_window_set_wmclass(GTK_WINDOW(win), "fkeys", "X-Chat");


   vbox = gtk_vbox_new(FALSE, 2);
   gtk_container_set_border_width(GTK_CONTAINER(vbox), 4);
   gtk_container_add(GTK_CONTAINER(win), vbox);
   gtk_widget_show(vbox);

   for(i=1; i<11; i++)
   {
      char *macros = 0;

      if(list) macros = list -> data;

      hbox = gtk_hbox_new(0, 0);
      gtk_container_add(GTK_CONTAINER(vbox), hbox);
      gtk_widget_show(hbox);

      if(i == 10)
	wid = gtk_label_new("F0:");
      else {
	 sprintf(tbuf, "F%d:", i);
	 wid = gtk_label_new(tbuf);
      }
      gtk_box_pack_start(GTK_BOX(hbox), wid, 0, 0, 5);
      gtk_widget_show(wid);

      wid = gtk_entry_new_with_max_length(80);
      fkey_entries[i-1] = wid;
      if(list) gtk_entry_set_text(GTK_ENTRY(wid), macros);
      gtk_container_add(GTK_CONTAINER(hbox), wid);
      gtk_widget_show(wid);

      if(list) list = list -> next;
   }

   wid = gtk_hseparator_new();
   gtk_box_pack_start(GTK_BOX(vbox), wid, 0, 0, 5);
   gtk_widget_show(wid);

   hbox = gtk_hbox_new(0, 0);
   gtk_box_pack_start(GTK_BOX(vbox), hbox, 0, 0, 0);
   gtk_widget_show(hbox);
   
#ifdef USE_GNOME
   gtkutil_stock_button(win, GNOME_STOCK_BUTTON_CANCEL, "Cancel",
				 gtkutil_destroy, win, hbox);
   gtkutil_stock_button(win, GNOME_STOCK_BUTTON_APPLY, "Apply",
				 fkeys_apply_button, win, hbox);
   gtkutil_stock_button(win, GNOME_STOCK_PIXMAP_SAVE, "Save",
				 fkeys_save_button, win, hbox);
#else
   gtkutil_button_new("Cancel", 0, 0, gtkutil_destroy, win, hbox);
   gtkutil_button_new("Apply", 0, 0, fkeys_apply_button, win, hbox);
   gtkutil_button_new("Save", 0, 0, fkeys_save_button, win, hbox);
#endif

   gtk_widget_show(win);
}

void fkeys_load(void)
{
   int fh, j, i = 0;
   char tbuf[256];

   snprintf(tbuf, sizeof tbuf, "%s/fkeys.conf", get_xdir());

   fh = open(tbuf, O_RDONLY);
   if(fh != -1)
   {
      while( waitline(fh, tbuf, sizeof tbuf) != -1)
      {
	 char *macro = strdup(tbuf);
	 i++;
	 fkey_list = g_slist_append(fkey_list, macro);
      }
      close(fh);
   }
   for(j=i; j<10; j++)
   {
      char *macro = malloc(1);
      *macro = 0;
      fkey_list = g_slist_append(fkey_list, macro);
   }
}
