/* X-Chat
 * Copyright (C) 1998 Peter Zelezny.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "xchat.h"
#include <fcntl.h>
#include "gtkutil.h"
#ifdef USE_IMLIB
#include <gdk_imlib.h>
#endif
#include "cfgfiles.h"

extern struct xchatprefs prefs;
extern GdkColor colors[];
extern GdkFont *font_normal;
extern GdkFont *font_bold;
extern GdkFont *dialog_font_normal;
extern GdkFont *dialog_font_bold;
extern GSList *sess_list;
extern gint notify_tag;
extern GtkStyle *channelwin_style;
extern GtkStyle *dialogwin_style;
extern GtkWidget *main_window, *main_book;

extern void add_tip(GtkWidget *, char *);
extern void maingui_updatebuttons(struct session *sess);
extern GdkFont *my_font_load(char *fontname);
extern void check_homedir(char *file);
extern void maingui_create_textlist(struct session *sess, GtkWidget *leftpane);
extern void size_request_textgad(GtkWidget *win, GtkRequisition *req);
extern void notify_checklist(void);
extern void path_part(char *file, char *path);
extern GtkStyle *my_widget_get_style(char *bg_pic, int bg_color);
extern void zvt_set_style(GtkWidget *zvt, char *bg_pic, int trans, int tint,
		   GdkFont *norm_font, GdkFont *bold_font);

void gui_entry(char *label, int max, GtkWidget *box, char *def, char *suffix, GtkWidget **entry, void *suffixcallback);
GtkWidget *gui_toggle(char *label, GtkWidget *box, int state, void *callback, struct session *sess);



int settings_closegui(GtkWidget *wid, struct session *sess)
{
   if(sess->setup)
   {
      free(sess->setup);
      sess->setup = 0;
   }
   return 0;
}

void settings_ok_clicked(GtkWidget *wid, struct session *sess)
{
   int channelwinchange = FALSE;
   int dialogwinchange = FALSE;
   int noapply = FALSE;

   strcpy(sess->setup->prefs.background, gtk_entry_get_text(GTK_ENTRY(sess->setup->background)));
   check_homedir(sess->setup->prefs.background);
   strcpy(sess->setup->prefs.background_dialog, gtk_entry_get_text(GTK_ENTRY(sess->setup->background_dialog)));
   check_homedir(sess->setup->prefs.background_dialog);
   strcpy(sess->setup->prefs.soundcmd, gtk_entry_get_text(GTK_ENTRY(sess->setup->entry_soundcmd)));
   strcpy(sess->setup->prefs.sounddir, gtk_entry_get_text(GTK_ENTRY(sess->setup->entry_sounddir)));

   strcpy(sess->setup->prefs.bluestring, gtk_entry_get_text((GtkEntry*)sess->setup->entry_bluestring));
   strcpy(sess->setup->prefs.doubleclickuser, gtk_entry_get_text((GtkEntry*)sess->setup->entry_doubleclickuser));
   strcpy(sess->setup->prefs.awayreason, gtk_entry_get_text((GtkEntry*)sess->setup->entry_away));
   strcpy(sess->setup->prefs.quitreason, gtk_entry_get_text((GtkEntry*)sess->setup->entry_quit));
   sess->setup->prefs.bufsize = atol(gtk_entry_get_text((GtkEntry*)sess->setup->entry_bufsize));
   sess->setup->prefs.zvt_lines = atoi(gtk_entry_get_text((GtkEntry*)sess->setup->entry_zvt_lines));
   sess->setup->prefs.notify_timeout = atol(gtk_entry_get_text((GtkEntry*)sess->setup->entry_timeout));

   
   sscanf(gtk_entry_get_text((GtkEntry*)sess->setup->entry_permissions),
	  "%o", &sess->setup->prefs.dccpermissions);
   
   sess->setup->prefs.dccstalltimeout = atoi(gtk_entry_get_text((GtkEntry*)sess->setup->entry_dccstalltimeout));
   sess->setup->prefs.dcctimeout = atoi(gtk_entry_get_text((GtkEntry*)sess->setup->entry_dcctimeout));
   strcpy(sess->setup->prefs.dccdir, gtk_entry_get_text(GTK_ENTRY(sess->setup->entry_dccdir)));
   check_homedir(sess->setup->prefs.dccdir);

   strcpy(sess->setup->prefs.font_normal, gtk_entry_get_text(GTK_ENTRY(sess->setup->font_normal)));
   strcpy(sess->setup->prefs.font_bold, gtk_entry_get_text(GTK_ENTRY(sess->setup->font_bold)));
   strcpy(sess->setup->prefs.dialog_font_normal, gtk_entry_get_text(GTK_ENTRY(sess->setup->dialog_font_normal)));
   strcpy(sess->setup->prefs.dialog_font_bold, gtk_entry_get_text(GTK_ENTRY(sess->setup->dialog_font_bold)));

   sess->setup->prefs.mainwindow_left = atoi(gtk_entry_get_text(GTK_ENTRY(sess->setup->entry_mainw_left)));
   sess->setup->prefs.mainwindow_top = atoi(gtk_entry_get_text(GTK_ENTRY(sess->setup->entry_mainw_top)));
   sess->setup->prefs.mainwindow_width = atoi(gtk_entry_get_text(GTK_ENTRY(sess->setup->entry_mainw_width)));
   sess->setup->prefs.mainwindow_height = atoi(gtk_entry_get_text(GTK_ENTRY(sess->setup->entry_mainw_height)));

   if(sess->setup->prefs.notify_timeout != prefs.notify_timeout)
   {
      if(notify_tag != -1) gtk_timeout_remove(notify_tag);
      if(sess->setup->prefs.notify_timeout)
	notify_tag = gtk_timeout_add(sess->setup->prefs.notify_timeout,
				     (GtkFunction) notify_checklist, 0);
   }

   if(strcmp(prefs.font_normal, sess->setup->prefs.font_normal) != 0)
     font_normal = my_font_load(sess->setup->prefs.font_normal);

   if(strcmp(prefs.font_bold,   sess->setup->prefs.font_bold) != 0)
     font_bold = my_font_load(sess->setup->prefs.font_bold);

   if(strcmp(prefs.dialog_font_normal, sess->setup->prefs.dialog_font_normal) != 0)
     dialog_font_normal = my_font_load(sess->setup->prefs.dialog_font_normal);

   if(strcmp(prefs.dialog_font_bold,   sess->setup->prefs.dialog_font_bold) != 0)
     dialog_font_bold = my_font_load(sess->setup->prefs.dialog_font_bold);

   if(prefs.tabchannels != sess->setup->prefs.tabchannels)
     noapply = TRUE;

   if(prefs.nopaned != sess->setup->prefs.nopaned)
     noapply = TRUE;

   if(prefs.nouserlistbuttons != sess->setup->prefs.nouserlistbuttons)
     channelwinchange = TRUE;

   if(prefs.nochanmodebuttons != sess->setup->prefs.nochanmodebuttons)
     noapply = TRUE;

   if(prefs.zvt != sess->setup->prefs.zvt || prefs.dialog_zvt != sess->setup->prefs.dialog_zvt)
     noapply = TRUE;

   if(prefs.tint != sess->setup->prefs.tint || prefs.dialog_tint != sess->setup->prefs.dialog_tint)
     channelwinchange = TRUE;

   if(prefs.transparent != sess->setup->prefs.transparent || prefs.dialog_transparent != sess->setup->prefs.dialog_transparent)
     channelwinchange = TRUE;

   if(strcmp(prefs.background, sess->setup->prefs.background) != 0)
     channelwinchange = TRUE;

   if(prefs.bg_color != sess->setup->prefs.bg_color)
     channelwinchange = TRUE;

   if(strcmp(prefs.background_dialog, sess->setup->prefs.background_dialog) != 0)
     dialogwinchange = TRUE;

   if(prefs.dialog_bg_color != sess->setup->prefs.dialog_bg_color)
     dialogwinchange = TRUE;

   if(prefs.nu_color != sess->setup->prefs.nu_color)
     {channelwinchange = TRUE; noapply = TRUE;}

   if(prefs.panel_vbox != sess->setup->prefs.panel_vbox)
     noapply = TRUE;

   memcpy(&prefs, &sess->setup->prefs, sizeof(struct xchatprefs));

   if(main_window)
   {
      if(prefs.tabsatbottom)
	gtk_notebook_set_tab_pos((GtkNotebook*)main_book, GTK_POS_BOTTOM);
      else
	gtk_notebook_set_tab_pos((GtkNotebook*)main_book, GTK_POS_TOP);
   }

   if(channelwinchange)
   {
      GtkStyle *old_style = channelwin_style;
      struct session *s;
      GSList *list = sess_list;

      channelwin_style = my_widget_get_style(prefs.background, prefs.bg_color);

      while(list)
      {
	 s = (struct session *)list->data;
	 if (!s->is_dialog) {
#ifdef USE_GNOME
	    if(s->zvt)
	    {
	       zvt_set_style(s->textgad, prefs.background, prefs.transparent,
			     prefs.tint, font_normal, font_bold);
	    } else {
#endif
	       gtk_widget_set_style(s->textgad, channelwin_style);
#ifdef USE_GNOME
	    }
#endif
	    maingui_updatebuttons(s);
	 }
	 list = list -> next;
      }
      if(old_style)
      {
	 if(old_style->bg_pixmap[GTK_STATE_NORMAL])
#ifdef USE_IMLIB	
	   gdk_imlib_free_pixmap(old_style->bg_pixmap[GTK_STATE_NORMAL]);
#else
	   gdk_pixmap_unref(old_style->bg_pixmap[GTK_STATE_NORMAL]);
#endif
	 gtk_style_unref(old_style);
      }
   }

   if(dialogwinchange)
   {
      GtkStyle *old_style = dialogwin_style;
      struct session *s;
      GSList *list = sess_list;

      dialogwin_style = my_widget_get_style(prefs.background_dialog, prefs.dialog_bg_color);

      while(list)
      {
	 s = (struct session *)list->data;
	 if(sess->is_dialog)
	 {
#ifdef USE_GNOME
	    if(s->zvt)
	    {
	       zvt_set_style(s->textgad, prefs.background_dialog, prefs.dialog_transparent,
			     prefs.dialog_tint, dialog_font_normal, dialog_font_bold);
	    } else {
#endif
	       gtk_widget_set_style(s->textgad, dialogwin_style);
#ifdef USE_GNOME
	    }
#endif
	 }
	 list = list -> next;
      }
      if(old_style)
      {
	 if(old_style->bg_pixmap[GTK_STATE_NORMAL])
#ifdef USE_IMLIB        
	   gdk_imlib_free_pixmap(old_style->bg_pixmap[GTK_STATE_NORMAL]);
#else
   	   gdk_pixmap_unref(old_style->bg_pixmap[GTK_STATE_NORMAL]);
#endif
	 gtk_style_unref(old_style);
      }
   }

   if(wid)
     gtk_widget_destroy(sess->setup->settings_window);
   else
     gtk_widget_set_sensitive(sess->setup->cancel_button, FALSE);

   if(noapply)
     gtkutil_simpledialog("The following prefs do not take effect\n"
		       "immediately, you will have to close the\n"
		       "window and re-open it:\n\n"
		       " - ZVT On/Off\n"
		       " - Channel Tabs\n"
		       " - Channel Mode Buttons\n"
		       " - Userlist Buttons\n"
		       " - Disable Paned Userlist\n"
		       " - Tabs At Bottom On/Off\n"
		       " - Notify User color\n"
		       " - Layout for a vertical panel");
}

void settings_apply_clicked(GtkWidget *wid, struct session *sess)
{
   settings_ok_clicked(0, sess);
}

void color_clicked(GtkWidget *igad, GtkWidget *colgad, char *colset)
{
   GtkStyle *stylefg = gtk_style_new();
   char buf[16];
   int col = atoi(gtk_entry_get_text(GTK_ENTRY(igad)));
   if(col < 0 || col > 15) col = 0;
   sprintf(buf, "%d", col);
   gtk_entry_set_text(GTK_ENTRY(igad), buf);
   stylefg->bg[0] = colors[col];
   gtk_widget_set_style(colgad, stylefg);
   *colset = col; 
}

void dialog_fg_color_clicked(GtkWidget *igad, struct session *sess)
{
   color_clicked(igad, sess->setup->dialog_fg_color, &sess->setup->prefs.dialog_fg_color);
}

void dialog_bg_color_clicked(GtkWidget *igad, struct session *sess)
{
   color_clicked(igad, sess->setup->dialog_bg_color, &sess->setup->prefs.dialog_bg_color);
}

void fg_color_clicked(GtkWidget *igad, struct session *sess)
{
   color_clicked(igad, sess->setup->fg_color, &sess->setup->prefs.fg_color);
}

void bg_color_clicked(GtkWidget *igad, struct session *sess)
{
   color_clicked(igad, sess->setup->bg_color, &sess->setup->prefs.bg_color);
}

void nu_color_clicked(GtkWidget *igad, struct session *sess)
{
   color_clicked(igad, sess->setup->nu_color, &sess->setup->prefs.nu_color);
}

void bt_color_clicked(GtkWidget *igad, struct session *sess)
{
   color_clicked(igad, sess->setup->bt_color, &sess->setup->prefs.bt_color);
}

void settings_dialogzvt_check(GtkWidget *widget, struct session *sess)
{
   if (GTK_TOGGLE_BUTTON (widget)->active)
   {
      sess->setup->prefs.dialog_zvt = TRUE;
      gtk_widget_set_sensitive(sess->setup->dialog_check_transparent, TRUE);
      if(sess->setup->prefs.dialog_transparent)
      {
	 gtk_widget_set_sensitive(sess->setup->dialog_check_tint, TRUE);
	 gtk_widget_set_sensitive(sess->setup->background_dialog, FALSE);
      }
   } else {
      gtk_widget_set_sensitive(sess->setup->dialog_check_transparent, FALSE);
      gtk_widget_set_sensitive(sess->setup->dialog_check_tint, FALSE);
      gtk_widget_set_sensitive(sess->setup->background_dialog, TRUE);
      sess->setup->prefs.dialog_zvt = FALSE;
   }
}

void settings_zvt_check(GtkWidget *widget, struct session *sess)
{
   if (GTK_TOGGLE_BUTTON (widget)->active)
   {
      sess->setup->prefs.zvt = TRUE;
      gtk_widget_set_sensitive(sess->setup->check_transparent, TRUE);
      if(sess->setup->prefs.transparent)
      {
	 gtk_widget_set_sensitive(sess->setup->check_tint, TRUE);
	 gtk_widget_set_sensitive(sess->setup->background, FALSE);
      }
   } else {
      gtk_widget_set_sensitive(sess->setup->check_transparent, FALSE);
      gtk_widget_set_sensitive(sess->setup->check_tint, FALSE);
      gtk_widget_set_sensitive(sess->setup->background, TRUE);
      sess->setup->prefs.zvt = FALSE;
   }
}

void settings_noserverlogs_check(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.no_server_logs = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}

void settings_showawayonce_check(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.show_away_once = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}

void settings_rawmodes_check(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.raw_modes = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}

void settings_ip_check(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.get_ip_from_server = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}

void settings_newtabstofront_check(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.newtabstofront = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}

void settings_tabsatbottom_check(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.tabsatbottom = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}

void settings_beep_check(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.filterbeep = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}

void settings_beepmsg_check(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.beepmsg = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}

void settings_logging_check(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.logging = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}

void settings_hidever(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.hidever = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}

void settings_fastdccsend_check(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.fastdccsend = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}

void settings_dccwithnick_check(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.dccwithnick = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}

void settings_hilitenotify_check(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.hilitenotify = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}

void settings_timestamp_check(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.timestamp = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}

void settings_strip_check(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.stripcolor = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}

void settings_sendwin_check(GtkWidget *widget, struct session *sess)
{
   if (GTK_TOGGLE_BUTTON (widget)->active)
      sess->setup->prefs.noautoopendccsendwindow = FALSE;
   else
      sess->setup->prefs.noautoopendccsendwindow = TRUE;
}

void settings_recvwin_check(GtkWidget *widget, struct session *sess)
{
   if (GTK_TOGGLE_BUTTON (widget)->active)
      sess->setup->prefs.noautoopendccrecvwindow = FALSE;
   else
      sess->setup->prefs.noautoopendccrecvwindow = TRUE;
}

void settings_nopaned_check(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.nopaned = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}

void settings_tabchannels_check(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.tabchannels = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}

void settings_privmsgtab_check(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.privmsgtab = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}

void settings_nickcompletion_check(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.nickcompletion = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}

void settings_tab_check(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.tabnicks = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}

void settings_skipserverlist_check(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.skipserverlist = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}

void settings_colored_check(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.colorednicks = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}

#ifdef USE_PANEL
void settings_panelize_hide_check(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.panelize_hide = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}
void settings_panel_vbox_check(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.panel_vbox = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}
#endif

void settings_chanbut_check(GtkWidget *widget, struct session *sess)
{
   if (GTK_TOGGLE_BUTTON (widget)->active)
      sess->setup->prefs.nochanmodebuttons = FALSE;
   else
      sess->setup->prefs.nochanmodebuttons = TRUE;
}

void settings_userlistbut_check(GtkWidget *widget, struct session *sess)
{
   if (GTK_TOGGLE_BUTTON (widget)->active)
      sess->setup->prefs.nouserlistbuttons = FALSE;
   else
      sess->setup->prefs.nouserlistbuttons = TRUE;
}

void settings_transparent(GtkWidget *widget, struct session *sess)
{
   if (GTK_TOGGLE_BUTTON (widget)->active)
   {
      sess->setup->prefs.transparent = TRUE;
      gtk_widget_set_sensitive(sess->setup->background, FALSE);
      gtk_widget_set_sensitive(sess->setup->check_tint, TRUE);
   } else {
      sess->setup->prefs.transparent = FALSE;
      gtk_widget_set_sensitive(sess->setup->background, TRUE);
      gtk_widget_set_sensitive(sess->setup->check_tint, FALSE);
   }
}

void settings_transparent_dialog(GtkWidget *widget, struct session *sess)
{
   if (GTK_TOGGLE_BUTTON (widget)->active)
   {
      sess->setup->prefs.dialog_transparent = TRUE;
      gtk_widget_set_sensitive(sess->setup->background_dialog, FALSE);
      gtk_widget_set_sensitive(sess->setup->dialog_check_tint, TRUE);
   } else {
      sess->setup->prefs.dialog_transparent = FALSE;
      gtk_widget_set_sensitive(sess->setup->background_dialog, TRUE);
      gtk_widget_set_sensitive(sess->setup->dialog_check_tint, FALSE);
   }
}

void settings_tint(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.tint = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}

void settings_tint_dialog(GtkWidget *widget, struct session *sess)
{
   sess->setup->prefs.dialog_tint = (int)(GTK_TOGGLE_BUTTON(widget)->active);
}

GtkWidget *fontdialog = 0;

void settings_filereq_done(GtkWidget *entry, void *data2, char *file)
{
   if(file)
   {
      if(file[0]) gtk_entry_set_text(GTK_ENTRY(entry), file);
      free(file);
   }
}

void settings_openfiledialog(GtkWidget *button, GtkWidget *entry)
{    
#ifdef USE_IMLIB
   gtkutil_file_req("Choose Picture", settings_filereq_done, entry, 0, FALSE);
#else
   gtkutil_file_req("Choose XPM", settings_filereq_done, entry, 0, FALSE);
#endif
}

void settings_fontok(GtkWidget *ok_button, GtkWidget *entry)
{
   gchar *fontname;

   fontname = gtk_font_selection_dialog_get_font_name(GTK_FONT_SELECTION_DIALOG(fontdialog));
   if(fontname && fontname[0])
   {
      gtk_entry_set_text(GTK_ENTRY(entry), fontname);
   }
   gtk_widget_destroy(fontdialog);
   fontdialog = 0;
}

void settings_openfontdialog(GtkWidget *button, GtkWidget *entry)
{
   GtkWidget *dialog;

   dialog = gtk_font_selection_dialog_new("Select Font");
   gtk_signal_connect(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(dialog)->ok_button), "clicked",
		      GTK_SIGNAL_FUNC(settings_fontok), entry);
   gtk_signal_connect(GTK_OBJECT(GTK_FONT_SELECTION_DIALOG(dialog)->cancel_button), "clicked",
		      GTK_SIGNAL_FUNC(gtkutil_destroy), dialog);
   gtk_font_selection_dialog_set_font_name(GTK_FONT_SELECTION_DIALOG(dialog), gtk_entry_get_text(GTK_ENTRY(entry)));
   fontdialog = dialog;
   gtk_widget_show(dialog);
}

void settings_create_color_box(GtkWidget *vvbox,
			       char *label,
			       GtkWidget **color_wid,
			       int initcolor,
			       void *callback,
			       struct session *sess)
{
   GtkStyle *style;
   GtkWidget *hbox, *wid;
   char buf[16];

   hbox = gtk_hbox_new(0, 5);
   gtk_container_set_border_width(GTK_CONTAINER(hbox), 3);
   gtk_box_pack_start(GTK_BOX(vvbox), hbox, 0, 0, 0);
   gtk_widget_show(hbox);

   wid = gtk_label_new(label);
   gtk_widget_set_usize(wid, 132, 0);
   gtk_misc_set_alignment(GTK_MISC(wid), 1, 0.5);
   gtk_box_pack_start(GTK_BOX(hbox), wid, 0, 0, 0);
   gtk_widget_show(wid);

   wid = gtk_entry_new();
   sprintf(buf, "%d", initcolor);
   gtk_entry_set_text(GTK_ENTRY(wid), buf);
   gtk_widget_set_usize(wid, 40, -1);
   gtk_signal_connect(GTK_OBJECT(wid), "activate",
		      GTK_SIGNAL_FUNC(callback), sess);
   gtk_box_pack_start(GTK_BOX(hbox), wid, 0, 0, 0);
   gtk_widget_show(wid);

   wid = gtk_button_new();
   *color_wid = wid;
   style = gtk_style_new();
   style->bg[0] = colors[initcolor];
   gtk_widget_set_style(wid, style);
   gtk_container_add(GTK_CONTAINER(hbox), wid);
   gtk_widget_show(wid);
}

void settings_create_tab(
			 GtkWidget *book,
			 char *title,
			 GtkWidget **font_normal_wid,
			 GtkWidget **font_bold_wid,
			 char *font_normal_str,
			 char *font_bold_str,

			 GtkWidget **bg_color_wid,
			 GtkWidget **fg_color_wid,
			 int bg_color,
			 int fg_color,
			 void *bg_color_callback,
			 void *fg_color_callback,

			 GdkFont *font_nn,
			 GdkFont *font_bb,

			 GtkWidget **backgroundwid,
			 char *background,

			 int transparent,
			 void *transparent_callback,

			 int tint,
			 void *tint_callback,

			 GtkWidget **transwid,
			 GtkWidget **tintwid,

			 int zvt,
			 void *zvt_callback,

			 struct session *sess
			 )
{
   GtkWidget *vvbox, *wid, *hbox;

   vvbox = gtk_vbox_new(0, 2);

   hbox = gtk_vbox_new(8, 8);
   gtk_container_add(GTK_CONTAINER(vvbox), hbox);
   gtk_widget_show(hbox);

   wid = gui_toggle("Use ZVT", hbox, zvt, zvt_callback, sess);
#ifdef USE_GNOME
   add_tip(wid, "Use GNOME's ZVT ANSI Emulation instead of GtkText");
#else
   gtk_widget_set_sensitive(wid, FALSE);
   gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(wid), FALSE);
#endif

   *transwid = gui_toggle("Transparent Background", hbox, transparent, transparent_callback, sess);
#ifndef USE_GNOME
   gtk_widget_set_sensitive(*transwid, FALSE);
#else
   if(!zvt) gtk_widget_set_sensitive(*transwid, FALSE);
#endif

   *tintwid = gui_toggle("Tint Transparency", hbox, tint, tint_callback, sess);
#ifndef USE_GNOME
   gtk_widget_set_sensitive(*tintwid, FALSE);
#else
   if(!transparent) gtk_widget_set_sensitive(*tintwid, FALSE);      
#endif

   settings_create_color_box(vvbox, "Background Color:", bg_color_wid,
			     bg_color, bg_color_callback, sess);
   settings_create_color_box(vvbox, "Text Color:", fg_color_wid,
			     fg_color, fg_color_callback, sess);

   gui_entry("Normal Font:", FONTNAMELEN, vvbox, font_normal_str, 0, font_normal_wid, settings_openfontdialog);
   gui_entry("Bold Font:", FONTNAMELEN, vvbox, font_bold_str, 0, font_bold_wid, settings_openfontdialog);
#ifdef USE_IMLIB
   gui_entry("Background Picture:", PATH_MAX, vvbox, background, 0, backgroundwid, settings_openfiledialog);
#else
   gui_entry("Background XPM:", PATH_MAX, vvbox, background, 0, backgroundwid, settings_openfiledialog);
#endif
#ifdef USE_GNOME
   if(zvt && transparent) gtk_widget_set_sensitive(*backgroundwid, FALSE);
#endif

   wid = gtk_label_new(title);
   gtk_widget_show(wid);
   gtk_notebook_append_page(GTK_NOTEBOOK(book), vvbox, wid);
   gtk_widget_show(vvbox); 
}

void gui_entry(char *label, int max, GtkWidget *box, char *def, char *suffix, GtkWidget **entry, void *suffixcallback)
{
   GtkWidget *wid, *hbox;

   hbox = gtk_hbox_new(0, 5);
   gtk_container_set_border_width(GTK_CONTAINER(hbox), 3);
   gtk_widget_show(hbox);

   wid = gtk_label_new(label);
   gtk_widget_set_usize(wid, 132, 0);
   gtk_misc_set_alignment(GTK_MISC(wid), 1, 0.5);
   gtk_box_pack_start(GTK_BOX(hbox), wid, 0, 0, 0);
   gtk_widget_show(wid);

   wid = gtk_entry_new_with_max_length(max);
   if(entry) *entry = wid;
   gtk_entry_set_text(GTK_ENTRY(wid), def);
   gtk_container_add(GTK_CONTAINER(hbox), wid);
   gtk_widget_show(wid);

   if(suffixcallback)
   {
      wid = gtk_button_new_with_label("...");
      gtk_signal_connect(GTK_OBJECT(wid), "clicked",
			 GTK_SIGNAL_FUNC(suffixcallback), *entry);
      gtk_box_pack_end(GTK_BOX(hbox), wid, 0, 0, 0);
      gtk_widget_show(wid);
   } else {
      if(suffix)
      {
	 wid = gtk_label_new(suffix);
	 gtk_widget_show(wid);
	 gtk_box_pack_end(GTK_BOX(hbox), wid, 0, 0, 0);
      }
   }
   gtk_box_pack_start(GTK_BOX(box), hbox, 0, 0, 0);
}

GtkWidget *gui_toggle(char *label, GtkWidget *box, int state, void *callback, struct session *sess)
{
   GtkWidget *wid;

   wid = gtk_check_button_new_with_label(label);
   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wid), state);
   gtk_signal_connect(GTK_OBJECT(wid), "toggled",
			GTK_SIGNAL_FUNC(callback), sess);
   gtk_box_pack_start(GTK_BOX(box), wid, 0, 0, 0);
   gtk_widget_show(wid);

   return wid;
}

void settings_opengui(struct session *sess)
{
   char buf[16];
   GtkWidget *book, *wid, *tog, *vbox, *vvbox, *hbox, *options_box, *frame;

   if(sess->setup)
   {
      gtk_widget_destroy(sess->setup->settings_window);
      return;
   }

   sess->setup = malloc(sizeof(struct setup));
   memcpy(&sess->setup->prefs, &prefs, sizeof(struct xchatprefs));

   sess->setup->settings_window = gtkutil_window_new("X-Chat: Settings", "settings", 474, 0,
						     settings_closegui, sess);
   gtk_container_set_border_width(GTK_CONTAINER(sess->setup->settings_window), 3);

   vbox = gtk_vbox_new(0, 2);
   gtk_container_add(GTK_CONTAINER(sess->setup->settings_window), vbox);
   gtk_widget_show(vbox);

   book = gtk_notebook_new();
   gtk_container_add(GTK_CONTAINER(vbox), book);
   gtk_widget_show(book);

   /* main tab */

   vvbox = gtk_vbox_new(0, 2);
   gtk_container_set_border_width(GTK_CONTAINER(vvbox), 3);

   gui_entry("Away Reason:", sizeof(prefs.awayreason) - 1, vvbox, prefs.awayreason, 0, &sess->setup->entry_away, 0);
   gui_entry("Quit Message:", sizeof(prefs.quitreason) - 1, vvbox, prefs.quitreason, 0, &sess->setup->entry_quit, 0);
   sprintf(buf, "%d", prefs.bufsize);
   gui_entry("Text Buffer Size:", sizeof(buf) - 1, vvbox, buf, "bytes. (0=Unlimited)", &sess->setup->entry_bufsize, 0);
   sprintf(buf, "%d", prefs.zvt_lines);
   gui_entry("ZVT Buffer Size:", sizeof(buf) - 1, vvbox, buf, "lines.", &sess->setup->entry_zvt_lines, 0);
   sprintf(buf, "%d", prefs.notify_timeout);
   gui_entry("Notify Check Interval:", sizeof(buf) - 1, vvbox, buf, "milliseconds. (15000=normal, 0=Disable)", &sess->setup->entry_timeout, 0);
   gui_entry("D-Click User Cmd:", sizeof(prefs.doubleclickuser) - 1, vvbox, prefs.doubleclickuser, 0, &sess->setup->entry_doubleclickuser, 0);
   gui_entry("Extra Blue Tab String", sizeof(prefs.bluestring) - 1, vvbox, prefs.bluestring, 0, &sess->setup->entry_bluestring, 0);

   settings_create_color_box(vvbox, "Notified User Color:",
		             &sess->setup->nu_color, prefs.nu_color,
		             nu_color_clicked, sess);
   settings_create_color_box(vvbox, "'Blue Tab' Nick Color:", /* Think up a
								 better name!
								 --AGL */
			     &sess->setup->bt_color, prefs.bt_color,
			     bt_color_clicked, sess);

   wid = gtk_label_new("Misc");
   gtk_widget_show(wid);   
   gtk_notebook_append_page(GTK_NOTEBOOK(book), vvbox, wid);

   gtk_widget_show(vvbox);

   /* end of main tab */

   settings_create_tab(book,
		       "Channel Windows",
		       &sess->setup->font_normal,
		       &sess->setup->font_bold,
		       prefs.font_normal,
		       prefs.font_bold,
		       &sess->setup->bg_color,
		       &sess->setup->fg_color,
		       prefs.bg_color,
		       prefs.fg_color,
		       bg_color_clicked,
		       fg_color_clicked,
		       font_normal,
		       font_bold,
		       &sess->setup->background,
		       prefs.background,
		       prefs.transparent,
		       settings_transparent,
		       prefs.tint,
		       settings_tint,
		       &sess->setup->check_transparent,
		       &sess->setup->check_tint,
		       prefs.zvt,
		       settings_zvt_check,
		       sess);

   settings_create_tab(book,
		       "Dialog Windows",
		       &sess->setup->dialog_font_normal,
		       &sess->setup->dialog_font_bold,
		       prefs.dialog_font_normal,
		       prefs.dialog_font_bold,
		       &sess->setup->dialog_bg_color,
		       &sess->setup->dialog_fg_color,
		       prefs.dialog_bg_color,
		       prefs.dialog_fg_color,
		       dialog_bg_color_clicked,
		       dialog_fg_color_clicked,
		       dialog_font_normal,
		       dialog_font_bold,
		       &sess->setup->background_dialog,
		       prefs.background_dialog,
		       prefs.dialog_transparent,
		       settings_transparent_dialog,
		       prefs.dialog_tint,
		       settings_tint_dialog,
		       &sess->setup->dialog_check_transparent,
		       &sess->setup->dialog_check_tint,
		       prefs.dialog_zvt,
		       settings_dialogzvt_check,
		       sess);
   
   hbox = gtk_hbox_new(0, 2);
   gtk_box_pack_end(GTK_BOX(vbox), hbox, 0, 0, 0);
   gtk_widget_show(hbox);

#ifdef USE_GNOME
   wid = gnome_stock_button(GNOME_STOCK_BUTTON_OK);
#else
   wid = gtk_button_new_with_label("Ok");
#endif
   gtk_signal_connect(GTK_OBJECT(wid), "clicked",
		      GTK_SIGNAL_FUNC(settings_ok_clicked), sess);
   gtk_container_add(GTK_CONTAINER(hbox), wid);
   gtk_widget_show(wid);

#ifdef USE_GNOME
   wid = gnome_stock_button(GNOME_STOCK_BUTTON_APPLY);
#else
   wid = gtk_button_new_with_label("Apply");
#endif
   gtk_signal_connect(GTK_OBJECT(wid), "clicked",
		      GTK_SIGNAL_FUNC(settings_apply_clicked), sess);
   gtk_container_add(GTK_CONTAINER(hbox), wid);
   gtk_widget_show(wid);

#ifdef USE_GNOME
   wid = gnome_stock_button(GNOME_STOCK_BUTTON_CANCEL);
#else
   wid = gtk_button_new_with_label("Cancel");
#endif
   gtk_signal_connect(GTK_OBJECT(wid), "clicked",
		      GTK_SIGNAL_FUNC(gtkutil_destroy), sess->setup->settings_window);
   gtk_container_add(GTK_CONTAINER(hbox), wid);
   gtk_widget_show(wid);
   sess->setup->cancel_button = wid;

   /* Options tab */

   options_box = gtk_hbox_new(0, 0);
   gtk_container_set_border_width(GTK_CONTAINER(options_box), 3);
   gtk_widget_show(options_box);

   wid = gtk_vbox_new(0, 0);
   gtk_container_add(GTK_CONTAINER(options_box), wid);
   gtk_widget_show(wid);
   gui_toggle("Colored Nicks", wid, prefs.colorednicks, settings_colored_check, sess);
   gui_toggle("Highlight Notifies", wid, prefs.hilitenotify, settings_hilitenotify_check, sess);
   tog = gui_toggle("Channel Mode Buttons", wid, !prefs.nochanmodebuttons, settings_chanbut_check, sess);
   add_tip(tog, "Show the TNSIPMLK buttons");
   gui_toggle("Userlist Buttons", wid, !prefs.nouserlistbuttons, settings_userlistbut_check, sess);
   gui_toggle("Nick Name Completion", wid, prefs.nickcompletion, settings_nickcompletion_check, sess);
   gui_toggle("Tab Nicks", wid, prefs.tabnicks, settings_tab_check, sess);
   gui_toggle("Time Stamp All Text", wid, prefs.timestamp, settings_timestamp_check, sess);
   gui_toggle("No Server List On Startup", wid, prefs.skipserverlist, settings_skipserverlist_check, sess);
   tog = gui_toggle("New Tabs to front", wid, prefs.newtabstofront, settings_newtabstofront_check, sess);
   add_tip(tog, "Bring new query/channel tabs to front");
   tog = gui_toggle("Get my IP from Server", wid, prefs.get_ip_from_server, settings_ip_check, sess);
   add_tip(tog, "For people behind firewall/proxy");
   gui_toggle("No ServerName in logs", wid, prefs.no_server_logs, settings_noserverlogs_check, sess);

   wid = gtk_vbox_new(0, 0);
   gtk_container_add(GTK_CONTAINER(options_box), wid);
   gtk_widget_show(wid);
   tog = gui_toggle("Channel Tabs", wid, prefs.tabchannels, settings_tabchannels_check, sess);
   add_tip(tog, "Use tabs instead of seperate windows");
   tog = gui_toggle("Private Message Tabs", wid, prefs.privmsgtab, settings_privmsgtab_check, sess);
   add_tip(tog, "Use tabs for /query instead of seperate windows");
   gui_toggle("Disable Paned Userlist", wid, prefs.nopaned, settings_nopaned_check, sess);
   gui_toggle("Strip MIRC Color", wid, prefs.stripcolor, settings_strip_check, sess);
   gui_toggle("Filter out BEEPs", wid, prefs.filterbeep, settings_beep_check, sess);
   gui_toggle("Tabs at bottom", wid, prefs.tabsatbottom, settings_tabsatbottom_check, sess);
   gui_toggle("Beep on Private Messages", wid, prefs.beepmsg, settings_beepmsg_check, sess);
   tog = gui_toggle("Logging", wid, prefs.logging, settings_logging_check, sess);
   add_tip(tog, "Enable logging conversations to disk");
   tog = gui_toggle("Hide Version", wid, prefs.hidever, settings_hidever, sess);
   add_tip(tog, "Do not reply to CTCP version");
   gui_toggle("Raw Mode Display", wid, prefs.raw_modes, settings_rawmodes_check, sess);
#ifdef USE_PANEL
   gui_toggle("Hide Session on Panelize", wid, prefs.panelize_hide, settings_panelize_hide_check, sess);
   gui_toggle("Layout For a Vertical Panel", wid, prefs.panel_vbox, settings_panel_vbox_check, sess);
#endif
   tog = gui_toggle("Show away once", wid, prefs.show_away_once, settings_showawayonce_check, sess);
   add_tip(tog, "Only show away messages the first time they're seen" );
   wid = gtk_label_new("Options");
   gtk_widget_show(wid);
   gtk_notebook_append_page(GTK_NOTEBOOK(book), options_box, wid);

   /* end of Options tab */

   /* Dcc TAB */

   vbox = gtk_vbox_new(0, 2);
   gtk_container_set_border_width(GTK_CONTAINER(vbox), 3);
   gtk_widget_show(vbox);

   gui_toggle("Auto Open DCC Send Window", vbox, !prefs.noautoopendccsendwindow, settings_sendwin_check, sess);
   gui_toggle("Auto Open DCC Recv Window", vbox, !prefs.noautoopendccrecvwindow, settings_recvwin_check, sess);
   tog = gui_toggle("Fast DCC Send", vbox, prefs.fastdccsend, settings_fastdccsend_check, sess);
   add_tip(tog, "Don't wait for ACKs to send more data");
   tog = gui_toggle("Save DCC with Nickname", vbox, prefs.dccwithnick, settings_dccwithnick_check, sess);
   add_tip(tog, "Put the sender\'s nickname in incoming filenames");
   sprintf(buf, "%d", prefs.dcctimeout);
   gui_entry("DCC Offers Timeout:", sizeof(buf) - 1, vbox, buf, "(seconds)", &sess->setup->entry_dcctimeout, 0);
   sprintf(buf, "%d", prefs.dccstalltimeout);
   gui_entry("DCC Stall Timeout:", sizeof(buf) - 1, vbox, buf, "(seconds)", &sess->setup->entry_dccstalltimeout, 0);   
   sprintf(buf, "%04o", prefs.dccpermissions);
   gui_entry("DCC Permissions:", 5, vbox, buf, "(octal)", &sess->setup->entry_permissions, 0);
   add_tip(sess->setup->entry_permissions, "Permissions to set for receiving files");
   gui_entry("DCC Receive dir:", PATH_MAX, vbox, prefs.dccdir, 0, &sess->setup->entry_dccdir, 0);

   wid = gtk_label_new("DCC");
   gtk_widget_show(wid);
   gtk_notebook_append_page(GTK_NOTEBOOK(book), vbox, wid);

   /* end of Dcc TAB */

   /* Sound TAB */

   vbox = gtk_vbox_new(0, 2);
   gtk_container_set_border_width(GTK_CONTAINER(vbox), 3);
   gtk_widget_show(vbox);

   gui_entry("CTCP Sound Dir:", PATH_MAX, vbox, prefs.sounddir, 0, &sess->setup->entry_sounddir, 0);
   gui_entry("CTCP Play Command:", PATH_MAX, vbox, prefs.soundcmd, 0, &sess->setup->entry_soundcmd, 0);

   wid = gtk_label_new("Sound");
   gtk_widget_show(wid);
   gtk_notebook_append_page(GTK_NOTEBOOK(book), vbox, wid);

   /* end of sound TAB */

   /* window size TAB */

   frame = gtk_frame_new("Initial Main Window");
   gtk_widget_show(frame);

   vbox = gtk_vbox_new(0, 2);
   gtk_container_set_border_width(GTK_CONTAINER(vbox), 3);
   gtk_container_add(GTK_CONTAINER(frame), vbox);
   gtk_widget_show(vbox);

   sprintf(buf, "%d", prefs.mainwindow_left);
   gui_entry("Left:", sizeof(buf) - 1, vbox, buf, 0, &sess->setup->entry_mainw_left, 0);
   sprintf(buf, "%d", prefs.mainwindow_top);
   gui_entry("Top:", sizeof(buf) - 1, vbox, buf, 0, &sess->setup->entry_mainw_top, 0);
   sprintf(buf, "%d", prefs.mainwindow_width);
   gui_entry("Width:", sizeof(buf) - 1, vbox, buf, 0, &sess->setup->entry_mainw_width, 0);
   sprintf(buf, "%d", prefs.mainwindow_height);
   gui_entry("Height:", sizeof(buf) - 1, vbox, buf, 0, &sess->setup->entry_mainw_height, 0);

   gtkutil_label_new("If Left and Top are set to zero, it will use"
		     " window manager defaults.", vbox);

   wid = gtk_label_new("Window Size");
   gtk_widget_show(wid);
   gtk_notebook_append_page(GTK_NOTEBOOK(book), frame, wid);

   /* end of window size TAB */

   gtk_widget_show(sess->setup->settings_window);
}
