// Thread.cpp
#define ACE_BUILD_DLL
#include "ace/Thread.h"

#if !defined (__ACE_INLINE__)
#include "ace/Thread.i"
#endif /* !defined (__ACE_INLINE__) */

int
ACE_Thread::spawn_n (size_t n, 
		     ACE_THR_FUNC func, 
		     void *arg, 
		     long flags, 
		     u_int priority,
		     void *stack[], 
		     size_t stack_size[])
{
  ACE_TRACE ("ACE_Thread::spawn_n");
  ACE_thread_t t_id;
  size_t i;

  for (i = 0; i < n; i++)
    // Bail out if error occurs.
    if (ACE_OS::thr_create (func, arg, flags, &t_id, 0, priority,
			    stack == 0 ? 0 : stack[i], 
			    stack_size == 0 ? 0 : stack_size[i]) != 0)
      break;

  return i;
}

int
ACE_Thread::spawn_n (ACE_thread_t thread_ids[],
		     size_t n, 
		     ACE_THR_FUNC func, 
		     void *arg, 
		     long flags, 
		     u_int priority,
		     void **stack,
		     size_t stack_size[])
{
  ACE_TRACE ("ACE_Thread::spawn_n");
  size_t i;

  for (i = 0; i < n; i++)
    {
      ACE_thread_t t_id;

      int result = ACE_OS::thr_create 
        (func, arg, flags, &t_id, 0, priority,
         stack == 0 ? 0 : stack[i], 
         stack_size == 0 ? 0 : stack_size[i]);

      if (result == 0)
	thread_ids[i] = t_id;
      else
        // Bail out if error occurs.
        break;
    }

  return i;
}

