// The following is another test that exercises the Eric C. Newton's
// <ecn@clark.net> XtReactor implementation.

#include "ace/Log_Msg.h"
#include "ace/XtReactor.h"
#include "ace/Message_Block.h"

#if defined (ACE_HAS_XT)
#include <Xm/PushB.h>

class Stdout : public ACE_Event_Handler
{
public:
  Stdout (ACE_Reactor * r)
    : reactor_ (r), msg_ (1000000) 
  {
    int flags;
    flags = ACE_OS::fcntl (ACE_STDOUT, F_GETFL);

    if (flags != -1
	&& ACE_OS::fcntl (ACE_STDOUT, F_SETFL, flags | O_NONBLOCK) != -1)
      return;
    else
      ACE_DEBUG ((LM_DEBUG, "Unable to set stdout to non-block."));
  }

  ACE_HANDLE get_handle (void) const { return ACE_STDOUT; }

  int handle_output (ACE_HANDLE)
  {
    char *s = msg_.rd_ptr ();

    if (ACE_OS::write (ACE_STDOUT, s, 1)==1)
      {
	ACE_DEBUG ((LM_DEBUG, "wrote output '%d'\n", (int) *s));
	msg_.rd_ptr (1);
      }

    if (msg_.length () == 0)
      {
	reactor_->remove_handler (this, ACE_Event_Handler::WRITE_MASK);
	msg_.rd_ptr (msg_.base ());
	msg_.wr_ptr (msg_.base ());
      }
    return 0;
  }

  void put (char c) 
  {
    if (msg_.length () == 0)
      reactor_->register_handler (this, ACE_Event_Handler::WRITE_MASK);

    if (msg_.wr_ptr () < msg_.end ())
      {
	*msg_.wr_ptr () = c; 
	msg_.wr_ptr (1);
      }
    else
      ACE_DEBUG ((LM_DEBUG, "Oops... data falling off the end of the buffer!\n"));
  }

private:
  ACE_Reactor *reactor_;
  ACE_Message_Block msg_;
};

class Stdin : public ACE_Event_Handler
{
public:
  Stdin (Stdout *out) 
    : out_ (out) {}

  ACE_HANDLE get_handle () const { return ACE_STDIN; }

  int handle_input (ACE_HANDLE)
  {
    char c;

    if (ACE_OS::read (ACE_STDIN, &c, 1) == 1)
      out_->put (c);

    return 0;
  }

  int handle_timeout (const ACE_Time_Value &tv, const void *)
  {
    ACE_DEBUG ((LM_DEBUG, "Timeout! %f\n", (double) (tv.msec ()/1000.)));
    return 0;
  }

private:
  Stdout *out_;
};

static void 
ActivateCB (Widget, XtPointer, XtPointer)
{
  ACE_DEBUG ((LM_DEBUG, "Button pushed!\n"));
}

int 
main (int argc, char**argv)
{
  // The worlds most useless user interface
  Widget top_level = XtVaAppInitialize (NULL, "buttontest", NULL, 0,
					&argc, argv, NULL, NULL);
  Widget button = XmCreatePushButton (top_level, "change", 0, 0);
  XtManageChild (button);
  XtAddCallback (button, XmNactivateCallback, ActivateCB, NULL);

  // A reactor beastie
  ACE_XtReactor reactor (XtWidgetToApplicationContext (top_level));

  // Print a message when data is recv'd on stdin...
  ACE_Event_Handler *stdin_ = new Stdin (new Stdout (&reactor));
  reactor.register_handler (stdin_, ACE_Event_Handler::READ_MASK);

  // Print a message every 10 seconds.
  reactor.schedule_timer (stdin_, 0, ACE_Time_Value (10), ACE_Time_Value (10));

  // Show the top_level widget.
  XtRealizeWidget (top_level);

  // Demonstrate Reactor/Xt event loop unification.
  XtAppMainLoop (XtWidgetToApplicationContext (top_level));

  return 0;
}
#else
int 
main (int, char *[])
{
  ACE_ERROR ((LM_ERROR, "XT not configured for this platform\n"));
  return 0;
}
#endif /* ACE_HAS_XT */
